/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3dbi.ctr
*/

/*
Copyright (C) 2011-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file */

#ifndef DK3DBI_H_INCLUDED
/** Avoid multiple inclusions. */
#define DK3DBI_H_INCLUDED 1


#line 10 "dk3dbi.ctr"

#ifdef __cplusplus
extern "C" {
#endif

/**	Check whether a database type is supported.
	@param	tp	Database type, see @ref databasetypes.
	@return	1 on success (type supported), 0 on error (not supported).
*/
int
dk3dbi_type_supported(int tp);

/**	Open a database.
	@param	fn	Database file name.
	@param	tp	Database type, see @ref databasetypes.
	@param	acc	Access type, see @ref databaseaccess.
	@param	pec	Pointer to error code variable, may be NULL.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	Pointer to opened database on success, NULL on error.
*/
dk3_dbi_t *
dk3dbi_open_app(dkChar const *fn, int tp, int acc, int *pec, dk3_app_t *app);

/**	Open a database.
	@param	fn	Database file name.
	@param	tp	Database type, see @ref databasetypes.
	@param	acc	Access type, see @ref databaseaccess.
	@param	pec	Pointer to error code variable, may be NULL.
	@return	Pointer to opened database on success, NULL on error.
*/
dk3_dbi_t *
dk3dbi_open(dkChar const *fn, int tp, int acc, int *pec);

/**	Open a database, discard all existing contents.
	@param	fn	Database file name.
	@param	tp	Database type, see @ref databasetypes.
	@param	acc	Access type, see @ref databaseaccess.
	@param	pec	Pointer to error code variable, may be NULL.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	Pointer to opened database on success, NULL on error.
*/
dk3_dbi_t *
dk3dbi_open_truncate_app(
  dkChar const *fn,
  int tp,
  int acc,
  int *pec,
  dk3_app_t *app
);

/**	Open a database, discard all existing contents.
	@param	fn	Database file name.
	@param	tp	Database type, see @ref databasetypes.
	@param	acc	Access type, see @ref databaseaccess.
	@param	pec	Pointer to error code variable, may be NULL.
	@return	Pointer to opened database on success, NULL on error.
*/
dk3_dbi_t *
dk3dbi_open_truncate(dkChar const *fn, int tp, int acc, int *pec);

/**	Set an entry in the database.
	@param	dbp	Database.
	@param	key	Key data.
	@param	val	Value data.
	@return	1 on success, 0 on error.
*/
int
dk3dbi_set(dk3_dbi_t *dbp, dk3_datum_t *key, dk3_datum_t *val);

/**	Get an entry from the database.
	@param	dbp	Database.
	@param	key	Key data.
	@param	val	Value data, set up for a result buffer.
	On input it contains the buffer size, on successful
	return it contains the number of bytes.
	@return	1 on success, 0 on error.
*/
int
dk3dbi_get(dk3_dbi_t *dbp, dk3_datum_t *key, dk3_datum_t *val);

/**	Delete an entry from the database.
	@param	dbp	Database.
	@param	key	Key data.
	@return	1 on success, 0 on error.
*/
int
dk3dbi_delete(dk3_dbi_t *dbp, dk3_datum_t *key);

/**	Save 8-bit character string to database.
	@param	dbp	Database.
	@param	key	Key string.
	@param	val	Value string.
	@return	1 on success, 0 on error.
*/
int
dk3dbi_set_c8_string(
  dk3_dbi_t	*dbp,
  char const	*key,
  char const	*val
);

/**	Retrieve 8-bit character string from database.
	@param	dbp	Database.
	@param	key	Key string.
	@param	vb	Value buffer.
	@param	vbsz	Value buffer size in bytes.
	@return	1 on success, 0 on error.
*/
int
dk3dbi_get_c8_string(
  dk3_dbi_t	*dbp,
  char const	*key,
  char		*vb,
  size_t	 vbsz
);

/**	Delete 8-bit character string from database.
	@param	dbp	Database.
	@param	key	Key string.
	@return	1 on success, 0 on error.
*/
int
dk3dbi_delete_c8_string(
  dk3_dbi_t	*dbp,
  char const	*key
);

/**	Save 16-bit character string to database.
	@param	dbp	Database.
	@param	key	Key string.
	@param	val	Value string.
	@return	1 on success, 0 on error.
*/
int
dk3dbi_set_c16_string(
  dk3_dbi_t		*dbp,
  dk3_c16_t const	*key,
  dk3_c16_t const	*val
);

/**	Retrieve 16-bit character string from database.
	@param	dbp	Database.
	@param	key	Key string.
	@param	vb	Value buffer.
	@param	vbsz	Value buffer size (number of 16-bit characters).
	@return	1 on success, 0 on error.
*/
int
dk3dbi_get_c16_string(
  dk3_dbi_t		*dbp,
  dk3_c16_t const	*key,
  dk3_c16_t		*vb,
  size_t		 vbsz
);

/**	Delete 16-bit character string from database.
	@param	dbp	Database.
	@param	key	Key string.
	@return	1 on success, 0 on error.
*/
int
dk3dbi_delete_c16_string(
  dk3_dbi_t		*dbp,
  dk3_c16_t const	*key
);

/**	Save 32-bit character string to database.
	@param	dbp	Database.
	@param	key	Key string.
	@param	val	Value string.
	@return	1 on success, 0 on error.
*/
int
dk3dbi_set_c32_string(
  dk3_dbi_t		*dbp,
  dk3_c32_t const	*key,
  dk3_c32_t const	*val
);

/**	Retrieve 32-bit character string from database.
	@param	dbp	Database.
	@param	key	Key string.
	@param	vb	Value buffer.
	@param	vbsz	Value buffer size (number of 32-bit characters).
	@return	1 on success, 0 on error.
*/
int
dk3dbi_get_c32_string(
  dk3_dbi_t		*dbp,
  dk3_c32_t const	*key,
  dk3_c32_t		*vb,
  size_t		 vbsz
);

/**	Delete 32-bit character string from database.
	@param	dbp	Database.
	@param	key	Key string.
	@return	1 on success, 0 on error.
*/
int
dk3dbi_delete_c32_string(
  dk3_dbi_t		*dbp,
  dk3_c32_t const	*key
);

/**	Save a dkChar string to the database.
	@param	dbp	Database.
	@param	key	Key string.
	@param	val	Value string.
	@return	1 on success, 0 on error.
*/
int
dk3dbi_set_string(
  dk3_dbi_t	*dbp,
  dkChar const	*key,
  dkChar const	*val
);

/**	Retrieve dkChar string from the database.
	@param	dbp	Database.
	@param	key	Key string.
	@param	vb	Value buffer.
	@param	vbsz	Size of value buffer (Number of dkChar).
	@return	1 on success, 0 on error.
*/
int
dk3dbi_get_string(
  dk3_dbi_t	*dbp,
  dkChar const	*key,
  dkChar	*vb,
  size_t	 vbsz
);

/**	Delete dkChar string from database.
	@param	dbp	Database.
	@param	key	Key string.
	@return	1 on success, 0 on error.
*/
int
dk3dbi_delete_string(
  dk3_dbi_t	*dbp,
  dkChar const	*key
);

/**	Synchronize to disk.
	@param	dbp	Database.
	@return	1 on success, 0 on error.
*/
int
dk3dbi_sync(dk3_dbi_t *dbp);

/**	Traverse database.
	@param	dbp	Database.
	@param	obj	Object to modify while traversing the database.
	@param	fct	Callback function to use for each key/value pair.
	@return	1 on success, 0 on error.
*/
int
dk3dbi_traverse(dk3_dbi_t *dbp, void *obj, dk3_db_traverse_fct_t *fct);

/**	Get last error code occured.
	@param	dbp	Database.
	@param	res	Flag: Reset error code.
	@return	Error code for last error.
*/
int
dk3dbi_get_error(dk3_dbi_t *dbp, int res);

/**	Close database.
	@param	dbp	Database to close.
	@return	1 on success (sync ok), 0 on error.
*/
int
dk3dbi_close(dk3_dbi_t *dbp);

/**	Delete database file(s).
	@param	fn	Database file name.
	@param	tp	Database type.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3dbi_dbfile_delete_app(dkChar const *fn, int tp, dk3_app_t *app);

/**	Truncate database (remove all contents).
	@param	fn	Database file name.
	@param	tp	Database type.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3dbi_dbfile_truncate_app(dkChar const *fn, int tp, dk3_app_t *app);

/**	Delete database file(s).
	@param	fn	Database file name.
	@param	tp	Database type.
	@return	1 on success, 0 on error.
*/
int
dk3dbi_dbfile_delete(dkChar const *fn, int tp);

/**	Truncate database (remove all contents).
	@param	fn	Database file name.
	@param	tp	Database type.
	@return	1 on success, 0 on error.
*/
int
dk3dbi_dbfile_truncate(dkChar const *fn, int tp);

/**	Split a given name into database type and real file name.
	The given name may be either a file name with tp set to a
	database type or
	"mem::file", "bdb::file", or "ndbm::file" to specify a file name
	and database type with tp set to DK3_DB_TYPE_UNKNOWN.
	@param	myfn	Pointer to a pointer to receive real file name.
	@param	mytp	Pointer to type output variable.
	@param	fn	File name or type::filename.
	@param	tp	Type as specified.
	@param	pec	Pointer to error code variable.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3dbi_find_type_and_name(
  dkChar const	**myfn,
  int		 *mytp,
  dkChar const	 *fn,
  int		  tp,
  int		 *pec,
  dk3_app_t	 *app
);


#if !DK3_ON_WINDOWS
#if DK3_CHAR_SIZE == 1
#if DK3_HAVE_CHOWN && DK3_HAVE_CHMOD
/**	Change user name and permissions for a database.
	This function is intended for daemons on *x systems where the daemon
	is started by user root but gives up privileges before starting
	processing.
	@param	db	Database to change.
	@param	uid	New user ID.
	@param	gid	New group ID.
	@param	mode	Unix/Linux permissions.
	@return	1 on success, 0 on error.
*/
int
dk3dbi_change_user_and_permissions(
  dk3_dbi_t		*db,
  uid_t			 uid,
  gid_t			 gid,
  mode_t		 mode
);
#endif
#endif
#endif

#ifdef __cplusplus
}
#endif


#endif
