/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3cores.ctr
*/

/**	@file */

#ifndef DK3CORES_H_INCLUDED
/** Avoid multiple inclusions. */
#define DK3CORES_H_INCLUDED 1


#line 4 "dk3cores.ctr"

/**	@defgroup	coressrc	Source for cores information
*/
/**@{*/

/**	No information found.
*/
#define	DK3_CORES_SRC_NONE		(-1)

/**	System call succeeded.
*/
#define	DK3_CORES_SRC_SYSTEM		0

/**	Environment variable NUMBER_OF_PROCESSORS on Windows.
*/
#define	DK3_CORES_SRC_ENVIRONMENT	1

/**	File /proc/cpuinfo on *x systems.
*/
#define	DK3_CORES_SRC_CPUINFO		2

/**	The /threads/max preference.
*/
#define	DK3_CORES_SRC_PREFERENCE	3

/**@}*/

#ifdef __cplusplus
extern "C" {
#endif

/**	Retrieve number of processor cores on system.
	@param	src	Pointer to information source indicator variable,
			may be NULL.
	@return	Number of processor cores found.
*/
size_t
dk3cores_get_num(int *src);

/**	Check whether we run on WOW6432.
	@return	1 for WOW6432, 0 otherwise.
*/
int
dk3cores_is_wow64(void);

/**	Get maximum number of threads.
	The number is retrieved from the /threads/max preference if
	available, or derived from the number of cores available
	(back = (n > 2) ? (n - 1) : 1) to leave one core for
	@param	app	Application to use for preferences retrieval.
	@param	src	Pointer to information source indicator variable,
			may be NULL.
	@return	Number of threas to use maximally.
*/
size_t
dk3cores_max_threads(dk3_app_t *app, int *src);

#ifdef __cplusplus
}
#endif


#endif
