
/**	@file	dk3confd.h	Configuration defaults.
 * 	This file contains default settings for systems where the
 * 	configure script cannot be run.
 */

#ifndef DK3_CONFD_H_INCLUDED
#define DK3_CONFD_H_INCLUDED 1

#ifndef DK3_ON_WINDOWS
#if defined(WIN32) || defined(_WIN32) || defined(WIN64) || defined(_WIN64)
/** On a Windows system. */
#define DK3_ON_WINDOWS	1
#else
/** Not on a Windows system. */
#define DK3_ON_WINDOWS	0
#endif
#endif
/** ifndef DK3_ON_WINDOWS */

#if DK3_ON_WINDOWS
/* +++ Windows */

/* ##### TODO: Create setup entries. */

/* --- Windows */
#else
/* if DK3_ON_WINDOWS */
/* +++ non-Windows */

#define HAVE_WINSOCK2_H		0
#define HAVE_WINDOWS_H		0
#define HAVE_WINBASE_H		0
#define HAVE_WINREG_H		0
#define HAVE_WINCON_H		0
#define HAVE_STDIO_H 1
#define HAVE_SYS_TYPES_H 1
#define HAVE_SYS_STAT_H 1
#define HAVE_STDLIB_H 1
#define HAVE_STDDEF_H 1
#define HAVE_UNISTD_H 1
#define HAVE_PROCESS_H		0
#define HAVE_LIMITS_H 1
#define HAVE_SYS_PARAM_H 1
#define HAVE_SYS_WAIT_H 1
#define HAVE_SYS_STATVFS_H 1
#define HAVE_SYS_STROPTS_H	0
#define HAVE_SYS_FILE_H 1
#define HAVE_SYS_UIO_H 1
#define HAVE_SYS_UN_H 1
#define HAVE_SYS_SUNDDI_H	0
#define HAVE_SYS_RESOURCE_H 1
#define HAVE_SYS_SYSTEMINFO_H	0
#define HAVE_SYS_SOCKET_H 1
#define TIME_WITH_SYS_TIME 1
#define HAVE_SYS_TIME_H 1
#define HAVE_TIME_H 1
#define HAVE_ERRNO_H 1
#define HAVE_ALLOC_H		0
#define HAVE_MALLOC_H 1
#define HAVE_CTYPE_H 1
#define HAVE_STRING_H 1
#define HAVE_STRINGS_H 1
#define HAVE_STROPTS_H		0
#define HAVE_IO_H		0
#define HAVE_DOS_H		0
#define HAVE_FCNTL_H 1
#define HAVE_DIR_H		0
#define HAVE_DIREENT_H		0
#define HAVE_DIRECT_H		0
#define HAVE_SYSRES_H		0
#define HAVE_NETINET_IN_H 1
#define HAVE_ARPA_INET_H 1
#define HAVE_NETDB_H 1
#define HAVE_GRP_H 1
#define HAVE_PWD_H 1
#define HAVE_MATH_H 1
#define HAVE_SIGNAL_H 1
#define HAVE_SYSLOG_H 1
#define HAVE_CONIO_H		0
#define HAVE_WCHAR_H 1
#define HAVE_STDARG_H 1
#define HAVE_VARARG_H		0
#define HAVE_VARARGS_H		0
#define HAVE_TERMIOS_H 1
#define HAVE_SHADOW_H 1
#define HAVE_SYS_TERMIOS_H 1
#define HAVE_SYS_TTOLD_H	0
#define HAVE_SETJMP_H 1
#define HAVE_OPENSSL_RAND_H 1
#define HAVE_OPENSSL_MD5_H 1
#define HAVE_OPENSSL_SHA_H 1
#define HAVE_OPENSSL_RIPEMD_H 1
#define HAVE_PNG_H 1
#define HAVE_PNM_H		0
#define HAVE_JPEGLIB_H 1
#define HAVE_TIFF_H 1
#define HAVE_NDBM_H		0
#define HAVE_DB_H 1
#define	WORDS_BIGENDIAN		0
#define SIZEOF_SHORT 2
#define SIZEOF_INT 4
#define SIZEOF_LONG 4
#define SIZEOF_SIZE_T 4
#define HAVE_LONG_LONG 1
#define SIZEOF_LONG_LONG 8
#define HAVE_WCHAR_T 1
#define SIZEOF_WCHAR_T 4
#define HAVE_LARGEFILE64_SOURCE 1
#define HAVE_CONST 1
#define HAVE_VOLATILE 1
#define HAVE_BACKSLASH		0
#define	HAVE_FNCASEINS		0
#define HAVE_MALLOC 1
#define HAVE_FREE 1
#define HAVE_STRLEN 1
#define HAVE_WCSLEN		0
#define HAVE__WCSLEN		0
#define HAVE_STRCMP 1
#define HAVE_WCSCMP		0
#define HAVE__WCSCMP		0
#define HAVE_STRNCMP 1
#define HAVE_WCSNCMP		0
#define HAVE__WCSNCMP		0
#define HAVE_STRICMP		0
#define HAVE_STRCASECMP 1
#define HAVE_WCSICMP		0
#define HAVE__WCSICMP		0
#define HAVE_STRCPY 1
#define HAVE_WCSCPY		0
#define HAVE__WCSCPY		0
#define HAVE_STRNCPY 1
#define HAVE_WCSNCPY		0
#define HAVE__WCSNCPY		0
#define HAVE_STRCAT 1
#define HAVE_WCSCAT		0
#define HAVE__WCSCAT		0
#define HAVE_STRCHR 1
#define HAVE_WCSCHR		0
#define HAVE__WCSCHR		0
#define HAVE_STRRCHR 1
#define HAVE_WCSRCHR		0
#define HAVE__WCSRCHR		0
#define HAVE_STRDUP 1
#define HAVE_WCSDUP		0
#define HAVE__WCSDUP		0
#define HAVE_RINT 1
#define HAVE_FLOOR 1
#define HAVE_CEIL 1
#define HAVE_FABS 1
#define HAVE_LABS 1
#define HAVE_TIME 1
#define HAVE_LOCALTIME 1
#define HAVE_FOPEN 1
#define	HAVE__FOPEN		0
#define HAVE_FCLOSE 1
#define	HAVE__FCLOSE		0
#define HAVE_FEOF 1
#define	HAVE__FEOF		0
#define HAVE_FFLUSH 1
#define	HAVE__FFLUSH		0
#define HAVE_FREAD 1
#define	HAVE__FREAD		0
#define HAVE_FWRITE 1
#define	HAVE__FWRITE		0
#define HAVE__WGETENV		0
#define HAVE_GETPWNAM 1
#define HAVE_GETPWUID 1
#define HAVE_GETPWENT 1
#define HAVE_SETPWENT 1
#define HAVE_ENDPWENT 1
#define HAVE_GETUID 1
#define HAVE_STAT64 1
#define	HAVE__STAT64		0
#define HAVE_LSTAT64 1
#define	HAVE__LSTAT64		0
#define	HAVE_STAT32		0
#define	HAVE__STAT32		0
#define	HAVE_LSTAT32		0
#define	HAVE__LSTAT32		0
#define HAVE_STAT 1
#define	HAVE__STAT		0
#define HAVE_LSTAT 1
#define	HAVE__LSTAT		0
#define HAVE_GETHOSTNAME 1

/* --- non-Windows */
#endif
/* if DK3_ON_WINDOWS */


#endif
/* ifndef DK3_CONFD_H_INCLUDED */

