/**	@file dk3conf.h	Configuration for DK3 libraries.
	Features: Include files, functions, sizes,
	and endianness.
*/

#ifndef DK3_CONF_H_INCLUDED
/** Avoid multiple inclusions. */
#define DK3_CONF_H_INCLUDED 1

#ifndef DK3_ON_WINDOWS
#if defined(WIN32) || defined(_WIN32) || defined(WIN64) || defined(_WIN64)
/** On a Windows system. */
#define DK3_ON_WINDOWS	1
#else
/** Not on a Windows system. */
#define DK3_ON_WINDOWS	0
#endif
#endif
/** ifndef DK3_ON_WINDOWS */

#if DK3_ON_WINDOWS

#ifndef DK3_HAVE_ACOSH
/**	DK3 version of HAVE_ACOSH.
*/
#define DK3_HAVE_ACOSH 0
#endif

#ifndef DK3_HAVE_ACOSHL
/**	DK3 version of HAVE_ACOSHL.
*/
#define DK3_HAVE_ACOSHL 1
#endif

#ifndef DK3_HAVE_ACOSL
/**	DK3 version of HAVE_ACOSL.
*/
#define DK3_HAVE_ACOSL 1
#endif

#ifndef DK3_HAVE_ALLOC_H
/**	DK3 version of HAVE_ALLOC_H.
*/
#define DK3_HAVE_ALLOC_H 0
#endif

#ifndef DK3_HAVE_ARPA_INET_H
/**	DK3 version of HAVE_ARPA_INET_H.
*/
#define DK3_HAVE_ARPA_INET_H 0
#endif

#ifndef DK3_HAVE_ASINH
/**	DK3 version of HAVE_ASINH.
*/
#define DK3_HAVE_ASINH 0
#endif

#ifndef DK3_HAVE_ASINHL
/**	DK3 version of HAVE_ASINHL.
*/
#define DK3_HAVE_ASINHL 1
#endif

#ifndef DK3_HAVE_ASINL
/**	DK3 version of HAVE_ASINL.
*/
#define DK3_HAVE_ASINL 1
#endif

#ifndef DK3_HAVE_ATAN2
/**	DK3 version of HAVE_ATAN2.
*/
#define DK3_HAVE_ATAN2 1
#endif

#ifndef DK3_HAVE_ATAN2L
/**	DK3 version of HAVE_ATAN2L.
*/
#define DK3_HAVE_ATAN2L 1
#endif

#ifndef DK3_HAVE_ATANH
/**	DK3 version of HAVE_ATANH.
*/
#define DK3_HAVE_ATANH 0
#endif

#ifndef DK3_HAVE_ATANHL
/**	DK3 version of HAVE_ATANHL.
*/
#define DK3_HAVE_ATANHL 1
#endif

#ifndef DK3_HAVE_ATANL
/**	DK3 version of HAVE_ATANL.
*/
#define DK3_HAVE_ATANL 1
#endif

#ifndef DK3_HAVE_BACKSLASH
/**	DK3 version of HAVE_BACKSLASH.
*/
#define DK3_HAVE_BACKSLASH 1
#endif

#ifndef DK3_HAVE_BCMP
/**	DK3 version of HAVE_BCMP.
*/
#define DK3_HAVE_BCMP 0
#endif

#ifndef DK3_HAVE_BCOPY
/**	DK3 version of HAVE_BCOPY.
*/
#define DK3_HAVE_BCOPY 0
#endif

#ifndef DK3_HAVE_BZERO
/**	DK3 version of HAVE_BZERO.
*/
#define DK3_HAVE_BZERO 0
#endif

#ifndef DK3_HAVE_CEIL
/**	DK3 version of HAVE_CEIL.
*/
#define DK3_HAVE_CEIL 1
#endif

#ifndef DK3_HAVE_CEILL
/**	DK3 version of HAVE_CEILL.
*/
#define DK3_HAVE_CEILL 1
#endif

#ifndef DK3_HAVE_CHDIR
/**	DK3 version of HAVE_CHDIR.
*/
#define DK3_HAVE_CHDIR 1
#endif

#ifndef DK3_HAVE_CHMOD
/**	DK3 version of HAVE_CHMOD.
*/
#define DK3_HAVE_CHMOD 0
#endif

#ifndef DK3_HAVE_CHOWN
/**	DK3 version of HAVE_CHOWN.
*/
#define DK3_HAVE_CHOWN 0
#endif

#ifndef DK3_HAVE_CLOSEDIR
/**	DK3 version of HAVE_CLOSEDIR.
*/
#define DK3_HAVE_CLOSEDIR 0
#endif

#ifndef DK3_HAVE_CONIO_H
/**	DK3 version of HAVE_CONIO_H.
*/
#define DK3_HAVE_CONIO_H 1
#endif

#ifndef DK3_HAVE_CONST
/**	DK3 version of HAVE_CONST.
*/
#define DK3_HAVE_CONST 1
#endif

#ifndef DK3_HAVE_COSHL
/**	DK3 version of HAVE_COSHL.
*/
#define DK3_HAVE_COSHL 1
#endif

#ifndef DK3_HAVE_COSL
/**	DK3 version of HAVE_COSL.
*/
#define DK3_HAVE_COSL 1
#endif

#ifndef DK3_HAVE_CTYPE_H
/**	DK3 version of HAVE_CTYPE_H.
*/
#define DK3_HAVE_CTYPE_H 1
#endif

#ifndef DK3_HAVE_DEV_RANDOM
/**	DK3 version of HAVE_DEV_RANDOM.
*/
#define DK3_HAVE_DEV_RANDOM 0
#endif

#ifndef DK3_HAVE_DEV_URANDOM
/**	DK3 version of HAVE_DEV_URANDOM.
*/
#define DK3_HAVE_DEV_URANDOM 0
#endif

#ifndef DK3_HAVE_DIRECT_H
/**	DK3 version of HAVE_DIRECT_H.
*/
#define DK3_HAVE_DIRECT_H 1
#endif

#ifndef DK3_HAVE_DIRENT_H
/**	DK3 version of HAVE_DIRENT_H.
*/
#define DK3_HAVE_DIRENT_H 0
#endif

#ifndef DK3_HAVE_DIR_H
/**	DK3 version of HAVE_DIR_H.
*/
#define DK3_HAVE_DIR_H 0
#endif

#ifndef DK3_HAVE_DOS_H
/**	DK3 version of HAVE_DOS_H.
*/
#define DK3_HAVE_DOS_H 1
#endif

#ifndef DK3_HAVE_ENDGRENT
/**	DK3 version of HAVE_ENDGRENT.
*/
#define DK3_HAVE_ENDGRENT 0
#endif

#ifndef DK3_HAVE_ENDPWENT
/**	DK3 version of HAVE_ENDPWENT.
*/
#define DK3_HAVE_ENDPWENT 0
#endif

#ifndef DK3_HAVE_ERRNO_H
/**	DK3 version of HAVE_ERRNO_H.
*/
#define DK3_HAVE_ERRNO_H 1
#endif

#ifndef DK3_HAVE_ERR_H
/**	DK3 version of HAVE_ERR_H.
*/
#define DK3_HAVE_ERR_H 0
#endif

#ifndef DK3_HAVE_EXPL
/**	DK3 version of HAVE_EXPL.
*/
#define DK3_HAVE_EXPL 1
#endif

#ifndef DK3_HAVE_FABS
/**	DK3 version of HAVE_FABS.
*/
#define DK3_HAVE_FABS 1
#endif

#ifndef DK3_HAVE_FABSL
/**	DK3 version of HAVE_FABSL.
*/
#define DK3_HAVE_FABSL 1
#endif

#ifndef DK3_HAVE_FCLOSE
/**	DK3 version of HAVE_FCLOSE.
*/
#define DK3_HAVE_FCLOSE 1
#endif

#ifndef DK3_HAVE_FCNTL_H
/**	DK3 version of HAVE_FCNTL_H.
*/
#define DK3_HAVE_FCNTL_H 1
#endif

#ifndef DK3_HAVE_FENV_H
/**	DK3 version of HAVE_FENV_H.
*/
#define DK3_HAVE_FENV_H 0
#endif

#ifndef DK3_HAVE_FEOF
/**	DK3 version of HAVE_FEOF.
*/
#define DK3_HAVE_FEOF 1
#endif

#ifndef DK3_HAVE_FERROR
/**	DK3 version of HAVE_FERROR.
*/
#define DK3_HAVE_FERROR 1
#endif

#ifndef DK3_HAVE_FETESTEXCEPT
/**	DK3 version of HAVE_FETESTEXCEPT.
*/
#define DK3_HAVE_FETESTEXCEPT 0
#endif

#ifndef DK3_HAVE_FFLUSH
/**	DK3 version of HAVE_FFLUSH.
*/
#define DK3_HAVE_FFLUSH 1
#endif

#ifndef DK3_HAVE_FLOAT_H
/**	DK3 version of HAVE_FLOAT_H.
*/
#define DK3_HAVE_FLOAT_H 1
#endif

#ifndef DK3_HAVE_FLOOR
/**	DK3 version of HAVE_FLOOR.
*/
#define DK3_HAVE_FLOOR 1
#endif

#ifndef DK3_HAVE_FLOORL
/**	DK3 version of HAVE_FLOORL.
*/
#define DK3_HAVE_FLOORL 1
#endif

#ifndef DK3_HAVE_FNCASEINS
/**	DK3 version of HAVE_FNCASEINS.
*/
#define DK3_HAVE_FNCASEINS 1
#endif

#ifndef DK3_HAVE_FOPEN
/**	DK3 version of HAVE_FOPEN.
*/
#define DK3_HAVE_FOPEN 1
#endif

#ifndef DK3_HAVE_FOPEN64
/**	DK3 version of HAVE_FOPEN64.
*/
#define DK3_HAVE_FOPEN64 0
#endif

#ifndef DK3_HAVE_FORK
/**	DK3 version of HAVE_FORK.
*/
#define DK3_HAVE_FORK 0
#endif

#ifndef DK3_HAVE_FPCLASSIFY
/**	DK3 version of HAVE_FPCLASSIFY.
*/
#define DK3_HAVE_FPCLASSIFY 0
#endif

#ifndef DK3_HAVE_FREAD
/**	DK3 version of HAVE_FREAD.
*/
#define DK3_HAVE_FREAD 0
#endif

#ifndef DK3_HAVE_FREE
/**	DK3 version of HAVE_FREE.
*/
#define DK3_HAVE_FREE 1
#endif

#ifndef DK3_HAVE_FWRITE
/**	DK3 version of HAVE_FWRITE.
*/
#define DK3_HAVE_FWRITE 0
#endif

#ifndef DK3_HAVE_GDBM_H
/**	DK3 version of HAVE_GDBM_H.
*/
#define DK3_HAVE_GDBM_H 0
#endif

#ifndef DK3_HAVE_GETADDRINFO
/**	DK3 version of HAVE_GETADDRINFO.
*/
#define DK3_HAVE_GETADDRINFO 1
#endif

#ifndef DK3_HAVE_GETCWD
/**	DK3 version of HAVE_GETCWD.
*/
#define DK3_HAVE_GETCWD 1
#endif

#ifndef DK3_HAVE_GETENV
/**	DK3 version of HAVE_GETENV.
*/
#define DK3_HAVE_GETENV 1
#endif

#ifndef DK3_HAVE_GETEUID
/**	DK3 version of HAVE_GETEUID.
*/
#define DK3_HAVE_GETEUID 0
#endif

#ifndef DK3_HAVE_GETGRENT
/**	DK3 version of HAVE_GETGRENT.
*/
#define DK3_HAVE_GETGRENT 0
#endif

#ifndef DK3_HAVE_GETGRGID
/**	DK3 version of HAVE_GETGRGID.
*/
#define DK3_HAVE_GETGRGID 0
#endif

#ifndef DK3_HAVE_GETGRNAM
/**	DK3 version of HAVE_GETGRNAM.
*/
#define DK3_HAVE_GETGRNAM 0
#endif

#ifndef DK3_HAVE_GETHOSTBYNAME
/**	DK3 version of HAVE_GETHOSTBYNAME.
*/
#define DK3_HAVE_GETHOSTBYNAME 1
#endif

#ifndef DK3_HAVE_GETHOSTNAME
/**	DK3 version of HAVE_GETHOSTNAME.
*/
#define DK3_HAVE_GETHOSTNAME 0
#endif

#ifndef DK3_HAVE_GETPEERNAME
/**	DK3 version of HAVE_GETPEERNAME.
*/
#define DK3_HAVE_GETPEERNAME 1
#endif

#ifndef DK3_HAVE_GETPID
/**	DK3 version of HAVE_GETPID.
*/
#define DK3_HAVE_GETPID 1
#endif

#ifndef DK3_HAVE_GETPWENT
/**	DK3 version of HAVE_GETPWENT.
*/
#define DK3_HAVE_GETPWENT 0
#endif

#ifndef DK3_HAVE_GETPWNAM
/**	DK3 version of HAVE_GETPWNAM.
*/
#define DK3_HAVE_GETPWNAM 0
#endif

#ifndef DK3_HAVE_GETPWUID
/**	DK3 version of HAVE_GETPWUID.
*/
#define DK3_HAVE_GETPWUID 0
#endif

#ifndef DK3_HAVE_GETRLIMIT
/**	DK3 version of HAVE_GETRLIMIT.
*/
#define DK3_HAVE_GETRLIMIT 0
#endif

#ifndef DK3_HAVE_GETSOCKNAME
/**	DK3 version of HAVE_GETSOCKNAME.
*/
#define DK3_HAVE_GETSOCKNAME 1
#endif

#ifndef DK3_HAVE_GETUID
/**	DK3 version of HAVE_GETUID.
*/
#define DK3_HAVE_GETUID 0
#endif

#ifndef DK3_HAVE_GRP_H
/**	DK3 version of HAVE_GRP_H.
*/
#define DK3_HAVE_GRP_H 0
#endif

#ifndef DK3_HAVE_HTONL
/**	DK3 version of HAVE_HTONL.
*/
#define DK3_HAVE_HTONL 1
#endif

#ifndef DK3_HAVE_IEEE_754_DOUBLE
/**	DK3 version of HAVE_IEEE_754_DOUBLE.
*/
#define DK3_HAVE_IEEE_754_DOUBLE 1
#endif

#ifndef DK3_HAVE_IN6_ADDR
/**	DK3 version of HAVE_IN6_ADDR.
*/
#define DK3_HAVE_IN6_ADDR 1
#endif

#ifndef DK3_HAVE_INET_ADDR
/**	DK3 version of HAVE_INET_ADDR.
*/
#define DK3_HAVE_INET_ADDR 0
#endif

#ifndef DK3_HAVE_INET_ATON
/**	DK3 version of HAVE_INET_ATON.
*/
#define DK3_HAVE_INET_ATON 0
#endif

#ifndef DK3_HAVE_INET_PTON
/**	DK3 version of HAVE_INET_PTON.
*/
#define DK3_HAVE_INET_PTON 0
#endif

#ifndef DK3_HAVE_INITSTATE
/**	DK3 version of HAVE_INITSTATE.
*/
#define DK3_HAVE_INITSTATE 0
#endif

#ifndef DK3_HAVE_INODES
/**	DK3 version of HAVE_INODES.
*/
#define DK3_HAVE_INODES 0
#endif

#ifndef DK3_HAVE_INTMAX_T
#if _MSC_VER >= 1700
/**	DK3 version of HAVE_INTMAX_T.
*/
#define DK3_HAVE_INTMAX_T 1
#else
/**	DK3 version of HAVE_INTMAX_T.
*/
#define DK3_HAVE_INTMAX_T 0
#endif
#endif

#ifndef DK3_HAVE_INTTYPES_H
/**	DK3 version of HAVE_INTTYPES_H.
*/
#define DK3_HAVE_INTTYPES_H 0
#endif

#ifndef DK3_HAVE_IN_ADDR
/**	DK3 version of HAVE_IN_ADDR.
*/
#define DK3_HAVE_IN_ADDR 1
#endif

#ifndef DK3_HAVE_IO_H
/**	DK3 version of HAVE_IO_H.
*/
#define DK3_HAVE_IO_H 1
#endif

#ifndef DK3_HAVE_ISATTY
/**	DK3 version of HAVE_ISATTY.
*/
#define DK3_HAVE_ISATTY 1
#endif

#ifndef DK3_HAVE_ISFINITE
/**	DK3 version of HAVE_ISFINITE.
*/
#define DK3_HAVE_ISFINITE 0
#endif

#ifndef DK3_HAVE_ISNORMAL
/**	DK3 version of HAVE_ISNORMAL.
*/
#define DK3_HAVE_ISNORMAL 0
#endif

#ifndef DK3_HAVE_LABS
/**	DK3 version of HAVE_LABS.
*/
#define DK3_HAVE_LABS 1
#endif

#ifndef DK3_HAVE_LARGEFILE64_SOURCE
/**	DK3 version of HAVE_LARGEFILE64_SOURCE.
*/
#define DK3_HAVE_LARGEFILE64_SOURCE 0
#endif

#ifndef DK3_HAVE_LIMITS_H
/**	DK3 version of HAVE_LIMITS_H.
*/
#define DK3_HAVE_LIMITS_H 1
#endif

#ifndef DK3_HAVE_LOCALE_H
/**	DK3 version of HAVE_LOCALE_H.
*/
#define DK3_HAVE_LOCALE_H 1
#endif

#ifndef DK3_HAVE_LOCALTIME
/**	DK3 version of HAVE_LOCALTIME.
*/
#define DK3_HAVE_LOCALTIME 1
#endif

#ifndef DK3_HAVE_LOCALTIME
/**	DK3 version of HAVE_LOCALTIME.
*/
#define DK3_HAVE_LOCALTIME 1
#endif

#ifndef DK3_HAVE_LOCALTIME_R
/**	DK3 version of HAVE_LOCALTIME_R.
*/
#define DK3_HAVE_LOCALTIME_R 0
#endif

#ifndef DK3_HAVE_LOGL
/**	DK3 version of HAVE_LOGL.
*/
#define DK3_HAVE_LOGL 1
#endif

#ifndef DK3_HAVE_LONG_DOUBLE
/**	DK3 version of HAVE_LONG_DOUBLE.
*/
#define DK3_HAVE_LONG_DOUBLE 1
#endif

#ifndef DK3_HAVE_LONG_LONG
/**	DK3 version of HAVE_LONG_LONG.
*/
#define DK3_HAVE_LONG_LONG 1
#endif

#ifndef DK3_HAVE_LRAND48
/**	DK3 version of HAVE_LRAND48.
*/
#define DK3_HAVE_LRAND48 0
#endif

#ifndef DK3_HAVE_LSTAT
/**	DK3 version of HAVE_LSTAT.
*/
#define DK3_HAVE_LSTAT 1
#endif

#ifndef DK3_HAVE_LSTAT32
/**	DK3 version of HAVE_LSTAT32.
*/
#define DK3_HAVE_LSTAT32 1
#endif

#ifndef DK3_HAVE_LSTAT64
/**	DK3 version of HAVE_LSTAT64.
*/
#define DK3_HAVE_LSTAT64 1
#endif

#ifndef DK3_HAVE_MALLOC
/**	DK3 version of HAVE_MALLOC.
*/
#define DK3_HAVE_MALLOC 1
#endif

#ifndef DK3_HAVE_MALLOC_H
/**	DK3 version of HAVE_MALLOC_H.
*/
#define DK3_HAVE_MALLOC_H 1
#endif

#ifndef DK3_HAVE_MATH_H
/**	DK3 version of HAVE_MATH_H.
*/
#define DK3_HAVE_MATH_H 1
#endif

#ifndef DK3_HAVE_MEMCMP
/**	DK3 version of HAVE_MEMCMP.
*/
#define DK3_HAVE_MEMCMP 1
#endif

#ifndef DK3_HAVE_MEMCPY
/**	DK3 version of HAVE_MEMCPY.
*/
#define DK3_HAVE_MEMCPY 1
#endif

#ifndef DK3_HAVE_MEMSET
/**	DK3 version of HAVE_MEMSET.
*/
#define DK3_HAVE_MEMSET 1
#endif

#ifndef DK3_HAVE_MKDIR
/**	DK3 version of HAVE_MKDIR.
*/
#define DK3_HAVE_MKDIR 0
#endif

#ifndef DK3_HAVE_MKDIR2
/**	DK3 version of HAVE_MKDIR2.
*/
#define DK3_HAVE_MKDIR2 0
#endif

#ifndef DK3_HAVE_MPCTL
/**	DK3 version of HAVE_MPCTL.
*/
#define DK3_HAVE_MPCTL 0
#endif

#ifndef DK3_HAVE_NDBM_H
/**	DK3 version of HAVE_NDBM_H.
*/
#define DK3_HAVE_NDBM_H 0
#endif

#ifndef DK3_HAVE_NETDB_H
/**	DK3 version of HAVE_NETDB_H.
*/
#define DK3_HAVE_NETDB_H 0
#endif

#ifndef DK3_HAVE_NETINET_IN_H
/**	DK3 version of HAVE_NETINET_IN_H.
*/
#define DK3_HAVE_NETINET_IN_H 0
#endif

#ifndef DK3_HAVE_NRAND48
/**	DK3 version of HAVE_NRAND48.
*/
#define DK3_HAVE_NRAND48 0
#endif

#ifndef DK3_HAVE_OPENDIR
/**	DK3 version of HAVE_OPENDIR.
*/
#define DK3_HAVE_OPENDIR 0
#endif

#ifndef DK3_HAVE_PNG_GET_PIXELS_PER_INCH
/**	DK3 version of HAVE_PNG_GET_PIXELS_PER_INCH.
*/
#define DK3_HAVE_PNG_GET_PIXELS_PER_INCH 1
#endif

#ifndef DK3_HAVE_POPEN
/**	DK3 version of HAVE_POPEN.
*/
#define DK3_HAVE_POPEN 0
#endif

#ifndef DK3_HAVE_PROCESS_H
/**	DK3 version of HAVE_PROCESS_H.
*/
#define DK3_HAVE_PROCESS_H 1
#endif

#ifndef DK3_HAVE_PTHREAD_H
/**	DK3 version of HAVE_PTHREAD_H.
*/
#define DK3_HAVE_PTHREAD_H 0
#endif

#ifndef DK3_HAVE_PWD_H
/**	DK3 version of HAVE_PWD_H.
*/
#define DK3_HAVE_PWD_H 0
#endif

#ifndef DK3_HAVE_RAND
/**	DK3 version of HAVE_RAND.
*/
#define DK3_HAVE_RAND 0
#endif

#ifndef DK3_HAVE_RANDOM
/**	DK3 version of HAVE_RANDOM.
*/
#define DK3_HAVE_RANDOM 0
#endif

#ifndef DK3_HAVE_READ
/**	DK3 version of HAVE_READ.
*/
#define DK3_HAVE_READ 1
#endif

#ifndef DK3_HAVE_READDIR
/**	DK3 version of HAVE_READDIR.
*/
#define DK3_HAVE_READDIR 0
#endif

#ifndef DK3_HAVE_RFC_2249
/**	DK3 version of HAVE_RFC_2249.
*/
#define DK3_HAVE_RFC_2249 0
#endif

#ifndef DK3_HAVE_RINT
/**	DK3 version of HAVE_RINT.
*/
#define DK3_HAVE_RINT 0
#endif

#ifndef DK3_HAVE_RINTL
/**	DK3 version of HAVE_RINTL.
*/
#define DK3_HAVE_RINTL 1
#endif

#ifndef DK3_HAVE_RMDIR
/**	DK3 version of HAVE_RMDIR.
*/
#define DK3_HAVE_RMDIR 0
#endif

#ifndef DK3_HAVE_SEED48
/**	DK3 version of HAVE_SEED48.
*/
#define DK3_HAVE_SEED48 0
#endif

#ifndef DK3_HAVE_SELECT
/**	DK3 version of HAVE_SELECT.
*/
#define DK3_HAVE_SELECT 1
#endif

#ifndef DK3_HAVE_SETGID
/**	DK3 version of HAVE_SETGID.
*/
#define DK3_HAVE_SETGID 0
#endif

#ifndef DK3_HAVE_SETGRENT
/**	DK3 version of HAVE_SETGRENT.
*/
#define DK3_HAVE_SETGRENT 0
#endif

#ifndef DK3_HAVE_SETJMP_H
/**	DK3 version of HAVE_SETJMP_H.
*/
#define DK3_HAVE_SETJMP_H 1
#endif

#ifndef DK3_HAVE_SETPGRP
/**	DK3 version of HAVE_SETPGRP.
*/
#define DK3_HAVE_SETPGRP 0
#endif

#ifndef DK3_HAVE_SETPWENT
/**	DK3 version of HAVE_SETPWENT.
*/
#define DK3_HAVE_SETPWENT 0
#endif

#ifndef DK3_HAVE_SETSID
/**	DK3 version of HAVE_SETSID.
*/
#define DK3_HAVE_SETSID 0
#endif

#ifndef DK3_HAVE_SETSOCKOPT
/**	DK3 version of HAVE_SETSOCKOPT.
*/
#define DK3_HAVE_SETSOCKOPT 1
#endif

#ifndef DK3_HAVE_SETSTATE
/**	DK3 version of HAVE_SETSTATE.
*/
#define DK3_HAVE_SETSTATE 0
#endif

#ifndef DK3_HAVE_SETUID
/**	DK3 version of HAVE_SETUID.
*/
#define DK3_HAVE_SETUID 0
#endif

#ifndef DK3_HAVE_SHADOW_H
/**	DK3 version of HAVE_SHADOW_H.
*/
#define DK3_HAVE_SHADOW_H 0
#endif

#ifndef DK3_HAVE_SIGACTION
/**	DK3 version of HAVE_SIGACTION.
*/
#define DK3_HAVE_SIGACTION 0
#endif

#ifndef DK3_HAVE_SIGNAL
/**	DK3 version of HAVE_SIGNAL.
*/
#define DK3_HAVE_SIGNAL 1
#endif

#ifndef DK3_HAVE_SIGNAL_H
/**	DK3 version of HAVE_SIGNAL_H.
*/
#define DK3_HAVE_SIGNAL_H 1
#endif

#ifndef DK3_HAVE_SIGSET
/**	DK3 version of HAVE_SIGSET.
*/
#define DK3_HAVE_SIGSET 0
#endif

#ifndef DK3_HAVE_SIG_ATOMIC_T
/**	DK3 version of HAVE_SIG_ATOMIC_T.
*/
#define DK3_HAVE_SIG_ATOMIC_T 0
#endif

#ifndef DK3_HAVE_SINHL
/**	DK3 version of HAVE_SINHL.
*/
#define DK3_HAVE_SINHL 1
#endif

#ifndef DK3_HAVE_SINL
/**	DK3 version of HAVE_SINL.
*/
#define DK3_HAVE_SINL 1
#endif

#ifndef DK3_HAVE_SNPRINTF
/**	DK3 version of HAVE_SNPRINTF.
*/
#define DK3_HAVE_SNPRINTF 0
#endif

#ifndef DK3_HAVE_SOCKET
/**	DK3 version of HAVE_SOCKET.
*/
#define DK3_HAVE_SOCKET 1
#endif

#ifndef DK3_HAVE_SOCKLEN_T
/**	DK3 version of HAVE_SOCKLEN_T.
*/
#define DK3_HAVE_SOCKLEN_T 0
#endif

#ifndef DK3_HAVE_SQRTL
/**	DK3 version of HAVE_SQRTL.
*/
#define DK3_HAVE_SQRTL 1
#endif

#ifndef DK3_HAVE_SRAND
/**	DK3 version of HAVE_SRAND.
*/
#define DK3_HAVE_SRAND 0
#endif

#ifndef DK3_HAVE_SSIZE_T
/**	DK3 version of HAVE_SSIZE_T.
*/
#define DK3_HAVE_SSIZE_T 0
#endif

#ifndef DK3_HAVE_STAT
/**	DK3 version of HAVE_STAT.
*/
#define DK3_HAVE_STAT 1
#endif

#ifndef DK3_HAVE_STAT32
/**	DK3 version of HAVE_STAT32.
*/
#define DK3_HAVE_STAT32 1
#endif

#ifndef DK3_HAVE_STAT64
/**	DK3 version of HAVE_STAT64.
*/
#define DK3_HAVE_STAT64 1
#endif

#ifndef DK3_HAVE_STDARG_H
/**	DK3 version of HAVE_STDARG_H.
*/
#define DK3_HAVE_STDARG_H 1
#endif

#ifndef DK3_HAVE_STDDEF_H
/**	DK3 version of HAVE_STDDEF_H.
*/
#define DK3_HAVE_STDDEF_H 1
#endif

#ifndef DK3_HAVE_STDINT_H
#if _MSC_VER >= 1700
/**	DK3 version of HAVE_STDINT_H.
*/
#define DK3_HAVE_STDINT_H 1
#else
/**	DK3 version of HAVE_STDINT_H.
*/
#define DK3_HAVE_STDINT_H 0
#endif
#endif

#ifndef DK3_HAVE_STDIO_H
/**	DK3 version of HAVE_STDIO_H.
*/
#define DK3_HAVE_STDIO_H 1
#endif

#ifndef DK3_HAVE_STDLIB_H
/**	DK3 version of HAVE_STDLIB_H.
*/
#define DK3_HAVE_STDLIB_H 1
#endif

#ifndef DK3_HAVE_STRCASECMP
/**	DK3 version of HAVE_STRCASECMP.
*/
#define DK3_HAVE_STRCASECMP 0
#endif

#ifndef DK3_HAVE_STRCAT
/**	DK3 version of HAVE_STRCAT.
*/
#define DK3_HAVE_STRCAT 1
#endif

#ifndef DK3_HAVE_STRCHR
/**	DK3 version of HAVE_STRCHR.
*/
#define DK3_HAVE_STRCHR 1
#endif

#ifndef DK3_HAVE_STRCMP
/**	DK3 version of HAVE_STRCMP.
*/
#define DK3_HAVE_STRCMP 1
#endif

#ifndef DK3_HAVE_STRCPY
/**	DK3 version of HAVE_STRCPY.
*/
#define DK3_HAVE_STRCPY 1
#endif

#ifndef DK3_HAVE_STRDUP
/**	DK3 version of HAVE_STRDUP.
*/
#define DK3_HAVE_STRDUP 0
#endif

#ifndef DK3_HAVE_STRERROR
/**	DK3 version of HAVE_STRERROR.
*/
#define DK3_HAVE_STRERROR 1
#endif

#ifndef DK3_HAVE_STRICMP
/**	DK3 version of HAVE_STRICMP.
*/
#define DK3_HAVE_STRICMP 0
#endif

#ifndef DK3_HAVE_STRINGS_H
/**	DK3 version of HAVE_STRINGS_H.
*/
#define DK3_HAVE_STRINGS_H 0
#endif

#ifndef DK3_HAVE_STRING_H
/**	DK3 version of HAVE_STRING_H.
*/
#define DK3_HAVE_STRING_H 1
#endif

#ifndef DK3_HAVE_STRLEN
/**	DK3 version of HAVE_STRLEN.
*/
#define DK3_HAVE_STRLEN 1
#endif

#ifndef DK3_HAVE_STRNCMP
/**	DK3 version of HAVE_STRNCMP.
*/
#define DK3_HAVE_STRNCMP 1
#endif

#ifndef DK3_HAVE_STRNCPY
/**	DK3 version of HAVE_STRNCPY.
*/
#define DK3_HAVE_STRNCPY 1
#endif

#ifndef DK3_HAVE_STROPTS_H
/**	DK3 version of HAVE_STROPTS_H.
*/
#define DK3_HAVE_STROPTS_H 0
#endif

#ifndef DK3_HAVE_STRRCHR
/**	DK3 version of HAVE_STRRCHR.
*/
#define DK3_HAVE_STRRCHR 1
#endif

#ifndef DK3_HAVE_STRTOD
/**	DK3 version of HAVE_STRTOD.
*/
#define DK3_HAVE_STRTOD 1
#endif

#ifndef DK3_HAVE_STRTOIMAX
#if _MSC_VER >= 1700
/**	DK3 version of HAVE_STRTOIMAX.
*/
#define DK3_HAVE_STRTOIMAX 1
#else
/**	DK3 version of HAVE_STRTOIMAX.
*/
#define DK3_HAVE_STRTOIMAX 0
#endif
#endif

#ifndef DK3_HAVE_STRTOL
#if _MSC_VER >= 1700
/**	DK3 version of HAVE_STRTOL.
*/
#define DK3_HAVE_STRTOL 1
#else
/**	DK3 version of HAVE_STRTOL.
*/
#define DK3_HAVE_STRTOL 0
#endif
#endif

#ifndef DK3_HAVE_STRTOLL
#if _MSC_VER >= 1700
/**	DK3 version of HAVE_STRTOLL.
*/
#define DK3_HAVE_STRTOLL 1
#else
/**	DK3 version of HAVE_STRTOLL.
*/
#define DK3_HAVE_STRTOLL 0
#endif
#endif

#ifndef DK3_HAVE_STRTOUL
#if _MSC_VER >= 1700
/**	DK3 version of HAVE_STRTOUL.
*/
#define DK3_HAVE_STRTOUL 1
#else
/**	DK3 version of HAVE_STRTOUL.
*/
#define DK3_HAVE_STRTOUL 0
#endif
#endif

#ifndef DK3_HAVE_STRTOULL
#if _MSC_VER >= 1700
/**	DK3 version of HAVE_STRTOULL.
*/
#define DK3_HAVE_STRTOULL 1
#else
/**	DK3 version of HAVE_STRTOULL.
*/
#define DK3_HAVE_STRTOULL 0
#endif
#endif

#ifndef DK3_HAVE_STRTOUMAX
#if _MSC_VER >= 1700
/**	DK3 version of HAVE_STRTOUMAX.
*/
#define DK3_HAVE_STRTOUMAX 1
#else
/**	DK3 version of HAVE_STRTOUMAX.
*/
#define DK3_HAVE_STRTOUMAX 0
#endif
#endif

#ifndef DK3_HAVE_STRUCT_ADDRINFO
/**	DK3 version of HAVE_STRUCT_ADDRINFO.
*/
#define DK3_HAVE_STRUCT_ADDRINFO 0
#endif

#ifndef DK3_HAVE_STRUCT_SOCKADDR_IN
/**	DK3 version of HAVE_STRUCT_SOCKADDR_IN.
*/
#define DK3_HAVE_STRUCT_SOCKADDR_IN 1
#endif

#ifndef DK3_HAVE_STRUCT_SOCKADDR_IN6
/**	DK3 version of HAVE_STRUCT_SOCKADDR_IN6.
*/
#define DK3_HAVE_STRUCT_SOCKADDR_IN6 1
#endif

#ifndef DK3_HAVE_STRUCT_SOCKADDR_STORAGE
/**	DK3 version of HAVE_STRUCT_SOCKADDR_STORAGE.
*/
#define DK3_HAVE_STRUCT_SOCKADDR_STORAGE 0
#endif

#ifndef DK3_HAVE_STRUCT_SOCKADDR_UN
/**	DK3 version of HAVE_STRUCT_SOCKADDR_UN.
*/
#define DK3_HAVE_STRUCT_SOCKADDR_UN 0
#endif

#ifndef DK3_HAVE_SYSCONF
/**	DK3 version of HAVE_SYSCONF.
*/
#define DK3_HAVE_SYSCONF 0
#endif

#ifndef DK3_HAVE_SYSCTL
/**	DK3 version of HAVE_SYSCTL.
*/
#define DK3_HAVE_SYSCTL 0
#endif

#ifndef DK3_HAVE_SYSLOG
/**	DK3 version of HAVE_SYSLOG.
*/
#define DK3_HAVE_SYSLOG 0
#endif

#ifndef DK3_HAVE_SYSLOG_H
/**	DK3 version of HAVE_SYSLOG_H.
*/
#define DK3_HAVE_SYSLOG_H 0
#endif

#ifndef DK3_HAVE_SYSRES_H
/**	DK3 version of HAVE_SYSRES_H.
*/
#define DK3_HAVE_SYSRES_H 0
#endif

#ifndef DK3_HAVE_SYS_FILE_H
/**	DK3 version of HAVE_SYS_FILE_H.
*/
#define DK3_HAVE_SYS_FILE_H 0
#endif

#ifndef DK3_HAVE_SYS_PARAM_H
/**	DK3 version of HAVE_SYS_PARAM_H.
*/
#define DK3_HAVE_SYS_PARAM_H 0
#endif

#ifndef DK3_HAVE_SYS_RESOURCE_H
/**	DK3 version of HAVE_SYS_RESOURCE_H.
*/
#define DK3_HAVE_SYS_RESOURCE_H 0
#endif

#ifndef DK3_HAVE_SYS_SOCKET_H
/**	DK3 version of HAVE_SYS_SOCKET_H.
*/
#define DK3_HAVE_SYS_SOCKET_H 0
#endif

#ifndef DK3_HAVE_SYS_STATVFS_H
/**	DK3 version of HAVE_SYS_STATVFS_H.
*/
#define DK3_HAVE_SYS_STATVFS_H 0
#endif

#ifndef DK3_HAVE_SYS_STAT_H
/**	DK3 version of HAVE_SYS_STAT_H.
*/
#define DK3_HAVE_SYS_STAT_H 1
#endif

#ifndef DK3_HAVE_SYS_STROPTS_H
/**	DK3 version of HAVE_SYS_STROPTS_H.
*/
#define DK3_HAVE_SYS_STROPTS_H 0
#endif

#ifndef DK3_HAVE_SYS_SUNDDI_H
/**	DK3 version of HAVE_SYS_SUNDDI_H.
*/
#define DK3_HAVE_SYS_SUNDDI_H 0
#endif

#ifndef DK3_HAVE_SYS_SYSCTL_H
/**	DK3 version of HAVE_SYS_SYSCTL_H.
*/
#define DK3_HAVE_SYS_SYSCTL_H 0
#endif

#ifndef DK3_HAVE_SYS_SYSTEMINFO_H
/**	DK3 version of HAVE_SYS_SYSTEMINFO_H.
*/
#define DK3_HAVE_SYS_SYSTEMINFO_H 0
#endif

#ifndef DK3_HAVE_SYS_TERMIOS_H
/**	DK3 version of HAVE_SYS_TERMIOS_H.
*/
#define DK3_HAVE_SYS_TERMIOS_H 0
#endif

#ifndef DK3_HAVE_SYS_TIME_H
/**	DK3 version of HAVE_SYS_TIME_H.
*/
#define DK3_HAVE_SYS_TIME_H 0
#endif

#ifndef DK3_HAVE_SYS_TTOLD_H
/**	DK3 version of HAVE_SYS_TTOLD_H.
*/
#define DK3_HAVE_SYS_TTOLD_H 0
#endif

#ifndef DK3_HAVE_SYS_TYPES_H
/**	DK3 version of HAVE_SYS_TYPES_H.
*/
#define DK3_HAVE_SYS_TYPES_H 1
#endif

#ifndef DK3_HAVE_SYS_UIO_H
/**	DK3 version of HAVE_SYS_UIO_H.
*/
#define DK3_HAVE_SYS_UIO_H 0
#endif

#ifndef DK3_HAVE_SYS_UN_H
/**	DK3 version of HAVE_SYS_UN_H.
*/
#define DK3_HAVE_SYS_UN_H 0
#endif

#ifndef DK3_HAVE_SYS_WAIT_H
/**	DK3 version of HAVE_SYS_WAIT_H.
*/
#define DK3_HAVE_SYS_WAIT_H 0
#endif

#ifndef DK3_HAVE_TANHL
/**	DK3 version of HAVE_TANHL.
*/
#define DK3_HAVE_TANHL 1
#endif

#ifndef DK3_HAVE_TANL
/**	DK3 version of HAVE_TANL.
*/
#define DK3_HAVE_TANL 1
#endif

#ifndef DK3_HAVE_TCFLUSH
/**	DK3 version of HAVE_TCFLUSH.
*/
#define DK3_HAVE_TCFLUSH 0
#endif

#ifndef DK3_HAVE_TCGETATTR
/**	DK3 version of HAVE_TCGETATTR.
*/
#define DK3_HAVE_TCGETATTR 0
#endif

#ifndef DK3_HAVE_TERMIOS_H
/**	DK3 version of HAVE_TERMIOS_H.
*/
#define DK3_HAVE_TERMIOS_H 0
#endif

#ifndef DK3_HAVE_TIME
/**	DK3 version of HAVE_TIME.
*/
#define DK3_HAVE_TIME 1
#endif

#ifndef DK3_HAVE_TIME_H
/**	DK3 version of HAVE_TIME_H.
*/
#define DK3_HAVE_TIME_H 1
#endif

#ifndef DK3_HAVE_TWOS_COMPLEMENT
/**	DK3 version of HAVE_TWOS_COMPLEMENT.
*/
#define DK3_HAVE_TWOS_COMPLEMENT 1
#endif

#ifndef DK3_HAVE_UMASK
/**	DK3 version of HAVE_UMASK.
*/
#define DK3_HAVE_UMASK 0
#endif

#ifndef DK3_HAVE_UNISTD_H
/**	DK3 version of HAVE_UNISTD_H.
*/
#define DK3_HAVE_UNISTD_H 0
#endif

#ifndef DK3_HAVE_UNLINK
/**	DK3 version of HAVE_UNLINK.
*/
#define DK3_HAVE_UNLINK 0
#endif

#ifndef DK3_HAVE_USER_NAMES_CASE_INSENSITIVE
/**	DK3 version of HAVE_USER_NAMES_CASE_INSENSITIVE.
*/
#define DK3_HAVE_USER_NAMES_CASE_INSENSITIVE 1
#endif

#ifndef DK3_HAVE_VARARGS_H
/**	DK3 version of HAVE_VARARGS_H.
*/
#define DK3_HAVE_VARARGS_H 0
#endif

#ifndef DK3_HAVE_VARARG_H
/**	DK3 version of HAVE_VARARG_H.
*/
#define DK3_HAVE_VARARG_H 0
#endif

#ifndef DK3_HAVE_VOLATILE
/**	DK3 version of HAVE_VOLATILE.
*/
#define DK3_HAVE_VOLATILE 1
#endif

#ifndef DK3_HAVE_WCHAR_H
/**	DK3 version of HAVE_WCHAR_H.
*/
#define DK3_HAVE_WCHAR_H 1
#endif

#ifndef DK3_HAVE_WCHAR_T
/**	DK3 version of HAVE_WCHAR_T.
*/
#define DK3_HAVE_WCHAR_T 1
#endif

#ifndef DK3_HAVE_WCSCAT
/**	DK3 version of HAVE_WCSCAT.
*/
#define DK3_HAVE_WCSCAT 1
#endif

#ifndef DK3_HAVE_WCSCHR
/**	DK3 version of HAVE_WCSCHR.
*/
#define DK3_HAVE_WCSCHR 1
#endif

#ifndef DK3_HAVE_WCSCMP
/**	DK3 version of HAVE_WCSCMP.
*/
#define DK3_HAVE_WCSCMP 1
#endif

#ifndef DK3_HAVE_WCSCPY
/**	DK3 version of HAVE_WCSCPY.
*/
#define DK3_HAVE_WCSCPY 1
#endif

#ifndef DK3_HAVE_WCSDUP
/**	DK3 version of HAVE_WCSDUP.
*/
#define DK3_HAVE_WCSDUP 0
#endif

#ifndef DK3_HAVE_WCSICMP
/**	DK3 version of HAVE_WCSICMP.
*/
#define DK3_HAVE_WCSICMP 0
#endif

#ifndef DK3_HAVE_WCSLEN
/**	DK3 version of HAVE_WCSLEN.
*/
#define DK3_HAVE_WCSLEN 1
#endif

#ifndef DK3_HAVE_WCSNCMP
/**	DK3 version of HAVE_WCSNCMP.
*/
#define DK3_HAVE_WCSNCMP 1
#endif

#ifndef DK3_HAVE_WCSNCPY
/**	DK3 version of HAVE_WCSNCPY.
*/
#define DK3_HAVE_WCSNCPY 1
#endif

#ifndef DK3_HAVE_WCSRCHR
/**	DK3 version of HAVE_WCSRCHR.
*/
#define DK3_HAVE_WCSRCHR 1
#endif

#ifndef DK3_HAVE_WCSTOD
/**	DK3 version of HAVE_WCSTOD.
*/
#define DK3_HAVE_WCSTOD 1
#endif

#ifndef DK3_HAVE_WCSTOIMAX
#if _MSC_VER >= 1700
/**	DK3 version of HAVE_WCSTOIMAX.
*/
#define DK3_HAVE_WCSTOIMAX 1
#else
/**	DK3 version of HAVE_WCSTOIMAX.
*/
#define DK3_HAVE_WCSTOIMAX 0
#endif
#endif

#ifndef DK3_HAVE_WCSTOL
#if _MSC_VER >= 1700
/**	DK3 version of HAVE_WCSTOL.
*/
#define DK3_HAVE_WCSTOL 1
#else
/**	DK3 version of HAVE_WCSTOL.
*/
#define DK3_HAVE_WCSTOL 0
#endif
#endif

#ifndef DK3_HAVE_WCSTOLL
#if _MSC_VER >= 1700
/**	DK3 version of HAVE_WCSTOLL.
*/
#define DK3_HAVE_WCSTOLL 1
#else
/**	DK3 version of HAVE_WCSTOLL.
*/
#define DK3_HAVE_WCSTOLL 0
#endif
#endif

#ifndef DK3_HAVE_WCSTOUL
#if _MSC_VER >= 1700
/**	DK3 version of HAVE_WCSTOUL.
*/
#define DK3_HAVE_WCSTOUL 1
#else
/**	DK3 version of HAVE_WCSTOUL.
*/
#define DK3_HAVE_WCSTOUL 0
#endif
#endif

#ifndef DK3_HAVE_WCSTOULL
#if _MSC_VER >= 1700
/**	DK3 version of HAVE_WCSTOULL.
*/
#define DK3_HAVE_WCSTOULL 1
#else
/**	DK3 version of HAVE_WCSTOULL.
*/
#define DK3_HAVE_WCSTOULL 0
#endif
#endif

#ifndef DK3_HAVE_WCSTOUMAX
#if _MSC_VER >= 1700
/**	DK3 version of HAVE_WCSTOUMAX.
*/
#define DK3_HAVE_WCSTOUMAX 1
#else
/**	DK3 version of HAVE_WCSTOUMAX.
*/
#define DK3_HAVE_WCSTOUMAX 0
#endif
#endif

#ifndef DK3_HAVE_WINBASE_H
/**	DK3 version of HAVE_WINBASE_H.
*/
#define DK3_HAVE_WINBASE_H 1
#endif

#ifndef DK3_HAVE_WINCON_H
/**	DK3 version of HAVE_WINCON_H.
*/
#define DK3_HAVE_WINCON_H 1
#endif

#ifndef DK3_HAVE_WINDOWS_H
/**	DK3 version of HAVE_WINDOWS_H.
*/
#define DK3_HAVE_WINDOWS_H 1
#endif

#ifndef DK3_HAVE_WINREG_H
/**	DK3 version of HAVE_WINREG_H.
*/
#define DK3_HAVE_WINREG_H 1
#endif

#ifndef DK3_HAVE_WINSOCK2_H
/**	DK3 version of HAVE_WINSOCK2_H.
*/
#define DK3_HAVE_WINSOCK2_H 1
#endif

#ifndef DK3_HAVE_WRITE
/**	DK3 version of HAVE_WRITE.
*/
#define DK3_HAVE_WRITE 1
#endif

#ifndef DK3_HAVE_WS2TCPIP_H
/**	DK3 version of HAVE_WS2TCPIP_H.
*/
#define DK3_HAVE_WS2TCPIP_H 1
#endif

#ifndef DK3_HAVE__CLEARFP
#if _MSC_VER >= 1700
/**	DK3 version of HAVE__CLEARFP.
*/
#define DK3_HAVE__CLEARFP 1
#else
/**	DK3 version of HAVE__CLEARFP.
*/
#define DK3_HAVE__CLEARFP 0
#endif
#endif

#ifndef DK3_HAVE__FCLOSE
/**	DK3 version of HAVE__FCLOSE.
*/
#define DK3_HAVE__FCLOSE 0
#endif

#ifndef DK3_HAVE__FEOF
/**	DK3 version of HAVE__FEOF.
*/
#define DK3_HAVE__FEOF 0
#endif

#ifndef DK3_HAVE__FERROR
/**	DK3 version of HAVE__FERROR.
*/
#define DK3_HAVE__FERROR 0
#endif

#ifndef DK3_HAVE__FFLUSH
/**	DK3 version of HAVE__FFLUSH.
*/
#define DK3_HAVE__FFLUSH 0
#endif

#ifndef DK3_HAVE__FOPEN
/**	DK3 version of HAVE__FOPEN.
*/
#define DK3_HAVE__FOPEN 0
#endif

#ifndef DK3_HAVE__FREAD
/**	DK3 version of HAVE__FREAD.
*/
#define DK3_HAVE__FREAD 1
#endif

#ifndef DK3_HAVE__FWRITE
/**	DK3 version of HAVE__FWRITE.
*/
#define DK3_HAVE__FWRITE 1
#endif

#ifndef DK3_HAVE__GETCWD
/**	DK3 version of HAVE__GETCWD.
*/
#define DK3_HAVE__GETCWD 0
#endif

#ifndef DK3_HAVE__GETPID
/**	DK3 version of HAVE__GETPID.
*/
#define DK3_HAVE__GETPID 0
#endif

#ifndef DK3_HAVE__LSTAT
/**	DK3 version of HAVE__LSTAT.
*/
#define DK3_HAVE__LSTAT 0
#endif

#ifndef DK3_HAVE__LSTAT32
/**	DK3 version of HAVE__LSTAT32.
*/
#define DK3_HAVE__LSTAT32 0
#endif

#ifndef DK3_HAVE__LSTAT64
/**	DK3 version of HAVE__LSTAT64.
*/
#define DK3_HAVE__LSTAT64 0
#endif

#ifndef DK3_HAVE__MKDIR
/**	DK3 version of HAVE__MKDIR.
*/
#define DK3_HAVE__MKDIR 1
#endif

#ifndef DK3_HAVE__POPEN
/**	DK3 version of HAVE__POPEN.
*/
#define DK3_HAVE__POPEN 1
#endif

#ifndef DK3_HAVE__READ
/**	DK3 version of HAVE__READ.
*/
#define DK3_HAVE__READ 0
#endif

#ifndef DK3_HAVE__RMDIR
/**	DK3 version of HAVE__RMDIR.
*/
#define DK3_HAVE__RMDIR 1
#endif

#ifndef DK3_HAVE__SNPRINTF
/**	DK3 version of HAVE__SNPRINTF.
*/
#define DK3_HAVE__SNPRINTF 1
#endif

#ifndef DK3_HAVE__STAT
/**	DK3 version of HAVE__STAT.
*/
#define DK3_HAVE__STAT 0
#endif

#ifndef DK3_HAVE__STAT32
/**	DK3 version of HAVE__STAT32.
*/
#define DK3_HAVE__STAT32 0
#endif

#ifndef DK3_HAVE__STAT64
/**	DK3 version of HAVE__STAT64.
*/
#define DK3_HAVE__STAT64 0
#endif

#ifndef DK3_HAVE__STRDUP
/**	DK3 version of HAVE__STRDUP.
*/
#define DK3_HAVE__STRDUP 1
#endif

#ifndef DK3_HAVE__STRICMP
/**	DK3 version of HAVE__STRICMP.
*/
#define DK3_HAVE__STRICMP 1
#endif

#ifndef DK3_HAVE__UNLINK
/**	DK3 version of HAVE__UNLINK.
*/
#define DK3_HAVE__UNLINK 1
#endif

#ifndef DK3_HAVE__WCSCAT
/**	DK3 version of HAVE__WCSCAT.
*/
#define DK3_HAVE__WCSCAT 0
#endif

#ifndef DK3_HAVE__WCSCHR
/**	DK3 version of HAVE__WCSCHR.
*/
#define DK3_HAVE__WCSCHR 0
#endif

#ifndef DK3_HAVE__WCSCMP
/**	DK3 version of HAVE__WCSCMP.
*/
#define DK3_HAVE__WCSCMP 0
#endif

#ifndef DK3_HAVE__WCSCPY
/**	DK3 version of HAVE__WCSCPY.
*/
#define DK3_HAVE__WCSCPY 0
#endif

#ifndef DK3_HAVE__WCSDUP
/**	DK3 version of HAVE__WCSDUP.
*/
#define DK3_HAVE__WCSDUP 1
#endif

#ifndef DK3_HAVE__WCSICMP
/**	DK3 version of HAVE__WCSICMP.
*/
#define DK3_HAVE__WCSICMP 1
#endif

#ifndef DK3_HAVE__WCSLEN
/**	DK3 version of HAVE__WCSLEN.
*/
#define DK3_HAVE__WCSLEN 0
#endif

#ifndef DK3_HAVE__WCSNCMP
/**	DK3 version of HAVE__WCSNCMP.
*/
#define DK3_HAVE__WCSNCMP 0
#endif

#ifndef DK3_HAVE__WCSNCPY
/**	DK3 version of HAVE__WCSNCPY.
*/
#define DK3_HAVE__WCSNCPY 0
#endif

#ifndef DK3_HAVE__WCSRCHR
/**	DK3 version of HAVE__WCSRCHR.
*/
#define DK3_HAVE__WCSRCHR 0
#endif

#ifndef DK3_HAVE__WGETENV
/**	DK3 version of HAVE__WGETENV.
*/
#define DK3_HAVE__WGETENV 1
#endif

#ifndef DK3_HAVE__WRITE
/**	DK3 version of HAVE__WRITE.
*/
#define DK3_HAVE__WRITE 0
#endif

#ifndef DK3_TIME_WITH_SYS_TIME
/**	DK3 version of TIME_WITH_SYS_TIME.
*/
#define DK3_TIME_WITH_SYS_TIME 0
#endif

#ifndef DK3_SIZEOF_DOUBLE
/**	DK3 version of SIZEOF_DOUBLE.
*/
#define DK3_SIZEOF_DOUBLE 8
#endif

#ifndef DK3_SIZEOF_INT
/**	DK3 version of SIZEOF_INT.
*/
#define DK3_SIZEOF_INT 4
#endif

#ifndef DK3_SIZEOF_INTMAX_T
#if _MSC_VER >= 1700
/**	DK3 version of SIZEOF_INTMAX_T.
*/
#define DK3_SIZEOF_INTMAX_T 8
#else
/**	DK3 version of SIZEOF_INTMAX_T.
*/
#define DK3_SIZEOF_INTMAX_T 0
#endif
#endif

#ifndef DK3_SIZEOF_LONG
/**	DK3 version of SIZEOF_LONG.
*/
#define DK3_SIZEOF_LONG 4
#endif

#ifndef DK3_SIZEOF_LONG_DOUBLE
/**	DK3 version of SIZEOF_LONG_DOUBLE.
*/
#define DK3_SIZEOF_LONG_DOUBLE 8
#endif

#ifndef DK3_SIZEOF_LONG_LONG
/**	DK3 version of SIZEOF_LONG_LONG.
*/
#define DK3_SIZEOF_LONG_LONG 8
#endif

#ifndef DK3_SIZEOF_SHORT
/**	DK3 version of SIZEOF_SHORT.
*/
#define DK3_SIZEOF_SHORT 2
#endif

#if defined(WIN64) || defined(_WIN64)
#ifndef DK3_SIZEOF_SIZE_T
/**	DK3 version of SIZEOF_SIZE_T.
*/
#define DK3_SIZEOF_SIZE_T 8
#endif
#else
#ifndef DK3_SIZEOF_SIZE_T
/**	DK3 version of SIZEOF_SIZE_T.
*/
#define DK3_SIZEOF_SIZE_T 4
#endif
#endif

#ifndef DK3_SIZEOF_WCHAR_T
/**	DK3 version of SIZEOF_WCHAR_T.
*/
#define DK3_SIZEOF_WCHAR_T 2
#endif

#ifndef DK3_HAVE_RFC_2279
/**	DK3 version of HAVE_RFC_2279.
*/
#define DK3_HAVE_RFC_2279 0
#endif

#ifndef DK3_WORDS_BIGENDIAN
/**	DK3 version of WORDS_BIGENDIAN.
*/
#define DK3_WORDS_BIGENDIAN 0
#endif

#else
/* if DK3_ON_WINDOWS */


#ifndef DK3_HAVE_ACOSH
/**	DK3 version of HAVE_ACOSH.
*/
#define DK3_HAVE_ACOSH 1
#endif

#ifndef DK3_HAVE_ACOSHL
/**	DK3 version of HAVE_ACOSHL.
*/
#define DK3_HAVE_ACOSHL 1
#endif

#ifndef DK3_HAVE_ACOSL
/**	DK3 version of HAVE_ACOSL.
*/
#define DK3_HAVE_ACOSL 1
#endif

#ifndef DK3_HAVE_ALLOC_H
/**	DK3 version of HAVE_ALLOC_H.
*/
#define DK3_HAVE_ALLOC_H 0
#endif

#ifndef DK3_HAVE_ARPA_INET_H
/**	DK3 version of HAVE_ARPA_INET_H.
*/
#define DK3_HAVE_ARPA_INET_H 1
#endif

#ifndef DK3_HAVE_ASINH
/**	DK3 version of HAVE_ASINH.
*/
#define DK3_HAVE_ASINH 1
#endif

#ifndef DK3_HAVE_ASINHL
/**	DK3 version of HAVE_ASINHL.
*/
#define DK3_HAVE_ASINHL 1
#endif

#ifndef DK3_HAVE_ASINL
/**	DK3 version of HAVE_ASINL.
*/
#define DK3_HAVE_ASINL 1
#endif

#ifndef DK3_HAVE_ATAN2
/**	DK3 version of HAVE_ATAN2.
*/
#define DK3_HAVE_ATAN2 1
#endif

#ifndef DK3_HAVE_ATAN2L
/**	DK3 version of HAVE_ATAN2L.
*/
#define DK3_HAVE_ATAN2L 1
#endif

#ifndef DK3_HAVE_ATANH
/**	DK3 version of HAVE_ATANH.
*/
#define DK3_HAVE_ATANH 1
#endif

#ifndef DK3_HAVE_ATANHL
/**	DK3 version of HAVE_ATANHL.
*/
#define DK3_HAVE_ATANHL 1
#endif

#ifndef DK3_HAVE_ATANL
/**	DK3 version of HAVE_ATANL.
*/
#define DK3_HAVE_ATANL 1
#endif

#ifndef DK3_HAVE_BACKSLASH
/**	DK3 version of HAVE_BACKSLASH.
*/
#define DK3_HAVE_BACKSLASH 0
#endif

#ifndef DK3_HAVE_BCMP
/**	DK3 version of HAVE_BCMP.
*/
#define DK3_HAVE_BCMP 1
#endif

#ifndef DK3_HAVE_BCOPY
/**	DK3 version of HAVE_BCOPY.
*/
#define DK3_HAVE_BCOPY 1
#endif

#ifndef DK3_HAVE_BZERO
/**	DK3 version of HAVE_BZERO.
*/
#define DK3_HAVE_BZERO 1
#endif

#ifndef DK3_HAVE_BZLIB_H
/**	DK3 version of HAVE_BZLIB_H.
*/
#define DK3_HAVE_BZLIB_H 1
#endif

#ifndef DK3_HAVE_CEIL
/**	DK3 version of HAVE_CEIL.
*/
#define DK3_HAVE_CEIL 1
#endif

#ifndef DK3_HAVE_CEILL
/**	DK3 version of HAVE_CEILL.
*/
#define DK3_HAVE_CEILL 1
#endif

#ifndef DK3_HAVE_CHDIR
/**	DK3 version of HAVE_CHDIR.
*/
#define DK3_HAVE_CHDIR 1
#endif

#ifndef DK3_HAVE_CHMOD
/**	DK3 version of HAVE_CHMOD.
*/
#define DK3_HAVE_CHMOD 1
#endif

#ifndef DK3_HAVE_CHOWN
/**	DK3 version of HAVE_CHOWN.
*/
#define DK3_HAVE_CHOWN 1
#endif

#ifndef DK3_HAVE_CLOSEDIR
/**	DK3 version of HAVE_CLOSEDIR.
*/
#define DK3_HAVE_CLOSEDIR 1
#endif

#ifndef DK3_HAVE_CONIO_H
/**	DK3 version of HAVE_CONIO_H.
*/
#define DK3_HAVE_CONIO_H 0
#endif

#ifndef DK3_HAVE_CONST
/**	DK3 version of HAVE_CONST.
*/
#define DK3_HAVE_CONST 1
#endif

#ifndef DK3_HAVE_COSHL
/**	DK3 version of HAVE_COSHL.
*/
#define DK3_HAVE_COSHL 1
#endif

#ifndef DK3_HAVE_COSL
/**	DK3 version of HAVE_COSL.
*/
#define DK3_HAVE_COSL 1
#endif

#ifndef DK3_HAVE_CTYPE_H
/**	DK3 version of HAVE_CTYPE_H.
*/
#define DK3_HAVE_CTYPE_H 1
#endif

#ifndef DK3_HAVE_DB_CURSOR_C_GET
/**	DK3 version of HAVE_DB_CURSOR_C_GET.
*/
#define DK3_HAVE_DB_CURSOR_C_GET 1
#endif

#ifndef DK3_HAVE_DB_H
/**	DK3 version of HAVE_DB_H.
*/
#define DK3_HAVE_DB_H 1
#endif

#ifndef DK3_HAVE_DEV_RANDOM
/**	DK3 version of HAVE_DEV_RANDOM.
*/
#define DK3_HAVE_DEV_RANDOM 1
#endif

#ifndef DK3_HAVE_DEV_URANDOM
/**	DK3 version of HAVE_DEV_URANDOM.
*/
#define DK3_HAVE_DEV_URANDOM 1
#endif

#ifndef DK3_HAVE_DIRECT_H
/**	DK3 version of HAVE_DIRECT_H.
*/
#define DK3_HAVE_DIRECT_H 0
#endif

#ifndef DK3_HAVE_DIRENT_H
/**	DK3 version of HAVE_DIRENT_H.
*/
#define DK3_HAVE_DIRENT_H 1
#endif

#ifndef DK3_HAVE_DIR_H
/**	DK3 version of HAVE_DIR_H.
*/
#define DK3_HAVE_DIR_H 0
#endif

#ifndef DK3_HAVE_DOS_H
/**	DK3 version of HAVE_DOS_H.
*/
#define DK3_HAVE_DOS_H 0
#endif

#ifndef DK3_HAVE_ENDGRENT
/**	DK3 version of HAVE_ENDGRENT.
*/
#define DK3_HAVE_ENDGRENT 1
#endif

#ifndef DK3_HAVE_ENDPWENT
/**	DK3 version of HAVE_ENDPWENT.
*/
#define DK3_HAVE_ENDPWENT 1
#endif

#ifndef DK3_HAVE_ERRNO_H
/**	DK3 version of HAVE_ERRNO_H.
*/
#define DK3_HAVE_ERRNO_H 1
#endif

#ifndef DK3_HAVE_ERR_H
/**	DK3 version of HAVE_ERR_H.
*/
#define DK3_HAVE_ERR_H 1
#endif

#ifndef DK3_HAVE_EXPL
/**	DK3 version of HAVE_EXPL.
*/
#define DK3_HAVE_EXPL 1
#endif

#ifndef DK3_HAVE_FABS
/**	DK3 version of HAVE_FABS.
*/
#define DK3_HAVE_FABS 1
#endif

#ifndef DK3_HAVE_FABSL
/**	DK3 version of HAVE_FABSL.
*/
#define DK3_HAVE_FABSL 1
#endif

#ifndef DK3_HAVE_FCLOSE
/**	DK3 version of HAVE_FCLOSE.
*/
#define DK3_HAVE_FCLOSE 1
#endif

#ifndef DK3_HAVE_FCNTL_H
/**	DK3 version of HAVE_FCNTL_H.
*/
#define DK3_HAVE_FCNTL_H 1
#endif

#ifndef DK3_HAVE_FENV_H
/**	DK3 version of HAVE_FENV_H.
*/
#define DK3_HAVE_FENV_H 1
#endif

#ifndef DK3_HAVE_FEOF
/**	DK3 version of HAVE_FEOF.
*/
#define DK3_HAVE_FEOF 1
#endif

#ifndef DK3_HAVE_FERROR
/**	DK3 version of HAVE_FERROR.
*/
#define DK3_HAVE_FERROR 1
#endif

#ifndef DK3_HAVE_FETESTEXCEPT
/**	DK3 version of HAVE_FETESTEXCEPT.
*/
#define DK3_HAVE_FETESTEXCEPT 1
#endif

#ifndef DK3_HAVE_FFLUSH
/**	DK3 version of HAVE_FFLUSH.
*/
#define DK3_HAVE_FFLUSH 1
#endif

#ifndef DK3_HAVE_FLOAT_H
/**	DK3 version of HAVE_FLOAT_H.
*/
#define DK3_HAVE_FLOAT_H 1
#endif

#ifndef DK3_HAVE_FLOOR
/**	DK3 version of HAVE_FLOOR.
*/
#define DK3_HAVE_FLOOR 1
#endif

#ifndef DK3_HAVE_FLOORL
/**	DK3 version of HAVE_FLOORL.
*/
#define DK3_HAVE_FLOORL 1
#endif

#ifndef DK3_HAVE_FNCASEINS
/**	DK3 version of HAVE_FNCASEINS.
*/
#define DK3_HAVE_FNCASEINS 0
#endif

#ifndef DK3_HAVE_FOPEN
/**	DK3 version of HAVE_FOPEN.
*/
#define DK3_HAVE_FOPEN 1
#endif

#ifndef DK3_HAVE_FOPEN64
/**	DK3 version of HAVE_FOPEN64.
*/
#define DK3_HAVE_FOPEN64 1
#endif

#ifndef DK3_HAVE_FORK
/**	DK3 version of HAVE_FORK.
*/
#define DK3_HAVE_FORK 1
#endif

#ifndef DK3_HAVE_FPCLASSIFY
/**	DK3 version of HAVE_FPCLASSIFY.
*/
#define DK3_HAVE_FPCLASSIFY 1
#endif

#ifndef DK3_HAVE_FREAD
/**	DK3 version of HAVE_FREAD.
*/
#define DK3_HAVE_FREAD 1
#endif

#ifndef DK3_HAVE_FREE
/**	DK3 version of HAVE_FREE.
*/
#define DK3_HAVE_FREE 1
#endif

#ifndef DK3_HAVE_FWRITE
/**	DK3 version of HAVE_FWRITE.
*/
#define DK3_HAVE_FWRITE 1
#endif

#ifndef DK3_HAVE_GDBM_H
/**	DK3 version of HAVE_GDBM_H.
*/
#define DK3_HAVE_GDBM_H 1
#endif

#ifndef DK3_HAVE_GETADDRINFO
/**	DK3 version of HAVE_GETADDRINFO.
*/
#define DK3_HAVE_GETADDRINFO 1
#endif

#ifndef DK3_HAVE_GETCWD
/**	DK3 version of HAVE_GETCWD.
*/
#define DK3_HAVE_GETCWD 1
#endif

#ifndef DK3_HAVE_GETENV
/**	DK3 version of HAVE_GETENV.
*/
#define DK3_HAVE_GETENV 1
#endif

#ifndef DK3_HAVE_GETEUID
/**	DK3 version of HAVE_GETEUID.
*/
#define DK3_HAVE_GETEUID 1
#endif

#ifndef DK3_HAVE_GETGRENT
/**	DK3 version of HAVE_GETGRENT.
*/
#define DK3_HAVE_GETGRENT 1
#endif

#ifndef DK3_HAVE_GETGRGID
/**	DK3 version of HAVE_GETGRGID.
*/
#define DK3_HAVE_GETGRGID 1
#endif

#ifndef DK3_HAVE_GETGRNAM
/**	DK3 version of HAVE_GETGRNAM.
*/
#define DK3_HAVE_GETGRNAM 1
#endif

#ifndef DK3_HAVE_GETHOSTBYNAME
/**	DK3 version of HAVE_GETHOSTBYNAME.
*/
#define DK3_HAVE_GETHOSTBYNAME 1
#endif

#ifndef DK3_HAVE_GETHOSTNAME
/**	DK3 version of HAVE_GETHOSTNAME.
*/
#define DK3_HAVE_GETHOSTNAME 1
#endif

#ifndef DK3_HAVE_GETPEERNAME
/**	DK3 version of HAVE_GETPEERNAME.
*/
#define DK3_HAVE_GETPEERNAME 1
#endif

#ifndef DK3_HAVE_GETPID
/**	DK3 version of HAVE_GETPID.
*/
#define DK3_HAVE_GETPID 1
#endif

#ifndef DK3_HAVE_GETPWENT
/**	DK3 version of HAVE_GETPWENT.
*/
#define DK3_HAVE_GETPWENT 1
#endif

#ifndef DK3_HAVE_GETPWNAM
/**	DK3 version of HAVE_GETPWNAM.
*/
#define DK3_HAVE_GETPWNAM 1
#endif

#ifndef DK3_HAVE_GETPWUID
/**	DK3 version of HAVE_GETPWUID.
*/
#define DK3_HAVE_GETPWUID 1
#endif

#ifndef DK3_HAVE_GETRLIMIT
/**	DK3 version of HAVE_GETRLIMIT.
*/
#define DK3_HAVE_GETRLIMIT 1
#endif

#ifndef DK3_HAVE_GETSOCKNAME
/**	DK3 version of HAVE_GETSOCKNAME.
*/
#define DK3_HAVE_GETSOCKNAME 1
#endif

#ifndef DK3_HAVE_GETUID
/**	DK3 version of HAVE_GETUID.
*/
#define DK3_HAVE_GETUID 1
#endif

#ifndef DK3_HAVE_GRP_H
/**	DK3 version of HAVE_GRP_H.
*/
#define DK3_HAVE_GRP_H 1
#endif

#ifndef DK3_HAVE_HTONL
/**	DK3 version of HAVE_HTONL.
*/
#define DK3_HAVE_HTONL 1
#endif

#ifndef DK3_HAVE_IEEE_754_DOUBLE
/**	DK3 version of HAVE_IEEE_754_DOUBLE.
*/
#define DK3_HAVE_IEEE_754_DOUBLE 1
#endif

#ifndef DK3_HAVE_IN6_ADDR
/**	DK3 version of HAVE_IN6_ADDR.
*/
#define DK3_HAVE_IN6_ADDR 0
#endif

#ifndef DK3_HAVE_INET_ADDR
/**	DK3 version of HAVE_INET_ADDR.
*/
#define DK3_HAVE_INET_ADDR 1
#endif

#ifndef DK3_HAVE_INET_ATON
/**	DK3 version of HAVE_INET_ATON.
*/
#define DK3_HAVE_INET_ATON 1
#endif

#ifndef DK3_HAVE_INET_PTON
/**	DK3 version of HAVE_INET_PTON.
*/
#define DK3_HAVE_INET_PTON 1
#endif

#ifndef DK3_HAVE_INITSTATE
/**	DK3 version of HAVE_INITSTATE.
*/
#define DK3_HAVE_INITSTATE 1
#endif

#ifndef DK3_HAVE_INODES
/**	DK3 version of HAVE_INODES.
*/
#define DK3_HAVE_INODES 1
#endif

#ifndef DK3_HAVE_INTMAX_T
/**	DK3 version of HAVE_INTMAX_T.
*/
#define DK3_HAVE_INTMAX_T 1
#endif

#ifndef DK3_HAVE_INTTYPES_H
/**	DK3 version of HAVE_INTTYPES_H.
*/
#define DK3_HAVE_INTTYPES_H 1
#endif

#ifndef DK3_HAVE_IN_ADDR
/**	DK3 version of HAVE_IN_ADDR.
*/
#define DK3_HAVE_IN_ADDR 0
#endif

#ifndef DK3_HAVE_IO_H
/**	DK3 version of HAVE_IO_H.
*/
#define DK3_HAVE_IO_H 0
#endif

#ifndef DK3_HAVE_ISATTY
/**	DK3 version of HAVE_ISATTY.
*/
#define DK3_HAVE_ISATTY 1
#endif

#ifndef DK3_HAVE_ISFINITE
/**	DK3 version of HAVE_ISFINITE.
*/
#define DK3_HAVE_ISFINITE 1
#endif

#ifndef DK3_HAVE_ISNORMAL
/**	DK3 version of HAVE_ISNORMAL.
*/
#define DK3_HAVE_ISNORMAL 1
#endif

#ifndef DK3_HAVE_JPEGLIB_H
/**	DK3 version of HAVE_JPEGLIB_H.
*/
#define DK3_HAVE_JPEGLIB_H 1
#endif

#ifndef DK3_HAVE_LABS
/**	DK3 version of HAVE_LABS.
*/
#define DK3_HAVE_LABS 1
#endif

#ifndef DK3_HAVE_LARGEFILE64_SOURCE
/**	DK3 version of HAVE_LARGEFILE64_SOURCE.
*/
#define DK3_HAVE_LARGEFILE64_SOURCE 1
#endif

#ifndef DK3_HAVE_LIBNETSNMP
/**	DK3 version of HAVE_LIBNETSNMP.
*/
#define DK3_HAVE_LIBNETSNMP 1
#endif

#ifndef DK3_HAVE_LIMITS_H
/**	DK3 version of HAVE_LIMITS_H.
*/
#define DK3_HAVE_LIMITS_H 1
#endif

#ifndef DK3_HAVE_LOCALE_H
/**	DK3 version of HAVE_LOCALE_H.
*/
#define DK3_HAVE_LOCALE_H 1
#endif

#ifndef DK3_HAVE_LOCALTIME
/**	DK3 version of HAVE_LOCALTIME.
*/
#define DK3_HAVE_LOCALTIME 1
#endif

#ifndef DK3_HAVE_LOCALTIME
/**	DK3 version of HAVE_LOCALTIME.
*/
#define DK3_HAVE_LOCALTIME 1
#endif

#ifndef DK3_HAVE_LOCALTIME_R
/**	DK3 version of HAVE_LOCALTIME_R.
*/
#define DK3_HAVE_LOCALTIME_R 1
#endif

#ifndef DK3_HAVE_LOGL
/**	DK3 version of HAVE_LOGL.
*/
#define DK3_HAVE_LOGL 1
#endif

#ifndef DK3_HAVE_LONG_DOUBLE
/**	DK3 version of HAVE_LONG_DOUBLE.
*/
#define DK3_HAVE_LONG_DOUBLE 1
#endif

#ifndef DK3_HAVE_LONG_LONG
/**	DK3 version of HAVE_LONG_LONG.
*/
#define DK3_HAVE_LONG_LONG 1
#endif

#ifndef DK3_HAVE_LPRNG_H
/**	DK3 version of HAVE_LPRNG_H.
*/
#define DK3_HAVE_LPRNG_H 0
#endif

#ifndef DK3_HAVE_LRAND48
/**	DK3 version of HAVE_LRAND48.
*/
#define DK3_HAVE_LRAND48 1
#endif

#ifndef DK3_HAVE_LSTAT
/**	DK3 version of HAVE_LSTAT.
*/
#define DK3_HAVE_LSTAT 1
#endif

#ifndef DK3_HAVE_LSTAT32
/**	DK3 version of HAVE_LSTAT32.
*/
#define DK3_HAVE_LSTAT32 0
#endif

#ifndef DK3_HAVE_LSTAT64
/**	DK3 version of HAVE_LSTAT64.
*/
#define DK3_HAVE_LSTAT64 1
#endif

#ifndef DK3_HAVE_MALLOC
/**	DK3 version of HAVE_MALLOC.
*/
#define DK3_HAVE_MALLOC 1
#endif

#ifndef DK3_HAVE_MALLOC_H
/**	DK3 version of HAVE_MALLOC_H.
*/
#define DK3_HAVE_MALLOC_H 1
#endif

#ifndef DK3_HAVE_MATH_H
/**	DK3 version of HAVE_MATH_H.
*/
#define DK3_HAVE_MATH_H 1
#endif

#ifndef DK3_HAVE_MEMCMP
/**	DK3 version of HAVE_MEMCMP.
*/
#define DK3_HAVE_MEMCMP 1
#endif

#ifndef DK3_HAVE_MEMCPY
/**	DK3 version of HAVE_MEMCPY.
*/
#define DK3_HAVE_MEMCPY 1
#endif

#ifndef DK3_HAVE_MEMSET
/**	DK3 version of HAVE_MEMSET.
*/
#define DK3_HAVE_MEMSET 1
#endif

#ifndef DK3_HAVE_MKDIR
/**	DK3 version of HAVE_MKDIR.
*/
#define DK3_HAVE_MKDIR 1
#endif

#ifndef DK3_HAVE_MKDIR2
/**	DK3 version of HAVE_MKDIR2.
*/
#define DK3_HAVE_MKDIR2 1
#endif

#ifndef DK3_HAVE_MPCTL
/**	DK3 version of HAVE_MPCTL.
*/
#define DK3_HAVE_MPCTL 0
#endif

#ifndef DK3_HAVE_MYSQL_LIBRARY_END
/**	DK3 version of HAVE_MYSQL_LIBRARY_END.
*/
#define DK3_HAVE_MYSQL_LIBRARY_END 0
#endif

#ifndef DK3_HAVE_MYSQL_LIBRARY_INIT
/**	DK3 version of HAVE_MYSQL_LIBRARY_INIT.
*/
#define DK3_HAVE_MYSQL_LIBRARY_INIT 0
#endif

#ifndef DK3_HAVE_MYSQL_MYSQL_H
/**	DK3 version of HAVE_MYSQL_MYSQL_H.
*/
#define DK3_HAVE_MYSQL_MYSQL_H 1
#endif

#ifndef DK3_HAVE_MYSQL_SET_CHARACTER_SET
/**	DK3 version of HAVE_MYSQL_SET_CHARACTER_SET.
*/
#define DK3_HAVE_MYSQL_SET_CHARACTER_SET 0
#endif

#ifndef DK3_HAVE_NDBM_H
/**	DK3 version of HAVE_NDBM_H.
*/
#define DK3_HAVE_NDBM_H 0
#endif

#ifndef DK3_HAVE_NETDB_H
/**	DK3 version of HAVE_NETDB_H.
*/
#define DK3_HAVE_NETDB_H 1
#endif

#ifndef DK3_HAVE_NETINET_IN_H
/**	DK3 version of HAVE_NETINET_IN_H.
*/
#define DK3_HAVE_NETINET_IN_H 1
#endif

#ifndef DK3_HAVE_NETSNMP_ENABLE_FILELOG
/**	DK3 version of HAVE_NETSNMP_ENABLE_FILELOG.
*/
#define DK3_HAVE_NETSNMP_ENABLE_FILELOG 1
#endif

#ifndef DK3_HAVE_NRAND48
/**	DK3 version of HAVE_NRAND48.
*/
#define DK3_HAVE_NRAND48 1
#endif

#ifndef DK3_HAVE_OPENDIR
/**	DK3 version of HAVE_OPENDIR.
*/
#define DK3_HAVE_OPENDIR 1
#endif

#ifndef DK3_HAVE_OPENSSL_MD5_H
/**	DK3 version of HAVE_OPENSSL_MD5_H.
*/
#define DK3_HAVE_OPENSSL_MD5_H 1
#endif

#ifndef DK3_HAVE_OPENSSL_RAND_H
/**	DK3 version of HAVE_OPENSSL_RAND_H.
*/
#define DK3_HAVE_OPENSSL_RAND_H 1
#endif

#ifndef DK3_HAVE_OPENSSL_RIPEMD_H
/**	DK3 version of HAVE_OPENSSL_RIPEMD_H.
*/
#define DK3_HAVE_OPENSSL_RIPEMD_H 1
#endif

#ifndef DK3_HAVE_OPENSSL_SHA_H
/**	DK3 version of HAVE_OPENSSL_SHA_H.
*/
#define DK3_HAVE_OPENSSL_SHA_H 1
#endif

#ifndef DK3_HAVE_PNG_GET_PIXELS_PER_INCH
/**	DK3 version of HAVE_PNG_GET_PIXELS_PER_INCH.
*/
#define DK3_HAVE_PNG_GET_PIXELS_PER_INCH 0
#endif

#ifndef DK3_HAVE_PNG_H
/**	DK3 version of HAVE_PNG_H.
*/
#define DK3_HAVE_PNG_H 1
#endif

#ifndef DK3_HAVE_POPEN
/**	DK3 version of HAVE_POPEN.
*/
#define DK3_HAVE_POPEN 1
#endif

#ifndef DK3_HAVE_PROCESS_H
/**	DK3 version of HAVE_PROCESS_H.
*/
#define DK3_HAVE_PROCESS_H 0
#endif

#ifndef DK3_HAVE_PTHREAD_H
/**	DK3 version of HAVE_PTHREAD_H.
*/
#define DK3_HAVE_PTHREAD_H 1
#endif

#ifndef DK3_HAVE_PWD_H
/**	DK3 version of HAVE_PWD_H.
*/
#define DK3_HAVE_PWD_H 1
#endif

#ifndef DK3_HAVE_RAND
/**	DK3 version of HAVE_RAND.
*/
#define DK3_HAVE_RAND 1
#endif

#ifndef DK3_HAVE_RANDOM
/**	DK3 version of HAVE_RANDOM.
*/
#define DK3_HAVE_RANDOM 1
#endif

#ifndef DK3_HAVE_READ
/**	DK3 version of HAVE_READ.
*/
#define DK3_HAVE_READ 1
#endif

#ifndef DK3_HAVE_READDIR
/**	DK3 version of HAVE_READDIR.
*/
#define DK3_HAVE_READDIR 1
#endif

#ifndef DK3_HAVE_RFC_2249
/**	DK3 version of HAVE_RFC_2249.
*/
#define DK3_HAVE_RFC_2249 0
#endif

#ifndef DK3_HAVE_RINT
/**	DK3 version of HAVE_RINT.
*/
#define DK3_HAVE_RINT 1
#endif

#ifndef DK3_HAVE_RINTL
/**	DK3 version of HAVE_RINTL.
*/
#define DK3_HAVE_RINTL 1
#endif

#ifndef DK3_HAVE_RMDIR
/**	DK3 version of HAVE_RMDIR.
*/
#define DK3_HAVE_RMDIR 1
#endif

#ifndef DK3_HAVE_SEED48
/**	DK3 version of HAVE_SEED48.
*/
#define DK3_HAVE_SEED48 1
#endif

#ifndef DK3_HAVE_SELECT
/**	DK3 version of HAVE_SELECT.
*/
#define DK3_HAVE_SELECT 1
#endif

#ifndef DK3_HAVE_SETGID
/**	DK3 version of HAVE_SETGID.
*/
#define DK3_HAVE_SETGID 1
#endif

#ifndef DK3_HAVE_SETGRENT
/**	DK3 version of HAVE_SETGRENT.
*/
#define DK3_HAVE_SETGRENT 1
#endif

#ifndef DK3_HAVE_SETJMP_H
/**	DK3 version of HAVE_SETJMP_H.
*/
#define DK3_HAVE_SETJMP_H 1
#endif

#ifndef DK3_HAVE_SETLOCALE
/**	DK3 version of HAVE_SETLOCALE.
*/
#define DK3_HAVE_SETLOCALE 1
#endif

#ifndef DK3_HAVE_SETPGRP
/**	DK3 version of HAVE_SETPGRP.
*/
#define DK3_HAVE_SETPGRP 1
#endif

#ifndef DK3_HAVE_SETPWENT
/**	DK3 version of HAVE_SETPWENT.
*/
#define DK3_HAVE_SETPWENT 1
#endif

#ifndef DK3_HAVE_SETSID
/**	DK3 version of HAVE_SETSID.
*/
#define DK3_HAVE_SETSID 1
#endif

#ifndef DK3_HAVE_SETSOCKOPT
/**	DK3 version of HAVE_SETSOCKOPT.
*/
#define DK3_HAVE_SETSOCKOPT 1
#endif

#ifndef DK3_HAVE_SETSTATE
/**	DK3 version of HAVE_SETSTATE.
*/
#define DK3_HAVE_SETSTATE 1
#endif

#ifndef DK3_HAVE_SETUID
/**	DK3 version of HAVE_SETUID.
*/
#define DK3_HAVE_SETUID 1
#endif

#ifndef DK3_HAVE_SHA224
/**	DK3 version of HAVE_SHA224.
*/
#define DK3_HAVE_SHA224 1
#endif

#ifndef DK3_HAVE_SHA256
/**	DK3 version of HAVE_SHA256.
*/
#define DK3_HAVE_SHA256 1
#endif

#ifndef DK3_HAVE_SHA384
/**	DK3 version of HAVE_SHA384.
*/
#define DK3_HAVE_SHA384 1
#endif

#ifndef DK3_HAVE_SHA512
/**	DK3 version of HAVE_SHA512.
*/
#define DK3_HAVE_SHA512 1
#endif

#ifndef DK3_HAVE_SHADOW_H
/**	DK3 version of HAVE_SHADOW_H.
*/
#define DK3_HAVE_SHADOW_H 1
#endif

#ifndef DK3_HAVE_SIGACTION
/**	DK3 version of HAVE_SIGACTION.
*/
#define DK3_HAVE_SIGACTION 1
#endif

#ifndef DK3_HAVE_SIGNAL
/**	DK3 version of HAVE_SIGNAL.
*/
#define DK3_HAVE_SIGNAL 1
#endif

#ifndef DK3_HAVE_SIGNAL_H
/**	DK3 version of HAVE_SIGNAL_H.
*/
#define DK3_HAVE_SIGNAL_H 1
#endif

#ifndef DK3_HAVE_SIGSET
/**	DK3 version of HAVE_SIGSET.
*/
#define DK3_HAVE_SIGSET 1
#endif

#ifndef DK3_HAVE_SIG_ATOMIC_T
/**	DK3 version of HAVE_SIG_ATOMIC_T.
*/
#define DK3_HAVE_SIG_ATOMIC_T 1
#endif

#ifndef DK3_HAVE_SINHL
/**	DK3 version of HAVE_SINHL.
*/
#define DK3_HAVE_SINHL 1
#endif

#ifndef DK3_HAVE_SINL
/**	DK3 version of HAVE_SINL.
*/
#define DK3_HAVE_SINL 1
#endif

#ifndef DK3_HAVE_SNPRINTF
/**	DK3 version of HAVE_SNPRINTF.
*/
#define DK3_HAVE_SNPRINTF 1
#endif

#ifndef DK3_HAVE_SOCKET
/**	DK3 version of HAVE_SOCKET.
*/
#define DK3_HAVE_SOCKET 1
#endif

#ifndef DK3_HAVE_SOCKLEN_T
/**	DK3 version of HAVE_SOCKLEN_T.
*/
#define DK3_HAVE_SOCKLEN_T 1
#endif

#ifndef DK3_HAVE_SQRTL
/**	DK3 version of HAVE_SQRTL.
*/
#define DK3_HAVE_SQRTL 1
#endif

#ifndef DK3_HAVE_SRAND
/**	DK3 version of HAVE_SRAND.
*/
#define DK3_HAVE_SRAND 1
#endif

#ifndef DK3_HAVE_SSIZE_T
/**	DK3 version of HAVE_SSIZE_T.
*/
#define DK3_HAVE_SSIZE_T 1
#endif

#ifndef DK3_HAVE_STAT
/**	DK3 version of HAVE_STAT.
*/
#define DK3_HAVE_STAT 1
#endif

#ifndef DK3_HAVE_STAT32
/**	DK3 version of HAVE_STAT32.
*/
#define DK3_HAVE_STAT32 0
#endif

#ifndef DK3_HAVE_STAT64
/**	DK3 version of HAVE_STAT64.
*/
#define DK3_HAVE_STAT64 1
#endif

#ifndef DK3_HAVE_STDARG_H
/**	DK3 version of HAVE_STDARG_H.
*/
#define DK3_HAVE_STDARG_H 1
#endif

#ifndef DK3_HAVE_STDDEF_H
/**	DK3 version of HAVE_STDDEF_H.
*/
#define DK3_HAVE_STDDEF_H 1
#endif

#ifndef DK3_HAVE_STDINT_H
/**	DK3 version of HAVE_STDINT_H.
*/
#define DK3_HAVE_STDINT_H 1
#endif

#ifndef DK3_HAVE_STDIO_H
/**	DK3 version of HAVE_STDIO_H.
*/
#define DK3_HAVE_STDIO_H 1
#endif

#ifndef DK3_HAVE_STDLIB_H
/**	DK3 version of HAVE_STDLIB_H.
*/
#define DK3_HAVE_STDLIB_H 1
#endif

#ifndef DK3_HAVE_STRCASECMP
/**	DK3 version of HAVE_STRCASECMP.
*/
#define DK3_HAVE_STRCASECMP 1
#endif

#ifndef DK3_HAVE_STRCAT
/**	DK3 version of HAVE_STRCAT.
*/
#define DK3_HAVE_STRCAT 1
#endif

#ifndef DK3_HAVE_STRCHR
/**	DK3 version of HAVE_STRCHR.
*/
#define DK3_HAVE_STRCHR 1
#endif

#ifndef DK3_HAVE_STRCMP
/**	DK3 version of HAVE_STRCMP.
*/
#define DK3_HAVE_STRCMP 1
#endif

#ifndef DK3_HAVE_STRCPY
/**	DK3 version of HAVE_STRCPY.
*/
#define DK3_HAVE_STRCPY 1
#endif

#ifndef DK3_HAVE_STRDUP
/**	DK3 version of HAVE_STRDUP.
*/
#define DK3_HAVE_STRDUP 1
#endif

#ifndef DK3_HAVE_STRERROR
/**	DK3 version of HAVE_STRERROR.
*/
#define DK3_HAVE_STRERROR 1
#endif

#ifndef DK3_HAVE_STRICMP
/**	DK3 version of HAVE_STRICMP.
*/
#define DK3_HAVE_STRICMP 0
#endif

#ifndef DK3_HAVE_STRINGS_H
/**	DK3 version of HAVE_STRINGS_H.
*/
#define DK3_HAVE_STRINGS_H 1
#endif

#ifndef DK3_HAVE_STRING_H
/**	DK3 version of HAVE_STRING_H.
*/
#define DK3_HAVE_STRING_H 1
#endif

#ifndef DK3_HAVE_STRLEN
/**	DK3 version of HAVE_STRLEN.
*/
#define DK3_HAVE_STRLEN 1
#endif

#ifndef DK3_HAVE_STRNCMP
/**	DK3 version of HAVE_STRNCMP.
*/
#define DK3_HAVE_STRNCMP 1
#endif

#ifndef DK3_HAVE_STRNCPY
/**	DK3 version of HAVE_STRNCPY.
*/
#define DK3_HAVE_STRNCPY 1
#endif

#ifndef DK3_HAVE_STROPTS_H
/**	DK3 version of HAVE_STROPTS_H.
*/
#define DK3_HAVE_STROPTS_H 0
#endif

#ifndef DK3_HAVE_STRRCHR
/**	DK3 version of HAVE_STRRCHR.
*/
#define DK3_HAVE_STRRCHR 1
#endif

#ifndef DK3_HAVE_STRTOD
/**	DK3 version of HAVE_STRTOD.
*/
#define DK3_HAVE_STRTOD 1
#endif

#ifndef DK3_HAVE_STRTOIMAX
/**	DK3 version of HAVE_STRTOIMAX.
*/
#define DK3_HAVE_STRTOIMAX 1
#endif

#ifndef DK3_HAVE_STRTOL
/**	DK3 version of HAVE_STRTOL.
*/
#define DK3_HAVE_STRTOL 1
#endif

#ifndef DK3_HAVE_STRTOLL
/**	DK3 version of HAVE_STRTOLL.
*/
#define DK3_HAVE_STRTOLL 1
#endif

#ifndef DK3_HAVE_STRTOUL
/**	DK3 version of HAVE_STRTOUL.
*/
#define DK3_HAVE_STRTOUL 1
#endif

#ifndef DK3_HAVE_STRTOULL
/**	DK3 version of HAVE_STRTOULL.
*/
#define DK3_HAVE_STRTOULL 1
#endif

#ifndef DK3_HAVE_STRTOUMAX
/**	DK3 version of HAVE_STRTOUMAX.
*/
#define DK3_HAVE_STRTOUMAX 1
#endif

#ifndef DK3_HAVE_STRUCT_ADDRINFO
/**	DK3 version of HAVE_STRUCT_ADDRINFO.
*/
#define DK3_HAVE_STRUCT_ADDRINFO 1
#endif

#ifndef DK3_HAVE_STRUCT_SOCKADDR_IN
/**	DK3 version of HAVE_STRUCT_SOCKADDR_IN.
*/
#define DK3_HAVE_STRUCT_SOCKADDR_IN 1
#endif

#ifndef DK3_HAVE_STRUCT_SOCKADDR_IN6
/**	DK3 version of HAVE_STRUCT_SOCKADDR_IN6.
*/
#define DK3_HAVE_STRUCT_SOCKADDR_IN6 1
#endif

#ifndef DK3_HAVE_STRUCT_SOCKADDR_STORAGE
/**	DK3 version of HAVE_STRUCT_SOCKADDR_STORAGE.
*/
#define DK3_HAVE_STRUCT_SOCKADDR_STORAGE 1
#endif

#ifndef DK3_HAVE_STRUCT_SOCKADDR_UN
/**	DK3 version of HAVE_STRUCT_SOCKADDR_UN.
*/
#define DK3_HAVE_STRUCT_SOCKADDR_UN 1
#endif

#ifndef DK3_HAVE_SYSCONF
/**	DK3 version of HAVE_SYSCONF.
*/
#define DK3_HAVE_SYSCONF 1
#endif

#ifndef DK3_HAVE_SYSCTL
/**	DK3 version of HAVE_SYSCTL.
*/
#define DK3_HAVE_SYSCTL 1
#endif

#ifndef DK3_HAVE_SYSLOG
/**	DK3 version of HAVE_SYSLOG.
*/
#define DK3_HAVE_SYSLOG 1
#endif

#ifndef DK3_HAVE_SYSLOG_H
/**	DK3 version of HAVE_SYSLOG_H.
*/
#define DK3_HAVE_SYSLOG_H 1
#endif

#ifndef DK3_HAVE_SYSRES_H
/**	DK3 version of HAVE_SYSRES_H.
*/
#define DK3_HAVE_SYSRES_H 0
#endif

#ifndef DK3_HAVE_SYS_FILE_H
/**	DK3 version of HAVE_SYS_FILE_H.
*/
#define DK3_HAVE_SYS_FILE_H 1
#endif

#ifndef DK3_HAVE_SYS_PARAM_H
/**	DK3 version of HAVE_SYS_PARAM_H.
*/
#define DK3_HAVE_SYS_PARAM_H 1
#endif

#ifndef DK3_HAVE_SYS_RESOURCE_H
/**	DK3 version of HAVE_SYS_RESOURCE_H.
*/
#define DK3_HAVE_SYS_RESOURCE_H 1
#endif

#ifndef DK3_HAVE_SYS_SOCKET_H
/**	DK3 version of HAVE_SYS_SOCKET_H.
*/
#define DK3_HAVE_SYS_SOCKET_H 1
#endif

#ifndef DK3_HAVE_SYS_STATVFS_H
/**	DK3 version of HAVE_SYS_STATVFS_H.
*/
#define DK3_HAVE_SYS_STATVFS_H 1
#endif

#ifndef DK3_HAVE_SYS_STAT_H
/**	DK3 version of HAVE_SYS_STAT_H.
*/
#define DK3_HAVE_SYS_STAT_H 1
#endif

#ifndef DK3_HAVE_SYS_STROPTS_H
/**	DK3 version of HAVE_SYS_STROPTS_H.
*/
#define DK3_HAVE_SYS_STROPTS_H 0
#endif

#ifndef DK3_HAVE_SYS_SUNDDI_H
/**	DK3 version of HAVE_SYS_SUNDDI_H.
*/
#define DK3_HAVE_SYS_SUNDDI_H 0
#endif

#ifndef DK3_HAVE_SYS_SYSCTL_H
/**	DK3 version of HAVE_SYS_SYSCTL_H.
*/
#define DK3_HAVE_SYS_SYSCTL_H 1
#endif

#ifndef DK3_HAVE_SYS_SYSTEMINFO_H
/**	DK3 version of HAVE_SYS_SYSTEMINFO_H.
*/
#define DK3_HAVE_SYS_SYSTEMINFO_H 0
#endif

#ifndef DK3_HAVE_SYS_TERMIOS_H
/**	DK3 version of HAVE_SYS_TERMIOS_H.
*/
#define DK3_HAVE_SYS_TERMIOS_H 1
#endif

#ifndef DK3_HAVE_SYS_TIME_H
/**	DK3 version of HAVE_SYS_TIME_H.
*/
#define DK3_HAVE_SYS_TIME_H 1
#endif

#ifndef DK3_HAVE_SYS_TTOLD_H
/**	DK3 version of HAVE_SYS_TTOLD_H.
*/
#define DK3_HAVE_SYS_TTOLD_H 0
#endif

#ifndef DK3_HAVE_SYS_TYPES_H
/**	DK3 version of HAVE_SYS_TYPES_H.
*/
#define DK3_HAVE_SYS_TYPES_H 1
#endif

#ifndef DK3_HAVE_SYS_UIO_H
/**	DK3 version of HAVE_SYS_UIO_H.
*/
#define DK3_HAVE_SYS_UIO_H 1
#endif

#ifndef DK3_HAVE_SYS_UN_H
/**	DK3 version of HAVE_SYS_UN_H.
*/
#define DK3_HAVE_SYS_UN_H 1
#endif

#ifndef DK3_HAVE_SYS_WAIT_H
/**	DK3 version of HAVE_SYS_WAIT_H.
*/
#define DK3_HAVE_SYS_WAIT_H 1
#endif

#ifndef DK3_HAVE_TANHL
/**	DK3 version of HAVE_TANHL.
*/
#define DK3_HAVE_TANHL 1
#endif

#ifndef DK3_HAVE_TANL
/**	DK3 version of HAVE_TANL.
*/
#define DK3_HAVE_TANL 1
#endif

#ifndef DK3_HAVE_TCFLUSH
/**	DK3 version of HAVE_TCFLUSH.
*/
#define DK3_HAVE_TCFLUSH 1
#endif

#ifndef DK3_HAVE_TCGETATTR
/**	DK3 version of HAVE_TCGETATTR.
*/
#define DK3_HAVE_TCGETATTR 1
#endif

#ifndef DK3_HAVE_TERMIOS_H
/**	DK3 version of HAVE_TERMIOS_H.
*/
#define DK3_HAVE_TERMIOS_H 1
#endif

#ifndef DK3_HAVE_TIFF_H
/**	DK3 version of HAVE_TIFF_H.
*/
#define DK3_HAVE_TIFF_H 1
#endif

#ifndef DK3_HAVE_TIME
/**	DK3 version of HAVE_TIME.
*/
#define DK3_HAVE_TIME 1
#endif

#ifndef DK3_HAVE_TIME_H
/**	DK3 version of HAVE_TIME_H.
*/
#define DK3_HAVE_TIME_H 1
#endif

#ifndef DK3_HAVE_TWOS_COMPLEMENT
/**	DK3 version of HAVE_TWOS_COMPLEMENT.
*/
#define DK3_HAVE_TWOS_COMPLEMENT 1
#endif

#ifndef DK3_HAVE_UMASK
/**	DK3 version of HAVE_UMASK.
*/
#define DK3_HAVE_UMASK 1
#endif

#ifndef DK3_HAVE_UNISTD_H
/**	DK3 version of HAVE_UNISTD_H.
*/
#define DK3_HAVE_UNISTD_H 1
#endif

#ifndef DK3_HAVE_UNLINK
/**	DK3 version of HAVE_UNLINK.
*/
#define DK3_HAVE_UNLINK 1
#endif

#ifndef DK3_HAVE_USER_NAMES_CASE_INSENSITIVE
/**	DK3 version of HAVE_USER_NAMES_CASE_INSENSITIVE.
*/
#define DK3_HAVE_USER_NAMES_CASE_INSENSITIVE 0
#endif

#ifndef DK3_HAVE_VARARGS_H
/**	DK3 version of HAVE_VARARGS_H.
*/
#define DK3_HAVE_VARARGS_H 0
#endif

#ifndef DK3_HAVE_VARARG_H
/**	DK3 version of HAVE_VARARG_H.
*/
#define DK3_HAVE_VARARG_H 0
#endif

#ifndef DK3_HAVE_VOLATILE
/**	DK3 version of HAVE_VOLATILE.
*/
#define DK3_HAVE_VOLATILE 1
#endif

#ifndef DK3_HAVE_WCHAR_H
/**	DK3 version of HAVE_WCHAR_H.
*/
#define DK3_HAVE_WCHAR_H 1
#endif

#ifndef DK3_HAVE_WCHAR_T
/**	DK3 version of HAVE_WCHAR_T.
*/
#define DK3_HAVE_WCHAR_T 1
#endif

#ifndef DK3_HAVE_WCSCAT
/**	DK3 version of HAVE_WCSCAT.
*/
#define DK3_HAVE_WCSCAT 1
#endif

#ifndef DK3_HAVE_WCSCHR
/**	DK3 version of HAVE_WCSCHR.
*/
#define DK3_HAVE_WCSCHR 1
#endif

#ifndef DK3_HAVE_WCSCMP
/**	DK3 version of HAVE_WCSCMP.
*/
#define DK3_HAVE_WCSCMP 1
#endif

#ifndef DK3_HAVE_WCSCPY
/**	DK3 version of HAVE_WCSCPY.
*/
#define DK3_HAVE_WCSCPY 1
#endif

#ifndef DK3_HAVE_WCSDUP
/**	DK3 version of HAVE_WCSDUP.
*/
#define DK3_HAVE_WCSDUP 1
#endif

#ifndef DK3_HAVE_WCSICMP
/**	DK3 version of HAVE_WCSICMP.
*/
#define DK3_HAVE_WCSICMP 0
#endif

#ifndef DK3_HAVE_WCSLEN
/**	DK3 version of HAVE_WCSLEN.
*/
#define DK3_HAVE_WCSLEN 1
#endif

#ifndef DK3_HAVE_WCSNCMP
/**	DK3 version of HAVE_WCSNCMP.
*/
#define DK3_HAVE_WCSNCMP 1
#endif

#ifndef DK3_HAVE_WCSNCPY
/**	DK3 version of HAVE_WCSNCPY.
*/
#define DK3_HAVE_WCSNCPY 1
#endif

#ifndef DK3_HAVE_WCSRCHR
/**	DK3 version of HAVE_WCSRCHR.
*/
#define DK3_HAVE_WCSRCHR 1
#endif

#ifndef DK3_HAVE_WCSTOD
/**	DK3 version of HAVE_WCSTOD.
*/
#define DK3_HAVE_WCSTOD 1
#endif

#ifndef DK3_HAVE_WCSTOIMAX
/**	DK3 version of HAVE_WCSTOIMAX.
*/
#define DK3_HAVE_WCSTOIMAX 1
#endif

#ifndef DK3_HAVE_WCSTOL
/**	DK3 version of HAVE_WCSTOL.
*/
#define DK3_HAVE_WCSTOL 1
#endif

#ifndef DK3_HAVE_WCSTOLL
/**	DK3 version of HAVE_WCSTOLL.
*/
#define DK3_HAVE_WCSTOLL 1
#endif

#ifndef DK3_HAVE_WCSTOUL
/**	DK3 version of HAVE_WCSTOUL.
*/
#define DK3_HAVE_WCSTOUL 1
#endif

#ifndef DK3_HAVE_WCSTOULL
/**	DK3 version of HAVE_WCSTOULL.
*/
#define DK3_HAVE_WCSTOULL 1
#endif

#ifndef DK3_HAVE_WCSTOUMAX
/**	DK3 version of HAVE_WCSTOUMAX.
*/
#define DK3_HAVE_WCSTOUMAX 1
#endif

#ifndef DK3_HAVE_WINBASE_H
/**	DK3 version of HAVE_WINBASE_H.
*/
#define DK3_HAVE_WINBASE_H 0
#endif

#ifndef DK3_HAVE_WINCON_H
/**	DK3 version of HAVE_WINCON_H.
*/
#define DK3_HAVE_WINCON_H 0
#endif

#ifndef DK3_HAVE_WINDOWS_H
/**	DK3 version of HAVE_WINDOWS_H.
*/
#define DK3_HAVE_WINDOWS_H 0
#endif

#ifndef DK3_HAVE_WINREG_H
/**	DK3 version of HAVE_WINREG_H.
*/
#define DK3_HAVE_WINREG_H 0
#endif

#ifndef DK3_HAVE_WINSOCK2_H
/**	DK3 version of HAVE_WINSOCK2_H.
*/
#define DK3_HAVE_WINSOCK2_H 0
#endif

#ifndef DK3_HAVE_WRITE
/**	DK3 version of HAVE_WRITE.
*/
#define DK3_HAVE_WRITE 1
#endif

#ifndef DK3_HAVE_WS2TCPIP_H
/**	DK3 version of HAVE_WS2TCPIP_H.
*/
#define DK3_HAVE_WS2TCPIP_H 0
#endif

#ifndef DK3_HAVE_ZLIB_H
/**	DK3 version of HAVE_ZLIB_H.
*/
#define DK3_HAVE_ZLIB_H 1
#endif

#ifndef DK3_HAVE__CLEARFP
/**	DK3 version of HAVE__CLEARFP.
*/
#define DK3_HAVE__CLEARFP 0
#endif

#ifndef DK3_HAVE__FCLOSE
/**	DK3 version of HAVE__FCLOSE.
*/
#define DK3_HAVE__FCLOSE 0
#endif

#ifndef DK3_HAVE__FEOF
/**	DK3 version of HAVE__FEOF.
*/
#define DK3_HAVE__FEOF 0
#endif

#ifndef DK3_HAVE__FERROR
/**	DK3 version of HAVE__FERROR.
*/
#define DK3_HAVE__FERROR 0
#endif

#ifndef DK3_HAVE__FFLUSH
/**	DK3 version of HAVE__FFLUSH.
*/
#define DK3_HAVE__FFLUSH 0
#endif

#ifndef DK3_HAVE__FOPEN
/**	DK3 version of HAVE__FOPEN.
*/
#define DK3_HAVE__FOPEN 0
#endif

#ifndef DK3_HAVE__FREAD
/**	DK3 version of HAVE__FREAD.
*/
#define DK3_HAVE__FREAD 0
#endif

#ifndef DK3_HAVE__FWRITE
/**	DK3 version of HAVE__FWRITE.
*/
#define DK3_HAVE__FWRITE 0
#endif

#ifndef DK3_HAVE__GETCWD
/**	DK3 version of HAVE__GETCWD.
*/
#define DK3_HAVE__GETCWD 0
#endif

#ifndef DK3_HAVE__GETPID
/**	DK3 version of HAVE__GETPID.
*/
#define DK3_HAVE__GETPID 0
#endif

#ifndef DK3_HAVE__LSTAT
/**	DK3 version of HAVE__LSTAT.
*/
#define DK3_HAVE__LSTAT 0
#endif

#ifndef DK3_HAVE__LSTAT32
/**	DK3 version of HAVE__LSTAT32.
*/
#define DK3_HAVE__LSTAT32 0
#endif

#ifndef DK3_HAVE__LSTAT64
/**	DK3 version of HAVE__LSTAT64.
*/
#define DK3_HAVE__LSTAT64 0
#endif

#ifndef DK3_HAVE__MKDIR
/**	DK3 version of HAVE__MKDIR.
*/
#define DK3_HAVE__MKDIR 0
#endif

#ifndef DK3_HAVE__POPEN
/**	DK3 version of HAVE__POPEN.
*/
#define DK3_HAVE__POPEN 0
#endif

#ifndef DK3_HAVE__READ
/**	DK3 version of HAVE__READ.
*/
#define DK3_HAVE__READ 0
#endif

#ifndef DK3_HAVE__RMDIR
/**	DK3 version of HAVE__RMDIR.
*/
#define DK3_HAVE__RMDIR 0
#endif

#ifndef DK3_HAVE__SNPRINTF
/**	DK3 version of HAVE__SNPRINTF.
*/
#define DK3_HAVE__SNPRINTF 0
#endif

#ifndef DK3_HAVE__STAT
/**	DK3 version of HAVE__STAT.
*/
#define DK3_HAVE__STAT 0
#endif

#ifndef DK3_HAVE__STAT32
/**	DK3 version of HAVE__STAT32.
*/
#define DK3_HAVE__STAT32 0
#endif

#ifndef DK3_HAVE__STAT64
/**	DK3 version of HAVE__STAT64.
*/
#define DK3_HAVE__STAT64 0
#endif

#ifndef DK3_HAVE__STRDUP
/**	DK3 version of HAVE__STRDUP.
*/
#define DK3_HAVE__STRDUP 0
#endif

#ifndef DK3_HAVE__STRICMP
/**	DK3 version of HAVE__STRICMP.
*/
#define DK3_HAVE__STRICMP 0
#endif

#ifndef DK3_HAVE__UNLINK
/**	DK3 version of HAVE__UNLINK.
*/
#define DK3_HAVE__UNLINK 0
#endif

#ifndef DK3_HAVE__WCSCAT
/**	DK3 version of HAVE__WCSCAT.
*/
#define DK3_HAVE__WCSCAT 0
#endif

#ifndef DK3_HAVE__WCSCHR
/**	DK3 version of HAVE__WCSCHR.
*/
#define DK3_HAVE__WCSCHR 0
#endif

#ifndef DK3_HAVE__WCSCMP
/**	DK3 version of HAVE__WCSCMP.
*/
#define DK3_HAVE__WCSCMP 0
#endif

#ifndef DK3_HAVE__WCSCPY
/**	DK3 version of HAVE__WCSCPY.
*/
#define DK3_HAVE__WCSCPY 0
#endif

#ifndef DK3_HAVE__WCSDUP
/**	DK3 version of HAVE__WCSDUP.
*/
#define DK3_HAVE__WCSDUP 0
#endif

#ifndef DK3_HAVE__WCSICMP
/**	DK3 version of HAVE__WCSICMP.
*/
#define DK3_HAVE__WCSICMP 0
#endif

#ifndef DK3_HAVE__WCSLEN
/**	DK3 version of HAVE__WCSLEN.
*/
#define DK3_HAVE__WCSLEN 0
#endif

#ifndef DK3_HAVE__WCSNCMP
/**	DK3 version of HAVE__WCSNCMP.
*/
#define DK3_HAVE__WCSNCMP 0
#endif

#ifndef DK3_HAVE__WCSNCPY
/**	DK3 version of HAVE__WCSNCPY.
*/
#define DK3_HAVE__WCSNCPY 0
#endif

#ifndef DK3_HAVE__WCSRCHR
/**	DK3 version of HAVE__WCSRCHR.
*/
#define DK3_HAVE__WCSRCHR 0
#endif

#ifndef DK3_HAVE__WGETENV
/**	DK3 version of HAVE__WGETENV.
*/
#define DK3_HAVE__WGETENV 0
#endif

#ifndef DK3_HAVE__WRITE
/**	DK3 version of HAVE__WRITE.
*/
#define DK3_HAVE__WRITE 0
#endif

#ifndef DK3_TIME_WITH_SYS_TIME
/**	DK3 version of TIME_WITH_SYS_TIME.
*/
#define DK3_TIME_WITH_SYS_TIME 1
#endif

#ifndef DK3_SIZEOF_DOUBLE
/**	DK3 version of SIZEOF_DOUBLE.
*/
#define DK3_SIZEOF_DOUBLE 8
#endif

#ifndef DK3_SIZEOF_INT
/**	DK3 version of SIZEOF_INT.
*/
#define DK3_SIZEOF_INT 4
#endif

#ifndef DK3_SIZEOF_INTMAX_T
/**	DK3 version of SIZEOF_INTMAX_T.
*/
#define DK3_SIZEOF_INTMAX_T 8
#endif

#ifndef DK3_SIZEOF_LONG
/**	DK3 version of SIZEOF_LONG.
*/
#define DK3_SIZEOF_LONG 4
#endif

#ifndef DK3_SIZEOF_LONG_DOUBLE
/**	DK3 version of SIZEOF_LONG_DOUBLE.
*/
#define DK3_SIZEOF_LONG_DOUBLE 12
#endif

#ifndef DK3_SIZEOF_LONG_LONG
/**	DK3 version of SIZEOF_LONG_LONG.
*/
#define DK3_SIZEOF_LONG_LONG 8
#endif

#ifndef DK3_SIZEOF_SHORT
/**	DK3 version of SIZEOF_SHORT.
*/
#define DK3_SIZEOF_SHORT 2
#endif

#ifndef DK3_SIZEOF_SIZE_T
/**	DK3 version of SIZEOF_SIZE_T.
*/
#define DK3_SIZEOF_SIZE_T 4
#endif

#ifndef DK3_SIZEOF_WCHAR_T
/**	DK3 version of SIZEOF_WCHAR_T.
*/
#define DK3_SIZEOF_WCHAR_T 4
#endif

#endif
/* if DK3_ON_WINDOWS */

#ifndef DK3_WORDS_BIGENDIAN
/**	Little-endian.
*/
#define DK3_WORDS_BIGENDIAN 0
#endif

#ifndef DK3_MAX_PATH
/**	Maximum path length.
*/
#define DK3_MAX_PATH 4097
#endif

#endif
/* ifndef DK3_CONF_H_INCLUDED */

