/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3chks.ctr
*/

/*
Copyright (C) 2011-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file */

#ifndef DK3CHKS_H_INCLUDED
/** Avoid multiple inclusions. */
#define DK3CHKS_H_INCLUDED 1


#line 10 "dk3chks.ctr"

#include "dk3conf.h"
#include "dk3types.h"

#ifdef __cplusplus
extern "C" {
#endif

/**	Get checksum type for a given name.
	@param	n	Message digest name ("MD5", "SHA-1", "SHA-224",
	"SHA-256", "SHA-384", "SHA-512", or "RIPEMD-160").
	@param	app	Application structure for diagnostics, may be NULL.
	@return	Integer representation (see @ref mdtypes) on success,
	-1 on error.
*/
int
dk3checksum_get_type_app(dkChar const *n, dk3_app_t *app);

/**	Build checksum for a file.
	@param	db	Destination buffer.
	@param	sz	Size of destination buffer.
	@param	fn	File name to process.
	@param	cst	Checksum type (message digest type,
	see @ref mdtypes).
	@param	cse	Binary to text encoding for message digest
	(see @ref dataencoding).
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3checksum_build_app(
  char *db, size_t sz, dkChar const *fn, int cst, int cse, dk3_app_t *app
);

/**	Get string length produced for a message digest and encoding type.
	@param	cst	Message digest type, see @ref mdtypes.
	@param	cse	Binary to text encoding, see @ref dataencoding.
	@return	Number of characters produced.
*/
size_t
dk3checksum_length(int cst, int cse);

/**	Get name for message digest type.
	@param	tp	Digest type, see @ref mdtypes.
	@return	Name for digest type.
*/
dkChar const *
dk3checksum_get_type_name(int tp);

#ifdef __cplusplus
}
#endif




#endif
