/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3bmj.ctr
*/

/*
Copyright (C) 2011-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file dk3bmj.h Header file for the dk3bmj module.
*/

#ifndef DK3BMJ_H_INCLUDED
/** Avoid multiple inclusions. */
#define DK3BMJ_H_INCLUDED 1


#line 10 "dk3bmj.ctr"

#ifdef __cplusplus
extern "C" {
#endif

/**	Initialize job structure.
	@param	job	Structure to initialize.
	@param	app	Application structure for diagnostics.
*/
void
dk3bmj_init(dk3_bm_conversion_job_t *job, dk3_app_t *app);

/**	Write a log message.
	@param	app	Application structure.
	@param	ll	Log level.
	@param	i	Index of message text in internal array.
	@param	dest	Destination, combination of DK3_BMJ_LOG_xxx,
			see @ref bmepslogtargets.
	@param	job	Job structure.
*/
void
dk3bmj_log_i1(
  dk3_app_t			*app,
  int				 ll,
  size_t			 i,
  int				 dest,
  dk3_bm_conversion_job_t	*job
);

/**	Write a log message.
	@param	app	Application structure.
	@param	ll	Log level.
	@param	i1	Index of first message text in internal array.
	@param	i2	Index of third message text in internal array.
	@param	txt	Second message text.
	@param	dest	Destination, combination of DK3_BMJ_LOG_xxx,
			see @ref bmepslogtargets.
	@param	job	Job structure.
*/
void
dk3bmj_log_i3(
  dk3_app_t			*app,
  int				 ll,
  size_t			 i1,
  size_t			 i2,
  dkChar const			*txt,
  int				 dest,
  dk3_bm_conversion_job_t	*job
);

/**	Write a log message.
	@param	app	Application structure.
	@param	ll	Log level.
	@param	i1	Index of first message text in internal array.
	@param	i2	Index of third message text in internal array.
	@param	i3	Index of fifth message text in internal array.
	@param	txt1	Second message text.
	@param	txt2	Fourth message text.
	@param	dest	Destination, combination of DK3_BMJ_LOG_xxx,
			see @ref bmepslogtargets.
	@param	job	Job structure.
*/
void
dk3bmj_log_i5(
  dk3_app_t			*app,
  int				 ll,
  size_t			 i1,
  size_t			 i2,
  size_t			 i3,
  dkChar const			*txt1,
  dkChar const			*txt2,
  int				 dest,
  dk3_bm_conversion_job_t	*job
);

/**	Write a log message.
	@param	app	Application structure.
	@param	ll	Log level.
	@param	txta	Localized message texts.
	@param	i	Index of message text in @a txta.
	@param	dest	Destination, combination of DK3_BMJ_LOG_xxx,
			see @ref bmepslogtargets.
	@param	job	Job structure.
*/
void
dk3bmj_log_1(
  dk3_app_t			*app,
  int				 ll,
  dkChar const * const		*txta,
  size_t			 i,
  int				 dest,
  dk3_bm_conversion_job_t	*job
);

/**	Write a log message.
	@param	app	Application structure.
	@param	ll	Log level.
	@param	txta	Localized message texts.
	@param	i1	Index of first message text in @a txta.
	@param	i2	Index of third message text in @a txta.
	@param	txt	Second message text.
	@param	dest	Destination, combination of DK3_BMJ_LOG_xxx,
			see @ref bmepslogtargets.
	@param	job	Job structure.
*/
void
dk3bmj_log_3(
  dk3_app_t			*app,
  int				 ll,
  dkChar const * const		*txta,
  size_t			 i1,
  size_t			 i2,
  dkChar const			*txt,
  int				 dest,
  dk3_bm_conversion_job_t	*job
);

/**	Write a log message.
	@param	app	Application structure.
	@param	ll	Log level.
	@param	txta	Localized message texts.
	@param	i1	Index of first message text in @a txta.
	@param	i2	Index of third message text in @a txta.
	@param	i3	Index of fifth message text in @a txta.
	@param	txt1	Second message text.
	@param	txt2	Fourth message text.
	@param	dest	Destination, combination of DK3_BMJ_LOG_xxx,
			see @ref bmepslogtargets.
	@param	job	Job structure.
*/
void
dk3bmj_log_5(
  dk3_app_t			*app,
  int				 ll,
  dkChar const * const		*txta,
  size_t			 i1,
  size_t			 i2,
  size_t			 i3,
  dkChar const			*txt1,
  dkChar const			*txt2,
  int				 dest,
  dk3_bm_conversion_job_t	*job
);

/**	Set new value for progress bar.
	@param	pc	Communicator object pointer.
	@param	val	New value (0-1000).
*/
void
dk3bmj_progress(void *pc, int val);

/**	Show progress for completed image scanlines.
	@param	pc	Communicator object.
	@param	min	Minimum progress bar value.
	@param	max	Maximum progress bar value.
	@param	h	Image height (number of lines).
	@param	y	Current line completed.
*/
void
dk3bmj_lines_do_progress(
  void			*pc,
  int		 	min,
  int		 	max,
  dk3_bif_coord_t	h,
  dk3_bif_coord_t	y
);

/**	Show progress for completed image scanlines.
	Calls dk3bmj_lines_do_progress() if DK3_USE_WX is on,
	does nothing otherwise.
	@param	pc	Communicator object.
	@param	min	Minimum progress bar value.
	@param	max	Maximum progress bar value.
	@param	h	Image height (number of lines).
	@param	y	Current line completed.
*/
void
dk3bmj_lines_progress(
  void			*pc,
  int		 	min,
  int		 	max,
  dk3_bif_coord_t	h,
  dk3_bif_coord_t	y
);

/**	Show progress for completed image scanlines.
	@param	pc	Communicator object.
	@param	min	Minimum progress bar value.
	@param	max	Maximum progress bar value.
	@param	nObjects	Number of objects.
	@param	co	Current object number.
*/
void
dk3bmj_objects_do_progress(
  void			*pc,
  int			 min,
  int			 max,
  unsigned long		 nObjects,
  unsigned long		 co
);

/**	Show progress for completed image scanlines.
	Call dk3bmj_objects_do_progress() if DK3_USE_WX is on,
	do nothing otherwise.
	@param	pc	Communicator object.
	@param	min	Minimum progress bar value.
	@param	max	Maximum progress bar value.
	@param	nObjects	Number of objects.
	@param	co	Current object number.
*/
void
dk3bmj_obj_progress(
  void			*pc,
  int			 min,
  int			 max,
  unsigned long		 nObjects,
  unsigned long		 co
);

#ifdef __cplusplus
}
#endif


/**	@defgroup	bmepslogtargets	Log targets for bmeps3 and wxbmeps . */
/**@{*/
/**	Log destination:	Application structure.
*/
#define	DK3_BMJ_LOG_APP		1

/**	Log destination:	Job structure.
*/
#define	DK3_BMJ_LOG_JOB		2

/**	Log destination:	Application structure and job structure.
*/
#define	DK3_BMJ_LOG_BOTH	(DK3_BMJ_LOG_APP | DK3_BMJ_LOG_JOB)
/**@}*/



/**	@defgroup	bmepscompression	Compression type used by bmeps. 
*/
/**@{*/
/**	Output procedure: Uncompressed RGB.
*/
#define	DK3_BMEPS_RGB_UNCOMPRESSED	0

/**	Output procedure: Uncompressed gray.
*/
#define	DK3_BMEPS_GRAY_UNCOMPRESSED	1

/**	Output procedure: Run-length compressed RGB, separated color channels.
*/
#define	DK3_BMEPS_RGB_RUNLENGTH		2

/**	Output procedure: Run-length compressed gray.
*/
#define	DK3_BMEPS_GRAY_RUNLENGTH	3

/**	Output procedure: DCT-compressed RGB.
*/
#define	DK3_BMEPS_RGB_DCT		4

/**	Output procedure: DCT-compressed gray.
*/
#define	DK3_BMEPS_GRAY_DCT		5

/**	Output procedure: DCT-compressed CMYK.
*/
#define	DK3_BMEPS_CMYK_DCT		6

/**	Output procedure: Flate-compressed RGB.
*/
#define	DK3_BMEPS_RGB_FLATE		7

/**	Output procedure: Flate-compressed gray.
*/
#define	DK3_BMEPS_GRAY_FLATE		8

/**	Output procedure: Flate-compressed RGB with alpha (PDF output only).
*/
#define	DK3_BMEPS_RGB_ALPHA_FLATE	9

/**	Output procedure: Flate-compressed gray with alpha (PDF output only).
*/
#define	DK3_BMEPS_GRAY_ALPHA_FLATE	10	

/**@}*/




#endif
