/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3bmj.ctr
*/

/*
Copyright (C) 2011-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file dk3bmj.c The dk3bmj module.
*/


#line 303 "dk3bmj.ctr"

#if DK3_USE_WX
#include "wxbmeps.h"
#else
#include "dk3all.h"
#include "dk3bmj.h"
#include "dk3bmeps.h"
#endif





#line 315 "dk3bmj.ctr"



/**	Log level required for writing to the log text field in wxbmeps.
*/
static	int const	dk3bmj_required_log_level = DK3_LL_PROGRESS;



void
dk3bmj_init(dk3_bm_conversion_job_t *job, dk3_app_t *app)
{
  

#line 328 "dk3bmj.ctr"
  job->opt = NULL;
  if(app) {
    job->msg = dk3app_messages(
      app,
      dk3bmep_str_get_string_table_name(),
      (dkChar const **)dk3bmep_str_get_message_texts()
    );
    if(!(job->msg)) {
      job->msg = dk3bmep_str_get_message_texts();
    }
  } else {
    job->msg = dk3bmep_str_get_message_texts();
  }
  job->sfn = NULL;
  job->dfn = NULL;
  job->dfile = NULL;
  job->biftype = 0;
  job->bif = NULL;
  job->pComm = NULL;
  job->minpb = 0;
  job->maxpb = 0;
  job->do_translate = 0;
  job->x_translate = 0.0;
  job->y_translate = 0.0;
  job->do_rotate = 0;
  job->do_float_scale = 0;
  job->x_scale = 1.0;
  job->y_scale = 1.0;
  job->x_size = 0L;
  job->y_size = 0L;
  job->x_0 = 0.0;
  job->x_1 = 0.0;
  job->y_0 = 0.0;
  job->y_1 = 0.0;
  job->do_header_footer = 1;
  job->procedure = DK3_BMEPS_GRAY_UNCOMPRESSED;
  job->bpc = 8;
  job->nPages = 1;
  job->currentPage = 1;
  job->pdf = NULL; 

#line 368 "dk3bmj.ctr"
}



void
dk3bmj_progress(void *pc, int val)
{
  

#line 376 "dk3bmj.ctr"
#if DK3_USE_WX
  DkWxCommunicator	*pComm;
  if(pc) {	

#line 379 "dk3bmj.ctr"
    pComm = (DkWxCommunicator *)pc;
    pComm->updateGauge(val);
  }
#endif
  

#line 384 "dk3bmj.ctr"
}



void
dk3bmj_lines_do_progress(
  void			*pc,
  int		 	min,
  int		 	max,
  dk3_bif_coord_t	h,
  dk3_bif_coord_t	y
)
{
  

#line 398 "dk3bmj.ctr"
#if DK3_USE_WX
  {
  unsigned long ul;
  int		i;
  

#line 403 "dk3bmj.ctr"
  if((pc) && (max > min)) {	

#line 404 "dk3bmj.ctr"
    ul = (unsigned long)min
       + (((unsigned long)y + 1UL) * ((unsigned long)(max - min)))
       /(unsigned long)h;
    i = (int)ul;
    if(i < min) i = min;
    if(i > max) i = max;
    dk3bmj_progress(pc, i);
  } else {			

#line 412 "dk3bmj.ctr"
  }
  }
#endif
  

#line 416 "dk3bmj.ctr"
}



void
dk3bmj_lines_progress(
  void			*pc,
  int		 	min,
  int		 	max,
  dk3_bif_coord_t	h,
  dk3_bif_coord_t	y
)
{
#if DK3_USE_WX
  dk3bmj_lines_do_progress(pc, min, max, h, y);
#endif
}



void
dk3bmj_objects_do_progress(
  void			*pc,
  int			 min,
  int			 max,
  unsigned long		 nObjects,
  unsigned long		 co
)
{
  

#line 446 "dk3bmj.ctr"
#if DK3_USE_WX
  unsigned long	ul;	/* Temporary value. */
  int		i;	/* New progress bar value. */

  if((pc) && (max > min)) {	

#line 451 "dk3bmj.ctr"
    ul = (unsigned long)min
       + ((co + 1UL) * ((unsigned long)(max - min))) / nObjects;
    i = (int)ul;
    if(i < min) i = min;
    if(i > max) i = max;
    dk3bmj_progress(pc, i);
  } else {			

#line 458 "dk3bmj.ctr"
  }
#endif
  

#line 461 "dk3bmj.ctr"
}


void
dk3bmj_obj_progress(
  void			*pc,
  int			 min,
  int			 max,
  unsigned long		 nObjects,
  unsigned long		 co
)
{
#if DK3_USE_WX
  dk3bmj_objects_do_progress(pc, min, max, nObjects, co);
#endif
}



void
dk3bmj_log_i1(
  dk3_app_t			*app,
  int				 ll,
  size_t			 i,
  int				 dest,
  dk3_bm_conversion_job_t	*job
)
{
#if DK3_USE_WX
  dkChar const		*p1;	/* Log text. */
  DkWxCommunicator	*pComm;	/* Communicator object. */
#endif
  if(dest & DK3_BMJ_LOG_APP) {
    if(app) {
      dk3app_log_i1(app, ll, i);
    }
  }
#if DK3_USE_WX
  if((dest & DK3_BMJ_LOG_JOB) && (ll <= dk3bmj_required_log_level)) {
    if(job) {
      if(app) {
        pComm = (DkWxCommunicator *)(job->pComm);
        if(pComm) {
	  pComm->setLogLevel(ll);
          p1 = dk3app_localized(app, i);
	  if(p1) {
	    pComm->addDkText(p1);
	    pComm->nl();
	  }
        }
      }
    }
  }
#endif
}



void
dk3bmj_log_i3(
  dk3_app_t			*app,
  int				 ll,
  size_t			 i1,
  size_t			 i2,
  dkChar const			*txt,
  int				 dest,
  dk3_bm_conversion_job_t	*job
)
{
#if DK3_USE_WX
  dkChar const		*p1;	/* First message part. */
  dkChar const		*p2;	/* Last message part. */
  DkWxCommunicator	*pComm;	/* Communicator object. */
#endif
  if(dest & DK3_BMJ_LOG_APP) {
    if(app) {
      dk3app_log_i3(app, ll, i1, i2, txt);
    }
  }
#if DK3_USE_WX
  if((dest & DK3_BMJ_LOG_JOB) && (ll <= dk3bmj_required_log_level)) {
    if(job) {
      if(app) {
        pComm = (DkWxCommunicator *)(job->pComm);
        if(pComm) {
	  pComm->setLogLevel(ll);
          p1 = dk3app_localized(app, i1);
	  p2 = dk3app_localized(app, i2);
	  if((p1) && (p2)) {
	    pComm->addDkText(p1);
	    if(txt) {
	      pComm->addDkText(txt);
	    }
	    pComm->addDkText(p2);
	    pComm->nl();
	  }
        }
      }
    }
  }
#endif
}




void
dk3bmj_log_i5(
  dk3_app_t			*app,
  int				 ll,
  size_t			 i1,
  size_t			 i2,
  size_t			 i3,
  dkChar const			*txt1,
  dkChar const			*txt2,
  int				 dest,
  dk3_bm_conversion_job_t	*job
)
{
#if DK3_USE_WX
  dkChar const		*p1;	/* First message part. */
  dkChar const		*p2;	/* Centered message part. */
  dkChar const		*p3;	/* Last message part. */
  DkWxCommunicator	*pComm;	/* Communicator object. */
#endif
  if(dest & DK3_BMJ_LOG_APP) {
    if(app) {
      dk3app_log_i5(app, ll, i1, i2, i3, txt1, txt2);
    }
  }
#if DK3_USE_WX
  if((dest & DK3_BMJ_LOG_JOB) && (ll <= dk3bmj_required_log_level)) {
    if(job) {
      if(app) {
        pComm = (DkWxCommunicator *)(job->pComm);
        if(pComm) {
	  pComm->setLogLevel(ll);
          p1 = dk3app_localized(app, i1);
	  p2 = dk3app_localized(app, i2);
	  p3 = dk3app_localized(app, i3);
	  if((p1) && (p2) && (p3)) {
	    pComm->addDkText(p1);
	    if(txt1) {
	      pComm->addDkText(txt1);
	    }
	    pComm->addDkText(p2);
	    if(txt2) {
	      pComm->addDkText(txt2);
	    }
	    pComm->addDkText(p3);
	    pComm->nl();
	  }
        }
      }
    }
  }
#endif
}



void
dk3bmj_log_1(
  dk3_app_t			*app,
  int				 ll,
  dkChar const * const		*txta,
  size_t			 i,
  int				 dest,
  dk3_bm_conversion_job_t	*job
)
{
#if DK3_USE_WX
  dkChar const		*p1;	/* Message text. */
  DkWxCommunicator	*pComm;	/* Communicator object. */
#endif
  

#line 637 "dk3bmj.ctr"
  if(txta) {				

#line 638 "dk3bmj.ctr"
    if(dest & DK3_BMJ_LOG_APP) {	

#line 639 "dk3bmj.ctr"
      if(app) {				

#line 640 "dk3bmj.ctr"
        dk3app_log_1(app, ll, txta, i);
      } else {				

#line 642 "dk3bmj.ctr"
      }
    } else {				

#line 644 "dk3bmj.ctr"
    }
#if DK3_USE_WX
    if((dest & DK3_BMJ_LOG_JOB) && (ll <= dk3bmj_required_log_level)) { 

#line 647 "dk3bmj.ctr"
      if(job) {				

#line 648 "dk3bmj.ctr"
        if(app) {			

#line 649 "dk3bmj.ctr"
          pComm = (DkWxCommunicator *)(job->pComm);
          if(pComm) {			

#line 651 "dk3bmj.ctr"
	    pComm->setLogLevel(ll);
            p1 = txta[i];
	    if(p1) {			

#line 654 "dk3bmj.ctr"
	      pComm->addDkText(p1);
	      pComm->nl();
	    } else {			

#line 657 "dk3bmj.ctr"
	    }
          } else {			

#line 659 "dk3bmj.ctr"
	  }
        } else {			

#line 661 "dk3bmj.ctr"
	}
      } else {				

#line 663 "dk3bmj.ctr"
      }
    } else {				

#line 665 "dk3bmj.ctr"
    }
#endif
  } else {			

#line 668 "dk3bmj.ctr"
  } 

#line 669 "dk3bmj.ctr"
}



void
dk3bmj_log_3(
  dk3_app_t			*app,
  int				 ll,
  dkChar const * const		*txta,
  size_t			 i1,
  size_t			 i2,
  dkChar const			*txt,
  int				 dest,
  dk3_bm_conversion_job_t	*job
)
{
#if DK3_USE_WX
  dkChar const		*p1;	/* First message part. */
  dkChar const		*p2;	/* Last message part. */
  DkWxCommunicator	*pComm;	/* Communicator object. */
#endif
  if(txta) {
    if(dest & DK3_BMJ_LOG_APP) {
      if(app) {
        dk3app_log_3(app, ll, txta, i1, i2, txt);
      }
    }
#if DK3_USE_WX
    if((dest & DK3_BMJ_LOG_JOB) && (ll <= dk3bmj_required_log_level)) {
      if(job) {
        if(app) {
          pComm = (DkWxCommunicator *)(job->pComm);
          if(pComm) {
	    pComm->setLogLevel(ll);
            p1 = txta[i1];
	    p2 = txta[i2];
	    if((p1) && (p2)) {
	      pComm->addDkText(p1);
	      if(txt) {
	        pComm->addDkText(txt);
	      }
	      pComm->addDkText(p2);
	      pComm->nl();
	    }
          }
        }
      }
    }
#endif
  }
}




void
dk3bmj_log_5(
  dk3_app_t			*app,
  int				 ll,
  dkChar const * const		*txta,
  size_t			 i1,
  size_t			 i2,
  size_t			 i3,
  dkChar const			*txt1,
  dkChar const			*txt2,
  int				 dest,
  dk3_bm_conversion_job_t	*job
)
{
#if DK3_USE_WX
  dkChar const		*p1;	/* First message part. */
  dkChar const		*p2;	/* Centered message part. */
  dkChar const		*p3;	/* Last message part. */
  DkWxCommunicator	*pComm;	/* Communicator object. */
#endif
  if(txta) {
    if(dest & DK3_BMJ_LOG_APP) {
      if(app) {
        dk3app_log_5(app, ll, txta, i1, i2, i3, txt1, txt2);
      }
    }
#if DK3_USE_WX
    if((dest & DK3_BMJ_LOG_JOB) && (ll <= dk3bmj_required_log_level)) {
      if(job) {
        if(app) {
          pComm = (DkWxCommunicator *)(job->pComm);
          if(pComm) {
	    pComm->setLogLevel(ll);
            p1 = txta[i1];
	    p2 = txta[i2];
	    p3 = txta[i3];
	    if((p1) && (p2) && (p3)) {
	      pComm->addDkText(p1);
	      if(txt1) {
	        pComm->addDkText(txt1);
	      }
	      pComm->addDkText(p2);
	      if(txt2) {
	        pComm->addDkText(txt2);
	      }
	      pComm->addDkText(p3);
	      pComm->nl();
	    }
          }
        }
      }
    }
#endif
  }
}


