/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3bmeo.ctr
*/

/*
Copyright (C) 2011-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file dk3bmeo.h Header file for the dk3bmeo module.
*/

#ifndef DK3BMEO_H_INCLUDED
/** Avoid multiple inclusions. */
#define DK3BMEO_H_INCLUDED 1


#line 10 "dk3bmeo.ctr"

#ifdef __cplusplus
extern "C" {
#endif

/**	Initialize bmeps option set.
	@param	opt	Option set to initialize.
*/
void
dk3bmeo_init(dk3_bm_eps_options_t *opt);

/**	Allocate and initalize new option set.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	Pointer to new option set on success, NULL on error.
*/
dk3_bm_eps_options_t *
dk3bmeo_new_app(dk3_app_t *app);

/**	Get run mode.
	@param	opt	Option set.
	@return	Run mode DK3_BMEPS_MODE_xxx, see @ref dkbmmodes.
*/
int
dk3bmeo_get_mode(dk3_bm_eps_options_t *opt);

/**	Set output driver and mode.
	@param	opt	Option set.
	@param	driver	Output driver DK3_BMEPS_DRIVER_xxx,
	see @ref bmepsdrivers.
	@param	mode	Output mode DK3_BMEPS_MODE_xxx,
	see @ref dkbmmodes.
*/
void
dk3bmeo_set_driver_and_mode(dk3_bm_eps_options_t *opt, int driver, int mode);

/**	Set paper size by name.
	@param	opt	Option set.
	@param	psn	Paper size name.
	@return	1 on success, 0 on error.
*/
int
dk3bmeo_set_paper_size(dk3_bm_eps_options_t *opt, dkChar const *psn);

/**	Get output driver.
	@param	opt	Option set.
	@return	Output driver DK3_BMEPS_DRIVER_xxx, see @ref bmepsdrivers.
*/
int
dk3bmeo_get_driver(dk3_bm_eps_options_t *opt);

/**	Enable/disable draft mode.
	@param	opt	Option set.
	@param	drflag	1=draft, 0=normal.
*/
void
dk3bmeo_set_draft(dk3_bm_eps_options_t *opt, int drflag);

/**	Get draft mode setting.
	@param	opt	Option set.
	@return	1 for draft mode, 0 for normal mode.
*/
int
dk3bmeo_get_draft(dk3_bm_eps_options_t *opt);

/**	Set duplex printing.
	@param	opt	Option set.
	@param	duplex	Flag: Enable duplex output.
*/
void
dk3bmeo_set_duplex(dk3_bm_eps_options_t *opt, int duplex);

/**	Retrieve duplex setting.
	@param	opt	Option set.
	@return	1 for duplex, 0 for simplex output.
*/
int
dk3bmeo_get_duplex(dk3_bm_eps_options_t *opt);

/**	Set flate predictor.
	@param	opt	Option set.
	@param	pred	Predictor DK3_COMPRESSION_PREDICTOR_xxx, see
	@ref flatepredictors.
*/
void
dk3bmeo_set_predictor(dk3_bm_eps_options_t *opt, int pred);

/**	Get compression predictor.
	@param	opt	Option set.
	@return Predictor DK3_COMPRESSION_PREDICTOR_xxx,
	see @ref flatepredictors.
*/
int
dk3bmeo_get_predictor(dk3_bm_eps_options_t *opt);

/**	Set image origin.
	@param	opt	Option set.
	@param	io	Image origin DK3_IMAGE_ORIGIN_xxx, se @ref imageorigin.
*/
void
dk3bmeo_set_origin(dk3_bm_eps_options_t *opt, int io);

/**	Get image origin.
	@param	opt	Option set.
	@return	Image origin DK3_IMAGE_ORIGIN_xxx, se @ref imageorigin.
*/
int
dk3bmeo_get_origin(dk3_bm_eps_options_t *opt);

/**	Set PS level.
	@param	opt	Option set.
	@param	psl	PS level (2 or 3).
*/
void
dk3bmeo_set_ps_level(dk3_bm_eps_options_t *opt, int psl);

/**	Get PS level.
	@param	opt	Option set.
	@return	PS level (2 or 3).
*/
int
dk3bmeo_get_ps_level(dk3_bm_eps_options_t *opt);

/**	Enable/disable direct transfer of DCT data.
	@param	opt	Option set.
	@param	dct	1=enable, 0=disable.
*/
void
dk3bmeo_set_dct(dk3_bm_eps_options_t *opt, int dct);

/**	Get flag for direct DCT data transfer.
	@param	opt	Option set.
	@return	1=enabled, 0=disabled.
*/
int
dk3bmeo_get_dct(dk3_bm_eps_options_t *opt);

/**	Set flag to keep aspect ratio.
	@param	opt	Option set.
	@param	kar	1=keep aspect ratio, 0=allow different scales for
	x and y.
*/
void
dk3bmeo_set_keep_aspect_ratio(dk3_bm_eps_options_t *opt, int kar);

/**	Get flag for keeping aspect ratio.
	@param	opt	Option set.
	@return	1 for keep aspect ratio, 0 for allow different
	scaling for x and y.
*/
int
dk3bmeo_get_keep_aspect_ratio(dk3_bm_eps_options_t *opt);

/**	Set background.
	@param	opt	Option set.
	@param	r	Background red component.
	@param	g	Background green component.
	@param	b	Background blue component.
	@param	f	Flag: Force this background over background chunk
	from image file.
*/
void
dk3bmeo_set_background(dk3_bm_eps_options_t *opt, int r, int g, int b, int f);

/**	Get background red component.
	@param	opt	Option set.
	@return	Background red component.
*/
int
dk3bmeo_get_background_red(dk3_bm_eps_options_t *opt);

/**	Get background green component.
	@param	opt	Option set.
	@return	Background green component.
*/
int
dk3bmeo_get_background_green(dk3_bm_eps_options_t *opt);

/**	Get background blue component.
	@param	opt	Option set.
	@return	Background blue component.
*/
int
dk3bmeo_get_background_blue(dk3_bm_eps_options_t *opt);

/**	Get enforce background flag.
	@param	opt	Option set.
	@return	1 for enforce background over background chunk,
	0 for use background chunk if available.
*/
int
dk3bmeo_get_background_force(dk3_bm_eps_options_t *opt);

/**	Enable/disable image interpolation.
	@param	opt	Option set.
	@param	iip	Flag: Image interpolation allowed.
*/
void
dk3bmeo_set_interpolation(dk3_bm_eps_options_t *opt, int iip);

/**	Get image interpolation flag.
	@param	opt	Option set.
	@return	1 for image interpolation allowed, 0 for denied.
*/
int
dk3bmeo_get_interpolation(dk3_bm_eps_options_t *opt);

/**	Enable/disable image interpolation for JPEG files.
	@param	opt	Option set.
	@param	iip	Flag: Image interpolation for JPEGs allowed or denied.
*/
void
dk3bmeo_set_jpeg_interpolation(dk3_bm_eps_options_t *opt, int iip);

/**	Get image interpolation flag for JPEGs.
	@param	opt	Option set.
	@return	1 for image interpolation allowed, 0 for denied.
*/
int
dk3bmeo_get_jpeg_interpolation(dk3_bm_eps_options_t *opt);

/**	Destroy option set, release memory.
	@param	opt	Option set to destroy.
*/
void
dk3bmeo_delete(dk3_bm_eps_options_t *opt);

/**	Apply one text option (argument to -o) to option set.
	@param	opt	Option set to modify.
	@param	str	Option text.
	@param	msg	Message text array containing localized texts.
	@return	1 on success, 0 on error.
*/
int
dk3bmeo_apply_option(
  dk3_bm_eps_options_t	*opt,
  dkChar const		*str,
  dkChar const * const	*msg
);

/**	Set language (driver and mode, obtained from -l option).
	@param	opt	Option set to modify.
	@param	str	String containing configuration data.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3bmeo_set_language(
  dk3_bm_eps_options_t	*opt,
  dkChar const		*str,
  dk3_app_t		*app
);

/**	Check options consistency.
	On inconsistency, correct the options and return 0 so
	a second check will return 1.
	@param	opt	Option set.
	@param	type	Invokation type (0=bmeps/wxbmeps, 1=placed object).
	@param	app	Application structure for diagnostics, may be NULL.
	@param	job	Conversion job structure.
	@return	1 on success, 0 on error (corrections applied).
*/
int
dk3bmeo_check(
  dk3_bm_eps_options_t		*opt,
  int				 type,
  dk3_app_t			*app,
  dk3_bm_conversion_job_t	*job
);

/**	Attempt to find PS level and page size from preferences.
	@param	opt	Conversion option set, app must be initialized.
*/
void
dk3bmeo_apply_preferences(dk3_bm_eps_options_t *opt);

/**	Set size mode in option set.
	@param	opt	Option set.
	@param	newmode	new size mode DK3_BMEPS_SIZE_xxx,
	see @ref bmepssizehandling.
*/
void
dk3bmeo_set_szmode(dk3_bm_eps_options_t *opt, int newmode);

/**	Retrieve image size mode.
	@param	opt	Option set.
	@return	Size mode.
*/
int
dk3bmeo_get_szmode(dk3_bm_eps_options_t *opt);

/**	Set image resolution.
	@param	opt	Option set.
	@param	dpi	Resolution in dpi (dots per inch).
*/
void
dk3bmeo_set_resolution(dk3_bm_eps_options_t *opt, double dpi);

/**	Retrieve image resolution setting.
	@param	opt	Option set.
	@return	Resolution in dpi if set, 72.0 is used as default.
*/
double
dk3bmeo_get_resolution(dk3_bm_eps_options_t *opt);

#ifdef __cplusplus
}
#endif




#endif
