/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3bmeo.ctr
*/

/*
Copyright (C) 2011-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file dk3bmeo.c The dk3bmeo module.
*/


#line 321 "dk3bmeo.ctr"


#include "dk3all.h"
#include "dk3bmeo.h"
#include "dk3bmeps.h"
#include "dk3bmj.h"
#include "dk3bm.h"




#line 331 "dk3bmeo.ctr"



/**	Keywords used by the module.
*/
static dkChar const * const dk3bmeo_kw[] = {
/* 0 */
dkT("/print/paper-size"),

/* 1 */
dkT("1px1pt"),

/* 2 */
dkT("chunk"),

/* 3 */
dkT("1:1"),

/* 4 */
dkT("/print/ps/level"),

/* 5 */
dkT("%ld"),

NULL


#line 363 "dk3bmeo.ctr"
};



/**	Names for options.
*/
static dkChar const * const dk3bmeo_option_names[] = {
/* 0 */
dkT("level"),

/* 1 */
dkT("color"),

/* 2 */
dkT("dsc"),

/* 3 */
dkT("draft"),

/* 4 */
dkT("predictor"),

/* 5 */
dkT("duplex"),

/* 6 */
dkT("tumble"),

/* 7 */
dkT("dct"),

/* 8 */
dkT("bg"),

/* 9 */
dkT("interpolation"),

/* 10 */
dkT("jpeg-interpolation"),

/* 11 */
dkT("resolution"),

/* 12 */
dkT("paper"),

/* 13 */
dkT("make"),

/* 14 */
dkT("aspect"),

/* 15 */
dkT("bpc"),

NULL


#line 436 "dk3bmeo.ctr"
};



/**	Driver names.
*/
dkChar const * const	dk3bmeo_driver_names[] = {
/* 0 */
dkT("ps"),

/* 1 */
dkT("eps"),

/* 2 */
dkT("pdf"),

/* 3 */
dkT("bb"),

NULL


#line 449 "dk3bmeo.ctr"
};



/**	Mode names
*/
dkChar const * const    dk3bmeo_mode_names[] = {
/* 0 */
dkT("i$mage"),

/* 1 */
dkT("o$bject"),

/* 2 */
dkT("d$ocument"),

NULL


#line 470 "dk3bmeo.ctr"
};



/**	Names for flate compression predictors.
	Order must match DK3_COMPRESSION_PREDICTOR_xxx
	in dk3const.h, see @ref flatepredictors.
*/
dkChar const * const	dk3bmeo_predictor_names[] = {
/* 0 */
dkT("tiff"),

/* 1 */
dkT("sub"),

/* 2 */
dkT("up"),

/* 3 */
dkT("average"),

/* 4 */
dkT("paeth"),

NULL


#line 486 "dk3bmeo.ctr"
};




void
dk3bmeo_init(dk3_bm_eps_options_t *opt)
{
  

#line 495 "dk3bmeo.ctr"
  if(opt) {
    (opt->ima).ps.w = 595.0;
    (opt->ima).ps.h = 842.0;
    (opt->ima).ps.i = 0.0;
    (opt->ima).ps.o = 0.0;
    (opt->ima).ps.t = 0.0;
    (opt->ima).ps.b = 0.0;
    opt->resolution = 72.0;
    opt->app = NULL;
    opt->mode = DK3_BMEPS_MODE_OBJECT;
    opt->szmode = DK3_BMEPS_SIZE_1_1;	

#line 506 "dk3bmeo.ctr"
    opt->dr = DK3_BMEPS_DRIVER_PDF;
    opt->pred = 0;
    opt->io = 0;
    opt->draft = 0;
    opt->duplex = 0;
    opt->tumble = 0;
    opt->psl = 3;
    opt->dsc = 0;
    opt->dct = 1;
    opt->kar = 1;
    opt->bgr = 255; opt->bgg = 255; opt->bgb = 255; opt->fbg = 0;
    opt->ip = 1; opt->jip = 0;
    opt->make = 0;
    opt->color = 1;
    opt->to_stdout = 0;
    opt->rbpc = 1;
  } 

#line 523 "dk3bmeo.ctr"
}



dk3_bm_eps_options_t *
dk3bmeo_new_app(dk3_app_t *app)
{
  dk3_bm_eps_options_t	*back = NULL;
  

#line 532 "dk3bmeo.ctr"
  back = dk3_new_app(dk3_bm_eps_options_t,1,app);
  if(back) {
    dk3bmeo_init(back);
    back->app = app;
  } 

#line 537 "dk3bmeo.ctr"
  return back;
}



void
dk3bmeo_delete(dk3_bm_eps_options_t *opt)
{
  

#line 546 "dk3bmeo.ctr"
  if(opt) {
    opt->app = NULL;
    dk3_delete(opt);
  } 

#line 550 "dk3bmeo.ctr"
}



int
dk3bmeo_get_mode(dk3_bm_eps_options_t *opt)
{
  int back = DK3_BMEPS_MODE_IMAGE;
  

#line 559 "dk3bmeo.ctr"
  if(opt) {
    back = opt->mode;
  } 

#line 562 "dk3bmeo.ctr"
  return back;
}



/**	Set paper size, complain if named size is not found.
	@param	opt	Option set to receive size information.
	@param	psn	Paper size name.
	@param	cond	Flag: Complain (nonzero) or not (0).
	@return	1 on success, 0 on error.
*/
static
int
dk3bmeo_set_paper_size_complain(
  dk3_bm_eps_options_t *opt, dkChar const *psn, int cond
)
{
  dk3_paper_size_collection_t	*psc;    /* Paper size collection. */
  dk3_paper_size_t const	*pap;	 /* Paper size. */
  dkChar const * const		*msg;	 /* Localized message texts. */
  int			back	= 0;
  

#line 584 "dk3bmeo.ctr"
  msg = dk3app_messages(
    opt->app,
    dk3bmep_str_get_string_table_name(),
    (dkChar const **)dk3bmep_str_get_message_texts()
  );
  if(!(msg)) {
    msg = dk3bmep_str_get_message_texts();
  }
  if((opt) && (psn)) {			

#line 593 "dk3bmeo.ctr"
    if(opt->app) {			

#line 594 "dk3bmeo.ctr"
      psc = dk3paper_open_app(opt->app);
      if(psc) {			

#line 596 "dk3bmeo.ctr"
        pap = dk3paper_find(psc, psn);
        if(pap) {			

#line 598 "dk3bmeo.ctr"
          (opt->ima).ps.w = pap->w;
          (opt->ima).ps.h = pap->h;
          (opt->ima).ps.i = pap->i;
          (opt->ima).ps.o = pap->o;
          (opt->ima).ps.t = pap->t;
          (opt->ima).ps.b = pap->b;
	  back = 1;
        } else {			

#line 606 "dk3bmeo.ctr"
          /* ERROR: No such paper size. */
          dk3bmj_log_3(
	    opt->app, DK3_LL_ERROR,msg,39,40,psn,DK3_BMJ_LOG_BOTH,NULL
	  );
        }
        dk3paper_close(psc);
      } else {			

#line 613 "dk3bmeo.ctr"
      }
      if(!(opt->mode == DK3_BMEPS_MODE_DOCUMENT)) {	

#line 615 "dk3bmeo.ctr"
        /* ERROR: Not a document */
	if(cond) {
	  dk3bmj_log_1(opt->app, DK3_LL_ERROR,msg,38,DK3_BMJ_LOG_BOTH,NULL);
	}
      }
    } else {				

#line 621 "dk3bmeo.ctr"
      /* ERROR: No app! */
    }
  } else {				

#line 624 "dk3bmeo.ctr"
  } 

#line 625 "dk3bmeo.ctr"
  return back;
}



void
dk3bmeo_apply_preferences(dk3_bm_eps_options_t *opt)
{
  dkChar			psn[64]; /* Buffer for paper size name. */
  int				psl;	 /* PS level. */
  

#line 636 "dk3bmeo.ctr"
  if(opt->app) {
    if(dk3app_get_pref(opt->app,dk3bmeo_kw[0],psn,DK3_SIZEOF(psn,dkChar)))
    {
      (void)dk3bmeo_set_paper_size_complain(opt, psn, 0);
    }
    if(dk3app_get_pref(opt->app,dk3bmeo_kw[4],psn,DK3_SIZEOF(psn,dkChar)))
    {
#if VERSION_BEFORE_20140716
      if(dk3sf_sscanf3(psn, dk3bmeo_kw[5], &psl) == 1)
#else
      if (0 != dk3ma_i_from_string(&psl, psn, NULL))
#endif
      {
        if(psl > 3) { psl = 3; }
	if(psl < 2) { psl = 2; }
	opt->psl = psl;
      }
    }
  }
  

#line 656 "dk3bmeo.ctr"
}



/**	Initialize for a given driver and mode.
	@param	opt	Option set to complete setup.
*/
static
void
dk3bmeo_initialize_for_driver_and_mode(dk3_bm_eps_options_t *opt)
{
  switch(opt->dr) {
    case DK3_BMEPS_DRIVER_PS: {
    } break;
    case DK3_BMEPS_DRIVER_EPS: {
    } break;
    case DK3_BMEPS_DRIVER_PDF: {
    } break;
    case DK3_BMEPS_DRIVER_BB: {
      opt->mode = DK3_BMEPS_MODE_OBJECT;
    } break;
  }
  switch(opt->mode) {
    case DK3_BMEPS_MODE_IMAGE: {
      opt->szmode = DK3_BMEPS_SIZE_CHUNK;	

#line 681 "dk3bmeo.ctr"
    } break;
    case DK3_BMEPS_MODE_OBJECT: {
      opt->szmode = DK3_BMEPS_SIZE_1_1;		

#line 684 "dk3bmeo.ctr"
    } break;
    case DK3_BMEPS_MODE_DOCUMENT: {		

#line 686 "dk3bmeo.ctr"
      opt->szmode = DK3_BMEPS_SIZE_PAPER;
      if(opt->dr == DK3_BMEPS_DRIVER_PS) {
        opt->dsc = 1;
      }
    } break;
  }
  (opt->ima).ps.w = 595.0;
  (opt->ima).ps.h = 842.0;
  if(opt->mode == DK3_BMEPS_MODE_DOCUMENT) {
    /*
      	The option -l ps.document is typically used for fax TIFF files
	which already have a border. So we do not need an additional border.
    */
    (opt->ima).ps.i = 0.0;
    (opt->ima).ps.o = 0.0;
    (opt->ima).ps.t = 0.0;
    (opt->ima).ps.b = 0.0;
    opt->szmode = DK3_BMEPS_SIZE_PAPER;		

#line 704 "dk3bmeo.ctr"
  } else {
    (opt->ima).ps.i = 56.0;
    (opt->ima).ps.o = 28.0;
    (opt->ima).ps.t = 14.0;
    (opt->ima).ps.b = 14.0;
  }
  dk3bmeo_apply_preferences(opt);
}




void
dk3bmeo_set_driver_and_mode(dk3_bm_eps_options_t *opt, int driver, int mode)
{
  

#line 720 "dk3bmeo.ctr"
  if(opt) {
    opt->dr = driver;
    opt->mode = mode;
    dk3bmeo_initialize_for_driver_and_mode(opt);
  } 

#line 725 "dk3bmeo.ctr"
}



int
dk3bmeo_set_paper_size(dk3_bm_eps_options_t *opt, dkChar const *psn)
{
  int back;
  back = dk3bmeo_set_paper_size_complain(opt, psn, 1);
  return back;
}



int
dk3bmeo_get_driver(dk3_bm_eps_options_t *opt)
{
  int back = DK3_BMEPS_DRIVER_PS;
  

#line 744 "dk3bmeo.ctr"
  if(opt) {
    back = opt->dr;
  } 

#line 747 "dk3bmeo.ctr"
  return back;
}



void
dk3bmeo_set_draft(dk3_bm_eps_options_t *opt, int drflag)
{
  

#line 756 "dk3bmeo.ctr"
  if(opt) {
    opt->draft = drflag;
  } 

#line 759 "dk3bmeo.ctr"
}



int
dk3bmeo_get_draft(dk3_bm_eps_options_t *opt)
{
  int back = 0;
  

#line 768 "dk3bmeo.ctr"
  if(opt) {
    back = ((opt->draft) ? 1 : 0);
  } 

#line 771 "dk3bmeo.ctr"
  return back;
}



void
dk3bmeo_set_duplex(dk3_bm_eps_options_t *opt, int duplex)
{
  

#line 780 "dk3bmeo.ctr"
  if(opt) {
    opt->duplex = duplex;
  } 

#line 783 "dk3bmeo.ctr"
}



int
dk3bmeo_get_duplex(dk3_bm_eps_options_t *opt)
{
  int back = 0;
  

#line 792 "dk3bmeo.ctr"
  if(opt) {
    back = ((opt->duplex) ? 1 : 0);
  } 

#line 795 "dk3bmeo.ctr"
  return back;
}



void
dk3bmeo_set_predictor(dk3_bm_eps_options_t *opt, int pred)
{
  

#line 804 "dk3bmeo.ctr"
  if(opt) {
    opt->pred = pred;
  } 

#line 807 "dk3bmeo.ctr"
}



int
dk3bmeo_get_predictor(dk3_bm_eps_options_t *opt)
{
  int back = 0;
  

#line 816 "dk3bmeo.ctr"
  if(opt) {
    back = opt->pred;
  } 

#line 819 "dk3bmeo.ctr"
  return back;
}



void
dk3bmeo_set_origin(dk3_bm_eps_options_t *opt, int io)
{
  

#line 828 "dk3bmeo.ctr"
  if(opt) {
    opt->io = io;
  } 

#line 831 "dk3bmeo.ctr"
}



int
dk3bmeo_get_origin(dk3_bm_eps_options_t *opt)
{
  int back = 0;
  

#line 840 "dk3bmeo.ctr"
  if(opt) {
    back = opt->io;
  } 

#line 843 "dk3bmeo.ctr"
  return back;
}



void
dk3bmeo_set_ps_level(dk3_bm_eps_options_t *opt, int psl)
{
  

#line 852 "dk3bmeo.ctr"
  if(opt) {
    opt->psl = psl;
    if(psl < 2) opt->psl = 2;
    if(psl > 3) opt->psl = 3;
  } 

#line 857 "dk3bmeo.ctr"
}



int
dk3bmeo_get_ps_level(dk3_bm_eps_options_t *opt)
{
  int back = 3;
  

#line 866 "dk3bmeo.ctr"
  if(opt) {
    back = opt->psl;
  } 

#line 869 "dk3bmeo.ctr"
  return back;
}



void
dk3bmeo_set_dct(dk3_bm_eps_options_t *opt, int dct)
{
  

#line 878 "dk3bmeo.ctr"
  if(opt) {
    opt->dct = dct;
  } 

#line 881 "dk3bmeo.ctr"
}



int
dk3bmeo_get_dct(dk3_bm_eps_options_t *opt)
{
  int back = 1;
  

#line 890 "dk3bmeo.ctr"
  if(opt) {
    back = ((opt->dct) ? 1 : 0);
  } 

#line 893 "dk3bmeo.ctr"
  return back;
}


void
dk3bmeo_set_keep_aspect_ratio(dk3_bm_eps_options_t *opt, int kar)
{
  

#line 901 "dk3bmeo.ctr"
  if(opt) {
    opt->kar = kar;
  } 

#line 904 "dk3bmeo.ctr"
}



int
dk3bmeo_get_keep_aspect_ratio(dk3_bm_eps_options_t *opt)
{
  int back = 1;
  

#line 913 "dk3bmeo.ctr"
  if(opt) {
    back = ((opt->kar) ? 1 : 0);
  } 

#line 916 "dk3bmeo.ctr"
  return back;
}



void
dk3bmeo_set_background(dk3_bm_eps_options_t *opt, int r, int g, int b, int f)
{
  

#line 925 "dk3bmeo.ctr"
  if(opt) {
    opt->bgr = r; opt->bgg = g; opt->bgb = b; opt->fbg = f;
  } 

#line 928 "dk3bmeo.ctr"
}



int
dk3bmeo_get_background_red(dk3_bm_eps_options_t *opt)
{
  int back = 0;
  

#line 937 "dk3bmeo.ctr"
  if(opt) {
    back = opt->bgr;
  } 

#line 940 "dk3bmeo.ctr"
  return back;
}




int
dk3bmeo_get_background_green(dk3_bm_eps_options_t *opt)
{
  int back = 0;
  

#line 951 "dk3bmeo.ctr"
  if(opt) {
    back = opt->bgg;
  } 

#line 954 "dk3bmeo.ctr"
  return back;
}



int
dk3bmeo_get_background_blue(dk3_bm_eps_options_t *opt)
{
  int back = 0;
  

#line 964 "dk3bmeo.ctr"
  if(opt) {
    back = opt->bgb;
  } 

#line 967 "dk3bmeo.ctr"
  return back;
}



int
dk3bmeo_get_background_force(dk3_bm_eps_options_t *opt)
{
  int back = 0;
  

#line 977 "dk3bmeo.ctr"
  if(opt) {
    back = ((opt->fbg) ? 1 : 0);
  } 

#line 980 "dk3bmeo.ctr"
  return back;
}



void
dk3bmeo_set_interpolation(dk3_bm_eps_options_t *opt, int iip)
{
  

#line 989 "dk3bmeo.ctr"
  if(opt) {
    opt->ip = iip;
  } 

#line 992 "dk3bmeo.ctr"
}



int
dk3bmeo_get_interpolation(dk3_bm_eps_options_t *opt)
{
  int back = 1;
  

#line 1001 "dk3bmeo.ctr"
  if(opt) {
    back = ((opt->ip) ? 1 : 0);
  } 

#line 1004 "dk3bmeo.ctr"
  return back;
}



void
dk3bmeo_set_jpeg_interpolation(dk3_bm_eps_options_t *opt, int iip)
{
  

#line 1013 "dk3bmeo.ctr"
  if(opt) {
    opt->jip = iip;
  } 

#line 1016 "dk3bmeo.ctr"
}



int
dk3bmeo_get_jpeg_interpolation(dk3_bm_eps_options_t *opt)
{
  int back = 0;
  

#line 1025 "dk3bmeo.ctr"
  if(opt) {
    back = ((opt->jip) ? 1 : 0);
  } 

#line 1028 "dk3bmeo.ctr"
  return back;
}



void
dk3bmeo_set_szmode(dk3_bm_eps_options_t *opt, int newmode)
{
  

#line 1037 "dk3bmeo.ctr"
  if(opt) {
    if((newmode >= 0) && (newmode <= 2)) {
      opt->szmode = newmode;	

#line 1040 "dk3bmeo.ctr"
    }
  } 

#line 1042 "dk3bmeo.ctr"
}



void
dk3bmeo_set_resolution(dk3_bm_eps_options_t *opt, double dpi)
{
  

#line 1050 "dk3bmeo.ctr"
  if(opt) {
    opt->resolution = dpi;
  } 

#line 1053 "dk3bmeo.ctr"
}



double
dk3bmeo_get_resolution(dk3_bm_eps_options_t *opt)
{
  double back = 72.0;
  

#line 1062 "dk3bmeo.ctr"
  if(opt) {
    back = opt->resolution;
    if(back < 0.0) { back = 0.0; }
  } 

#line 1066 "dk3bmeo.ctr"
  return back;
}



int
dk3bmeo_get_szmode(dk3_bm_eps_options_t *opt)
{
  int back = 0;
  

#line 1076 "dk3bmeo.ctr"
  if(opt) {
    back = opt->szmode;
  } 

#line 1079 "dk3bmeo.ctr"
  return back;
}



/**	Set PS level.
	@param	opt	Option set to modify.
	@param	val	Value for option.
	@param	msg	Localized message texts.
	@return	1 on success, 0 on error.
*/
static
int
dk3bmeo_option_pslevel(
  dk3_bm_eps_options_t	*opt,
  dkChar const		*val,
  dkChar const * const	*msg
)
{
  int		back	= 0;
  int		i;		/* Number obtained from val. */
  

#line 1101 "dk3bmeo.ctr"
  if(val) {
#if VERSION_BEFORE_20140716
    if(dk3sf_sscanf3(val, dkT("%d"), &i))
#else
    if (0 != dk3ma_i_from_string(&i, val, NULL))
#endif
    {
      if(i >= 2) {
        if(i <= 3) {
	  opt->psl = i; back = 1;
	} else {
	  /* ERROR: Must be 2 or 3! */
	  dk3bmj_log_1(opt->app, DK3_LL_ERROR,msg,26,DK3_BMJ_LOG_BOTH,NULL);
	}
      } else {
        /* ERROR: Must be 2 or 3! */
	dk3bmj_log_1(opt->app, DK3_LL_ERROR,msg,26,DK3_BMJ_LOG_BOTH,NULL);
      }
    } else {
      /* ERROR: Not a number! */
      dk3bmj_log_3(opt->app, DK3_LL_ERROR,msg,24,25,val,DK3_BMJ_LOG_BOTH,NULL);
    }
  } else {
    /* ERROR: Missing argument! */
  } 

#line 1126 "dk3bmeo.ctr"
  return back;
}




/**	Set a boolean value.
	@param	opt	Option set, used for diagnostics.
	@param	dest	Boolean variable.
	@param	val	Text containing the value.
	@param	msg	Localized message texts.
	@return	1 on success, 0 on error.
*/
static
int
dk3bmeo_set_boolean(
  dk3_bm_eps_options_t	*opt,
  int			*dest,
  dkChar const		*val,
  dkChar const * const	*msg
)
{
  int back = 0;
  

#line 1150 "dk3bmeo.ctr"
  if(val) {
    if(dk3str_is_bool(val)) {
      back = 1;
      if(dk3str_is_on(val)) {
        *dest = 1;
      } else {
        *dest = 0;
      }
    } else {
      /* ERROR: Not a boolean! */
      dk3bmj_log_3(opt->app, DK3_LL_ERROR,msg,27,28,val,DK3_BMJ_LOG_BOTH,NULL);
    }
  } else {
    *dest = 1; back = 1;
  } 

#line 1165 "dk3bmeo.ctr"
  return back;
}



/**	Set flate predictor name.
	@param	opt	Option set to modify.
	@param	val	Value for option.
	@param	msg	Localized message texts.
	@return	1 on success, 0 on error.
*/
static
int
dk3bmeo_option_predictor(
  dk3_bm_eps_options_t	*opt,
  dkChar const		*val,
  dkChar const * const	*msg
)
{
  int		back	= 0;
  

#line 1186 "dk3bmeo.ctr"
  if(val) {
    back = dk3str_array_index(dk3bmeo_predictor_names, val, 0);
    if(back > -1) {
      opt->pred = back + 1;
      back = 1;
    } else {
      back = 0;
      dk3bmj_log_3(opt->app, DK3_LL_ERROR,msg,29,30,val,DK3_BMJ_LOG_BOTH,NULL);
    }
  } else {
    opt->pred = DK3_COMPRESSION_PREDICTOR_TIFF; back = 1;
  } 

#line 1198 "dk3bmeo.ctr"
  return back;
}



/**	Set background.
	@param	opt	Option set to modify.
	@param	val	Value for option.
	@param	msg	Localized message texts.
	@return	1 on success, 0 on error.
*/
static
int
dk3bmeo_option_background(
  dk3_bm_eps_options_t	*opt,
  dkChar const		*val,
  dkChar const * const	*msg
)
{
  int		back	= 0;
  int		i;		/* Temporary conversion result. */
  dkChar	*pc;		/* Current word pointer. */
  dkChar	*pn;		/* Next word pointer. */
  

#line 1222 "dk3bmeo.ctr"
  if(val) {
    pc = dk3str_start(val, NULL);
    if(pc) {
      pn = dk3str_chr(pc, dkT(':'));
      if(pn) {
        *(pn++) = dkT('\0');
#if VERSION_BEFORE_20140716
	if(dk3sf_sscanf3(pc, dkT("%d"), &i))
#else
	if (0 != dk3ma_i_from_string(&i, pc, NULL))
#endif
	{
	  opt->bgr = DK3_TO_RANGE(i,0,255);
	  pc = pn;
	  pn = dk3str_chr(pc, dkT(':'));
	  if(pn) {
	    *(pn++) = dkT('\0');
#if VERSION_BEFORE_20140716
	    if(dk3sf_sscanf3(pc, dkT("%d"), &i))
#else
	    if (0 != dk3ma_i_from_string(&i, pc, NULL))
#endif
	    {
	      opt->bgg = DK3_TO_RANGE(i,0,255);
	      pc = pn;
	      pn = dk3str_chr(pc, dkT(':'));
	      if(pn) { *(pn++) = dkT('\0'); pn = dk3str_start(pn, NULL); }
#if VERSION_BEFORE_20140716
	      if(dk3sf_sscanf3(pc, dkT("%d"), &i))
#else
	      if (0 != dk3ma_i_from_string(&i, pc, NULL))
#endif
	      {
	        opt->bgb = DK3_TO_RANGE(i,0,255);
		back = 1;
		if(pn) {
		  back = 0;
		  if(dk3str_is_bool(pn)) {
		    back = 1;
		    opt->fbg = (dk3str_is_on(pn) ? 1 : 0);
		  } else {
		    /* ERROR: Not a boolean! */
		    dk3bmj_log_3(
		      opt->app, DK3_LL_ERROR,msg,27,28,pn,DK3_BMJ_LOG_BOTH,NULL
		    );
		  }
		}
	      } else {
	        /* ERROR: Not a number! */
		dk3bmj_log_3(
		  opt->app, DK3_LL_ERROR,msg,24,25,pc,DK3_BMJ_LOG_BOTH,NULL
		);
	      }
	    } else {
	      /* ERROR: Not a number! */
	      dk3bmj_log_3(
	        opt->app, DK3_LL_ERROR,msg,24,25,pc,DK3_BMJ_LOG_BOTH,NULL
	      );
	    }
	  } else {
	    /* ERROR: Syntax! */
	    dk3bmj_log_3(
	      opt->app, DK3_LL_ERROR,msg,32,33,pc,DK3_BMJ_LOG_BOTH,NULL
	    );
	  }
	} else {
	  /* ERROR: Not a number! */
          dk3bmj_log_3(
	    opt->app, DK3_LL_ERROR,msg,24,25,pc,DK3_BMJ_LOG_BOTH,NULL
	  );
	}
      } else {
        /* ERROR: Syntax! */
        dk3bmj_log_3(opt->app, DK3_LL_ERROR,msg,32,33,pc,DK3_BMJ_LOG_BOTH,NULL);
      }
    } else {
      /* ERROR: Empty string */
      dk3bmj_log_1(opt->app, DK3_LL_ERROR,msg,31,DK3_BMJ_LOG_BOTH,NULL);
    }
  } else {
    opt->bgr = 255; opt->bgg = 255; opt->bgb = 255; opt->fbg = 1;
  } 

#line 1304 "dk3bmeo.ctr"
  return back;
}



/**	Set resolution, numeric or by name.
	@param	opt	Option set to modify.
	@param	val	Value for option.
	@param	msg	Localized message texts.
	@return	1 on success, 0 on error.
*/
static
int
dk3bmeo_option_resolution(
  dk3_bm_eps_options_t	*opt,
  dkChar const		*val,
  dkChar const * const	*msg
)
{
  int		back	= 0;
  double	d;		/* Temporary conversion result. */
  

#line 1326 "dk3bmeo.ctr"
  if(val) {
    if(dk3str_casecmp(dk3bmeo_kw[1], val) == 0) {
      opt->szmode = DK3_BMEPS_SIZE_1_1;		

#line 1329 "dk3bmeo.ctr"
      back = 1;
    } else {
      if(dk3str_casecmp(dk3bmeo_kw[2], val) == 0) {
        opt->szmode = DK3_BMEPS_SIZE_CHUNK;	

#line 1333 "dk3bmeo.ctr"
	back = 1;
      } else {
        if(dk3str_casecmp(dk3bmeo_kw[3], val) == 0) {
	  opt->szmode = DK3_BMEPS_SIZE_1_1;	

#line 1337 "dk3bmeo.ctr"
	  back = 1;
	} else {
#if VERSION_BEFORE_20140716
	  if(dk3sf_sscanf3(val, dkT("%lf"), &d))
#else
	  if (0 != dk3ma_d_from_string(&d, val, NULL))
#endif
	  {
	    opt->szmode = DK3_BMEPS_SIZE_SPECIFIED;	

#line 1346 "dk3bmeo.ctr"
	    opt->resolution = d;
	    back = 1;
	  } else {
	    /* ERROR: Illegal resolution value */
            dk3bmj_log_3(
	      opt->app, DK3_LL_ERROR,msg,35,36,val,DK3_BMJ_LOG_BOTH,NULL
	    );
	  }
	}
      }
    }
  } else {
    /* ERROR: Missing value! */
    dk3bmj_log_1(opt->app, DK3_LL_ERROR,msg,34,DK3_BMJ_LOG_BOTH,NULL);
  }
  

#line 1362 "dk3bmeo.ctr"
  return back;
}



/**	Set paper size.
	@param	opt	Option set to modify.
	@param	val	Value for option.
	@param	msg	Localized message texts.
	@return	1 on success, 0 on error.
*/
static
int
dk3bmeo_option_paper(
  dk3_bm_eps_options_t	*opt,
  dkChar const		*val,
  dkChar const * const	*msg
)
{
  int		back	= 0;
  

#line 1383 "dk3bmeo.ctr"
  if(val) {
    back = dk3bmeo_set_paper_size_complain(opt, val, 1);
    opt->szmode = DK3_BMEPS_SIZE_PAPER;		

#line 1386 "dk3bmeo.ctr"
  } else {
    /* ERROR: Missing value! */
    dk3bmj_log_1(opt->app, DK3_LL_ERROR,msg,37,DK3_BMJ_LOG_BOTH,NULL);
  } 

#line 1390 "dk3bmeo.ctr"
  return back;
}



int
dk3bmeo_apply_option(
  dk3_bm_eps_options_t	*opt,
  dkChar const		*str,
  dkChar const * const	*msg
)
{
  dkChar	 bu[1024];		/* Private copy of str. */
  dkChar	*p1;			/* String start, option value. */
  int		 ind;			/* Option name index. */
  int		 back	= 0;
  

#line 1407 "dk3bmeo.ctr"
  if((opt) && (str)) {
    p1 = dk3str_start(str, NULL);
    if(p1) {
      if(dk3str_len(p1) < DK3_SIZEOF(bu,dkChar)) {
        dk3str_cpy_not_overlapped(bu, p1);
	p1 = dk3str_chr(bu, dkT('='));
	if(p1) {
	  *(p1++) = dkT('\0');
	  p1 = dk3str_start(p1, NULL);
	}
	ind = dk3str_array_index(dk3bmeo_option_names, bu, 0);
	switch(ind) {
	  case 0: {	/* PS level */
	    back = dk3bmeo_option_pslevel(opt, p1, msg);
	  } break;
	  case 1: {	/* Color flag */
	    back = dk3bmeo_set_boolean(opt, &(opt->color), p1, msg);
	  } break;
	  case 2: {	/* DSC flag */
	    back = dk3bmeo_set_boolean(opt, &(opt->dsc), p1, msg);
	  } break;
	  case 3: {	/* Draft flag */
	    back = dk3bmeo_set_boolean(opt, &(opt->draft), p1, msg);
	  } break;
	  case 4: {	/* Flate predictor name */
	    back = dk3bmeo_option_predictor(opt, p1, msg);
	  } break;
	  case 5: {	/* Duplex flag */
	    back = dk3bmeo_set_boolean(opt, &(opt->duplex), p1, msg);
	  } break;
	  case 6: {	/* Tumble for duplex flag */
	    back = dk3bmeo_set_boolean(opt, &(opt->tumble), p1, msg);
	  } break;
	  case 7: {	/* DCT flag */
	    back = dk3bmeo_set_boolean(opt, &(opt->dct), p1, msg);
	  } break;
	  case 8: {	/* Background color and optional force flag */
	    back = dk3bmeo_option_background(opt, p1, msg);
	  } break;
	  case 9: {	/* Interpolation flag */
	    back = dk3bmeo_set_boolean(opt, &(opt->ip), p1, msg);
	  } break;
	  case 10: {	/* JPEG interpolation flag */
	    back = dk3bmeo_set_boolean(opt, &(opt->jip), p1, msg);
	  } break;
	  case 11: {	/* Resolution, dpi number or name */
	    back = dk3bmeo_option_resolution(opt, p1, msg);
	  } break;
	  case 12: {	/* Paper size, name or numeric */
	    back = dk3bmeo_option_paper(opt, p1, msg);
	  } break;
	  case 13: {	/* Make */
	    back = dk3bmeo_set_boolean(opt, &(opt->make), p1, msg);
	  } break;
	  case 14: {	/* Keep aspect ratio. */
	    back = dk3bmeo_set_boolean(opt, &(opt->kar), p1, msg);
	  } break;
	  case 15: {	/* Reduce bits per component if possible. */
	    

#line 1466 "dk3bmeo.ctr"
	    back = dk3bmeo_set_boolean(opt, &(opt->rbpc), p1, msg);
	  } break;
	  default: {
	    /* ERROR: Unknown option name! */
            dk3bmj_log_3(
	      opt->app, DK3_LL_ERROR,msg,22,23,bu,DK3_BMJ_LOG_BOTH,NULL
	    );
	  } break;
	}
      } else {		

#line 1476 "dk3bmeo.ctr"
        /* ERROR: Configuration string too long! */
        dk3bmj_log_3(opt->app, DK3_LL_ERROR,msg,20,21,p1,DK3_BMJ_LOG_BOTH,NULL);
      }
    } else {		

#line 1480 "dk3bmeo.ctr"
      /* ERROR: Empty configuration string! */
      dk3bmj_log_1(opt->app, DK3_LL_ERROR,msg,19,DK3_BMJ_LOG_BOTH,NULL);
    }
  } 

#line 1484 "dk3bmeo.ctr"
  return back;
}



#if 0
int
dk3bmeo_set_language(
  dk3_bm_eps_options_t *opt, dkChar const *str, dk3_app_t *app
)
{
  dkChar		bu[1024];	/* Private copy of str. */
  dkChar const * const	*msg;		/* Localized messages. */
  dkChar		*pn;		/* Next part to process. */
  dkChar		*pc;		/* Current part to process. */
  dkChar		*pt;		/* Type. */
  int			back	= 0;
  int			lang	= -1;	/* Language. */
  int			mode	= -1;	/* Mode. */
  

#line 1504 "dk3bmeo.ctr"
  msg = dk3app_messages(
    opt->app,
    dk3bmep_str_get_string_table_name(),
    (dkChar const **)dk3bmep_str_get_message_texts()
  );
  if(!(msg)) {
    msg = dk3bmep_str_get_message_texts();
  }
  if((opt) && (str)) {
    if(dk3str_len(str) < DK3_SIZEOF(bu,dkChar)) {
      dk3str_cpy_not_overlapped(bu, str);
      pn = dk3str_chr(bu, dkT(','));
      if(pn) { *(pn++) = dkT('\0'); }
      pc = dk3str_start(bu, NULL);
      if(pc) {
        pt = dk3str_chr(pc, dkT('.'));
	if(pt) { *(pt++) = dkT('\0'); pt = dk3str_start(pt, NULL); }
	lang = dk3str_array_index(dk3bmeo_driver_names, pc, 0);
	switch(lang) {
	  case 0: {
	    lang = DK3_BMEPS_DRIVER_PS; back = 1;
	  } break;
	  case 1: {
	    lang = DK3_BMEPS_DRIVER_EPS; back = 1;
	  } break;
	  case 2: {
	    lang = DK3_BMEPS_DRIVER_PDF; back = 1;
	  } break;
	  case 3: {
	    back = DK3_BMEPS_DRIVER_BB; back = 1;
	  } break;
	  default: {
	    /* ERROR: Unknown language! */
	    if(app) {
	      dkChar const * const	*msg;
              msg = dk3app_messages(
                app,
                dk3bmep_str_get_string_table_name(),
                (dkChar const **)dk3bmep_str_get_message_texts()
              );
	      if(msg) {
	        dk3app_log_3(app, DK3_LL_ERROR, msg, 74, 75, pc);
	      }
	    }
	  } break;
	}
	if(back) {
	  mode = DK3_BMEPS_MODE_OBJECT;
	  if(pt) {
	    back = 0;
	    switch(dk3str_array_index(dk3bmeo_mode_names, pt, 0)) {
	      case 0: case 1: {
	        mode = DK3_BMEPS_MODE_IMAGE; back = 1;
	      } break;
	      case 2: case 3: {
	        mode = DK3_BMEPS_MODE_OBJECT; back = 1;
	      } break;
	      case 4: case 5: {
	        mode = DK3_BMEPS_MODE_DOCUMENT; back = 1;
	      } break;
	    }
	  }
	  if(back) {
	    dk3bmeo_set_driver_and_mode(opt, lang, mode);
            pc = pn;
            while(pc) {
	      pn = dk3str_chr(pc, dkT(','));
	      if(pn) { *(pn++) = dkT('\0'); pn = dk3str_start(pn, NULL); }
	      if(!dk3bmeo_apply_option(opt, pc, msg)) { back = 0; }
	      pc = pn;
            }
	  }
	}
      } else {
        /* ##### ERROR: Missing language/mode! */
      }
    } else {
      /* ##### ERROR: String too long! */
      dk3bmj_log_3(opt->app, DK3_LL_ERROR,msg,12,13,str,DK3_BMJ_LOG_BOTH,job);
    }
  } 

#line 1585 "dk3bmeo.ctr"
  return back;
}
#else
int
dk3bmeo_set_language(
  dk3_bm_eps_options_t	*opt,
  dkChar const		*str,
  dk3_app_t		*app
)
{
  dkChar		bu[1024];	/* Private copy of str. */
  dkChar const * const	*msg;		/* Localized messages. */
  dkChar		*pn;		/* Next part to process. */
  dkChar		*pc;		/* Current part to process. */
  dkChar		*pt;		/* Type. */
  int			back	= 0;
  

#line 1602 "dk3bmeo.ctr"
  msg = dk3app_messages(
    opt->app,
    dk3bmep_str_get_string_table_name(),
    (dkChar const **)dk3bmep_str_get_message_texts()
  );
  if(!(msg)) {
    msg = dk3bmep_str_get_message_texts();
  }
  if((opt) && (str)) {					

#line 1611 "dk3bmeo.ctr"
    dk3bmeo_init(opt);
    opt->app = app;
    if(dk3str_len(str) < DK3_SIZEOF(bu,dkChar)) {	

#line 1614 "dk3bmeo.ctr"
      dk3str_cpy_not_overlapped(bu, str);
      pc = dk3str_start(bu, NULL);
      if(pc) {						

#line 1617 "dk3bmeo.ctr"
        pn = dk3str_chr(pc, dkT(','));
	if(pn) { *(pn++) = dkT('\0'); pn = dk3str_start(pn, NULL); }
	pt = dk3str_chr(pc, dkT('.'));
	if(pt) { *(pt++) = dkT('\0'); pt = dk3str_start(pt, NULL); }
	back = 1;					

#line 1622 "dk3bmeo.ctr"
	opt->mode = DK3_BMEPS_MODE_OBJECT;
	opt->szmode = DK3_BMEPS_SIZE_1_1;		

#line 1624 "dk3bmeo.ctr"
	switch(dk3str_array_index(dk3bmeo_driver_names, pc, 0)) {
	  case 0: {
	    opt->dr = DK3_BMEPS_DRIVER_PS;		

#line 1627 "dk3bmeo.ctr"
	  } break;
	  case 1: {
	    opt->dr = DK3_BMEPS_DRIVER_EPS;		

#line 1630 "dk3bmeo.ctr"
	  } break;
	  case 2: {
	    opt->dr = DK3_BMEPS_DRIVER_PDF;		

#line 1633 "dk3bmeo.ctr"
	  } break;
	  case 3: {
	    opt->dr = DK3_BMEPS_DRIVER_BB;		

#line 1636 "dk3bmeo.ctr"
	    opt->mode = DK3_BMEPS_MODE_OBJECT;
	    opt->szmode = DK3_BMEPS_SIZE_1_1;		

#line 1638 "dk3bmeo.ctr"
	  } break;
	  default: {					

#line 1640 "dk3bmeo.ctr"
	    back = 0;
            dk3bmj_log_3(
	      opt->app, DK3_LL_ERROR,msg,15,16,pc,DK3_BMJ_LOG_BOTH,NULL
	    );
	  } break;
	}
	if(back) {					

#line 1647 "dk3bmeo.ctr"
	  if(pt) {					

#line 1648 "dk3bmeo.ctr"
	    switch(dk3str_array_abbr(dk3bmeo_mode_names, pt, dkT('$'), 0)) {
	      case 0: {					

#line 1650 "dk3bmeo.ctr"
	        opt->mode = DK3_BMEPS_MODE_IMAGE;
		opt->szmode = DK3_BMEPS_SIZE_CHUNK;	

#line 1652 "dk3bmeo.ctr"
	      } break;
	      case 1: {					

#line 1654 "dk3bmeo.ctr"
	        opt->mode = DK3_BMEPS_MODE_OBJECT;
		opt->szmode = DK3_BMEPS_SIZE_1_1;	

#line 1656 "dk3bmeo.ctr"
	      } break;
	      case 2: {
	        opt->mode = DK3_BMEPS_MODE_DOCUMENT;	

#line 1659 "dk3bmeo.ctr"
		opt->szmode = DK3_BMEPS_SIZE_PAPER;	

#line 1660 "dk3bmeo.ctr"
	      } break;
	      default: {				

#line 1662 "dk3bmeo.ctr"
	        back = 0;
		/* ERROR: Illegal mode! */
                dk3bmj_log_3(
		  opt->app, DK3_LL_ERROR,msg,17,18,pt,DK3_BMJ_LOG_BOTH,NULL
		);
	      } break;
	    }
	    if(opt->dr == DK3_BMEPS_DRIVER_BB) {	

#line 1670 "dk3bmeo.ctr"
	      if(opt->mode != DK3_BMEPS_MODE_OBJECT) {	

#line 1671 "dk3bmeo.ctr"
	        back = 0;
		/* ERROR: BB driver can only produce objects! */
	        dk3bmj_log_1(opt->app, DK3_LL_ERROR,msg,8,DK3_BMJ_LOG_BOTH,NULL);
	      }
	    }
	  } else {					

#line 1677 "dk3bmeo.ctr"
	  }
          dk3bmeo_initialize_for_driver_and_mode(opt);
	  if(back) {					

#line 1680 "dk3bmeo.ctr"
	    pc = pn;
	    while(pc) {					

#line 1682 "dk3bmeo.ctr"
	      pn = dk3str_chr(pc, dkT(','));
	      if(pn) { *(pn++) = dkT('\0'); pn = dk3str_start(pn, NULL); }
	      if(!dk3bmeo_apply_option(opt, pc, msg)) { back = 0; }
	      pc = pn;
	    }
	  }
	}
      } else {						

#line 1690 "dk3bmeo.ctr"
        /* ERROR: Empty string! */
	dk3bmj_log_1(opt->app, DK3_LL_ERROR,msg,14,DK3_BMJ_LOG_BOTH,NULL);
      }
    } else {						

#line 1694 "dk3bmeo.ctr"
      /* ERROR: String too long! */
      dk3bmj_log_3(opt->app, DK3_LL_ERROR,msg,12,13,str,DK3_BMJ_LOG_BOTH,NULL);
    }
  } else {						

#line 1698 "dk3bmeo.ctr"
  } 

#line 1699 "dk3bmeo.ctr"
  return back;
}
#endif



int
dk3bmeo_check(
  dk3_bm_eps_options_t		*opt,
  int				 type,
  dk3_app_t			*app,
  dk3_bm_conversion_job_t	*job
)
{
  dkChar const * const	*msg;		/* Localized message texts. */
  int			 back	= 1;	/* No error found (yet). */
  

#line 1716 "dk3bmeo.ctr"
  /*
  	Check driver.
  */
  msg = dk3app_messages(
    opt->app,
    dk3bmep_str_get_string_table_name(),
    (dkChar const **)dk3bmep_str_get_message_texts()
  );
  if(!(msg)) {
    msg = dk3bmep_str_get_message_texts();
  }
  if(type) {				

#line 1728 "dk3bmeo.ctr"
    switch(opt->dr) {
      case DK3_BMEPS_DRIVER_PS:
      case DK3_BMEPS_DRIVER_PDF:
      {					

#line 1732 "dk3bmeo.ctr"
      }
      break;
      default: {			

#line 1735 "dk3bmeo.ctr"
        back = 0;
	/* ERROR: Placed objects can use the PS or PDF driver only! */
	opt->dr = DK3_BMEPS_DRIVER_PS;
	dk3bmj_log_1(opt->app, DK3_LL_ERROR, msg, 2, DK3_BMJ_LOG_BOTH, job);
      } break;
    }
  } else {				

#line 1742 "dk3bmeo.ctr"
    switch(opt->dr) {
      case DK3_BMEPS_DRIVER_PS:
      case DK3_BMEPS_DRIVER_EPS:
      case DK3_BMEPS_DRIVER_PDF:
      case DK3_BMEPS_DRIVER_BB:
      {					

#line 1748 "dk3bmeo.ctr"
      }
      break;
      default: {			

#line 1751 "dk3bmeo.ctr"
        back = 0;
	/* ERROR: Illegal driver, must be PS, EPS, PDF, BB! */
	opt->dr = DK3_BMEPS_DRIVER_PDF;
	dk3bmj_log_1(opt->app, DK3_LL_ERROR, msg, 3, DK3_BMJ_LOG_BOTH, job);
      } break;
    }
  }
  /*
  	Check mode.
  */
  if(type) {				

#line 1762 "dk3bmeo.ctr"
    if(opt->mode != DK3_BMEPS_MODE_PLACED_OBJECT) {
      back = 0;				

#line 1764 "dk3bmeo.ctr"
      /* ERROR: Illegal mode, must be placed object! */
      opt->mode = DK3_BMEPS_MODE_PLACED_OBJECT;
      dk3bmj_log_1(opt->app, DK3_LL_ERROR, msg, 4, DK3_BMJ_LOG_BOTH, job);
    }
  } else {				

#line 1769 "dk3bmeo.ctr"
    if(opt->mode == DK3_BMEPS_MODE_PLACED_OBJECT) {	

#line 1770 "dk3bmeo.ctr"
      dk3bmj_log_1(opt->app, DK3_LL_ERROR, msg, 5, DK3_BMJ_LOG_BOTH, job);
    } else {				
      switch(opt->dr) {
        case DK3_BMEPS_DRIVER_PS: {	

#line 1774 "dk3bmeo.ctr"
          switch(opt->mode) {
            case DK3_BMEPS_MODE_IMAGE:
	    case DK3_BMEPS_MODE_OBJECT:
	    case DK3_BMEPS_MODE_DOCUMENT:
	    {				

#line 1779 "dk3bmeo.ctr"
	    }
	    break;
	    default: {			

#line 1782 "dk3bmeo.ctr"
	      back = 0;
	      /* ERROR: Illegal mode, must be image, object, document! */
	      opt->mode = DK3_BMEPS_MODE_IMAGE;
	      dk3bmj_log_1(opt->app,DK3_LL_ERROR,msg,6,DK3_BMJ_LOG_BOTH,job);
	    } break;
          }
        } break;
        case DK3_BMEPS_DRIVER_EPS: {	

#line 1790 "dk3bmeo.ctr"
	  switch(opt->mode) {
	    case DK3_BMEPS_MODE_IMAGE:
	    case DK3_BMEPS_MODE_OBJECT:
	    {				

#line 1794 "dk3bmeo.ctr"
	    }
	    break;
	    default: {			

#line 1797 "dk3bmeo.ctr"
	      back = 0;
	      /* ERROR: Illegal mode, must be image or object! */
	      opt->mode = DK3_BMEPS_MODE_OBJECT;
	      dk3bmj_log_1(opt->app, DK3_LL_ERROR,msg,7,DK3_BMJ_LOG_BOTH,job);
	    } break;
	  }
        } break;
        case DK3_BMEPS_DRIVER_PDF: {	

#line 1805 "dk3bmeo.ctr"
	  switch(opt->mode) {
            case DK3_BMEPS_MODE_IMAGE:
	    case DK3_BMEPS_MODE_OBJECT:
	    case DK3_BMEPS_MODE_DOCUMENT:
	    {				

#line 1810 "dk3bmeo.ctr"
	    }
	    break;
	    default: {			

#line 1813 "dk3bmeo.ctr"
	      back = 0;
	      /* ERROR: Illegal mode, must be image, object, document! */
	      opt->mode = DK3_BMEPS_MODE_OBJECT;
	      dk3bmj_log_1(opt->app, DK3_LL_ERROR,msg,6,DK3_BMJ_LOG_BOTH,job);
	    } break;
	  }
        } break;
        case DK3_BMEPS_DRIVER_BB: {	

#line 1821 "dk3bmeo.ctr"
	  switch(opt->mode) {
	    case DK3_BMEPS_MODE_OBJECT:
	    {				

#line 1824 "dk3bmeo.ctr"
	    }
	    break;
	    default: {			

#line 1827 "dk3bmeo.ctr"
	      back = 0;
	      /* ERROR: Illegal mode, BB requires object! */
	      opt->mode = DK3_BMEPS_MODE_OBJECT;
	      dk3bmj_log_1(opt->app, DK3_LL_ERROR,msg,8,DK3_BMJ_LOG_BOTH,job);
	    } break;
	  }
	  if(opt->draft) {
	    opt->draft = 0;
	    /* ERROR: Draft mode can not be used for bounding box! */
	  }
        } break;
      }
    }
  }
  /*
  	Check size mode.
  */
  if(type) {				

#line 1845 "dk3bmeo.ctr"
  } else {				

#line 1846 "dk3bmeo.ctr"
    switch(opt->mode) {
      case DK3_BMEPS_MODE_IMAGE: {	

#line 1848 "dk3bmeo.ctr"
        switch(opt->szmode) {
	  case DK3_BMEPS_SIZE_1_1: {		

#line 1850 "dk3bmeo.ctr"
	  } break;
	  case DK3_BMEPS_SIZE_CHUNK: {		

#line 1852 "dk3bmeo.ctr"
	  } break;
	  case DK3_BMEPS_SIZE_SPECIFIED: {	

#line 1854 "dk3bmeo.ctr"
	  } break;
	  case DK3_BMEPS_SIZE_PAPER: {		

#line 1856 "dk3bmeo.ctr"
	  } break;
	  default: {				

#line 1858 "dk3bmeo.ctr"
	    back = 0;
	    /* ERROR: Illegal size mode! */
	    opt->szmode = DK3_BMEPS_SIZE_1_1;	

#line 1861 "dk3bmeo.ctr"
	    dk3bmj_log_1(opt->app, DK3_LL_ERROR,msg,9,DK3_BMJ_LOG_BOTH,job);
	  } break;
	}
      } break;
      case DK3_BMEPS_MODE_OBJECT: {		

#line 1866 "dk3bmeo.ctr"
        switch(opt->szmode) {
	  case DK3_BMEPS_SIZE_1_1: {		

#line 1868 "dk3bmeo.ctr"
	  } break;
	  default: {				

#line 1870 "dk3bmeo.ctr"
	    back = 0;
	    /* ERROR: Illegal size mode, must be 1:1! */
	    opt->szmode = DK3_BMEPS_SIZE_1_1;	

#line 1873 "dk3bmeo.ctr"
	    dk3bmj_log_1(opt->app, DK3_LL_ERROR,msg,10,DK3_BMJ_LOG_BOTH,job);
	  } break;
	}
      } break;
      case DK3_BMEPS_MODE_DOCUMENT: {		

#line 1878 "dk3bmeo.ctr"
        if(opt->draft) {
	  opt->draft = 0;
	  /* ERROR: Draft can not be used with documents! */
	  dk3bmj_log_1(opt->app, DK3_LL_WARNING,msg,11,DK3_BMJ_LOG_BOTH,job);
	}
        switch(opt->szmode) {
	  case DK3_BMEPS_SIZE_1_1: {		

#line 1885 "dk3bmeo.ctr"
	  } break;
	  case DK3_BMEPS_SIZE_CHUNK: {		

#line 1887 "dk3bmeo.ctr"
	  } break;
	  case DK3_BMEPS_SIZE_SPECIFIED: {	

#line 1889 "dk3bmeo.ctr"
	  } break;
	  case DK3_BMEPS_SIZE_PAPER: {		

#line 1891 "dk3bmeo.ctr"
	  } break;
	  default: {				

#line 1893 "dk3bmeo.ctr"
	    back = 0;
	    /* ERROR: Illegal size mode! */
	    opt->szmode = DK3_BMEPS_SIZE_1_1;	

#line 1896 "dk3bmeo.ctr"
	    dk3bmj_log_1(opt->app, DK3_LL_ERROR,msg,9,DK3_BMJ_LOG_BOTH,job);
	  } break;
	}
      } break;
    }
  } 

#line 1902 "dk3bmeo.ctr"
  return back;
}

