/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3bm.ctr
*/

/*
Copyright (C) 2011-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file dk3bm.h Header file for the dk3bm module.
*/

#ifndef DK3BM_H_INCLUDED
/** Avoid multiple inclusions. */
#define DK3BM_H_INCLUDED 1


#line 10 "dk3bm.ctr"

#ifdef __cplusplus
extern "C" {
#endif

/**	Process one file name.
	This function is the entry point used by bmeps3 and wxbmeps.
	The opt->app component must be set.
	@param	opt	Option set for conversion.
	@param	sfn	Source file name.
	@param	biftype	Bitmap image file type.
	@param	min	Progress bar value at start of processing.
	@param	max	Progress bar value at end of processing.
	@param	comm	Communicator object from wxbmeps.
	@return	1 on success, 0 on error.
*/
int
dk3bm_process_file_name(
  dk3_bm_eps_options_t		*opt,
  dkChar const			*sfn,
  int				 biftype,
  int				 min,
  int				 max,
  void				*comm
);


/**	Place a PS object in a given range.
	This is the entry point used by Fig to PS/EPS conversion.
	@param	dfile		Destination file.
	@param	outbb		Image area.
	@param	drawdir		Draw direction / coordinates origin.
	@param	sfn		Source file name.
	@param	app		Application structure.
	@param	pslevel		PS level.
	@param	ec		Pointer to error code variable, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3bm_ps_place_object(
  FILE				*dfile,
  dk3_bb_t			*outbb,
  int				 drawdir,
  char const			*sfn,
  dk3_app_t			*app,
  int				 pslevel,
  int				*ec
);

/**	Find graphics state transformations to place an object.
	@param	dst	Graphics state transformation structure.
	@param	outbb	Reserved range for image.
	@param	drawdir	Drawing directory / coordinates origin.
	@param	imw	Image width in pixels.
	@param	imh	Image height in pixels.
	@param	xres	X resolution.
	@param	yres	Y resolution.
	@param	ec	Pointer to error code variable.
	@return	1 on success, 0 on error.
*/
int
dk3bm_find_transformation(
  dk3_coordinates_transformation_t	*dst,
  dk3_bb_t				*outbb,
  int					 drawdir,
  double				 imw,
  double				 imh,
  double				 xres,
  double				 yres,
  int					*ec
);

/**	Find graphics state transformations to place an object.
	@param	dst	Graphics state transformation structure.
	@param	bif	Image to place.
	@param	outbb	Reserved range for image.
	@param	drawdir	Drawing directory / coordinates origin.
	@param	ec	Pointer to error code variable.
	@return	1 on success, 0 on error.
*/
int
dk3bm_find_bif_transformation(
  dk3_coordinates_transformation_t	*dst,
  dk3_bif_t				*bif,
  dk3_bb_t				*outbb,
  int					 drawdir,
  int					*ec
);

#ifdef __cplusplus
}
#endif




#endif
