/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3bm.ctr
*/

/*
Copyright (C) 2011-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file dk3bm.c The dk3bm module.
*/


#line 106 "dk3bm.ctr"

#include "dk3all.h"
#include "dk3bif.h"
#include "dk3bifa.h"
#include "dk3bmeps.h"
#include "dk3bmeo.h"
#include "dk3bmj.h"
#include "dk3pdf.h"
#include "dk3bm.h"



#if DK3_USE_WX
#include <wxbmeps.h>
#endif




#line 124 "dk3bm.ctr"



/**	Don't debug the module.
*/
#define	DK3BM_DEBUG	0



/**	File name suffixes for output files.
*/
dkChar const * const	dk3bm_output_suffixes[] = {
dkT(".ps"),
dkT(".eps"),
dkT(".pdf"),
dkT(".bb")
};



/**	Everything between 72-epsilon and 72+epsilon is seen as 72 dpi.
	Some file formats store the resolution in pixels per meter as
	integer numbers.
	If 72.0 is scaled from one inch to a meter and rounded to
	integer, the rounding error maximum is one. If one dot per meter
	(the probable rounding error) is converted back to dot per inch
	the result is 0.254.
*/
static double const dk3bm_epsilon = 0.254;



/**	Keywords used by the module.
*/
static char const * const	dk3bm_c8_kw[] = {
/*   0 */ "\n",
/*   1 */ " ",
/*   2 */ "{\n",
/*   3 */ "} exec\n",
/*   4 */ "gsave\n",
/*   5 */ "grestore\n",
/*   6 */ "showpage\n",
/*   7 */ "13 dict begin\n",
/*   8 */ "end\n",
/*   9 */ "%lg %lg translate\n",
/*  10 */ "%d rotate\n",
/*  11 */ "%lg %lg scale\n",
/*  12 */ "%ld %ld scale\n",
/*  13 */ "%!PS-Adobe-2.0",
/*  14 */ "%!PS-Adobe-3.0",
/*  15 */ " EPSF-2.0",
/*  16 */ " EPSF-3.0",
/*  17 */ "<<\n",
/*  18 */ ">>\nimage\n",
/*  19 */ "/ImageType 1\n",
/*  20 */ "/DeviceRGB setcolorspace\n",
/*  21 */ "/DeviceGray setcolorspace\n",
/*  22 */ "/fa currentfile /ASCII85Decode filter def\n",
/*  23 */ "fa flushfile fa closefile\n",
/*  24 */ "/fb fa /RunLengthDecode filter def\n",
/*  25 */ "fb closefile\n",
/*  26 */ "/fb fa /FlateDecode filter def\n",
/*  27 */ "/fb fa << >> /DCTDecode filter def\n",
/*  28 */ "/Width %ld\n",
/*  29 */ "/Height %ld\n",
/*  30 */ "/ImageMatrix [%ld 0 0 -%ld 0 %ld]\n",
/*  31 */ "%%%%BoundingBox: 0 0 %ld %ld\n",
/*  32 */ "%%LanguageLevel: 2\n",
/*  33 */ "%%LanguageLevel: 3\n",
/*  34 */ "/BitsPerComponent %u\n",
/*  35 */ "/MultipleDataSources true\n",
/*  36 */ "/MultipleDataSources false\n",
/*  37 */ "/DataSource fb\n",
/*  38 */ "/DataSource fa\n",
/*  39 */ "/DataSource [\n",
/*  40 */ "{ fb sr readstring pop }\n",
/*  41 */ "{ fb sg readstring pop }\n",
/*  42 */ "{ fb sb readstring pop }\n",
/*  43 */ "]\n",
/*  44 */ "/Decode [0 1]\n",
/*  45 */ "/Decode [0 1 0 1 0 1]\n",
/*  46 */ "/Interpolate true\n",
/*  47 */ "/Interpolate false\n",
/*  48 */ "/sr %ld string def\n",
/*  49 */ "/sg %ld string def\n",
/*  50 */ "/sb %ld string def\n",
/*  51 */ "%%Creator: bmeps3\n",
/*  52 */ "%%Title: ",
/*  53 */ "%%%%Pages: %u\n",
/*  54 */ "%%PageOrder: Ascend\n",
/*  55 */ "%%DocumentData: Clean7Bit\n",
/*  56 */ "%%EndComments\n",
/*  57 */ "%%BeginProlog\n",
/*  58 */ "%%EndProlog\n",
/*  59 */ "%%BeginSetup\n",
/*  60 */ "%%EndSetup\n",
/*  61 */ "%%Trailer\n",
/*  62 */ "%%EOF\n",
/*  63 */ "%%%%Page: %u %u\n",
/*  64 */ "%%BeginFeature: *PageSize BmepsPage\n",
/*  65 */ "%%EndFeature\n",
/*  66 */ "<< /PageSize [%ld %ld] /ImagingBBox null >> setpagedevice\n",
/*  67 */ "%%BeginFeature: *Duplex DuplexNoTumble\n",
/*  68 */ "<< /Duplex true /Tumble false >> setpagedevice\n",
/*  69 */ "%%BeginFeature: *Duplex DuplexTumble\n",
/*  70 */ "<< /Duplex true /Tumble true >> setpagedevice\n",
/*  71 */ "0 setgray\nnewpath\n",
/*  72 */ "%lg %lg moveto\n",
/*  73 */ "%lg %lg lineto\n",
/*  74 */ "closepath\nfill\n",
/*  75 */ "0.8 setgray\nnewpath\n",
/*  76 */ "1 setgray\nnewpath\n",
/*  77 */ "%lg setlinewidth\n",
/*  78 */ "newpath\n",
/*  79 */ "stroke\n",
/*  80 */ "/fb fa <<\n",
/*  81 */ ">> /FlateDecode filter def\n",
/*  82 */ "/Predictor %d\n",
/*  83 */ "/Columns %ld\n",
/*  84 */ "/Colors 3\n",
/*  85 */ "/Colors 1\n",
/*  86 */ "/DeviceCMYK setcolorspace\n",
/*  87 */ "/Decode [0 1 0 1 0 1 0 1]\n",
/*  88 */ "/Decode [1 0 1 0 1 0 1 0]\n",
};



/**	Convert long to double.
	@param	l	Long value to convert.
	@return	Conversion result.
*/
static
double
dk3bm_l_to_d(long l)
{
  return ((double)l);
}



/**	Correct output buffer.
	If LC_NUMERIC has a wrong setting it might produce
	a comma instead of a decimal dot for floating point numbers.
	The PS and PDF language specification always requires a dot,
	independent of the users language setting.
	@param	s	Buffer start address.
*/
static
void
dk3bm_correct_output_buffer(char *s)
{
  char		*ptr;	/* Temporary pointer to traverse string. */
  

#line 278 "dk3bm.ctr"
  if(s) {
    ptr = s;
    while(*ptr) {
      if(*ptr == ',') { *ptr = '.'; }
      ptr++;
    }
  } 

#line 285 "dk3bm.ctr"
}



/**	Write PS header for document.
	@param	job	Conversion job.
	@param	pages	Number of pages in the print job.
*/
static
void
dk3bm_ps_document_header(dk3_bm_conversion_job_t *job, size_t pages)
{
  char		 fnb[DK3_MAX_PATH];	/* Buffer used to construct output. */
  char		 outputbuffer[256];	/* Another buffer for output. */
  dkChar const	*ptr;			/* Used to traverse file name. */
  dkChar const	*nb;			/* Short file name. */
  int		 ie;			/* Input encoding. */
  

#line 303 "dk3bm.ctr"
  fputs(dk3bm_c8_kw[((job->opt)->psl == 3) ? 14 : 13], job->dfile);
  if((job->opt)->dr == DK3_BMEPS_DRIVER_EPS) {
    fputs(dk3bm_c8_kw[((job->opt)->psl == 3) ? 16 : 15], job->dfile);
  }
  fputs(dk3bm_c8_kw[0], job->dfile); 

#line 308 "dk3bm.ctr"
  fprintf(job->dfile, dk3bm_c8_kw[31], job->x_size, job->y_size);
  fputs(dk3bm_c8_kw[((job->opt)->psl == 3) ? 33 : 32], job->dfile);
  if((job->opt)->dsc) {
    fputs(dk3bm_c8_kw[51], job->dfile);
    ptr = job->sfn;
    if(ptr) {
      nb = NULL;
      while(*ptr) {
        if((*ptr == dkT('\\')) || (*ptr == dkT('/'))) {
	  nb = ptr;
	}
        ptr++;
      }
      if(nb) {
        nb++;
      } else {
        nb = job->sfn;
      }
      ie = dk3app_get_encoding((job->opt)->app);
      if(dk3str_to_c8p_app(fnb,sizeof(fnb),nb,ie,(job->opt)->app)) {
	fputs(dk3bm_c8_kw[52], job->dfile);
	fputs(fnb, job->dfile);
	fputs(dk3bm_c8_kw[0], job->dfile);
      }
    }
    sprintf(fnb, dk3bm_c8_kw[53], (unsigned)pages);
    fputs(fnb, job->dfile);
    for(ie = 54; ie <= 59; ie++) {
      fputs(dk3bm_c8_kw[ie], job->dfile);
    }
    switch((job->opt)->dr) {
      case DK3_BMEPS_DRIVER_PS: {
        switch((job->opt)->mode) {
	  case DK3_BMEPS_MODE_DOCUMENT: {
	    fputs(dk3bm_c8_kw[64], job->dfile);
	    sprintf(outputbuffer, dk3bm_c8_kw[66], job->x_size, job->y_size);
	    fputs(outputbuffer, job->dfile);
	    fputs(dk3bm_c8_kw[65], job->dfile);
	    if((job->opt)->duplex) {
	      if((job->opt)->tumble) {
	        fputs(dk3bm_c8_kw[69], job->dfile);
		fputs(dk3bm_c8_kw[70], job->dfile);
		fputs(dk3bm_c8_kw[65], job->dfile);
	      } else {
	        fputs(dk3bm_c8_kw[67], job->dfile);
		fputs(dk3bm_c8_kw[68], job->dfile);
		fputs(dk3bm_c8_kw[65], job->dfile);
	      }
	    }
	  } break;
	}
      } break;
    }
    fputs(dk3bm_c8_kw[60], job->dfile);
  } else {
    if((job->opt)->duplex) {
      if((job->opt)->tumble) {
	fputs(dk3bm_c8_kw[70], job->dfile);
      } else {
        fputs(dk3bm_c8_kw[68], job->dfile);
      }
    }
  } 

#line 371 "dk3bm.ctr"
}



/**	Produce footer for PS print job.
	@param	job	Conversion job.
*/
static
void
dk3bm_ps_document_footer(dk3_bm_conversion_job_t *job)
{
  

#line 383 "dk3bm.ctr"
  if((job->opt)->dsc) {
    fputs(dk3bm_c8_kw[61], job->dfile);
    fputs(dk3bm_c8_kw[62], job->dfile);
  }
  switch((job->opt)->dr) {
    case DK3_BMEPS_DRIVER_PS: {
      switch((job->opt)->mode) {
        case DK3_BMEPS_MODE_DOCUMENT: {
          fputc(0x04, job->dfile);
	} break;
      }
    } break;
  } 

#line 396 "dk3bm.ctr"
}



/**	Copy DCT encoded data directly from input to output.
	@param	of	Output filter.
	@param	dctin	Input file containing DCT-encoded data.
	@param	job	Conversion job.
	@return	1 on success, 0 on error.
*/
static
int
dk3bm_copy_dct_data(
  dk3_of_t			*of,
  FILE				*dctin,
  dk3_bm_conversion_job_t	*job
)
{
  char		bu[4096];	/* Buffer for data read from file. */
  size_t	rb;		/* Number of bytes read. */
  int		back	= 1;
  int		cc;		/* Flag: Can continue. */
  

#line 419 "dk3bm.ctr"
  cc = 1;
  while(cc) {
    cc = 0;
    rb = dk3sf_fread_app((void *)bu, 1, sizeof(bu), dctin, (job->opt)->app);
    if(rb > 0) {
      cc = 1;
      if(!dk3of_write_bytes(of, (unsigned char *)bu, rb)) {
        back = 0;
	cc = 0;
	/* ERROR: Failed to write data! */
	dk3bmj_log_1(
	  (job->opt)->app, DK3_LL_ERROR, job->msg, 58, DK3_BMJ_LOG_BOTH, job
	);
      }
    }
  } 

#line 435 "dk3bm.ctr"
  return back;
}



/**	Write flate filter definition with predictor.
	@param	job	Conversion job.
*/
static
void
dk3bm_define_flate_with_predictor(dk3_bm_conversion_job_t *job)
{
  char	outputbuffer[256];	/* Buffer to construct output. */
  int	i = 0;			/* Predictor ID in PS and PDF. */
  

#line 450 "dk3bm.ctr"
  fputs(dk3bm_c8_kw[80], job->dfile);
  /* Predictor Columns Colors BitsPerComponent */
  switch((job->opt)->pred) {
    case DK3_COMPRESSION_PREDICTOR_TIFF: {
      i = 2;
    } break;
    case DK3_COMPRESSION_PREDICTOR_PNG_SUB: {
      i = 11;
    } break;
    case DK3_COMPRESSION_PREDICTOR_PNG_UP: {
      i = 12;
    } break;
    case DK3_COMPRESSION_PREDICTOR_PNG_AVERAGE: {
      i = 13;
    } break;
    case DK3_COMPRESSION_PREDICTOR_PNG_PAETH: {
      i = 14;
    } break;
  }
  sprintf(outputbuffer, dk3bm_c8_kw[82], i);
  fputs(outputbuffer, job->dfile);
  sprintf(outputbuffer, dk3bm_c8_kw[83], dk3bif_get_width(job->bif));
  fputs(outputbuffer, job->dfile);
  sprintf(outputbuffer, dk3bm_c8_kw[34], job->bpc);
  fputs(outputbuffer, job->dfile);
  if(job->procedure == DK3_BMEPS_RGB_FLATE) {
    fputs(dk3bm_c8_kw[84], job->dfile);
  } else {
    fputs(dk3bm_c8_kw[85], job->dfile);
  }
  fputs(dk3bm_c8_kw[81], job->dfile); 

#line 481 "dk3bm.ctr"
}



/**	Write one unsigned character.
	@param	of	Output filter.
	@param	v	Value to write to output.
*/
static
void
dk3bm_write_uc(dk3_of_t *of, dk3_bif_pixel_t v)
{
  unsigned char	ucv;			/* Byte to write. */
  

#line 495 "dk3bm.ctr"
  ucv = (unsigned char)v;
  dk3of_write_bytes(of, &ucv, 1);	

#line 497 "dk3bm.ctr"
}



/**	Produce PS for image or object.
	The following components of job must be set:
	x_size, y_size, x_translate, y_translate, x_0, x_1, y_0, y_1,
	x_scale, y_scale, do_translate, do_rotate, do_float_scale.
	@param	job	Conversion job.
	@return	1 on success, 0 on error.
*/
static
int
dk3bm_job_produce_img_job_real_ps(dk3_bm_conversion_job_t *job)
{
  char			 outputbuffer[256];	/* Buffer to prepare output. */
  FILE			*dctin;		/* Input file containing DCT data. */
  dk3_stream_t		*os;			/* Output stream. */
  dk3_of_t		*of;			/* Output filter. */
  long			 bitsperline;		/* Bits per line. */
  long			 bytesperline;		/* Bytes per line. */
  dk3_bif_coord_t	 w;			/* Image width. */
  dk3_bif_coord_t	 h;			/* Image height. */
  dk3_bif_coord_t	 x;			/* Current x. */
  dk3_bif_coord_t	 y;			/* Current y. */
  dk3_bif_pixel_t	 v;			/* Current point value. */
  dk3_bif_pixel_t	 pl;			/* Left pixel. */
  dk3_bif_pixel_t	 pu;			/* Upper pixel. */
  dk3_bif_pixel_t	 plu;			/* Left upper pixel. */
  size_t		 nbits;		/* Number of bits per component. */
  int			 back	= 0;
  int			 analysis_type	= 0;	/* Analysis to perform. */
  int			 use_dct	= 0;	/* Flag: DCT used. */
  int			 me	= 0;		/* Flag: Math error. */
  int			 alphain	= 0;	/* Flag: Alpha channel. */
  int			 colorin	= 0;	/* Flag: Color image. */
#if DK3_USE_WX
  int			 minpb;		/* Original min progress bar value. */
  int			 maxpb;		/* Original max progress bar value. */
  int			 pbmin;		/* Min progress bar value. */
  int			 pbmax;		/* Max progress bar value. */
#endif
  

#line 540 "dk3bm.ctr"
#if DK3_USE_WX
  minpb = job->minpb;
  maxpb = job->maxpb;
#endif
  if(job->dfile) {			

#line 545 "dk3bm.ctr"
    alphain = 0;
    switch(dk3bif_get_color_space(job->bif)) {
      case DK3_COLOR_SPACE_GRAY_ALPHA:
      case DK3_COLOR_SPACE_RGBA:
      {
        alphain = 1;			

#line 551 "dk3bm.ctr"
      } break;
    }
    colorin = 0;
    switch(dk3bif_get_color_space(job->bif)) {
      case DK3_COLOR_SPACE_GRAY:
      case DK3_COLOR_SPACE_GRAY_ALPHA: {
      } break;
      default: {
        colorin = 1;			

#line 560 "dk3bm.ctr"
      } break;
    }
    /*
    	Conversion defaults.
    */
    w = dk3bif_get_width(job->bif);
    h = dk3bif_get_height(job->bif);
    job->procedure = DK3_BMEPS_GRAY_UNCOMPRESSED;
    job->bpc = 8;
    /*
    	Decisions about compression, bpc, colors.
    */
    analysis_type = 0;
    switch(dk3bif_get_type(job->bif)) {
      case DK3_BIF_IMAGE_TYPE_JPEG: {		

#line 575 "dk3bm.ctr"
        if((job->opt)->dct) {			

#line 576 "dk3bm.ctr"
	  switch(dk3bif_get_bits_per_pixel(job->bif)) {
	    case 8: case 4: case 2: case 1: {	

#line 578 "dk3bm.ctr"
	      switch(dk3bif_jpeg_get_num_components(job->bif)) {
	        case 1: {			

#line 580 "dk3bm.ctr"
		  job->procedure = DK3_BMEPS_GRAY_DCT;
		  job->bpc = dk3bif_get_bits_per_pixel(job->bif);
		  use_dct = 1;
		} break;
		case 3: {			

#line 585 "dk3bm.ctr"
		  job->procedure = DK3_BMEPS_RGB_DCT;
		  job->bpc = dk3bif_get_bits_per_pixel(job->bif);
		  use_dct = 1;
		} break;
		case 4: {			

#line 590 "dk3bm.ctr"
		  job->procedure = DK3_BMEPS_CMYK_DCT;
		  job->bpc = dk3bif_get_bits_per_pixel(job->bif);
		  use_dct = 1;
		} break;
		default: { 

#line 595 "dk3bm.ctr"
		} break;
	      }
	    } break;
	  }
	}
      } break;
    }
    if(!(use_dct)) {
      if((job->opt)->color) {
        switch(dk3bif_get_color_space(job->bif)) {
          case DK3_COLOR_SPACE_GRAY:
	  case DK3_COLOR_SPACE_GRAY_ALPHA: {
	  } break;
	  default: {
            analysis_type |= DK3_BIF_ANALYSIS_COLOR;
          } break;
        }
      }
      if((job->opt)->rbpc) {
        analysis_type |= DK3_BIF_ANALYSIS_BITS;
      }
      if(alphain) {
        analysis_type |= DK3_BIF_ANALYSIS_ALPHA;
      }
      /* PROGRESS: Analyzing image. */
      dk3app_log_1((job->opt)->app, DK3_LL_PROGRESS, job->msg, 48);
      if(analysis_type) {
#if DK3_USE_WX
        dk3bif_analyze_progress(
	  job->bif, analysis_type, job->pComm, minpb, ((maxpb + minpb)/2)
	);
#else
	dk3bif_analyze(job->bif, analysis_type);
#endif
      }
      nbits = dk3bif_get_bits_per_pixel(job->bif);
      if((job->opt)->rbpc) { nbits = dk3bif_real_bits_per_pixel(job->bif); }
#if 0
      /*	2014-03-22
      		New algorithms for bits per component detection and reduction.
      */
      job->bpc = 1;
      if(nbits > 1) {
        job->bpc = 2;
	if(nbits > 2) {
	  job->bpc = 4;
	  if(nbits > 4) {
	    job->bpc = 8;
	    if(nbits > 8) {
	      job->bpc = 12;
	    }
	  }
	}
      }
#else
      switch (nbits) {
        case 1:  { job->bpc =  1; } break;
	case 2:  { job->bpc =  2; } break;
	case 4:  { job->bpc =  4; } break;
	case 12: { job->bpc = 12; } break;
	default: { job->bpc =  8; } break;
      }
#endif

/*	2014-03-23
	The dk3bifa module generate debug output.
*/
#if 0
      /* DEBUG: Analysis results. */
      {
        dkChar	numbuf[128];
        dkChar const *msgpart[3];
	int	convres;
	msgpart[0] = (job->msg)[51];
	msgpart[1] = (job->msg)[(colorin) ? 49 : 50];
	dk3app_log_msg((job->opt)->app, DK3_LL_DEBUG, msgpart, 2);
	msgpart[0] = (job->msg)[52];
	msgpart[1] = (job->msg)[(dk3bif_real_color(job->bif)) ? 49 : 50];
	dk3app_log_msg((job->opt)->app, DK3_LL_DEBUG, msgpart, 2);
	msgpart[0] = (job->msg)[53];
	msgpart[1] = (job->msg)[(alphain) ? 49 : 50];
	dk3app_log_msg((job->opt)->app, DK3_LL_DEBUG, msgpart, 2);
	msgpart[0] = (job->msg)[54];
	msgpart[1] = (job->msg)[(dk3bif_real_alpha(job->bif)) ? 49 : 50];
	dk3app_log_msg((job->opt)->app, DK3_LL_DEBUG, msgpart, 2);
#if VERSION_BEFORE_20140716
	dk3sf_sprintf3(numbuf,dkT("%u"),(unsigned)dk3bif_get_bits_per_pixel(job->bif));
	msgpart[0] = (job->msg)[55];
	msgpart[1] = numbuf;
	dk3app_log_msg((job->opt)->app, DK3_LL_DEBUG, msgpart, 2);
	dk3sf_sprintf3(numbuf,dkT("%u"),(unsigned)dk3bif_real_bits_per_pixel(job->bif));
	msgpart[0] = (job->msg)[56];
	msgpart[1] = numbuf;
	dk3app_log_msg((job->opt)->app, DK3_LL_DEBUG, msgpart, 2);
	dk3sf_sprintf3(numbuf,dkT("%u"),(unsigned)(job->bpc));
	msgpart[0] = (job->msg)[57];
	msgpart[1] = numbuf;
	dk3app_log_msg((job->opt)->app, DK3_LL_DEBUG, msgpart, 2);
#else
	convres = dk3ma_um_to_string(
	  numbuf, DK3_SIZEOF(numbuf,dkChar),
	  (dk3_um_t)dk3bif_get_bits_per_pixel(job->bif)
	);
	if (0 != convres) {
	  msgpart[0] = (job->msg)[55];
	  msgpart[1] = numbuf;
	  dk3app_log_msg((job->opt)->app, DK3_LL_DEBUG, msgpart, 2);
	}
	convres = dk3ma_um_to_string(
	  numbuf, DK3_SIZEOF(numbuf,dkChar),
	  (dk3_um_t)dk3bif_real_bits_per_pixel(job->bif)
	);
	if (0 != convres) {
	  msgpart[0] = (job->msg)[56];
	  msgpart[1] = numbuf;
	  dk3app_log_msg((job->opt)->app, DK3_LL_DEBUG, msgpart, 2);
	}
	convres = dk3ma_um_to_string(
	  numbuf, DK3_SIZEOF(numbuf,dkChar), (dk3_um_t)(job->bpc)
	);
	if (0 != convres) {
	  msgpart[0] = (job->msg)[57];
	  msgpart[1] = numbuf;
	  dk3app_log_msg((job->opt)->app, DK3_LL_DEBUG, msgpart, 2);
	}
#endif
      }
#endif
      if(analysis_type & DK3_BIF_ANALYSIS_COLOR) {
        colorin = dk3bif_real_color(job->bif);
      }
      if(analysis_type & DK3_BIF_ANALYSIS_ALPHA) {
        alphain = dk3bif_real_alpha(job->bif);
      }
      switch(dk3bif_get_color_space(job->bif)) {
        case DK3_COLOR_SPACE_GRAY:
        case DK3_COLOR_SPACE_GRAY_ALPHA: {
          job->procedure = DK3_BMEPS_GRAY_RUNLENGTH;
	  if((job->opt)->psl >= 3) {
	    job->procedure = DK3_BMEPS_GRAY_FLATE;
	    if((job->opt)->pred > DK3_COMPRESSION_PREDICTOR_TIFF) {
	      job->bpc = 8;
	    }
	  }
        } break;
        default: {
	  if(dk3bif_real_color(job->bif)) {
	    job->procedure = DK3_BMEPS_RGB_UNCOMPRESSED;
	    if((job->opt)->psl >= 3) {
	      job->procedure = DK3_BMEPS_RGB_FLATE;
	      if((job->opt)->pred > DK3_COMPRESSION_PREDICTOR_TIFF) {
	        job->bpc = 8;
	      }
	    } else {
	      bitsperline = dk3ma_l_mul_ok((long)(job->bpc), w, &me);
	      if(me == 0) {
	        bytesperline = bitsperline / 8L;
	        if(bitsperline % 8L) { bytesperline++; }
	        if(bytesperline < 16384L) {
	          job->procedure = DK3_BMEPS_RGB_RUNLENGTH;
	        }
	      }
	    }
	  } else {
	    job->procedure = DK3_BMEPS_GRAY_RUNLENGTH;
	    if((job->opt)->psl >= 3) {
	      job->procedure = DK3_BMEPS_GRAY_FLATE;
	      if((job->opt)->pred > DK3_COMPRESSION_PREDICTOR_TIFF) {
	        job->bpc = 8;
	      }
	    }
	  }
        } break;
      }
    }
    dk3app_log_1((job->opt)->app, DK3_LL_PROGRESS, job->msg, 76);
#if DK3BM_DEBUG
    job->procedure = DK3_BMEPS_RGB_UNCOMPRESSED;
#endif
#if DK3_USE_WX
    

#line 776 "dk3bm.ctr"
    dk3bmj_progress(job->pComm, ((maxpb + minpb)/2));
    job->minpb = ((maxpb + minpb) / 2);
    pbmin = job->minpb;
    pbmax = job->maxpb;
#endif
    /*
    	File header.
    */
    if(job->do_header_footer) {
      dk3bm_ps_document_header(job, 1);
    }
    /*
    	Image.
    */
    if((job->opt)->dsc) {
      sprintf(
        outputbuffer, dk3bm_c8_kw[63],
	(unsigned)(job->currentPage),
	(unsigned)(job->currentPage)
      );
      fputs(outputbuffer, job->dfile);
    }
    fputs(dk3bm_c8_kw[2], job->dfile);				/* { */
    fputs(dk3bm_c8_kw[4], job->dfile);				/* gsave */
    /*
    	Translate, rotate, scale.
    */
    if(job->do_translate) {
      sprintf(
        outputbuffer, dk3bm_c8_kw[9], job->x_translate, job->y_translate
      );
      dk3bm_correct_output_buffer(outputbuffer);
      fputs(outputbuffer, job->dfile);
    }
    if(job->do_rotate) {
      sprintf(outputbuffer, dk3bm_c8_kw[10], (90 * job->do_rotate));
      fputs(outputbuffer, job->dfile);
    }
    if(job->do_float_scale) {
      sprintf(
        outputbuffer,
	dk3bm_c8_kw[11],
	job->x_scale, job->y_scale
      );
      dk3bm_correct_output_buffer(outputbuffer);
    } else {
      sprintf(outputbuffer, dk3bm_c8_kw[12], w, h);
    }
    fputs(outputbuffer, job->dfile);
    fputs(dk3bm_c8_kw[7], job->dfile);			/* 13 dict begin */
    /*
    	Color space, definitions for data source(s).
    */
    switch(job->procedure) {
      case DK3_BMEPS_GRAY_UNCOMPRESSED: {
        fputs(dk3bm_c8_kw[21], job->dfile);
        fputs(dk3bm_c8_kw[22], job->dfile);
      } break;
      case DK3_BMEPS_RGB_UNCOMPRESSED: {
        fputs(dk3bm_c8_kw[20], job->dfile);
        fputs(dk3bm_c8_kw[22], job->dfile);
      } break;
      case DK3_BMEPS_GRAY_RUNLENGTH: {
        fputs(dk3bm_c8_kw[21], job->dfile);
        fputs(dk3bm_c8_kw[22], job->dfile);
        fputs(dk3bm_c8_kw[24], job->dfile);
      } break;
      case DK3_BMEPS_RGB_RUNLENGTH: {
        fputs(dk3bm_c8_kw[20], job->dfile);
        fputs(dk3bm_c8_kw[22], job->dfile);
        fputs(dk3bm_c8_kw[24], job->dfile);
	bitsperline = w * (long)(job->bpc);
	bytesperline = bitsperline / 8L;
	if(bitsperline % 8L) { bytesperline++; }
	fprintf(job->dfile, dk3bm_c8_kw[48], bytesperline);
	fprintf(job->dfile, dk3bm_c8_kw[49], bytesperline);
	fprintf(job->dfile, dk3bm_c8_kw[50], bytesperline);
      } break;
      case DK3_BMEPS_GRAY_DCT: {
        fputs(dk3bm_c8_kw[21], job->dfile);
        fputs(dk3bm_c8_kw[22], job->dfile);
        fputs(dk3bm_c8_kw[27], job->dfile);
      } break;
      case DK3_BMEPS_RGB_DCT: {
        fputs(dk3bm_c8_kw[20], job->dfile);
        fputs(dk3bm_c8_kw[22], job->dfile);
        fputs(dk3bm_c8_kw[27], job->dfile);
      } break;
      case DK3_BMEPS_CMYK_DCT: {
        fputs(dk3bm_c8_kw[86], job->dfile);
        fputs(dk3bm_c8_kw[22], job->dfile);
        fputs(dk3bm_c8_kw[27], job->dfile);
      } break;
      case DK3_BMEPS_GRAY_FLATE: {
        fputs(dk3bm_c8_kw[21], job->dfile);
        fputs(dk3bm_c8_kw[22], job->dfile);
	if((job->opt)->pred) {
	  dk3bm_define_flate_with_predictor(job);
	} else {
          fputs(dk3bm_c8_kw[26], job->dfile);
	}
      } break;
      case DK3_BMEPS_RGB_FLATE: {
        fputs(dk3bm_c8_kw[20], job->dfile);
        fputs(dk3bm_c8_kw[22], job->dfile);
	if((job->opt)->pred) {
	  dk3bm_define_flate_with_predictor(job);
	} else {
          fputs(dk3bm_c8_kw[26], job->dfile);
	}
      } break;
    }
    fputs(dk3bm_c8_kw[17], job->dfile);				/* << */
    /*
    	Image dictionary contents.
    */
    fputs(dk3bm_c8_kw[19], job->dfile);			/* /ImageType 1 */
    sprintf(outputbuffer, dk3bm_c8_kw[28], w);
    fputs(outputbuffer, job->dfile);			/* /Width ... */
    sprintf(outputbuffer, dk3bm_c8_kw[29], h);
    fputs(outputbuffer, job->dfile);			/* /Height ... */
    sprintf(outputbuffer, dk3bm_c8_kw[30], w, h, h);
    fputs(outputbuffer, job->dfile);			/* /ImageMatrix ... */
    sprintf(outputbuffer, dk3bm_c8_kw[34], (unsigned)(job->bpc));
    fputs(outputbuffer, job->dfile);		/* /BitsPerComponent ... */
    /* /Interpolate ... */
    switch(job->procedure) {
      case DK3_BMEPS_GRAY_UNCOMPRESSED: {
        fputs(dk3bm_c8_kw[38], job->dfile);
        fputs(dk3bm_c8_kw[44], job->dfile);
	fputs(dk3bm_c8_kw[((job->opt)->ip) ? 46 : 47], job->dfile);
      } break;
      case DK3_BMEPS_RGB_UNCOMPRESSED: {
        fputs(dk3bm_c8_kw[36], job->dfile);
        fputs(dk3bm_c8_kw[38], job->dfile);
        fputs(dk3bm_c8_kw[45], job->dfile);
	fputs(dk3bm_c8_kw[((job->opt)->ip) ? 46 : 47], job->dfile);
      } break;
      case DK3_BMEPS_GRAY_RUNLENGTH: {
        fputs(dk3bm_c8_kw[37], job->dfile);
        fputs(dk3bm_c8_kw[44], job->dfile);
	fputs(dk3bm_c8_kw[((job->opt)->ip) ? 46 : 47], job->dfile);
      } break;
      case DK3_BMEPS_RGB_RUNLENGTH: {
        fputs(dk3bm_c8_kw[35], job->dfile);
        fputs(dk3bm_c8_kw[39], job->dfile);
        fputs(dk3bm_c8_kw[40], job->dfile);
        fputs(dk3bm_c8_kw[41], job->dfile);
        fputs(dk3bm_c8_kw[42], job->dfile);
        fputs(dk3bm_c8_kw[43], job->dfile);
        fputs(dk3bm_c8_kw[45], job->dfile);
	fputs(dk3bm_c8_kw[((job->opt)->ip) ? 46 : 47], job->dfile);
      } break;
      case DK3_BMEPS_GRAY_DCT: {
        fputs(dk3bm_c8_kw[37], job->dfile);
        fputs(dk3bm_c8_kw[44], job->dfile);
	if((job->opt)->ip) {
	  if((job->opt)->jip) {
	    fputs(dk3bm_c8_kw[46], job->dfile);
	  }
	}
      } break;
      case DK3_BMEPS_RGB_DCT: {
        fputs(dk3bm_c8_kw[36], job->dfile);
        fputs(dk3bm_c8_kw[37], job->dfile);
        fputs(dk3bm_c8_kw[45], job->dfile);
	if((job->opt)->ip) {
	  if((job->opt)->jip) {
	    fputs(dk3bm_c8_kw[46], job->dfile);
	  }
	}
      } break;
      case DK3_BMEPS_CMYK_DCT: {
        fputs(dk3bm_c8_kw[36], job->dfile);
        fputs(dk3bm_c8_kw[37], job->dfile);
	if(dk3bif_jpeg_get_found_adobe_marker(job->bif)) {
          fputs(dk3bm_c8_kw[88], job->dfile);
	} else {
	  fputs(dk3bm_c8_kw[87], job->dfile);
	}
	if((job->opt)->ip) {
	  if((job->opt)->jip) {
	    fputs(dk3bm_c8_kw[46], job->dfile);
	  }
	}
      } break;
      case DK3_BMEPS_GRAY_FLATE: {
        fputs(dk3bm_c8_kw[37], job->dfile);
        fputs(dk3bm_c8_kw[44], job->dfile);
	fputs(dk3bm_c8_kw[((job->opt)->ip) ? 46 : 47], job->dfile);
      } break;
      case DK3_BMEPS_RGB_FLATE: {
        fputs(dk3bm_c8_kw[36], job->dfile);
        fputs(dk3bm_c8_kw[37], job->dfile);
        fputs(dk3bm_c8_kw[45], job->dfile);
	fputs(dk3bm_c8_kw[((job->opt)->ip) ? 46 : 47], job->dfile);
      } break;
    }
    fputs(dk3bm_c8_kw[18], job->dfile);				/* >> image */
    /*
    	Close data streams.
    */
    switch(job->procedure) {
      case DK3_BMEPS_GRAY_UNCOMPRESSED: {
        fputs(dk3bm_c8_kw[23], job->dfile);
      } break;
      case DK3_BMEPS_RGB_UNCOMPRESSED: {
        fputs(dk3bm_c8_kw[23], job->dfile);
      } break;
      case DK3_BMEPS_GRAY_RUNLENGTH: {
        fputs(dk3bm_c8_kw[25], job->dfile);
        fputs(dk3bm_c8_kw[23], job->dfile);
      } break;
      case DK3_BMEPS_RGB_RUNLENGTH: {
        fputs(dk3bm_c8_kw[25], job->dfile);
        fputs(dk3bm_c8_kw[23], job->dfile);
      } break;
      case DK3_BMEPS_GRAY_DCT: {
        fputs(dk3bm_c8_kw[25], job->dfile);
        fputs(dk3bm_c8_kw[23], job->dfile);
      } break;
      case DK3_BMEPS_RGB_DCT: {
        fputs(dk3bm_c8_kw[25], job->dfile);
        fputs(dk3bm_c8_kw[23], job->dfile);
      } break;
      case DK3_BMEPS_CMYK_DCT: {
        fputs(dk3bm_c8_kw[25], job->dfile);
        fputs(dk3bm_c8_kw[23], job->dfile);
      } break;
      case DK3_BMEPS_GRAY_FLATE: {
        fputs(dk3bm_c8_kw[25], job->dfile);
        fputs(dk3bm_c8_kw[23], job->dfile);
      } break;
      case DK3_BMEPS_RGB_FLATE: {
        fputs(dk3bm_c8_kw[25], job->dfile);
        fputs(dk3bm_c8_kw[23], job->dfile);
      } break;
    }
    fputs(dk3bm_c8_kw[8], job->dfile);				/* end */
    fputs(dk3bm_c8_kw[5], job->dfile);				/* grestore */
    switch((job->opt)->mode) {
      case DK3_BMEPS_MODE_IMAGE:
      case DK3_BMEPS_MODE_DOCUMENT: {
        if((job->opt)->dr == DK3_BMEPS_DRIVER_PS) {
          fputs(dk3bm_c8_kw[6], job->dfile);			/* showpage */
	}
      } break;
    }
    fputs(dk3bm_c8_kw[3], job->dfile);				/* } exec */
    /*
    	Write compress/encoded image data.
    */
    os = dk3stream_open_file_app(
      job->dfile, DK3_STREAM_FLAG_WRITE, (job->opt)->app
    );
    if(os) {
      of = dk3of_open_app(os, (job->opt)->app);
      if(of) {
        dk3of_set_finalize(of, 1);
        if(dk3of_add_cell(of, DK3_OF_CELL_TYPE_A85)) {
          switch(job->procedure) {
            case DK3_BMEPS_GRAY_UNCOMPRESSED: {
	      dk3bif_set_bits_per_pixel(job->bif, job->bpc);
	      if(dk3of_start_chunk(of)) {
		if(job->bpc == 8) {
		  if(alphain) {
		    for(y = 0L; y < h; y++) {
		      for(x = 0L; x < w; x++) {
		        v = dk3bif_get_mixed_gray(job->bif, x, y);
			dk3bm_write_uc(of, v);
		      }
#if DK3_USE_WX
		      dk3bmj_lines_progress(job->pComm,pbmin,pbmax,h,y);
#endif
		    }
		  } else {
		    for(y = 0L; y < h; y++) {
		      for(x = 0L; x < w; x++) {
		        v = dk3bif_get_gray(job->bif, x, y);
			dk3bm_write_uc(of, v);
		      }
#if DK3_USE_WX
		      dk3bmj_lines_progress(job->pComm,pbmin,pbmax,h,y);
#endif
		    }
		  }
		} else {
		  if(alphain) {
		    for(y = 0L; y < h; y++) {
		      for(x = 0L; x < w; x++) {
		        v = dk3bif_get_mixed_gray(job->bif, x, y);
			dk3of_write_bits(of, v, job->bpc);
		      }
		      dk3of_flush_bits(of);
#if DK3_USE_WX
		      dk3bmj_lines_progress(job->pComm,pbmin,pbmax,h,y);
#endif
		    }
		  } else {
		    for(y = 0L; y < h; y++) {
		      for(x = 0L; x < w; x++) {
		        v = dk3bif_get_gray(job->bif, x, y);
			dk3of_write_bits(of, v, job->bpc);
		      }
		      dk3of_flush_bits(of);
#if DK3_USE_WX
		      dk3bmj_lines_progress(job->pComm,pbmin,pbmax,h,y);
#endif
		    }
		  }
		}
	        back = dk3of_end_chunk(of);
	      } else {
	        /* ERROR: Failed to start encoded chunk! */
	        dk3bmj_log_1(
	          (job->opt)->app, DK3_LL_ERROR, job->msg, 59,
		  DK3_BMJ_LOG_BOTH, job
	        );
	      }
            } break;
            case DK3_BMEPS_RGB_UNCOMPRESSED: {
	      dk3bif_set_bits_per_pixel(job->bif, job->bpc);
	      if(dk3of_start_chunk(of)) {
		if(job->bpc == 8) {
		  if(alphain) {
		    for(y = 0L; y < h; y++) {
		      for(x = 0L; x < w; x++) {
		        v = dk3bif_get_mixed_red(job->bif, x, y);
			dk3bm_write_uc(of, v);
			v = dk3bif_get_mixed_green(job->bif, x, y);
			dk3bm_write_uc(of, v);
			v = dk3bif_get_mixed_blue(job->bif, x, y);
			dk3bm_write_uc(of, v);
		      }
#if DK3_USE_WX
		      dk3bmj_lines_progress(job->pComm,pbmin,pbmax,h,y);
#endif
		    }
		  } else {
		    for(y = 0L; y < h; y++) {
		      for(x = 0L; x < w; x++) {
		        v = dk3bif_get_red(job->bif, x, y);
			dk3bm_write_uc(of, v);
			v = dk3bif_get_green(job->bif, x, y);
			dk3bm_write_uc(of, v);
			v = dk3bif_get_blue(job->bif, x, y);
			dk3bm_write_uc(of, v);
		      }
#if DK3_USE_WX
		      dk3bmj_lines_progress(job->pComm,pbmin,pbmax,h,y);
#endif
		    }
		  }
		} else {
		  if(alphain) {
		    for(y = 0L; y < h; y++) {
		      for(x = 0L; x < w; x++) {
		        v = dk3bif_get_mixed_red(job->bif, x, y);
			dk3of_write_bits(of, v, job->bpc);
			v = dk3bif_get_mixed_green(job->bif, x, y);
			dk3of_write_bits(of, v, job->bpc);
			v = dk3bif_get_mixed_blue(job->bif, x, y);
			dk3of_write_bits(of, v, job->bpc);
		      }
		      dk3of_flush_bits(of);
#if DK3_USE_WX
		      dk3bmj_lines_progress(job->pComm,pbmin,pbmax,h,y);
#endif
		    }
		  } else {
		    for(y = 0L; y < h; y++) {
		      for(x = 0L; x < w; x++) {
		        v = dk3bif_get_red(job->bif, x, y);
			dk3of_write_bits(of, v, job->bpc);
			v = dk3bif_get_green(job->bif, x, y);
			dk3of_write_bits(of, v, job->bpc);
			v = dk3bif_get_blue(job->bif, x, y);
			dk3of_write_bits(of, v, job->bpc);
		      }
		      dk3of_flush_bits(of);
#if DK3_USE_WX
		      dk3bmj_lines_progress(job->pComm,pbmin,pbmax,h,y);
#endif
		    }
		  }
		}
	        back = dk3of_end_chunk(of);
	      } else {
	        /* ERROR: Failed to start encoded chunk! */
	        dk3bmj_log_1(
	          (job->opt)->app, DK3_LL_ERROR, job->msg, 59,
		  DK3_BMJ_LOG_BOTH, job
	        );
	      }
            } break;
            case DK3_BMEPS_GRAY_RUNLENGTH: {
	      dk3bif_set_bits_per_pixel(job->bif, job->bpc);
	      if(dk3of_add_cell(of, DK3_OF_CELL_TYPE_RUN_LENGTH)) {
	        if(dk3of_start_chunk(of)) {
		  if(job->bpc == 8) {
		    if(alphain) {
		      for(y = 0UL; y < h; y++) {
		        for(x = 0UL; x < w; x++) {
			  v = dk3bif_get_mixed_gray(job->bif, x, y);
			  dk3bm_write_uc(of, v);
			}
#if DK3_USE_WX
		      dk3bmj_lines_progress(job->pComm,pbmin,pbmax,h,y);
#endif
		      }
		    } else {
		      for(y = 0UL; y < h; y++) {
		        for(x = 0UL; x < w; x++) {
			  v = dk3bif_get_gray(job->bif, x, y);
			  dk3bm_write_uc(of, v);
			}
#if DK3_USE_WX
		      dk3bmj_lines_progress(job->pComm,pbmin,pbmax,h,y);
#endif
		      }
		    }
		  } else {
		    if(alphain) {
		      for(y = 0UL; y < h; y++) {
		        for(x = 0UL; x < w; x++) {
			  v = dk3bif_get_mixed_gray(job->bif, x, y);
			  dk3of_write_bits(of, v, job->bpc);
			}
			dk3of_flush_bits(of);
#if DK3_USE_WX
		      dk3bmj_lines_progress(job->pComm,pbmin,pbmax,h,y);
#endif
		      }
		    } else {
		      for(y = 0UL; y < h; y++) {
		        for(x = 0UL; x < w; x++) {
			  v = dk3bif_get_gray(job->bif, x, y);
			  dk3of_write_bits(of, v, job->bpc);
			}
			dk3of_flush_bits(of);
#if DK3_USE_WX
		      dk3bmj_lines_progress(job->pComm,pbmin,pbmax,h,y);
#endif
		      }
		    }
		  }
		  back = dk3of_end_chunk(of);
		} else {
		  /* ERROR: Failed to start encoded chunk! */
	          dk3bmj_log_1(
	            (job->opt)->app, DK3_LL_ERROR, job->msg, 59,
		    DK3_BMJ_LOG_BOTH, job
	          );
		}
	      } else {
	        /* ERROR: Failed to add run-length cell! */
	        dk3bmj_log_1(
	          (job->opt)->app, DK3_LL_ERROR, job->msg, 59,
		  DK3_BMJ_LOG_BOTH, job
	        );
	      }
            } break;
            case DK3_BMEPS_RGB_RUNLENGTH: {
	      dk3bif_set_bits_per_pixel(job->bif, job->bpc);
	      if(dk3of_add_cell(of, DK3_OF_CELL_TYPE_RUN_LENGTH)) {
	        if(dk3of_start_chunk(of)) {
		  if(job->bpc == 8) {
		    if(alphain) {
		      for(y = 0UL; y < h; y++) {
		        for(x = 0UL; x < w; x++) {
			  v = dk3bif_get_mixed_red(job->bif, x, y);
			  dk3bm_write_uc(of, v);
			}
			for(x = 0UL; x < w; x++) {
			  v = dk3bif_get_mixed_green(job->bif, x, y);
			  dk3bm_write_uc(of, v);
			}
			for(x = 0UL; x < w; x++) {
			  v = dk3bif_get_mixed_blue(job->bif, x, y);
			  dk3bm_write_uc(of, v);
			}
#if DK3_USE_WX
		      dk3bmj_lines_progress(job->pComm,pbmin,pbmax,h,y);
#endif
		      }
		    } else {
		      for(y = 0UL; y < h; y++) {
		        for(x = 0UL; x < w; x++) {
			  v = dk3bif_get_red(job->bif, x, y);
			  dk3bm_write_uc(of, v);
			}
			for(x = 0UL; x < w; x++) {
			  v = dk3bif_get_green(job->bif, x, y);
			  dk3bm_write_uc(of, v);
			}
			for(x = 0UL; x < w; x++) {
			  v = dk3bif_get_blue(job->bif, x, y);
			  dk3bm_write_uc(of, v);
			}
#if DK3_USE_WX
		      dk3bmj_lines_progress(job->pComm,pbmin,pbmax,h,y);
#endif
		      }
		    }
		  } else {
		    if(alphain) {
		      for(y = 0UL; y < h; y++) {
		        for(x = 0UL; x < w; x++) {
			  v = dk3bif_get_mixed_red(job->bif, x, y);
			  dk3of_write_bits(of, v, job->bpc);
			}
			dk3of_flush_bits(of);
			for(x = 0UL; x < w; x++) {
			  v = dk3bif_get_mixed_green(job->bif, x, y);
			  dk3of_write_bits(of, v, job->bpc);
			}
			dk3of_flush_bits(of);
			for(x = 0UL; x < w; x++) {
			  v = dk3bif_get_mixed_blue(job->bif, x, y);
			  dk3of_write_bits(of, v, job->bpc);
			}
			dk3of_flush_bits(of);
#if DK3_USE_WX
		      dk3bmj_lines_progress(job->pComm,pbmin,pbmax,h,y);
#endif
		      }
		    } else {
		      for(y = 0UL; y < h; y++) {
		        for(x = 0UL; x < w; x++) {
			  v = dk3bif_get_red(job->bif, x, y);
			  dk3of_write_bits(of, v, job->bpc);
			}
			dk3of_flush_bits(of);
			for(x = 0UL; x < w; x++) {
			  v = dk3bif_get_green(job->bif, x, y);
			  dk3of_write_bits(of, v, job->bpc);
			}
			dk3of_flush_bits(of);
			for(x = 0UL; x < w; x++) {
			  v = dk3bif_get_blue(job->bif, x, y);
			  dk3of_write_bits(of, v, job->bpc);
			}
			dk3of_flush_bits(of);
#if DK3_USE_WX
		      dk3bmj_lines_progress(job->pComm,pbmin,pbmax,h,y);
#endif
		      }
		    }
		  }
		  back = dk3of_end_chunk(of);
		} else {
		  /* ERROR: Failed to start encoded chunk! */
	          dk3bmj_log_1(
	            (job->opt)->app, DK3_LL_ERROR, job->msg, 59,
		    DK3_BMJ_LOG_BOTH, job
	          );
		}
	      } else {
	        /* ERROR: Failed to add run-length cell! */
	        dk3bmj_log_1(
	         (job->opt)->app, DK3_LL_ERROR, job->msg, 59,
		 DK3_BMJ_LOG_BOTH, job
	        );
	      }
            } break;
            case DK3_BMEPS_GRAY_DCT:
            case DK3_BMEPS_RGB_DCT:
	    case DK3_BMEPS_CMYK_DCT: {
	      dctin = dk3bif_get_file(job->bif);
	      if(dctin) {
	        rewind(dctin);
		if(dk3of_start_chunk(of)) {
		  back = dk3bm_copy_dct_data(of, dctin, job);
		  if(back) {
		    back = dk3of_end_chunk(of);
		  } else {
		    (void)dk3of_end_chunk(of);
		  }
		} else {
		  /* ERROR: Failed to start encoded chunk! */
	          dk3bmj_log_1(
	            (job->opt)->app, DK3_LL_ERROR, job->msg, 59,
		    DK3_BMJ_LOG_BOTH, job
	          );
		}
	      } else {
	        /* BUG: No input file! */
	      }
            } break;
            case DK3_BMEPS_GRAY_FLATE: {
	      dk3bif_set_bits_per_pixel(job->bif, job->bpc);
	      if(dk3of_add_cell(of, DK3_OF_CELL_TYPE_FLATE)) {
	        if(dk3of_start_chunk(of)) {
		  if(job->bpc == 8) {
		    if(alphain) {		

#line 1371 "dk3bm.ctr"
		      switch((job->opt)->pred) {
		        case DK3_COMPRESSION_PREDICTOR_TIFF: {
		          for(y = 0UL; y < h; y++) {
			    pl = 0;
		            for(x = 0UL; x < w; x++) {
			      v = dk3bif_get_mixed_gray(job->bif, x, y);
			      dk3bm_write_uc(of, (v - pl));
			      pl = v;
			    }
#if DK3_USE_WX
		      dk3bmj_lines_progress(job->pComm,pbmin,pbmax,h,y);
#endif
		          }
			} break;
			case DK3_COMPRESSION_PREDICTOR_PNG_SUB: {
		          for(y = 0UL; y < h; y++) {
			    pl = 0;
			    dk3bm_write_uc(of, 1);
		            for(x = 0UL; x < w; x++) {
			      v = dk3bif_get_mixed_gray(job->bif, x, y);
			      dk3bm_write_uc(of, (v - pl));
			      pl = v;
			    }
#if DK3_USE_WX
		      dk3bmj_lines_progress(job->pComm,pbmin,pbmax,h,y);
#endif
		          }
			} break;
			case DK3_COMPRESSION_PREDICTOR_PNG_UP: {
		          for(y = 0UL; y < h; y++) {
			    dk3bm_write_uc(of, 2);
		            for(x = 0UL; x < w; x++) {	

#line 1403 "dk3bm.ctr"
			      v = dk3bif_get_mixed_gray(job->bif, x, y);
			      pu = dk3bif_get_mixed_gray(job->bif, x, (y - 1L));
			      

#line 1406 "dk3bm.ctr"
			      v = v - pu;	

#line 1407 "dk3bm.ctr"
			      dk3bm_write_uc(of, v);
			    }
#if DK3_USE_WX
		      dk3bmj_lines_progress(job->pComm,pbmin,pbmax,h,y);
#endif
		          }
			} break;
			case DK3_COMPRESSION_PREDICTOR_PNG_AVERAGE: {
		          for(y = 0UL; y < h; y++) {
			    dk3bm_write_uc(of, 3);
		            for(x = 0UL; x < w; x++) {
			      v = dk3bif_get_mixed_gray(job->bif, x, y);
			      pl = dk3bif_get_mixed_gray(job->bif, (x - 1L), y);
			      pu = dk3bif_get_mixed_gray(job->bif, x, (y - 1L));
			      pl = dk3bif_average(pl, pu);
			      pl &= 0x00FFU;
			      v = v - pl;
			      dk3bm_write_uc(of, v);
			    }
#if DK3_USE_WX
		      dk3bmj_lines_progress(job->pComm,pbmin,pbmax,h,y);
#endif
		          }
			} break;
			case DK3_COMPRESSION_PREDICTOR_PNG_PAETH: {
		          for(y = 0UL; y < h; y++) {
			    dk3bm_write_uc(of, 4);
		            for(x = 0UL; x < w; x++) {
			      v = dk3bif_get_mixed_gray(job->bif, x, y);
			      pl = dk3bif_get_mixed_gray(job->bif, (x - 1L), y);
			      pu = dk3bif_get_mixed_gray(job->bif, x, (y - 1L));
			      plu = dk3bif_get_mixed_gray(
			        job->bif, (x - 1L), (y - 1L)
			      );
			      pl = dk3bif_paeth(pl, pu, plu);
			      v = v - pl;
			      dk3bm_write_uc(of, v);
			    }
#if DK3_USE_WX
		      dk3bmj_lines_progress(job->pComm,pbmin,pbmax,h,y);
#endif
		          }
			} break;
			default: {
		          for(y = 0UL; y < h; y++) {
		            for(x = 0UL; x < w; x++) {
			      v = dk3bif_get_mixed_gray(job->bif, x, y);
			      dk3bm_write_uc(of, v);
			    }
#if DK3_USE_WX
		      dk3bmj_lines_progress(job->pComm,pbmin,pbmax,h,y);
#endif
		          }
			} break;
		      }
		    } else {
		      switch((job->opt)->pred) {
		        case DK3_COMPRESSION_PREDICTOR_TIFF: {
		          for(y = 0UL; y < h; y++) {
			    pl = 0;
		            for(x = 0UL; x < w; x++) {
			      v = dk3bif_get_gray(job->bif, x, y);
			      dk3bm_write_uc(of, (v - pl));
			      pl = v;
			    }
#if DK3_USE_WX
		      dk3bmj_lines_progress(job->pComm,pbmin,pbmax,h,y);
#endif
		          }
			} break;
			case DK3_COMPRESSION_PREDICTOR_PNG_SUB: {
		          for(y = 0UL; y < h; y++) {
			    dk3bm_write_uc(of, 1);
			    pl = 0;
		            for(x = 0UL; x < w; x++) {
			      v = dk3bif_get_gray(job->bif, x, y);
			      dk3bm_write_uc(of, (v - pl));
			      pl = v;
			    }
#if DK3_USE_WX
		      dk3bmj_lines_progress(job->pComm,pbmin,pbmax,h,y);
#endif
		          }
			} break;
			case DK3_COMPRESSION_PREDICTOR_PNG_UP: {
		          for(y = 0UL; y < h; y++) {
			    dk3bm_write_uc(of, 2);
		            for(x = 0UL; x < w; x++) {
			      v = dk3bif_get_gray(job->bif, x, y);
			      pu = dk3bif_get_gray(job->bif, x, (y - 1L));
			      dk3bm_write_uc(of, (v - pu));
			    }
#if DK3_USE_WX
		      dk3bmj_lines_progress(job->pComm,pbmin,pbmax,h,y);
#endif
		          }
			} break;
			case DK3_COMPRESSION_PREDICTOR_PNG_AVERAGE: {
		          for(y = 0UL; y < h; y++) {
			    dk3bm_write_uc(of, 3);
		            for(x = 0UL; x < w; x++) {
			      v = dk3bif_get_gray(job->bif, x, y);
			      pl = dk3bif_get_gray(job->bif, (x - 1L), y);
			      pu = dk3bif_get_gray(job->bif, x, (y - 1L));
			      pl = dk3bif_average(pl, pu);
			      pl &= 0x00FFU;
			      v = v - pl;
			      dk3bm_write_uc(of, v);
			    }
#if DK3_USE_WX
		      dk3bmj_lines_progress(job->pComm,pbmin,pbmax,h,y);
#endif
		          }
			} break;
			case DK3_COMPRESSION_PREDICTOR_PNG_PAETH: {
		          for(y = 0UL; y < h; y++) {
			    dk3bm_write_uc(of, 4);
		            for(x = 0UL; x < w; x++) {
			      v = dk3bif_get_gray(job->bif, x, y);
			      pl = dk3bif_get_gray(job->bif, (x - 1L), y);
			      pu = dk3bif_get_gray(job->bif, x, (y - 1L));
			      plu = dk3bif_get_gray(
			        job->bif, (x - 1L), (y - 1L)
			      );
			      pl = dk3bif_paeth(pl, pu, plu);
			      v = v - pl;
			      dk3bm_write_uc(of, v);
			    }
#if DK3_USE_WX
		      dk3bmj_lines_progress(job->pComm,pbmin,pbmax,h,y);
#endif
		          }
			} break;
		        default: {
		          for(y = 0UL; y < h; y++) {
		            for(x = 0UL; x < w; x++) {
			      v = dk3bif_get_gray(job->bif, x, y);
			      dk3bm_write_uc(of, v);
			    }
#if DK3_USE_WX
		      dk3bmj_lines_progress(job->pComm,pbmin,pbmax,h,y);
#endif
		          }
			} break;
		      }
		    }
		  } else {
		    if(alphain) {
		      switch((job->opt)->pred) {
		        case DK3_COMPRESSION_PREDICTOR_TIFF: {
		          for(y = 0UL; y < h; y++) {
			    pl = 0;
		            for(x = 0UL; x < w; x++) {
			      v = dk3bif_get_mixed_gray(job->bif, x, y);
			      dk3of_write_bits(of, (v - pl), job->bpc);
			      pl = v;
			    }
			    dk3of_flush_bits(of);
#if DK3_USE_WX
		      dk3bmj_lines_progress(job->pComm,pbmin,pbmax,h,y);
#endif
		          }
			} break;
			default: {
		          for(y = 0UL; y < h; y++) {
		            for(x = 0UL; x < w; x++) {
			      v = dk3bif_get_mixed_gray(job->bif, x, y);
			      dk3of_write_bits(of, v, job->bpc);
			    }
			    dk3of_flush_bits(of);
#if DK3_USE_WX
		      dk3bmj_lines_progress(job->pComm,pbmin,pbmax,h,y);
#endif
		          }
			} break;
		      }
		    } else {
		      switch((job->opt)->pred) {
		        case DK3_COMPRESSION_PREDICTOR_TIFF: {
		          for(y = 0UL; y < h; y++) {
			    pl = 0;
		            for(x = 0UL; x < w; x++) {
			      v = dk3bif_get_gray(job->bif, x, y);
			      dk3of_write_bits(of, (v - pl), job->bpc);
			      pl = v;
			    }
			    dk3of_flush_bits(of);
#if DK3_USE_WX
		      dk3bmj_lines_progress(job->pComm,pbmin,pbmax,h,y);
#endif
		          }
			} break;
			default: {
		          for(y = 0UL; y < h; y++) {
		            for(x = 0UL; x < w; x++) {
			      v = dk3bif_get_gray(job->bif, x, y);
			      dk3of_write_bits(of, v, job->bpc);
			    }
			    dk3of_flush_bits(of);
#if DK3_USE_WX
		      dk3bmj_lines_progress(job->pComm,pbmin,pbmax,h,y);
#endif
		          }
			} break;
		      }
		    }
		  }
		  back = dk3of_end_chunk(of);
		} else {
		  /* ERROR: Failed to start encoded chunk! */
	          dk3bmj_log_1(
	            (job->opt)->app, DK3_LL_ERROR, job->msg, 59,
		    DK3_BMJ_LOG_BOTH, job
	          );
		}
	      } else {
	        /* ERROR: Failed to add run-length cell! */
	        dk3bmj_log_1(
	          (job->opt)->app, DK3_LL_ERROR, job->msg, 59,
		  DK3_BMJ_LOG_BOTH, job
	        );
	      }
            } break;
            case DK3_BMEPS_RGB_FLATE: {
	      dk3bif_set_bits_per_pixel(job->bif, job->bpc);
	      if(dk3of_add_cell(of, DK3_OF_CELL_TYPE_FLATE)) {
	        if(dk3of_start_chunk(of)) {
		  if(job->bpc == 8) {
		    if(alphain) {
		      switch((job->opt)->pred) {
		        case DK3_COMPRESSION_PREDICTOR_TIFF: {
		          for(y = 0UL; y < h; y++) {
			    pl  = 0; /* r */
			    pu  = 0; /* g */
			    plu = 0; /* b */
		            for(x = 0UL; x < w; x++) {
			      v = dk3bif_get_mixed_red(job->bif, x, y);
			      dk3bm_write_uc(of, (v - pl));
			      pl = v;
			      v = dk3bif_get_mixed_green(job->bif, x, y);
			      dk3bm_write_uc(of, (v - pu));
			      pu = v;
			      v = dk3bif_get_mixed_blue(job->bif, x, y);
			      dk3bm_write_uc(of, (v - plu));
			      plu = v;
			    }
#if DK3_USE_WX
		      dk3bmj_lines_progress(job->pComm,pbmin,pbmax,h,y);
#endif
		          }
			} break;
			case DK3_COMPRESSION_PREDICTOR_PNG_SUB: {
		          for(y = 0UL; y < h; y++) {
			    pl  = 0; /* r */
			    pu  = 0; /* g */
			    plu = 0; /* b */
			    dk3bm_write_uc(of, 1);
		            for(x = 0UL; x < w; x++) {
			      v = dk3bif_get_mixed_red(job->bif, x, y);
			      dk3bm_write_uc(of, (v - pl));
			      pl = v;
			      v = dk3bif_get_mixed_green(job->bif, x, y);
			      dk3bm_write_uc(of, (v - pu));
			      pu = v;
			      v = dk3bif_get_mixed_blue(job->bif, x, y);
			      dk3bm_write_uc(of, (v - plu));
			      plu = v;
			    }
#if DK3_USE_WX
		      dk3bmj_lines_progress(job->pComm,pbmin,pbmax,h,y);
#endif
		          }
			} break;
			case DK3_COMPRESSION_PREDICTOR_PNG_UP: {
		          for(y = 0UL; y < h; y++) {
			    dk3bm_write_uc(of, 2);
		            for(x = 0UL; x < w; x++) {
			      v = dk3bif_get_mixed_red(job->bif, x, y);
			      pu = dk3bif_get_mixed_red(job->bif, x, (y - 1L));
			      dk3bm_write_uc(of, (v - pu));
			      v = dk3bif_get_mixed_green(job->bif, x, y);
			      pu = dk3bif_get_mixed_green(job->bif, x, (y - 1L));
			      dk3bm_write_uc(of, (v - pu));
			      v = dk3bif_get_mixed_blue(job->bif, x, y);
			      pu = dk3bif_get_mixed_blue(job->bif, x, (y - 1L));
			      dk3bm_write_uc(of, (v - pu));
			    }
#if DK3_USE_WX
		      dk3bmj_lines_progress(job->pComm,pbmin,pbmax,h,y);
#endif
		          }
			} break;
			case DK3_COMPRESSION_PREDICTOR_PNG_AVERAGE: {
		          for(y = 0UL; y < h; y++) {
			    dk3bm_write_uc(of, 3);
		            for(x = 0UL; x < w; x++) {
			      v = dk3bif_get_mixed_red(job->bif, x, y);
			      pl = dk3bif_get_mixed_red(job->bif, (x - 1L), y);
			      pu = dk3bif_get_mixed_red(job->bif, x, (y - 1L));
			      pu = dk3bif_average(pl, pu);
			      dk3bm_write_uc(of, (v - pu));
			      v = dk3bif_get_mixed_green(job->bif, x, y);
			      pl = dk3bif_get_mixed_green(job->bif, (x - 1L), y);
			      pu = dk3bif_get_mixed_green(job->bif, x, (y - 1L));
			      pu = dk3bif_average(pl, pu);
			      dk3bm_write_uc(of, (v - pu));
			      v = dk3bif_get_mixed_blue(job->bif, x, y);
			      pl = dk3bif_get_mixed_blue(job->bif, (x - 1L), y);
			      pu = dk3bif_get_mixed_blue(job->bif, x, (y - 1L));
			      pu = dk3bif_average(pl, pu);
			      dk3bm_write_uc(of, (v - pu));
			    }
#if DK3_USE_WX
		      dk3bmj_lines_progress(job->pComm,pbmin,pbmax,h,y);
#endif
		          }
			} break;
			case DK3_COMPRESSION_PREDICTOR_PNG_PAETH: {
		          for(y = 0UL; y < h; y++) {
			    dk3bm_write_uc(of, 3);
		            for(x = 0UL; x < w; x++) {
			      v = dk3bif_get_mixed_red(job->bif, x, y);
			      pl = dk3bif_get_mixed_red(job->bif, (x - 1L), y);
			      pu = dk3bif_get_mixed_red(job->bif, x, (y - 1L));
			      plu = dk3bif_get_mixed_red(job->bif, (x - 1L), (y - 1L));
			      pu = dk3bif_paeth(pl, pu, plu);
			      dk3bm_write_uc(of, (v - pu));
			      v = dk3bif_get_mixed_green(job->bif, x, y);
			      pl = dk3bif_get_mixed_green(job->bif, (x - 1L), y);
			      pu = dk3bif_get_mixed_green(job->bif, x, (y - 1L));
			      plu = dk3bif_get_mixed_green(job->bif, (x - 1L), (y - 1L));
			      pu = dk3bif_paeth(pl, pu, plu);
			      dk3bm_write_uc(of, (v - pu));
			      v = dk3bif_get_mixed_blue(job->bif, x, y);
			      pl = dk3bif_get_mixed_blue(job->bif, (x - 1L), y);
			      pu = dk3bif_get_mixed_blue(job->bif, x, (y - 1L));
			      plu = dk3bif_get_mixed_blue(job->bif, (x - 1L), (y - 1L));
			      pu = dk3bif_paeth(pl, pu, plu);
			      dk3bm_write_uc(of, (v - pu));
			    }
#if DK3_USE_WX
		      dk3bmj_lines_progress(job->pComm,pbmin,pbmax,h,y);
#endif
		          }
			} break;
		        default: {
		          for(y = 0UL; y < h; y++) {
		            for(x = 0UL; x < w; x++) {
			      v = dk3bif_get_mixed_red(job->bif, x, y);
			      dk3bm_write_uc(of, v);
			      v = dk3bif_get_mixed_green(job->bif, x, y);
			      dk3bm_write_uc(of, v);
			      v = dk3bif_get_mixed_blue(job->bif, x, y);
			      dk3bm_write_uc(of, v);
			    }
#if DK3_USE_WX
		      dk3bmj_lines_progress(job->pComm,pbmin,pbmax,h,y);
#endif
		          }
			} break;
		      }
		    } else {
		      switch((job->opt)->pred) {
		        case DK3_COMPRESSION_PREDICTOR_TIFF: {
		          for(y = 0UL; y < h; y++) {
			    pl  = 0; /* r */
			    pu  = 0; /* g */
			    plu = 0; /* b */
		            for(x = 0UL; x < w; x++) {
			      v = dk3bif_get_red(job->bif, x, y);
			      dk3bm_write_uc(of, (v - pl));
			      pl = v;
			      v = dk3bif_get_green(job->bif, x, y);
			      dk3bm_write_uc(of, (v - pu));
			      pu = v;
			      v = dk3bif_get_blue(job->bif, x, y);
			      dk3bm_write_uc(of, (v - plu));
			      plu = v;
			    }
#if DK3_USE_WX
		      dk3bmj_lines_progress(job->pComm,pbmin,pbmax,h,y);
#endif
		          }
			} break;
			case DK3_COMPRESSION_PREDICTOR_PNG_SUB: {
		          for(y = 0UL; y < h; y++) {
			    pl  = 0; /* r */
			    pu  = 0; /* g */
			    plu = 0; /* b */
			    dk3bm_write_uc(of, 1);
		            for(x = 0UL; x < w; x++) {
			      v = dk3bif_get_red(job->bif, x, y);
			      dk3bm_write_uc(of, (v - pl));
			      pl = v;
			      v = dk3bif_get_green(job->bif, x, y);
			      dk3bm_write_uc(of, (v - pu));
			      pu = v;
			      v = dk3bif_get_blue(job->bif, x, y);
			      dk3bm_write_uc(of, (v - plu));
			      plu = v;
			    }
#if DK3_USE_WX
		      dk3bmj_lines_progress(job->pComm,pbmin,pbmax,h,y);
#endif
		          }
			} break;
			case DK3_COMPRESSION_PREDICTOR_PNG_UP: {
		          for(y = 0UL; y < h; y++) {
			    dk3bm_write_uc(of, 2);
		            for(x = 0UL; x < w; x++) {
			      v = dk3bif_get_red(job->bif, x, y);
			      pu = dk3bif_get_red(job->bif, x, (y - 1L));
			      dk3bm_write_uc(of, (v - pu));
			      v = dk3bif_get_green(job->bif, x, y);
			      pu = dk3bif_get_green(job->bif, x, (y - 1L));
			      dk3bm_write_uc(of, (v - pu));
			      v = dk3bif_get_blue(job->bif, x, y);
			      pu = dk3bif_get_blue(job->bif, x, (y - 1L));
			      dk3bm_write_uc(of, (v - pu));
			    }
#if DK3_USE_WX
		      dk3bmj_lines_progress(job->pComm,pbmin,pbmax,h,y);
#endif
		          }
			} break;
			case DK3_COMPRESSION_PREDICTOR_PNG_AVERAGE: {
		          for(y = 0UL; y < h; y++) {
			    dk3bm_write_uc(of, 3);
		            for(x = 0UL; x < w; x++) {
			      v = dk3bif_get_red(job->bif, x, y);
			      pl = dk3bif_get_red(job->bif, (x - 1L), y);
			      pu = dk3bif_get_red(job->bif, x, (y - 1L));
			      pu = dk3bif_average(pl, pu);
			      dk3bm_write_uc(of, (v - pu));
			      v = dk3bif_get_green(job->bif, x, y);
			      pl = dk3bif_get_green(job->bif, (x - 1L), y);
			      pu = dk3bif_get_green(job->bif, x, (y - 1L));
			      pu = dk3bif_average(pl, pu);
			      dk3bm_write_uc(of, (v - pu));
			      v = dk3bif_get_blue(job->bif, x, y);
			      pl = dk3bif_get_blue(job->bif, (x - 1L), y);
			      pu = dk3bif_get_blue(job->bif, x, (y - 1L));
			      pu = dk3bif_average(pl, pu);
			      dk3bm_write_uc(of, (v - pu));
			    }
#if DK3_USE_WX
		      dk3bmj_lines_progress(job->pComm,pbmin,pbmax,h,y);
#endif
		          }
			} break;
			case DK3_COMPRESSION_PREDICTOR_PNG_PAETH: {
		          for(y = 0UL; y < h; y++) {
			    dk3bm_write_uc(of, 3);
		            for(x = 0UL; x < w; x++) {
			      v = dk3bif_get_red(job->bif, x, y);
			      pl = dk3bif_get_red(job->bif, (x - 1L), y);
			      pu = dk3bif_get_red(job->bif, x, (y - 1L));
			      plu = dk3bif_get_red(job->bif, (x - 1L), (y - 1L));
			      pu = dk3bif_paeth(pl, pu, plu);
			      dk3bm_write_uc(of, (v - pu));
			      v = dk3bif_get_green(job->bif, x, y);
			      pl = dk3bif_get_green(job->bif, (x - 1L), y);
			      pu = dk3bif_get_green(job->bif, x, (y - 1L));
			      plu = dk3bif_get_green(job->bif, (x - 1L), (y - 1L));
			      pu = dk3bif_paeth(pl, pu, plu);
			      dk3bm_write_uc(of, (v - pu));
			      v = dk3bif_get_blue(job->bif, x, y);
			      pl = dk3bif_get_blue(job->bif, (x - 1L), y);
			      pu = dk3bif_get_blue(job->bif, x, (y - 1L));
			      plu = dk3bif_get_blue(job->bif, (x - 1L), (y - 1L));
			      pu = dk3bif_paeth(pl, pu, plu);
			      dk3bm_write_uc(of, (v - pu));
			    }
#if DK3_USE_WX
		      dk3bmj_lines_progress(job->pComm,pbmin,pbmax,h,y);
#endif
		          }
			} break;
			default : {
		          for(y = 0UL; y < h; y++) {
		            for(x = 0UL; x < w; x++) {
			      v = dk3bif_get_red(job->bif, x, y);
			      dk3bm_write_uc(of, v);
			      v = dk3bif_get_green(job->bif, x, y);
			      dk3bm_write_uc(of, v);
			      v = dk3bif_get_blue(job->bif, x, y);
			      dk3bm_write_uc(of, v);
			    }
#if DK3_USE_WX
		      dk3bmj_lines_progress(job->pComm,pbmin,pbmax,h,y);
#endif
		          }
			} break;
		      }
		    }
		  } else {
		    if(alphain) {
		      switch((job->opt)->pred) {
		        case DK3_COMPRESSION_PREDICTOR_TIFF: {
		          for(y = 0UL; y < h; y++) {
			    pl = 0; pu = 0; plu = 0;
		            for(x = 0UL; x < w; x++) {
			      v = dk3bif_get_mixed_red(job->bif, x, y);
			      dk3of_write_bits(of, (v - pl), job->bpc);
			      pl = v;
			      v = dk3bif_get_mixed_green(job->bif, x, y);
			      dk3of_write_bits(of, (v - pu), job->bpc);
			      pu = v;
			      v = dk3bif_get_mixed_blue(job->bif, x, y);
			      dk3of_write_bits(of, (v - plu), job->bpc);
			      plu = v;
			    }
			    dk3of_flush_bits(of);
#if DK3_USE_WX
		      dk3bmj_lines_progress(job->pComm,pbmin,pbmax,h,y);
#endif
		          }
			} break;
			default: {
		          for(y = 0UL; y < h; y++) {
		            for(x = 0UL; x < w; x++) {
			      v = dk3bif_get_mixed_red(job->bif, x, y);
			      dk3of_write_bits(of, v, job->bpc);
			      v = dk3bif_get_mixed_green(job->bif, x, y);
			      dk3of_write_bits(of, v, job->bpc);
			      v = dk3bif_get_mixed_blue(job->bif, x, y);
			      dk3of_write_bits(of, v, job->bpc);
			    }
			    dk3of_flush_bits(of);
#if DK3_USE_WX
		      dk3bmj_lines_progress(job->pComm,pbmin,pbmax,h,y);
#endif
		          }
			} break;
		      }
		    } else {
		      switch((job->opt)->pred) {
		        case DK3_COMPRESSION_PREDICTOR_TIFF: {
		          for(y = 0UL; y < h; y++) {
			    pl = 0; pu = 0; plu = 0;
		            for(x = 0UL; x < w; x++) {
			      v = dk3bif_get_red(job->bif, x, y);
			      dk3of_write_bits(of, (v - pl), job->bpc);
			      pl = v;
			      v = dk3bif_get_green(job->bif, x, y);
			      dk3of_write_bits(of, (v - pu), job->bpc);
			      pu = v;
			      v = dk3bif_get_blue(job->bif, x, y);
			      dk3of_write_bits(of, (v - plu), job->bpc);
			      plu = v;
			    }
			    dk3of_flush_bits(of);
#if DK3_USE_WX
		      dk3bmj_lines_progress(job->pComm,pbmin,pbmax,h,y);
#endif
		          }
			} break;
			default: {
		          for(y = 0UL; y < h; y++) {
		            for(x = 0UL; x < w; x++) {
			      v = dk3bif_get_red(job->bif, x, y);
			      dk3of_write_bits(of, v, job->bpc);
			      v = dk3bif_get_green(job->bif, x, y);
			      dk3of_write_bits(of, v, job->bpc);
			      v = dk3bif_get_blue(job->bif, x, y);
			      dk3of_write_bits(of, v, job->bpc);
			    }
			    dk3of_flush_bits(of);
#if DK3_USE_WX
		      dk3bmj_lines_progress(job->pComm,pbmin,pbmax,h,y);
#endif
		          }
			} break;
		      }
		    }
		  }
		  back = dk3of_end_chunk(of);
		} else {
		  /* ERROR: Failed to start encoded chunk! */
	          dk3bmj_log_1(
	            (job->opt)->app, DK3_LL_ERROR, job->msg, 59,
		    DK3_BMJ_LOG_BOTH, job
	          );
		}
	      } else {
	        /* ERROR: Failed to add run-length cell! */
	        dk3bmj_log_1(
	          (job->opt)->app, DK3_LL_ERROR, job->msg, 59,
		  DK3_BMJ_LOG_BOTH, job
	        );
	      }
            } break;
          }
	} else {
	  /* ERROR: Failed to add filter cell! */
	  dk3bmj_log_1(
	    (job->opt)->app, DK3_LL_ERROR, job->msg, 59,
	    DK3_BMJ_LOG_BOTH, job
	  );
	}
        dk3of_close(of);
      } else {
        /* ERROR: Failed to create output filter! */
	dk3bmj_log_1(
	  (job->opt)->app, DK3_LL_ERROR, job->msg, 59, DK3_BMJ_LOG_BOTH, job
	);
      }
      dk3stream_close(os);
    } else {
      /* ERROR: Failed to create output stream! */
      dk3bmj_log_1(
	(job->opt)->app, DK3_LL_ERROR, job->msg, 59, DK3_BMJ_LOG_BOTH, job
      );
    }
    /*
    	File footer.
    */
    if(job->do_header_footer) {
      dk3bm_ps_document_footer(job);
    }
  } else {				

#line 2028 "dk3bm.ctr"
    /* BUG: No output file! */
  }
#if DK3_USE_WX
  job->minpb = minpb;
  job->maxpb = maxpb;
#endif
  

#line 2035 "dk3bm.ctr"
  return back;
}



int
dk3bm_find_transformation(
  dk3_coordinates_transformation_t	*dst,
  dk3_bb_t				*outbb,
  int					 drawdir,
  double				 imw,
  double				 imh,
  double				 xres,
  double				 yres,
  int					*ec
)
{
  double		w = 0.0;	/* Image width. */
  double		h = 0.0;	/* Image height. */
  double		sx = 0.0;	/* X scale factor. */
  double		sy = 0.0;	/* Y scale factor. */
  double		sf = 0.0;	/* Scale factor. */
  double		xmin = 0.0;	/* Minimum X. */
  double		xmax = 0.0;	/* Maximum X. */
  double		ymin = 0.0;	/* Minimum Y. */
  double		ymax = 0.0;	/* Maximum Y. */
  double		xused = 0.0;	/* Used X range. */
  double		yused = 0.0;	/* Used Y range. */
  double		xborder = 0.0;	/* X border. */
  double		yborder = 0.0;	/* Y border. */
  int		 	mec  = 0;	/* Mathematical error code. */
  int		 	back = 0;
  

#line 2068 "dk3bm.ctr"
  if((dst) && (outbb)) {
    back = 1;
    w = imw;	

#line 2071 "dk3bm.ctr"
    h = imh;	

#line 2072 "dk3bm.ctr"
    if((xres > 0.0) && (yres > 0.0)) {
      w = dk3ma_d_div_ok(w, xres, &mec);	

#line 2074 "dk3bm.ctr"
      h = dk3ma_d_div_ok(h, yres, &mec);	

#line 2075 "dk3bm.ctr"
    }
    sx = sy = sf = 0.0;
    switch(drawdir) {
      case DK3_IMAGE_ORIGIN_LEFT_BOTTOM:
      case DK3_IMAGE_ORIGIN_RIGHT_TOP:
      case DK3_IMAGE_ORIGIN_LEFT_TOP_FLIPPED:
      case DK3_IMAGE_ORIGIN_RIGHT_BOTTOM_FLIPPED:
      {
        sx = dk3ma_d_div_ok(
	  dk3ma_d_sub_ok(outbb->xmax, outbb->xmin, ec),
	  h,
	  ec
	);
	sy = dk3ma_d_div_ok(
	  dk3ma_d_sub_ok(outbb->ymax, outbb->ymin, ec),
	  w,
	  ec
	);
	if(sx < sy) {	/* Entire X range used. */
	  xmin = outbb->xmin;
	  xmax = outbb->xmax;
	  xused = dk3ma_d_sub_ok(xmax, xmin, ec);
	  xborder = 0.0;
	  yused = dk3ma_d_mul_ok(sx, w, ec);
	  yborder = 0.5 * dk3ma_d_sub_ok(
	    dk3ma_d_sub_ok(outbb->ymax, outbb->ymin, ec),
	    yused,
	    ec
	  );
	  if(yborder < 0.0) { yborder = 0.0; }
	  ymin = dk3ma_d_add_ok(outbb->ymin, yborder, ec);
	  ymax = dk3ma_d_add_ok(ymin, yused, ec);
	} else {	/* Entire Y range used. */
	  ymin = outbb->ymin;
	  ymax = outbb->ymax;
	  yused = dk3ma_d_sub_ok(ymax, ymin, ec);
	  yborder = 0.0;
	  xused = dk3ma_d_mul_ok(sy, h, ec);
	  xborder = 0.5 * dk3ma_d_sub_ok(
	    dk3ma_d_sub_ok(outbb->xmax, outbb->xmin, ec),
	    xused,
	    ec
	  );
	  if(xborder < 0.0) { xborder = 0.0; }
	  xmin = dk3ma_d_add_ok(outbb->xmin, xborder, ec);
	  xmax = dk3ma_d_add_ok(xmin, xused, ec);
	}
      } break;
      default: {
        sx = dk3ma_d_div_ok(
	  dk3ma_d_sub_ok(outbb->xmax, outbb->xmin, ec),
	  w,
	  ec
	);
	sy = dk3ma_d_div_ok(
	  dk3ma_d_sub_ok(outbb->ymax, outbb->ymin, ec),
	  h,
	  ec
	);
	if(sx < sy) {	/* Entire X range used. */
	  xmin = outbb->xmin;
	  xmax = outbb->xmax;
	  xused = dk3ma_d_sub_ok(xmax, xmin, ec);
	  xborder = 0.0;
	  yused = dk3ma_d_mul_ok(sx, h, ec);
	  yborder = 0.5 * dk3ma_d_sub_ok(
	    dk3ma_d_sub_ok(outbb->ymax, outbb->ymin, ec),
	    yused,
	    ec
	  );
	  if(yborder < 0.0) { yborder = 0.0; }
	  ymin = dk3ma_d_add_ok(outbb->ymin, yborder, ec);
	  ymax = dk3ma_d_add_ok(ymin, yused, ec);
	} else {	/* Entire Y range used. */
	  ymin = outbb->ymin;
	  ymax = outbb->ymax;
	  yused = dk3ma_d_sub_ok(ymax, ymin, ec);
	  yborder = 0.0;
	  xused = dk3ma_d_mul_ok(sy, w, ec);
	  xborder = 0.5 * dk3ma_d_sub_ok(
	    dk3ma_d_sub_ok(outbb->xmax, outbb->xmin, ec),
	    xused,
	    ec
	  );
	  if(xborder < 0.0) { xborder = 0.0; }
	  xmin = dk3ma_d_add_ok(outbb->xmin, xborder, ec);
	  xmax = dk3ma_d_add_ok(xmin, xused, ec);
	}
      } break;
    }
    dst->x_scale = xused;
    dst->y_scale = yused;
    

#line 2168 "dk3bm.ctr"
    

#line 2169 "dk3bm.ctr"
    

#line 2170 "dk3bm.ctr"
    

#line 2171 "dk3bm.ctr"
    

#line 2172 "dk3bm.ctr"
    

#line 2173 "dk3bm.ctr"
    dst->rot = 0;
    switch(drawdir) {
      case DK3_IMAGE_ORIGIN_LEFT_BOTTOM: {		/* 1 */
        dst->x_translate = xmax;
	dst->y_translate = ymin;
	dst->rot = 1;
        dst->x_scale = yused;
        dst->y_scale = xused;
      } break;
      case DK3_IMAGE_ORIGIN_RIGHT_TOP: {		/* 2 */
        dst->x_translate = xmin;
	dst->y_translate = ymax;
	dst->rot = 3;
        dst->x_scale = yused;
        dst->y_scale = xused;
      } break;
      case DK3_IMAGE_ORIGIN_RIGHT_BOTTOM: {		/* 3 */
        dst->x_translate = xmax;
	dst->y_translate = ymax;
	dst->rot = 2;
      } break;
      case DK3_IMAGE_ORIGIN_LEFT_TOP_FLIPPED: {		/* 4 */
        dst->x_translate = xmax;
	dst->y_translate = ymax;
	dst->rot = 1;
        dst->x_scale = yused;
        dst->y_scale = xused;
	dst->x_scale = -1.0 * (dst->x_scale);
      } break;
      case DK3_IMAGE_ORIGIN_LEFT_BOTTOM_FLIPPED: {	/* 5 */
        dst->x_translate = xmin;
	dst->y_translate = ymax;
	dst->y_scale = -1.0 * (dst->y_scale);
      } break;
      case DK3_IMAGE_ORIGIN_RIGHT_TOP_FLIPPED: {	/* 6 */
         dst->x_translate = xmax;
	 dst->y_translate = ymin;
	 dst->x_scale = -1.0 * (dst->x_scale);
      } break;
      case DK3_IMAGE_ORIGIN_RIGHT_BOTTOM_FLIPPED: {	/* 7 */
        dst->x_translate = xmin;
	dst->y_translate = ymin;
	dst->rot = 3;
        dst->x_scale = yused;
        dst->y_scale = xused;
	dst->x_scale = -1.0 * (dst->x_scale);
      } break;
      default: {	/* left top */
        dst->x_translate = xmin;
	dst->y_translate = ymin;
	dst->rot = 0;
      } break;
    }
    

#line 2227 "dk3bm.ctr"
    

#line 2228 "dk3bm.ctr"
    

#line 2229 "dk3bm.ctr"
    

#line 2230 "dk3bm.ctr"
    

#line 2231 "dk3bm.ctr"
  }
  if(mec) {
    if(ec) { *ec = mec; }
  } 

#line 2235 "dk3bm.ctr"
  return back;
}



int
dk3bm_find_bif_transformation(
  dk3_coordinates_transformation_t	*dst,
  dk3_bif_t				*bif,
  dk3_bb_t				*outbb,
  int					 drawdir,
  int					*ec
)
{
  double		 w;
  double		 h;
  double		 xres;
  double		 yres;
  dk3_bif_coord_t	 imw;
  dk3_bif_coord_t	 imh;
  int			 back = 0;
  

#line 2257 "dk3bm.ctr"
  if((dst) && (bif) && (outbb)) {
    imw = dk3bif_get_width(bif);
    imh = dk3bif_get_height(bif);
    w = (double)imw;
    h = (double)imh;
    xres = dk3bif_get_xres(bif);
    yres = dk3bif_get_yres(bif);
    back = dk3bm_find_transformation(dst, outbb, drawdir, w, h, xres, yres, ec);
  } 

#line 2266 "dk3bm.ctr"
  return back;
}



int
dk3bm_ps_place_object(
  FILE				*dfile,
  dk3_bb_t			*outbb,
  int				 drawdir,
  char const			*sfn,
  dk3_app_t			*app,
  int				 pslevel,
  int				*ec
)
{
  dk3_coordinates_transformation_t	trans;
  dk3_bm_eps_options_t			bmeo;
  dk3_bm_conversion_job_t		job;
  int					back = 0;
  

#line 2287 "dk3bm.ctr"
  if((dfile) && (outbb) && (sfn) && (app)) {
    dk3bmj_init(&job, app);
    dk3bmeo_init(&bmeo);	

#line 2290 "dk3bm.ctr"
    job.opt = &bmeo;
    job.sfn = NULL;
    job.dfile = dfile;
    job.do_header_footer = 0;
    bmeo.app = app;
    bmeo.ima.ia.xl = outbb->xmin;
    bmeo.ima.ia.xr = outbb->xmax;
    bmeo.ima.ia.yb = outbb->ymin;
    bmeo.ima.ia.yt = outbb->ymax;
#if VERSION_BEFORE_20140902
    bmeo.mode =
    bmeo.szmode =
    bmeo.dr = DK3_BMEPS_DRIVER_EPS;
#else
    bmeo.mode =		DK3_BMEPS_MODE_OBJECT;
    bmeo.szmode =	DK3_BMEPS_SIZE_1_1;	

#line 2306 "dk3bm.ctr"
    bmeo.dr = 		DK3_BMEPS_DRIVER_EPS;
#endif
    bmeo.io = drawdir;
    bmeo.psl = pslevel;
    job.bif = dk3bif_open_c8_filename_app(sfn,DK3_BIF_IMAGE_TYPE_UNKNOWN,app);
    if(job.bif) {		

#line 2312 "dk3bm.ctr"
      job.biftype = dk3bif_get_type(job.bif);
      /* job.procedure = */	

#line 2314 "dk3bm.ctr"
      /* job->x_size */
      /* job->y_size */
      /* job->x_0 */
      /* job->x_1 */
      /* job->y_0 */
      /* job->y_1 */
      /* job->procedure */
      /* job->bpc */
      /* job->nPages */
      /* job->currentPage */
      if(dk3bm_find_bif_transformation(&trans, job.bif, outbb, drawdir, ec)) {
        /* FIG2LAT */			

#line 2326 "dk3bm.ctr"
	job.x_translate = trans.x_translate;
	job.y_translate = trans.y_translate;
	job.x_scale = trans.x_scale;
	job.y_scale = trans.y_scale;
	job.do_rotate = trans.rot;
	job.do_translate = 1;
	job.do_float_scale = 1;		

#line 2333 "dk3bm.ctr"
	if(dk3bif_read_data(job.bif)) {
	  back = dk3bm_job_produce_img_job_real_ps(&job);
	} else {
	  /* ##### ERROR: Failed to read image data! */
	}
      } else {
        /* ##### ERROR: Failed to calculate transformation data */
      }
      dk3bif_close(job.bif);
    } else {			

#line 2343 "dk3bm.ctr"
      /* ##### ERROR: Failed to open image */
    }
  } else {			

#line 2346 "dk3bm.ctr"
  } 

#line 2347 "dk3bm.ctr"
  return back;
}



/**	Paper size check function.
	@param	ps	Paper size to check.
	@return	1 on success, 0 on error (borders larger than paper).
*/
static
int
dk3bm_check_paper_size(dk3_paper_size_t *ps)
{
  int back = 0;
  

#line 2362 "dk3bm.ctr"
  if(ps->w > (ps->i + ps->o)) {
    if(ps->h > (ps->t + ps->b)) {
      back = 1;
    }
  } 

#line 2367 "dk3bm.ctr"
  return back;
}



/**	Produce PS draft for image or object.
	The x_0, x_1, y_0 and y_1  values must be set.
	@param	job	Conversion job.
	@return	1 on succes, 0 on error.
*/
static
int
dk3bm_job_produce_img_job_draft_ps(dk3_bm_conversion_job_t *job)
{
  char		outputbuffer[256];	/* Conversion buffer for numbers. */
  double	dx;			/* Stripe width. */
  double	dy;			/* Stripe width backup. */
  int		back	= 0;
  

#line 2386 "dk3bm.ctr"
  dk3bm_ps_document_header(job, job->nPages);
  fputs(dk3bm_c8_kw[4], job->dfile);
  fputs(dk3bm_c8_kw[21], job->dfile);
  fputs(dk3bm_c8_kw[71], job->dfile);
  sprintf(outputbuffer, dk3bm_c8_kw[72], job->x_0, job->y_0);
  dk3bm_correct_output_buffer(outputbuffer);
  fputs(outputbuffer, job->dfile);
  sprintf(outputbuffer, dk3bm_c8_kw[73], job->x_1, job->y_0);
  dk3bm_correct_output_buffer(outputbuffer);
  fputs(outputbuffer, job->dfile);
  sprintf(outputbuffer, dk3bm_c8_kw[73], job->x_1, job->y_1);
  dk3bm_correct_output_buffer(outputbuffer);
  fputs(outputbuffer, job->dfile);
  sprintf(outputbuffer, dk3bm_c8_kw[73], job->x_0, job->y_1);
  dk3bm_correct_output_buffer(outputbuffer);
  fputs(outputbuffer, job->dfile);
  fputs(dk3bm_c8_kw[74], job->dfile);
  dx = 0.01 * (job->x_1 - job->x_0);
  dy = 0.01 * (job->y_1 - job->y_0);
  if(dy < dx) dx = dy;
  if(dx > 2.8) dx = 2.8;
  fputs(dk3bm_c8_kw[75], job->dfile);
  sprintf(outputbuffer, dk3bm_c8_kw[72], job->x_0+dx, job->y_0+dx);
  dk3bm_correct_output_buffer(outputbuffer);
  fputs(outputbuffer, job->dfile);
  sprintf(outputbuffer, dk3bm_c8_kw[73], job->x_1-dx, job->y_0+dx);
  dk3bm_correct_output_buffer(outputbuffer);
  fputs(outputbuffer, job->dfile);
  sprintf(outputbuffer, dk3bm_c8_kw[73], job->x_1-dx, job->y_1-dx);
  dk3bm_correct_output_buffer(outputbuffer);
  fputs(outputbuffer, job->dfile);
  sprintf(outputbuffer, dk3bm_c8_kw[73], job->x_0+dx, job->y_1-dx);
  dk3bm_correct_output_buffer(outputbuffer);
  fputs(outputbuffer, job->dfile);
  fputs(dk3bm_c8_kw[74], job->dfile);
  dx = 10.0 * dx;
  fputs(dk3bm_c8_kw[76], job->dfile);
  sprintf(outputbuffer, dk3bm_c8_kw[72], job->x_0+dx, job->y_0+dx);
  dk3bm_correct_output_buffer(outputbuffer);
  fputs(outputbuffer, job->dfile);
  sprintf(outputbuffer, dk3bm_c8_kw[73], job->x_1-dx, job->y_0+dx);
  dk3bm_correct_output_buffer(outputbuffer);
  fputs(outputbuffer, job->dfile);
  sprintf(outputbuffer, dk3bm_c8_kw[73], job->x_1-dx, job->y_1-dx);
  dk3bm_correct_output_buffer(outputbuffer);
  fputs(outputbuffer, job->dfile);
  sprintf(outputbuffer, dk3bm_c8_kw[73], job->x_0+dx, job->y_1-dx);
  dk3bm_correct_output_buffer(outputbuffer);
  fputs(outputbuffer, job->dfile);
  fputs(dk3bm_c8_kw[74], job->dfile);
  sprintf(outputbuffer, dk3bm_c8_kw[77], 0.9 * dx);
  dk3bm_correct_output_buffer(outputbuffer);
  fputs(outputbuffer, job->dfile);
  fputs(dk3bm_c8_kw[75], job->dfile);
  sprintf(outputbuffer, dk3bm_c8_kw[72], job->x_0+dx, job->y_0+dx);
  dk3bm_correct_output_buffer(outputbuffer);
  fputs(outputbuffer, job->dfile);
  sprintf(outputbuffer, dk3bm_c8_kw[73], job->x_1-dx, job->y_1-dx);
  dk3bm_correct_output_buffer(outputbuffer);
  fputs(outputbuffer, job->dfile);
  fputs(dk3bm_c8_kw[79], job->dfile);
  fputs(dk3bm_c8_kw[78], job->dfile);
  sprintf(outputbuffer, dk3bm_c8_kw[72], job->x_0+dx, job->y_1-dx);
  dk3bm_correct_output_buffer(outputbuffer);
  fputs(outputbuffer, job->dfile);
  sprintf(outputbuffer, dk3bm_c8_kw[73], job->x_1-dx, job->y_0+dx);
  dk3bm_correct_output_buffer(outputbuffer);
  fputs(outputbuffer, job->dfile);
  fputs(dk3bm_c8_kw[79], job->dfile);
  fputs(dk3bm_c8_kw[5], job->dfile);
  switch((job->opt)->mode) {
    case DK3_BMEPS_MODE_IMAGE:
    case DK3_BMEPS_MODE_DOCUMENT: {
        if((job->opt)->dr == DK3_BMEPS_DRIVER_PS) {
          fputs(dk3bm_c8_kw[6], job->dfile);			/* showpage */
	}
    } break;
  }
  dk3bm_ps_document_footer(job);
  

#line 2466 "dk3bm.ctr"
  return back;
}



/**	Do the real work when producing a PS document.
	@param	job	Job structure.
	@return	1 on success, 0 on error.
*/
static
int
dk3bm_job_produce_doc_real_ps(dk3_bm_conversion_job_t *job)
{
  double		dmaxwidth	= 0.0;	/* Max width PS points. */
  double		dmaxheight	= 0.0;	/* Max height PS points. */
  double		xres;			/* X res current frame. */
  double		yres;			/* Y res current frame. */
  double		deltax;			/* Real x width. */
  double		deltay;			/* Real y width. */
  double		sx;			/* Scale factor x. */
  double		sy;			/* Scale factor y. */
  dk3_bif_coord_t	maxwidth	= 0L;	/* Max width pixels. */
  dk3_bif_coord_t	maxheight	= 0L;	/* Max height pixels. */
  dk3_bif_coord_t	w;			/* Current frame width. */
  dk3_bif_coord_t	h;			/* Current frame height. */
  size_t		nFrames;		/* Number of frames. */
  size_t		cf;			/* Current frame. */
  int			me		= 0;	/* Math error. */
  int			workmode	= 0;	/* Transformation mode. */
  int			back		= 1;
  int			must_rotate	= 0;	/* Flag: Must rotate. */
#if DK3_USE_WX
  int			minpb;		/* Original min progress bar value. */
  int			maxpb;		/* Original max progress bar value. */
#endif
  

#line 2502 "dk3bm.ctr"
#if DK3_USE_WX
  minpb = job->minpb;
  maxpb = job->maxpb;
#endif
  switch((job->opt)->szmode) {
    case DK3_BMEPS_SIZE_1_1: {		

#line 2508 "dk3bm.ctr"
      workmode = 0;
    } break;
    case DK3_BMEPS_SIZE_CHUNK: case DK3_BMEPS_SIZE_SPECIFIED: {
      workmode = 1;			

#line 2512 "dk3bm.ctr"
    } break;
    case DK3_BMEPS_SIZE_PAPER: {	

#line 2514 "dk3bm.ctr"
      workmode = 2;
      if(!dk3bm_check_paper_size(&(((job->opt)->ima).ps))) {
        back = 0;
	/* ERROR: Incorrect paper size setup! */
	dk3bmj_log_1(
	  (job->opt)->app, DK3_LL_ERROR, job->msg, 62, DK3_BMJ_LOG_BOTH, job
	);
      }
    } break;
  }
  if(back) {
    nFrames = dk3bif_number_of_frames(job->bif);
    for(cf = 0; cf < nFrames; cf++) {
      dk3bif_set_frame(job->bif, cf);
      job->currentPage = cf + 1;
      w = dk3bif_get_width(job->bif);
      h = dk3bif_get_height(job->bif);
      if(w > maxwidth) { maxwidth = w; }
      if(h > maxheight) { maxheight = h; }
      if(workmode == 1) {
        switch((job->opt)->szmode) {
	  case DK3_BMEPS_SIZE_SPECIFIED: {	

#line 2536 "dk3bm.ctr"
	    xres = yres = (job->opt)->resolution;
	  } break;
	  default: {				

#line 2539 "dk3bm.ctr"
	    xres = dk3bif_get_xres(job->bif);
	    yres = dk3bif_get_yres(job->bif);
	  } break;
        }
        if(xres <= 0.0) { xres = 72.0; }
        if(yres <= 0.0) { yres = 72.0; }
	if(fabs(xres - 72.0) > dk3bm_epsilon) {
          deltax = dk3ma_d_mul_ok(
            72.0,
	    dk3ma_d_div_ok(dk3bm_l_to_d(w), xres, &me),
	    &me
          );
	} else {
	  deltax = dk3bm_l_to_d(w);
	}
	if(fabs(yres - 72.0) > dk3bm_epsilon) {
          deltay = dk3ma_d_mul_ok(
            72.0,
	    dk3ma_d_div_ok(dk3bm_l_to_d(h), yres, &me),
	    &me
          );
	} else {
	  deltay = dk3bm_l_to_d(h);
	}
        if(deltax > dmaxwidth) { dmaxwidth = deltax; }
        if(deltay > dmaxheight) { dmaxheight = deltay; }
      }
    }
    switch(workmode) {
      case 0: {
        job->x_size = maxwidth;
        job->y_size = maxheight;
      } break;
      case 1: {
        dmaxwidth = ceil(dmaxwidth);
        dmaxheight = ceil(dmaxheight);
        job->x_size = dk3ma_d_to_l_ok(dmaxwidth, &me);
        job->y_size = dk3ma_d_to_l_ok(dmaxheight, &me);
      } break;
      case 2: {
        job->x_size = dk3ma_d_to_l_ok(floor(((job->opt)->ima).ps.w), &me);
        job->y_size = dk3ma_d_to_l_ok(floor(((job->opt)->ima).ps.h), &me);
      } break;
    }
    /*
  	  Produce output.
    */
    if(back) {
      job->nPages = nFrames;
      dk3bm_ps_document_header(job, job->nPages);
      job->do_header_footer = 0;
      for(cf = 0; cf < nFrames; cf++) {
#if DK3_USE_WX
	job->minpb = minpb + (int)cf * (maxpb - minpb) / (int)nFrames;
	job->maxpb = minpb + (1 + (int)cf) * (maxpb - minpb) / (int)nFrames;
	if(job->minpb < minpb) { job->minpb = minpb; }
	if(job->maxpb > maxpb) { job->maxpb = maxpb; }
#endif
        dk3bif_set_frame(job->bif, cf);
	w = dk3bif_get_width(job->bif);
	h = dk3bif_get_height(job->bif);
        job->currentPage = cf + 1;
        job->x_translate = 0.0;
        job->y_translate = 0.0;
        job->x_0 = 0.0;
        job->y_0 = 0.0;
        job->x_1 = 0.0;
        job->y_1 = 0.0;
        job->x_scale = 1.0;
        job->y_scale = 1.0;
        job->do_translate = 0;
        job->do_float_scale = 0;
        job->do_rotate = 0;
        must_rotate = 0;
        switch(workmode) {
          case 0: {
	    if(w < maxwidth) {
	      job->x_translate = 0.5 * dk3bm_l_to_d(maxwidth - w);
	      job->do_translate = 1;
	    }
	    if(h < maxheight) {
	      job->y_translate = 0.5 * dk3bm_l_to_d(maxheight - h);
	      job->do_translate = 1;
	    }
	    if(job->do_translate) {
	      job->x_scale = dk3bm_l_to_d(w);
	      job->y_scale = dk3bm_l_to_d(h);
	      job->do_float_scale = 1;
	    }
	  } break;
	  case 1: {
	    job->do_float_scale = 1;
	    job->do_translate = 1;
            switch((job->opt)->szmode) {
	      case DK3_BMEPS_SIZE_SPECIFIED: {	

#line 2634 "dk3bm.ctr"
	        xres = yres = (job->opt)->resolution;
	      } break;
	      default: {			

#line 2637 "dk3bm.ctr"
	        xres = dk3bif_get_xres(job->bif);
	        yres = dk3bif_get_yres(job->bif);
	      } break;
            }
            if(xres <= 0.0) { xres = 72.0; }
            if(yres <= 0.0) { yres = 72.0; }
	    if(fabs(xres - 72.0) > dk3bm_epsilon) {
              deltax = dk3ma_d_mul_ok(
                72.0,
	        dk3ma_d_div_ok(dk3bm_l_to_d(w), xres, &me),
	        &me
              );
	    } else {
	      deltax = dk3bm_l_to_d(w);
	    }
	    if(fabs(yres - 72.0) > dk3bm_epsilon) {
              deltay = dk3ma_d_mul_ok(
                72.0,
	        dk3ma_d_div_ok(dk3bm_l_to_d(h), yres, &me),
	        &me
              );
	    } else {
	      deltay = dk3bm_l_to_d(h);
	    }
	    job->x_scale = deltax;
	    job->y_scale = deltay;
	    job->x_translate = 0.5 * (dmaxwidth - deltax);
	    job->y_translate = 0.5 * (dmaxheight - deltay);
	  } break;
	  case 2: {
	    job->do_float_scale = 1;
	    job->do_translate = 1;
	    if((job->opt)->duplex) {
	      if((job->opt)->tumble) {
	        if((job->currentPage) % 2) {
	          job->y_0 = ((job->opt)->ima).ps.b;
		  job->y_1 = ((job->opt)->ima).ps.h - ((job->opt)->ima).ps.t;
	        } else {
	          job->y_0 = ((job->opt)->ima).ps.t;
		  job->y_1 = ((job->opt)->ima).ps.h - ((job->opt)->ima).ps.b;
	        }
	        job->x_0 = ((job->opt)->ima).ps.i;
	        job->x_1 = ((job->opt)->ima).ps.w - ((job->opt)->ima).ps.o;
	      } else {
	        if((job->currentPage) % 2) {
	          job->x_0 = ((job->opt)->ima).ps.i;
		  job->x_1 = ((job->opt)->ima).ps.w - ((job->opt)->ima).ps.o;
	        } else {
	          job->x_0 = ((job->opt)->ima).ps.o;
		  job->x_1 = ((job->opt)->ima).ps.w - ((job->opt)->ima).ps.i;
	        }
	        job->y_0 = ((job->opt)->ima).ps.b;
	        job->y_1 = ((job->opt)->ima).ps.h - ((job->opt)->ima).ps.t;
	      }
	    } else {
	      job->x_0 = ((job->opt)->ima).ps.i;
	      job->x_1 = ((job->opt)->ima).ps.w - ((job->opt)->ima).ps.o;
	      job->y_0 = ((job->opt)->ima).ps.b;
	      job->y_1 = ((job->opt)->ima).ps.h - ((job->opt)->ima).ps.t;
	    }
	    xres = dk3bif_get_xres(job->bif);
	    yres = dk3bif_get_yres(job->bif);
	    if(xres <= 0.0) xres = 72.0;
	    if(yres <= 0.0) yres = 72.0;
	    if(fabs(xres - 72.0) > dk3bm_epsilon) {
              deltax = dk3ma_d_mul_ok(
                72.0,
	        dk3ma_d_div_ok(dk3bm_l_to_d(w), xres, &me),
	        &me
              );
	    } else {
	      deltax = dk3bm_l_to_d(w);
	    }
	    if(fabs(yres - 72.0) > dk3bm_epsilon) {
              deltay = dk3ma_d_mul_ok(
                72.0,
	        dk3ma_d_div_ok(dk3bm_l_to_d(h), yres, &me),
	        &me
              );
	    } else {
	      deltay = dk3bm_l_to_d(h);
	    }
	    if((job->y_1 - job->y_0) > (job->x_1 - job->x_0)) {
	      if(deltax > deltay) {
	        must_rotate = 1;
	      }
	    } else {
	      if((job->y_1 - job->y_0) < (job->x_1 - job->x_0)) {
	        if(deltax > deltay) {
	          must_rotate = 1;
	        }
	      }
	    }
	    if(must_rotate) {
	      job->do_rotate = 1;
	      sx = dk3ma_d_div_ok((job->y_1 - job->y_0), deltax, &me);
	      sy = dk3ma_d_div_ok((job->x_1 - job->x_0), deltay, &me);
	      if(sx < sy) {
	        job->x_scale = job->y_1 - job->y_0;
	        job->y_scale = dk3ma_d_mul_ok(sx, deltay, &me);
	        job->x_translate = job->x_1 - 0.5 * (job->x_1 - job->x_0 - job->y_scale);
	        job->y_translate = job->y_0;
	      } else {
	        job->y_scale = job->x_1 - job->x_0;
	        job->x_scale = dk3ma_d_mul_ok(sy, deltax, &me);
	        job->x_translate = job->x_1;
	        job->y_translate = job->y_0 + 0.5 * (job->y_1 - job->y_0 - job->x_scale);
	      }
	    } else {
	      sx = dk3ma_d_div_ok((job->x_1 - job->x_0), deltax, &me);
	      sy = dk3ma_d_div_ok((job->y_1 - job->y_0), deltay, &me);
	      if(sx < sy) {
	        job->x_scale = job->x_1 - job->x_0;
	        job->y_scale = dk3ma_d_mul_ok(sx, deltay, &me);
	        job->x_translate = job->x_0;
	        job->y_translate = job->y_0 + 0.5 * (job->y_1 - job->y_0 - job->y_scale);
	      } else {
	        job->y_scale = job->y_1 - job->y_0;
	        job->x_scale = dk3ma_d_mul_ok(sy, deltax, &me);
	        job->y_translate = job->y_0;
	        job->x_translate = job->x_0 + 0.5 * (job->x_1 - job->x_0 - job->x_scale);
	      }
	    }
	    

#line 2761 "dk3bm.ctr"
	    

#line 2762 "dk3bm.ctr"
	    

#line 2763 "dk3bm.ctr"
	    

#line 2764 "dk3bm.ctr"
	    

#line 2765 "dk3bm.ctr"
	  } break;
        }
        /*
      	  Output current frame.
        */
        if(back) {
          if(!dk3bm_job_produce_img_job_real_ps(job)) {
	    back = 0;
	  }
        }
#if DK3_USE_WX
	dk3bmj_progress(job->pComm, job->maxpb);
#endif
      }
      dk3bm_ps_document_footer(job);
    }
  }
#if DK3_USE_WX
  job->minpb = minpb;
  job->maxpb = maxpb;
#endif
  

#line 2787 "dk3bm.ctr"
  return back;
}
  
  

/**	Produce PS document.
	@param	job	Conversion job.
	@return	1 on success, 0 on error.
*/
static
int
dk3bm_job_produce_doc_ps(dk3_bm_conversion_job_t *job)
{
  int		back	= 0;
#if DK3_USE_WX
  int		min;		/* Original min progress bar value. */
  int		max;		/* Original max progress bar value. */
#endif
  /* PROGRESS: Reading image. */
  

#line 2807 "dk3bm.ctr"
  dk3app_log_1((job->opt)->app, DK3_LL_PROGRESS, job->msg, 47);
#if DK3_USE_WX
  min = job->minpb;
  max = job->maxpb;
#endif
  if(dk3bif_read_data(job->bif)) {		

#line 2813 "dk3bm.ctr"
#if DK3_USE_WX
    

#line 2815 "dk3bm.ctr"
    dk3bmj_progress(job->pComm, job->minpb + (job->maxpb - job->minpb)/3);
    job->minpb = job->minpb + ((job->maxpb - job->minpb)/3);
#endif
    if(job->dfile) {
      back = dk3bm_job_produce_doc_real_ps(job);
    } else {
      job->dfile = dk3sf_fopen_app(
        job->dfn,
	dk3app_not_localized(24),
	(job->opt)->app
      );
      if(job->dfile) {
        back = dk3bm_job_produce_doc_real_ps(job);
        if(!dk3sf_fclose_fn_app(job->dfile, job->dfn, (job->opt)->app)) {
	  back = 0;
	}
	job->dfile = NULL;
      } else {
        /* ERROR: Failed to open output file! */
	dk3bmj_log_i3(
	  (job->opt)->app, DK3_LL_ERROR, 77, 78, job->dfn, DK3_BMJ_LOG_JOB, job
	);
      }
    }
  } else {					

#line 2840 "dk3bm.ctr"
    /* ERROR: Failed to read image data! */
    dk3bmj_log_1(
      (job->opt)->app, DK3_LL_ERROR, job->msg, 61, DK3_BMJ_LOG_BOTH, job
    );
  }
#if DK3_USE_WX
  job->minpb = min;
  job->maxpb = max;
#endif
  

#line 2850 "dk3bm.ctr"
  return back;
}



/**	Produce PS image or object.
	@param	job	Conversion job.
	@return	1 on success, 0 on error.
*/
static
int
dk3bm_job_produce_img_obj_ps(dk3_bm_conversion_job_t *job)
{
  double	w;		/* Image width used. */
  double	h;		/* Image height used. */
  double	xr = 0.0;	/* X resolution. */
  double	yr = 0.0;	/* Y resolution. */
  int		back	= 1;
  int		ur	= 0;	/* Flag: Use resolution. */
  int		ec	= 0;	/* Math error code. */
  

#line 2871 "dk3bm.ctr"
  /*
  	Prepare for size 1:1.
  */
  job->x_size = dk3bif_get_width(job->bif);
  job->y_size = dk3bif_get_height(job->bif);
  job->x_1 = dk3bm_l_to_d(job->x_size);
  job->y_1 = dk3bm_l_to_d(job->y_size);
  

#line 2879 "dk3bm.ctr"
  /*
  	Attempt to use other size/resolution if required.
  */
  switch((job->opt)->szmode) {
    case DK3_BMEPS_SIZE_CHUNK: {		

#line 2884 "dk3bm.ctr"
      xr = dk3bif_get_xres(job->bif);
      yr = dk3bif_get_yres(job->bif);		

#line 2886 "dk3bm.ctr"
      if((xr > 0.0) && (yr > 0.0)) {
        

#line 2888 "dk3bm.ctr"
        if(fabs(xr - 72.0) > dk3bm_epsilon) {
	  ur = 1;
	}
	

#line 2892 "dk3bm.ctr"
	if(fabs(yr - 72.0) > dk3bm_epsilon) {
	  ur = 1;
	}
      }
    } break;
    case DK3_BMEPS_SIZE_SPECIFIED: {		

#line 2898 "dk3bm.ctr"
      if((job->opt)->resolution > 0.0) {
        

#line 2900 "dk3bm.ctr"
        if(fabs((job->opt)->resolution - 72.0) > dk3bm_epsilon) {
	  xr = yr = (job->opt)->resolution;	

#line 2902 "dk3bm.ctr"
	  ur = 1;
	}
      }
    } break;
  }
  /*
  	If we have to use a resolution, calculate dimensions.
  */
  if(ur) {					

#line 2911 "dk3bm.ctr"
    w = dk3bm_l_to_d(job->x_size);	

#line 2912 "dk3bm.ctr"
    h = dk3bm_l_to_d(job->y_size);	

#line 2913 "dk3bm.ctr"
    w = dk3ma_d_mul_ok(72.0, dk3ma_d_div_ok(w, xr, &ec), &ec);
    h = dk3ma_d_mul_ok(72.0, dk3ma_d_div_ok(h, yr, &ec), &ec);
    job->x_1 = ceil(w); 

#line 2916 "dk3bm.ctr"
    job->y_1 = ceil(h);
    job->x_size = dk3ma_d_to_l_ok(job->x_1, &ec);
    job->y_size = dk3ma_d_to_l_ok(job->y_1, &ec);
    

#line 2920 "dk3bm.ctr"
    job->x_translate = 0.5 * (job->x_1 - w);
    job->y_translate = 0.5 * (job->y_1 - h);
    if(job->x_translate < 0.0) { job->x_translate = 0.0; }
    if(job->y_translate < 0.0) { job->y_translate = 0.0; }
    job->do_translate = 1;
    job->x_0 = job->x_translate;
    job->y_0 = job->y_translate;
    job->x_1 = job->x_0 + w;
    job->y_1 = job->y_0 + h;
    if(job->x_1 > dk3bm_l_to_d(job->x_size)) {
      job->x_1 = dk3bm_l_to_d(job->x_size);
    }
    if(job->y_1 > dk3bm_l_to_d(job->y_size)) {
      job->y_1 = dk3bm_l_to_d(job->y_size);
    }
    job->x_scale = w;
    job->y_scale = h;
    job->do_float_scale = 1;
    

#line 2939 "dk3bm.ctr"
    

#line 2940 "dk3bm.ctr"
    

#line 2941 "dk3bm.ctr"
    

#line 2942 "dk3bm.ctr"
    

#line 2943 "dk3bm.ctr"
    

#line 2944 "dk3bm.ctr"
    

#line 2945 "dk3bm.ctr"
    

#line 2946 "dk3bm.ctr"
    

#line 2947 "dk3bm.ctr"
    

#line 2948 "dk3bm.ctr"
    if(ec) {					

#line 2949 "dk3bm.ctr"
      back = 0;
      dk3bmj_log_i1(
        (job->opt)->app, DK3_LL_ERROR, 260, DK3_BMJ_LOG_BOTH, job
      );
    }
  }
  /*
  	If no error yet, go on.
  */
  if(back) {
    if((job->opt)->draft) {			

#line 2960 "dk3bm.ctr"
      if(job->dfile) {				

#line 2961 "dk3bm.ctr"
	back = dk3bm_job_produce_img_job_draft_ps(job);
      } else {					

#line 2963 "dk3bm.ctr"
        job->dfile = dk3sf_fopen_app(
	  job->dfn,
	  dk3app_not_localized(24),
	  (job->opt)->app
	);
	if(job->dfile) {			

#line 2969 "dk3bm.ctr"
	  back = dk3bm_job_produce_img_job_draft_ps(job);
	  if(!dk3sf_fclose_fn_app(job->dfile, job->dfn, (job->opt)->app)) {
	    back = 0;
	  }
	  job->dfile = NULL;
	} else {				

#line 2975 "dk3bm.ctr"
	  back = 0;
	  /* ERROR: Failed to open output file! */
	  dk3bmj_log_i3(
	    (job->opt)->app, DK3_LL_ERROR, 77, 78, job->dfn,
	    DK3_BMJ_LOG_JOB, job
	  );
	}
      }
    } else {					

#line 2984 "dk3bm.ctr"
      /* PROGRESS: Reading image. */
      dk3app_log_1((job->opt)->app, DK3_LL_PROGRESS, job->msg, 47);
      if(dk3bif_read_data(job->bif)) {		

#line 2987 "dk3bm.ctr"
#if DK3_USE_WX
        

#line 2989 "dk3bm.ctr"
	dk3bmj_progress(job->pComm, job->minpb + (job->maxpb - job->minpb)/3);
	job->minpb = job->minpb + ((job->maxpb - job->minpb)/3);
#endif
        if(job->dfile) {			

#line 2993 "dk3bm.ctr"
          back = dk3bm_job_produce_img_job_real_ps(job);
	} else {				

#line 2995 "dk3bm.ctr"
	  job->dfile = dk3sf_fopen_app(
	    job->dfn,
	    dk3app_not_localized(24),
	    (job->opt)->app
	  );
	  if(job->dfile) {			

#line 3001 "dk3bm.ctr"
	    back = dk3bm_job_produce_img_job_real_ps(job);
	    if(!dk3sf_fclose_fn_app(job->dfile, job->dfn, (job->opt)->app)) {
	      back = 0;
	    }
	    job->dfile = NULL;
	  } else {				

#line 3007 "dk3bm.ctr"
	    back = 0;
	    /* ERROR: Failed to open output file! */
	    dk3bmj_log_i3(
	      (job->opt)->app, DK3_LL_ERROR, 77, 78, job->dfn,
	      DK3_BMJ_LOG_JOB, job
	    );
	  }
	}
      } else {					

#line 3016 "dk3bm.ctr"
        back = 0;
	/* ERROR: Failed to read image data! */
	dk3bmj_log_1(
	  (job->opt)->app, DK3_LL_ERROR, job->msg, 61, DK3_BMJ_LOG_BOTH, job
	);
      }
    }
  } 

#line 3024 "dk3bm.ctr"
  return back;
}



/**	Produce PS/EPS output.
	@param	job	Job structure.
	@return	1 on success, 0 on error.
*/
static
int
dk3bm_job_produce_ps(dk3_bm_conversion_job_t *job)
{
  int		back	= 0;
  

#line 3039 "dk3bm.ctr"
  switch((job->opt)->mode) {
    case DK3_BMEPS_MODE_DOCUMENT: {	

#line 3041 "dk3bm.ctr"
      back = dk3bm_job_produce_doc_ps(job);
    } break;
    default: {				

#line 3044 "dk3bm.ctr"
      back = dk3bm_job_produce_img_obj_ps(job);
    } break;
  } 

#line 3047 "dk3bm.ctr"
  return back;
}



/**	Add one image frame as output page.
	@param	job	Conversion job.
	@param	pageno	Page number of frame to add.
	@return	1 on success, 0 on error.
*/
static
int
dk3bm_job_add_pdf_frame(dk3_bm_conversion_job_t *job, size_t pageno)
{
  dk3_bif_coord_t	w;		/* Image width. */
  dk3_bif_coord_t	h;		/* Image height. */
  double		xres = 0.0;	/* X resolution. */
  double		yres = 0.0;	/* Y resolution. */
  double		dw;		/* Image width on paper. */
  double		dh;		/* Image height on paper. */
  double		px0;		/* Left x (paper). */
  double		px1;		/* Right x (paper). */
  double		py0;		/* Lower y (paper). */
  double		py1;		/* Upper y (paper). */
  double		width;		/* Paper width. */
  double		height;		/* Paper height. */
  double		sx;		/* Scale factor for x direction. */
  double		sy;		/* Scale factor for y direction. */
  long			mbx0;		/* Left x (media box). */
  long			mbx1;		/* Right x (media box). */
  long			mby0;		/* Lower y (media box). */
  long			mby1;		/* Upper y (media box). */
  int			workmode;	/* Transformation mode. */
  int			back = 1;
  int			me = 0;	/* Flag: Math error. */
  

#line 3083 "dk3bm.ctr"
  /*
  	Re-initialize (we probably have to handle multiple frames in one job.
  */
  job->x_translate = 0.0;
  job->y_translate = 0.0;
  job->x_scale = 1.0;
  job->y_scale = 1.0;
  job->x_0 = 0.0;
  job->x_1 = 0.0;
  job->y_0 = 0.0;
  job->y_1 = 0.0;
  job->x_size = 0L;
  job->y_size = 0L;
  job->bpc = 8;
  job->do_translate = 0;
  job->do_rotate = 0;
  job->do_float_scale = 0;
  job->procedure = 0;
  workmode = 0;
  mbx0 = mbx1 = mby0 = mby1 = 0L;
  /*
  	Process image width, height and resolution.
  */
  w = dk3bif_get_width(job->bif);
  h = dk3bif_get_height(job->bif);
  switch((job->opt)->szmode) {
    case DK3_BMEPS_SIZE_CHUNK: {	

#line 3110 "dk3bm.ctr"
      xres = dk3bif_get_xres(job->bif);
      yres = dk3bif_get_yres(job->bif);
      if(xres > 0.0) {
        if(yres > 0.0) {
	  if((fabs(xres - 72.0) > dk3bm_epsilon)
	     || (fabs(yres - 72.0) > dk3bm_epsilon))
	  {
	    workmode = 1;
	  }
	}
      }
    } break;
    case DK3_BMEPS_SIZE_SPECIFIED: {	

#line 3123 "dk3bm.ctr"
      xres = yres = (job->opt)->resolution;
      if(xres > 0.0) {
        if(fabs(xres - 72.0) > dk3bm_epsilon) {
	  workmode = 1;
	}
      }
    } break;
    case DK3_BMEPS_SIZE_PAPER: {	

#line 3131 "dk3bm.ctr"
      workmode = 2;
      xres = dk3bif_get_xres(job->bif);
      yres = dk3bif_get_yres(job->bif);
      if(xres <= 0.0) { xres = 72.0; }
      if(yres <= 0.0) { yres = 72.0; }
      if(fabs(xres - 72.0) <= dk3bm_epsilon) {
        xres = 72.0;
      }
      if(fabs(yres - 72.0) <= dk3bm_epsilon) {
        yres = 72.0;
      }
    } break;
    default: {				

#line 3144 "dk3bm.ctr"
      workmode = 0;
    } break;
  }
  switch(workmode) {
    case 2: {
      dw = dk3ma_d_mul_ok(
        72.0,
	dk3ma_d_div_ok(dk3bm_l_to_d(w), xres, &me),
	&me
      );
      dh = dk3ma_d_mul_ok(
        72.0,
	dk3ma_d_div_ok(dk3bm_l_to_d(h), yres, &me),
	&me
      ); 

#line 3159 "dk3bm.ctr"
      if(dk3bm_check_paper_size(&(((job->opt)->ima).ps))) {
	width = floor(((job->opt)->ima).ps.w);
	height = floor(((job->opt)->ima).ps.h);
	

#line 3163 "dk3bm.ctr"
	

#line 3164 "dk3bm.ctr"
	mbx1 = dk3ma_d_to_l_ok(width, &me);
	mby1 = dk3ma_d_to_l_ok(height, &me);
        if((job->opt)->duplex) {
          if((job->opt)->tumble) {
	    if(pageno % 2) {	/* Rueckseite */
	      px0 = ((job->opt)->ima).ps.i;
	      px1 = width - ((job->opt)->ima).ps.o;
	      py0 = ((job->opt)->ima).ps.t;
	      py1 = height - ((job->opt)->ima).ps.b;
	    } else {		/* Vorderseite */
	      px0 = ((job->opt)->ima).ps.i;
	      px1 = width - ((job->opt)->ima).ps.o;
	      py0 = ((job->opt)->ima).ps.b;
	      py1 = height - ((job->opt)->ima).ps.t;
	    }
	  } else {
	    if(pageno % 2) {	/* Rueckseite */
	      px0 = ((job->opt)->ima).ps.o;
	      px1 = width - ((job->opt)->ima).ps.i;
	      py0 = ((job->opt)->ima).ps.b;
	      py1 = height - ((job->opt)->ima).ps.t;
	    } else {		/* Vorderseite */
	      px0 = ((job->opt)->ima).ps.i;
	      px1 = width - ((job->opt)->ima).ps.o;
	      py0 = ((job->opt)->ima).ps.b;
	      py1 = height - ((job->opt)->ima).ps.t;
	    }
	  }
        } else {
	  px0 = ((job->opt)->ima).ps.i;
	  px1 = width - ((job->opt)->ima).ps.o;
	  py0 = ((job->opt)->ima).ps.b;
	  py1 = height - ((job->opt)->ima).ps.t;
        }
	if((px1 > px0) && (py1 > py0)) {
	  if((py1 - py0) > (px1 - px0)) {	

#line 3200 "dk3bm.ctr"
	    if(dw > dh) {			

#line 3201 "dk3bm.ctr"
	      job->do_rotate = 1;
	    } else {				

#line 3203 "dk3bm.ctr"
	    }
	  } else {				

#line 3205 "dk3bm.ctr"
	    if((py1 - py0) < (px1 - px0)) {	

#line 3206 "dk3bm.ctr"
	      if(dh > dw) {			

#line 3207 "dk3bm.ctr"
	        job->do_rotate = 1;
	      } else {
	      }
	    }
	  }
	  

#line 3213 "dk3bm.ctr"
	  

#line 3214 "dk3bm.ctr"
	  

#line 3215 "dk3bm.ctr"
	  

#line 3216 "dk3bm.ctr"
	  if(job->do_rotate) {		

#line 3217 "dk3bm.ctr"
	    sx = dk3ma_d_div_ok((py1 - py0), dw, &me);
	    sy = dk3ma_d_div_ok((px1 - px0), dh, &me);
	    if(sx > sy) {		

#line 3220 "dk3bm.ctr"
	      job->y_scale = (px1 - px0);
	      job->x_scale = sy * dw;
	      job->x_translate = px1;
	      job->y_translate = py0 + 0.5 * (py1 - py0 - job->x_scale);
	      if(job->y_translate < py0) { job->y_translate = py0; }
	    } else {			

#line 3226 "dk3bm.ctr"
	      job->x_scale = (py1 - py0);
	      job->y_scale = sx * dh;
	      job->x_translate = px1 - 0.5 * (px1 - px0 - job->y_scale);
	      if(job->x_translate > px1) { job->x_translate = px1; }
	      job->y_translate = py0;
	    }
	  } else {			

#line 3233 "dk3bm.ctr"
	    sx = dk3ma_d_div_ok((px1 - px0), dw, &me);
	    sy = dk3ma_d_div_ok((py1 - py0), dh, &me);
	    if(sx > sy) {		

#line 3236 "dk3bm.ctr"
	      job->y_scale = py1 - py0;
	      job->x_scale = sy * dw;
	      job->x_translate = px0 + 0.5 * (px1 - px0 - job->x_scale);
	      if(job->x_translate < px0) { job->x_translate = px0; }
	      job->y_translate = py0;
	    } else {			

#line 3242 "dk3bm.ctr"
	      job->x_scale = px1 - px0;
	      job->y_scale = sx * dh;
	      job->y_translate = py0 + 0.5 * (py1 - py0 - job->y_scale);
	      if(job->y_translate < py0) { job->y_translate = py0; }
	      job->x_translate = px0;
	    }
	  }
	  job->do_translate = 1;
	  job->do_float_scale = 1;
	} else {			

#line 3252 "dk3bm.ctr"
	  back = 0;
	  /* ERROR Page setup incorrect */
	  dk3bmj_log_i1(
	    (job->opt)->app, DK3_LL_ERROR, 259,
	    DK3_BMJ_LOG_BOTH, job
	  );
	}
      } else {
        back = 0;
      }
	    

#line 3263 "dk3bm.ctr"
	    

#line 3264 "dk3bm.ctr"
	    

#line 3265 "dk3bm.ctr"
	    

#line 3266 "dk3bm.ctr"
	    

#line 3267 "dk3bm.ctr"
    } break;
    case 1: {
      dw = dk3ma_d_mul_ok(
        72.0,
	dk3ma_d_div_ok(dk3bm_l_to_d(w), xres, &me),
	&me
      );
      dh = dk3ma_d_mul_ok(
        72.0,
	dk3ma_d_div_ok(dk3bm_l_to_d(h), yres, &me),
	&me
      );
      job->x_scale = dw;
      job->y_scale = dh;
      job->x_size = dk3ma_d_to_l_ok(ceil(dw), &me);
      job->y_size = dk3ma_d_to_l_ok(ceil(dh), &me);
      job->do_float_scale = 1;
      job->x_translate = 0.5 * dk3ma_d_sub_ok(job->x_size, dw, &me);
      job->y_translate = 0.5 * dk3ma_d_sub_ok(job->y_size, dh, &me);
      if(job->x_translate < 0.0) { job->x_translate = 0.0; }
      if(job->y_translate < 0.0) { job->y_translate = 0.0; }
      job->do_translate = 1;
      mbx1 = dk3ma_d_to_l_ok(job->x_size, &me);
      mby1 = dk3ma_d_to_l_ok(job->y_size, &me);
    } break;
    default: {		

#line 3293 "dk3bm.ctr"
      mbx0 = 0L; mby0 = 0L; mbx1 = w; mby1 = h;
      job->x_size = w; job->y_size = h;
    } break;
  }
  dk3pdf_set_next_mediabox(job->pdf, mbx0, mbx1, mby0, mby1);
  if(me) {		

#line 3299 "dk3bm.ctr"
    back = 0;
  }
  if(back == 1) {	

#line 3302 "dk3bm.ctr"
    if(dk3pdf_open_page(job->pdf)) {	

#line 3303 "dk3bm.ctr"
      if(job->do_translate) {
        dk3pdf_translate_double(job->pdf, job->x_translate, job->y_translate);
      }
      if(job->do_rotate) {
        dk3pdf_rotate_int(job->pdf, 90);
      }
      if(job->do_float_scale) {
        dk3pdf_scale_double(job->pdf, job->x_scale, job->y_scale);
      } else {
        dk3pdf_scale_long(job->pdf, mbx1, mby1);
      }
      if(dk3pdf_add_image_progress(
           job->pdf, job->bif, job->opt, job->pComm, job->minpb, job->maxpb
         )
      )
      {
        back = 1;			

#line 3320 "dk3bm.ctr"
      } else {
        back = 0;			

#line 3322 "dk3bm.ctr"
	dk3bmj_log_1(
	  (job->opt)->app, DK3_LL_ERROR, job->msg, 73,
	  DK3_BMJ_LOG_BOTH, job
	);
      }
      dk3pdf_close_page(job->pdf);
    } else {				

#line 3329 "dk3bm.ctr"
      dk3bmj_log_1(
	(job->opt)->app, DK3_LL_ERROR, job->msg, 71,
	DK3_BMJ_LOG_JOB, job
      );
    }
  } else {
    back = 0;
    /* ERROR: Math error! */
    dk3bmj_log_i1(
      (job->opt)->app, DK3_LL_ERROR, 260,
      DK3_BMJ_LOG_BOTH, job
    );
  } 

#line 3342 "dk3bm.ctr"
  return back;
}



/**	Produce PDF output.
	@param	job	Job structure.
	@return	1 on success, 0 on error.
*/
static
int
dk3bm_job_produce_file_pdf(dk3_bm_conversion_job_t *job)
{
  size_t	nFrames;	/* Number of frames. */
  size_t	i;		/* Current frame index. */
  int		back	= 0;
#if DK3_USE_WX
  int		min;		/* Original min progress bar value. */
  int		max;		/* Original max progress bar value. */
  int		xmax;		/* Intermediate progress bar value. */
#endif
  

#line 3364 "dk3bm.ctr"
#if DK3_USE_WX
  min = job->minpb;
  max = job->maxpb;
  job->maxpb = xmax = min + ((14 * (max - min)) / 15);
#endif
  job->pdf = dk3pdf_open_app((job->opt)->app);
  if(job->pdf) {
    back = 1;
    

#line 3373 "dk3bm.ctr"
    switch((job->opt)->mode) {
      case DK3_BMEPS_MODE_DOCUMENT: {		

#line 3375 "dk3bm.ctr"
        nFrames = dk3bif_number_of_frames(job->bif);
	for(i = 0; i < nFrames; i++) {
#if DK3_USE_WX
	  job->minpb = min + ((((int)i) * (xmax - min)) / (int)nFrames);
	  job->maxpb = min + (((((int)i) + 1) * (xmax - min)) / (int)nFrames);
#endif
	  if(dk3bif_set_frame(job->bif, i)) {
	    if(!dk3bm_job_add_pdf_frame(job, i)) {
	      back = 0;
	    }
	  } else {
	    back = 0;
	    /* ERROR: Failed to set frame! */
	    dk3bmj_log_i1(
	      (job->opt)->app, DK3_LL_ERROR, 261, DK3_BMJ_LOG_BOTH, job
	    );
	  }
#if DK3_USE_WX
          

#line 3394 "dk3bm.ctr"
	  dk3bmj_progress(job->pComm, job->maxpb);
#endif
	}
      } break;
      default: {				

#line 3399 "dk3bm.ctr"
        if(!dk3bm_job_add_pdf_frame(job, 0)) {
	  back = 0;
	}
      } break;
    }
#if DK3_USE_WX
    

#line 3406 "dk3bm.ctr"
    dk3bmj_progress(job->pComm, job->maxpb);
    job->minpb = job->maxpb;
    job->maxpb = max;
#endif
    if(!dk3pdf_write_file_progress(
          job->pdf, job->dfile, job->pComm, job->minpb, job->maxpb)
        )
    {
      back = 0;
      dk3bmj_log_1(
        (job->opt)->app, DK3_LL_ERROR, job->msg, 72,
        DK3_BMJ_LOG_JOB, job
      );
    }
    dk3pdf_close(job->pdf); job->pdf = NULL;
  } else {
    /* ERROR: Failed to create PDF job! */
    dk3bmj_log_i1(
      (job->opt)->app, DK3_LL_ERROR, 9,
      DK3_BMJ_LOG_JOB, job
    );
  }
#if DK3_USE_WX
  job->minpb = min;
  job->maxpb = max;
#endif
  

#line 3433 "dk3bm.ctr"
  return back;
}



/**	Produce draft PDF output.
	@param	job	Job structure.
	@return	1 on success, 0 on error.
*/
static
int
dk3bm_job_draft_pdf(dk3_bm_conversion_job_t *job)
{
  dk3_pdf_t	*pdf;		/* PDF writer structure. */
  double	x0;		/* Left border. */
  double	x1;		/* Right border. */
  double	y0;		/* Lower border. */
  double	y1;		/* Upper border. */
  double	xres = -1.0;	/* X resolution. */
  double	yres = -1.0;	/* Y resolution. */
  double	w;		/* Width, using resolution. */
  double	h;		/* Height, using resolution. */
  double	dx;		/* X delta. */
  double	dy;		/* Y delta. */
  long		mbx0;		/* Media box x0. */
  long		mbx1;		/* Media box x1. */
  long		mby0;		/* Media box y0. */
  long		mby1;		/* Media box y1. */
  int		me		= 0;	/* Flag: Math error. */
  int		workmode	= 0;	/* Work mode. */
  int		do_rotate	= 0;	/* Flag: Rotate. */
  int		back		= 1;
  

#line 3466 "dk3bm.ctr"
  mbx0 = mby0 = 0L;
  mbx1 = dk3bif_get_width(job->bif);
  mby1 = dk3bif_get_height(job->bif);
  x0 = 0.0;
  y0 = 0.0;
  x1 = dk3bm_l_to_d(mbx1);
  y1 = dk3bm_l_to_d(mby1);
  switch((job->opt)->szmode) {
    case DK3_BMEPS_SIZE_CHUNK: {	

#line 3475 "dk3bm.ctr"
      xres = dk3bif_get_xres(job->bif);
      yres = dk3bif_get_yres(job->bif);
      if((xres > 0.0) || (yres > 0.0)) {
        if(xres <= 0.0) { xres = 72.0; }
	if(yres <= 0.0) { yres = 72.0; }
	if(fabs(xres - 72.0) > dk3bm_epsilon) {
	  workmode = 1;
	}
	if(fabs(yres - 72.0) > dk3bm_epsilon) {
	  workmode = 1;
	}
      }
    } break;
    case DK3_BMEPS_SIZE_SPECIFIED: {	

#line 3489 "dk3bm.ctr"
      xres = yres = (job->opt)->resolution;
      if(xres > 0.0) {
        if(fabs(xres - 72.0) > dk3bm_epsilon) {
	  workmode = 1;
	}
      }
    } break;
    case DK3_BMEPS_SIZE_PAPER: {	

#line 3497 "dk3bm.ctr"
      workmode = 2;
      xres = dk3bif_get_xres(job->bif);
      yres = dk3bif_get_yres(job->bif);
      if(xres <= 0.0) { xres = 72.0; }
      if(yres <= 0.0) { yres = 72.0; }
      if(fabs(xres - 72.0) <= dk3bm_epsilon) { xres = 72.0; }
      if(fabs(yres - 72.0) <= dk3bm_epsilon) { yres = 72.0; }
    } break;
  }
  switch(workmode) {
    case 2: {		/* Fit to page */
      w = dk3ma_d_div_ok(dk3bm_l_to_d(mbx1), xres, &me); 

#line 3509 "dk3bm.ctr"
      h = dk3ma_d_div_ok(dk3bm_l_to_d(mby1), yres, &me); 

#line 3510 "dk3bm.ctr"
      mbx1 = dk3ma_d_to_l_ok(floor(((job->opt)->ima).ps.w), &me);
      mby1 = dk3ma_d_to_l_ok(floor(((job->opt)->ima).ps.h), &me);
      

#line 3513 "dk3bm.ctr"
      x0 = ((job->opt)->ima).ps.i;	
      y0 = ((job->opt)->ima).ps.b;
      x1 = dk3ma_d_sub_ok(((job->opt)->ima).ps.w, ((job->opt)->ima).ps.o, &me);
      y1 = dk3ma_d_sub_ok(((job->opt)->ima).ps.h, ((job->opt)->ima).ps.t, &me);
      

#line 3518 "dk3bm.ctr"
      if((x1 > x0) && (y1 > y0)) {		

#line 3519 "dk3bm.ctr"
        if((x1 - x0) > (y1 - y0)) {
	  if(h > w) {				

#line 3521 "dk3bm.ctr"
	    do_rotate = 1;
	  }
	} else {
	  if((x1 - x0) < (y1 - y0)) {
	    if(h < w) {				

#line 3526 "dk3bm.ctr"
	      do_rotate = 1;
	    }
	  }
	}
	if(do_rotate) {				

#line 3531 "dk3bm.ctr"
	  dx = dk3ma_d_div_ok((x1 - x0), h, &me);
	  dy = dk3ma_d_div_ok((y1 - y0), w, &me);
	  if(dx > dy) {
	    w = dk3ma_d_mul_ok(dy, h, &me);
	    dx = dk3ma_d_add_ok(
	      x0,
	      0.5 * dk3ma_d_sub_ok((x1 - x0), w, &me),
	      &me
	    );
	    dy = dk3ma_d_add_ok(dx, w, &me);
	    if(dx >= x0) { x0 = dx; }
	    if(dy <= x1) { x1 = dy; }
	  } else {
	    h = dk3ma_d_mul_ok(dx, w, &me);
	    dx = dk3ma_d_add_ok(
	      y0,
	      0.5 * dk3ma_d_sub_ok((y1 - y0), h, &me),
	      &me
	    );
	    dy = dk3ma_d_add_ok(dx, h, &me);
	    if(dx >= y0) { y0 = dx; }
	    if(dy <= y1) { y1 = dy; }
	  }
	} else {				

#line 3555 "dk3bm.ctr"
	  dx = dk3ma_d_div_ok((x1 - x0), w, &me);
	  dy = dk3ma_d_div_ok((y1 - y0), h, &me);
	  if(dx > dy) {				

#line 3558 "dk3bm.ctr"
	    w = dk3ma_d_mul_ok(dy, w, &me);
	    dx = dk3ma_d_add_ok(
	      x0,
	      0.5 * dk3ma_d_sub_ok((x1 - x0), w, &me),
	      &me
	    );
	    dy = dk3ma_d_add_ok(dx, w, &me);
	    if(dx >= x0) { x0 = dx; }
	    if(dy <= x1) { x1 = dy; }
	  } else {				

#line 3568 "dk3bm.ctr"
	    h = dk3ma_d_mul_ok(dx, h, &me);
	    dx = dk3ma_d_add_ok(
	      y0,
	      0.5 * dk3ma_d_sub_ok((y1 - y0), h, &me),
	      &me
	    );
	    dy = dk3ma_d_add_ok(dx, h, &me);
	    if(dx >= y0) { y0 = dx; }
	    if(dy <= y1) { y1 = dy; }
	  }
	} 

#line 3579 "dk3bm.ctr"
      } else {
        back = 0;
	/* ERROR: Incorrect page setup. */
	dk3bmj_log_i1(
	  (job->opt)->app, DK3_LL_ERROR, 259, DK3_BMJ_LOG_BOTH, job
	);
      }
    } break;
    case 1: {		/* Use resolution */
      w = dk3ma_d_div_ok(dk3bm_l_to_d(mbx1), xres, &me);
      h = dk3ma_d_div_ok(dk3bm_l_to_d(mby1), yres, &me);
      w = dk3ma_d_mul_ok(72.0, w, &me);
      h = dk3ma_d_mul_ok(72.0, h, &me);
      x1 = ceil(w);
      y1 = ceil(h);
      mbx1 = dk3ma_d_to_l_ok(x1, &me);
      mby1 = dk3ma_d_to_l_ok(y1, &me);
      x0 = 0.5 * dk3ma_d_sub_ok(x1, w, &me);
      y0 = 0.5 * dk3ma_d_sub_ok(y1, h, &me);
      x1 = dk3ma_d_add_ok(x0, w, &me);
      y1 = dk3ma_d_add_ok(y0, h, &me);
      if(x0 < 0.0) { x0 = 0.0; }
      if(y0 < 0.0) { y0 = 0.0; }
      if(x1 > dk3bm_l_to_d(mbx1)) { x1 = dk3bm_l_to_d(mbx1); }
      if(y1 > dk3bm_l_to_d(mby1)) { y1 = dk3bm_l_to_d(mby1); }
    } break;
    default: {		/* 1:1 */
      /* Nothing to do, everything is initialized. */
    } break;
  }
  if(me) {
    back = 0;
    /* ERROR: Math error occured! */
    dk3bmj_log_i1(
      (job->opt)->app, DK3_LL_ERROR, 260, DK3_BMJ_LOG_BOTH, job
    );
  }
  if(back) {
    back = 0;
    /* Here we have all information prepared to produce the draft. */
    pdf = dk3pdf_open_app((job->opt)->app);
    if(pdf) {
      dk3pdf_set_next_mediabox(pdf, mbx0, mbx1, mby0, mby1);
      if(dk3pdf_open_page(pdf)) {
        back = 1;
	dx = 0.01 * (x1 - x0);
	dy = 0.01 * (y1 - y0);
	if(dy < dx) dx = dy;
	if(dx > 2.8) dx = 2.8;
	dk3pdf_set_nonstroking_gray(pdf, 0.0);
	dk3pdf_newpath_moveto(pdf, x0, y0);
	dk3pdf_lineto(pdf, x1, y0);
	dk3pdf_lineto(pdf, x1, y1);
	dk3pdf_lineto(pdf, x0, y1);
	dk3pdf_closepath(pdf);
	dk3pdf_fill_nz(pdf);
	dk3pdf_set_nonstroking_gray(pdf, 0.8);
	dk3pdf_newpath_moveto(pdf, (x0 + dx), (y0 + dx));
	dk3pdf_lineto(pdf, (x1 - dx), (y0 + dx));
	dk3pdf_lineto(pdf, (x1 - dx), (y1 - dx));
	dk3pdf_lineto(pdf, (x0 + dx), (y1 - dx));
	dk3pdf_closepath(pdf);
	dk3pdf_fill_nz(pdf);
	dk3pdf_set_nonstroking_gray(pdf, 1.0);
	dy = dx;
	dx = 10.0 * dx;
	dk3pdf_newpath_moveto(pdf, (x0 + dx), (y0 + dx));
	dk3pdf_lineto(pdf, (x1 - dx), (y0 + dx));
	dk3pdf_lineto(pdf, (x1 - dx), (y1 - dx));
	dk3pdf_lineto(pdf, (x0 + dx), (y1 - dx));
	dk3pdf_closepath(pdf);
	dk3pdf_fill_nz(pdf);
	dk3pdf_set_linewidth(pdf, dx);
	dk3pdf_set_linecap(pdf, DK3_LINECAP_ROUND);
	dk3pdf_set_stroking_gray(pdf, 0.8);
	dk3pdf_newpath_moveto(pdf, (x0 + dx), (y0 + dx));
	dk3pdf_lineto(pdf, (x1 - dx), (y1 - dx));
	dk3pdf_stroke(pdf);
	dk3pdf_newpath_moveto(pdf, (x0 + dx), (y1 - dx));
	dk3pdf_lineto(pdf, (x1 - dx), (y0 + dx));
	dk3pdf_stroke(pdf);
	dk3pdf_close_page(pdf);
      } else {
	dk3bmj_log_1(
	  (job->opt)->app, DK3_LL_ERROR, job->msg, 71,
	  DK3_BMJ_LOG_JOB, job
	);
      }
      dk3pdf_write_file(pdf, job->dfile);
      dk3pdf_close(pdf);
    } else {
      /* ERROR: Failed to create PDF writer */
      dk3bmj_log_i1(
        (job->opt)->app, DK3_LL_ERROR, 9,
        DK3_BMJ_LOG_JOB, job
      );
    }
  }
  

#line 3678 "dk3bm.ctr"
  return back;
}



/**	Produce PDF output.
	@param	job	Job structure.
	@return	1 on success, 0 on error.
*/
static
int
dk3bm_job_produce_pdf(dk3_bm_conversion_job_t *job)
{
  int			back = 0;
#if DK3_USE_WX
  int			min;		/* Original min progress bar value. */
  int			max;		/* Original max progress bar value. */
#endif
  

#line 3697 "dk3bm.ctr"
#if DK3_USE_WX
  min = job->minpb;
  max = job->maxpb;
  job->minpb = min + ((max - min) / 4);
#endif
  if((job->opt)->draft) {
    if(job->dfile) {
      back = dk3bm_job_draft_pdf(job);
    } else {
      job->dfile = dk3sf_fopen_app(
        job->dfn,
	dk3app_not_localized(53),
	(job->opt)->app
      );
      if(job->dfile) {
        back = dk3bm_job_draft_pdf(job);
        if(!dk3sf_fclose_fn_app(job->dfile, job->dfn, (job->opt)->app)) {
	  back = 0;
	}
	job->dfile = NULL;
      } else {
        /* ERROR: Failed to open output file! */
	dk3bmj_log_i3(
	  (job->opt)->app, DK3_LL_ERROR, 77, 78, job->dfn,
	  DK3_BMJ_LOG_JOB, job
	);
      }
    }
  } else {
    if(dk3bif_read_data(job->bif)) {
#if DK3_USE_WX
      if((job->pComm) && (job->maxpb > job->minpb)) {
        

#line 3730 "dk3bm.ctr"
        dk3bmj_progress(job->pComm, job->minpb);
      }
#endif
      if(job->dfile) {
        back = dk3bm_job_produce_file_pdf(job);
      } else {
        job->dfile = dk3sf_fopen_app(
	  job->dfn,
	  dk3app_not_localized(53),
	  (job->opt)->app
	);
	if(job->dfile) {
	  back = dk3bm_job_produce_file_pdf(job);
	  if(!dk3sf_fclose_fn_app(job->dfile, job->dfn, (job->opt)->app)) {
	    back = 0;
	  }
	  job->dfile = NULL;
	} else {
	  /* ERROR: Failed to open output file! */
	  dk3bmj_log_i3(
	    (job->opt)->app, DK3_LL_ERROR, 77, 78, job->dfn,
	    DK3_BMJ_LOG_JOB, job
	  );
	}
      }
    } else {
      /* ERROR: Failed to read image data! */
      dk3bmj_log_1(
        (job->opt)->app, DK3_LL_ERROR, job->msg, 61, DK3_BMJ_LOG_BOTH, job
      );
    }
  }
#if DK3_USE_WX
  job->minpb = min;
  job->maxpb = max;
#endif
  

#line 3767 "dk3bm.ctr"
  return back;
}



/**	Produce bounding box output.
	@param	job	Job structure.
*/
static
void
dk3bm_produce_bb(dk3_bm_conversion_job_t *job)
{
  dk3_bif_coord_t	w;	/* Image width. */
  dk3_bif_coord_t	h;	/* Image height. */
  

#line 3782 "dk3bm.ctr"
  w = dk3bif_get_width(job->bif);
  h = dk3bif_get_height(job->bif);
  fprintf(job->dfile, dk3bm_c8_kw[31], w, h);
  

#line 3786 "dk3bm.ctr"
}



/**	Produce bounding box output.
	@param	job	Job structure.
	@return	1 on success, 0 on error.
*/
static
int
dk3bm_job_produce_bb(dk3_bm_conversion_job_t *job)
{
  int		 back	= 0;
  if(job->dfile) {
    dk3bm_produce_bb(job);
    back = 1;
  } else {
    job->dfile = dk3sf_fopen_app(
      job->dfn,
      dk3app_not_localized(24),
      (job->opt)->app
    );
    if(job->dfile) {
      dk3bm_produce_bb(job);
      back = 1;
      if(!dk3sf_fclose_fn_app(job->dfile, job->dfn, (job->opt)->app)) {
        back = 0;
      }
      job->dfile = NULL;
    } else {
      dk3bmj_log_i3(
	(job->opt)->app, DK3_LL_ERROR, 77, 78, job->dfn,
	DK3_BMJ_LOG_JOB, job
      );
    }
  }
  return back;
}



/**	Run a conversion job for either the opened file or the named file.
	@param	job	Conversion job.
	@return	1 on success, 0 on error.
*/
static
int
dk3bm_job_from_program_with_output(dk3_bm_conversion_job_t *job)
{
  int			back	= 0;
  

#line 3837 "dk3bm.ctr"
  job->bif = dk3bif_open_filename_app(job->sfn, job->biftype, (job->opt)->app);
  if(job->bif) {
    switch((job->opt)->dr) {
      case DK3_BMEPS_DRIVER_PS: {
        back = dk3bm_job_produce_ps(job);
      } break;
      case DK3_BMEPS_DRIVER_EPS: {
        back = dk3bm_job_produce_ps(job);
      } break;
      case DK3_BMEPS_DRIVER_PDF: {
        back = dk3bm_job_produce_pdf(job);
      } break;
      default: {
        back = dk3bm_job_produce_bb(job);
      } break;
    }
    dk3bif_close(job->bif);
  } else {
    dk3bmj_log_3(
      (job->opt)->app, DK3_LL_ERROR, job->msg, 69, 70, job->sfn, DK3_BMJ_LOG_BOTH, job
    );
  }
  

#line 3860 "dk3bm.ctr"
  return back;
}




/**	Construct an output file name and run.
	@param	job	Conversion job.
	@return	1 on success, 0 on error.
*/
static
int
dk3bm_job_from_program_construct_name(dk3_bm_conversion_job_t *job)
{
  dkChar	 fno[DK3_MAX_PATH];	/* Output file name buffer. */
  dkChar	*sptr;			/* Pointer to file name suffix. */
  dkChar const	*ns;			/* New suffix. */
  int		 back	= 0;
  

#line 3879 "dk3bm.ctr"
  dk3str_cpy_not_overlapped(fno, job->sfn);
  sptr = dk3str_get_suffix(fno);
  if(sptr) { *sptr = dkT('\0'); }
  ns = dk3bm_output_suffixes[0];
  switch((job->opt)->dr) {
    case DK3_BMEPS_DRIVER_EPS: {
      ns = dk3bm_output_suffixes[1];
    } break;
    case DK3_BMEPS_DRIVER_PDF: {
      ns = dk3bm_output_suffixes[2];
    } break;
    case DK3_BMEPS_DRIVER_BB: {
      ns = dk3bm_output_suffixes[3];
    } break;
  }
  if((dk3str_len(ns) + dk3str_len(fno)) < DK3_SIZEOF(fno,dkChar)) {
    dk3str_cat(fno, ns);	

#line 3896 "dk3bm.ctr"
    job->dfn = fno;
    back = dk3bm_job_from_program_with_output(job);
  } else {
    /* ERROR: File name too long! */
    dk3bmj_log_i3(
      (job->opt)->app, DK3_LL_ERROR, 65, 66, job->sfn, DK3_BMJ_LOG_BOTH, job
    );
  } 

#line 3904 "dk3bm.ctr"
  return back;
}



int
dk3bm_process_file_name(
  dk3_bm_eps_options_t		*opt,
  dkChar const			*sfn,
  int				 biftype,
  int				 min,
  int				 max,
  void				*comm
)
{
  dk3_bm_eps_options_t	 	 bmeo;	/* Conversion options. */
  dk3_bm_conversion_job_t	 job;	/* Conversion job. */
#if DK3_ON_WINDOWS
  int			 oldmode;	/* Original stdout file mode. */
#endif
  int			 back	= 0;
  

#line 3926 "dk3bm.ctr"
  if((opt) && (sfn)) {		

#line 3927 "dk3bm.ctr"
    if(opt->app) {			

#line 3928 "dk3bm.ctr"
      dk3bmj_init(&job, opt->app);
      dk3mem_cpy((void *)(&bmeo), (void *)opt, sizeof(dk3_bm_eps_options_t));
      job.opt = &bmeo;		

#line 3931 "dk3bm.ctr"
      job.sfn = sfn;
      job.biftype = biftype;
#if DK3_USE_WX
      job.pComm = comm;
      job.minpb = min;
      job.maxpb = max;
#endif
      if(dk3bmeo_check(&bmeo, 0, opt->app, &job)) {	

#line 3939 "dk3bm.ctr"
        if(opt->to_stdout) {		

#line 3940 "dk3bm.ctr"
          job.dfile = stdout;
	  switch(opt->dr) {
	    case DK3_BMEPS_DRIVER_PDF: {	

#line 3943 "dk3bm.ctr"
#if DK3_ON_WINDOWS
	      oldmode = _setmode(_fileno(stdout), _O_BINARY);
#endif
	      back = dk3bm_job_from_program_with_output(&job);
#if DK3_ON_WINDOWS
	      _setmode(_fileno(stdout), oldmode);
#endif
	    } break;
	    default: {				

#line 3952 "dk3bm.ctr"
	      back = dk3bm_job_from_program_with_output(&job);
	    } break;
	  }
        } else {				

#line 3956 "dk3bm.ctr"
	  job.dfile = NULL;
          back = dk3bm_job_from_program_construct_name(&job);
        }
      } else {				

#line 3960 "dk3bm.ctr"
        /* ERROR: Inconsistent options, reported by dk3bmeo_check(). */
	dk3bmj_log_1(
	  opt->app, DK3_LL_ERROR, job.msg, 68, DK3_BMJ_LOG_JOB, &job
	);
      }
    } else {				

#line 3966 "dk3bm.ctr"
      /* ERROR: Application structure not set! */
    }
  }
#if DK3_USE_WX
  if((comm) && (max > min)) {
    

#line 3972 "dk3bm.ctr"
    dk3bmj_progress(comm, max);
  }
#endif
  

#line 3976 "dk3bm.ctr"
  return back;
}


