/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3bif.ctr
*/

/*
Copyright (C) 2011-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file */

#ifndef DK3BIF_H_INCLUDED
/** Avoid multiple inclusions. */
#define DK3BIF_H_INCLUDED 1


#line 10 "dk3bif.ctr"

#include "dk3conf.h"
#include "dk3types.h"

#ifdef __cplusplus
extern "C" {
#endif

/**	Check whether a bitmap image file type is supported.
	@param	tp	File type to check.
	@return	1 for supported types, 0 otherwise.
*/
int
dk3bif_type_supported(int tp);

/**	Check file name suffix (dkChar).
	@param	sn	File name suffix without the dot.
	@return	Bitmap image file type.
*/
int
dk3bif_check_suffix_without_dot(dkChar const *sn);

/**	Check file name suffix (char).
	@param	sn	File name suffix without the dot.
	@return	Bitmap image file type.
*/
int
dk3bif_check_c8_suffix_without_dot(char const *sn);

/**	Check file name suffix (dkChar).
	@param	fn	File name to check.
	@return	Bitmap image file type.
*/
int
dk3bif_check_file_name(dkChar const *fn);

/**	Check file name suffix (char).
	@param	fn	File name to check.
	@return	Bitmap image file type.
*/
int
dk3bif_check_c8_file_name(char const *fn);

/**	Open bitmap image file (dkChar).
	@param	fn	File name.
	@param	tp	Bitmap type.
	@param	app	Application structure for diagnostics, may not be NULL.
	@return	Pointer to BIF on success, NULL on error.
*/
dk3_bif_t *
dk3bif_open_filename_app(dkChar const *fn, int tp, dk3_app_t *app);

/**	Open bitmap image file (char).
	@param	fn	File name.
	@param	tp	Bitmap type.
	@param	app	Application structure for diagnostics, may not be NULL.
	@return	Pointer to BIF on success, NULL on error.
*/
dk3_bif_t *
dk3bif_open_c8_filename_app(char const *fn, int tp, dk3_app_t *app);

/**	Open bitmap image file.
	@param	fipo	File, opened for binary reading.
	@param	tp	Bitmap type.
	@param	app	Application structure for diagnostics, may not be NULL.
	@return	Pointer to BIF on success, NULL on error.
*/
dk3_bif_t *
dk3bif_open_file_app(FILE *fipo, int tp, dk3_app_t *app);

/**	Retrieve image type.
	@param	bp	Bitmap image file.
	@return	Image type, DK3_BIF_IMAGE_TYPE_xxx, see	@ref bifimagetypes.
*/
int
dk3bif_get_type(dk3_bif_t *bp);

/**	Get width of current frame.
	@param	bp	Bitmap image file.
	@return	Image width.
*/
dk3_bif_coord_t
dk3bif_get_width(dk3_bif_t *bp);

/**	Get height of current frame.
	@param	bp	Bitmap image file.
	@return	Image height.
*/
dk3_bif_coord_t
dk3bif_get_height(dk3_bif_t *bp);

/**	Get width of widest frame.
	@param	bp	Bitmap image file.
	@return	Image width.
*/
dk3_bif_coord_t
dk3bif_get_largest_width(dk3_bif_t *bp);

/**	Get height of highest frame.
	@param	bp	Bitmap image file.
	@return	Image height.
*/
dk3_bif_coord_t
dk3bif_get_largest_height(dk3_bif_t *bp);

/**	Set background color on per-file base.
	Use this function after opening the bitmap image file
	but before dk3bif_read_data().
	@param	bp	Bitmap image file.
	@param	r	Red.
	@param	g	Green.
	@param	b	Blue.
	@param	f	Force flag: 0=use background color chunk
	from file if available, 1=always use the color specified here.
*/
void
dk3bif_set_background(
  dk3_bif_t		*bp,
  dk3_bif_pixel_t	r,
  dk3_bif_pixel_t	g,
  dk3_bif_pixel_t	b,
  int			f
);

/**	Read image data.
	@param	bp	Bitmap image file.
	@return	1 on success, 0 on error.
*/
int
dk3bif_read_data(dk3_bif_t	*bp);

/**	Find number of frames in image file.
	@param	bp	Bitmap image file.
	@return	Number of frames in the file.
*/
size_t
dk3bif_number_of_frames(dk3_bif_t *bp);

/**	Set current frame number.
	@param	bp	Bitmap image file.
	@param	fn	Number of frame to process.
	@return	1 on success, 0 on error.
*/
int
dk3bif_set_frame(dk3_bif_t *bp, size_t fn);

/**	Reset internal current frame pointer, so the next
	dk3bif_next_frame() call returns the first frame.
	@param	bp	Bitmap image file.
*/
void
dk3bif_reset_frames(dk3_bif_t *bp);

/**	Switch to the next frame.
	@param	bp	Bitmap image file.
	@return	1 on success, 0 on error (no more frames).
*/
int
dk3bif_next_frame(dk3_bif_t *bp);

/**	Check whether a bitmap image is really colored.
	@param	bp	Bitmap image file.
	@return	1 for colored image, 0 for grey.
*/
int
dk3bif_is_colored(dk3_bif_t *bp);

/**	Retrieve number of bits per pixel for current frame.
	@param	bp	Bitmap image file.
	@return	Number of bits per pixel used in the file.
*/
size_t
dk3bif_get_bits_per_pixel(dk3_bif_t *bp);

/**	Retrieve number of bits per pixel for current frame
	really containing information.
	This function returns a useful result only if
	dk3bif_analyze() was run with DK3_ANALYSIS_BITS before.
	@param	bp	Bitmap image file.
	@return	Number of non-redundant bits per pixel.
*/
size_t
dk3bif_real_bits_per_pixel(dk3_bif_t *bp);

/**	Retrieve information whether colors are really used.
	This function returns a useful result only if
	dk3bif_analyze() was run with DK3_BIF_ANALYSIS_COLOR before.
	@param	bp	Bitmap image file.
	@return	1 for colors, 0 for gray.
*/
int
dk3bif_real_color(dk3_bif_t *bp);

/**	Retrieve information whether alpha channel is really used.
	This function returns a useful result only if
	dk3bif_analyze() was run with DK3_BIF_ANALYSIS_ALPHA before.
	@param	bp	Bitmap image file.
	@return	1 for alpha channel used, 0 for unused.
*/
int
dk3bif_real_alpha(dk3_bif_t *bp);

/**	Set number of bits per pixel when retrieving data.
	@param	bp	Bitmap image file.
	@param	sz	Number of bits per pixel.
	@return	1 on success, 0 on error.
*/
int
dk3bif_set_bits_per_pixel(dk3_bif_t *bp, size_t sz);

/**	Get color space.
	@param	bp	Bitmap image file.
	@return	The color space used by the image.
*/
int
dk3bif_get_color_space(dk3_bif_t *bp);

/**	Get red component of pixel.
	@param	bp	Bitmap image file.
	@param	x	X coordinate.
	@param	y	Y coordinate.
	@return	Value corrected to requested bits per component.
*/
dk3_bif_pixel_t
dk3bif_get_red(dk3_bif_t *bp, dk3_bif_coord_t x, dk3_bif_coord_t y);

/**	Get green component of pixel.
	@param	bp	Bitmap image file.
	@param	x	X coordinate.
	@param	y	Y coordinate.
	@return	Value corrected to requested bits per component.
*/
dk3_bif_pixel_t
dk3bif_get_green(dk3_bif_t *bp, dk3_bif_coord_t x, dk3_bif_coord_t y);

/**	Get blue component of pixel.
	@param	bp	Bitmap image file.
	@param	x	X coordinate.
	@param	y	Y coordinate.
	@return	Value corrected to requested bits per component.
*/
dk3_bif_pixel_t
dk3bif_get_blue(dk3_bif_t *bp, dk3_bif_coord_t x, dk3_bif_coord_t y);

/**	Get gray component of pixel.
	@param	bp	Bitmap image file.
	@param	x	X coordinate.
	@param	y	Y coordinate.
	@return	Value corrected to requested bits per component.
*/
dk3_bif_pixel_t
dk3bif_get_gray(dk3_bif_t *bp, dk3_bif_coord_t x, dk3_bif_coord_t y);

/**	Get alpha component of pixel.
	@param	bp	Bitmap image file.
	@param	x	X coordinate.
	@param	y	Y coordinate.
	@return	Value corrected to requested bits per component.
*/
dk3_bif_pixel_t
dk3bif_get_alpha(dk3_bif_t *bp, dk3_bif_coord_t x, dk3_bif_coord_t y);

/**	Get red component of pixel mixed against background.
	@param	bp	Bitmap image file.
	@param	x	X coordinate.
	@param	y	Y coordinate.
	@return	Value corrected to requested bits per component.
*/
dk3_bif_pixel_t
dk3bif_get_mixed_red(dk3_bif_t *bp, dk3_bif_coord_t x, dk3_bif_coord_t y);

/**	Get green component of pixel mixed against background.
	@param	bp	Bitmap image file.
	@param	x	X coordinate.
	@param	y	Y coordinate.
	@return	Value corrected to requested bits per component.
*/
dk3_bif_pixel_t
dk3bif_get_mixed_green(dk3_bif_t *bp, dk3_bif_coord_t x, dk3_bif_coord_t y);

/**	Get blue component of pixel mixed against background.
	@param	bp	Bitmap image file.
	@param	x	X coordinate.
	@param	y	Y coordinate.
	@return	Value corrected to requested bits per component.
*/
dk3_bif_pixel_t
dk3bif_get_mixed_blue(dk3_bif_t *bp, dk3_bif_coord_t x, dk3_bif_coord_t y);

/**	Get gray component of pixel mixed against background.
	@param	bp	Bitmap image file.
	@param	x	X coordinate.
	@param	y	Y coordinate.
	@return	Value corrected to requested bits per component.
*/
dk3_bif_pixel_t
dk3bif_get_mixed_gray(dk3_bif_t *bp, dk3_bif_coord_t x, dk3_bif_coord_t y);

/**	Get file to access raw data.
	This function is primary intended to access JPEG data.
	@param	bp	Bitmap image file.
	@return	FILE pointer if available, NULL otherwise.
*/
FILE *
dk3bif_get_file(dk3_bif_t *bp);

/**	Retrieve X resolution.
	@param	bp	Bitmap image file.
	@return	X resolution in dpi.
*/
double
dk3bif_get_xres(dk3_bif_t *bp);

/**	Retrieve Y resolution.
	@param	bp	Bitmap image file.
	@return	Y resolution in dpi.
*/
double
dk3bif_get_yres(dk3_bif_t *bp);

/**	Close bitmap image file, release memory.
	@param	bp	Bitmap image file to close.
*/
void
dk3bif_close(dk3_bif_t *bp);

/**	Get original number of components for JPEG file.
	@param	bif	Bitmap image file.
	@return	Number of components found in file on success, 0 on error.
*/
int
dk3bif_jpeg_get_num_components(dk3_bif_t *bif);

/**	Check whether Adobe marker was found in JPEG input file.
	@param	bif	Bitmap image file.
	@return	1 if marker was found, 0 otherwise.
*/
int
dk3bif_jpeg_get_found_adobe_marker(dk3_bif_t *bif);

/**	Calculate average predictor value from left and upper value.
	@param	left	Value left to the pixel.
	@param	upper	Value upper to the pixel.
	@return	Predictor value.
*/
dk3_bif_pixel_t
dk3bif_average(dk3_bif_pixel_t left, dk3_bif_pixel_t upper);

/**	Paeth prediction function.
	@param	v1	Left value.
	@param	v2	Upper value.
	@param	v3	Upper left value.
	@return	Predicted value.
*/
dk3_bif_pixel_t
dk3bif_paeth(
  dk3_bif_pixel_t	v1,
  dk3_bif_pixel_t	v2,
  dk3_bif_pixel_t	v3
);

/**	Retrieve one pixel component not yet resampled.
	@param	bp	Bitmap image.
	@param	x	X coordinate.
	@param	y	Y coordinate.
	@param	c	Choose component: 0=red/gray, 1=green, 2=blue, 3=alpha.
	@return	Pixel component.
*/
dk3_bif_pixel_t
dk3bif_get_pixel_component_not_resampled(
  dk3_bif_t		*bp,
  dk3_bif_coord_t	 x,
  dk3_bif_coord_t	 y,
  int			 c
);

#ifdef __cplusplus
}
#endif




#endif
