/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3bf.ctr
*/

/*
Copyright (C) 2011-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file */

#ifndef DK3BF_H_INCLUDED
/** Avoid multiple inclusions. */
#define DK3BF_H_INCLUDED 1


#line 8 "dk3bf.ctr"

#include "dk3conf.h"
#include "dk3types.h"

#ifdef __cplusplus
extern "C" {
#endif


/**	Open a bit field (bit array).
	@param	nbits	Number of bits.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	Pointer to new bit field on success, NULL on error.
*/
dk3_bf_t *
dk3bf_open_app(size_t nbits, dk3_app_t *app);

/**	Close bit field.
	@param	b	Bit field to close.
*/
void
dk3bf_close(dk3_bf_t *b);

/**	Set or reset one bit.
	@param	b	Bit field.
	@param	n	Index of bit to set.
	@param	v	New bit value (1 or 0).
*/
void
dk3bf_set(dk3_bf_t *b, size_t n, int v);

/**	Get one bit value.
	@param	b	Bit field.
	@param	n	Index of bit.
	@return	1 or 0 depending on the bit value.
*/
int
dk3bf_get(dk3_bf_t const *b, size_t n);

/**	Open a bit matrix.
	@param	x	Number of columns.
	@param	y	Number of rows.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	Pointer to new bit matrix on success, NULL on error.
*/
dk3_bm_t *
dk3bm_open(size_t x, size_t y, dk3_app_t *app);

/**	Close bit matrix.
	@param	b	Bit matrix to close.
*/
void
dk3bm_close(dk3_bm_t *b);

/**	Set cache size (threshold to switch between traditional
	algorithm for dk3bm_expand and cache friendly algorithm).
	@param	b	Bit matrix.
	@param	cs	Maximum matrix size for traditional algorithm.
*/
void
dk3bm_set_cache_size(dk3_bm_t *b, size_t cs);

/**	Set or reset  one bit.
	@param	b	Bit matrix.
	@param	x	Column number.
	@param	y	Row number.
	@param	v	New value for bit.
*/
void
dk3bm_set(dk3_bm_t *b, size_t x, size_t y, int v);

/**	Get one bit.
	@param	b	Bit matrix.
	@param	x	Column number.
	@param	y	Row number.
	@return	1 or 0 depending on the bit value.
*/
int
dk3bm_get(dk3_bm_t const *b, size_t x, size_t y);

/**	Expand bit matrix. The matrix must be square.
	@param	b	Bit matrix.
*/
void
dk3bm_expand(dk3_bm_t *b);


#ifdef __cplusplus
}
#endif




#endif
