/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3bezcu.ctr
*/

/*
Copyright (C) 2012-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file dk3bezcu.h Header file for the dk3bezcu module.
*/

#ifndef DK3BEZCU_H_INCLUDED
/** Avoid multiple inclusions. */
#define DK3BEZCU_H_INCLUDED 1


#line 9 "dk3bezcu.ctr"

#ifdef __cplusplus
extern "C" {
#endif

/**	Bezier curve value calculation.
	@param	x0	Start point value.
	@param	xp	Value in control point near start.
	@param	xm	Value in control point near end.
	@param	x1	End point.
	@param	t	The t parameter.
	@param	ec	Pointer to error code variable, may be NULL.
	@return	Calculation result.
*/
double
dk3bezier_value(
  double x0, double xp, double xm, double x1, double t, int *ec
);

/**	Add Bezier curve segment to bounding box.
	@param	bb	Bounding box to modify.
	@param	x0	Start point x coordinate.
	@param	y0	Start point y coordinate.
	@param	xp	Control point near start x coordinate.
	@param	yp	Control point near start y coordinate.
	@param	xm	Control point near end x coordinate.
	@param	ym	Control point near end y coordinate.
	@param	x1	End point x coordinate.
	@param	y1	End point y coordinate.
	@param	ra	Half line width.
	@param	ec	Pointer to error code variable, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3bezier_bb(
  dk3_bb_t	*bb,
  double	 x0,
  double	 y0,
  double	 xp,
  double	 yp,
  double	 xm,
  double	 ym,
  double	 x1,
  double	 y1,
  double	 ra,
  int		*ec
);

#ifdef __cplusplus
}
#endif


#endif
