/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3bezcu.ctr
*/

/*
Copyright (C) 2012-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file dk3bezcu.c The dk3bezcu module.
*/


#line 62 "dk3bezcu.ctr"

#include "dk3all.h"
#include "dk3bb.h"
#include "dk3bezcu.h"





#line 70 "dk3bezcu.ctr"



double
dk3bezier_value(
  double x0, double xp, double xm, double x1, double t, int *ec
)
{
  int		mec = 0;
  double	back;
  

#line 81 "dk3bezcu.ctr"
  back = dk3ma_d_add_ok(
    x0,
    dk3ma_d_mul_ok(
      t,
      dk3ma_d_add_ok(
        dk3ma_d_sub_ok(
	  dk3ma_d_mul_ok(3.0, xp, &mec),
	  dk3ma_d_mul_ok(3.0, x0, &mec),
	  &mec
	),
	dk3ma_d_mul_ok(
	  t,
	  dk3ma_d_add_ok(
	    dk3ma_d_add_ok(
	      dk3ma_d_sub_ok(
	        dk3ma_d_mul_ok(3.0, xm, &mec),
		dk3ma_d_mul_ok(6.0, xp, &mec),
		&mec
	      ),
	      dk3ma_d_mul_ok(3.0, x0, &mec),
	      &mec
	    ),
	    dk3ma_d_mul_ok(
	      t,
	      dk3ma_d_add_ok(
	        dk3ma_d_sub_ok(
		  dk3ma_d_mul_ok(3.0, xp, &mec),
		  dk3ma_d_mul_ok(3.0, xm, &mec),
		  &mec
		),
		dk3ma_d_sub_ok(x1, x0, &mec),
		&mec
	      ),
	      &mec
	    ),
	    &mec
	  ),
	  &mec
	),
	&mec
      ),
      &mec
    ),
    &mec
  );			

#line 126 "dk3bezcu.ctr"
  if(mec) {
    if(ec) { *ec = mec; }
  }
  

#line 130 "dk3bezcu.ctr"
  return back;
}



/**	Apply one t value to a bounding box.
	@param	bb	Bounding box to modify.
	@param	x0	Start value.
	@param	xp	Control value for start.
	@param	xm	Control value for end.
	@param	x1	End value.
	@param	ra	Point radius (half line width).
	@param	tv	The t value.
	@param	isy	Flag: Y direction.
	@param	ec	Pointer to error code variable, may be NULL.
	@return	1 on success, 0 on error.
*/
static
int
dk3bezier_t_dimension(
  dk3_bb_t	*bb,
  double	 x0,
  double	 xp,
  double	 xm,
  double	 x1,
  double	 ra,
  double	 tv,
  int		 isy,
  int		*ec
)
{
  double	 val;
  int		 back = 1;
  int		 mec = 0;
  

#line 165 "dk3bezcu.ctr"
  if(tv > 0.0) {
    if(tv < 1.0) {
      val = dk3bezier_value(x0, xp, xm, x1, tv, &mec); 

#line 168 "dk3bezcu.ctr"
      if(isy) {
        if(!dk3bb_add_y_width(bb, val, ra)) { back = 0; }
      } else {
        if(!dk3bb_add_x_width(bb, val, ra)) { back = 0; }
      }
    }
  }
  if(mec) {		

#line 176 "dk3bezcu.ctr"
    back = 0;
    if(ec) { *ec = mec; }
  } 

#line 179 "dk3bezcu.ctr"
  return back;
}



#if VERSION_BEFORE_20121218
/**	Apply one dimension to a bounding box.
	@param	bb	Bounding box to modify.
	@param	x0	Start value.
	@param	xp	Control value for start.
	@param	xm	Control value for end.
	@param	x1	End value.
	@param	ra	Point radius (half line width).
	@param	isy	Flag: Y direction.
	@param	ec	Pointer to error code variable, may be NULL.
	@return	1 on success, 0 on error.
*/
static
int
dk3bezier_bb_dimension(
  dk3_bb_t	*bb,
  double	 x0,
  double	 xp,
  double	 xm,
  double	 x1,
  double	 ra,
  int		 isy,
  int		*ec
)
{
  double	 n;
  double	 z1;
  double	 z2;
  double	 t;
  int		 back = 1;
  int		 mec = 0;
  

#line 216 "dk3bezcu.ctr"
  n = dk3ma_d_add_ok(
    dk3ma_d_sub_ok(x1, x0, &mec),
    dk3ma_d_mul_ok(3.0, dk3ma_d_sub_ok(xp, xm, &mec), &mec),
    &mec
  );	

#line 221 "dk3bezcu.ctr"
  z1 = dk3ma_d_sub_ok(
    dk3ma_d_sub_ok(dk3ma_d_mul_ok(2.0, xp, &mec), xm, &mec),
    x0,
    &mec
  );	

#line 226 "dk3bezcu.ctr"
  z2 = dk3ma_d_add_ok(
    dk3ma_d_sub_ok(
      xm,
      dk3ma_d_mul_ok(2.0, xp, &mec),
      &mec
    ),
    x0,
    &mec
  );	

#line 235 "dk3bezcu.ctr"
  z2 = dk3ma_d_mul_ok(z2, z2, &mec);
  z2 = dk3ma_d_sub_ok(
    z2,
    dk3ma_d_mul_ok(
      dk3ma_d_sub_ok(xp, x0, &mec),
      n,
      &mec
    ),
    &mec
  );	

#line 245 "dk3bezcu.ctr"
  if(z2 >= 0.0) {
    z2 = sqrt(z2);	

#line 247 "dk3bezcu.ctr"
    t = dk3ma_d_div_ok(
      dk3ma_d_add_ok(z1, z2, &mec),
      n,
      &mec
    );	

#line 252 "dk3bezcu.ctr"
    if(!dk3bezier_t_dimension(bb, x0, xp, xm, x1, ra, t, isy, &mec)) {
      back = 0;
    }	

#line 255 "dk3bezcu.ctr"
    t = dk3ma_d_div_ok(
      dk3ma_d_sub_ok(z1, z2, &mec),
      n,
      &mec
    );	

#line 260 "dk3bezcu.ctr"
    if(!dk3bezier_t_dimension(bb, x0, xp, xm, x1, ra, t, isy, &mec)) {
      back = 0;
    }	

#line 263 "dk3bezcu.ctr"
  }
  if(mec) {		

#line 265 "dk3bezcu.ctr"
    back = 0;
    if(ec) { *ec = mec; }
  } 

#line 268 "dk3bezcu.ctr"
  return back;
}
#else
/**	Apply one dimension to a bounding box.
	@param	bb	Bounding box to modify.
	@param	x0	Start value.
	@param	xp	Control value for start.
	@param	xm	Control value for end.
	@param	x1	End value.
	@param	ra	Point radius (half line width).
	@param	isy	Flag: Y direction.
	@param	ec	Pointer to error code variable, may be NULL.
	@return	1 on success, 0 on error.
*/
static
int
dk3bezier_bb_dimension(
  dk3_bb_t	*bb,
  double	 x0,
  double	 xp,
  double	 xm,
  double	 x1,
  double	 ra,
  int		 isy,
  int		*ec
)
{
  double	 n;
  double	 z1;
  double	 z2;
  double	 t;
  int		 back = 1;
  int		 mec = 0;
  int		 testmec;
  

#line 303 "dk3bezcu.ctr"
  n = dk3ma_d_add_ok(
    dk3ma_d_sub_ok(x1, x0, &mec),
    dk3ma_d_mul_ok(3.0, dk3ma_d_sub_ok(xp, xm, &mec), &mec),
    &mec
  );	

#line 308 "dk3bezcu.ctr"
  z1 = dk3ma_d_sub_ok(
    dk3ma_d_sub_ok(dk3ma_d_mul_ok(2.0, xp, &mec), xm, &mec),
    x0,
    &mec
  );	

#line 313 "dk3bezcu.ctr"
  z2 = dk3ma_d_add_ok(
    dk3ma_d_sub_ok(
      xm,
      dk3ma_d_mul_ok(2.0, xp, &mec),
      &mec
    ),
    x0,
    &mec
  );	

#line 322 "dk3bezcu.ctr"
  z2 = dk3ma_d_mul_ok(z2, z2, &mec);
  z2 = dk3ma_d_sub_ok(
    z2,
    dk3ma_d_mul_ok(
      dk3ma_d_sub_ok(xp, x0, &mec),
      n,
      &mec
    ),
    &mec
  );	

#line 332 "dk3bezcu.ctr"
  if(z2 >= 0.0) {
    z2 = sqrt(z2);	

#line 334 "dk3bezcu.ctr"
    testmec = 0;
    t = dk3ma_d_div_ok(
      dk3ma_d_add_ok(z1, z2, &mec),
      n,
      &testmec
    );	

#line 340 "dk3bezcu.ctr"
    if(0 == testmec) {
      if(!dk3bezier_t_dimension(bb, x0, xp, xm, x1, ra, t, isy, &mec)) {
        back = 0;
      }	

#line 344 "dk3bezcu.ctr"
    }
    testmec = 0;
    t = dk3ma_d_div_ok(
      dk3ma_d_sub_ok(z1, z2, &mec),
      n,
      &testmec
    );	

#line 351 "dk3bezcu.ctr"
    if(0 == testmec) {
      if(!dk3bezier_t_dimension(bb, x0, xp, xm, x1, ra, t, isy, &mec)) {
        back = 0;
      }	

#line 355 "dk3bezcu.ctr"
    }
  }
  if(mec) {		

#line 358 "dk3bezcu.ctr"
    back = 0;
    if(ec) { *ec = mec; }
  } 

#line 361 "dk3bezcu.ctr"
  return back;
}
#endif


int
dk3bezier_bb(
  dk3_bb_t	*bb,
  double	 x0,
  double	 y0,
  double	 xp,
  double	 yp,
  double	 xm,
  double	 ym,
  double	 x1,
  double	 y1,
  double	 ra,
  int		*ec
)
{
  int		 back = 0;
  int		 mec = 0;
  

#line 384 "dk3bezcu.ctr"
  if(bb) {
    back = 1;
    if(!dk3bb_point_width(bb, x0, y0, ra)) {
      back = 0;
    }
    if(!dk3bb_point_width(bb, x1, y1, ra)) {
      back = 0;
    }
    if(!dk3bezier_bb_dimension(bb, x0, xp, xm, x1, ra, 0, &mec)) {
      back = 0;
    }
    if(!dk3bezier_bb_dimension(bb, y0, yp, ym, y1, ra, 1, &mec)) {
      back = 0;
    }
    if(mec) {
      back = 0;
      if(ec) { *ec = mec; }
    }
  } else {
    if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  } 

#line 405 "dk3bezcu.ctr"
  return back;
}


