/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3bb.ctr
*/

/*
Copyright (C) 2012-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file dk3bb.h Header file for the dk3bb module.
*/

#ifndef DK3BB_H_INCLUDED
/** Avoid multiple inclusions. */
#define DK3BB_H_INCLUDED 1


#line 8 "dk3bb.ctr"

#ifdef __cplusplus
extern "C" {
#endif

/**	Reset a bounding box.
	@param	bb	Bounding box to reset.
*/
void
dk3bb_reset(dk3_bb_t *bb);

/**	Add x value to bounding box.
	@param	bb	Bounding box to modify.
	@param	x	Value to add.
*/
void
dk3bb_add_x(dk3_bb_t *bb, double x);

/**	Add y value to bounding box.
	@param	bb	Bounding box to modify.
	@param	y	Value to add.
*/
void
dk3bb_add_y(dk3_bb_t *bb, double y);

/**	Add x value with radius.
	@param	bb	Bounding box to modify.
	@param	x	X value to add.
	@param	r	Radius.
	@return	1 on success, 0 on error.
*/
int
dk3bb_add_x_width(dk3_bb_t *bb, double x, double r);

/**	Add y value with radius.
	@param	bb	Bounding box to modify.
	@param	y	Y value to add.
	@param	r	Radius.
	@return	1 on success, 0 on error.
*/
int
dk3bb_add_y_width(dk3_bb_t *bb, double y, double r);

/**	Add point.
	@param	bb	Bouding box to grow.
	@param	x	X value of point.
	@param	y	Y value of point.
*/
void
dk3bb_point(dk3_bb_t *bb, double x, double y);

/**	Add point with radius.
	@param	bb
	@param	x
	@param	y
	@param	r
	@return	1 on success, 0 on error (math overflow).
*/
int
dk3bb_point_width(dk3_bb_t *bb, double x, double y, double r);

/**	Merge two bounding boxes.
	@param	dbb	Destination bounding box.
	@param	sbb	Source bounding box to merge into dbb.
*/
void
dk3bb_merge(dk3_bb_t *dbb, dk3_bb_t const *sbb);

#ifdef __cplusplus
}
#endif


#endif
