/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3bb.ctr
*/

/*
Copyright (C) 2012-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file dk3bb.c The dk3bb module.
*/


#line 81 "dk3bb.ctr"

#include "dk3all.h"
#include "dk3bb.h"





#line 88 "dk3bb.ctr"



void
dk3bb_reset(dk3_bb_t *bb)
{
  

#line 95 "dk3bb.ctr"
  if(bb) {
    bb->xmin = bb->xmax = bb->ymin = bb->ymax = 0.0;
    bb->xused = bb->yused = 0;
  } 

#line 99 "dk3bb.ctr"
}



void
dk3bb_add_x(dk3_bb_t *bb, double x)
{
  

#line 107 "dk3bb.ctr"
  if(bb) {
    if(bb->xused) {
      if(x < bb->xmin) { bb->xmin = x; }
      if(x > bb->xmax) { bb->xmax = x; }
    } else {
      bb->xmin = x; bb->xmax = x; bb->xused = 1;
    } 

#line 114 "dk3bb.ctr"
  } 

#line 115 "dk3bb.ctr"
}



void
dk3bb_add_y(dk3_bb_t *bb, double y)
{
  

#line 123 "dk3bb.ctr"
  if(bb) {
    if(bb->yused) {
      if(y < bb->ymin) { bb->ymin = y; }
      if(y > bb->ymax) { bb->ymax = y; }
    } else {
      bb->ymin = y; bb->ymax = y; bb->yused = 1;
    } 

#line 130 "dk3bb.ctr"
  } 

#line 131 "dk3bb.ctr"
}



int
dk3bb_add_x_width(dk3_bb_t *bb, double x, double r)
{
  double	 x1;		/* Minimum x value. */
  double	 x2;		/* Maximum x value. */
  int		 ec = 0;	/* Error code for mathematical operations. */
  int		 back = 0;
  

#line 143 "dk3bb.ctr"
  if(bb) {
    x1 = dk3ma_d_sub_ok(x, r, &ec);
    x2 = dk3ma_d_add_ok(x, r, &ec);
    if(0 == ec) {
      back = 1;
      dk3bb_add_x(bb, x1);
      dk3bb_add_x(bb, x2);
    }
  } 

#line 152 "dk3bb.ctr"
  return	 back;
}



int
dk3bb_add_y_width(dk3_bb_t *bb, double y, double r)
{
  double	 y1;		/* Minimum y value. */
  double	 y2;		/* Maximum y value. */
  int		 ec = 0;	/* Error code for mathematical operations. */
  int		 back = 0;
  

#line 165 "dk3bb.ctr"
  y1 = dk3ma_d_sub_ok(y, r, &ec);
  y2 = dk3ma_d_add_ok(y, r, &ec);
  if(0 == ec) {
    back = 1;
    dk3bb_add_y(bb, y1);
    dk3bb_add_y(bb, y2);
  } 

#line 172 "dk3bb.ctr"
  return back;
}



void
dk3bb_point(dk3_bb_t *bb, double x, double y)
{
  

#line 181 "dk3bb.ctr"
  if(bb) {
    dk3bb_add_x(bb, x);
    dk3bb_add_y(bb, y);
  } 

#line 185 "dk3bb.ctr"
}



int
dk3bb_point_width(dk3_bb_t *bb, double x, double y, double r)
{

  int		 back = 0;
  

#line 195 "dk3bb.ctr"
  if(bb) {
    if(dk3bb_add_x_width(bb, x, r)) {
      if(dk3bb_add_y_width(bb, y, r)) {
        back = 1;
      }
    }
  } 

#line 202 "dk3bb.ctr"
  return back;
}



void
dk3bb_merge(dk3_bb_t *dbb, dk3_bb_t const *sbb)
{
  

#line 211 "dk3bb.ctr"
  if((dbb) && (sbb)) {
    if(sbb->xused) {
      dk3bb_add_x(dbb, sbb->xmin);
      dk3bb_add_x(dbb, sbb->xmax);
    }
    if(sbb->yused) {
      dk3bb_add_y(dbb, sbb->ymin);
      dk3bb_add_y(dbb, sbb->ymax);
    }
  }
  

#line 222 "dk3bb.ctr"
}



