/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3app.ctr
*/

/*
Copyright (C) 2011-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file */

#ifndef DK3APP_H_INCLUDED
/** Avoid multiple inclusions. */
#define DK3APP_H_INCLUDED 1


#line 10 "dk3app.ctr"

#include "dk3conf.h"
#include "dk3types.h"

#ifdef __cplusplus
extern "C" {
#endif

/**	Open application structure for command line application.
 *	Diagnostic messages are written to stderr and to the log file.
 *	The log file $HOME/log/<i>application</i>-<i>pid</i>.log
 *	is removed automatically by dk3app_close() unless there was an
 *	error message.
 * 	@param	argc	Number of command line arguments.
 * 	@param	argv	Command line arguments array.
 * 	@param	gn	Application group name.
 * 	@return	Pointer to new application on success, NULL on error.
 */
dk3_app_t *
dk3app_open_command(int argc, dkChar const * const * argv, dkChar const *gn);

/**	Open application structure for GUI application.
 *	Diagnostic messages are written to the log file only.
 *	The log file is removed automatically by dk3app_open() unless
 *	there were error messages.
 *	Typically this function is invoked from a DkWxAppHelper constructor.
 * 	@param	argc	Number of command line arguments.
 * 	@param	argv	Command line arguments array.
 * 	@param	gn	Application group name.
 * 	@return	Pointer to new application on success, NULL on error.
 */
dk3_app_t *
dk3app_open_gui(int argc, dkChar const * const * argv, dkChar const *gn);

/**	First silence check to correct the type if necessary.
	Do not report errors directly, set app->de instead.
	@param	app	Application structure.
	@param	argc	Number of command line arguments.
	@param	argv	Command line arguments array.
*/
int
dk3app_first_silence_check(dk3_app_t *app,int argc,dkChar const * const *argv);

/**	Open application structure for a daemon.
 *	Log messages are appended to
 *	${localstatedir}/log/<i>applicationname</i>/<i>applicationname</i>.log.
 * 	@param	wd	Working directory when starting the program.
 * 	@param	argc	Number of command line arguments.
 * 	@param	argv	Command line arguments array.
 * 	@param	gn	Application group name.
 * 	@return	Pointer to new application on success, NULL on error.
 */
dk3_app_t *
dk3app_open_daemon(dkChar const *wd, int argc, dkChar const * const * argv, dkChar const *gn);

/**	Open application structure for a silent application (no diagnostics).
 * 	@param	argc	Number of command line arguments.
 * 	@param	argv	Command line arguments array.
 * 	@param	gn	Application group name.
 * 	@return	Pointer to new application on success, NULL on error.
 */
dk3_app_t *
dk3app_open_silent(int argc, dkChar const * const * argv, dkChar const *gn);

/**	Close application structure, release dynamic memory and resources
 *	assigned to the object.
 * 	@param	app	Application to close.
 */
void
dk3app_close(dk3_app_t *app);

/**	Log a message consisting of multiple parts.
 *	@param	app	Application structure.
 *	@param	ll	Log level.
 *	@param	msg	Message parts array. Pointer to an array
 *	of string pointers, all array elements are concatenated to
 *	create the message text.
 *	@param	nmsg	Number of elements in the array.
 */
void
dk3app_log_msg(dk3_app_t *app, int ll, dkChar const * const * msg, size_t nmsg);

/**	Log message consisting of one part.
 *	@param	app	Application structure.
 *	@param	ll	Log level.
 *	@param	msg	Message texts array, typically localized, obtained
 *	from dk3app_messages().
 *	@param	i1	Index of message text in \a msg.
 */
void
dk3app_log_1(dk3_app_t *app, int ll, dkChar const * const * msg, size_t i1);

/**	Log message consisting of two parts.
 *	@param	app	Application structure.
 *	@param	ll	Log level.
 *	@param	msg	Message texts array, typically localized, obtained
 *	from dk3app_messages().
 *	@param	i	Index of message text in \a msg.
 *	@param	st	String to write as second part.
 */
void
dk3app_log_2(
  dk3_app_t *app, int ll, dkChar const * const * msg,
  size_t i, dkChar const *st
);

/**	Log message consisting of three parts.
 *	@param	app	Application structure.
 *	@param	ll	Log level.
 *	@param	msg	Message string array.
 *	@param	i1	Index of first message text in \a msg.
 *	@param	i2	Index of third message text in \a msg.
 *	@param	st	Second message text.
 */
void
dk3app_log_3(
  dk3_app_t *app, int ll, dkChar const * const * msg,
  size_t i1, size_t i2, dkChar const *st
);

/**	Log message consisting of five parts.
 *	@param	app	Application structure.
 *	@param	ll	Log level.
 *	@param	msg	Message string array.
 *	@param	i1	Index of first message text in \a msg.
 *	@param	i2	Index of third message text in \a msg.
 *	@param	i3	Index of fifth message text in \a msg.
 *	@param	st1	Second message text.
 *	@param	st2	Fourth message text.
 */
void
dk3app_log_5(
  dk3_app_t *app, int ll, dkChar const * const * msg,
  size_t i1, size_t i2, size_t i3, dkChar const *st1, dkChar const *st2
);

/**	Log message consisting of one part.
 *	@param	app	Application structure.
 *	@param	ll	Log level.
 *	@param	i1	Index of message text in messages array.
 */
void
dk3app_log_i1(dk3_app_t *app, int ll, size_t i1);

/**	Log message consisting of two parts.
 *	@param	app	Application structure.
 *	@param	ll	Log level.
 *	@param	i 	Index of first message text in messages array.
 *	@param	st	Second message text.
 */
void
dk3app_log_i2(dk3_app_t *app, int ll, size_t i, dkChar const * st);

/**	Log message consisting of three parts.
 *	@param	app	Application structure.
 *	@param	ll	Log level.
 *	@param	i1	Index of first message text in messages array.
 *	@param	i2	Index of third message text in messages array.
 *	@param	st	Second message text.
 */
void
dk3app_log_i3(
  dk3_app_t *app, int ll,
  size_t i1, size_t i2, dkChar const *st
);

/**	Log message consisting of five parts.
 *	@param	app	Application structure.
 *	@param	ll	Log level.
 *	@param	i1	Index of first message text in messages array.
 *	@param	i2	Index of third message text in messages array.
 *	@param	i3	Index of fifth message text in messages array.
 *	@param	st1	Second message text.
 *	@param	st2	Fourth message text.
 */
void
dk3app_log_i5(
  dk3_app_t *app, int ll,
  size_t i1, size_t i2, size_t i3, dkChar const *st1, dkChar const *st2
);

/**	Set file name for current source file position.
	The source file position is used when writing diagnostic messages.
	@param	app	Application structure.
	@param	fn	Source file name. Use NULL to disable printing
	the file name.
*/
void
dk3app_set_source_file(dk3_app_t *app, dkChar const *fn);

/**	Set source line number for current source file position.
	The source file position is used when writing diagnostic messages.
	@param	app	Application structure.
	@param	li	Line number. Use 0UL to disable printing the
	line number.
*/
void
dk3app_set_source_line(dk3_app_t *app, unsigned long li);

/**	Get current source file name.
	@param	app	Application structure.
	@return	Current source file name, may be NULL.
*/
dkChar const *
dk3app_get_source_file(dk3_app_t const *app);

/**	Get current source line number.
	@param	app	Application structure.
	@return	Current source file line number, may be 0UL.
*/
unsigned long
dk3app_get_source_line(dk3_app_t const *app);


/**	Get number of command line arguments.
	@param	app	Application structure.
	@return	Number of command line arguments.
*/
int
dk3app_get_argc(dk3_app_t const *app);

/**	Get command line arguments array.
	@param	app	Application structure.
	@return	Command line arguments array.
*/
dkChar const * const *
dk3app_get_argv(dk3_app_t const *app);

/**	Retrieve application name.
	@param	app	Application structure.
	@return	Application name on success, NULL on error.
*/
dkChar const *
dk3app_get_appname(dk3_app_t const *app);

/**	Retrieve name of executable file.
 * 	@param	app	Application structure.
 * 	@return	Executable file name on success, NULL on error.
*/
dkChar const *
dk3app_get_execfilename(dk3_app_t const *app);

/**	Retrieve binary directory name.
	@param	app	Application structure.
	@return	Name of bin directory on success, NULL on error.
*/
dkChar const *
dk3app_get_bindir(dk3_app_t const *app);

/**	Get system configuration directory (/etc or /usr/local/etc).
	@param	app	Application structure.
	@return	Directory name on success, NULL on error.
*/
dkChar const *
dk3app_get_etcdir(dk3_app_t const *app);

/**	Get data root directory (/usr/share or /usr/local/share).
	@param	app	Application structure.
	@return	Directory name on success, NULL on error.
*/
dkChar const *
dk3app_get_sharedir(dk3_app_t const *app);

/**	Get local state directory (/var or /usr/local/var).
	@param	app	Application structure.
	@return	Directory name on success, NULL on error.
*/
dkChar const *
dk3app_get_vardir(dk3_app_t const *app);

/**	Get user login name.
	@param	app	Application structure.
	@return	Login name on success, NULL on error.
*/
dkChar const *
dk3app_get_logname(dk3_app_t const *app);

/**	Get host name.
	@param	app	Application structure.
	@return	Host name on success, NULL on error.
*/
dkChar const *
dk3app_get_hostname(dk3_app_t const *app);

/**	Get users home directory.
	@param	app	Application structure.
	@return	Home directory on success, NULL on error.
*/
dkChar const *
dk3app_get_homedir(dk3_app_t const *app);

/**	Get application group name.
	@param	app	Application structure.
	@return	Group name on success, NULL on error.
*/
dkChar const *
dk3app_get_appgroup(dk3_app_t const *app);

/**	Retrieve users language.
	@param	app	Application structure.
	@return	Pointer to users language or NULL if no language is defined.
*/
dkChar const *
dk3app_get_language(dk3_app_t const *app);

/**	Retrieve users region.
	@param	app	Application structure.
	@return	Pointer to users region or NULL if no region is defined.
*/
dkChar const *
dk3app_get_region(dk3_app_t const *app);

/**	Retrieve internal encoding.
	@param	app	Application structure.
	@return	Internal (in-memory) encoding.
*/
int
dk3app_get_encoding(dk3_app_t const *app);

/**	Retrieve output file encoding.
	@param	app	Application structure.
	@return	Output file encoding.
*/
int
dk3app_get_output_encoding(dk3_app_t const *app);

/**	Retrieve default encoding expected on stdin.
	@param	app	Application structure.
	@return	Expected input encoding (DK3_FILE_ENCODING_xxx).
*/
int
dk3app_get_input_stdin_encoding(dk3_app_t const *app);

/**	Retrieve default encoding expected on files.
	@param	app	Application structure.
	@return	Expected input encoding (DK3_FILE_ENCODING_xxx).
*/
int
dk3app_get_input_file_encoding(dk3_app_t const *app);

/**	Get file name for temporary file.
	The file name is stored into the buffer @a db.
	@param	app	Application structure.
	@param	db	Destination buffer.
	@param	sz	Size of \a db (number of characters).
	@return	1 on success, 0 on error.
*/
int
dk3app_get_temp_file_name(dk3_app_t *app, dkChar *db, size_t sz);

/**	Set a preference value.
	Preferences set by this function are written to the
	$HOME/.dk3app/<i>application</i>/dk3pref.conf file during
	dk3app_close().
	@param	app	Application structure.
	@param	k	Key (preference name).
	@param	v	Value.
	@return	1 on success, 0 on error.
*/
int
dk3app_set_pref(dk3_app_t *app, dkChar const *k, dkChar const *v);

/**	Get a preference value.
	On success the preference value is written to @a d.
	@param	app	Application structure.
	@param	k	Key (preference name).
	@param	d	Destination buffer.
	@param	s	Size of \a d (number of characters).
	@return	1 on success, 0 on error.
*/
int
dk3app_get_pref(dk3_app_t *app, dkChar const *k, dkChar *d, size_t s);

/**	Get boolean preference value.
	@param	app	Application structure.
	@param	name	Preference name.
	@param	dv	Default value if preference not found.
	@return	Preference value or default value.
*/
int
dk3app_get_pref_bool(dk3_app_t *app, dkChar const *name, int dv);

/**	Get int preference value.
	@param	app	Application structure.
	@param	name	Preference name.
	@param	dv	Default value.
	@return	Preference value or default value.
*/
int
dk3app_get_pref_int(dk3_app_t *app, dkChar const * name, int dv);

/**	Get a system preference value.
	Command line and user-set preferences are ignored.
	@param	app	Application structure.
	@param	k	Key (preference name).
	@param	d	Destination buffer.
	@param	s	Size of \a d (number of characters).
	@return	1 on success, 0 on error.
*/
int
dk3app_get_sys_pref(dk3_app_t *app, dkChar const *k, dkChar *d, size_t s);

/**	Unconfigure application.
	@param	app	Application structure.
*/
void
dk3app_unconfigure(dk3_app_t *app);

/**	Find configuration file.
	On success the function returns a file name collection.
	Configuration files with low priority are at the start of the
	collection, files with higher priority are at the end.
	This allows higher priorized configuration files to overwrite
	settings made by the previously processed files.
	After you are done with the search results set, use
	dk3search_close() to close the set and release resources assigned
	to it.
	@param	app	Application structure.
	@param	fn	File name to search for (short filename
	without leading path).
	@param	exclu	Flag: Exclude users configuration file.
	@return	Collection of file names (full path names including the
	leading directory), use dk3search_close() after
	use to destroy it.
*/
dk3_search_t *
dk3app_find_config_file(dk3_app_t *app, dkChar const *fn, int exclu);


/**	Find configuration file in reverse search order
 	(most significant file first).
	This function is typically used to process the first file from
	the set only which is the most significant file.
	After you are done with the search results set, use
	dk3search_close() to close the set and release resources assigned
	to it.
	@param	app	Application structure.
	@param	fn	File name to search for (short file name without
	leading directory).
	@param	exclu	Flag: Exclude users configuration files.
	@return	Collection of file names (full path names with leading
	directory), use dk3search_close() after
	use to destroy it.
*/
dk3_search_t *
dk3app_find_config_file_revers(dk3_app_t *app, dkChar const *fn, int exclu);

/**	Find data file.
	The full path name of the file found is written to @a db on success.
	@param	app	Application structure.
	@param	fn	File name to search for (short file name without leading
	directory).
	@param	db	Destination buffer.
	@param	sz	Size of \a db (number of characters).
	@return	1 on success, 0 on error.
*/
int
dk3app_find_data_file(dk3_app_t *app, dkChar const *fn, dkChar *db, size_t sz);

/**	Get string table.
	@param	app	Application structure.
	@param	fn	Short file name of string table.
	@param	dv	Default value, used if file not found.
	@return	New string table if found or \a dv on problems.
*/
dkChar const * const *
dk3app_messages(dk3_app_t *app, dkChar const *fn, dkChar const * const *dv);

/**	Find and print help text.
	The function searches for a help text file in the users
	language. If no file is found the default text is printed.
	@param	app	Application structure.
	@param	fn	Help text file name (short name wih).
	@param	dt	Default text to use if file not found.
*/
void
dk3app_help(dk3_app_t *app, dkChar const *fn, dkChar const * const *dt);

/**	Get log level used for stderr.
	@param	app	Application structure.
	@return	Log level required for logging to stderr.
*/
int
dk3app_get_stderr_log_level(dk3_app_t const *app);

/**	Set log level used for stderr.
	@param	app	Application structure.
	@param	ll	New log level.
*/
void
dk3app_set_stderr_log_level(dk3_app_t *app, int ll);

/**	Report write error.
	@param	app	Application structure.
	@param	ll	Log level.
	@param	wished	Number of bytes wished to write.
	@param	written	Number of bytes written.
*/
void
dk3app_log_write_error(dk3_app_t *app, int ll, size_t wished, size_t written);


/**	Report fwrite error.
	@param	app	Application structure.
	@param	ll	Log level.
	@param	wished	Number of elements wished to write.
	@param	written	Number of elements written.
*/
void
dk3app_log_fwrite_error(dk3_app_t *app, int ll, size_t wished, size_t written);

/**	Get a localized text.
	@param	app	Application structure.
	@param	num	Index of string in array.
	@return	Pointer to localized string on success, NULL on error.
*/
dkChar const *
dk3app_localized(dk3_app_t const *app, size_t num);

/**	Get a non-localized text.
	@param	num	Index of string in array.
	@return	Pointer to localized string on success, NULL on error.
*/
dkChar const *
dk3app_not_localized(size_t num);

/**	Initialize random number generator.
	Set up allowed PRNG types and seed best PRNG found.
	If at least one of the PRNG types specified in @a il is available
	we attempt to seed this PRNG.
	The following preferences are used by this function:
		- /rand/types is used if il is NULL.
		- /rand/file/allowed configured whether or not usage o
		  seed file in the users home directory is allowed
		- /rand/egd/name can be used to specify of the EDG socket
		  if an EGD (entropy gathering daemon) is running on the
		  system. By default /dev/urandom and/or /dev/random
		  are used to seed a PRNG if available.
	@param	app	Application structure.
	@param	il	Text line to process, may be NULL.
	If this argument is NULL, the /rand/types preference is used
	to find the allowed PRNG types.
	@return	1 on success, 0 on error.
*/
int
dk3app_rand_init(dk3_app_t *app, dkChar const *il);

/**	Retrieve list of allowed PRNG types from a text line.
	If the text line \a il pointer is NULL the
	/rand/types preference value is used.
	@param	app	Application structure.
	@param	il	Text line to process.
	@return	Combination of DK3_PRNG_xxx.
*/
int
dk3app_get_allowed_prng_types(dk3_app_t *app, dkChar const *il);

/**	Retrieve pseudo-random bytes.
	@param	app	Application structure.
	@param	db	Destination buffer.
	@param	sz	Size of \a db (number of bytes).
	@return	Number of bytes found.
*/
size_t
dk3app_rand_bytes(dk3_app_t *app, void *db, size_t sz);

/**	Retrieve pseudo-random bytes.
	The bytes will not be used for cryptographic or authentication
	purposes, so we can use a less unpredictive (less complicated und
	thus faster) generation mechanism.
	@param	app	Application structure.
	@param	db	Destination buffer.
	@param	sz	Size of \a db (number of bytes).
	@return	Number of bytes found.
*/
size_t
dk3app_rand_bytes_non_crypto(dk3_app_t *app, void *db, size_t sz);

/**	Attempt to save random seed to file when closing an application.
	@param	app	Application structure.
*/
void
dk3app_rand_end(dk3_app_t *app);

/**	Get default input encoding for stdin ignoring preferences.
	@param	app	Application structure.
	@return	Encoding (DK3_FILE_ENCODING_xxx).
*/
int
dk3app_get_default_stdin_encoding(dk3_app_t const *app);

/**	Get default input encoding for files ignoring preferences.
	@param	app	Application structure.
	@return	Encoding (DK3_FILE_ENCODING_xxx).
*/
int
dk3app_get_default_file_encoding(dk3_app_t const *app);

/**	Process standard input character by character.
	Attempt to save stdin data to file so we can do a BOM check.
	@param	app	Application structure.
	@param	obj	Object to modify while processing data.
	@param	hf	Handler function.
	@param	de	Default encoding.
*/
int
dk3app_process_stdin_chars(
  dk3_app_t		*app,
  void			*obj,
  dk3_char_handler_t	*hf,
  int			 de
);

/**	Process standard input line by line.
	Attempt to save stdin data to file so we can do a BOM check.
	@param	app	Application structure.
	@param	obj	Object to modify while reading data.
	@param	hf	Handler function.
	@param	buffer	Line buffer.
	@param	szbuffer	Size of buffer.
	@param	de	Default encoding.
*/
int
dk3app_process_stdin_lines(
  dk3_app_t		*app,
  void			*obj,
  dk3_line_handler_t	*hf,
  dkChar		*buffer,
  size_t		 szbuffer,
  int			 de
);

/**	Get maximum log level used by the application.
	@param	app	Application structure.
	@return	Maximum log level used by the application.
*/
int
dk3app_max_log_level(dk3_app_t const *app);

/**	Remove trailing newline and handle backslash escape sequences.
	This function is run on lines read from string table file.
	@param	lb	Line buffer.
*/
void
dk3app_squeeze_line(char *lb);


#if !DK3_ON_WINDOWS
#if DK3_HAVE_SETUID && DK3_HAVE_SETGID && DK3_HAVE_CHOWN
#if DK3_CHAR_SIZE == 1
/**	Change ownership to writable files.
	This function is used by daemons before switching to a
	non-privileged user account.
	@param	app	Application structure.
	@param	uid	New user ID for process.
	@param	gid	New group ID for process.
	@return	1 on success, 0 on error.
*/
int
dk3app_change_user(dk3_app_t *app, uid_t uid, gid_t gid);
#endif
#endif
#endif

/**	Retrieve directory setting from preference.
	@param	app	Application structure.
	@param	pn	Preference name.
	@param	buf	Result buffer.
	@param	bs	Size of bs (number of dkChar).
	@param	ch	Flag: Check existance of directory.
	@return	1 on success, 0 on error.
*/
int
dk3app_get_dir_from_pref(
  dk3_app_t	*app,
  dkChar const	*pn,
  dkChar	*buf,
  size_t	 bs,
  int		 ch
);

#ifdef __cplusplus
}
#endif




#endif
