#! /bin/sh

DIR="$1"

if [ "X$DIR" = "X" ]
then
  echo 'ERROR: Please specify destination directory as command line argument!'
  exit 1
fi

FF=`which fontforge`
if [ "X$FF" = "X" ]
then
  echo 'ERROR: The fontforge program was not found!'
  exit 1
fi

export DIR

[ -d "$DIR" ] || (mkdir $DIR ; chmod 755 $DIR)

#	Argument 1: GhostScript font name.
#	Argument 2: PFB font name without the .pfb suffix
create_pfb_font() {
  cp $1 $2.pfb
  cp $2.pfb $DIR
}

create_pfb_font NimbusRomNo9L-Regu		n021003l
create_pfb_font NimbusRomNo9L-ReguItal		n021023l
create_pfb_font NimbusRomNo9L-Medi		n021004l
create_pfb_font NimbusRomNo9L-MediItal		n021024l
create_pfb_font URWGothicL-Book			a010013l
create_pfb_font URWGothicL-BookObli		a010033l
create_pfb_font URWGothicL-Demi			a010015l
create_pfb_font URWGothicL-DemiObli		a010035l
create_pfb_font URWBookmanL-Ligh		b018012l
create_pfb_font URWBookmanL-LighItal		b018032l
create_pfb_font URWBookmanL-DemiBold		b018015l
create_pfb_font URWBookmanL-DemiBoldItal	b018035l
create_pfb_font NimbusMonL-Regu			n022003l
create_pfb_font NimbusMonL-ReguObli		n022023l
create_pfb_font NimbusMonL-Bold			n022004l
create_pfb_font NimbusMonL-BoldObli		n022024l
create_pfb_font NimbusSanL-Regu			n019003l
create_pfb_font NimbusSanL-ReguItal		n019023l
create_pfb_font NimbusSanL-Bold			n019004l
create_pfb_font NimbusSanL-BoldItal		n019024l
create_pfb_font NimbusSanL-ReguCond		n019043l
create_pfb_font NimbusSanL-ReguCondItal		n019063l
create_pfb_font NimbusSanL-BoldCond		n019044l
create_pfb_font NimbusSanL-BoldCondItal		n019064l
create_pfb_font CenturySchL-Roma		c059013l
create_pfb_font CenturySchL-Ital		c059033l
create_pfb_font CenturySchL-Bold		c059016l
create_pfb_font CenturySchL-BoldItal		c059036l
create_pfb_font URWPalladioL-Roma		p052003l
create_pfb_font URWPalladioL-Ital		p052023l
create_pfb_font URWPalladioL-Bold		p052004l
create_pfb_font URWPalladioL-BoldItal		p052024l
create_pfb_font StandardSymL			s050000l
create_pfb_font URWChanceryL-MediItal		z003034l
create_pfb_font Dingbats			d050000l

cp crsvg.sh	$DIR
cp crpfb.sh	$DIR
cp crttf.sh	$DIR
cp metadata.sed	$DIR
cp pfb2svg.pe	$DIR
cp README	$DIR
cp COPYING	$DIR

