/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: bmeps3.ctr
*/

/*
Copyright (C) 2011-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file bmeps3.c The bmeps3 module.
*/


#line 12 "bmeps3.ctr"

#include "dk3all.h"
#include "dkt-version.h"
#include "dk3bif.h"
#include "dk3bmeo.h"
#include "dk3bmeps.h"
#include "dk3bm.h"





#line 23 "bmeps3.ctr"



/**	Help text shown if no help file is found.
*/
static dkChar const * const bmeps3_default_help_text[] = {
dkT(""),
dkT("NAME"),
dkT(""),
dkT("  bmpp - Bitmap to PS/PDF converter"),
dkT(""),
dkT("SYNOPSIS"),
dkT(""),
dkT("  bmpp [-l<driver>[.<mode>][,<key>[=<value>]...]] [<options>] <file(s)>"),
dkT(""),
dkT("DESCRIPTION"),
dkT(""),
dkT("The program converts bitmap images from PNG, JPEG, or TIFF to PS/EPS and PDF."),
dkT("Different output modes are available:"),
dkT("- object"),
dkT("  to produce an object which is embedded into a text or drawing by a text"),
dkT("  processing or drawing software."),
dkT("- image"),
dkT("  to produce an image for stand-alone viewing."),
dkT("- document"),
dkT("  to fit the output to a given paper size."),
dkT(""),
dkT("OPTIONS"),
dkT(""),
dkT("-h"),
dkT("--help"),
dkT("\tshows this help text."),
dkT(""),
dkT("-v"),
dkT("--version"),
dkT("\tshows the version number."),
dkT(""),
dkT("-L"),
dkT("--license-terms"),
dkT("\tshows the license terms."),
dkT(""),
dkT("-t <type>"),
dkT("\tspecifies the image type, \"png\", \"jpeg\", or \"tiff\". The image type"),
dkT("\tmust be specified when processing standard input or if the input file"),
dkT("\tname suffix does not indicate the type."),
dkT(""),
dkT("-m"),
dkT("\tworks like \"make\" and runs only the conversions necessary when"),
dkT("\tprocessing a directory. Conversion is skipped if the output file"),
dkT("\tfor an input file already exists and is up to date."),
dkT(""),
dkT("-s"),
dkT("\twrites output to standard output instead of an output file."),
dkT(""),
dkT("-o <key>[=<value>]"),
dkT("\tspecifies detailed conversion options."),
dkT(""),
dkT("NAME=VALUE PAIRS"),
dkT(""),
dkT("The key=value pairs allow to set detailed conversion options. For boolean"),
dkT("settings the value can be omitted, the presence of the name sets the option"),
dkT("to active."),
dkT("The following keys (and values) can be used:"),
dkT(""),
dkT("level=<pslevel>"),
dkT("\tspecifies the PS level, \"2\" or \"3\".  Default: 3."),
dkT(""),
dkT("color[=<boolean>]"),
dkT("\tenables/disables color output for PS output. For PDF output color is"),
dkT("\talways enabled. This setting is ignored when passing DCT data from"),
dkT("\tJPEG files to output directly."),
dkT("\tDefault: On."),
dkT(""),
dkT("dsc[=<boolean>]"),
dkT("\tenables/disables DSC comments when producing PS/EPS output."),
dkT("\tDefault: Off, except for ps.document."),
dkT(""),
dkT("draft[=<boolean>]"),
dkT("\tenables/disables draft mode. Default: Off."),
dkT(""),
dkT("predictor=<predictor>"),
dkT("\tchooses a predictor for flate compressions, \"tiff\", \"sub\", \"up\","),
dkT("\t\"average\", or \"paeth\". Default: none."),
dkT(""),
dkT("duplex[=<boolean>]"),
dkT("\tenables/disables duplex mode when producing documents. Default: Off."),
dkT(""),
dkT("tumble[=<boolean>]"),
dkT("\tenables/disables tumble in addition to duplex mode. Default: Off."),
dkT(""),
dkT("dct[=<boolean>]"),
dkT("\tenables/disables direct pass-through of DCT encoded data found in JPEG"),
dkT("\tfiles. Default: On."),
dkT(""),
dkT("bg=<int>:<int>:<int>[:<boolean>]"),
dkT("\tspecifies a default background RGB color to be used if the input file"),
dkT("\tdoes not contain a background color chunk. The optional boolean value"),
dkT("\tat the end can be used to enforce this background over the background"),
dkT("\tchunk. RGB values are in the range 0...255."),
dkT("\tDefault: White, off."),
dkT(""),
dkT("interpolation[=<boolean>]"),
dkT("\tenables/disables image interpolation. Default: On."),
dkT(""),
dkT("jpeg-interpolation[=<boolean>]"),
dkT("\tenables/disables image interpolation if DCT data is passed through"),
dkT("\tdirectly. Default: Off."),
dkT(""),
dkT("resolution=<resolution>"),
dkT("\tchooses a resolution, either \"1:1\" (use a 1 point x 1 point square for"),
dkT("\teach source pixel), \"chunk\" (use resolution data from image) or an"),
dkT("\tinteger value for dpi."),
dkT("\tDefault: 1:1 for objects, chunk for images,"),
dkT("\tfit to paper size for documents."),
dkT(""),
dkT("paper=<paper>"),
dkT("\tspecify a paper size for documents. The paper size must be configured"),
dkT("\tin a dk3paper.conf file. Only one from \"resolution\" or \"paper\" can be"),
dkT("\tused."),
dkT(""),
dkT("make[=<boolean>]"),
dkT("\tenables/disables make mode when processing directories."),
dkT("\tDefault: Off."),
dkT(""),
dkT("bpc[=<boolean>]"),
dkT("\tattempt to reduce the number of bits per component. Default: On."),
dkT(""),
dkT("RETURN VALUE"),
dkT(""),
dkT("The program returns exit status code 0 on success, all other status"),
dkT("codes indicate an error."),
dkT(""),
dkT("EXAMPLES"),
dkT(""),
dkT("bmpp -lps.document,level=2,paper=A4,duplex,bpc myfax.tif"),
dkT("\tconverts a fax TIFF file \"myfax.tif\" to \"myfax.ps\" for a PS 2 printer."),
dkT(""),
dkT("bmpp -l pdf.document,paper=A4,duplex fax.tif"),
dkT("\tcreates a PDF file fax.pdf."),
dkT(""),
dkT("bmpp -l ps.object screenshot.png"),
dkT("\tcreates a PS object file screenshot.ps for use with latex/dvips."),
dkT(""),
dkT("bmpp -l pdf.object screenshot.png"),
dkT("\tcreates a PDF object file screenshot.pdf for use with pdflatex."),
dkT(""),
dkT("bmpp -l ps.image file.png"),
dkT("\tcreates a PS image file.ps."),
dkT(""),
dkT("bmpp -l pdf.image file.png"),
dkT("\tcreates a PDF image file.pdf."),
dkT(""),
dkT("FILES"),
dkT(""),
dkT("dk3paper.conf"),
dkT("\tIf paper=... the named paper size must be configured in a"),
dkT("\tdk3paper.conf file."),
dkT(""),
dkT("RESTRICTIONS"),
dkT(""),
dkT("The program uses the TIFFReadRGBAImage() function from the libtiff library to"),
dkT("read TIFF images. The input file must meet the following conditions:"),
dkT("- The file must be compliant to the \"TIFF baseline v6.0 standard\"."),
dkT("- The number of bits of component must be 8 or less."),
dkT("- The frames must not be too large, the system must be able to allocate the"),
dkT("  4*w*h bytes needed for image date in one piece."),
dkT(""),
dkT("TIFF refers to a group of different compression and encoding mechanisms."),
dkT("A TIFF file is a sequence of data chunks, each data chunk contains a tag"),
dkT("(chunk type identifier). A lot of tags is defined in standards, i.e. the"),
dkT("\"TIFF baseline v6.0 standard\". Some software vendors add vendor-specific"),
dkT("or non-standard tags when writing TIFF files."),
dkT("So when processing TIFF files in bmpp, you should not be surprised to see"),
dkT("warnings or error messages about unknown TIFF tags."),
dkT("Neither bmpp nor the tifflib library are to blame for this, it's the"),
dkT("responsibility of the people adding the non-standard tags."),
dkT("Sometimes bmpp can read the image despite of the warnings/errors."),
dkT(""),
dkT("If you create bitmaps you want to process with bmpp, you should create PNG"),
dkT("images instead of TIFF images if you have the choice."),
dkT(""),
dkT("AUTHOR"),
dkT(""),
dkT("Dirk Krause"),
dkT(""),
dkT("HISTORY"),
dkT(""),
dkT("The bmpp program replaces the bmeps program found in previous versions of"),
dkT("dktools."),
dkT(""),
dkT("COPYRIGHT AND LICENSE"),
dkT(""),
dkT("Run"),
dkT("  bmpp --license-terms"),
dkT("to see the license conditions."),
dkT(""),
dkT("SEE ALSO"),
dkT(""),
dkT("http://dktools.sourceforge.net"),
dkT(""),
NULL


#line 225 "bmeps3.ctr"
};



/**	Strings used to show version number.
*/
static dkChar const * const dk3bm_version_strings[] = {
dkT("bmpp "),
DKT_VERSION
};


/**	Options used by bmeps.
*/
static dk3_option_t const bmeps3_options[] = {
  { dkT('l'), dkT("language"), 1 },
  { dkT('m'), dkT("make"), 0 },
  { dkT('s'), dkT("stdout"), 0 },
  { dkT('t'), dkT("type"), 1 },
  { dkT('h'), dkT("help"), 0 },
  { dkT('v'), dkT("version"), 0 },
  { dkT('L'), dkT("license-terms"), 0 },
  { dkT('\0'),dkT("license"), 0 }
};

/**	Number of options in @a bmeps3_options.
*/
static size_t const bmeps3_szoptions =
sizeof(bmeps3_options)/sizeof(dk3_option_t);



/**	Names of supported input types.
*/
static dkChar const * const	bmeps3_image_type_names[] = {
/* 0 */
dkT("png"),

/* 1 */
dkT("jpg"),

/* 2 */
dkT("jpeg"),

/* 3 */
dkT("tif"),

/* 4 */
dkT("tiff"),

NULL


#line 267 "bmeps3.ctr"
};



/**	Suffixes for output files.
*/
static dkChar const * const	bmeps3_output_suffixes[] = {
dkT(".ps"),
dkT(".eps"),
dkT(".pdf"),
dkT(".bb")
};



/**	Strings, not localized.
*/
static dkChar const * const bmeps3_kw[] = {
/* 0 */
dkT("dkt-3"),

/* 1 */
dkT("bmeps3.str"),

/* 2 */
dkT("option"),

NULL


#line 299 "bmeps3.ctr"
};



/**	Strings, replaced by localized version.
*/
static dkChar const * const bmeps3_message_texts[] = {
/* 0 */
dkT(""),

NULL


#line 309 "bmeps3.ctr"
};



/**	License overview text.
*/
static dkChar const * const bmeps3_overview_license[] = {
dkT(""),
dkT("Overview"),
dkT("========"),
dkT("This software uses code from the following projects either directly"),
dkT("or as a library:"),
dkT(""),
dkT("dktools\t\tDirk Krause's tools and libraries."),
dkT("\t\tSee http://dktools.sourceforge.net for information."),
#if DK3_HAVE_PNG_H
dkT(""),
dkT("libpng\t\tPNG reference library."),
dkT("\t\tSee http://www.libpng.org/pub/png/libpng.html for information."),
#endif
#if DK3_HAVE_JPEGLIB_H
dkT(""),
dkT("jpeg\t\tIndependent JPEG groups free JPEG library."),
dkT("\t\tSee http://www.ijg.org/ for information."),
#endif
#if DK3_HAVE_TIFF_H
dkT(""),
dkT("libtiff\t\tTIFF library."),
dkT("\t\tSee http://www.remotesensing.org/libtiff/ for information."),
#endif
#if DK3_HAVE_ZLIB_H
dkT(""),
dkT("zlib\t\tCompression library."),
dkT("\t\tSee http://www.zlib.net/ for information."),
#endif
dkT(""),
dkT("Your use of the bmpp/wxmbpp program must be in compliance with the"),
dkT("license conditions for the dktools project and the license conditions"),
dkT("for all the libraries used by bmpp."),
dkT(""),
NULL
};



/**	License terms for the dktools project itself.
*/
static dkChar const * const bmpp_dk_license[] = {
dkT("License for the dktools project"),
dkT("==============================="),
dkT("Copyright (c) 2011-2013, Dirk Krause"),
dkT("All rights reserved."),
dkT(""),
dkT("Redistribution and use in source and binary forms,"),
dkT("with or without modification, are permitted provided"),
dkT("that the following conditions are met:"),
dkT(""),
dkT("* Redistributions of source code must retain the above"),
dkT("  copyright notice, this list of conditions and the"),
dkT("  following disclaimer."),
dkT("* Redistributions in binary form must reproduce the above "),
dkT("  copyright notice, this list of conditions and the following"),
dkT("  disclaimer in the documentation and/or other materials"),
dkT("  provided with the distribution."),
dkT("* Neither the name of the copyright holder(s) nor the names of"),
dkT("  contributors may be used to endorse or promote"),
dkT("  products derived from this software without specific"),
dkT("  prior written permission."),
dkT(""),
dkT("THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND"),
dkT("CONTRIBUTORS \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES,"),
dkT("INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF"),
dkT("MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE"),
dkT("DISCLAIMED."),
dkT("IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE"),
dkT("LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,"),
dkT("EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT"),
dkT("LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;"),
dkT("LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)"),
dkT("HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN"),
dkT("CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE"),
dkT("OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS"),
dkT("SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH"),
dkT("DAMAGE."),
dkT(""),
NULL


#line 396 "bmeps3.ctr"
};

#if DK3_HAVE_PNG_H
static dkChar const * const bmpp_png_license[] = {
dkT(""),
dkT("libpng license"),
dkT("=============="),
dkT(""),
dkT("This copy of the libpng notices is provided for your convenience.  In case of"),
dkT("any discrepancy between this copy and the notices in the file png.h that is"),
dkT("included in the libpng distribution, the latter shall prevail."),
dkT(""),
dkT("COPYRIGHT NOTICE, DISCLAIMER, and LICENSE:"),
dkT(""),
dkT("If you modify libpng you may insert additional notices immediately following"),
dkT("this sentence."),
dkT(""),
dkT("This code is released under the libpng license."),
dkT(""),
dkT("libpng versions 1.2.6, August 15, 2004, through 1.2.46, July 9, 2011, are"),
dkT("Copyright (c) 2004, 2006-2009 Glenn Randers-Pehrson, and are"),
dkT("distributed according to the same disclaimer and license as libpng-1.2.5"),
dkT("with the following individual added to the list of Contributing Authors"),
dkT(""),
dkT("   Cosmin Truta"),
dkT(""),
dkT("libpng versions 1.0.7, July 1, 2000, through 1.2.5 - October 3, 2002, are"),
dkT("Copyright (c) 2000-2002 Glenn Randers-Pehrson, and are"),
dkT("distributed according to the same disclaimer and license as libpng-1.0.6"),
dkT("with the following individuals added to the list of Contributing Authors"),
dkT(""),
dkT("   Simon-Pierre Cadieux"),
dkT("   Eric S. Raymond"),
dkT("   Gilles Vollant"),
dkT(""),
dkT("and with the following additions to the disclaimer:"),
dkT(""),
dkT("   There is no warranty against interference with your enjoyment of the"),
dkT("   library or against infringement.  There is no warranty that our"),
dkT("   efforts or the library will fulfill any of your particular purposes"),
dkT("   or needs.  This library is provided with all faults, and the entire"),
dkT("   risk of satisfactory quality, performance, accuracy, and effort is with"),
dkT("   the user."),
dkT(""),
dkT("libpng versions 0.97, January 1998, through 1.0.6, March 20, 2000, are"),
dkT("Copyright (c) 1998, 1999 Glenn Randers-Pehrson, and are"),
dkT("distributed according to the same disclaimer and license as libpng-0.96,"),
dkT("with the following individuals added to the list of Contributing Authors:"),
dkT(""),
dkT("   Tom Lane"),
dkT("   Glenn Randers-Pehrson"),
dkT("   Willem van Schaik"),
dkT(""),
dkT("libpng versions 0.89, June 1996, through 0.96, May 1997, are"),
dkT("Copyright (c) 1996, 1997 Andreas Dilger"),
dkT("Distributed according to the same disclaimer and license as libpng-0.88,"),
dkT("with the following individuals added to the list of Contributing Authors:"),
dkT(""),
dkT("   John Bowler"),
dkT("   Kevin Bracey"),
dkT("   Sam Bushell"),
dkT("   Magnus Holmgren"),
dkT("   Greg Roelofs"),
dkT("   Tom Tanner"),
dkT(""),
dkT("libpng versions 0.5, May 1995, through 0.88, January 1996, are"),
dkT("Copyright (c) 1995, 1996 Guy Eric Schalnat, Group 42, Inc."),
dkT(""),
dkT("For the purposes of this copyright and license, \"Contributing Authors\""),
dkT("is defined as the following set of individuals:"),
dkT(""),
dkT("   Andreas Dilger"),
dkT("   Dave Martindale"),
dkT("   Guy Eric Schalnat"),
dkT("   Paul Schmidt"),
dkT("   Tim Wegner"),
dkT(""),
dkT("The PNG Reference Library is supplied \"AS IS\".  The Contributing Authors"),
dkT("and Group 42, Inc. disclaim all warranties, expressed or implied,"),
dkT("including, without limitation, the warranties of merchantability and of"),
dkT("fitness for any purpose.  The Contributing Authors and Group 42, Inc."),
dkT("assume no liability for direct, indirect, incidental, special, exemplary,"),
dkT("or consequential damages, which may result from the use of the PNG"),
dkT("Reference Library, even if advised of the possibility of such damage."),
dkT(""),
dkT("Permission is hereby granted to use, copy, modify, and distribute this"),
dkT("source code, or portions hereof, for any purpose, without fee, subject"),
dkT("to the following restrictions:"),
dkT(""),
dkT("1. The origin of this source code must not be misrepresented."),
dkT(""),
dkT("2. Altered versions must be plainly marked as such and must not"),
dkT("   be misrepresented as being the original source."),
dkT(""),
dkT("3. This Copyright notice may not be removed or altered from any"),
dkT("   source or altered source distribution."),
dkT(""),
dkT("The Contributing Authors and Group 42, Inc. specifically permit, without"),
dkT("fee, and encourage the use of this source code as a component to"),
dkT("supporting the PNG file format in commercial products.  If you use this"),
dkT("source code in a product, acknowledgment is not required but would be"),
dkT("appreciated."),
dkT(""),
dkT(""),
dkT("A \"png_get_copyright\" function is available, for convenient use in \"about\""),
dkT("boxes and the like:"),
dkT(""),
dkT("   printf(\"%s\",png_get_copyright(NULL));"),
dkT(""),
dkT("Also, the PNG logo (in PNG format, of course) is supplied in the"),
dkT("files \"pngbar.png\" and \"pngbar.jpg (88x31) and \"pngnow.png\" (98x31)."),
dkT(""),
dkT("Libpng is OSI Certified Open Source Software.  OSI Certified Open Source is a"),
dkT("certification mark of the Open Source Initiative."),
dkT(""),
dkT("Glenn Randers-Pehrson"),
dkT("glennrp at users.sourceforge.net"),
dkT("July 9, 2011"),
NULL


#line 516 "bmeps3.ctr"
};
#endif
#if DK3_HAVE_JPEGLIB_H
static dkChar const * const bmpp_jpeg_license[] = {
dkT(""),
dkT("jpeglib license"),
dkT("==============="),
dkT(""),
dkT("In plain English:"),
dkT(""),
dkT("1. We don't promise that this software works.  (But if you find any bugs,"),
dkT("   please let us know!)"),
dkT("2. You can use this software for whatever you want.  You don't have to pay us."),
dkT("3. You may not pretend that you wrote this software.  If you use it in a"),
dkT("   program, you must acknowledge somewhere in your documentation that"),
dkT("   you've used the IJG code."),
dkT(""),
dkT("In legalese:"),
dkT(""),
dkT("The authors make NO WARRANTY or representation, either express or implied,"),
dkT("with respect to this software, its quality, accuracy, merchantability, or"),
dkT("fitness for a particular purpose.  This software is provided \"AS IS\", and you,"),
dkT("its user, assume the entire risk as to its quality and accuracy."),
dkT(""),
dkT("This software is copyright (C) 1991-1998, Thomas G. Lane."),
dkT("All Rights Reserved except as specified below."),
dkT(""),
dkT("Permission is hereby granted to use, copy, modify, and distribute this"),
dkT("software (or portions thereof) for any purpose, without fee, subject to these"),
dkT("conditions:"),
dkT("(1) If any part of the source code for this software is distributed, then this"),
dkT("README file must be included, with this copyright and no-warranty notice"),
dkT("unaltered; and any additions, deletions, or changes to the original files"),
dkT("must be clearly indicated in accompanying documentation."),
dkT("(2) If only executable code is distributed, then the accompanying"),
dkT("documentation must state that \"this software is based in part on the work of"),
dkT("the Independent JPEG Group\"."),
dkT("(3) Permission for use of this software is granted only if the user accepts"),
dkT("full responsibility for any undesirable consequences; the authors accept"),
dkT("NO LIABILITY for damages of any kind."),
dkT(""),
dkT("These conditions apply to any software derived from or based on the IJG code,"),
dkT("not just to the unmodified library.  If you use our work, you ought to"),
dkT("acknowledge us."),
dkT(""),
dkT("Permission is NOT granted for the use of any IJG author's name or company name"),
dkT("in advertising or publicity relating to this software or products derived from"),
dkT("it.  This software may be referred to only as \"the Independent JPEG Group's"),
dkT("software\"."),
dkT(""),
dkT("We specifically permit and encourage the use of this software as the basis of"),
dkT("commercial products, provided that all warranty or liability claims are"),
dkT("assumed by the product vendor."),
dkT(""),
dkT(""),
dkT("ansi2knr.c is included in this distribution by permission of L. Peter Deutsch,"),
dkT("sole proprietor of its copyright holder, Aladdin Enterprises of Menlo Park, CA."),
dkT("ansi2knr.c is NOT covered by the above copyright and conditions, but instead"),
dkT("by the usual distribution terms of the Free Software Foundation; principally,"),
dkT("that you must include source code if you redistribute it.  (See the file"),
dkT("ansi2knr.c for full details.)  However, since ansi2knr.c is not needed as part"),
dkT("of any program generated from the IJG code, this does not limit you more than"),
dkT("the foregoing paragraphs do."),
dkT(""),
dkT("The Unix configuration script \"configure\" was produced with GNU Autoconf."),
dkT("It is copyright by the Free Software Foundation but is freely distributable."),
dkT("The same holds for its supporting scripts (config.guess, config.sub,"),
dkT("ltconfig, ltmain.sh).  Another support script, install-sh, is copyright"),
dkT("by M.I.T. but is also freely distributable."),
dkT(""),
dkT("It appears that the arithmetic coding option of the JPEG spec is covered by"),
dkT("patents owned by IBM, AT&T, and Mitsubishi.  Hence arithmetic coding cannot"),
dkT("legally be used without obtaining one or more licenses.  For this reason,"),
dkT("support for arithmetic coding has been removed from the free JPEG software."),
dkT("(Since arithmetic coding provides only a marginal gain over the unpatented"),
dkT("Huffman mode, it is unlikely that very many implementations will support it.)"),
dkT("So far as we are aware, there are no patent restrictions on the remaining"),
dkT("code."),
dkT(""),
dkT("The IJG distribution formerly included code to read and write GIF files."),
dkT("To avoid entanglement with the Unisys LZW patent, GIF reading support has"),
dkT("been removed altogether, and the GIF writer has been simplified to produce"),
dkT("\"uncompressed GIFs\".  This technique does not use the LZW algorithm; the"),
dkT("resulting GIF files are larger than usual, but are readable by all standard"),
dkT("GIF decoders."),
dkT(""),
dkT("We are required to state that"),
dkT("    \"The Graphics Interchange Format(c) is the Copyright property of"),
dkT("    CompuServe Incorporated.  GIF(sm) is a Service Mark property of"),
dkT("    CompuServe Incorporated.\""),
dkT(""),
NULL


#line 609 "bmeps3.ctr"
};
#endif
#if DK3_HAVE_TIFF_H
static dkChar const * const bmpp_tiff_license[] = {
dkT(""),
dkT("libtiff license"),
dkT("==============="),
dkT(""),
dkT("Copyright (c) 1988-1997 Sam Leffler"),
dkT("Copyright (c) 1991-1997 Silicon Graphics, Inc."),
dkT(""),
dkT("Permission to use, copy, modify, distribute, and sell this software and "),
dkT("its documentation for any purpose is hereby granted without fee, provided"),
dkT("that (i) the above copyright notices and this permission notice appear in"),
dkT("all copies of the software and related documentation, and (ii) the names of"),
dkT("Sam Leffler and Silicon Graphics may not be used in any advertising or"),
dkT("publicity relating to the software without the specific, prior written"),
dkT("permission of Sam Leffler and Silicon Graphics."),
dkT(""),
dkT("THE SOFTWARE IS PROVIDED \"AS-IS\" AND WITHOUT WARRANTY OF ANY KIND, "),
dkT("EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY "),
dkT("WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  "),
dkT(""),
dkT("IN NO EVENT SHALL SAM LEFFLER OR SILICON GRAPHICS BE LIABLE FOR"),
dkT("ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,"),
dkT("OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,"),
dkT("WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF "),
dkT("LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE "),
dkT("OF THIS SOFTWARE."),
dkT(""),
NULL


#line 641 "bmeps3.ctr"
};
#endif
#if DK3_HAVE_ZLIB_H
static dkChar const * const bmpp_zlib_license[] = {
dkT(""),
dkT("zlib license"),
dkT("============"),
dkT(""),
dkT(" (C) 1995-2004 Jean-loup Gailly and Mark Adler"),
dkT(""),
dkT("  This software is provided 'as-is', without any express or implied"),
dkT("  warranty.  In no event will the authors be held liable for any damages"),
dkT("  arising from the use of this software."),
dkT(""),
dkT("  Permission is granted to anyone to use this software for any purpose,"),
dkT("  including commercial applications, and to alter it and redistribute it"),
dkT("  freely, subject to the following restrictions:"),
dkT(""),
dkT("  1. The origin of this software must not be misrepresented; you must not"),
dkT("     claim that you wrote the original software. If you use this software"),
dkT("     in a product, an acknowledgment in the product documentation would be"),
dkT("     appreciated but is not required."),
dkT("  2. Altered source versions must be plainly marked as such, and must not be"),
dkT("     misrepresented as being the original software."),
dkT("  3. This notice may not be removed or altered from any source distribution."),
dkT(""),
dkT("  Jean-loup Gailly        Mark Adler"),
dkT("  jloup@gzip.org          madler@alumni.caltech.edu"),
dkT(""),
dkT("If you use the zlib library in a product, we would appreciate *not*"),
dkT("receiving lengthy legal documents to sign. The sources are provided"),
dkT("for free but without warranty of any kind.  The library has been"),
dkT("entirely written by Jean-loup Gailly and Mark Adler; it does not"),
dkT("include third-party code."),
dkT(""),
dkT("If you redistribute modified sources, we would appreciate that you include"),
dkT("in the file ChangeLog history information documenting your changes. Please"),
dkT("read the FAQ for more information on the distribution of modified source"),
dkT("versions."),
dkT(""),
NULL


#line 683 "bmeps3.ctr"
};
#endif



/**	Show one section of text.
	@param	ltext	Text to show.
*/
static
void
bmeps3_show_one_license(dkChar const * const *ltext)
{
  dkChar const * const *	sptr;
  sptr = ltext;
  while(*sptr) {
    dk3sf_fputs(*(sptr++), stdout);
    dk3sf_fputc(dkT('\n'), stdout);
  }
}



/**	Show license for the program itself and for the used libraries.
*/
static
void
bmeps3_show_license(void)
{
  bmeps3_show_one_license(bmeps3_overview_license);
  bmeps3_show_one_license(bmpp_dk_license);
#if DK3_HAVE_PNG_H
  bmeps3_show_one_license(bmpp_png_license);
#endif
#if DK3_HAVE_JPEGLIB_H
  bmeps3_show_one_license(bmpp_jpeg_license);
#endif
#if DK3_HAVE_TIFF_H
  bmeps3_show_one_license(bmpp_tiff_license);
#endif
#if DK3_HAVE_ZLIB_H
  bmeps3_show_one_license(bmpp_zlib_license);
#endif
}



/**	Process a complete directory.
	@param	bmeo	Conversion options.
	@param	fnb	File name for directory.
	@param	app	Application structure for diagnostics.
	@return	1 on success, 0 on error.
*/
static
int
bmeps3_process_directory(
  dk3_bm_eps_options_t		*bmeo,
  dkChar const			*fnb,
  dk3_app_t			*app
)
{
  dkChar		 fni[DK3_MAX_PATH];	/* Input file name. */
  dkChar		 fno[DK3_MAX_PATH];	/* output file name. */
  dkChar const * const	*msg;			/* Localized message texts. */
  dk3_dir_t		*dir;			/* Directory. */
  dkChar const		*en;			/* Full file name. */
  dkChar const		*sn;			/* Short file name. */
  dkChar const		*nsptr;			/* Suffix output file. */
  dkChar const		*oldsourcefile;		/* Old source file name. */
  dkChar		*sptr;			/* Suffix input file. */
  dk3_stat_t const	*es;			/* Stat info input file. */
  dk3_stat_t		 stb;			/* Stat buffer output file. */
  int			 mustrun;		/* Flag: Must convert file. */
  int			 sit;			/* Image type. */
  int			 back	= 0;
  

#line 758 "bmeps3.ctr"
  msg = dk3app_messages(
    app,
    dk3bmep_str_get_string_table_name(),
    (dkChar const **)dk3bmep_str_get_message_texts()
  );
  if(!(msg)) {
    msg = dk3bmep_str_get_message_texts();
  }
  oldsourcefile = dk3app_get_source_file(app);
  dir = dk3dir_open_app(fnb, app);
  if(dir) {			

#line 769 "bmeps3.ctr"
    back = 1;			

#line 770 "bmeps3.ctr"
    while(dk3dir_get_next_file(dir)) {	

#line 771 "bmeps3.ctr"
      en = dk3dir_get_fullname(dir);	

#line 772 "bmeps3.ctr"
      sn = dk3dir_get_shortname(dir);
      es = dk3dir_get_stat(dir);
      if((en) && (es)) {		

#line 775 "bmeps3.ctr"
        if(dk3bif_type_supported(sit = dk3bif_check_file_name(en))) { 

#line 776 "bmeps3.ctr"
	  if(((es->ft) & (~(DK3_FT_SYMLINK))) == DK3_FT_REGULAR) {	

#line 777 "bmeps3.ctr"
	    mustrun = 1;
	    if(bmeo->make) {
	      if(dk3str_len(en) < DK3_SIZEOF(fni,dkChar)) {
	        dk3str_cpy_not_overlapped(fni, en);
		dk3str_cpy_not_overlapped(fno, en);
		sptr = dk3str_get_suffix(fno);
		if(sptr) {
		  *sptr = dkT('\0');	

#line 785 "bmeps3.ctr"
		  if((bmeo->dr >= 0) && (bmeo->dr <= 3)) {
		    nsptr = bmeps3_output_suffixes[bmeo->dr];
		    if((dk3str_len(fno) + dk3str_len(nsptr))
		       < DK3_SIZEOF(fno,dkChar)
		    )
		    {
		      dk3str_cpy_not_overlapped(sptr, nsptr); 

#line 792 "bmeps3.ctr"
		      if(dk3sf_stat_app(&stb, fno, NULL)) {
		        if(stb.mod > es->mod) {
			  mustrun = 0;
			}
		      }
		    }
		  }
		}
	      }
	    }
	    if(mustrun) {	

#line 803 "bmeps3.ctr"
	      dk3app_log_3(app, DK3_LL_PROGRESS, msg, 41, 42, ((sn) ? sn : en));
	      dk3app_set_source_file(app, ((sn) ? sn : en));
	      if(!dk3bm_process_file_name(bmeo,en,sit,0,1000,NULL)) {
		back = 0;
	      }
	      dk3app_set_source_file(app, oldsourcefile);
	      dk3app_log_3(app, DK3_LL_PROGRESS, msg, 43, 44, ((sn) ? sn : en));
	    } else {		

#line 811 "bmeps3.ctr"
	      dk3app_log_3(app, DK3_LL_PROGRESS, msg, 45, 46, ((sn) ? sn : en));
	    }
	  } else {			

#line 814 "bmeps3.ctr"
	  }
	} else {			

#line 816 "bmeps3.ctr"
	}
      } else {				

#line 818 "bmeps3.ctr"
        back = 0;
        /* BUG: Should be handled by dk3dir. */
      }
    }
    dk3dir_close(dir);
  } else {				

#line 824 "bmeps3.ctr"
    /* ERROR: Failed to open directory! */
  }
  dk3app_set_source_file(app, oldsourcefile);
  

#line 828 "bmeps3.ctr"
  return back;
}




/**	Copy contents of one file to another.
	@param	fipoout	Destination file.
	@param	fipoin	Source file.
	@param	app	Application structure for diagnostics.
	@return	1 on success, 0 on error.
*/
static
int
bmeps3_copy_files(FILE *fipoout, FILE *fipoin, dk3_app_t *app)
{
  char		bu[4096];	/* Buffer for data. */
  size_t	rb;		/* Number of bytes read. */
  int		cc;		/* Flag: Can continue. */
  int		back = 1;
  do {
    cc = 0;
    rb = dk3sf_fread_app(bu, 1, sizeof(bu), fipoin, app);
    if(rb > 0) {
      cc = 1;
      if(!dk3sf_fwrite_app(bu, 1, rb, fipoout, app)) {
        back = 0; cc = 0;
      }
    }
  } while(cc);
  return back;
}




/**	Run with application structure and localized messages.
	@param	app	Application structure.
	@param	msg	Localized messages.
	@param	optset	Option set.
	@return	1 on success, 0 on error.
*/
static
int
bmeps3_run_with_optset(
  dk3_app_t		*app,
  dkChar const * const	*msg,
  dk3_option_set_t	*optset
)
{
  dkChar		 fnb[DK3_MAX_PATH];	/* File name. */
  dk3_bm_eps_options_t	 bmeo;		/* Conversion option set. */
  dk3_stat_t		 stb;		/* Stat buffer. */
  dk3_dir_t		*fne;		/* File name expander. */
  dk3_stat_t const	*es;		/* Entry (file) stat information. */
  FILE			*fipo;		/* Temporary file. */
  dkChar const		*larg;		/* Option argument. */
  dkChar const		*fo;		/* Further opt currently processed. */
  dkChar const		*en;		/* Entry (file) name. */
  int			 fonum;		/* Number of further options. */
  int			 i;		/* Traverse options and arguments. */
  int			 sit;		/* Standard input image type. */
  int			 numargs;	/* Number of command line args. */
  int			 found;		/* Flag: At least one file found. */
#if DK3_ON_WINDOWS
  int			 oldmode;	/* Stdin mode before start. */
#endif
  int			 back	= 0;
  

#line 897 "bmeps3.ctr"
  sit = DK3_BIF_IMAGE_TYPE_UNKNOWN;
  dk3bmeo_init(&bmeo);
  bmeo.app = app;			

#line 900 "bmeps3.ctr"
  back = 1;				

#line 901 "bmeps3.ctr"
  if(dk3opt_is_set(optset, dkT('l'))) {
    larg = dk3opt_get_short_arg(optset, dkT('l'));
    if(larg) {
      if(!dk3bmeo_set_language(&bmeo, larg, app)) {
        back = 0;
	/* ERROR during option processing! */
      }
      bmeo.app = app;
    } else {
      /* BUG: Option -l set, but no argument. Should be handled by dk3opt. */
    }
  }					

#line 913 "bmeps3.ctr"
  if(dk3opt_is_set(optset, dkT('m'))) {
    bmeo.make = 1;
  }
  if(dk3opt_is_set(optset, dkT('s'))) {
    bmeo.to_stdout = 1;
  }
  if(dk3opt_is_set(optset, dkT('t'))) {
    larg = dk3opt_get_short_arg(optset, dkT('t'));
    if(larg) {
      switch(dk3str_array_index(bmeps3_image_type_names, larg, 0)) {
        case 0: {
	  sit = DK3_BIF_IMAGE_TYPE_PNG;
	} break;
	case 1: case 2: {
	  sit = DK3_BIF_IMAGE_TYPE_JPEG;
	} break;
	case 3: case 4: {
	  sit = DK3_BIF_IMAGE_TYPE_TIFF;
	} break;
	default: {
	  /* ERROR: Unknown file type ... */
	  dk3app_log_3(app, DK3_LL_ERROR, msg, 63, 64, larg);
	  back = 0;
	} break;
      }
    } else {
      /*  BUG: Option -t set, but no argument. Should be handled by dk3opt. */
    }
  }
  if(back) {
    if((fonum = dk3opt_get_num_fo(optset)) > 0) {
      for(i = 0; i < fonum; i++) {
        fo = dk3opt_get_fo(optset, i);
	if(fo) {
	  if(!dk3bmeo_apply_option(&bmeo, fo, msg)) {
	    back = 0;
	    /* ERROR: Error while adding option! */
	  }
	} else {
	  /* BUG: Option not available. Should be handled by dk3opt. */
	}
      }
    }
  }					

#line 957 "bmeps3.ctr"
  if(back) {
    if(dk3opt_is_set(optset, dkT('h'))
       || dk3opt_is_set(optset, dkT('v'))
       || dk3opt_is_set(optset, dkT('L'))
    )
    {
      if(dk3opt_is_set(optset, dkT('v'))) {
        /* Print version number */
	dk3sf_initialize_stdout();
	dk3sf_fputs(dk3bm_version_strings[0], stdout);
	dk3sf_fputs(dk3bm_version_strings[1], stdout);
	dk3sf_fputc(dkT('\n'), stdout);
      }
      if(dk3opt_is_set(optset, dkT('L'))) {
        dk3sf_initialize_stdout();
	bmeps3_show_license();
      } else {
        if(dk3opt_is_set_long(optset, dkT("license"))) {
	  dk3sf_initialize_stdout();
	  bmeps3_show_license();
	}
      }
      if(dk3opt_is_set(optset, dkT('h'))) {
        dk3sf_initialize_stdout();
        dk3app_help(app, dkT("bmpp.txt"), bmeps3_default_help_text);
      }
    } else {
      dk3bmeo_check(&bmeo, 0, app, NULL);	

#line 985 "bmeps3.ctr"
      numargs = dk3opt_get_num_args(optset);
      if(numargs > 0) {		

#line 987 "bmeps3.ctr"
        for(i = 0; i < numargs; i++) {
          larg = dk3opt_get_arg(optset, i);
	  if(larg) {
	    if(dk3str_len(larg) < DK3_SIZEOF(fnb,dkChar)) {
	      dk3str_cpy_not_overlapped(fnb, larg);
	      dk3str_correct_filename(fnb);
	      if(dk3sf_must_expand(fnb)) {	

#line 994 "bmeps3.ctr"
	        found = 0;
	        fne = dk3dir_fne_open_app(fnb, app);
	        if(fne) {
	          while(dk3dir_get_next_file(fne)) {
		    en = dk3dir_get_fullname(fne);
		    es = dk3dir_get_stat(fne);
		    if((en) && (es)) {
		      if(((es->ft) & (~(DK3_FT_SYMLINK))) == DK3_FT_REGULAR) {
		        sit = DK3_BIF_IMAGE_TYPE_UNKNOWN;
		        if(!dk3bm_process_file_name(&bmeo,en,sit,0,1000,NULL))
		        {
		          back = 0;
		        }
		      } else {
		        /* ERROR: Not a regular file! */
			dk3app_log_i3(app, DK3_LL_ERROR, 255, 256, fnb);
		      }
		    } else {
		      /* BUG: Should be handled by dk3dir. */
		      back = 0;
		    }
		  }
	          dk3dir_close(fne);
		  if(!(found)) {
		    back = 0;
		    /* ERROR: No such file! */
		    dk3app_log_i3(app, DK3_LL_ERROR, 215, 216, fnb);
		  }
	        } else {
	          /* ERROR: Failed to expand file name! */
		  back = 0;
	        }
	      } else {				

#line 1027 "bmeps3.ctr"
	        if(dk3sf_stat_app(&stb, fnb, app)) {
	          switch((stb.ft) & (~(DK3_FT_SYMLINK))) {
		    case DK3_FT_DIRECTORY: {
		      if(!bmeps3_process_directory(&bmeo, fnb, app)) {
		        back = 0;
		      }
		    } break;
		    case DK3_FT_REGULAR: {
		      if(!dk3bm_process_file_name(&bmeo,fnb,sit,0,1000,NULL)) {
		        back = 0;
		      }
		    } break;
		    default: {
		      /* ERROR: Illegal file type! */
		      back = 0;
		      dk3app_log_3(app, DK3_LL_ERROR, msg, 65, 66, fnb);
		    } break;
		  }
	        } else {
	          /* ERROR: No information about file! */
		  back = 0;
	        }
	      }
	    } else {
	      /* ERROR: File name too long! */
	      back = 0;
	      dk3app_log_i3(app, DK3_LL_ERROR, 65, 66, larg);
	    }
	  } else {		

#line 1056 "bmeps3.ctr"
	    /* BUG: Option not available, should be handled by dk3opt. */
	  }
        }
      } else {			

#line 1060 "bmeps3.ctr"
        if(sit != DK3_BIF_IMAGE_TYPE_UNKNOWN) {
	  if(dk3app_get_temp_file_name(app, fnb, DK3_SIZEOF(fnb,dkChar))) {
	    fipo = dk3sf_fopen_app(fnb, dk3app_not_localized(53), app);
	    if(fipo) {
#if DK3_ON_WINDOWS
	      oldmode = _setmode(_fileno(stdin), _O_BINARY);
#endif
	      i = bmeps3_copy_files(fipo, stdin, app);
#if DK3_ON_WINDOWS
	      _setmode(_fileno(stdin), oldmode);
#endif
#if VERSION_BEFORE_2012_04_19
	      fclose(fipo);
#else
	      if(!dk3sf_fclose_fn_app(fipo, fnb, app)) {
	        i = 0;
	      }
#endif
	      if(i) {
	        bmeo.to_stdout = 1;
	        back = dk3bm_process_file_name(&bmeo,fnb,sit,0,1000,NULL);
	      }
	    } else {
	      /* ERROR: Failed to open file for writing! */
	      back = 0;
	    }
	  } else {
	    back = 0;
	    /* ERROR: Failed to obtain temporary file name! */
	  }
        } else {
          /* ERROR: No file type specified for standard input! */
	  back = 0;
	  dk3app_log_1(app, DK3_LL_ERROR, msg, 67);
        }
      }
    }
  }
  

#line 1099 "bmeps3.ctr"
  return back;
}



/**	Run with application structure and localized messages.
	@param	app	Application structure.
	@param	msg	Localized messages.
	@return	1 on success, 0 on error.
*/
static
int
bmeps3_run_with_app(dk3_app_t *app, dkChar const * const *msg)
{
  dk3_option_set_t	*optset;	/* Options provided on command line. */
  int			back	= 0;
  

#line 1116 "bmeps3.ctr"
  optset = dk3opt_open_from_app(
    bmeps3_options,
    bmeps3_szoptions,
    dkT('o'),
    bmeps3_kw[2],
    app
  );
  if(optset) {		

#line 1124 "bmeps3.ctr"
    if(0 == dk3opt_get_error_code(optset)) {	

#line 1125 "bmeps3.ctr"
      back = bmeps3_run_with_optset(app, msg, optset);
    } else {					

#line 1127 "bmeps3.ctr"
      /* ERROR: Error in options */
    }
    dk3opt_close(optset);
  } else {		

#line 1131 "bmeps3.ctr"
  } 

#line 1132 "bmeps3.ctr"
  return back;
}



/**	The main() function.
	@param	argc	Number of command line arguments.
	@param	argv	Command line arguments array.
	@return	0 on success, any other value indicates an error.
*/
DK3_MAIN
{
  dk3_app_t		*app;	/* Application structure. */
  dkChar const * const	*msg;	/* Localizd messages. */
  int			 exval;	/* Exit code. */

  

#line 1149 "bmeps3.ctr"
  

#line 1150 "bmeps3.ctr"
  exval = 1;
  app = dk3app_open_command(
    argc, (dkChar const * const *)argv, bmeps3_kw[0]
  );
  if(app) {			

#line 1155 "bmeps3.ctr"
    msg = dk3app_messages(
      app,
      dk3bmep_str_get_string_table_name(),
      (dkChar const **)dk3bmep_str_get_message_texts()
    );
    if(msg) {			

#line 1161 "bmeps3.ctr"
      if(bmeps3_run_with_app(app, msg)) {
        exval = 0;
      }
    } else {			

#line 1165 "bmeps3.ctr"
      /* BUG: Should not happen, as the fucntion returns the default array! */
    }
    dk3app_close(app);
  } else {			

#line 1169 "bmeps3.ctr"
    /* ERROR: Memory */
    fputs("ERROR: Not enough memory (RAM/swap space)!\n", stderr);
    fflush(stderr);
  }
  

#line 1174 "bmeps3.ctr"
  

#line 1175 "bmeps3.ctr"
  fflush(stdout);
  exit(exval); return exval;
}

