/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: WinprintThread.cpt
*/

/*
Copyright (C) 2013, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file WinprintThread.h Header file for the WinprintThread module.
*/

#ifndef WINPRINTTHREAD_H_INCLUDED
/** Avoid multiple inclusions. */
#define WINPRINTTHREAD_H_INCLUDED 1


#line 8 "WinprintThread.cpt"

class WinprintThread : public wxThread
{
  protected:

    /**	File to print.
    */
    wxChar const		*sFilename;

    /**	Printer to use.
    */
    dkChar const		*sPrintername;

    /**	Communicator object.
    */
    DkWxCommunicator		*pComm;

    /**	Localized texts.
    */
    wxChar const * const	*sTexts;

    /**	Application helper.
    */
    DkWxAppHelper		*pHelper;

    /**	Print configuration.
    */
    dk3_print_conf_t		*pc;

    /**	Encoding for dkChar strings.
    */
    int				 dkenc;

  public:

    /**	Constructor.
  	@param	communicator		Communication object.
	@param	localizedTexts		Localized texts.
	@param	applicationHelper	Application helper object.
	@param	printConfiguration	Print configuration.
	@param	fileName		File to print.
	@param	printerName		Printer to use.
    */
    WinprintThread(
      DkWxCommunicator		*communicator,
      wxChar const * const	*localizedTexts,
      DkWxAppHelper		*applicationHelper,
      dk3_print_conf_t		*printConfiguration,
      wxChar const		*fileName,
      wxChar const		*printerName
    );

    /**	Destructor.
    */
    ~WinprintThread();

    /**	Check setup.
    	@return	true on success, false on error.
    */
    bool
    checkSetup();

    /**	Thread function.
    	@return	Pointer which is ignored.
    */
    virtual
    void *
    Entry();

    /** Method executed at end of thread, doest nothing.
    */
    virtual
    void
    OnExit();
};


#endif
