/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: WinprintFrame.wxc
*/

/*
Copyright (C) 2013, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file WinprintFrame.h Header file for the WinprintFrame module.
*/

#ifndef WINPRINTFRAME_H_INCLUDED
/** Avoid multiple inclusions. */
#define WINPRINTFRAME_H_INCLUDED 1


#line 103 "WinprintFrame.wxc"

#ifdef	DK3_USE_WX
#undef	DK3_USE_WX
#endif
/**	Use wxWidgets libraries to build GUI programs.
*/
#define	DK3_USE_WX	1



#line 113 "WinprintFrame.wxc"
class WinprintFrame : public DkWxFrame
{
  private:

    /**	Event table for frame.
    */
    DECLARE_EVENT_TABLE()

  protected:
    
    /**	Black color for status label.
    */
    wxColour			 cBlack;

    /**	Green color for status label.
    */
    wxColour			 cGreen;

    /**	Red color for status label.
    */
    wxColour			 cRed;

    /**	Printer names.
    */
    DK3_PCWXCHAR		*pNames;

    /**	Printer names as wxString array.
    */
    wxString			*wxsNames;

    /**	Size of printer names array.
    */
    size_t			 nNames;

    /**	Index of default printer in array.
    */
    int				 nDefPrinter;

    /**	File dialog x position.
    */
    int				 fdx;

    /**	File dialog y position.
    */
    int				 fdy;

    /**	Printer chooser dialog x position.
    */
    int				 pcx;

    /**	Printer chooser dialog y position.
    */
    int				 pcy;

    /**	Localized texts.
    */
    wxChar const * const	*sTexts;

    /**	Non-localized texts.
    */
    wxChar const * const	*sNlWx;

    /**	Non-localized texts.
    */
    dkChar const * const	*sNlDk;

    /**	Print configuration.
    */
    dk3_print_conf_t		*pc;

    /**	Use default printer.
    */
    BOOL			 bUseDefaultPrinter;

    /**	Use named printer.
    */
    wxChar const		*sNamedPrinter;

    /**	Named file to process.
    */
    wxChar const		*sNamedFile;

    /**	Communicator object.
    */
    DkWxCommunicator		*pComm;

    /**	Time to close the application.
    */
    dk3_time_t			 timeClose;

    /**	Flag: Closing the application is scheduled.
    */
    BOOL			 bCloseScheduled;

    /**	Flag: Autostart wanted.
    */
    BOOL			 bAutostartWanted;

    /**	Flag: GUI ok.
    */
    bool dkctGUILayoutOK;

    /**	Contents panel.
    */
    wxPanel *dkctGUIContentsPanel;

    /**	GUI element mainSizer.
    */
#line 74 "WinprintFrame.wxc"
    wxBoxSizer *mainSizer;

    /**	GUI element tbMain.
    */
#line 24 "WinprintFrame.wxc"
    wxToolBar *tbMain;

    /**	GUI element mbMain.
    */
#line 40 "WinprintFrame.wxc"
    wxMenuBar *mbMain;

    /**	GUI element bRun.
    */
#line 28 "WinprintFrame.wxc"
    wxToolBarToolBase *bRun;

    /**	GUI element bExit.
    */
#line 34 "WinprintFrame.wxc"
    wxToolBarToolBase *bExit;

    /**	GUI element menuFile.
    */
#line 44 "WinprintFrame.wxc"
    wxMenu *menuFile;

    /**	GUI element menuHelp.
    */
#line 59 "WinprintFrame.wxc"
    wxMenu *menuHelp;

    /**	GUI element miFilePrint.
    */
#line 49 "WinprintFrame.wxc"
    wxMenuItem *miFilePrint;

    /**	GUI element miFileExit.
    */
#line 54 "WinprintFrame.wxc"
    wxMenuItem *miFileExit;

    /**	GUI element miHelpAbout.
    */
#line 64 "WinprintFrame.wxc"
    wxMenuItem *miHelpAbout;

    /**	GUI element miHelpContents.
    */
#line 69 "WinprintFrame.wxc"
    wxMenuItem *miHelpContents;

    /**	GUI element verticalSizer.
    */
#line 80 "WinprintFrame.wxc"
    wxBoxSizer *verticalSizer;

    /**	GUI element contentsSizer.
    */
#line 88 "WinprintFrame.wxc"
    wxGridBagSizer *contentsSizer;

    /**	GUI element tStatus.
    */
#line 97 "WinprintFrame.wxc"
    wxStaticText *tStatus;


#line 212 "WinprintFrame.wxc"

  public:

    /**	Constructor.
	@param	wxid			Window ID.
	@param	applicationHelper	Application helper object.
	@param	hc			Help controller for online help.
	@param	argc			Number of command line arguments.
	@param	argv			Command line arguments array.
	@param	localizedTexts		Localized wxChar texts.
	@param	nlWx			Non-localized wxChar texts.
	@param	nlDk			Non-localized dkChar texts.
	@param	pPrintConf		Print configuration.
    */
    WinprintFrame(
      int			  wxid,
      DkWxAppHelper		 *applicationHelper,
      DkWxHelpController	 *hc,
      int			  argc,
      wxChar			**argv,
      wxChar const * const	 *localizedTexts,
      wxChar const * const	 *nlWx,
      dkChar const * const	 *nlDk,
      dk3_print_conf_t		 *pPrintConf,
      DK3_PCWXCHAR		 *printerNames,
      size_t			  numberOfPrinters,
      int			  defaultPrinterIndex
    );

    /**	Destructor.
    */
    ~WinprintFrame();

    /**	Check whether we can close the window.
    	@param	isLast	Flag: Last main window to close.
    */
    bool
    canClose(bool isLast);

    /**	Handler for File/Exit.
    	@param	event	Event to process.
    */
    void
    OnQuit(wxCommandEvent & event);

    /**	Handler for Help/About.
    	@param	event	Event to process.
    */
    void
    OnAbout(wxCommandEvent & event);

    /**	Handler for Help/Contents.
    	@param	event	Event to process.
    */
    void
    OnHelpContents(wxCommandEvent & event);

    /**	Handler for print menu item.
    	@param	event	Event to process.
    */
    void
    OnPrint(wxCommandEvent & event);

    /*	__CHANGE__ 008:	Remove OnIdle if no idle processing required.
    */
    /**	Handler for idle events.
    */
    void
    OnIdle(wxIdleEvent & event);

    /*	__CHANGE__ 017:	Event handlers for further events.
    */

    /*	__CHANGE__ 014:	Add further methods.
    */

    /**	Run for a print job.
    */
    int	runJob(void);

    /**	Set error status.
    	@param	txt		Error message text.
	@param	filename	Current filename to process.
    */
    void setErrorStatus(wxChar const *txt, wxChar const *filename);

};


#line 301 "WinprintFrame.wxc"


#endif
