/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: WinprintFrame.wxc
*/

/*
Copyright (C) 2013, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file WinprintFrame.cpp The WinprintFrame module.
*/


#line 303 "WinprintFrame.wxc"

#include "winprint.h"
#include "dkt-version.h"
#include "run-conversion.xpm"
#include "exit-program.xpm"


#if !defined(__WXMSW__)
#include "winprint.xpm"
#endif





#line 317 "WinprintFrame.wxc"



/*	__CHANGE__ 017: Add further events. */
/*	__CHANGE__ 008: Remove OnIdle if no idle processing required. */
BEGIN_EVENT_TABLE(WinprintFrame, wxFrame)
	EVT_MENU(WinprintFrame_Quit, WinprintFrame::OnQuit)
	EVT_MENU(WinprintFrame_Print, WinprintFrame::OnPrint)
	EVT_MENU(WinprintFrame_Help_About, WinprintFrame::OnAbout)
	EVT_MENU(WinprintFrame_Help_Contents, WinprintFrame::OnHelpContents)
	EVT_IDLE(WinprintFrame::OnIdle)
END_EVENT_TABLE()



static const wxCmdLineEntryDesc winprint_cmd_line_desc[] = {
  {
    wxCMD_LINE_OPTION,
    wxT_2("P"),
    wxT_2("printer"),
    wxT_2("choose printer"),
    wxCMD_LINE_VAL_STRING
  },
  {
    wxCMD_LINE_SWITCH,
    wxT_2("d"),
    wxT_2("default"),
    wxT_2("Use default printer")
  },
  {
    wxCMD_LINE_PARAM,
    NULL,
    NULL,
    wxT_2("input file"),
    wxCMD_LINE_VAL_STRING,
    wxCMD_LINE_PARAM_OPTIONAL
  },
  { wxCMD_LINE_NONE }
};



#line 359 "WinprintFrame.wxc"
WinprintFrame::WinprintFrame(
  int			  wxid,
  DkWxAppHelper		 *applicationHelper,
  DkWxHelpController	 *hc,
  int			  argc,
  wxChar		**argv,
  wxChar const * const	 *localizedTexts,
  wxChar const * const	 *nlWx,
  dkChar const * const	 *nlDk,
  dk3_print_conf_t	 *pPrintConf,
  DK3_PCWXCHAR		 *printerNames,
  size_t		  numberOfPrinters,
  int			  defaultPrinterIndex
) : DkWxFrame(nlWx[0], applicationHelper, hc, wxid),
    cBlack(0, 0, 0),
    cGreen(0, 127, 0),
    cRed(127, 0, 0)
{
  /*	__CHANGE__ 012:	Add further local variables.
  */
  size_t	i;	/* Traverse pNames when creating wxsNames. */

  /*	__CHANGE__ 012: Initialize further local variables.
  */
  fdx = -1; fdy = -1;
  pcx = -1; pcy = -1;
  wxsNames = NULL;
  pNames = printerNames;
  nNames = numberOfPrinters;
  nDefPrinter = defaultPrinterIndex;
  pComm = NULL;
  bCloseScheduled = false;
  bAutostartWanted = false;
  timeClose = (dk3_time_t)0UL;
  sNamedFile = NULL;
  sNamedPrinter = NULL;
  bUseDefaultPrinter = false;
  sTexts = localizedTexts;
  sNlWx  = nlWx;
  sNlDk  = nlDk;
  pc = pPrintConf;
#if defined(__WXMSW__)
  wxIcon	winprint_icon(sNlWx[4]);
#else
  wxIcon	winprint_icon(winprint_xpm);
#endif
  /*	__CHANGE__ 011:	Initialize further class members.
  */
  dkctGUILayoutOK = false;
  dkctGUIContentsPanel = NULL;
  mainSizer = NULL;
  tbMain = NULL;
  mbMain = NULL;
  bRun = NULL;
  bExit = NULL;
  menuFile = NULL;
  menuHelp = NULL;
  miFilePrint = NULL;
  miFileExit = NULL;
  miHelpAbout = NULL;
  miHelpContents = NULL;
  verticalSizer = NULL;
  contentsSizer = NULL;
  tStatus = NULL;
  dkctGUIContentsPanel = new wxPanel(this);
  if(!(dkctGUIContentsPanel)) {
    goto dkctGUILayoutFinished;
  }
#if wxUSE_MENUS
  mbMain = new wxMenuBar(
  );
  if(!(mbMain)) {
    goto dkctGUILayoutFinished;
  }
  menuFile = new wxMenu(
  );
  if(!(menuFile)) {
    goto dkctGUILayoutFinished;
  }
  miFilePrint = menuFile->Append(
    WinprintFrame_Print,
    sTexts[15],
    sTexts[16]
  );
  if(!(miFilePrint)) {
    goto dkctGUILayoutFinished;
  }
  miFileExit = menuFile->Append(
    WinprintFrame_Quit,
    sTexts[1],
    sTexts[2]
  );
  if(!(miFileExit)) {
    goto dkctGUILayoutFinished;
  }
  mbMain->Append(menuFile, sTexts[0]);
  menuHelp = new wxMenu(
  );
  if(!(menuHelp)) {
    goto dkctGUILayoutFinished;
  }
  miHelpAbout = menuHelp->Append(
    WinprintFrame_Help_About,
    sTexts[4],
    sTexts[5]
  );
  if(!(miHelpAbout)) {
    goto dkctGUILayoutFinished;
  }
  miHelpContents = menuHelp->Append(
    WinprintFrame_Help_Contents,
    sTexts[6],
    sTexts[7]
  );
  if(!(miHelpContents)) {
    goto dkctGUILayoutFinished;
  }
  mbMain->Append(menuHelp, sTexts[3]);
  SetMenuBar(mbMain);
#endif
#if wxUSE_TOOLBAR
  tbMain = new wxToolBar(
    this,
    wxID_ANY
  );
  if(!(tbMain)) {
    goto dkctGUILayoutFinished;
  }
  bRun = tbMain->AddTool(
    WinprintFrame_Print,
    sTexts[15],
    xpm_run_conversion,
    wxNullBitmap,
    wxITEM_NORMAL,
    sTexts[16]
  );
  if(!(bRun)) {
    goto dkctGUILayoutFinished;
  }
  bExit = tbMain->AddTool(
    WinprintFrame_Quit,
    sTexts[1],
    xpm_exit_program,
    wxNullBitmap,
    wxITEM_NORMAL,
    sTexts[2]
  );
  if(!(bExit)) {
    goto dkctGUILayoutFinished;
  }
  tbMain->Realize();
  SetToolBar(tbMain);
#endif
  mainSizer = new wxBoxSizer(
    wxHORIZONTAL
  );
  if(!(mainSizer)) {
    goto dkctGUILayoutFinished;
  }
  mainSizer->Add(10, 10, 0);
  verticalSizer = new wxBoxSizer(
    wxVERTICAL
  );
  if(!(verticalSizer)) {
    goto dkctGUILayoutFinished;
  }
  verticalSizer->Add(10, 10, 0);
  contentsSizer = new wxGridBagSizer(
    5, 5
  );
  if(!(contentsSizer)) {
    goto dkctGUILayoutFinished;
  }
  tStatus = new wxStaticText(
    dkctGUIContentsPanel,
    wxID_ANY,
    sTexts[13]
  );
  if(!(tStatus)) {
    goto dkctGUILayoutFinished;
  }
  contentsSizer->Add(
    tStatus,
    wxGBPosition(0, 0),
    wxGBSpan(1, 1),
    wxALIGN_LEFT
  );
  verticalSizer->Add(
    contentsSizer
  );
  verticalSizer->Add(10, 10, 0);
  mainSizer->Add(
    verticalSizer,
    1,
    wxGROW
  );
  mainSizer->Add(10, 10, 0);
  dkctGUIContentsPanel->SetSizer(mainSizer);
  SetIcon(winprint_icon);
  dkctGUILayoutOK = true;
  dkctGUILayoutFinished:
#if wxUSE_STATUSBAR
  if(dkctGUILayoutOK) {
    CreateStatusBar(1);
    SetStatusText(sTexts[8]);
  }
#endif
  if(dkctGUILayoutOK) {
    mainSizer->Fit(this);
    mainSizer->SetSizeHints(this);
  }

#line 408 "WinprintFrame.wxc"
  if(dkctGUILayoutOK) {
    SetTitle(nlWx[0]);
    restorePosition();
  }
  if((pNames) && (nNames > 0)) {
    wxsNames = new wxString[nNames];
    if(wxsNames) {
      for(i = 0; i < nNames; i++) {
        wxsNames[i] = wxString(pNames[i]);
      }
    }
  }
  pComm = new DkWxCommunicator(
    applicationHelper->getWxEncoding(),
    applicationHelper->getDkEncoding()
  );
  if(argc > 1) {
    bAutostartWanted = true;
    {
      wxChar const	*ptr;
      int		res	= -1;
      wxCmdLineParser parser(winprint_cmd_line_desc, argc, argv);
      {
        wxLogNull log;
	res = parser.Parse(false);
      }
      if(0 == res) {
        wxString	sPrinter(wxT(""));
	if(pComm) {
	  pComm->autostartEnable(true);
	}
	if(parser.Found(wxT("d"))) {
	  /* Use default printer */
	  bUseDefaultPrinter = true;
	} else {
	  if(parser.Found(wxT("P"), &sPrinter)) {
	    /* Use named printer */
	    ptr = sPrinter.c_str();
	    if(ptr) {
	      if(sNamedPrinter) {
	        dk3_release(sNamedPrinter);
	      }
	      sNamedPrinter = dk3wxs_dup(ptr);
	    }
	  }
	}
	if(parser.GetParamCount() > 0) {
	  wxString	cmdfn;
	  wxString	fullPath;
	  /* Print named file(s) */
	  cmdfn = parser.GetParam(0);
	  wxFileName fn(cmdfn);
	  fn.Normalize(
	    wxPATH_NORM_LONG | wxPATH_NORM_DOTS
	    | wxPATH_NORM_TILDE | wxPATH_NORM_ABSOLUTE
	  );
	  fullPath = fn.GetFullPath();
	  ptr = fullPath.c_str();
	  if(ptr) {
	    if(sNamedFile) {
	      dk3_release(sNamedFile);
	    }
	    sNamedFile = dk3wxs_dup(ptr);
	  }
	}
      }
    }
  }
}




#line 481 "WinprintFrame.wxc"



WinprintFrame::~WinprintFrame()
{
  size_t		i;	/* Index of current string to delete. */
  /*	__CHANGE__ 011:	Release resources allocated by further class members.
  */
  if(wxsNames) {
    for(i = 0; i < nNames; i++) {
      wxsNames[i] = wxString(wxT(""));
    }
    delete [] wxsNames;
  }
  dk3_cpp_release(pComm);
  if(sNamedPrinter) {
    dk3_release(sNamedPrinter);
    sNamedPrinter = NULL;
  }
  if(sNamedFile) {
    dk3_release(sNamedFile);
    sNamedFile = NULL;
  }
}



bool
WinprintFrame::canClose(bool isLast)
{
  bool		back	= true;

  /*	__CHANGE__ 013: Check for unsaved data.
  */

  return back;
}


void
WinprintFrame::OnQuit(wxCommandEvent & event)
{
  Close();
}



void
WinprintFrame::OnAbout(wxCommandEvent & event)
{
  wxString	text(wxT(""));	/* Text to show. */
  wxString	title(wxT(""));	/* Windows title. */

  /* Construct message text. */
  text.Append(sNlWx[0]);
  text.Append(sNlWx[7]);
#if 0
  text.Append(sNlWx[1]);
#else
  text.Append( DKT_WXCHAR_VERSION );
#endif
  text.Append(sNlWx[8]);
  text.Append(sTexts[9]);
  text.Append(sNlWx[2]);
  text.Append(sNlWx[8]);
  text.Append(sNlWx[8]);
  text.Append(sTexts[11]);
  text.Append(sNlWx[8]);
  text.Append(sNlWx[9]);
  text.Append(sNlWx[8]);
  text.Append(sNlWx[8]);
  text.Append(sTexts[12]);
  text.Append(sNlWx[8]);
  text.Append(sNlWx[10]);
  text.Append(sNlWx[8]);
  text.Append(sNlWx[11]);
  text.Append(sNlWx[8]);
  text.Append(sNlWx[12]);
  text.Append(sNlWx[8]);
  text.Append(sNlWx[13]);
  text.Append(sNlWx[8]);
  text.Append(sNlWx[14]);
  text.Append(sNlWx[8]);
  text.Append(sNlWx[15]);
  text.Append(sNlWx[8]);
  
  /* Construct dialog box title. */
  title.Append(sTexts[10]);
  title.Append(sNlWx[0]);

  /* Show dialog box. */
  wxMessageBox(text, title, wxOK, this);

  /*	__CHANGE__ 019:	Create better about box.
  */
}



void
WinprintFrame::OnHelpContents(wxCommandEvent & event)
{
  openHelp();
}

/*	__CHANGE__ 017:	Event handlers for further events.
*/

void
WinprintFrame::OnPrint(wxCommandEvent & event)
{
  (void)runJob();
}


/*	__CHANGE__ 014:	Implementation of further methods.
*/


/*	__CHANGE__ 008:	Remove OnIdle if no idle processing required.
*/

void
WinprintFrame::OnIdle(wxIdleEvent & event)
{
  static BOOL firstIdle = true;	/* Flag: First idle event of application. */
  dk3_time_t		  ct;	/* Current time. */
  int			  res;	/* Operation result. */
  

#line 610 "WinprintFrame.wxc"
  /* __CHANGE__
  */
  if(firstIdle) {			

#line 613 "WinprintFrame.wxc"
    firstIdle = false;
    tStatus->SetLabel(wxT(""));
    Refresh();
    Update();
    /* For autostart */
    event.RequestMore();
  } else {				

#line 620 "WinprintFrame.wxc"
    if(!bCloseScheduled) {		

#line 621 "WinprintFrame.wxc"
      if(pComm) {			

#line 622 "WinprintFrame.wxc"
        if((bAutostartWanted) && (pComm->autostartCanRun())) {
	  

#line 624 "WinprintFrame.wxc"
          res = runJob();
	  if(res > 0) {			

#line 626 "WinprintFrame.wxc"
	    event.RequestMore();
	  }
        } else {			

#line 629 "WinprintFrame.wxc"
          if(pComm->autostartIsFinished()) {	

#line 630 "WinprintFrame.wxc"
	    if(!(timeClose)) {			

#line 631 "WinprintFrame.wxc"
	      if(pComm->getLogLevel() > DK3_LL_WARNING) {	

#line 632 "WinprintFrame.wxc"
	        dk3sf_time(&timeClose);		

#line 633 "WinprintFrame.wxc"
	        event.RequestMore();
	        tStatus->SetLabel(sTexts[14]);	

#line 635 "WinprintFrame.wxc"
		tStatus->SetForegroundColour(cGreen);
	        Refresh();
	        Update();
	      } else {
	        tStatus->SetLabel(pComm->getText());	

#line 640 "WinprintFrame.wxc"
		tStatus->SetForegroundColour(cRed);
		Refresh();
		Update();
		wxMessageBox(
		  pComm->getText(), sTexts[29], (wxICON_ERROR | wxOK), this
		);
		dk3sf_time(&timeClose);		

#line 647 "WinprintFrame.wxc"
		event.RequestMore();
	      }
	    }
	  }
	  if(timeClose) {		

#line 652 "WinprintFrame.wxc"
	    dk3sf_time(&ct);
	    if(ct > (timeClose + (dk3_time_t)1UL)) {	

#line 654 "WinprintFrame.wxc"
	      timeClose = (dk3_time_t)0UL;
	      bCloseScheduled = true;
	      Show(false);
	      Close();
	    } else {			

#line 659 "WinprintFrame.wxc"
	      event.RequestMore();
	    }
	  }
        }
      } else {				

#line 664 "WinprintFrame.wxc"
        /* ERROR: No communicator */
	if(timeClose) {
	  dk3sf_time(&ct);
	  if(ct > (timeClose * (dk3_time_t)1UL)) {
	    timeClose = (dk3_time_t)0UL;
	    bCloseScheduled = true;
	    Show(false);
	    Close();
	  } else {
	    event.RequestMore();
	  }
	}
      }
    } else {					

#line 678 "WinprintFrame.wxc"
    }
  }
  event.Skip();
  

#line 682 "WinprintFrame.wxc"
}



int
WinprintFrame::runJob(void)
{
  wxChar		 prbuf[512];	/* Printer name in system enc. */
  wxString		 path;		/* File path. */
  wxChar const		*filename = NULL;	/* File name. */
  wxChar const		*printername = NULL;	/* Printer name. */
  int			 res;			/* Operation result. */
  int			 ok = 0;		/* Flag: Success. */
  int			 back = 0;
  

#line 697 "WinprintFrame.wxc"
  tStatus->SetLabel(sTexts[17]);		

#line 698 "WinprintFrame.wxc"
  tStatus->SetForegroundColour(cBlack);
  Refresh();
  Update();
  if(sNamedFile) {				

#line 702 "WinprintFrame.wxc"
    filename = sNamedFile;
  } else {					

#line 704 "WinprintFrame.wxc"
    wxString s(wxT(""));
    s.Append(wxT("Print files (*.prn)|*.prn"));
    s.Append(wxT("|All files (*.*)|*.*"));
#if wxCHECK_VERSION(2, 9, 0)
    wxFileDialog dlg(this, sTexts[18], wxT("."), wxT(""), s, wxFD_OPEN);
#else
    wxFileDialog dlg(this, sTexts[18], wxT("."), wxT(""), s, wxOPEN);
#endif
    pHelper->setRelatedPosition(this, &dlg, &fdx, &fdy);
    if(wxID_OK == dlg.ShowModal()) {
      path = dlg.GetPath();
      filename = path.c_str();
    } else {
      /* Aborted by user */
      setErrorStatus(sTexts[19], NULL);		

#line 719 "WinprintFrame.wxc"
    }
    dlg.GetPosition(&fdx, &fdy);
  }
  if(filename) {				

#line 723 "WinprintFrame.wxc"
    if(bUseDefaultPrinter) {			

#line 724 "WinprintFrame.wxc"
      if(pc) {					

#line 725 "WinprintFrame.wxc"
        if(pc->defPrinter) {			

#line 726 "WinprintFrame.wxc"
	  if((pc->defPrinter->name)) {		

#line 727 "WinprintFrame.wxc"
	    res = dk3wxs_from_dkstr(
	      prbuf,
	      DK3_SIZEOF(prbuf,wxChar),
	      pHelper->getWxEncoding(),
	      (pc->defPrinter)->name,
	      pHelper->getDkEncoding()
	    );
	    if(res) {				

#line 735 "WinprintFrame.wxc"
	      printername = prbuf;
	    } else {				

#line 737 "WinprintFrame.wxc"
	      /* ERROR: Failed to convert printer name! */
	      setErrorStatus(sTexts[24], filename);	

#line 739 "WinprintFrame.wxc"
	    }
	  } else {				

#line 741 "WinprintFrame.wxc"
	    /* ERROR: No default printer name */
	    setErrorStatus(sTexts[25], filename);	

#line 743 "WinprintFrame.wxc"
	  }
	} else {				

#line 745 "WinprintFrame.wxc"
	  /* ERROR: No default printer */
	  setErrorStatus(sTexts[25], filename);	

#line 747 "WinprintFrame.wxc"
	}
      } else {					

#line 749 "WinprintFrame.wxc"
        /* ERROR: No print configuration */
	setErrorStatus(sTexts[26], filename);	

#line 751 "WinprintFrame.wxc"
      }
    } else {					

#line 753 "WinprintFrame.wxc"
      if(sNamedPrinter) {			

#line 754 "WinprintFrame.wxc"
        printername = sNamedPrinter;
      } else {					

#line 756 "WinprintFrame.wxc"
	if((pNames) && (wxsNames) && (nNames > 0)) {	

#line 757 "WinprintFrame.wxc"
	  WinprintChooserDialog dlg(this, sTexts[30], sTexts, wxsNames, nNames);
	  dlg.setCurrentPrinter(nDefPrinter);
	  pHelper->setRelatedPosition(this, &dlg, &pcx, &pcy);
	  if(wxID_OK == dlg.ShowModal()) {		

#line 761 "WinprintFrame.wxc"
	    nDefPrinter = dlg.getCurrentPrinter();
	    if((nDefPrinter >= 0) && (nDefPrinter < (int)nNames)) { 

#line 763 "WinprintFrame.wxc"
	      printername = pNames[nDefPrinter];
	    } else {					

#line 765 "WinprintFrame.wxc"
	      /* BUG: Illegal return value from dialog */
	      setErrorStatus(sTexts[26], filename);	

#line 767 "WinprintFrame.wxc"
	    }
	  } else {					

#line 769 "WinprintFrame.wxc"
	    /* ERROR: Aborted by user */
	    setErrorStatus(sTexts[19], filename);	

#line 771 "WinprintFrame.wxc"
	  }
	  dlg.GetPosition(&pcx, &pcy);
	} else {					

#line 774 "WinprintFrame.wxc"
	  /* ERROR: No printer configuration */
	  setErrorStatus(sTexts[26], filename);		

#line 776 "WinprintFrame.wxc"
	}
      }
    }
  } else {					

#line 780 "WinprintFrame.wxc"
  }
  if((filename) && (printername)) {		

#line 782 "WinprintFrame.wxc"
    /* wxMessageBox(filename, printername); */
    if(pComm) {					

#line 784 "WinprintFrame.wxc"
      DkWxProgressDialog *pd;
      pComm->prepareRun();
      pd = new DkWxProgressDialog(
        (DkWxFrame *)this,
	pComm,
	NULL,
	sTexts[20],
	filename,
	sTexts[21],
	sTexts[22],
	sTexts[23]
      );
      if(pd) {					

#line 797 "WinprintFrame.wxc"
        WinprintThread	*pt;
	pt = new WinprintThread(
	  pComm, sTexts, pHelper, pc, filename, printername
	);
	if(pt) {				

#line 802 "WinprintFrame.wxc"
	  if(wxTHREAD_NO_ERROR == pt->Create()) {	

#line 803 "WinprintFrame.wxc"
	    pt->SetPriority(WXTHREAD_DEFAULT_PRIORITY);
	    pt->Run();
	    pd->chooseModalPosition();
	    pd->ShowModal();
	    ok = 1;
	    if(pComm->getLogLevel() <= DK3_LL_WARNING) {	

#line 809 "WinprintFrame.wxc"
	      /* ERRORS occured */
	      tStatus->SetLabel(pComm->getText());		

#line 811 "WinprintFrame.wxc"
	      tStatus->SetForegroundColour(cRed);
	    } else {						

#line 813 "WinprintFrame.wxc"
	      /* Transfer succeeeded */
	      if(!(bAutostartWanted)) {
	        tStatus->SetLabel(sTexts[37]);		

#line 816 "WinprintFrame.wxc"
		tStatus->SetForegroundColour(cGreen);
	      }
	    }
	    Refresh();
	    Update();
	    back = 1;
	  } else {					

#line 823 "WinprintFrame.wxc"
	    /* ERROR: Create method failed! */
	    setErrorStatus(sTexts[27], filename);	

#line 825 "WinprintFrame.wxc"
	  }
	} else {			

#line 827 "WinprintFrame.wxc"
	  /* ERROR: Failed to create thread */
	  setErrorStatus(sTexts[27], filename);		

#line 829 "WinprintFrame.wxc"
	}
        pd->Destroy();
      } else {				

#line 832 "WinprintFrame.wxc"
        /* ERROR: Failed to create progress dialog */
	setErrorStatus(sTexts[28], filename);		

#line 834 "WinprintFrame.wxc"
      }
    } else {				

#line 836 "WinprintFrame.wxc"
      /* ###### ERROR: No communicator */
    }
  } else {				

#line 839 "WinprintFrame.wxc"
    if(pComm) {
      if(!(filename)) {
      }
      if(!(printername)) {
      }
    } else {
      /* ##### ERROR: No communicator */
    }
  } 

#line 848 "WinprintFrame.wxc"
  return back;
}



void
WinprintFrame::setErrorStatus(wxChar const *txt, wxChar const *filename)
{
  if(pComm) {
    pComm->prepareRun();
    pComm->addWxText(txt);
    pComm->setLogLevel(DK3_LL_ERROR);
    pComm->setUpdates(((filename) ? filename : wxT("")), 1000);
    pComm->setRunning(0);
  }
  tStatus->SetLabel(txt);
  tStatus->SetForegroundColour(cRed);
  Refresh();
  Update();
}


