/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: WinprintApp.cpt
*/

/*
Copyright (C) 2013, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file WinprintApp.cpp The WinprintApp module.
*/


#line 84 "WinprintApp.cpt"

#include "winprint.h"




#line 89 "WinprintApp.cpt"



/**	Localized wxChar texts.
*/
static wxChar const *	winprint_texts[] = {
/* 0 */
wxT("File"),

/* 1 */
wxT("Exit"),

/* 2 */
wxT("Exit the application"),

/* 3 */
wxT("Help"),

/* 4 */
wxT("About"),

/* 5 */
wxT("Show version information"),

/* 6 */
wxT("Contents"),

/* 7 */
wxT("Open table of contents"),

/* 8 */
wxT("Ready"),

/* 9 */
wxT("Copyright (c) "),

/* 10 */
wxT("About "),

/* 11 */
wxT("This program uses the following libraries:"),

/* 12 */
wxT("See:"),

/* 13 */
wxT("Initializing print queue names."),

/* 14 */
wxT("Success, exiting."),

/* 15 */
wxT("Print"),

/* 16 */
wxT("Schedule a file to printer."),

/* 17 */
wxT("Transferring print data."),

/* 18 */
wxT("Choose file to print"),

/* 19 */
wxT("Aborted by user!"),

/* 20 */
wxT("Data transfer"),

/* 21 */
wxT("Cancel"),

/* 22 */
wxT("Cancel data transfer"),

/* 23 */
wxT("Data transfer cancelled, wait please..."),

/* 24 */
wxT("ERROR: Bad printer name!"),

/* 25 */
wxT("ERROR: No default printer found!"),

/* 26 */
wxT("ERROR: Failed to obtain print configuration!"),

/* 27 */
wxT("ERROR: Failed to create background thread!"),

/* 28 */
wxT("ERROR: Failed to create progress dialog!"),

/* 29 */
wxT("Error while scheduling print data"),

/* 30 */
wxT("Printer selection"),

/* 31 */
wxT("Choose printer:"),

/* 32 */
wxT("OK"),

/* 33 */
wxT("Use selected printer."),

/* 34 */
wxT("Cancel"),

/* 35 */
wxT("Abort operation"),

/* 36 */
wxT("Choose the destination printer"),

/* 37 */
wxT("Transfer completed."),

/* 38 */
wxT("Error while writing print data to job file!"),

/* 39 */
wxT("Failed to open input file!"),

/* 40 */
wxT("Failed to schedule job to print queue!"),

/* 41 */
wxT("Failed to create print job data file!"),

/* 42 */
wxT("Failed to add print job to queue!"),

/* 43 */
wxT("Failed to open print queue!"),

/* 44 */
wxT("File name conversion failed!"),

/* 45 */
wxT("Printer name conversion failed!"),

NULL


#line 281 "WinprintApp.cpt"
};



/**	Non-localized wxChar texts.
*/
static wxChar const *	winprint_nl_wx[] = {
/* 0 */
wxT("winprint"),

/* 1 */
wxT("1.0.0"),

/* 2 */
wxT("Dirk Krause"),

/* 3 */
wxT("Dirk Krause"),

/* 4 */
wxT("aaaaa"),

/* 5 */
wxT("winprint.chm"),

/* 6 */
wxT("winprint.htb"),

/* 7 */
wxT(" "),

/* 8 */
wxT("\n"),

/* 9 */
wxT("DK tools, wxWidgets, libpng, libjpeg, libtiff, zlib."),

/* 10 */
wxT("http://dktools.sourceforge.net"),

/* 11 */
wxT("http://www.wxwidgets.org"),

/* 12 */
wxT("http://www.libpng.org/pub/png/libpng.html"),

/* 13 */
wxT("http://www.ijg.org"),

/* 14 */
wxT("http://www.remotesensing.org/libtiff"),

/* 15 */
wxT("http://www.zlib.net"),

NULL


#line 338 "WinprintApp.cpt"
};



/**	Non-localized dkChar texts.
*/
static dkChar const *	winprint_nl_dk[] = {
/* 0 */
dkT("dkt-3"),

/* 1 */
dkT("winprint.str"),

NULL


#line 355 "WinprintApp.cpt"
};



/**	Implementation of the wxApp functionality.
*/
IMPLEMENT_APP(WinprintApp)


bool
WinprintApp::OnInit()
{
  WinprintFrame		*frame	= NULL;		/* Main window to show. */
  wxChar const * const	*localizedTexts;	/* Localized texts. */
  bool			 back	= false;

  

#line 372 "WinprintApp.cpt"

  /* Initialize members. */
  nDefPrinter = 0;
  pNames = NULL;
  pHelper = NULL;
  helpController = NULL;
  pc = NULL;

  /*	__CHANGE__ 009:	Initialize further members here.
  */

  /* Set up helper object. */
  pHelper = new DkWxAppHelper(
    argv[0],
    winprint_nl_wx[3],
    winprint_nl_dk[0]
  );
  if(!(pHelper)) { goto finished; }
  if(!(pHelper->checkSetup())) { goto finished; }

  /* Add image and file system handlers for online help. */
  wxImage::AddHandler(new wxPNGHandler);
  wxImage::AddHandler(new wxXPMHandler);
  wxImage::AddHandler(new wxICOHandler);
  wxFileSystem::AddHandler(new wxZipFSHandler);

  localizedTexts = pHelper->getStringTable(winprint_texts, winprint_nl_dk[1]);
  if(!(localizedTexts)) { localizedTexts = winprint_texts; }

  /* Set up online help controller. */
  helpController = new DkWxHelpController(
    pHelper,
    winprint_nl_wx[5],
    winprint_nl_wx[6]
  );
  if(!(helpController)) { goto finished; }

  pc = dk3print_conf_open(pHelper->getApp(), 0);
  if(!(pc)) { goto finished; }

  setPrinterNames();
  if(!(pNames)) { goto finished; }

  /* Create and show frame. */
  frame = new WinprintFrame(
    WinprintFrame_MainWindow,
    pHelper,
    helpController,
    argc,
    argv,
    localizedTexts,
    winprint_nl_wx,
    winprint_nl_dk,
    pc,
    pNames,
    nNames,
    nDefPrinter
  );
  if(!(frame)) { goto finished; }
  frame->Show();
  back = true;

  /* Release resources if initialization failed. */
  finished:
  if(!(back)) {
    if(pNames) {
      releasePrinterNames();
    }
    if(helpController) {
      delete(helpController);
      helpController = NULL;
    }
    if(pHelper) {
      delete(pHelper);
      pHelper = NULL;
    }
    if(pc) {
      dk3print_conf_close(pc);
      pc = NULL;
    }
  }
  return back;
}



int
WinprintApp::OnExit()
{
  int			 back = 0;

  /*	__CHANGE__ 009:	Release resources allocated by further members.
  */

  /* Release resources. */
  if(pNames) {
    releasePrinterNames();
  }
  if(pc) {
    dk3print_conf_close(pc);
    pc = NULL;
  }
  if(helpController) {
    delete(helpController);
    helpController = NULL;
  }
  if(pHelper) {
    delete(pHelper);
    pHelper = NULL;
  }

  

#line 484 "WinprintApp.cpt"

  /*	__CHANGE__ 010:	Set back to exit status code.
  */
  return back;
}



void
WinprintApp::setPrinterNames(void)
{
  wxChar		 buf[512];	/* Conversion buffer. */
  void			*vptr;		/* Printer as returned from iterator. */
  dk3_printer_t		*pr;		/* Current printer. */
  DK3_PCWXCHAR		*wxptr;		/* Printer name in wxChar. */
  size_t	 	 n = 0;		/* Number of printers. */
  size_t		 i;		/* Index of current printer. */
  int			 wxe;		/* wxChar encoding. */
  int			 dke;		/* dkChar encoding. */
  
  if(pc) {
    dk3sto_it_reset(pc->iPrinters);
    while(NULL != (vptr = dk3sto_it_next(pc->iPrinters))) {
      pr = (dk3_printer_t *)vptr;
      if(DK3_PRINTER_TYPE_WINDOWS == pr->t_p) {
        if(pr->name) {
	  n++;
	}
      }
    }
    if(n) {
      pNames = dk3_new_app(DK3_PCWXCHAR,n,pHelper->getApp());
      if(pNames) {
        wxptr = pNames;
	for(i = 0; i < n; i++) {
	  *(wxptr++) = NULL;
	}
	i = 0;
	wxptr = pNames;
	dk3sto_it_reset(pc->iPrinters);
	while(NULL != (vptr = dk3sto_it_next(pc->iPrinters))) {
	  pr = (dk3_printer_t *)vptr;
	  if(DK3_PRINTER_TYPE_WINDOWS == pr->t_p) {
	    if(pr->name) {
	      wxe = pHelper->getWxEncoding();
	      dke = pHelper->getDkEncoding();
	      if(dk3wxs_from_dkstr(buf,DK3_SIZEOF(buf,wxChar),wxe,pr->name,dke))
	      {
	        *wxptr = dk3wxs_dup(buf);
		if(*wxptr) {
		  if(pc->defPrinter) {
		    if((pc->defPrinter)->name) {
		      if(dk3str_cmp(pr->name, (pc->defPrinter)->name) == 0) {
		        nDefPrinter = (int)i;
		      }
		    }
		  }
		  wxptr++;
		  i++;
		}
	      }
	    }
	  }
	}
	nNames = i;
      }
    }
  }
}


void
WinprintApp::releasePrinterNames(void)
{
  DK3_PCWXCHAR		*wxptr;	/* Current printer name to release. */
  size_t		 i;	/* Index of current printer name. */
  

#line 561 "WinprintApp.cpt"
  if(pNames) {
    wxptr = pNames;
    for(i = 0; i < nNames; i++) {
      if(*wxptr) {
        

#line 566 "WinprintApp.cpt"
        dk3_release(*wxptr);
	wxptr++;
      }
    }
    dk3_delete(pNames);
    pNames = NULL;
  } 

#line 573 "WinprintApp.cpt"
}


