/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: DkWxTraceThread.cpt
*/

/*
Copyright (C) 2011, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file DkWxTraceThread.h Header file for the DkWxTraceThread module.
*/

#ifndef DKWXTRACETHREAD_H_INCLUDED
/** Avoid multiple inclusions. */
#define DKWXTRACETHREAD_H_INCLUDED 1


#line 10 "DkWxTraceThread.cpt"

#include "dkwxtrace.h"



#line 14 "DkWxTraceThread.cpt"



/**	Worker thread for wxdkct.
*/
class DkWxTraceThread : public wxThread
{
  protected:

    /**	Conversion option set.
    */
    DKCT_OPTION_SET		dkcto;

    /**	Communication object between main thread and worker thread.
    */
    DkWxCommunicator		*pComm;

    /**	Localized text messages.
    */
    wxChar const * const	*sTexts;

    /**	Localized dkChar messages.
    */
    dkChar const * const	*msg;

    /**	Directory to process.
    */
    wxChar const		*sDirectory;

    /**	Application helper.
    */
    DkWxAppHelper		*pHelper;

    /**	Application structure.
    */
    dk3_app_t			*app;

    /**	Encoding used for wxChar.
    */
    int				 wxe;

    /**	Encoding used for dkChar.
    */
    int				 dke;

    /**	Run for one file.
    	@param	fn	File name.
	@param	sufi	Suffix index.
    */
    void
    runForFile(dkChar const *fn, int sufi);

    /**	Check one file, run if necessary.
    	@param	fn	File name.
	@param	sufi	Suffix index.
    */
    void
    checkAndRunFile(dkChar const *fn, int sufi);

    /**	Run for directory.
    	@param	dirname	Directory name.
    */
    void
    runForDirectory(wxChar const *dirname);

  public:

    /**	Constructor
    	@param	comm		Communication object.
	@param	texts		Localized messages texts.
	@param	ms		Localized dkChar message texts.
	@param	directory	Directory to process.
	@param	ah		Application helper.
	@param	o		Conversion option set.
	@param	we		Encoding for wxChar.
	@param	de		Encoding for dkChar.
    */
    DkWxTraceThread(
      DkWxCommunicator		*comm,
      wxChar const * const	*texts,
      dkChar const * const	*ms,
      wxChar const		*directory,
      DkWxAppHelper		*ah,
      DKCT_OPTION_SET		*o,
      int			 we,
      int			 de
    );

    /**	Thread function.
    	@return	A pointer which is ignored.
    */
    virtual void *Entry();

    /**	Function executed at the end of thread, does nothing.
    */
    virtual void OnExit();

};



#endif
