/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: DkWxTraceThread.cpt
*/

/*
Copyright (C) 2011, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file DkWxTraceThread.cpp The DkWxTraceThread module.
*/


#line 115 "DkWxTraceThread.cpt"

#include "dkwxtrace.h"



#line 119 "DkWxTraceThread.cpt"



/**	wxChar keywords used in this module.
*/
static wxChar const wxdkct_trace_thread_string_colon[] = { wxT(":") };



/**	Keywords used in this module.
*/
static dkChar const * const dkwxtrthr_kw[] = {
/*  0 */	dkT("."),
NULL
};



static
void
dkwxtrthr_check_current_directory(DKCT_SRC *psrc, dkChar const *fn)
{
  dkChar curdir[DK3_MAX_PATH];
  dkChar fndir[DK3_MAX_PATH];
  dkChar *ptr;
  

#line 145 "DkWxTraceThread.cpt"
  if(dk3str_len(fn) < DK3_SIZEOF(fndir,dkChar)) {
    dk3str_cpy(fndir, fn);
    ptr = dk3str_rchr(fndir, DK3_CHAR_SEP);
    if(ptr) { *ptr = DK3_CHAR_0; }
    if(dk3str_cmp(dkwxtrthr_kw[0], fndir) == 0) {
      psrc->curdi = 1;
    } else {
      if(dk3sf_getcwd_app(curdir,DK3_SIZEOF(curdir,dkChar),psrc->app)) {
        if(dk3str_cmp(curdir, fndir) == 0) {
	  psrc->curdi = 1;
	}
      }
    }
  } 

#line 159 "DkWxTraceThread.cpt"
}



DkWxTraceThread::DkWxTraceThread(
  DkWxCommunicator	*comm,
  wxChar const * const	*texts,
  dkChar const * const	*ms,
  wxChar const		*directory,
  DkWxAppHelper		*ah,
  DKCT_OPTION_SET	*o,
  int			 we,
  int			 de
) : wxThread(wxTHREAD_DETACHED)
{
  

#line 175 "DkWxTraceThread.cpt"
  pComm = comm;
  wxe = we;
  dke = de;
  sTexts = texts;
  msg = ms;
  sDirectory = directory;
  pHelper = ah;
  app = pHelper->getApp();
  dk3mem_cpy((void *)(&dkcto),(void *)o,sizeof(DKCT_OPTION_SET));
  

#line 185 "DkWxTraceThread.cpt"
}



static wxChar const testfilename[] = { wxT("Test") };



void
DkWxTraceThread::runForFile(dkChar const *fn, int sufi)
{
  char		 shn[DK3_MAX_PATH];	/* Short file name. */
  dkChar const	*pstart;		/* Start of short file name. */
  DKCT_SRC	*psrc;			/* Source structure. */
  int		 ie;			/* Input encoding. */
  int		 ok = 0;
  

#line 202 "DkWxTraceThread.cpt"
  pstart = dk3str_rchr(fn, DK3_CHAR_SEP);
  if(pstart) { pstart++; } else { pstart = fn; }
  ie = dk3app_get_encoding(app);
  if(dk3str_to_c8p_app(shn, sizeof(shn), pstart, ie, app)) { 

#line 206 "DkWxTraceThread.cpt"
    pComm->addDkText(fn);
    pComm->addWxText(wxdkct_trace_thread_string_colon);
    pComm->nl();
    psrc = dkct_tr_new(&dkcto, shn, sufi, app, fn);
    if(psrc) {					

#line 211 "DkWxTraceThread.cpt"
      (psrc->dkcto).deben = 1;
      psrc->msg = msg;
      psrc->pComm = pComm;
      dkwxtrthr_check_current_directory(psrc, fn);
      if(dkct_tr_read(psrc, fn, sufi)) {	

#line 216 "DkWxTraceThread.cpt"
        if(dkct_tr_check(psrc, fn, sufi)) {	

#line 217 "DkWxTraceThread.cpt"
	  if(dkct_tr_write(psrc, fn, sufi)) {	

#line 218 "DkWxTraceThread.cpt"
	    ok = 1;
	  }
	}
      }
      dkct_tr_delete(psrc); psrc = NULL;
    } else {
      /* ERROR: Memory! */
      pComm->addWxText(sTexts[63]);
      pComm->nl();
    } 

#line 228 "DkWxTraceThread.cpt"
    pComm->addWxText(sTexts[(ok) ? 56 : 57]);	

#line 229 "DkWxTraceThread.cpt"
    pComm->nl();
    pComm->nl();
  } else {		

#line 232 "DkWxTraceThread.cpt"
    /* ERROR: Can not convert file name to 8-bit characters plain! */
    pComm->addWxText(sTexts[61]);
    pComm->addDkText(fn);
    pComm->addWxText(sTexts[62]);
    pComm->nl();
  } 

#line 238 "DkWxTraceThread.cpt"
}



void
DkWxTraceThread::checkAndRunFile(dkChar const *fn, int sufi)
{
  dkChar		b1[DK3_MAX_PATH];
  dkChar		*xsu;
  dkChar const		*pstart;
  dkChar const * const	*lfdsu;
  

#line 250 "DkWxTraceThread.cpt"
  int must_run = 1;
  if(dkcto.mak) {			

#line 252 "DkWxTraceThread.cpt"
    /* Check whether we really need to run */
    if(dk3str_len(fn) < DK3_SIZEOF(b1,dkChar)) {
      dk3str_cpy(b1, fn);
      lfdsu = (dkct_str_get_dest_suffixes())[sufi];
      xsu = dk3str_get_suffix(b1);
      if(xsu) {
        must_run = 0;
	while(*lfdsu) {
	  *xsu = dkT('\0');
	  if((dk3str_len(b1) + dk3str_len(*lfdsu)) < DK3_SIZEOF(b1,dkChar)) {
	    dk3str_cat(b1, *lfdsu);
	    if(dk3sf_must_rebuild(b1,fn)) {
	      must_run = 1;
	    }
	  } else {
	    must_run = 1;
	  }
	  lfdsu++;
	}
      }
    }
  }
  if(must_run) {			

#line 275 "DkWxTraceThread.cpt"
    runForFile(fn, sufi);
  } else {
    /* Up to date. */
    pstart = dk3str_rchr(fn, DK3_CHAR_SEP);
    if(pstart) { pstart++; } else { pstart = fn; }
    pComm->addDkText(pstart);
    pComm->addWxText(wxdkct_trace_thread_string_colon);
    pComm->nl();
    pComm->addWxText(sTexts[55]);
    pComm->nl();
    pComm->nl();
  } 

#line 287 "DkWxTraceThread.cpt"
}



void
DkWxTraceThread::runForDirectory(wxChar const *dirname)
{
  dkChar		 bu[DK3_MAX_PATH];
  wxChar		 fnb[DK3_MAX_PATH];
  dk3_dir_t		*dir;
  dkChar const		*en;
  dkChar const		*su;
  dk3_stat_t const	*es;
  dk3_um_t	 	 nFiles;
  dk3_um_t	 	 cFile;
  dk3_um_t	 	 promille;
  int		 	 ai;
  int		 	 cc;
  

#line 306 "DkWxTraceThread.cpt"
  cFile = DK3_UM_0;
  cc  = 1;
  if(dk3wxs_to_dkstr(bu, DK3_SIZEOF(bu,dkChar), dke, dirname, wxe)) {
    

#line 310 "DkWxTraceThread.cpt"
    dir = dk3dir_open_app(bu, app);
    if(dir) {				

#line 312 "DkWxTraceThread.cpt"
      nFiles = dk3dir_get_number_of_files(dir);
      if(!(nFiles)) nFiles++;
      while(cc) {			

#line 315 "DkWxTraceThread.cpt"
	cc = 0;
	if(dk3dir_get_next_file(dir)) {	

#line 317 "DkWxTraceThread.cpt"
	  cc = 1;
          if(cFile > nFiles) cFile = nFiles;
          promille = ((dk3_um_t)1000UL * cFile) / nFiles;
          en = dk3dir_get_fullname(dir);
	  es = dk3dir_get_stat(dir);
	  if((en) && (es)) {		

#line 323 "DkWxTraceThread.cpt"
	    if(dk3wxs_from_dkstr(fnb, DK3_SIZEOF(fnb,wxChar), wxe, en, dke)) {
	      pComm->setUpdates(fnb, promille);
	    }
	    switch((es->ft) & (~(DK3_FT_SYMLINK))) {
	      case DK3_FT_REGULAR: {	

#line 328 "DkWxTraceThread.cpt"
	        su = dk3str_get_suffix(en);
	        if(su) {
#if DK3_ON_WINDOWS || DK3_HAVE_FNCASEINS
		  ai = dk3str_array_index(dkct_str_get_source_suffixes(), su, 0);
#else
		  ai = dk3str_array_index(dkct_str_get_source_suffixes(), su, 1);
#endif
		  if(ai >= 0) {
		    checkAndRunFile(en, ai);
		  }
	        }
	      } break;
	    }
	  }
	  cFile++;
	}
	if(!(pComm->getCanContinue())) {
	  cc = 0;
	}
      }
      dk3dir_close(dir);
    } else {		

#line 350 "DkWxTraceThread.cpt"
      /* ERROR: Failed to open directory! */
      pComm->addWxText(sTexts[59]);
      pComm->addWxText(dirname);
      pComm->addWxText(sTexts[60]);
      pComm->nl();
    }
  } else {		

#line 357 "DkWxTraceThread.cpt"
    /* ERROR: Filename conversion failed! */
    pComm->addWxText(sTexts[58]);
    pComm->nl();
  } 

#line 361 "DkWxTraceThread.cpt"
}



void *
DkWxTraceThread::Entry()
{
  

#line 369 "DkWxTraceThread.cpt"
#if 0
  /*
	Simple test thread witout practical use.
  */
  int	i = 0;
  int	cc = 1;
  int	numbreak = -1;
  do {
    this->Sleep(100);
    i++;
    if(i >= 100) {
      cc = 0;
    }
    pComm->setUpdates(testfilename, (10*i));
    if(pComm->getCanContinue() == 0) {
      if(numbreak == -1) {
        numbreak = i;
      } else {
        if(i >= numbreak + 15) {
	  cc = 0;
	}
      }
    }
    pComm->addWxText(wxT("Test mit einer ganz ganz ganz ganz langen Zeile\n"));
  } while(cc);
  pComm->setRunning(0);
#else
  /*
	Start message
  */
  pComm->addWxText(sTexts[54]);
  if(sDirectory) {
    pComm->addWxText(sDirectory);
  } else {
    pComm->addWxText(sTexts[25]);
  }
  pComm->nl();
  runForDirectory((sDirectory) ? sDirectory : sTexts[25]);
  /*
	Signal finished.
  */
  pComm->setRunning(0);
#endif
  

#line 413 "DkWxTraceThread.cpt"
  return NULL;
}



void
DkWxTraceThread::OnExit()
{
}




