/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: DkWxTraceFrame.wxc
*/

/*
Copyright (C) 2011, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file DkWxTraceFrame.h Header file for the DkWxTraceFrame module.
*/

#ifndef DKWXTRACEFRAME_H_INCLUDED
/** Avoid multiple inclusions. */
#define DKWXTRACEFRAME_H_INCLUDED 1


#line 139 "DkWxTraceFrame.wxc"

#include	"dkct.h"



#line 144 "DkWxTraceFrame.wxc"

/**	Top level frame of the dkwxtrace program.
*/
class DkWxTraceFrame : public DkWxFrame
{

  private:
  
    /**	Event table.
    */
    DECLARE_EVENT_TABLE()  
  
  protected:
  
    /**	Localized texts.
    */
    wxChar const * const	*sTexts;

    /**	Localized dkChar texts.
    */
    dkChar const * const	*msg;

    /**	Conversion options.
    */
    DKCT_OPTION_SET		options;

    /**	Communication object for main thread and worker thread.
    */
    DkWxCommunicator		*pComm;

    /**	Current directory.
    */
    wxChar const		*sDirectory;

    /**	Color: Black.
    */
    wxColour			*cBlack;

    /**	Color: Dark green.
    */
    wxColour			*cGreen;

    /**	Color: Dark red.
    */
    wxColour			*cRed;

    /**	Timestamp to close the application.
    */
    dk3_time_t			timeClose;

    /**	Directory dialog x position.
    */
    int				ddx;

    /**	Directory dialog y position.
    */
    int				ddy;

    /**	Options dialog x position.
    */
    int				odx;

    /**	Options dialog y position.
    */
    int				ody;

    /**	Must save the current settings.
    */
    bool			 bSaveSettings;

    /**	Must save the current directory.
    */
    bool			 bSaveDirectory;

    /**	Timestamp for closing the application is scheduled.
    */
    bool			 bCloseScheduled;

    /**	GUI elements are active, not automatic closing.
    */
    bool			 bGuiActive;

    /**	The run was started automatically.
    */
    bool			 bAutoStartRequested;

    /**	Flag: GUI ok.
    */
    bool dkctGUILayoutOK;

    /**	Contents panel.
    */
    wxPanel *dkctGUIContentsPanel;

    /**	GUI element mbMain.
    */
#line 49 "DkWxTraceFrame.wxc"
    wxMenuBar *mbMain;

    /**	GUI element mainSizer.
    */
#line 95 "DkWxTraceFrame.wxc"
    wxBoxSizer *mainSizer;

    /**	GUI element tbMain.
    */
#line 19 "DkWxTraceFrame.wxc"
    wxToolBar *tbMain;

    /**	GUI element bDir.
    */
#line 25 "DkWxTraceFrame.wxc"
    wxToolBarToolBase *bDir;

    /**	GUI element bOptions.
    */
#line 31 "DkWxTraceFrame.wxc"
    wxToolBarToolBase *bOptions;

    /**	GUI element bRun.
    */
#line 37 "DkWxTraceFrame.wxc"
    wxToolBarToolBase *bRun;

    /**	GUI element bExit.
    */
#line 43 "DkWxTraceFrame.wxc"
    wxToolBarToolBase *bExit;

    /**	GUI element menuFile.
    */
#line 53 "DkWxTraceFrame.wxc"
    wxMenu *menuFile;

    /**	GUI element menuHelp.
    */
#line 60 "DkWxTraceFrame.wxc"
    wxMenu *menuHelp;

    /**	GUI element miFileDir.
    */
#line 65 "DkWxTraceFrame.wxc"
    wxMenuItem *miFileDir;

    /**	GUI element miFileOptions.
    */
#line 70 "DkWxTraceFrame.wxc"
    wxMenuItem *miFileOptions;

    /**	GUI element miFileRun.
    */
#line 75 "DkWxTraceFrame.wxc"
    wxMenuItem *miFileRun;

    /**	GUI element miFileExit.
    */
#line 80 "DkWxTraceFrame.wxc"
    wxMenuItem *miFileExit;

    /**	GUI element miHelpContents.
    */
#line 85 "DkWxTraceFrame.wxc"
    wxMenuItem *miHelpContents;

    /**	GUI element miHelpAbout.
    */
#line 90 "DkWxTraceFrame.wxc"
    wxMenuItem *miHelpAbout;

    /**	GUI element verticalSizer.
    */
#line 101 "DkWxTraceFrame.wxc"
    wxBoxSizer *verticalSizer;

    /**	GUI element contentsSizer.
    */
#line 113 "DkWxTraceFrame.wxc"
    wxGridBagSizer *contentsSizer;

    /**	GUI element tLogmessages.
    */
#line 128 "DkWxTraceFrame.wxc"
    wxTextCtrl *tLogmessages;

    /**	GUI element tStatus.
    */
#line 134 "DkWxTraceFrame.wxc"
    wxStaticText *tStatus;

    /**	GUI element lDirectory.
    */
#line 122 "DkWxTraceFrame.wxc"
    wxStaticText *lDirectory;

    /**	GUI element tDirectory.
    */
#line 125 "DkWxTraceFrame.wxc"
    wxStaticText *tDirectory;


#line 231 "DkWxTraceFrame.wxc"

  public:
  
    /**	Constructor.
    	@param	applicationName		Application name.
    	@param	messageTexts		Localized texts.
	@param	ms			Message texts as dkChar strings.
    	@param	applicationHelper	Application helper.
    	@param	wxid			Window ID.
	@param	hc			Help controller.
	@param	argc			Number of command line arguments.
	@param	argv			Command line arguments array.
    */
    DkWxTraceFrame(
      wxChar const		*applicationName,
      wxChar const * const	*messageTexts,
      dkChar const * const	*ms,
      DkWxAppHelper		*applicationHelper,
      int			 wxid,
      DkWxHelpController	*hc,
      int			 argc,
      wxChar 			**argv
    );



    /**	Destructor.
    */
    ~DkWxTraceFrame();

    /**	Find index for splint special character.
    	@param	c	Character to find index for.
	@return	Index in range 0 to 17.
    */
    int findSplintCharacterIndex(char c);

    
    /**	Check whether we can close the window.
    	@param	isLast	Flag: Last top level window.
    */
    bool canClose(bool isLast);

    /**	Menu event handler for File / Quit.
    	@param	event	Event to process.
    */
    void OnQuit(wxCommandEvent& event);
    
    /**	Menu event handler for Help / About.
    */
    void OnAbout(wxCommandEvent& event);

    /**	Menu event handler for Help / Contents.
    */
    void OnHelpContents(wxCommandEvent& event);

    /**	Menu event handler for File / Directory.
    */
    void OnChooseDirectory(wxCommandEvent& event);

    /**	Menu event handler for File / Options.
    */
    void OnSetOptions(wxCommandEvent& event);

    /**	Menu event handler for File / Run.
    */
    void OnRunConversion(wxCommandEvent& event);

    /**	Handler for idle events.
    */
    void OnIdle(wxIdleEvent & event);

    /**	Run a conversion.
    */
    void runConversion();

    /**	Check whether GUI elements are active.
    	@return	True if GUI elements can be used, false otherwise
	(autostart job running).
    */
    bool isGuiActive();

  protected:

    /**	Retrieve stored preferences.
    */
    void getData(void);

};


#line 321 "DkWxTraceFrame.wxc"


#endif
