/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: DkWxTraceFrame.wxc
*/

/*
Copyright (C) 2011, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file DkWxTraceFrame.cpp The DkWxTraceFrame module.
*/


#line 323 "DkWxTraceFrame.wxc"



#include "dkwxtrace.h"

/*
	Icons and bitmaps
*/
#include "dkicon.xpm"
#include "choose-dir.xpm"
#include "exit-program.xpm"
#include "run-conversion.xpm"
#include "set-options.xpm"



#line 338 "DkWxTraceFrame.wxc"


/**	Version for the about dialog (program name).
*/
static wxChar const dkwxct_version[] = {
  wxT("wxdkct (part of dkt-")
};

/**	Version number for the about dialog (version number).
*/
static wxChar const dkwxct_versnumber[] = {
  DKT_WXCHAR_VERSION
};

/**	Version number for the about dialog (end).
*/
static wxChar const dkwxct_versend[] = {
  wxT(")")
};

static wxChar const * const dkwxct_settings_names[] = {
/* 0 */
wxT("wxdkct.make"),

/* 1 */
wxT("wxdkct.line-numbers"),

/* 2 */
wxT("wxdkct.debug"),

/* 3 */
wxT("wxdkct.debug.timestamp"),

/* 4 */
wxT("wxdkct.debug.keyword"),

/* 5 */
wxT("wxdkct.debug.wide"),

/* 6 */
wxT("wxdkct.splint.use"),

/* 7 */
wxT("wxdkct.splint.selected"),

NULL


#line 393 "DkWxTraceFrame.wxc"
};



static wxChar const * dkwxct_string_settings_names[] = {
/* 0 */
wxT("wxdkct.directory"),

NULL


#line 404 "DkWxTraceFrame.wxc"
};


/**	Event table for the DkWxTraceFrame class.
 */
BEGIN_EVENT_TABLE(DkWxTraceFrame, wxFrame)
    EVT_MENU(DkWxTrace_Quit,  DkWxTraceFrame::OnQuit)
    EVT_MENU(DkWxTrace_Help_Contents, DkWxTraceFrame::OnHelpContents)
    EVT_MENU(DkWxTrace_About, DkWxTraceFrame::OnAbout)
    EVT_MENU(DkWxTrace_ChooseDirectory, DkWxTraceFrame::OnChooseDirectory)
    EVT_MENU(DkWxTrace_SetOptions, DkWxTraceFrame::OnSetOptions)
    EVT_MENU(DkWxTrace_Run, DkWxTraceFrame::OnRunConversion)
    EVT_IDLE(DkWxTraceFrame::OnIdle)
END_EVENT_TABLE()



static const wxCmdLineEntryDesc wxdkctframe_cmd_line_desc[] = {
  {
    wxCMD_LINE_SWITCH,
    wxT_2("r"),
    wxT_2("run"),
    wxT_2("Run conversion")
  },
  {
    wxCMD_LINE_SWITCH,
    wxT_2("R"),
    wxT_2("reset"),
    wxT_2("Reset all options")
  },
  {
    wxCMD_LINE_SWITCH,
    wxT_2("m"),
    wxT_2("make"),
    wxT_2("Run in make mode")
  },
  {
    wxCMD_LINE_SWITCH,
    wxT_2("l"),
    wxT_2("line-numbers"),
    wxT_2("Run conversion")
  },
  {
    wxCMD_LINE_OPTION,
    wxT_2("b"),
    wxT_2("box"),
    wxT_2("Box width"),
    wxCMD_LINE_VAL_NUMBER
  },

  {
    wxCMD_LINE_SWITCH,
    wxT_2("d"),
    wxT_2("debug"),
    wxT_2("Create debug output")
  },
  {
    wxCMD_LINE_SWITCH,
    wxT_2("s"),
    wxT_2("debug-stdout"),
    wxT_2("Send debug output to standard output")
  },
  {
    wxCMD_LINE_SWITCH,
    wxT_2("t"),
    wxT_2("time"),
    wxT_2("Include timestamps in debug output")
  },
  {
    wxCMD_LINE_SWITCH,
    wxT_2("k"),
    wxT_2("keyword"),
    wxT_2("Include \"trace\" keyword in debug output")
  },
  {
    wxCMD_LINE_SWITCH,
    wxT_2("w"),
    wxT_2("wide"),
    wxT_2("Allow wide character debug output")
  },
  {
    wxCMD_LINE_PARAM,
    NULL,
    NULL,
    wxT_2("input file"),
    wxCMD_LINE_VAL_STRING,
    wxCMD_LINE_PARAM_OPTIONAL
  },
  { wxCMD_LINE_NONE }
};



#line 497 "DkWxTraceFrame.wxc"
DkWxTraceFrame::DkWxTraceFrame(
  wxChar const		*applicationName,
  wxChar const * const	*messageTexts,
  dkChar const * const	*m,
  DkWxAppHelper		*applicationHelper,
  int			 wxid,
  DkWxHelpController	*hc,
  int			 argc,
  wxChar 		**argv
) : DkWxFrame(applicationName, applicationHelper, hc, wxid)
{
  

#line 509 "DkWxTraceFrame.wxc"
  ddx = -1; ddy = -1;
  odx = -1; ody = -1;
  bAutoStartRequested = false;
  pComm = NULL;
  cBlack = NULL;
  cGreen = NULL;
  cRed = NULL;
  sDirectory = NULL;
  sTexts = messageTexts;
  msg = m;
  bSaveSettings = true;
  bSaveDirectory = true;
  bCloseScheduled = false;
  bGuiActive = true;
#if defined(__WXMSW__)
  wxIcon	dkicon_bitmap(wxT("aaaaa"));	/* from resource file */
#else
  wxIcon	dkicon_bitmap(xpm_dkicon);	/* from included xpm */
#endif
  options.deb = 0;
  options.deben = 1;
  options.lnn = 0;
  options.mak = 0;
  options.sty = 0;
  options.bw  = 75;
  options.tkw = 0;
  options.ts  = 0;
  options.win = 0;
  options.tip = 0;
  timeClose = (dk3_time_t)0UL;
  getData();
  dkctGUILayoutOK = false;
  dkctGUIContentsPanel = NULL;
  mbMain = NULL;
  mainSizer = NULL;
  tbMain = NULL;
  bDir = NULL;
  bOptions = NULL;
  bRun = NULL;
  bExit = NULL;
  menuFile = NULL;
  menuHelp = NULL;
  miFileDir = NULL;
  miFileOptions = NULL;
  miFileRun = NULL;
  miFileExit = NULL;
  miHelpContents = NULL;
  miHelpAbout = NULL;
  verticalSizer = NULL;
  contentsSizer = NULL;
  tLogmessages = NULL;
  tStatus = NULL;
  lDirectory = NULL;
  tDirectory = NULL;
  dkctGUIContentsPanel = new wxPanel(this);
  if(!(dkctGUIContentsPanel)) {
    goto dkctGUILayoutFinished;
  }
#if wxUSE_MENUS
  mbMain = new wxMenuBar(
  );
  if(!(mbMain)) {
    goto dkctGUILayoutFinished;
  }
  menuFile = new wxMenu(
  );
  if(!(menuFile)) {
    goto dkctGUILayoutFinished;
  }
  miFileDir = menuFile->Append(
    DkWxTrace_ChooseDirectory,
    sTexts[12],
    sTexts[13]
  );
  if(!(miFileDir)) {
    goto dkctGUILayoutFinished;
  }
  miFileOptions = menuFile->Append(
    DkWxTrace_SetOptions,
    sTexts[14],
    sTexts[15]
  );
  if(!(miFileOptions)) {
    goto dkctGUILayoutFinished;
  }
  miFileRun = menuFile->Append(
    DkWxTrace_Run,
    sTexts[64],
    sTexts[65]
  );
  if(!(miFileRun)) {
    goto dkctGUILayoutFinished;
  }
  miFileExit = menuFile->Append(
    DkWxTrace_Quit,
    sTexts[5],
    sTexts[7]
  );
  if(!(miFileExit)) {
    goto dkctGUILayoutFinished;
  }
  mbMain->Append(menuFile, sTexts[3]);
  menuHelp = new wxMenu(
  );
  if(!(menuHelp)) {
    goto dkctGUILayoutFinished;
  }
  miHelpContents = menuHelp->Append(
    DkWxTrace_Help_Contents,
    sTexts[9],
    sTexts[10]
  );
  if(!(miHelpContents)) {
    goto dkctGUILayoutFinished;
  }
  miHelpAbout = menuHelp->Append(
    DkWxTrace_About,
    sTexts[6],
    sTexts[8]
  );
  if(!(miHelpAbout)) {
    goto dkctGUILayoutFinished;
  }
  mbMain->Append(menuHelp, sTexts[4]);
  SetMenuBar(mbMain);
#endif
#if wxUSE_TOOLBAR
  tbMain = new wxToolBar(
    this,
    wxID_ANY
  );
  if(!(tbMain)) {
    goto dkctGUILayoutFinished;
  }
  bDir = tbMain->AddTool(
    DkWxTrace_ChooseDirectory,
    sTexts[17],
    xpm_choose_dir,
    wxNullBitmap,
    wxITEM_NORMAL,
    sTexts[21]
  );
  if(!(bDir)) {
    goto dkctGUILayoutFinished;
  }
  bOptions = tbMain->AddTool(
    DkWxTrace_SetOptions,
    sTexts[18],
    xpm_set_options,
    wxNullBitmap,
    wxITEM_NORMAL,
    sTexts[22]
  );
  if(!(bOptions)) {
    goto dkctGUILayoutFinished;
  }
  bRun = tbMain->AddTool(
    DkWxTrace_Run,
    sTexts[19],
    xpm_run_conversion,
    wxNullBitmap,
    wxITEM_NORMAL,
    sTexts[23]
  );
  if(!(bRun)) {
    goto dkctGUILayoutFinished;
  }
  bExit = tbMain->AddTool(
    DkWxTrace_Quit,
    sTexts[20],
    xpm_exit_program,
    wxNullBitmap,
    wxITEM_NORMAL,
    sTexts[24]
  );
  if(!(bExit)) {
    goto dkctGUILayoutFinished;
  }
  tbMain->Realize();
  SetToolBar(tbMain);
#endif
  mainSizer = new wxBoxSizer(
    wxHORIZONTAL
  );
  if(!(mainSizer)) {
    goto dkctGUILayoutFinished;
  }
  mainSizer->Add(10, 10, 0);
  verticalSizer = new wxBoxSizer(
    wxVERTICAL
  );
  if(!(verticalSizer)) {
    goto dkctGUILayoutFinished;
  }
  verticalSizer->Add(10, 10, 0);
  contentsSizer = new wxGridBagSizer(
    5, 5
  );
  if(!(contentsSizer)) {
    goto dkctGUILayoutFinished;
  }
  lDirectory = new wxStaticText(
    dkctGUIContentsPanel,
    wxID_ANY,
    sTexts[11]
  );
  if(!(lDirectory)) {
    goto dkctGUILayoutFinished;
  }
  contentsSizer->Add(
    lDirectory,
    wxGBPosition(0, 0),
    wxGBSpan(1, 1),
    wxALIGN_RIGHT
  );
  tDirectory = new wxStaticText(
    dkctGUIContentsPanel,
    wxID_ANY,
    ((sDirectory) ? sDirectory : sTexts[25])
  );
  if(!(tDirectory)) {
    goto dkctGUILayoutFinished;
  }
  contentsSizer->Add(
    tDirectory,
    wxGBPosition(0, 1),
    wxGBSpan(1, 1)
  );
  verticalSizer->Add(
    contentsSizer,
    0,
    wxALIGN_LEFT
  );
  verticalSizer->Add(10, 10, 0);
  tLogmessages = new wxTextCtrl(
    dkctGUIContentsPanel,
    wxID_ANY,
    wxEmptyString,
    wxDefaultPosition,
    wxSize(200, 30),
    wxTE_MULTILINE|wxTE_READONLY|wxTE_NOHIDESEL|wxTE_LEFT|wxTE_DONTWRAP
  );
  if(!(tLogmessages)) {
    goto dkctGUILayoutFinished;
  }
  verticalSizer->Add(
    tLogmessages,
    1,
    wxALIGN_LEFT|wxALIGN_TOP|wxGROW
  );
  verticalSizer->Add(10, 10, 0);
  tStatus = new wxStaticText(
    dkctGUIContentsPanel,
    wxID_ANY,
    sTexts[67]
  );
  if(!(tStatus)) {
    goto dkctGUILayoutFinished;
  }
  verticalSizer->Add(
    tStatus,
    0,
    wxALIGN_LEFT
  );
  verticalSizer->Add(10, 10, 0);
  mainSizer->Add(
    verticalSizer,
    1,
    wxGROW
  );
  mainSizer->Add(10, 10, 0);
  dkctGUIContentsPanel->SetSizer(mainSizer);
  SetIcon(dkicon_bitmap);
  dkctGUILayoutOK = true;
  dkctGUILayoutFinished:
#if wxUSE_STATUSBAR
  if(dkctGUILayoutOK) {
    CreateStatusBar(1);
    SetStatusText(sTexts[67]);
  }
#endif
  if(dkctGUILayoutOK) {
    mainSizer->Fit(this);
    mainSizer->SetSizeHints(this);
  }

#line 541 "DkWxTraceFrame.wxc"
  

#line 542 "DkWxTraceFrame.wxc"
  pComm = new DkWxCommunicator(
    applicationHelper->getWxEncoding(),
    applicationHelper->getDkEncoding()
  );
  cBlack = new wxColour(0x00, 0x00, 0x00);
  cGreen = new wxColour(0x00, 0x7F, 0x00);
  cRed   = new wxColour(0x7f, 0x00, 0x00);
  if(argc > 1) {
    int		res	= 	-1;
    long	l	=	0L;
    wxString	cmdfn;
    wxCmdLineParser parser(wxdkctframe_cmd_line_desc, argc, argv);
    bSaveSettings = false; bSaveDirectory = false;
    {
      wxLogNull log;
      res = parser.Parse(false);
    }
    if(parser.Found(wxT("r"))) {
      if(pComm) {
        pComm->autostartEnable(true);
	bGuiActive = false;
	bAutoStartRequested = true;
      }
    }
    if(parser.Found(wxT("R"))) {
      options.deb = 0;
      options.deben = 1;
      options.lnn = 0;
      options.mak = 0;
      options.sty = 0;
      options.bw  = 75;
      options.tkw = 0;
      options.ts  = 0;
      options.win = 0;
      options.tip = 0;
    }
    if(parser.Found(wxT("d"))) {
      options.deb = 1; options.deben = 1;
    }
    if(parser.Found(wxT("s"))) {
      options.deb = 2; options.deben = 1;
    }
    if(parser.Found(wxT("l"))) {
      options.lnn = 1;
    }
    if(parser.Found(wxT("m"))) {
      options.mak = 1;
    }
    if(parser.Found(wxT("b"), &l)) {
      if((l > 20L) && (l < 128L)) {
        options.bw = (int)l;
      }
    }
    if(options.deb) {
      if(parser.Found(wxT("t"))) {
        options.ts = 1;
      }
      if(parser.Found(wxT("k"))) {
        options.tkw = 1;
      }
      if(parser.Found(wxT("w"))) {
        options.win = 1;
      }
    }
    if(parser.GetParamCount() > 0) {	

#line 607 "DkWxTraceFrame.wxc"
      wxChar const	*nd;
      cmdfn = parser.GetParam(0);	

#line 609 "DkWxTraceFrame.wxc"
      wxFileName fn(cmdfn);
      fn.Normalize(
        wxPATH_NORM_LONG
	| wxPATH_NORM_DOTS
	| wxPATH_NORM_TILDE
	| wxPATH_NORM_ABSOLUTE
      );
      cmdfn = fn.GetFullPath();	 

#line 617 "DkWxTraceFrame.wxc"
      if(wxFileName::DirExists(cmdfn)) {	

#line 618 "DkWxTraceFrame.wxc"
        nd = cmdfn.c_str();
	if(nd) {			

#line 620 "DkWxTraceFrame.wxc"
	  nd = dk3wxs_dup_app(nd, applicationHelper->getApp());
	  if(nd) {			

#line 622 "DkWxTraceFrame.wxc"
	    dk3_release(sDirectory);
	    sDirectory = nd;
	    if(tDirectory) {
	      tDirectory->SetLabel(sDirectory);
	    }
	  } else {			

#line 628 "DkWxTraceFrame.wxc"
            pComm->autostartEnable(false);
            bGuiActive = true;
            if(bAutoStartRequested) {
              tStatus->SetLabel(sTexts[71]);
	      if((cBlack) && (cRed)) { tStatus->SetForegroundColour(*cRed); }
	      bAutoStartRequested = false;
            }
	  }
	} else {			

#line 637 "DkWxTraceFrame.wxc"
          pComm->autostartEnable(false);
          bGuiActive = true;
          if(bAutoStartRequested) {
            tStatus->SetLabel(sTexts[71]);
	    if((cBlack) && (cRed)) { tStatus->SetForegroundColour(*cRed); }
	    bAutoStartRequested = false;
          }
	}
      } else {				

#line 646 "DkWxTraceFrame.wxc"
        pComm->autostartEnable(false);
        bGuiActive = true;
        if(bAutoStartRequested) {
          tStatus->SetLabel(sTexts[71]);
	  if((cBlack) && (cRed)) { tStatus->SetForegroundColour(*cRed); }
	  bAutoStartRequested = false;
        }
      }
    } else {
      pComm->autostartEnable(false);
      bGuiActive = true;
      if(bAutoStartRequested) {
        tStatus->SetLabel(sTexts[71]);
	if((cBlack) && (cRed)) { tStatus->SetForegroundColour(*cRed); }
	bAutoStartRequested = false;
      }
    }
  }
  restorePosition();
  

#line 666 "DkWxTraceFrame.wxc"
}



#line 670 "DkWxTraceFrame.wxc"



DkWxTraceFrame::~DkWxTraceFrame()
{
  dk3_cpp_release(pComm);
  dk3_cpp_release(cBlack);
  dk3_cpp_release(cGreen);
  dk3_cpp_release(cRed);
}



void DkWxTraceFrame::OnQuit(wxCommandEvent& WXUNUSED(event))
{
  if(isGuiActive()) {
    bCloseScheduled = true;
    Close();
  }
}



void DkWxTraceFrame::OnHelpContents(wxCommandEvent& WXUNUSED(event))
{
  

#line 696 "DkWxTraceFrame.wxc"
  openHelp();
  

#line 698 "DkWxTraceFrame.wxc"
}



void DkWxTraceFrame::OnAbout(wxCommandEvent& WXUNUSED(event))
{
  

#line 705 "DkWxTraceFrame.wxc"
  if(isGuiActive()) {
    wxString sVersion(dkwxct_version);
    sVersion.Append(dkwxct_versnumber);
    sVersion.Append(dkwxct_versend);
    sVersion.Append(sTexts[73]);
    sVersion.Append(wxT("Copyright (c) 2013 Dirk Krause"));
    sVersion.Append(sTexts[73]);
    sVersion.Append(sTexts[73]);
    sVersion.Append(sTexts[74]);
    sVersion.Append(wxT("DK tools, wxWidgets, libpng, libjpeg, libtiff, zlib."));
    sVersion.Append(sTexts[73]);
    sVersion.Append(sTexts[73]);
    sVersion.Append(sTexts[75]);
    sVersion.Append(wxT("http://dktools.sourceforge.net\n"));
    sVersion.Append(wxT("http://www.wxwidgets.org\n"));
    sVersion.Append(wxT("http://www.libpng.org/pub/png/libpng.html\n"));
    sVersion.Append(wxT("http://www.ijg.org\n"));
    sVersion.Append(wxT("http://www.remotesensing.org/libtiff\n"));
    sVersion.Append(wxT("http://www.zlib.net\n"));
    wxMessageBox(sVersion, sTexts[66]);
  }
  

#line 727 "DkWxTraceFrame.wxc"
}



void DkWxTraceFrame::OnChooseDirectory(wxCommandEvent& WXUNUSED(event))
{
  wxChar const	*ptr;
  wxChar const	*np;
  

#line 736 "DkWxTraceFrame.wxc"
  if(isGuiActive()) {
    wxDirDialog	dd(
      this,
      sTexts[53],
      ((sDirectory) ? sDirectory : wxEmptyString), 
      (wxDD_DIR_MUST_EXIST | wxDD_CHANGE_DIR)
    );
    pHelper->setRelatedPosition(this, &dd, &ddx, &ddy);
    if(dd.ShowModal() == wxID_OK) {
      wxString path = dd.GetPath();
      ptr = path.c_str();
      if(ptr) {
        np = dk3wxs_dup_app(ptr, pHelper->getApp());
        if(np) {
	  dk3_release(sDirectory);
	  sDirectory = np;
	  if(tDirectory) {
	    tDirectory->SetLabel(sDirectory);
	    Refresh();
	    Update();
	  }
        }
      }
    }
    dd.GetPosition(&ddx, &ddy);
  }
  

#line 763 "DkWxTraceFrame.wxc"
}



void DkWxTraceFrame::OnSetOptions(wxCommandEvent& WXUNUSED(event))
{
  

#line 770 "DkWxTraceFrame.wxc"
  if(isGuiActive()) {
    DkWxTraceOptionsDialog dlg(
      (DkWxTraceFrame *)this, sTexts[30], sTexts, &options
    );
    dlg.dataIn();
    pHelper->setRelatedPosition(this, &dlg, &odx, &ody);
    dlg.ShowModal();
    dlg.GetPosition(&odx, &ody);
  }
  

#line 780 "DkWxTraceFrame.wxc"
}



void DkWxTraceFrame::runConversion()
{
  DkWxProgressDialog	*pd = NULL;
  DkWxTraceThread	*pt = NULL;
  int			 ok = 0;
  

#line 790 "DkWxTraceFrame.wxc"
  /* SetStatusText(sTexts[67]); */
  tStatus->SetLabel(sTexts[67]);
  if(cBlack) { tStatus->SetForegroundColour(*cBlack); }
  if(pComm) {
    pComm->prepareRun();
    pd = new DkWxProgressDialog(
      (DkWxFrame *)this,
      pComm,
      tLogmessages,
      sTexts[48],	/* title */
      sTexts[49],	/* file name */
      sTexts[50],	/* button text */
      sTexts[51],	/* button tool tip */
      sTexts[52]	/* wait text */
    );
    if(pd) {
      pt = new DkWxTraceThread(
        pComm,
	sTexts,
	msg,
	sDirectory,
	pHelper,
	&options,
	pHelper->getWxEncoding(),
	pHelper->getDkEncoding()
      );
      if(pt) {
        if(pt->Create() == wxTHREAD_NO_ERROR) {
          pt->SetPriority(WXTHREAD_DEFAULT_PRIORITY);
#if 0
	  if(iRunState == DK3_WX_RUN_STATE_START) {
	    iRunState = DK3_WX_RUN_STATE_RUNNING;
	  }
#endif
          pt->Run();
	  pd->chooseModalPosition();
          pd->ShowModal();
	  ok = 1;
	  if(pComm->getLogLevel() <= DK3_LL_WARNING) {
	    bGuiActive = true;
	  }
        } else {
          delete(pt);
	  /* ##### ERROR: Failed to create new thread! */
        }
      } else {
        /* ##### ERROR: Failed to construct new thread! */
      }
      pd->Destroy();
    } else {
      /* ##### ERROR: Failed to construct new progress dialog! */
    }
    if(tLogmessages) {
      pComm->getText(tLogmessages);
    }
    if(pComm->getLogLevel() > DK3_LL_WARNING) {
      /* SetStatusText(sTexts[68]); */
      if(bAutoStartRequested) {
        tStatus->SetLabel(sTexts[72]);
      } else {
        tStatus->SetLabel(sTexts[68]);
      }
      if((cBlack) && (cGreen)) { tStatus->SetForegroundColour(*cGreen); }
    } else {
      if(pComm->getLogLevel() < DK3_LL_WARNING) {
        /* SetStatusText(sTexts[70]); */
	tStatus->SetLabel(sTexts[70]);
	if((cBlack) && (cRed)) { tStatus->SetForegroundColour(*cRed); }
      } else {
        /* SetStatusText(sTexts[69]); */
	tStatus->SetLabel(sTexts[69]);
	if((cBlack) && (cRed)) { tStatus->SetForegroundColour(*cRed); }
      }
    }
    Refresh();
    Update();
  } 

#line 867 "DkWxTraceFrame.wxc"
}



void DkWxTraceFrame::OnRunConversion(wxCommandEvent& WXUNUSED(event))
{
  if(isGuiActive()) {
    runConversion();
  }
}



bool DkWxTraceFrame::canClose(bool isLast)
{
  bool back = true;
  int values_to_save[] = {
    0, 0, 0, 0, 0, 0, 0, 0
  };
  if(isLast) {
    if(bSaveSettings) {
      values_to_save[0] = options.mak;
      values_to_save[1] = options.lnn;
      values_to_save[2] = options.deb;
      values_to_save[3] = options.ts;
      values_to_save[4] = options.tkw;
      values_to_save[5] = options.win;
      values_to_save[6] = (('\0' != options.spls) ? 1 : 0);
      values_to_save[7] = findSplintCharacterIndex(options.spls);
      pHelper->saveMultipleInts(dkwxct_settings_names, values_to_save);
    }
    if(bSaveDirectory) {
      if(sDirectory) {
        pHelper->saveString(dkwxct_string_settings_names[0], sDirectory);
      }
    }
  }
  dk3_cpp_release(pComm);
  dk3_release(sDirectory);
  return back;
}



void DkWxTraceFrame::getData()
{
  int values_to_save[] = {
    0, 0, 0, 0, 0, 0, 0, 0
  };
  pHelper->retrieveMultipleInts(dkwxct_settings_names, values_to_save);
  options.mak = values_to_save[0];
  options.lnn = values_to_save[1];
  options.deb = values_to_save[2];
  options.ts  = values_to_save[3];
  options.tkw = values_to_save[4];
  options.win = values_to_save[5];
  options.spls = '\0';
  if ((values_to_save[6])
       && ((0 <= values_to_save[7]) && (18 > values_to_save[7])))
  {
    options.spls = (char)((sTexts[76 + values_to_save[7]])[0]);
  }
  sDirectory = pHelper->retrieveString(dkwxct_string_settings_names[0]);
}


void
DkWxTraceFrame::OnIdle(wxIdleEvent & event)
{
  dk3_time_t	ct;
  

#line 938 "DkWxTraceFrame.wxc"
  if(!bCloseScheduled) {
    if(pComm) {
      if(pComm->autostartCanRun()) {		

#line 941 "DkWxTraceFrame.wxc"
        runConversion();
      } else {
        if(pComm->autostartIsFinished()) {	

#line 944 "DkWxTraceFrame.wxc"
	  if(!(timeClose)) {
	    if(pComm->getLogLevel() > DK3_LL_WARNING) {
	      dk3sf_time(&timeClose);
	      event.RequestMore();
	      tStatus->SetLabel(sTexts[72]);
	      if((cGreen) && (cBlack)) {
	        tStatus->SetForegroundColour(*cGreen);
	      }
	      Refresh();
	      Update();
	    }
	  }
	}
      }
    }
    if(timeClose) {
      dk3sf_time(&ct);
      if(ct > (timeClose + (dk3_time_t)1UL)) {
        timeClose = (dk3_time_t)0UL;
        bCloseScheduled = true;
	Show(false);
	Close();
      } else {
        event.RequestMore();
      }
    }
  }
  

#line 972 "DkWxTraceFrame.wxc"
  event.Skip();
}



bool
DkWxTraceFrame::isGuiActive()
{
  bool		back = false;
  if(!(bCloseScheduled)) {
    back = bGuiActive;
  }
  return back;
}



int
DkWxTraceFrame::findSplintCharacterIndex(char c)
{
  int		 back	= 0;
  int		 i;			/* Traverse 0 to 17 */
  bool		 found	= false;	/* Flag: Character was found */
  for (i = 0; ((i < 18) && (!(found))); i++) {
    if (c == (sTexts[76 + i])[0]) {
      found = true;
      back = i;
    }
  }
  return back;
}

