/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: DkWxProcessingController.cpt
*/

/*
Copyright (C) 2013, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file DkWxProcessingController.h Header file for the DkWxProcessingController module.
*/

#ifndef DKWXPROCESSINGCONTROLLER_H_INCLUDED
/** Avoid multiple inclusions. */
#define DKWXPROCESSINGCONTROLLER_H_INCLUDED 1


#line 8 "DkWxProcessingController.cpt"

#include <dk3conf.h>
#include <dk3types.h>
#include <dk3const.h>

#include <wx/wxprec.h>
#ifdef __BORLANDC__
#pragma hdrstop
#endif
#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif
#include <wx/thread.h>



/**	Protect code from concurrent execution, mainly for timer handlers.
	In contrast to a critical section which delays execution of
	code to avoid concurrent access to data this class skips
	the execution of concurrent code.
*/
class DkWxProcessingController
{
  protected:

    /**	Prevent concurrent access.
    */
    wxMutex	mxProtectProcessing;

    /**	Flag: Processing is running.
    */
    bool	bIsRunning;

  public:
    /**	Default constructor.
    */
    DkWxProcessingController();

    /**	Begin processing if not already running.
    	If the function returns true you must invoke endProcessing()
	when your processing is finished.
    	@return	true to start processing, false if processing is running.
    */
    bool	canBeginProcessing(void);

    /**	End processing. Call this function after finishing the
    	critical code.
    */
    void	endProcessing(void);
};


#endif
