/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: DkWxPrintqdcFrame.wxc
*/

/*
Copyright (C) 2012, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file DkWxPrintqdcFrame.h Header file for the DkWxPrintqdcFrame module.
*/

#ifndef DKWXPRINTQDCFRAME_H_INCLUDED
/** Avoid multiple inclusions. */
#define DKWXPRINTQDCFRAME_H_INCLUDED 1


#line 126 "DkWxPrintqdcFrame.wxc"


#line 128 "DkWxPrintqdcFrame.wxc"

/**	Main window class for the wxpqdic program.
*/
class DkWxPrintqdcFrame : public DkWxFrame
{
  private:

    /**	Event table.
    */
    DECLARE_EVENT_TABLE()


  protected:

    /**	The worker thread.
    */
    wxThread			*thr;

    /**	Timer for periodic update.
    */
    wxTimer			 timer;

    /**	Mutex to protect bRunning and quotaData.
    */
    wxMutex			 mProtectData;

    /**	Text colour: black.
    */
    wxColour			 cBlack;
    
    /**	Text colour: green.
    */
    wxColour			 cGreen;

    /**	Text colour: red:
    */
    wxColour			 cRed;

    /**	Data retrieved by background thread.
    */
    wxpqdic_t			 quotaData;
    
    /**	Localized message texts.
    */
    wxChar const * const	*sTexts;

    /**	Request to send to server.
    */
    char const			*pRequest;

    /**	Host to connect to.
    */
    dkChar const		*pHostname;

    /**	Port number to connect to.
    */
    unsigned short		 iPortnumber;

    /**	Update interval.
    */
    int 			 iUpdateInterval;

    /**	Error code of last non-thread error occured.
    */
    int				 ec;

    /**	Flag: A background thread is currently running.
    */
    bool			 bRunning;

    /**	Flag: A background thread was seen in previous check.
    */
    bool			 bLastRunning;

    /**	Flag: No idle event was processed yet.
    */
    bool			 bFirstIdle;

    /**	Flag: GUI ok.
    */
    bool dkctGUILayoutOK;

    /**	Contents panel.
    */
    wxPanel *dkctGUIContentsPanel;

    /**	GUI element mbMain.
    */
#line 16 "DkWxPrintqdcFrame.wxc"
    wxMenuBar *mbMain;

    /**	GUI element tbMain.
    */
#line 56 "DkWxPrintqdcFrame.wxc"
    wxToolBar *tbMain;

    /**	GUI element mainSizer.
    */
#line 72 "DkWxPrintqdcFrame.wxc"
    wxBoxSizer *mainSizer;

    /**	GUI element mFile.
    */
#line 21 "DkWxPrintqdcFrame.wxc"
    wxMenu *mFile;

    /**	GUI element mView.
    */
#line 30 "DkWxPrintqdcFrame.wxc"
    wxMenu *mView;

    /**	GUI element mHelp.
    */
#line 39 "DkWxPrintqdcFrame.wxc"
    wxMenu *mHelp;

    /**	GUI element miExit.
    */
#line 25 "DkWxPrintqdcFrame.wxc"
    wxMenuItem *miExit;

    /**	GUI element miUpdate.
    */
#line 34 "DkWxPrintqdcFrame.wxc"
    wxMenuItem *miUpdate;

    /**	GUI element miHelp.
    */
#line 44 "DkWxPrintqdcFrame.wxc"
    wxMenuItem *miHelp;

    /**	GUI element miAbout.
    */
#line 49 "DkWxPrintqdcFrame.wxc"
    wxMenuItem *miAbout;

    /**	GUI element bUpdate.
    */
#line 60 "DkWxPrintqdcFrame.wxc"
    wxToolBarToolBase *bUpdate;

    /**	GUI element bExit.
    */
#line 66 "DkWxPrintqdcFrame.wxc"
    wxToolBarToolBase *bExit;

    /**	GUI element verticalSizer.
    */
#line 78 "DkWxPrintqdcFrame.wxc"
    wxBoxSizer *verticalSizer;

    /**	GUI element contentsSizer.
    */
#line 84 "DkWxPrintqdcFrame.wxc"
    wxGridBagSizer *contentsSizer;

    /**	GUI element lLimit.
    */
#line 98 "DkWxPrintqdcFrame.wxc"
    wxStaticText *lLimit;

    /**	GUI element tLimit.
    */
#line 101 "DkWxPrintqdcFrame.wxc"
    wxStaticText *tLimit;

    /**	GUI element lUsed.
    */
#line 104 "DkWxPrintqdcFrame.wxc"
    wxStaticText *lUsed;

    /**	GUI element tUsed.
    */
#line 107 "DkWxPrintqdcFrame.wxc"
    wxStaticText *tUsed;

    /**	GUI element lAccount.
    */
#line 110 "DkWxPrintqdcFrame.wxc"
    wxStaticText *lAccount;

    /**	GUI element tAccount.
    */
#line 113 "DkWxPrintqdcFrame.wxc"
    wxStaticText *tAccount;

    /**	GUI element lAllowed.
    */
#line 119 "DkWxPrintqdcFrame.wxc"
    wxStaticText *lAllowed;

    /**	GUI element tAllowed.
    */
#line 122 "DkWxPrintqdcFrame.wxc"
    wxStaticText *tAllowed;

    /**	GUI element lStatus.
    */
#line 116 "DkWxPrintqdcFrame.wxc"
    wxStaticText *lStatus;


#line 207 "DkWxPrintqdcFrame.wxc"

  protected:

  public:
    /**	Constructor.
    	@param	applicationName		Application name.
	@param	localizedMessages	Localized message texts.
	@param	applicationHelper	Application helper object.
	@param	wxid			Window ID.
	@param	argc			Number of command line arguments.
	@param	argv			Command line arguments array.
	@param	phc			Help controller.
    */
    DkWxPrintqdcFrame(
      wxChar const		 *applicationName,
      wxChar const * const	 *localizedMessages,
      DkWxAppHelper		 *applicationHelper,
      int			  wxid,
      int			  argc,
      wxChar			**argv,
      DkWxHelpController	 *phc
    );

    /**	Destructor.
    */
    ~DkWxPrintqdcFrame();

    /**	Check whether we can close the window.
    	@param	isLast	Flag: Last window of application.
	@return	True to close, false to prevent closing.
    */
    bool
    canClose(bool isLast);

    /**	Initialize member variables.
    	@param	argc	Number of command line arguments.
	@param	argv	Command line arguments array.
    */
    void
    initializeMembers(int argc, wxChar **argv);

    /**	Handler for Quit event.
    	@param	event	Event to process.
    */
    void
    OnQuit(wxCommandEvent & event);

    /**	Handler for Update event.
    	@param	event	Event to process.
    */
    void
    OnUpdate(wxCommandEvent & event);

    /**	Handler for timer event.
    	@param	event	Timer event to process.
    */
    void
    OnTimer(wxTimerEvent & event);

    /**	Handler for idle event.
    	@param	event	Idle event to process.
    */
    void
    OnIdle(wxIdleEvent & event);

    /**	Show results from background thread.
    */
    void
    showResults();

    /**	Start a new thread if possible.
    */
    void
    startThreadIfPossible();

    /**	Check whether we currently have a background thread running.
    	@return	True if a thread is running, false otherwise.
    */
    bool
    isRunning();

    /**	Set flag for background thread running.
    	@param	v	New flag value.
    */
    void
    setRunning(bool v);

    /**	Convert dkChar string to char.
    	@param	dp	Destination buffer pointer.
	@param	sz	Size of destination buffer.
	@param	src	Source string.
	@return	True on success, false on error.
    */
    bool
    convertWxToC8(
      char 		*dp,
      size_t 	 	 sz,
      wxString &	 src
    );

    /**	Set results from thread.
    	@param	res	Results to set.
    */
    void
    setThreadResult(wxpqdic_t *res);

    /**	Set a static text to the given value.
    	@param	wxst	Text label to change.
	@param	val	Numeric value to show.
    */
    void
    setTextUnsignedLong(wxStaticText *wxst, unsigned long val);

    /**	Show error status in error code.
    	@param	ec	Error code to show.
    */
    void
    showErrorStatus(int ec);

    /**	Show about dialog box.
    	@param	event	Event to process.
    */
    void
    OnAbout(wxCommandEvent & event);

    /**	Show help text.
    	@param	event	Event to process.
    */
    void
    OnHelp(wxCommandEvent & event);

};


#line 341 "DkWxPrintqdcFrame.wxc"


#endif
