/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: DkWxPrintqdcFrame.wxc
*/

/*
Copyright (C) 2012, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file DkWxPrintqdcFrame.cpp The DkWxPrintqdcFrame module.
*/


#line 343 "DkWxPrintqdcFrame.wxc"


#include "dkwxpqdc.h"
#include "dkicon.xpm"
#include "exit-program.xpm"
#include "run-conversion.xpm"




#line 352 "DkWxPrintqdcFrame.wxc"




static wxChar const wxpqdi_version[] = {
  wxT("wxpqdic (part of dkt-")
};



static wxChar const wxpqdi_versnumber[] = {
  DKT_WXCHAR_VERSION
};


static wxChar const wxpqdi_versend[] = {
  wxT(")")
};

static const wxCmdLineEntryDesc wxpqdic_cmd_line_entries[] = {
  {
    wxCMD_LINE_OPTION,
    wxT_2("h"),
    wxT_2("host"),
    wxT_2("Host to connect to."),
    wxCMD_LINE_VAL_STRING
  },
  {
    wxCMD_LINE_OPTION,
    wxT_2("p"),
    wxT_2("port"),
    wxT_2("Port number to connect to."),
    wxCMD_LINE_VAL_NUMBER
  },
  {
    wxCMD_LINE_OPTION,
    wxT_2("q"),
    wxT_2("queue"),
    wxT_2("Queue name to check."),
    wxCMD_LINE_VAL_STRING
  },
  {
    wxCMD_LINE_OPTION,
    wxT_2("u"),
    wxT_2("user"),
    wxT_2("User name to check."),
    wxCMD_LINE_VAL_STRING
  },
  {
    wxCMD_LINE_OPTION,
    wxT_2("i"),
    wxT_2("interval"),
    wxT_2("Time interval for automatic update."),
    wxCMD_LINE_VAL_NUMBER
  },
  { wxCMD_LINE_NONE }
};


/**	Event table for main window.
*/
BEGIN_EVENT_TABLE(DkWxPrintqdcFrame,wxFrame)
  EVT_MENU(DkWxPrintqdc_Quit, DkWxPrintqdcFrame::OnQuit)
  EVT_MENU(DkWxPrintqdc_Update, DkWxPrintqdcFrame::OnUpdate)
  EVT_MENU(DkWxPrintqdc_Help, DkWxPrintqdcFrame::OnHelp)
  EVT_MENU(DkWxPrintqdc_About, DkWxPrintqdcFrame::OnAbout)
  EVT_TIMER(DkWxPrintqdc_Timer, DkWxPrintqdcFrame::OnTimer)
  EVT_IDLE(DkWxPrintqdcFrame::OnIdle)
END_EVENT_TABLE()




#line 425 "DkWxPrintqdcFrame.wxc"
DkWxPrintqdcFrame::DkWxPrintqdcFrame(
      wxChar const		 *applicationName,
      wxChar const * const	 *localizedMessages,
      DkWxAppHelper		 *applicationHelper,
      int			  wxid,
      int			  argc,
      wxChar			**argv,
      DkWxHelpController	 *phc
)
: DkWxFrame(applicationName, applicationHelper, phc, wxid),
  timer(this, DkWxPrintqdc_Timer),
  mProtectData(wxMUTEX_DEFAULT),
  cBlack(0, 0, 0),
  cGreen(0, 127, 0),
  cRed(127, 0, 0)
{
  /*
  	Icon for main window.
  */
#if defined(__WXMSW__)
  wxIcon		dkicon_bitmap(wxT("aaaaa"));
#else
  wxIcon		dkicon_bitmap(xpm_dkicon);
#endif
  /*
  	Initialize all members.
  */
  thr = NULL;
  pRequest = NULL;
  pHostname = NULL;
  iPortnumber = 0;
  iUpdateInterval = 15;
  ec = 0;
  dk3mem_res((void *)(&quotaData), sizeof(wxpqdic_t));
  bRunning = false;
  bLastRunning = false;
  /*
  	Save constructor arguments.
  */
  sTexts = localizedMessages;
  dkctGUILayoutOK = false;
  dkctGUIContentsPanel = NULL;
  mbMain = NULL;
  tbMain = NULL;
  mainSizer = NULL;
  mFile = NULL;
  mView = NULL;
  mHelp = NULL;
  miExit = NULL;
  miUpdate = NULL;
  miHelp = NULL;
  miAbout = NULL;
  bUpdate = NULL;
  bExit = NULL;
  verticalSizer = NULL;
  contentsSizer = NULL;
  lLimit = NULL;
  tLimit = NULL;
  lUsed = NULL;
  tUsed = NULL;
  lAccount = NULL;
  tAccount = NULL;
  lAllowed = NULL;
  tAllowed = NULL;
  lStatus = NULL;
  dkctGUIContentsPanel = new wxPanel(this);
  if(!(dkctGUIContentsPanel)) {
    goto dkctGUILayoutFinished;
  }
#if wxUSE_MENUS
  mbMain = new wxMenuBar(
  );
  if(!(mbMain)) {
    goto dkctGUILayoutFinished;
  }
  mFile = new wxMenu(
  );
  if(!(mFile)) {
    goto dkctGUILayoutFinished;
  }
  miExit = mFile->Append(
    DkWxPrintqdc_Quit,
    sTexts[5],
    sTexts[8]
  );
  if(!(miExit)) {
    goto dkctGUILayoutFinished;
  }
  mbMain->Append(mFile, sTexts[3]);
  mView = new wxMenu(
  );
  if(!(mView)) {
    goto dkctGUILayoutFinished;
  }
  miUpdate = mView->Append(
    DkWxPrintqdc_Update,
    sTexts[6],
    sTexts[7]
  );
  if(!(miUpdate)) {
    goto dkctGUILayoutFinished;
  }
  mbMain->Append(mView, sTexts[4]);
  mHelp = new wxMenu(
  );
  if(!(mHelp)) {
    goto dkctGUILayoutFinished;
  }
  miHelp = mHelp->Append(
    DkWxPrintqdc_Help,
    sTexts[35],
    sTexts[37]
  );
  if(!(miHelp)) {
    goto dkctGUILayoutFinished;
  }
  miAbout = mHelp->Append(
    DkWxPrintqdc_About,
    sTexts[36],
    sTexts[38]
  );
  if(!(miAbout)) {
    goto dkctGUILayoutFinished;
  }
  mbMain->Append(mHelp, sTexts[34]);
  SetMenuBar(mbMain);
#endif
#if wxUSE_TOOLBAR
  tbMain = new wxToolBar(
    this,
    wxID_ANY
  );
  if(!(tbMain)) {
    goto dkctGUILayoutFinished;
  }
  bUpdate = tbMain->AddTool(
    DkWxPrintqdc_Update,
    sTexts[32],
    xpm_run_conversion,
    wxNullBitmap,
    wxITEM_NORMAL,
    sTexts[7]
  );
  if(!(bUpdate)) {
    goto dkctGUILayoutFinished;
  }
  bExit = tbMain->AddTool(
    DkWxPrintqdc_Quit,
    sTexts[33],
    xpm_exit_program,
    wxNullBitmap,
    wxITEM_NORMAL,
    sTexts[8]
  );
  if(!(bExit)) {
    goto dkctGUILayoutFinished;
  }
  tbMain->Realize();
  SetToolBar(tbMain);
#endif
  mainSizer = new wxBoxSizer(
    wxHORIZONTAL
  );
  if(!(mainSizer)) {
    goto dkctGUILayoutFinished;
  }
  mainSizer->Add(5, 5, 0);
  verticalSizer = new wxBoxSizer(
    wxVERTICAL
  );
  if(!(verticalSizer)) {
    goto dkctGUILayoutFinished;
  }
  verticalSizer->Add(5, 5, 0);
  contentsSizer = new wxGridBagSizer(
    5, 5
  );
  if(!(contentsSizer)) {
    goto dkctGUILayoutFinished;
  }
  lLimit = new wxStaticText(
    dkctGUIContentsPanel,
    wxID_ANY,
    sTexts[9]
  );
  if(!(lLimit)) {
    goto dkctGUILayoutFinished;
  }
  contentsSizer->Add(
    lLimit,
    wxGBPosition(0, 0),
    wxGBSpan(1, 1),
    wxALIGN_RIGHT
  );
  tLimit = new wxStaticText(
    dkctGUIContentsPanel,
    wxID_ANY,
    sTexts[31]
  );
  if(!(tLimit)) {
    goto dkctGUILayoutFinished;
  }
  contentsSizer->Add(
    tLimit,
    wxGBPosition(0, 1),
    wxGBSpan(1, 1)
  );
  lUsed = new wxStaticText(
    dkctGUIContentsPanel,
    wxID_ANY,
    sTexts[10]
  );
  if(!(lUsed)) {
    goto dkctGUILayoutFinished;
  }
  contentsSizer->Add(
    lUsed,
    wxGBPosition(1, 0),
    wxGBSpan(1, 1),
    wxALIGN_RIGHT
  );
  tUsed = new wxStaticText(
    dkctGUIContentsPanel,
    wxID_ANY,
    sTexts[31]
  );
  if(!(tUsed)) {
    goto dkctGUILayoutFinished;
  }
  contentsSizer->Add(
    tUsed,
    wxGBPosition(1, 1),
    wxGBSpan(1, 1)
  );
  lAccount = new wxStaticText(
    dkctGUIContentsPanel,
    wxID_ANY,
    sTexts[11]
  );
  if(!(lAccount)) {
    goto dkctGUILayoutFinished;
  }
  contentsSizer->Add(
    lAccount,
    wxGBPosition(2, 0),
    wxGBSpan(1, 1),
    wxALIGN_RIGHT
  );
  tAccount = new wxStaticText(
    dkctGUIContentsPanel,
    wxID_ANY,
    sTexts[31]
  );
  if(!(tAccount)) {
    goto dkctGUILayoutFinished;
  }
  contentsSizer->Add(
    tAccount,
    wxGBPosition(2, 1),
    wxGBSpan(1, 1)
  );
  contentsSizer->Add(5, 5, wxGBPosition(3, 0), wxGBSpan(1, 1));
  lAllowed = new wxStaticText(
    dkctGUIContentsPanel,
    wxID_ANY,
    sTexts[13]
  );
  if(!(lAllowed)) {
    goto dkctGUILayoutFinished;
  }
  contentsSizer->Add(
    lAllowed,
    wxGBPosition(4, 0),
    wxGBSpan(1, 1),
    wxALIGN_RIGHT
  );
  tAllowed = new wxStaticText(
    dkctGUIContentsPanel,
    wxID_ANY,
    sTexts[31]
  );
  if(!(tAllowed)) {
    goto dkctGUILayoutFinished;
  }
  contentsSizer->Add(
    tAllowed,
    wxGBPosition(4, 1),
    wxGBSpan(1, 1)
  );
  contentsSizer->Add(5, 5, wxGBPosition(5, 0), wxGBSpan(1, 1));
  lStatus = new wxStaticText(
    dkctGUIContentsPanel,
    wxID_ANY,
    sTexts[12]
  );
  if(!(lStatus)) {
    goto dkctGUILayoutFinished;
  }
  contentsSizer->Add(
    lStatus,
    wxGBPosition(6, 0),
    wxGBSpan(1, 2)
  );
  verticalSizer->Add(
    contentsSizer,
    0,
    wxALIGN_LEFT
  );
  verticalSizer->Add(5, 5, 0);
  mainSizer->Add(
    verticalSizer
  );
  mainSizer->Add(5, 5, 0);
  dkctGUIContentsPanel->SetSizer(mainSizer);
  SetIcon(dkicon_bitmap);
  dkctGUILayoutOK = true;
  dkctGUILayoutFinished:
  if(dkctGUILayoutOK) {
    mainSizer->Fit(this);
    mainSizer->SetSizeHints(this);
  }

#line 466 "DkWxPrintqdcFrame.wxc"
  /*
  	Set Window title.
  */
  SetTitle(sTexts[1]);
  /*
  	Restore position from previous run.
  */
  initializeMembers(argc, argv);
  restorePosition();
  bFirstIdle = true;
}


#line 479 "DkWxPrintqdcFrame.wxc"



/**	Keywords in dkChar.
*/
static dkChar const * const	wxpqdi_dk_kw[] = {
/* 0 */
dkT("/printqd/user-change/"),

/* 1 */
dkT("/printqd/host"),

/* 2 */
dkT("/printqd/port"),

/* 3 */
dkT("/printqd/queue"),

/* 4 */
dkT("/printqd/interval"),

NULL


#line 507 "DkWxPrintqdcFrame.wxc"
};



/**	8-bit characters keywords used by the module.
*/
static char const * const	wxpqdi_c8_kw[] = {
/* 0 */
"info",

/* 1 */
" ",

/* 2 */
"\n",

NULL


#line 528 "DkWxPrintqdcFrame.wxc"
};



void
DkWxPrintqdcFrame::initializeMembers(int argc, wxChar **argv)
{
  char			 c8un[WXPQDI_USER_NAME_SIZE];	/* User name. */
  char		 	 c8qn[sizeof(c8un)];		/* Queue name. */
  dkChar		 c8hn[sizeof(c8un)];		/* Host name. */
  dkChar		 pn[16+sizeof(c8un)];		/* Preference name. */
  dkChar		 pv[32];			/* Preference value. */
  wxCmdLineParser	 parser(wxpqdic_cmd_line_entries, argc, argv);
  dk3_app_t		*app;
  dkChar const		*dkptr;
  dkChar		*pvptr;				/* Start of pv. */
  char			*rq;				/* Request data. */
  size_t		 sl;				/* String length. */
  int			 ie;				/* Input encoding. */
  int			 se;				/* File encoding. */
  int			 res;				/* Conversion result. */
  int			 atcu;				/* Allowed to change. */
  int			 updi;				/* Update interval. */
  unsigned		 u;				/* Used for sscanf. */
  

#line 553 "DkWxPrintqdcFrame.wxc"
  c8un[0] = '\0';
  c8qn[0] = '\0';
  c8hn[0] = dkT('\0');
  atcu = 0;
  app = pHelper->getApp();
  if(app) {
    ie = dk3app_get_encoding(app);
    se = dk3app_get_input_stdin_encoding(app);
    /*
    	Find user name.
    */
    dkptr = dk3app_get_logname(app);
    if(dkptr) {
      if(!dk3str_to_c8_app(c8un, sizeof(c8un), dkptr, app)) {
        c8un[0] = '\0';
      }
      if((dk3str_len(wxpqdi_dk_kw[0])+dk3str_len(dkptr))<DK3_SIZEOF(pn,dkChar))
      {
        dk3str_cpy(pn, wxpqdi_dk_kw[0]);
	dk3str_cat(pn, dkptr);
	if(dk3app_get_sys_pref(app, pn, pv, DK3_SIZEOF(pv,dkChar))) {
	  pvptr = dk3str_start(pv, NULL);
	  if(pvptr) {
	    dk3str_delnl(pvptr);
	    dk3str_normalize(pvptr, NULL, dkT(' '));
	    if(dk3str_is_on(pvptr)) {
	      atcu = 1;
	    }
	  }
	}
      }
    }
    /*
    	Find host name.
    */
    if(!dk3app_get_pref(app, wxpqdi_dk_kw[1], c8hn, DK3_SIZEOF(c8hn,dkChar))) {
      c8hn[0] = dkT('\0');
    }
    /*
    	Find port number.
    */
    if(dk3app_get_pref(app, wxpqdi_dk_kw[2], pv, DK3_SIZEOF(pv,dkChar))) {
#if VERSION_BEFORE_20140716
      if(1 == dk3sf_sscanf3(pv, dkT("%u"), &u))
#else
      if(dk3ma_ui_from_string(&u, pv, NULL))
#endif
      {
        iPortnumber = (unsigned short)u;
#if VERSION_BEFORE_20140809
	if(u != (unsigned)iPortnumber)
#else
	if (u > (unsigned)(DK3_US_MAX))
#endif
	{
	  /* Overflow */
	  iPortnumber = 0;
	}
      }
    }
    /*
    	Find queue name.
    */
    if(dk3app_get_pref(app, wxpqdi_dk_kw[3], pv, DK3_SIZEOF(pv,dkChar))) {
      if(!(dk3str_to_c8_app(c8qn, sizeof(c8qn), pv, app))) {
        c8qn[0] = '\0';
      }
    }
    /*
    	Find auto update interval
    */
    if(dk3app_get_pref(app, wxpqdi_dk_kw[4], pv, DK3_SIZEOF(pv,dkChar))) {
#if VERSION_BEFORE_20140716
      if(1 == dk3sf_sscanf3(pv, dkT("%i"), &updi))
#else
      if(dk3ma_i_from_string(&updi, pv, NULL))
#endif
      {
        iUpdateInterval = updi;
      }
    }
  }
  res = -1;
  {
    wxLogNull log;
    res = parser.Parse(false);
  }
  if(0 == res) {
    long	l;
    wxString	sHost(wxT(""));
    wxString	sQueue(wxT(""));
    wxString	sUser(wxT(""));
    if(parser.Found(wxT_2("h"), &sHost)) {
      if(!(pHelper->wxToDk(c8hn, DK3_SIZEOF(c8hn,dkChar), sHost))) {
        c8hn[0] = dkT('\0');
      }
    }
    if(parser.Found(wxT_2("p"), &l)) {
      iPortnumber = (unsigned short)((unsigned long)l);
    }
    if(parser.Found(wxT_2("q"), &sQueue)) {
      pHelper->wxToC8(c8qn, sizeof(c8qn), sQueue);
    }
    if(atcu) {
      if(parser.Found(wxT_2("u"), &sUser)) {
	pHelper->wxToC8(c8un, sizeof(c8un), sUser);
      }
    }
    if(parser.Found(wxT_2("i"), &l)) {
      iUpdateInterval = (int)l;
    }
  }
  

#line 666 "DkWxPrintqdcFrame.wxc"
  

#line 667 "DkWxPrintqdcFrame.wxc"
  

#line 668 "DkWxPrintqdcFrame.wxc"
  

#line 669 "DkWxPrintqdcFrame.wxc"
  if(dk3str_len(c8hn) > 0) { 

#line 670 "DkWxPrintqdcFrame.wxc"
    pHostname = dk3str_dup_app(c8hn, app);
    if(pHostname) {	

#line 672 "DkWxPrintqdcFrame.wxc"
      if(iPortnumber > 0) {
        if(strlen(c8un) > 0) {	

#line 674 "DkWxPrintqdcFrame.wxc"
          if(strlen(c8qn) > 0) { 

#line 675 "DkWxPrintqdcFrame.wxc"
	    sl = 4 + strlen(c8un) + strlen(c8qn) + strlen(wxpqdi_c8_kw[0]);
	    rq = dk3_new_app(char,sl,app);
	    if(rq) {
	      strcpy(rq, wxpqdi_c8_kw[0]);
	      strcat(rq, wxpqdi_c8_kw[1]);
	      strcat(rq, c8qn);
	      strcat(rq, wxpqdi_c8_kw[1]);
	      strcat(rq, c8un);
	      strcat(rq, wxpqdi_c8_kw[2]);
	      pRequest = (char const *)rq;
	    } else {
	      ec = WXPQDIC_ERROR_MEMORY;
	    }
	  } else {
	    ec = WXPQDIC_ERROR_NO_QUEUE_NAME;
	  }
        } else {
          ec = WXPQDIC_ERROR_NO_USER_NAME;
        }
      } else {
        ec = WXPQDIC_ERROR_NO_PORT_NUMBER;
      }
    } else {
      ec = WXPQDIC_ERROR_NO_HOST_NAME;
    }
  } else {
    ec = WXPQDIC_ERROR_NO_HOST_NAME;
  }
  if(ec) {
    showErrorStatus(ec);
    Refresh();
    Update();
  }
  

#line 709 "DkWxPrintqdcFrame.wxc"
}



bool
DkWxPrintqdcFrame::isRunning()
{
  bool back = false;
  

#line 718 "DkWxPrintqdcFrame.wxc"
  {
    wxMutexLocker	lock(mProtectData);
    if(lock.IsOk()) {
      back = bRunning;
    }
  }

#line 724 "DkWxPrintqdcFrame.wxc"
  return back;
}



void
DkWxPrintqdcFrame::setRunning(bool v)
{
  

#line 733 "DkWxPrintqdcFrame.wxc"
  wxMutexLocker lock(mProtectData);
  if(lock.IsOk()) {
    bRunning = v;
  } 

#line 737 "DkWxPrintqdcFrame.wxc"
}



void
DkWxPrintqdcFrame::setThreadResult(wxpqdic_t *res)
{
  wxMutexLocker lock(mProtectData);
  if(lock.IsOk()) {
    thr = NULL;
    bRunning = false;
    dk3mem_cpy((void *)(&quotaData), (void *)res, sizeof(wxpqdic_t));
  }
}



void
DkWxPrintqdcFrame::setTextUnsignedLong(wxStaticText *wxst, unsigned long val)
{
  char		bu[64];
  wxChar	wbu[64];
  if(wxst) {
    sprintf(bu, "%lu", val);
    if(dk3wxs_from_plain(wbu, DK3_SIZEOF(wbu,wxChar), bu)) {
      wxst->SetLabel(wbu);
    } else {
      wxst->SetLabel(sTexts[2]);
    }
  }
}



void
DkWxPrintqdcFrame::showErrorStatus(int ec)
{
  int		i;		/* Index in sTexts */
  i = 2;
  if(lStatus) {
    switch(ec) {
      case WXPQDIC_ERROR_INIT: {
        i = 17;
      } break;
      case WXPQDIC_ERROR_NO_USER_NAME: {
        i = 18;
      } break;
      case WXPQDIC_ERROR_NO_HOST_NAME: {
        i = 19;
      } break;
      case WXPQDIC_ERROR_NO_PORT_NUMBER: {
        i = 20;
      } break;
      case WXPQDIC_ERROR_NO_QUEUE_NAME: {
        i = 21;
      } break;
      case WXPQDIC_ERROR_MEMORY: {
        i = 22;
      } break;
      case WXPQDIC_ERROR_NO_REQUEST: {
        i = 23;
      } break;
      case WXPQDIC_ERROR_CONNECT_FAILED: {
        i = 24;
      } break;
      case WXPQDIC_ERROR_SEND_FAILED: {
        i = 25;
      } break;
      case WXPQDIC_ERROR_SHUTDOWN: {
        i = 25;
      } break;
      case WXPQDIC_ERROR_NO_RESPONSE: {
        i = 26;
      } break;
      case WXPQDIC_ERROR_INVALID_RESPONSE: {
        i = 27;
      } break;
    }
    lStatus->SetLabel(sTexts[i]);
    if(WXPQDIC_ERROR_NONE == ec) {
      lStatus->SetForegroundColour(cBlack);
    } else {
      lStatus->SetForegroundColour(cRed);
    }
  }
}



void
DkWxPrintqdcFrame::showResults()
{
  wxpqdic_t	data;
  int		found;
  

#line 832 "DkWxPrintqdcFrame.wxc"
  found = 0;
  dk3mem_res((void *)(&data), sizeof(wxpqdic_t));
  {
    wxMutexLocker lock(mProtectData);
    if(lock.IsOk()) {
      dk3mem_cpy((void *)(&data), (void *)(&quotaData), sizeof(wxpqdic_t));
      found = 1;
    }
  }
  if(found) {
    /* ##### */
    if(data.ec) {
      if(tLimit) { tLimit->SetLabel(sTexts[2]); }
      if(tUsed) { tUsed->SetLabel(sTexts[2]); }
      if(tAccount) { tAccount->SetLabel(sTexts[2]); }
      if(tAllowed) {
        tAllowed->SetLabel(sTexts[2]);
	tAllowed->SetForegroundColour(cBlack);
      }
      showErrorStatus(data.ec);
    } else {
      if(2 == data.lt) {
        if(tLimit) { tLimit->SetLabel(sTexts[14]); }
      } else {
        setTextUnsignedLong(tLimit, data.li);
      }
      setTextUnsignedLong(tUsed, data.pa);
      setTextUnsignedLong(tAccount, data.ac);
      if(tAllowed) {
        tAllowed->SetLabel(sTexts[(data.su) ? 15 : 16]);
	if(data.su) {
	  tAllowed->SetForegroundColour(cGreen);
	} else {
	  tAllowed->SetForegroundColour(cRed);
	}
      }
      if(lStatus) { lStatus->SetLabel(sTexts[2]); }
    }
  } else {
    if(tLimit) { tLimit->SetLabel(sTexts[2]); }
    if(tUsed) { tUsed->SetLabel(sTexts[2]); }
    if(tAccount) { tAccount->SetLabel(sTexts[2]); }
    if(tAllowed) {
      tAllowed->SetLabel(sTexts[2]);
      tAllowed->SetForegroundColour(cBlack);
    }
    if(lStatus) { tAllowed->SetLabel(sTexts[2]); }
  }
  Refresh();
  Update();
  

#line 883 "DkWxPrintqdcFrame.wxc"
}



void
DkWxPrintqdcFrame::startThreadIfPossible()
{
  DkWxPrintqdcThread	*newThread;		/* Background thread. */
  int		 	 iStatusText = 0;	/* New status text to show. */
  wxThreadError		 runres;		/* Result from run. */
  

#line 894 "DkWxPrintqdcFrame.wxc"
  if(0 == ec) {
    wxMutexLocker lock(mProtectData);
    if(lock.IsOk()) {
      if(!(bRunning)) {
        newThread = new DkWxPrintqdcThread(
	  this,
	  pHelper->getApp(),
	  pRequest,
	  pHostname,
	  iPortnumber
	);
	if(newThread) {
	  if(wxTHREAD_NO_ERROR == newThread->Create()) {
	    newThread->SetPriority(WXTHREAD_DEFAULT_PRIORITY);
	    thr = (wxThread *)newThread;
	    bRunning = true; bLastRunning = true;
	    iStatusText = 28;
	    runres = newThread->Run();	

#line 912 "DkWxPrintqdcFrame.wxc"
	  } else {
	    iStatusText = 30;
	    delete(newThread);
	  }
	} else {
	  iStatusText = 29;
	}
      }
    }
  }
  if(iStatusText) {
    if(lStatus) {
      lStatus->SetLabel(sTexts[iStatusText]);
      switch(iStatusText) {
        case 28: {
	  lStatus->SetForegroundColour(cBlack);
	} break;
	default: {
	  lStatus->SetForegroundColour(cRed);
	} break;
      }
      Refresh();
      Update();
    }
  }
  

#line 938 "DkWxPrintqdcFrame.wxc"
}



DkWxPrintqdcFrame::~DkWxPrintqdcFrame()
{
  

#line 945 "DkWxPrintqdcFrame.wxc"
  dk3_release(pRequest);
  dk3_release(pHostname);
  

#line 948 "DkWxPrintqdcFrame.wxc"
}



void
DkWxPrintqdcFrame::OnQuit(wxCommandEvent & event)
{
  

#line 956 "DkWxPrintqdcFrame.wxc"
  timer.Stop();
  Show(false);
  Close();
  

#line 960 "DkWxPrintqdcFrame.wxc"
}



void
DkWxPrintqdcFrame::OnUpdate(wxCommandEvent & event)
{
  

#line 968 "DkWxPrintqdcFrame.wxc"
  startThreadIfPossible();
  

#line 970 "DkWxPrintqdcFrame.wxc"
}



void
DkWxPrintqdcFrame::OnTimer(wxTimerEvent & event)
{
  

#line 978 "DkWxPrintqdcFrame.wxc"
  startThreadIfPossible();
  

#line 980 "DkWxPrintqdcFrame.wxc"
}



void
DkWxPrintqdcFrame::OnHelp(wxCommandEvent & event)
{
  openHelp();
}


void
DkWxPrintqdcFrame::OnAbout(wxCommandEvent & event)
{
  wxString	sVersion(wxpqdi_version);
  sVersion.Append(wxpqdi_versnumber);
  sVersion.Append(wxpqdi_versend);
  sVersion.Append(sTexts[40]);
  sVersion.Append(wxT("Copyright (c) 2013 Dirk Krause"));
  sVersion.Append(sTexts[40]);
  sVersion.Append(sTexts[40]);
  sVersion.Append(sTexts[41]);
  sVersion.Append(wxT("DK tools, wxWidgets, libpng, libjpeg, libtiff, zlib."));
  sVersion.Append(sTexts[40]);
  sVersion.Append(sTexts[40]);
  sVersion.Append(sTexts[42]);
  sVersion.Append(wxT("http://dktools.sourceforge.net\n"));
  sVersion.Append(wxT("http://www.wxwidgets.org\n"));
  sVersion.Append(wxT("http://www.libpng.org/pub/png/libpng.html\n"));
  sVersion.Append(wxT("http://www.ijg.org\n"));
  sVersion.Append(wxT("http://www.remotesensing.org/libtiff\n"));
  sVersion.Append(wxT("http://www.zlib.org"));
  wxMessageBox(sVersion, sTexts[39]);
}



void
DkWxPrintqdcFrame::OnIdle(wxIdleEvent & event)
{
  

#line 1021 "DkWxPrintqdcFrame.wxc"
  if(isRunning()) {			

#line 1022 "DkWxPrintqdcFrame.wxc"
    bLastRunning = true;
    event.RequestMore();
  } else {				

#line 1025 "DkWxPrintqdcFrame.wxc"
    if(bLastRunning) {			

#line 1026 "DkWxPrintqdcFrame.wxc"
      showResults();
    }
    bLastRunning = false;
    if(bFirstIdle) {			

#line 1030 "DkWxPrintqdcFrame.wxc"
      bFirstIdle = false;
      startThreadIfPossible();
      if(0 == ec) {
        if(iUpdateInterval < 5) {
	  iUpdateInterval = 5;
	}
	timer.Start(1000 * iUpdateInterval, wxTIMER_CONTINUOUS);
      }
    }
  } 

#line 1040 "DkWxPrintqdcFrame.wxc"
  event.Skip();
}



bool
DkWxPrintqdcFrame::canClose(bool isLast)
{
  {
    wxMutexLocker lock(mProtectData);
    if(lock.IsOk()) {
      if(bRunning) {
        if(thr) {
	  thr->Kill();
	  bRunning = false;
	  thr = NULL;
	}
      }
    }
  }
  return(true);
}

