/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: DkWxPathFrame.wxc
*/

/*
Copyright (C) 2011, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file DkWxPathFrame.cpp The DkWxPathFrame module.
*/


#line 118 "DkWxPathFrame.wxc"

#include "dk3conf.h"
#include "dk3types.h"
#include "dk3wreg.h"
#include "dkwxpath.h"
#include "dkicon.xpm"



#line 126 "DkWxPathFrame.wxc"


BEGIN_EVENT_TABLE(DkWxPathFrame, wxFrame)
    EVT_IDLE(DkWxPathFrame::OnIdle)
END_EVENT_TABLE()



/**	Description of a context menu item.
*/
typedef struct {
  dkChar const	*menuitem;	/**< Context menu item text. */
  dkChar const	*progname;	/**< Program name. */
  dkChar const	*arguments;	/**< Program command line arguments. */
} dkwxpath_action_t;



/**	File suffix information.
*/
typedef struct {
  dkChar const	*suffix;	/**< File type suffix including the dot. */
  dkChar const	*classname;	/**< Class name if no class assigned yet. */
  dkwxpath_action_t	*items;	/**< Context menu items. */
} dkwxpath_filetype_t;



/**	Context menu items for PNG.
*/
static dkwxpath_action_t	dkwxpath_png_actions[] = {
  { NULL /* 12 */ ,  dkT("wxbmpp.exe"), dkT("-leps.image \"%1\"") },
  { NULL /* 13 */ ,  dkT("wxbmpp.exe"), dkT("-lpdf.image \"%1\"") },
  { NULL /* 14 */ , dkT("wxbmpp.exe"), dkT("-lpdf.object \"%1\"") },
  { NULL, NULL, NULL }
};

/**	Context menu items for JPEG.
*/
static dkwxpath_action_t	dkwxpath_jpeg_actions[] = {
  { NULL /* 12 */ ,  dkT("wxbmpp.exe"), dkT("-leps.image \"%1\"") },
  { NULL /* 13 */ ,  dkT("wxbmpp.exe"), dkT("-lpdf.image \"%1\"") },
  { NULL, NULL, NULL }
};

/**	Context menu items for TIFF.
*/
static dkwxpath_action_t	  dkwxpath_tiff_actions[] = {
  { NULL /* 12 */ ,    dkT("wxbmpp.exe"), dkT("-leps.image \"%1\"") },
  { NULL /* 15 */ , dkT("wxbmpp.exe"), dkT("-lpdf.document \"%1\"") },
  { NULL /* 13 */ ,    dkT("wxbmpp.exe"), dkT("-lpdf.image \"%1\"") },
  { NULL /* 14 */ ,   dkT("wxbmpp.exe"), dkT("-lpdf.object \"%1\"") },
  { NULL /* 16 */ ,  dkT("wxbmpp.exe"), dkT("-lps.document \"%1\"") },
  { NULL, NULL, NULL }
};

/**	Context menu items for PRN and PS files.
*/
static dkwxpath_action_t	dkwxpath_ps_actions[] = {
  { NULL /* 17 */ , dkT("winprint.exe"), dkT("-d \"%1\"") },
  { NULL /* 18 */ , dkT("winprint.exe"), dkT("\"%1\"") },
  { NULL, NULL, NULL }
};

/**	Context menu items for directories.
*/
static dkwxpath_action_t	dkwxpath_directory_actions[] = {
  { NULL /* 19 */ , dkT("wxbmpp.exe"), dkT("\"%1\"") },
  { NULL /* 20 */ ,  dkT("wxdkct.exe"), dkT("\"%1\"") },
  { NULL, NULL, NULL }
};


/**	File types to set up.
*/
static dkwxpath_filetype_t	   dkwxpath_filetypes[] = {
  { dkT(".png"),  dkT("pngfile"),  dkwxpath_png_actions },
  { dkT(".jpg"),  dkT("jpegfile"), dkwxpath_jpeg_actions},
  { dkT(".jpeg"), dkT("jpegfile"), dkwxpath_jpeg_actions},
  { dkT(".tif"),  dkT("tifffile"), dkwxpath_tiff_actions},
  { dkT(".tiff"), dkT("tifffile"), dkwxpath_tiff_actions},
  { dkT(".prn"),  dkT("prnfile"),  dkwxpath_ps_actions},
  { dkT(".ps"),   dkT("psfile"),   dkwxpath_ps_actions},
  { NULL, NULL, NULL }
};



dkChar const * const	dkwxpath_noloc[] = {
/* 0 */
dkT("\\shell"),

/* 1 */
dkT("\\command"),

/* 2 */
dkT("\""),

/* 3 */
dkT(" "),

/* 4 */
dkT("\\"),

/* 5 */
dkT("Directory"),

NULL


#line 241 "DkWxPathFrame.wxc"
};

#if DK3_ON_WINDOWS && ((DK3_CHAR_SIZE == 1) || (DK3_CHAR_SIZE == 2))

/**	Registry key in HKLM containing system environment variables.
*/
static dkChar const dkwxpath_registry_key[] = {
dkT("SYSTEM\\CurrentControlSet\\Control\\Session Manager\\Environment")
};

/**	Registry value name.
*/
static dkChar const dkwxpath_registry_name[] = {
dkT("Path")
};


/**	Separator of PATH components.
*/
static dkChar const dkwxpath_sep[] = {
dkT(";")
};

#endif
/* if DK3_ON_WINDOWS */


#if DK3_ON_WINDOWS && ((DK3_CHAR_SIZE == 1) || (DK3_CHAR_SIZE == 2))
/**	Check whether or not a directory is already contained in the PATH.
	@param	bu	Current PATH value.
	@param	dn	Directory name to check for.
	@return	1 on success (@a dn already contained), 0 otherwise.
*/
static
int
dk3_win_check_path(dkChar *bu, dkChar const *dn)
{
  dkChar	*pc;
  dkChar	*pn;
  int		 back = 0;
  

#line 282 "DkWxPathFrame.wxc"
  pc = bu;
  while((pc) && (0 == back)) {
    pn = dk3str_chr(pc, dkT(';'));
    if(pn) { *(pn++) = dkT('\0'); }
    if(0 == dk3str_fncmp(pc, dn)) {
      back = 1;
    }
    pc = pn;
  } 

#line 291 "DkWxPathFrame.wxc"
  return back;
}
#endif
/* if DK3_ON_WINDOWS */



/**	Register context menu entries.
	@param	dn	Installation directory name, bin subdirectory.
	@param	cl	Class name.
	@param	act	Actions list.
	@param	app	Application structure for diagnostics, may be NULL.
*/
static
void
dkwxpath_register_context_entries(
  dkChar const *dn, dkChar const *cl, dkwxpath_action_t *act, dk3_app_t *app
)
{
  dkChar		 kn1[DK3_MAX_PATH];
  dkChar		 kn2[DK3_SIZEOF(kn1,dkChar)];
  dkwxpath_action_t	*acp;
  size_t		 szk;
  size_t		 szv;
  HKEY			 hk;
  

#line 317 "DkWxPathFrame.wxc"
  acp = act;
  while((acp->menuitem) && (acp->progname) && (acp->arguments)) {
    szk = 2 + dk3str_len(cl) + dk3str_len(dkwxpath_noloc[0])
    	+ dk3str_len(acp->menuitem) + dk3str_len(dkwxpath_noloc[1]);
    szv = 5 + dk3str_len(dn) + dk3str_len(acp->progname)
    	+ dk3str_len(acp->arguments);
    if((szk < DK3_MAX_PATH) && (szv < DK3_MAX_PATH)) {
      dk3str_cpy(kn1, cl);			

#line 325 "DkWxPathFrame.wxc"
      if(dk3wreg_key_create_read(HKEY_CLASSES_ROOT, kn1, &hk, app)) {
        dk3wreg_key_close(hk, kn1, app);
	dk3str_cpy(kn1, cl);
	dk3str_cat(kn1, dkwxpath_noloc[0]);	

#line 329 "DkWxPathFrame.wxc"
	if(dk3wreg_key_create_read(HKEY_CLASSES_ROOT, kn1, &hk, app)) {
	  dk3wreg_key_close(hk, kn1, app);
	  dk3str_cpy(kn1, cl);
	  dk3str_cat(kn1, dkwxpath_noloc[0]);
	  dk3str_cat(kn1, dkwxpath_noloc[4]);
	  dk3str_cat(kn1, acp->menuitem);	

#line 335 "DkWxPathFrame.wxc"
	  if(dk3wreg_key_create_read(HKEY_CLASSES_ROOT, kn1, &hk, app)) {
	    dk3wreg_key_close(hk, kn1, app);
	    dk3str_cpy(kn1, cl);
	    dk3str_cat(kn1, dkwxpath_noloc[0]);
	    dk3str_cat(kn1, dkwxpath_noloc[4]);
	    dk3str_cat(kn1, acp->menuitem);
	    dk3str_cat(kn1, dkwxpath_noloc[1]);	

#line 342 "DkWxPathFrame.wxc"
	    dk3str_cpy(kn2, dkwxpath_noloc[2]);
	    dk3str_cat(kn2, dn);
	    dk3str_cat(kn2, dkwxpath_noloc[4]);
	    dk3str_cat(kn2, acp->progname);
	    dk3str_cat(kn2, dkwxpath_noloc[2]);
	    dk3str_cat(kn2, dkwxpath_noloc[3]);
	    dk3str_cat(kn2, acp->arguments);	

#line 349 "DkWxPathFrame.wxc"
	    if(dk3wreg_key_create_modify(HKEY_CLASSES_ROOT, kn1, &hk, app)) {
	      (void)dk3wreg_set_sz(hk, NULL, kn2, app);	

#line 351 "DkWxPathFrame.wxc"
	      dk3wreg_key_close(hk, kn1, app);
	    }
	  }
	}
      }
    }
    acp++;
  }
  

#line 360 "DkWxPathFrame.wxc"
}



/**	Remove context menu items.
	@param	dn	Base directory name.
	@param	cl	Class name.
	@param	act	Actions to delete.
	@param	app	Application structure for diagnostics, may be NULL.
*/
static
void
dkwxpath_unregister_context_entries(
  dkChar const *dn, dkChar const *cl, dkwxpath_action_t *act, dk3_app_t *app
)
{
  dkChar		 kn1[DK3_MAX_PATH];
  dkwxpath_action_t	*acp;
  size_t		 szk;
  

#line 380 "DkWxPathFrame.wxc"
  acp = act;
  while((acp->menuitem) && (acp->progname) && (acp->arguments)) {
    szk = 2 + dk3str_len(cl) + dk3str_len(dkwxpath_noloc[0])
    	+ dk3str_len(acp->menuitem);
    if(szk < DK3_MAX_PATH) {
      dk3str_cpy(kn1, cl);
      dk3str_cat(kn1, dkwxpath_noloc[0]);
      dk3str_cat(kn1, dkwxpath_noloc[4]);
      dk3str_cat(kn1, acp->menuitem);	

#line 389 "DkWxPathFrame.wxc"
      (void)dk3wreg_key_delete(HKEY_CLASSES_ROOT, kn1, app);
    }
    acp++;
  }
  

#line 394 "DkWxPathFrame.wxc"
}



/**	Register context menus.
	@param	dn	Directory name (bin subdirectory).
	@param	app	Application structure for diagnostics, may be NULL.
*/
static
void
dkwxpath_register_context_menus(dkChar const *dn, dk3_app_t *app)
{
  dkChar			 cln[DK3_MAX_PATH];
  dkwxpath_filetype_t		*ftp;
  int				 hcl;
  HKEY				 hk;
  

#line 411 "DkWxPathFrame.wxc"
  ftp = dkwxpath_filetypes;
  while((ftp->suffix) && (ftp->classname) && (ftp->items)) {
    

#line 414 "DkWxPathFrame.wxc"
    

#line 415 "DkWxPathFrame.wxc"
    cln[0] = dkT('\0');
    hcl    = 0;
    if(dk3wreg_key_create_modify(HKEY_CLASSES_ROOT, ftp->suffix, &hk, app)) {
      if(dk3wreg_get_sz(hk, NULL, cln, DK3_SIZEOF(cln,dkChar), app)) {
        if(0 < dk3str_len(cln)) {
	  hcl = 1;
	}
      }
      if(0 == hcl) {
        dk3wreg_set_sz(hk, NULL, ftp->classname, app);
      }
      dk3wreg_key_close(hk, ftp->suffix, app);
      if(hcl) {
        dkwxpath_register_context_entries(dn, cln, ftp->items, app);
      } else {
        dkwxpath_register_context_entries(dn, ftp->classname, ftp->items, app);
      }
    }
    ftp++;
  }
  dkwxpath_register_context_entries(
    dn, dkwxpath_noloc[5], dkwxpath_directory_actions, app
  );
  

#line 439 "DkWxPathFrame.wxc"
}



static
void
dkwxpath_unregister_context_menus(dkChar const *dn, dk3_app_t *app)
{
  dkChar			 cln[DK3_MAX_PATH];
  dkwxpath_filetype_t		*ftp;
  int				 hcl;
  HKEY				 hk;
  

#line 452 "DkWxPathFrame.wxc"
  ftp = dkwxpath_filetypes;
  while((ftp->suffix) && (ftp->classname) && (ftp->items)) {
    

#line 455 "DkWxPathFrame.wxc"
    

#line 456 "DkWxPathFrame.wxc"
    cln[0] = dkT('\0');
    hcl    = 0;
    if(dk3wreg_key_create_modify(HKEY_CLASSES_ROOT, ftp->suffix, &hk, app)) {
      if(dk3wreg_get_sz(hk, NULL, cln, DK3_SIZEOF(cln,dkChar), app)) {
        if(0 < dk3str_len(cln)) {
	  hcl = 1;
	}
      }
      dk3wreg_key_close(hk, ftp->suffix, app);
      if(hcl) {
        dkwxpath_unregister_context_entries(dn, cln, ftp->items, app);
      }
    }
    ftp++;
  }
  dkwxpath_unregister_context_entries(
    dn, dkwxpath_noloc[5], dkwxpath_directory_actions, app
  );
  

#line 475 "DkWxPathFrame.wxc"
}



/**	Ensure dn is listed in the PATH environment variable.
	@param	dn	New component to include in PATH.
	@return	0 on failure, 1 on success (added),
	2 on success (dn already in PATH).
*/
static
int
dkwxpath_set_regentry(dkChar const *dn, dk3_app_t *app)
{
  int		 back = 0;
#if DK3_ON_WINDOWS && ((DK3_CHAR_SIZE == 1) || (DK3_CHAR_SIZE == 2))
  dkChar	 b1[16 * DK3_MAX_PATH];
  dkChar	 b2[16 * DK3_MAX_PATH];
  DWORD		 dwType;
  DWORD		 dwSz;
  LONG		 res;
  size_t	 sl;
  REGSAM	 regsam;
  HKEY		 regkey;
  

#line 499 "DkWxPathFrame.wxc"
  regsam = KEY_ALL_ACCESS;
#if DK3_CHAR_SIZE == 2
  res = RegOpenKeyExW(
    HKEY_LOCAL_MACHINE, dkwxpath_registry_key, (DWORD)0UL, regsam, &regkey
  );
#else
  res = RegOpenKeyExA(
    HKEY_LOCAL_MACHINE, dkwxpath_registry_key, (DWORD)0UL, regsam, &regkey
  );
#endif
  if(ERROR_SUCCESS == res) {			

#line 510 "DkWxPathFrame.wxc"
    dwType = REG_EXPAND_SZ;
    dwSz   = (DWORD)sizeof(b1);
#if DK3_CHAR_SIZE == 2
    res = RegQueryValueExW(
      regkey, dkwxpath_registry_name, NULL, &dwType,
      (LPBYTE)b1, &dwSz
    );
#else
    res = RegQueryValueExA(
      regkey, dkwxpath_registry_name, NULL, &dwType,
      (LPBYTE)b1, &dwSz
    );
#endif
    if(ERROR_SUCCESS == res) {			

#line 524 "DkWxPathFrame.wxc"
      res = 1L;
#if DK3_CHAR_SIZE == 2
      if(dwSz % (DWORD)2L) {			

#line 527 "DkWxPathFrame.wxc"
        res = 0L;
      } else {					

#line 529 "DkWxPathFrame.wxc"
        dwSz = dwSz / (DWORD)2L;
      }
#endif
      if(dwType != REG_SZ) {
        if(dwType != REG_EXPAND_SZ) {		

#line 534 "DkWxPathFrame.wxc"
	  res = 0L;
	}
      }
      if(1L == res) {				

#line 538 "DkWxPathFrame.wxc"
        if((DWORD)0L < dwSz) {			

#line 539 "DkWxPathFrame.wxc"
	  if(dwSz < DK3_SIZEOF(b1,dkChar)) {	

#line 540 "DkWxPathFrame.wxc"
	    b1[dwSz] = dkT('\0');
	    dk3str_cpy(b2, b1);
	    if(dk3_win_check_path(b2, dn)) {
	      back = 2;
	    } else {
	      sl =  dk3str_len(b1);
	      sl += dk3str_len(dn);
	      sl += 1;
	      if(sl < DK3_SIZEOF(b2,dkChar)) {
	        dk3str_cpy(b2, dn);
		dk3str_cat(b2, dkwxpath_sep);
		dk3str_cat(b2, b1);
#if DK3_CHAR_SIZE == 2
		res = RegSetValueExW(
		  regkey, dkwxpath_registry_name, (DWORD)0L, dwType,
		  (BYTE const *)b2,
		  (DWORD)(2 * (1 + dk3str_len(b2)))
		);
#else
		res = RegSetValueExA(
		  regkey, dkwxpath_registry_name, (DWORD)0L, dwType,
		  (BYTE const *)b2,
		  (DWORD)(1 + dk3str_len(b2))
		);
#endif
		if(ERROR_SUCCESS == res) {
		  back = 1;
		}
	      } else {				

#line 569 "DkWxPathFrame.wxc"
	      }
	    }
	  } else {				

#line 572 "DkWxPathFrame.wxc"
	  }
	} else {				

#line 574 "DkWxPathFrame.wxc"
	}
      }
    } else {					

#line 577 "DkWxPathFrame.wxc"
    }
    RegCloseKey(regkey);
  } else {					

#line 580 "DkWxPathFrame.wxc"
  }
  dkwxpath_register_context_menus(dn, app);
#else
  /* Simulate results to test dialogs. */
#endif
/* if DK3_ON_WINDOWS ... */
  

#line 587 "DkWxPathFrame.wxc"
  return back;
}



#if DK3_ON_WINDOWS && ((DK3_CHAR_SIZE == 2) || (DK3_CHAR_SIZE == 1))
static
void
dkwxpath_remove(dkChar *dp, dkChar *sp, dkChar const *dn)
{
  dkChar 	*pc;
  dkChar 	*pn;
  bool		 isfirst = true;

  *dp = dkT('\0');
  pc = sp;
  while(pc) {
    pn = dk3str_chr(pc, dkT(';'));
    if(pn) { *(pn++) = dkT('\0'); }
    if(dk3str_fncmp(pc, dn)) {
      if(isfirst) {
        isfirst = false;
	dk3str_cpy(dp, pc);
      } else {
        dk3str_cat(dp, dkwxpath_sep);
	dk3str_cat(dp, pc);
      }
    }
    pc = pn;
  }
}
#endif
/* if DK3_ON_WINDOWS && ... */


/**	Ensure dn is not listed in the PATH environment variable.
	@param	dn	Component to exclude from PATH.
	@return	0 on failure, 1 on success (removed),
	2 on success (dn not contained).
*/
static
int
dkwxpath_unset_regentry(dkChar const *dn, dk3_app_t *app)
{
  int		 back = 0;
  

#line 633 "DkWxPathFrame.wxc"
#if DK3_ON_WINDOWS && ((DK3_CHAR_SIZE == 1) || (DK3_CHAR_SIZE == 2))
  dkChar	 b1[16 * DK3_MAX_PATH];
  dkChar	 b2[16 * DK3_MAX_PATH];
  DWORD		 dwType;
  DWORD		 dwSz;
  LONG		 res;
  REGSAM	 regsam;
  HKEY		 regkey;

  regsam = KEY_ALL_ACCESS;
#if DK3_CHAR_SIZE == 2
  res = RegOpenKeyExW(
    HKEY_LOCAL_MACHINE, dkwxpath_registry_key, (DWORD)0UL, regsam, &regkey
  );
#else
  res = RegOpenKeyExA(
    HKEY_LOCAL_MACHINE, dkwxpath_registry_key, (DWORD)0UL, regsam, &regkey
  );
#endif
  if(ERROR_SUCCESS == res) {		

#line 653 "DkWxPathFrame.wxc"
    dwType = REG_EXPAND_SZ;
    dwSz = (DWORD)sizeof(b1);
#if DK3_CHAR_SIZE == 2
    res = RegQueryValueExW(
      regkey, dkwxpath_registry_name, NULL, &dwType,
      (LPBYTE)b1, &dwSz
    );
#else
    res = RegQueryValueExA(
      regkey, dkwxpath_registry_name, NULL, &dwType,
      (LPBYTE)b1, &dwSz
    );
#endif
    if(ERROR_SUCCESS == res) {		

#line 667 "DkWxPathFrame.wxc"
      res = 1L;
#if DK3_CHAR_SIZE == 2
      if(dwSz % (DWORD)2L) {
        res = 0L;
      } else {
        dwSz = dwSz / (DWORD)2L;
      }
#endif
      if(dwType != REG_SZ) {
        if(dwType != REG_EXPAND_SZ) {
	  res = 0L;
	}
      }
      if(1L == res) {			

#line 681 "DkWxPathFrame.wxc"
        if((DWORD)0L < dwSz) {		

#line 682 "DkWxPathFrame.wxc"
	  if(dwSz < DK3_SIZEOF(b1,dkChar)) {
	    b1[dwSz] = dkT('\0');
	    dkwxpath_remove(b2, b1, dn);
#if DK3_CHAR_SIZE == 2
	    res = RegSetValueExW(
	      regkey, dkwxpath_registry_name, (DWORD)0L, dwType,
	      (BYTE const *)b2,
	      (DWORD)(2 * (1 + dk3str_len(b2)))
	    );
#else
	    res = RegSetValueExA(
	      regkey, dkwxpath_registry_name, (DWORD)0L, dwType,
	      (BYTE const *)b2,
	      (DWORD)(1 + dk3str_len(b2))
	    );
#endif
	    if(ERROR_SUCCESS == res) {	

#line 699 "DkWxPathFrame.wxc"
	      back = 1;
	    } else {			

#line 701 "DkWxPathFrame.wxc"
	    }
	  }
	} else {			

#line 704 "DkWxPathFrame.wxc"
	}
      } else {				

#line 706 "DkWxPathFrame.wxc"
      }
    } else {				

#line 708 "DkWxPathFrame.wxc"
    }
    RegCloseKey(regkey);
  } else {				

#line 711 "DkWxPathFrame.wxc"
  }
  dkwxpath_unregister_context_menus(dn, app);
#endif
  

#line 715 "DkWxPathFrame.wxc"
  return back;
}




#line 721 "DkWxPathFrame.wxc"
DkWxPathFrame::DkWxPathFrame(
  wxChar const		 *applicationName,
  wxChar const * const	 *localizedTexts,
  dkChar const * const	 *dkLocalizedTexts,
  DkWxAppHelper		 *applicationHelper,
  int			  idMain,
  int			  argc,
  wxChar		**argv
) : DkWxFrame(applicationName, applicationHelper, NULL, idMain),
    mProtectData(wxMUTEX_DEFAULT)
{
#if defined(__WXMSW__)
  wxIcon		dkicon_bitmap(wxT("aaaaa"));
#else
  wxIcon		dkicon_bitmap(dkicon_xpm);
#endif
  sTexts = localizedTexts;
  dkTexts = dkLocalizedTexts;
  bRunning = false;
  bUninstall = false;
  dkctGUILayoutOK = false;
  dkctGUIContentsPanel = NULL;
  mainSizer = NULL;
  horizontalSizer = NULL;
  lModifying = NULL;
  dkctGUIContentsPanel = new wxPanel(this);
  if(!(dkctGUIContentsPanel)) {
    goto dkctGUILayoutFinished;
  }
  mainSizer = new wxBoxSizer(
    wxVERTICAL
  );
  if(!(mainSizer)) {
    goto dkctGUILayoutFinished;
  }
  mainSizer->Add(10, 10, 0);
  horizontalSizer = new wxBoxSizer(
    wxHORIZONTAL
  );
  if(!(horizontalSizer)) {
    goto dkctGUILayoutFinished;
  }
  horizontalSizer->Add(10, 10, 0);
  lModifying = new wxStaticText(
    dkctGUIContentsPanel,
    wxID_ANY,
    sTexts[3]
  );
  if(!(lModifying)) {
    goto dkctGUILayoutFinished;
  }
  horizontalSizer->Add(
    lModifying
  );
  horizontalSizer->Add(10, 10, 0);
  mainSizer->Add(
    horizontalSizer
  );
  mainSizer->Add(10, 10, 0);
  dkctGUIContentsPanel->SetSizer(mainSizer);
  SetIcon(dkicon_bitmap);
  dkctGUILayoutOK = true;
  dkctGUILayoutFinished:
  if(dkctGUILayoutOK) {
    mainSizer->Fit(this);
    mainSizer->SetSizeHints(this);
  }

#line 742 "DkWxPathFrame.wxc"
  restorePosition();
  processArguments(argc, argv);
  /*	Set context menu item texts
  */
  dkwxpath_png_actions[0].menuitem = dkLocalizedTexts[12];
  dkwxpath_png_actions[1].menuitem = dkLocalizedTexts[13];
  dkwxpath_png_actions[2].menuitem = dkLocalizedTexts[14];
  dkwxpath_jpeg_actions[0].menuitem = dkLocalizedTexts[12];
  dkwxpath_jpeg_actions[1].menuitem = dkLocalizedTexts[13];
  dkwxpath_tiff_actions[0].menuitem = dkLocalizedTexts[12];
  dkwxpath_tiff_actions[1].menuitem = dkLocalizedTexts[15];
  dkwxpath_tiff_actions[2].menuitem = dkLocalizedTexts[13];
  dkwxpath_tiff_actions[3].menuitem = dkLocalizedTexts[14];
  dkwxpath_tiff_actions[4].menuitem = dkLocalizedTexts[16];
  dkwxpath_ps_actions[0].menuitem = dkLocalizedTexts[17];
  dkwxpath_ps_actions[1].menuitem = dkLocalizedTexts[18];
  dkwxpath_directory_actions[0].menuitem = dkLocalizedTexts[19];
  dkwxpath_directory_actions[1].menuitem = dkLocalizedTexts[20];
}


#line 763 "DkWxPathFrame.wxc"



bool
DkWxPathFrame::mustStart()
{
  bool	 back = false;
  {
    wxMutexLocker lock(mProtectData);
    if(lock.IsOk()) {
      if(!bRunning) {
        back = true;
	bRunning = true;
      }
    }
  }
  return back;
}



void DkWxPathFrame::OnIdle(wxIdleEvent & event)
{
  wxChar	 bindir[DK3_MAX_PATH];
  dk3_app_t	*app;
  dkChar const	*dkbindir;
  bool		 doRun;
  bool		 haveBinDir;
  int		 res;

  haveBinDir = false;
  app = NULL;
  dkbindir = NULL;
  doRun = mustStart();
  /*
  	Modify PATH variable.
  */
  if(doRun) {
    res = 1;
#if DK3_ON_WINDOWS && ((DK3_CHAR_SIZE == 1) || (DK3_CHAR_SIZE == 2))
    res = 0;
    app = pHelper->getApp();
    if(app) {
      dkbindir = dk3app_get_bindir(app);
      if(dkbindir) {
        if(bUninstall) {
	  res = dkwxpath_unset_regentry(dkbindir, app);
        } else {
          res = dkwxpath_set_regentry(dkbindir, app);
        }
	Sleep(250);
      }
    }
#endif
    if(0 == res) {
      app = pHelper->getApp();
      if(app) {
        dkbindir = dk3app_get_bindir(app);
	if(dkbindir) {
	  haveBinDir = pHelper->dkToWx(
	    bindir, DK3_SIZEOF(bindir,wxChar), dkbindir
	  );
	}
      }
      wxString	msg(wxT(""));
      msg.Append(sTexts[6]);
      msg.Append(wxT("\n"));
      if(bUninstall) {
        msg.Append(sTexts[9]);
	msg.Append(wxT("\n"));
	if(haveBinDir) {
	  msg.Append(wxT("\n"));
	  msg.Append(bindir);
	  msg.Append(wxT("\n"));
	  msg.Append(wxT("\n"));
	}
	msg.Append(sTexts[10]);
      } else {
        msg.Append(sTexts[7]);
	msg.Append(wxT("\n"));
	if(haveBinDir) {
	  msg.Append(wxT("\n"));
	  msg.Append(bindir);
	  msg.Append(wxT("\n"));
	  msg.Append(wxT("\n"));
	}
	msg.Append(sTexts[8]);
      }
      msg.Append(wxT("\n"));
      msg.Append(sTexts[11]);
      wxMessageBox(msg, sTexts[5], (wxOK | wxICON_ERROR), this);
    }
  }
  /*
  	Skip further event processing.
  */
  event.Skip();
  /*
  	Close window.
  */
  if(doRun) {
    Show(false);
    Close();
  }
}


bool
DkWxPathFrame::canClose(bool isLast)
{
  if(isLast) {
    savePosition();
  }
  return true;
}




static const wxCmdLineEntryDesc dkwxpath_cmd_line_desc[] = {
  {
    wxCMD_LINE_SWITCH,
    wxT_2("u"),
    wxT_2("uninstall"),
    wxT_2("Uninstall DK tools and libraries")
  },
  { wxCMD_LINE_NONE }
};



void
DkWxPathFrame::processArguments(int argc, wxChar **argv)
{
  wxLogNull	log;
  int		res;
  

#line 900 "DkWxPathFrame.wxc"
  wxCmdLineParser parser(dkwxpath_cmd_line_desc, argc, argv);
  res = parser.Parse(false);
  if(0 == res) {			

#line 903 "DkWxPathFrame.wxc"
    if(parser.Found(wxT("u"))) {	

#line 904 "DkWxPathFrame.wxc"
      bUninstall = true;
    }
  } 

#line 907 "DkWxPathFrame.wxc"
}


