/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: DkWxImgszFrame.wxc
*/

/*
Copyright (C) 2012, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file DkWxImgszFrame.cpp The DkWxImgszFrame module.
*/


#line 374 "DkWxImgszFrame.wxc"

#include "wximgsz.h"
#include "dkicon.xpm"

#include "run2.xpm"



#line 381 "DkWxImgszFrame.wxc"



/**	Event table for the DkWxImgszFrame class.
*/
BEGIN_EVENT_TABLE(DkWxImgszFrame, wxFrame)
    EVT_MENU(DkWxImgsz_Quit,  DkWxImgszFrame::OnQuit)
    EVT_MENU(DkWxImgsz_Help, DkWxImgszFrame::OnHelp)
    EVT_MENU(DkWxImgsz_About, DkWxImgszFrame::OnAbout)
    EVT_MENU(DkWxImgsz_Options,	DkWxImgszFrame::OnOptions)
    EVT_MENU(DkWxImgsz_Open, DkWxImgszFrame::OnOpen)
    EVT_BUTTON(DkWxImgsz_Run, DkWxImgszFrame::OnRun)
    EVT_CHOICE(DkWxImgsz_Choice, DkWxImgszFrame::OnChoice)
END_EVENT_TABLE()




#line 399 "DkWxImgszFrame.wxc"

DkWxImgszFrame::DkWxImgszFrame(
  wxChar const		 *applicationName,
  wxChar const * const	 *localizedMessages,
  DkWxAppHelper		 *applicationHelper,
  DkWxHelpController	 *helpController,
  int			  wxid,
  int			  argc,
  wxChar		**argv
) : DkWxFrame(applicationName, applicationHelper, helpController, wxid),
    cRed(255, 91, 91),
    cNotSoDarkRed(127, 0, 0),
    cGreen(127, 255, 127),
    cBlack(0, 0, 0),
    cDarkRed(63, 0, 0),
    cYellow(255, 255, 0),
    sCurrentDir(wxT(""))
{
  /*
  	Icon for main window.
  */
#if defined(__WXMSW__)
  wxIcon		dkicon_bitmap(wxT("aaaaa"));
#else
  wxIcon		dkicon_bitmap(xpm_dkicon);
#endif
  wxIcon		run2_bitmap(xpm_run2);
  fdx = -1; fdy = -1;
  odx = -1; ody = -1;
  sTexts = localizedMessages;
  wxString saAction[] = {
    wxString(localizedMessages[12]),
    wxString(localizedMessages[13]),
    wxString(localizedMessages[14])
  };
  bUseColour = true;
  dkctGUILayoutOK = false;
  dkctGUIContentsPanel = NULL;
  mbMain = NULL;
  mainSizer = NULL;
  mFile = NULL;
  mExtras = NULL;
  mHelp = NULL;
  miOpen = NULL;
  miExit = NULL;
  miOptions = NULL;
  miHelpContents = NULL;
  miHelpAbout = NULL;
  horizontalSizer = NULL;
  statusSizer = NULL;
  inputDataSizer = NULL;
  bCalculate = NULL;
  outputDataSizer = NULL;
  lOriginalImage = NULL;
  lWidth = NULL;
  tWidth = NULL;
  lHeight = NULL;
  tHeight = NULL;
  lChangeType = NULL;
  lAction = NULL;
  cbAction = NULL;
  lMinimum = NULL;
  tMinimum = NULL;
  lMaximum = NULL;
  tMaximum = NULL;
  lResults = NULL;
  dataGrid = NULL;
  lStatus = NULL;
  dkctGUIContentsPanel = new wxPanel(this);
  if(!(dkctGUIContentsPanel)) {
    goto dkctGUILayoutFinished;
  }
#if wxUSE_MENUS
  mbMain = new wxMenuBar(
  );
  if(!(mbMain)) {
    goto dkctGUILayoutFinished;
  }
  mFile = new wxMenu(
  );
  if(!(mFile)) {
    goto dkctGUILayoutFinished;
  }
  miOpen = mFile->Append(
    DkWxImgsz_Open,
    sTexts[49],
    sTexts[50]
  );
  if(!(miOpen)) {
    goto dkctGUILayoutFinished;
  }
  miExit = mFile->Append(
    DkWxImgsz_Quit,
    sTexts[2],
    sTexts[19]
  );
  if(!(miExit)) {
    goto dkctGUILayoutFinished;
  }
  mbMain->Append(mFile, sTexts[1]);
  mExtras = new wxMenu(
  );
  if(!(mExtras)) {
    goto dkctGUILayoutFinished;
  }
  miOptions = mExtras->Append(
    DkWxImgsz_Options,
    sTexts[39],
    sTexts[40]
  );
  if(!(miOptions)) {
    goto dkctGUILayoutFinished;
  }
  mbMain->Append(mExtras, sTexts[38]);
  mHelp = new wxMenu(
  );
  if(!(mHelp)) {
    goto dkctGUILayoutFinished;
  }
  miHelpContents = mHelp->Append(
    DkWxImgsz_Help,
    sTexts[28],
    sTexts[30]
  );
  if(!(miHelpContents)) {
    goto dkctGUILayoutFinished;
  }
  miHelpAbout = mHelp->Append(
    DkWxImgsz_About,
    sTexts[29],
    sTexts[31]
  );
  if(!(miHelpAbout)) {
    goto dkctGUILayoutFinished;
  }
  mbMain->Append(mHelp, sTexts[27]);
  SetMenuBar(mbMain);
#endif
  mainSizer = new wxBoxSizer(
    wxVERTICAL
  );
  if(!(mainSizer)) {
    goto dkctGUILayoutFinished;
  }
  mainSizer->Add(10, 10, 0);
  horizontalSizer = new wxBoxSizer(
    wxHORIZONTAL
  );
  if(!(horizontalSizer)) {
    goto dkctGUILayoutFinished;
  }
  horizontalSizer->Add(10, 10, 0);
  inputDataSizer = new wxGridBagSizer(
    5, 5
  );
  if(!(inputDataSizer)) {
    goto dkctGUILayoutFinished;
  }
  lOriginalImage = new wxStaticText(
    dkctGUIContentsPanel,
    wxID_ANY,
    sTexts[6]
  );
  if(!(lOriginalImage)) {
    goto dkctGUILayoutFinished;
  }
  inputDataSizer->Add(
    lOriginalImage,
    wxGBPosition(0, 0),
    wxGBSpan(1, 2),
    wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL
  );
  lWidth = new wxStaticText(
    dkctGUIContentsPanel,
    wxID_ANY,
    sTexts[8]
  );
  if(!(lWidth)) {
    goto dkctGUILayoutFinished;
  }
  inputDataSizer->Add(
    lWidth,
    wxGBPosition(1, 0),
    wxGBSpan(1, 1),
    wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL
  );
  tWidth = new wxTextCtrl(
    dkctGUIContentsPanel,
    wxID_ANY,
    sTexts[26]
  );
  if(!(tWidth)) {
    goto dkctGUILayoutFinished;
  }
  tWidth->SetToolTip(sTexts[20]);
  inputDataSizer->Add(
    tWidth,
    wxGBPosition(1, 1),
    wxGBSpan(1, 1),
    wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL
  );
  lHeight = new wxStaticText(
    dkctGUIContentsPanel,
    wxID_ANY,
    sTexts[9]
  );
  if(!(lHeight)) {
    goto dkctGUILayoutFinished;
  }
  inputDataSizer->Add(
    lHeight,
    wxGBPosition(2, 0),
    wxGBSpan(1, 1),
    wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL
  );
  tHeight = new wxTextCtrl(
    dkctGUIContentsPanel,
    wxID_ANY,
    sTexts[26]
  );
  if(!(tHeight)) {
    goto dkctGUILayoutFinished;
  }
  tHeight->SetToolTip(sTexts[21]);
  inputDataSizer->Add(
    tHeight,
    wxGBPosition(2, 1),
    wxGBSpan(1, 1),
    wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL
  );
  inputDataSizer->Add(10, 10, wxGBPosition(3, 0), wxGBSpan(1, 1));
  lChangeType = new wxStaticText(
    dkctGUIContentsPanel,
    wxID_ANY,
    sTexts[10]
  );
  if(!(lChangeType)) {
    goto dkctGUILayoutFinished;
  }
  inputDataSizer->Add(
    lChangeType,
    wxGBPosition(4, 0),
    wxGBSpan(1, 2),
    wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL
  );
  lAction = new wxStaticText(
    dkctGUIContentsPanel,
    wxID_ANY,
    sTexts[11]
  );
  if(!(lAction)) {
    goto dkctGUILayoutFinished;
  }
  inputDataSizer->Add(
    lAction,
    wxGBPosition(5, 0),
    wxGBSpan(1, 1),
    wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL
  );
  cbAction = new wxChoice(
    dkctGUIContentsPanel,
    DkWxImgsz_Choice,
    wxDefaultPosition,
    wxDefaultSize,
    3,
    saAction
  );
  if(!(cbAction)) {
    goto dkctGUILayoutFinished;
  }
  cbAction->SetToolTip(sTexts[22]);
  inputDataSizer->Add(
    cbAction,
    wxGBPosition(5, 1),
    wxGBSpan(1, 1),
    wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL
  );
  lMinimum = new wxStaticText(
    dkctGUIContentsPanel,
    wxID_ANY,
    sTexts[15]
  );
  if(!(lMinimum)) {
    goto dkctGUILayoutFinished;
  }
  inputDataSizer->Add(
    lMinimum,
    wxGBPosition(6, 0),
    wxGBSpan(1, 1),
    wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL
  );
  tMinimum = new wxTextCtrl(
    dkctGUIContentsPanel,
    wxID_ANY,
    sTexts[26]
  );
  if(!(tMinimum)) {
    goto dkctGUILayoutFinished;
  }
  tMinimum->SetToolTip(sTexts[23]);
  inputDataSizer->Add(
    tMinimum,
    wxGBPosition(6, 1),
    wxGBSpan(1, 1),
    wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL
  );
  lMaximum = new wxStaticText(
    dkctGUIContentsPanel,
    wxID_ANY,
    sTexts[16]
  );
  if(!(lMaximum)) {
    goto dkctGUILayoutFinished;
  }
  inputDataSizer->Add(
    lMaximum,
    wxGBPosition(7, 0),
    wxGBSpan(1, 1),
    wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL
  );
  tMaximum = new wxTextCtrl(
    dkctGUIContentsPanel,
    wxID_ANY,
    sTexts[26]
  );
  if(!(tMaximum)) {
    goto dkctGUILayoutFinished;
  }
  tMaximum->SetToolTip(sTexts[24]);
  inputDataSizer->Add(
    tMaximum,
    wxGBPosition(7, 1),
    wxGBSpan(1, 1),
    wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL
  );
  horizontalSizer->Add(
    inputDataSizer,
    0,
    wxALIGN_LEFT|wxALIGN_TOP
  );
  horizontalSizer->Add(10, 10, 0);
  bCalculate = new wxBitmapButton(
    dkctGUIContentsPanel,
    DkWxImgsz_Run,
    run2_bitmap
  );
  if(!(bCalculate)) {
    goto dkctGUILayoutFinished;
  }
  bCalculate->SetToolTip(sTexts[25]);
  horizontalSizer->Add(
    bCalculate,
    0,
    wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL
  );
  horizontalSizer->Add(10, 10, 0);
  outputDataSizer = new wxGridBagSizer(
    5, 5
  );
  if(!(outputDataSizer)) {
    goto dkctGUILayoutFinished;
  }
  lResults = new wxStaticText(
    dkctGUIContentsPanel,
    wxID_ANY,
    sTexts[7]
  );
  if(!(lResults)) {
    goto dkctGUILayoutFinished;
  }
  outputDataSizer->Add(
    lResults,
    wxGBPosition(0, 0),
    wxGBSpan(1, 2),
    wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL
  );
  dataGrid = new wxGrid(
    dkctGUIContentsPanel,
    wxID_ANY
  );
  if(!(dataGrid)) {
    goto dkctGUILayoutFinished;
  }
  dataGrid->CreateGrid(16, 4);
  dataGrid->SetColLabelValue(0, sTexts[3]);
  dataGrid->SetColLabelValue(1, sTexts[4]);
  dataGrid->SetColLabelValue(2, sTexts[5]);
  dataGrid->SetColLabelValue(3, sTexts[18]);
  dataGrid->EnableEditing(false);
  dataGrid->SetMinSize(wxSize(300, 200));
  outputDataSizer->Add(
    dataGrid,
    wxGBPosition(1, 0),
    wxGBSpan(2, 2),
    wxALIGN_LEFT|wxALIGN_TOP|wxGROW
  );
  outputDataSizer->AddGrowableRow(2);
  outputDataSizer->AddGrowableCol(1);
  horizontalSizer->Add(
    outputDataSizer,
    1,
    wxALIGN_LEFT|wxALIGN_TOP|wxGROW
  );
  horizontalSizer->Add(10, 10, 0);
  mainSizer->Add(
    horizontalSizer,
    1,
    wxGROW
  );
  mainSizer->Add(10, 10, 0);
  statusSizer = new wxBoxSizer(
    wxHORIZONTAL
  );
  if(!(statusSizer)) {
    goto dkctGUILayoutFinished;
  }
  statusSizer->Add(10, 10, 0);
  lStatus = new wxStaticText(
    dkctGUIContentsPanel,
    wxID_ANY,
    sTexts[18]
  );
  if(!(lStatus)) {
    goto dkctGUILayoutFinished;
  }
  statusSizer->Add(
    lStatus
  );
  statusSizer->Add(10, 10, 0);
  mainSizer->Add(
    statusSizer
  );
  mainSizer->Add(10, 10, 0);
  dkctGUIContentsPanel->SetSizer(mainSizer);
  SetIcon(dkicon_bitmap);
  dkctGUILayoutOK = true;
  dkctGUILayoutFinished:
  if(dkctGUILayoutOK) {
    mainSizer->Fit(this);
    mainSizer->SetSizeHints(this);
  }

#line 436 "DkWxImgszFrame.wxc"
  if (lOriginalImage) {
    lOriginalImage->SetForegroundColour(cNotSoDarkRed);
  }
  if (lChangeType) {
    lChangeType->SetForegroundColour(cNotSoDarkRed);
  }
  if (lResults) {
    lResults->SetForegroundColour(cNotSoDarkRed);
  }
  SetTitle(localizedMessages[0]);
  restorePosition();
  restoreData();
  enableDisableMinimumMaximum();
}


#line 452 "DkWxImgszFrame.wxc"

void
DkWxImgszFrame::OnHelp(wxCommandEvent& WXUNUSED(event))
{
  openHelp();
}


static wxChar const wximgsz_version[] = {
  wxT("wximgsz (part of dkt-")
};

static wxChar const wximgsz_versnumber[] = {
  DKT_WXCHAR_VERSION
};

static wxChar const wximgsz_versend[] = {
  wxT(")")
};
void
DkWxImgszFrame::OnAbout(wxCommandEvent& WXUNUSED(event))
{
  wxString sVersion(wximgsz_version);
  sVersion.Append(wximgsz_versnumber);
  sVersion.Append(wximgsz_versend);
  sVersion.Append(sTexts[53]);
  sVersion.Append(wxT("Copyright (c) 2013 Dirk Krause"));
  sVersion.Append(sTexts[53]);
  sVersion.Append(sTexts[53]);
  sVersion.Append(sTexts[54]);
  sVersion.Append(wxT("DK tools, wxWidgets, libpng, libjpeg, libtiff, zlib."));
  sVersion.Append(sTexts[53]);
  sVersion.Append(sTexts[53]);
  sVersion.Append(sTexts[55]);
  sVersion.Append(wxT("http://dktools.sourceforge.net\n"));
  sVersion.Append(wxT("http://www.wxwidgets.org\n"));
  sVersion.Append(wxT("http://www.libpng.org/pub/png/libpng.html\n"));
  sVersion.Append(wxT("http://www.ijg.org\n"));
  sVersion.Append(wxT("http://www.remotesensing.org/libtiff\n"));
  sVersion.Append(wxT("http://www.zlib.org"));
  wxMessageBox(sVersion, sTexts[35]);
}


void
DkWxImgszFrame::OnQuit(wxCommandEvent& WXUNUSED(event))
{
  

#line 500 "DkWxImgszFrame.wxc"
  Show(false);
  Close();
  

#line 503 "DkWxImgszFrame.wxc"
}



void
DkWxImgszFrame::OnOpen(wxCommandEvent& WXUNUSED(event))
{
  wxString	s(wxT(""));
  

#line 512 "DkWxImgszFrame.wxc"
  s.Append(wxT("BMP files (*.bmp)|*.bmp"));
  s.Append(wxT("|PNG files (*.png)|*.png"));
  s.Append(wxT("|JPEG files (*.jpg)|*.jpg|JPEG files (*.jpeg)|*.jpeg"));
  s.Append(wxT("|TIFF files (*.tif)|*.tif|TIFF files (*.tiff)|*.tiff"));
  s.Append(wxT("|XPM files (*.xpm)|*.xpm"));
  s.Append(wxT("|All files (*.*)|*.*"));
#if wxCHECK_VERSION(2, 9, 0)
  wxFileDialog dlg(this, sTexts[48], sCurrentDir, wxT(""), s, wxFD_OPEN);
#else
  wxFileDialog dlg(this, sTexts[48], sCurrentDir, wxT(""), s, wxOPEN);
#endif
  pHelper->setRelatedPosition(this, &dlg, &fdx, &fdy);
  if(wxID_OK == dlg.ShowModal()) {
    wxString path = dlg.GetPath();
    wxImage  img;
    if(img.LoadFile(path)) {
      int w = img.GetWidth();
      int h = img.GetHeight();
      if((w > 0) && (h > 0)) {
        wxString sWidth;
	wxString sHeight;
	sWidth.Printf(wxT("%d"), w);
	sHeight.Printf(wxT("%d"), h);
	if((tWidth) && (tHeight)) {
	  tWidth->SetValue(sWidth);
	  tHeight->SetValue(sHeight);
	  Refresh();
	  Update();
	  run(false);
	}
      } else {
        /* ERROR: Illegal image dimensions! */
	wxMessageBox(sTexts[51], sTexts[52], (wxOK | wxICON_ERROR), this);
      }
    } else {
      /* ERROR: Failed to load file! */
      wxMessageBox(sTexts[51], sTexts[52], (wxOK | wxICON_ERROR), this);
    }
  }
  dlg.GetPosition(&fdx, &fdy);
  

#line 553 "DkWxImgszFrame.wxc"
}



void
DkWxImgszFrame::OnOptions(wxCommandEvent& WXUNUSED(event))
{
  

#line 561 "DkWxImgszFrame.wxc"
  DkWxImgszOptionsDialog dlg(this, sTexts[41], sTexts);
  pHelper->setRelatedPosition(this, &dlg, &odx, &ody);
  dlg.SetValue(bUseColour);
  if(dlg.ShowModal() == wxID_OK) {
    bUseColour = dlg.GetValue();
  }
  dlg.GetPosition(&odx, &ody);
  

#line 569 "DkWxImgszFrame.wxc"
}


void
DkWxImgszFrame::run(bool bShowErrors)
{
  long		w	= 0L;
  long		h	= 0L;
  long		min	= 0L;
  long		max	= 0L;
  int		action	= 0;
  

#line 581 "DkWxImgszFrame.wxc"
  w = getTextCtrlContents(tWidth, bShowErrors);
  if(w > 0L) {
    h = getTextCtrlContents(tHeight, bShowErrors);
    if(h > 0L) {
      switch((action = cbAction->GetCurrentSelection())) {
        case 2: {
	  min = getTextCtrlContents(tMinimum, bShowErrors);
	  if(min > 0L) {
	    max = getTextCtrlContents(tMaximum, bShowErrors);
	  }
	} break;
	case 1: {
	  min = getTextCtrlContents(tMinimum, bShowErrors);
	  if(min > 0L) {
	    max = getTextCtrlContents(tMaximum, bShowErrors);
	  }
	} break;
	default: {
	  min = 1L; max = w; action = 1;
	} break;
      }
      if((w > 0L) && (h > 0L) && (min > 0L) && (max > 0L)) {
        switch(action) {
	  case 2: {
	    runForNumbers(h, w, min, max, 1);
	  } break;
	  default: {
	    runForNumbers(w, h, min, max, 0);
	  } break;
	}
      }
    }
  }
  

#line 615 "DkWxImgszFrame.wxc"
}



void
DkWxImgszFrame::OnRun(wxCommandEvent& WXUNUSED(event))
{
  

#line 623 "DkWxImgszFrame.wxc"
  run(true);
  

#line 625 "DkWxImgszFrame.wxc"
}



DkWxImgszFrame::~DkWxImgszFrame()
{
}



bool
DkWxImgszFrame::canClose(bool isLast)
{
  

#line 639 "DkWxImgszFrame.wxc"
  if(isLast) {
    saveData();
  } 

#line 642 "DkWxImgszFrame.wxc"
  return true;
}



static wxChar const * const	wximgsz_keys[] = {
/* 0 */
wxT("wximgsz.width"),

/* 1 */
wxT("wximgsz.height"),

/* 2 */
wxT("wximgsz.selection"),

/* 3 */
wxT("wximgsz.minimum"),

/* 4 */
wxT("wximgsz.maximum"),

/* 5 */
wxT("wximgsz.colours"),

NULL


#line 656 "DkWxImgszFrame.wxc"
};

void
DkWxImgszFrame::saveData()
{
  long i[] = {
    0L,		//	Width
    0L,		//	Height
    0L,		//	Selection
    0L,		//	Minimum
    0L,		//	Maximum
    0L		//	bUseColour
  };
  long l;
  if((tWidth->GetValue()).ToLong(&l)) {
    i[0] = l;
  }
  if((tHeight->GetValue()).ToLong(&l)) {
    i[1] = l;
  }
  i[2] = (long)(cbAction->GetCurrentSelection());
  if(i[2] < 0L) i[2] = 0L;
  if((tMinimum->GetValue()).ToLong(&l)) {
    i[3] = l;
  }
  if((tMaximum->GetValue()).ToLong(&l)) {
    i[4] = l;
  }
  i[5] = ((bUseColour) ? 1L : 0L);
  if(pHelper) {
    pHelper->saveMultipleLongs(wximgsz_keys, i);
  }
}


void
DkWxImgszFrame::restoreData()
{
  wxString sWidth;
  wxString sHeight;
  wxString sMinimum;
  wxString sMaximum;
  long i[] = {
    1024L,		//	Width
    768L,		//	Height
    0L,			//	Selection
    200L,		//	Minimum
    800L,		//	Maximum
    1L			//	bUseColour
  };
  if(pHelper) {
    pHelper->retrieveMultipleLongs(wximgsz_keys, i);
    sWidth.Printf(wxT("%ld"), i[0]);
    sHeight.Printf(wxT("%ld"), i[1]);
    sMinimum.Printf(wxT("%ld"), i[3]);
    sMaximum.Printf(wxT("%ld"), i[4]);
    tWidth->SetValue(sWidth);
    tHeight->SetValue(sHeight);
    tMinimum->SetValue(sMinimum);
    tMaximum->SetValue(sMaximum);
    cbAction->SetSelection((int)(i[2]));
    bUseColour = ((i[5]) ? true : false);
  }
}



void
DkWxImgszFrame::enableDisableMinimumMaximum()
{
  if(0 == cbAction->GetCurrentSelection()) {
    tMinimum->SetEditable(false);
    tMaximum->SetEditable(false);
    tMinimum->Enable(false);
    tMaximum->Enable(false);
  } else {
    tMinimum->SetEditable(true);
    tMaximum->SetEditable(true);
    tMinimum->Enable(true);
    tMaximum->Enable(true);
  }
}



void
DkWxImgszFrame::OnChoice(wxCommandEvent & event)
{
  enableDisableMinimumMaximum();
}



long 
DkWxImgszFrame::gcd(long aa, long bb)
{
  long		back	=	0L;
  long		h	=	0L;
  long		a;
  long		b;

  a = aa;
  b = bb;
  while(b > 0L) {
    h = a % b;
    a = b;
    b = h;
  }
  back = a;
  return back;
}


long
DkWxImgszFrame::getTextCtrlContents(wxTextCtrl *tf, bool bShowErrors)
{
  long		back	= 0L;
  long		l	= 0L;
  if((tf->GetValue()).ToLong(&l)) {
    back = l;
  }
  if(0 >= back) {
    if(bShowErrors) {
      tf->SetFocus();
      wxMessageBox(sTexts[33], sTexts[32], (wxOK | wxICON_ERROR), this);
    }
  }
  return back;
}



void
DkWxImgszFrame::runForNumbers(long w, long h, long min, long max, int inverted)
{
  long	gd;
  long	w0;
  long	h0;
  long	nw;
  long	nh;
  long	i;
  long	z;
  long	n;
  long	g2;
  int	lineno;
  int	cl;
  int	rows;
  int	found = 0;

  gd = gcd(w, h);
  if(gd > 0L) {
    /*
    	Minimum rectangle.
    */
    w0 = w / gd;
    h0 = h / gd;
    /*
    	Remove all grid lines.
    */
    rows = dataGrid->GetNumberRows();
    dataGrid->DeleteRows(0, rows);
    /*
    	Build and fill new grid.
    */
    lineno = 0;
    i = 1;
    lStatus->SetForegroundColour(cBlack);
    lStatus->SetLabel(sTexts[18]);
    while((i * w0) <= max) {
      if((i * w0) >= min) {
        found = 1;
        nw = i * w0;
	nh = i * h0;
	/* Classify factor. */
	cl = classifyFactor(nw, w);
	g2 = gcd(nw, w);
	z = nw / g2; n = w / g2;
	dataGrid->AppendRows(1);
	dataGrid->SetCellTextColour(lineno, 0, cBlack);
	dataGrid->SetCellTextColour(lineno, 1, cBlack);
	dataGrid->SetCellTextColour(lineno, 2, cBlack);
	switch(cl) {
	  case 2: {
	    if(bUseColour) {
	      dataGrid->SetCellBackgroundColour(lineno, 2, cGreen);
	    } else {
	      dataGrid->SetCellValue(lineno, 3, sTexts[36]);
	    }
	  } break;
	  case 1: {
	    if(bUseColour) {
	      dataGrid->SetCellBackgroundColour(lineno, 2, cYellow);
	    } else {
	      dataGrid->SetCellValue(lineno, 3, sTexts[37]);
	    }
	  } break;
	  default: {
	    if(bUseColour) {
	      dataGrid->SetCellBackgroundColour(lineno, 2, cRed);
	    } else {
	      dataGrid->SetCellValue(lineno, 3, wxT(""));
	    }
	  } break;
	}
	if(bUseColour) {
	  dataGrid->SetCellValue(lineno, 3, wxT(""));
	}
	{
	  wxString	sRowHead;
	  wxString	sFactor;
	  wxString	sWidth;
	  wxString	sHeight;

	  sRowHead.Printf(wxT("%d"), (lineno + 1));
	  if(n > 1L) {
	    sFactor.Printf(wxT("%ld / %d"), z, n);
	  } else {
	    sFactor.Printf(wxT("%ld"), z);
	  }
	  if(inverted) {
	    sWidth.Printf(wxT("%ld"), nh);
	    sHeight.Printf(wxT("%ld"), nw);
	  } else {
	    sWidth.Printf(wxT("%ld"), nw);
	    sHeight.Printf(wxT("%ld"), nh);
	  }
	  dataGrid->SetRowLabelValue(lineno, sRowHead);
	  dataGrid->SetCellValue(lineno, 0, sWidth);
	  dataGrid->SetCellValue(lineno, 1, sHeight);
	  dataGrid->SetCellValue(lineno, 2, sFactor);
	  dataGrid->SetCellAlignment(lineno, 0, wxALIGN_CENTRE, wxALIGN_CENTRE);
	  dataGrid->SetCellAlignment(lineno, 1, wxALIGN_CENTRE, wxALIGN_CENTRE);
	  dataGrid->SetCellAlignment(lineno, 2, wxALIGN_CENTRE, wxALIGN_CENTRE);
	  dataGrid->SetCellAlignment(lineno, 3, wxALIGN_CENTRE, wxALIGN_CENTRE);
	}
	lineno++;
      }
      i++;
    }
    dataGrid->AutoSizeColumns();
    dataGrid->EnableDragColSize(true);
    if(0 == found) {
      lStatus->SetLabel(sTexts[34]);
      lStatus->SetForegroundColour(cDarkRed);
    }
    Refresh();
    Update();
  }
}



int
DkWxImgszFrame::classifyFactor(long n, long o)
{
  long	max;
  long	min;
  int	back	= 0;
  if(n > o) {
    max = n; min = o;
  } else {
    max = o; min = n;
  }
  if(max % min) {
    back = 0;
  } else {
    back = 1;
    max = max / min;
    if(countBits(max) == 1) {
      back = 2;
    }
  }
  return back;
}


int
DkWxImgszFrame::countBits(long v)
{
  long	bitmask = 0x4000L;
  int	attempts = 15;
  int	back = 0;

/*	Better solution below, does not produce a warning
	about constant too large for data type.
*/
#if 0
  if(sizeof(long) > 2) {
    if(sizeof(long) > 4) {
      /* 2014-06-05	The next line causes a warning on 32 bit systems.
			Due to the   if(sizeof(long) > 4)   condition test
			above this line is not reached if the data type
			long is too short, so the warning is harmless.
      */
      bitmask = 0x4000000000000000L;
      attempts = 63;
    } else {
      bitmask = 0x40000000L;
      attempts = 31;
    }
  }
#endif

#if DK3_SIZEOF_LONG > 2
  bitmask = 0x40000000L;
  attempts = 31;
#if DK3_SIZEOF_LONG > 4
  bitmask = 0x4000000000000000L;
  attempts = 63;
#endif
#endif

  while(attempts--) {
    if(v & bitmask) {
      back++;
    }
    bitmask = bitmask >> 1;
  }
  return back;
}


