/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: DkWxHelpController.cpt
*/

/*
Copyright (C) 2011, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file DkWxHelpController.h Header file for the DkWxHelpController module.
*/

#ifndef DKWXHELPCONTROLLER_H_INCLUDED
/** Avoid multiple inclusions. */
#define DKWXHELPCONTROLLER_H_INCLUDED 1


#line 10 "DkWxHelpController.cpt"

#include <dk3conf.h>
#include <dk3types.h>

#include <wx/wxprec.h>
#ifdef __BORLANDC__
#pragma hdrstop
#endif
#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif
#include <wx/config.h>
#include <wx/filename.h>
#include <wx/help.h>
#include <wx/fs_zip.h>

#include <DkWxAppHelper.h>



/**	Help controller covering both chm and htb help files.
*/
class DkWxHelpController
{
  private:

    /**	Application helper, used to find the help files.
    */
    DkWxAppHelper		*appHelper;

    /**	Flag: Help file was found.
    */
    bool			bFileFound;

#ifdef __WXMSW__
    /**	Use CHM help controller on Windows systems.
    */
    wxCHMHelpController		hc;
#else
    /**	Use HTML help controller on all other systems.
    */
    wxHtmlHelpController	hc;
#endif

  public:
    /**	Constructor.
    	@param	ah	Application helper.
	@param	chmName	Short file name of chm file, without leading directory.
	@param	htbName	Short file name of htb file, without leading directory.
    */
    DkWxHelpController(
      DkWxAppHelper *ah,
      wxChar const *chmName,
      wxChar const *htbName
    );

    /**	Open help system.
    	@param	wxf	Parent frame.
    */
    void
    openHelp(wxFrame *wxf);

    /**	Open a help section specified by name.
    	@param	wxf	Parent frame.
	@param	name	Section name.
    */
    void
    openHelpSectionByName(wxFrame *wxf, wxString const & name);

    /**	Open a help section specified by number.
    	@param	wxf	Parent frame.
	@param	number	Section number (context ID).
    */
    void
    openHelpSectionByNumber(wxFrame *wxf, int number);

};




#endif
