/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: DkWxFrame.cpt
*/

/*
Copyright (C) 2011, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file DkWxFrame.h Header file for the DkWxFrame module.
*/

#ifndef DKWXFRAME_H_INCLUDED
/** Avoid multiple inclusions. */
#define DKWXFRAME_H_INCLUDED 1


#line 9 "DkWxFrame.cpt"

#include <dk3all.h>

#include <wx/wxprec.h>
#ifdef __BORLANDC__
#pragma hdrstop
#endif
#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif


#include "DkWxAppHelper.h"
#include "DkWxHelpController.h"



/**	Base class for top-level frames. This class keeps pointers to an
	application helper for file search and localization and a
	pointer to a help controller object managing online help
	for both *.chm and *.htb based help.

	Derive your applications frames from this class.
*/
class DkWxFrame : public wxFrame
{
  private:
  
    /**	Number of windows currently open.
    */
    static int		iInstances;
    
    /**	Keywords to save and retrieve size and position data.
    */
    static wxChar const * const	kwSizePos[];

    /**	Preference keys whether or not to restore maxizmed and iconized.
    */
    static dkChar const * const	kwRestoreFeatures[];
    
  protected:
  
    /**	Helper object for file search and internationalization.
    */
    DkWxAppHelper	*pHelper;

    /**	Help controller for chm and htb based help files.
    */
    DkWxHelpController		*helpController;

    /**	Restore previous position or center on screen.
    */
    void restorePosition();
    
    /**	Save current position.
    */
    void savePosition();
    
  public:
  
    /**	Constructor.
    	@param	applicationName		Application name.
    	@param	applicationHelper	Helper object.
	@param	applicationHelp		Help controller.
    	@param	wxid			Window ID.
    */
    DkWxFrame(
      wxChar const		*applicationName,
      DkWxAppHelper		*applicationHelper,
      DkWxHelpController	*applicationHelp,
      int		 	wxid
    );
    
    /**	Handler for close event.
    	@param	event	Event to process.
    */
    void OnClose(wxCloseEvent & event);
    
    /**	Check whether we can close the frame.
    	@param	isLast	Flag: Last frame instance of application.
	@return	Permission to close.
    */
    virtual bool	canClose(bool isLast);

    /**	Open help system if help controller available.
    */
    void		openHelp();

    /**	Open help section specified by name.
    	@param	name	Section name.
    */
    void
    openHelpSectionByName(wxString const & name);

    /**	Open help section specified by section number.
    	@param	number	Section number (context ID).
    */
    void
    openHelpSectionByNumber(int number);
};




#endif
