/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: DkWxFrame.cpt
*/

/*
Copyright (C) 2011, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file DkWxFrame.cpp The DkWxFrame module.
*/


#line 113 "DkWxFrame.cpt"

/**	@file	DkWxFrame.cpp	Implementation of DkWxFrame.
*/

#include "DkWxFrame.h"




#line 121 "DkWxFrame.cpt"



int DkWxFrame::iInstances = 0;



wxChar const * const	DkWxFrame::kwSizePos[] = {
/* 0 */ wxT("window.x"),
/* 1 */ wxT("window.y"),
/* 2 */ wxT("window.w"),
/* 3 */ wxT("window.h"),
/* 4 */ wxT("window.maximized"),
/* 5 */ wxT("window.iconized"),
NULL
};



dkChar const * const	DkWxFrame::kwRestoreFeatures[] = {
/* 0 */ dkT("/gui/restore/maximized"),
/* 1 */ dkT("/gui/restore/iconized"),
NULL
};



DkWxFrame::DkWxFrame(
  wxChar const		*applicationName,
  DkWxAppHelper		*applicationHelper,
  DkWxHelpController	*applicationHelp,
  int		 	wxid
) : wxFrame(NULL, wxid, applicationName)
{
  

#line 156 "DkWxFrame.cpt"
  /*
  	Initialize elements.
  */
  pHelper = NULL;
  helpController = applicationHelp;
  /*
  	Set elements.
  */
  pHelper = applicationHelper;
  iInstances++;
  Connect(wxid, wxEVT_CLOSE_WINDOW, wxCloseEventHandler(DkWxFrame::OnClose));
  

#line 168 "DkWxFrame.cpt"
}



void DkWxFrame::OnClose(wxCloseEvent & event)
{
  bool		doClose = true;
  

#line 176 "DkWxFrame.cpt"
  if(event.CanVeto()) {
    doClose = canClose(iInstances == 1);
  } else {
    canClose(iInstances == 1);
  }
  if(doClose) {		

#line 182 "DkWxFrame.cpt"
    /*
    	For last instance save position.
    */
    if(iInstances-- == 1) {	

#line 186 "DkWxFrame.cpt"
      savePosition();
    }
    /*
    	Process close event.
    */
    event.Skip();
  } else {		

#line 193 "DkWxFrame.cpt"
    /*
    	Do not close the window.
    */
    event.Veto();
  } 

#line 198 "DkWxFrame.cpt"
}



void
DkWxFrame::restorePosition()
{
  int		p[6];
  size_t	num;
  int		w, h;
  int		restoreFeature;
  

#line 210 "DkWxFrame.cpt"
  p[0] = p[1] = p[2] = p[3] = w = h = 0;
  if((num = pHelper->retrieveMultipleInts(kwSizePos, p)) >= 4) {
    wxSize scsz = wxGetDisplaySize();
    GetSize(&w, &h);
    if(w > p[2]) { p[2] = w; }
    if(h > p[3]) { p[3] = h; }
    if((p[0] + p[2]) > scsz.x) { p[0] = scsz.x - p[2]; }
    if((p[1] + p[3]) > scsz.y) { p[1] = scsz.y - p[3]; }
    if(p[0] < 0) { p[0] = 0; }
    if(p[1] < 0) { p[1] = 0; }
    SetSize(p[0], p[1], p[2], p[3]);
    restoreFeature = dk3app_get_pref_bool(
      pHelper->getApp(),
      kwRestoreFeatures[0],
      0
    );
    if((restoreFeature) && (4 < num)) {
      if(0 != p[4]) {
        Maximize(true);
      }
    }
    restoreFeature = dk3app_get_pref_bool(
      pHelper->getApp(),
      kwRestoreFeatures[1],
      0
    );
    if((restoreFeature) && (5 < num)) {
      if(0 != p[5]) {
        Iconize(true);
      }
    }
  } else {
    CentreOnScreen();
  } 

#line 244 "DkWxFrame.cpt"
}



void
DkWxFrame::savePosition()
{
  int p[6];
  

#line 253 "DkWxFrame.cpt"
  p[4] = 0;
  p[5] = 0;
  if(IsIconized()) {
    p[5] = 1;
    Iconize(false);
  }
  if(IsMaximized()) {
    p[4] = 1;
    Maximize(false);
  }
  GetPosition(&(p[0]), &(p[1]));
  GetSize(&(p[2]), &(p[3]));
  if(pHelper) {
    pHelper->saveMultipleInts(kwSizePos, p);
  } 

#line 268 "DkWxFrame.cpt"
}



bool
DkWxFrame::canClose(bool isLast)
{
  

#line 276 "DkWxFrame.cpt"
  return true;
}



void
DkWxFrame::openHelp()
{
  

#line 285 "DkWxFrame.cpt"
  if(helpController) {
    helpController->openHelp((wxFrame *)this);
  } 

#line 288 "DkWxFrame.cpt"
}



void
DkWxFrame::openHelpSectionByName(wxString const & name)
{
  

#line 296 "DkWxFrame.cpt"
  if (helpController) {
    helpController->openHelpSectionByName((wxFrame *)this, name);
  }
  

#line 300 "DkWxFrame.cpt"
}



void
DkWxFrame::openHelpSectionByNumber(int number)
{
  

#line 308 "DkWxFrame.cpt"
  if (helpController) {
    helpController->openHelpSectionByNumber((wxFrame *)this, number);
  }
  

#line 312 "DkWxFrame.cpt"
}

