/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: DkWxCommunicator.cpt
*/

/*
Copyright (C) 2011, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file DkWxCommunicator.h Header file for the DkWxCommunicator module.
*/

#ifndef DKWXCOMMUNICATOR_H_INCLUDED
/** Avoid multiple inclusions. */
#define DKWXCOMMUNICATOR_H_INCLUDED 1


#line 10 "DkWxCommunicator.cpt"


/**	Synchronized communication between a worker thread and a
	progress dialog (ie DkWxProgressDialog).
*/
class DkWxCommunicator
{
  protected:

    /**	Grant access to only one thread at a time to other members.
    */
    wxCriticalSection	csProtect;

    /**	Flag: Thread is still running.
    */
    int			iRunning;

    /**	Autostart state.
    */
    int			iAutostart;

    /**	Flag: Worker thread can continue.
    */
    int			iCanContinue;

    /**	String containing all the messages produced by worker thread.
    */
    wxString		*sMessages;

    /**	Current file name processed.
    */
    wxChar		*sFilename;

    /**	Current gauge value (0-1000).
    */
    int			iGauge;

    /**	Flag: Update required.
    */
    int			iUpdated;

    /**	Encoding for wxChar.
    */
    int			wxe;

    /**	Encoding for dkChar.
    */
    int			dke;

    /**	Most significant log level.
    */
    int			iLogLevelMax;

    /**	Change file name, set iUpdated if new file name differs from
    	previous one.
    	@param	newFileName	New file name.
	@return	1 on success (new file name saved), 0 on error.
    */
    int
    internalSetFilename(wxChar const *newFileName);

    /**	Change gauge value, set iUpdated if new value differs
    	from previous one.
	@param	newValue	New gauge value.
    */
    void
    internalSetGauge(int newValue);

  public:

    /**	Constructor.
    	@param	we	Encoding used for wxChar strings.
	@param	de	Encoding used for dkChar strings.
    */
    DkWxCommunicator(int we, int de);

    /**	Destructor.
    */
    ~DkWxCommunicator();
    
    /**	Check whether the object has set up correctly and is ready to use.
    	@return	1 if setup is ok, 0 for error.
    */
    int
    checkSetup() const;

    /**	Update GUI elements.
    	@param	wDialog		Progress dialog.
	@param	tFilename	Static text to show file name.
	@param	gProgress	Progress bar.
	@return	Or-combination of DK_WX_COMMUNICATOR_STATUS_RUNNING
	and DK_WX_COMMUNICATOR_STATUS_UPDATE.
	If the thread is no longer running, you can close the progress
	dialog. If there was an update to file name or progress bar
	value you need to call Refresh() and Update().
    */
    int
    getUpdates(
      wxWindow		*wDialog,
      wxStaticText	*tFilename,
      wxGauge		*gProgress
    );

    /**	Set new file name and gauge value, may be used by a worker thread.
    	@param	fn	New file name.
	@param	nv	New gauge value.
	@return	1 on success, 0 on error.
    */
    int
    setUpdates(wxChar const *fn, int nv);

    /**	Update gauge value only, leave file name untouched.
    	@param	nv	New gauge value.
    */
    void
    updateGauge(int nv);

    /**	Set text to text control.
    	@param	tc	Text control to use for log messages from
			worker thread.
    */
    void
    getText(
      wxTextCtrl	*tc
    );

    /**	Prepare to run a worker thread.
    */
    void
    prepareRun();

    /**	Set can-continue flag.
    	@param	nv	New flag value (1=can continue, 0=must stop).
			Set to 0 if a "Cancel" button was pressed in the
			progress dialog.
    */
    void
    setCanContinue(int nv);

    /**	Get can-continue flag, used by the worker thread to react
    	on "Cancel" button.
    	@return	1 on success (can continue), 0 on error (cancel button pressed).
    */
    int
    getCanContinue();

    /**	Set iRunning.
    	A worker thread uses setRunning(0) to inidicate it is finished.
	@param	nv	New iRunning value.
    */
    void
    setRunning(int nv);

    /**	Check whether the thread is still running.
    	@return	1 for thread still running, 0 for thread finished.
    */
    int
    getRunning();

    /**	Enable/disable autostart job.
    	@param	nv	New autostart flag.
    */
    void
    autostartEnable(bool nv = true);

    /**	Check whether we can run an autostart job.
    	On success we change the internal autostart variable to indicate
	that an autostart job is currently running.
    	@return	1 to run autostart job, 0 otherwise.
    */
    int
    autostartCanRun();

    /**	Mark autostart job as finished. This is typically invoked
    	at the end of the autostart worker thread.
    */
    void
    autostartSetFinished();

    /**	Check whether the autostart job is completed so we can close the
    	window.
	@return	1 to close the window, 0 otherwise.
    */
    int
    autostartIsFinished();

    /**	Add text to log messages string.
    	@param	t	Text to add.
    */
    void
    addWxText(wxChar const *t);

    /**	Add text to log messages string.
    	@param	t	Text to add.
    */
    void
    addDkText(dkChar const * t);

    /**	Add text to log messages string.
    	@param	t	Text to add.
    */
    void
    addCharText(char const *t);

    /**	Add newline to log messages string.
    */
    void
    nl();

    /**	Set most significant log level.
    	@param	nv	Log level occured.
    */
    void
    setLogLevel(int nv);

    /**	Retrieve most significant log level.
    	@return	Log level.
    */
    int
    getLogLevel();

    /**	Retrieve autostart information.
    	@return	Current iAutostart value.
    */
    int
    autostartGet();

    /**	Get current messages text.
    	@return	Current text stored.
    */
    wxString getText();
};



/** Status: Thread is still running.
*/
#define	DK_WX_COMMUNICATOR_STATUS_RUNNING	1

/** Status: Thread updated data since last request.
*/
#define	DK_WX_COMMUNICATOR_STATUS_UPDATE	2


#endif
