/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: DkWxCommunicator.cpt
*/

/*
Copyright (C) 2011, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file DkWxCommunicator.cpp The DkWxCommunicator module.
*/


#line 254 "DkWxCommunicator.cpt"


#include "dk3wxs.h"
#include <dk3mem.h>
#include "DkWxCommunicator.h"




#line 262 "DkWxCommunicator.cpt"



/**	Empty text to use if no file name is specified.
*/
static wxChar const dkwx_communicator_empty_text[] = { wxT("") } ;

/**	Newline.
*/
static wxChar const dkwx_communicator_newline[] = { wxT("\n") } ;


DkWxCommunicator::DkWxCommunicator(int we, int de)
{
  

#line 277 "DkWxCommunicator.cpt"
  wxe = we;
  dke = de;
  iRunning = 0;
  iAutostart = DK3_WX_AUTOSTART_NORMAL;	

#line 281 "DkWxCommunicator.cpt"
  sMessages = NULL;
  sFilename = NULL;
  iGauge = 0;
  iUpdated = 0;
  iCanContinue = 1;
  iLogLevelMax = DK3_LL_IGNORE;
  sMessages = new wxString(dkwx_communicator_empty_text);
  

#line 289 "DkWxCommunicator.cpt"
}



DkWxCommunicator::~DkWxCommunicator()
{
  {
    wxCriticalSectionLocker	lock(csProtect);
  }
  if(sMessages) {
    delete sMessages;
  }
  if(sFilename) {
    dk3_release(sFilename);
  }
  iRunning = 0;
  iGauge = 0;
  iUpdated = 0;
  iCanContinue = 0;
}



int
DkWxCommunicator::checkSetup() const
{
  int back = 0;
  if(sMessages) {
    back = 1;
  }
  return back;
}



int
DkWxCommunicator::getUpdates(
      wxWindow		*wDialog,
      wxStaticText	*tFilename,
      wxGauge		*gProgress
)
{
  int		back = 0;
  wxCriticalSectionLocker lock(csProtect);
  if(iUpdated) {
    back |= DK_WX_COMMUNICATOR_STATUS_UPDATE;
    if(tFilename) {
      if(sFilename) {
	tFilename->SetLabel(sFilename);
      } else {
	tFilename->SetLabel(dkwx_communicator_empty_text);
      }
    }
    if(gProgress) {
        gProgress->SetValue(iGauge);
    }
    iUpdated = 0;
  }
  if(iRunning) {
    back |= DK_WX_COMMUNICATOR_STATUS_RUNNING;
  }
  return back;
}



void
DkWxCommunicator::internalSetGauge(int newValue)
{
  int		nv;
  nv = newValue;
  if(nv < 0) nv = 0;
  if(nv > 1000) nv = 1000;
  if(iRunning) {
    if(nv == 1000) nv = 999;
  }
  if(nv != iGauge) {
    iGauge = nv;
    iUpdated = 1;
  }
}



int
DkWxCommunicator::internalSetFilename(wxChar const *newFileName)
{
  int		back = 0;
  if(newFileName) {
    if(sFilename) {
      if(dk3wxs_cmp(newFileName, sFilename)) {
        dk3_release(sFilename);
	sFilename = dk3wxs_dup(newFileName);
	if(sFilename) {
	  back = 1;
	}
	iUpdated = 1;
      } else {
        back = 1;
      }
    } else {
      sFilename = dk3wxs_dup(newFileName);
      if(sFilename) {
        iUpdated = 1;
	back = 1;
      }
    }
  } else {
    if(sFilename) {
      dk3_release(sFilename);
      sFilename = NULL;
      iUpdated = 1;
    }
    back = 1;
  }
  return back;
}



int
DkWxCommunicator::setUpdates(wxChar const *fn, int nv)
{
  int back = 0;
  wxCriticalSectionLocker lock(csProtect);
  if(internalSetFilename(fn)) { back = 1; }
  internalSetGauge(nv);
  return back;
}



void
DkWxCommunicator::updateGauge(int nv)
{
  wxCriticalSectionLocker lock(csProtect);
  internalSetGauge(nv);
}



void
DkWxCommunicator::prepareRun()
{
  wxCriticalSectionLocker	lock(csProtect);
  internalSetFilename(NULL);
  internalSetGauge(0);
  iRunning = 1;
  iCanContinue = 1;
  sMessages->Empty();
  iUpdated = 1;
  iLogLevelMax = DK3_LL_IGNORE;
}



void
DkWxCommunicator::setCanContinue(int nv)
{
  wxCriticalSectionLocker	lock(csProtect);
  iCanContinue = nv;
}



int
DkWxCommunicator::getCanContinue()
{
  int		back = 0;
  wxCriticalSectionLocker	lock(csProtect);
  back = iCanContinue;
  return back;
}



void
DkWxCommunicator::setRunning(int nv)
{
  

#line 469 "DkWxCommunicator.cpt"
  wxCriticalSectionLocker	lock(csProtect);
  /*
  	Set new value.
  */
  iRunning = nv;
  /*
  	If we are no longer running we have finished
	the autostart job.
  */
  if(nv == 0) {		

#line 479 "DkWxCommunicator.cpt"
    if(iAutostart == DK3_WX_AUTOSTART_RUNNING) {	

#line 480 "DkWxCommunicator.cpt"
      iAutostart = DK3_WX_AUTOSTART_FINISHED;		

#line 481 "DkWxCommunicator.cpt"
    }
  } 

#line 483 "DkWxCommunicator.cpt"
}



int
DkWxCommunicator::getRunning()
{
  int back = 1;
  {
    wxCriticalSectionLocker	lock(csProtect);
    back = iRunning;
  }
  return back;
}



void
DkWxCommunicator::getText( wxTextCtrl	*tc)
{
  wxCriticalSectionLocker	lock(csProtect);
  if(tc) {
    if(sMessages) {
      tc->ChangeValue(*sMessages);
    }
  }
}



void
DkWxCommunicator::addWxText(wxChar const *t)
{
  

#line 517 "DkWxCommunicator.cpt"
  if(sMessages) {	

#line 518 "DkWxCommunicator.cpt"
    if(t) {		

#line 519 "DkWxCommunicator.cpt"
      wxCriticalSectionLocker	lock(csProtect);
      

#line 521 "DkWxCommunicator.cpt"
      sMessages->Append(t);
      

#line 523 "DkWxCommunicator.cpt"
    }
  } 

#line 525 "DkWxCommunicator.cpt"
}



void
DkWxCommunicator::addDkText(dkChar const *t)
{
  wxChar	bu[2 * DK3_MAX_PATH];

  if(sMessages) {
    if(t) {
      if(dk3wxs_from_dkstr(bu, DK3_SIZEOF(bu,wxChar), wxe, t, dke)) {
        wxCriticalSectionLocker	lock(csProtect);
	sMessages->Append(bu);
      }
    }
  }
}



void
DkWxCommunicator::addCharText(char const *t)
{
  wxChar	bu[2 * DK3_MAX_PATH];

  if(sMessages) {
    if(t) {
      if(dk3wxs_from_plain(bu, DK3_SIZEOF(bu,wxChar), t)) {
        wxCriticalSectionLocker lock(csProtect);
	sMessages->Append(bu);
      }
    }
  }
}


void
DkWxCommunicator::nl()
{
  if(sMessages) {
    wxCriticalSectionLocker	lock(csProtect);
    sMessages->Append(dkwx_communicator_newline);
  }
}



int
DkWxCommunicator::autostartCanRun()
{
  int 		back	= 0;
  

#line 578 "DkWxCommunicator.cpt"
  {
    wxCriticalSectionLocker	lock(csProtect);
    if(iAutostart == DK3_WX_AUTOSTART_START) {	

#line 581 "DkWxCommunicator.cpt"
      iAutostart = DK3_WX_AUTOSTART_RUNNING;	

#line 582 "DkWxCommunicator.cpt"
      back = 1;
    }
  } 

#line 585 "DkWxCommunicator.cpt"
  return back;
}



void
DkWxCommunicator::autostartSetFinished()
{
  

#line 594 "DkWxCommunicator.cpt"
  wxCriticalSectionLocker	lock(csProtect);
  if(iAutostart == DK3_WX_AUTOSTART_RUNNING) {
    iAutostart = DK3_WX_AUTOSTART_FINISHED;	

#line 597 "DkWxCommunicator.cpt"
  } 

#line 598 "DkWxCommunicator.cpt"
}



int
DkWxCommunicator::autostartIsFinished()
{
  int		back	= 0;
  

#line 607 "DkWxCommunicator.cpt"
  {
    wxCriticalSectionLocker	lock(csProtect);
    if(iAutostart == DK3_WX_AUTOSTART_FINISHED) {
      iAutostart = DK3_WX_AUTOSTART_WAIT_FOR_EXIT; 

#line 611 "DkWxCommunicator.cpt"
      back = 1;
    }
  } 

#line 614 "DkWxCommunicator.cpt"
  return back;
}



int
DkWxCommunicator::autostartGet()
{
  int back;
  

#line 624 "DkWxCommunicator.cpt"
  {
    wxCriticalSectionLocker	lock(csProtect);
    back = iAutostart;
  } 

#line 628 "DkWxCommunicator.cpt"
  return back;
}



void
DkWxCommunicator::autostartEnable(bool nv)
{
  

#line 637 "DkWxCommunicator.cpt"
  wxCriticalSectionLocker	lock(csProtect);
  if(nv) {
    iAutostart = DK3_WX_AUTOSTART_START;	

#line 640 "DkWxCommunicator.cpt"
  } else {
    iAutostart = DK3_WX_AUTOSTART_NORMAL;	

#line 642 "DkWxCommunicator.cpt"
  } 

#line 643 "DkWxCommunicator.cpt"
}


void
DkWxCommunicator::setLogLevel(int nv)
{
  wxCriticalSectionLocker	lock(csProtect);
  if(nv < iLogLevelMax) {
    iLogLevelMax = nv;
  }
}



int
DkWxCommunicator::getLogLevel()
{
  int		back	= DK3_LL_IGNORE;
  {
    wxCriticalSectionLocker	lock(csProtect);
    back = iLogLevelMax;
  }
  return back;
}



wxString
DkWxCommunicator::getText()
{
  wxString back(wxT(""));
  if(sMessages) {
    back = *sMessages;
  }
  return back;
}


