/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: DkWxColorView.cpt
*/

/*
Copyright (C) 2011-2013, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file DkWxColorView.h Header file for the DkWxColorView module.
*/

#ifndef DKWXCOLORVIEW_H_INCLUDED
/** Avoid multiple inclusions. */
#define DKWXCOLORVIEW_H_INCLUDED 1


#line 9 "DkWxColorView.cpt"

#include <dk3all.h>

#include <wx/wxprec.h>
#ifdef __BORLANDC__
#pragma hdrstop
#endif
#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif

#include <DkWxAppHelper.h>


/**	Show color setting, show colour chooser on mouse click.
*/
class DkWxColorView : public wxControl
{

  /**	Declare class as dynamic.
  */
  DECLARE_DYNAMIC_CLASS(DkWxColorView)
  
  /**	Event table for control.
  */
  DECLARE_EVENT_TABLE()

  protected:

    /**	Parent window.
    */
    wxWindow		*pParentWindow;

    /**	Application helper, used to position color chooser dialog.
    */
    DkWxAppHelper	*pHelper;

    /**	Class name, used in constructor and Create().
    */
    static wxChar const	 DkWxColorViewName[];

    /**	Height.
    */
    int			w;

    /**	Width.
    */
    int			h;

    /**	Red component of color to show.
    */
    int			r;

    /**	Green component of color to show.
    */
    int			g;

    /**	Blue component of color to show.
    */
    int			b;

    /**	Previous x position of color chooser dialog.
    */
    int			ccdx;

    /**	Previous y position of color chooser dialog.
    */
    int			ccdy;

  public:
    
    /**	Default constructor.
    */
    DkWxColorView();

    /**	Constructor.
    	@param	pParent	Parent window.
	@param	wxid	Window ID.
	@param	appHelper	Application helper.
	@param	red	Red component of color to show.
	@param	green	Green component of color to show.
	@param	blue	Blue component of color to show.
	@param	pos	Object position.
	@param	size	Object minimum size.
	@param	style	Style for control.
	@param	name	Class name.
    */
    DkWxColorView(
      wxWindow		*pParent,
      wxWindowID	 wxid,
      DkWxAppHelper	*appHelper,
      int		 red,
      int		 green,
      int		 blue,
      wxPoint const &	 pos  = wxDefaultPosition,
      wxSize  const &	 size = wxDefaultSize,
      long		 style = wxBORDER_NONE,
      wxChar const	*name = DkWxColorViewName
    );

    /**	Create object after using default constructor.
    	@param	pParent	Parent window.
	@param	wxid	Window ID.
	@param	appHelper	Application helper.
	@param	red	Red component of color to show.
	@param	green	Green component of color to show.
	@param	blue	Blue component of color to show.
	@param	pos	Object position.
	@param	size	Object minimum size.
	@param	style	Style for control.
	@param	name	Class name.
	@return	true on success, false on error.
    */
    bool
    Create(
      wxWindow		*pParent,
      wxWindowID	 wxid,
      DkWxAppHelper	*appHelper,
      int		 red = 255,
      int		 green = 255,
      int		 blue = 255,
      wxPoint const &	 pos  = wxDefaultPosition,
      wxSize  const &	 size = wxDefaultSize,
      long		 style = wxBORDER_NONE,
      wxChar const	*name = DkWxColorViewName
    );

    /**	Find minimum size.
    */
    wxSize DoGetBestSize() const;

    /**	Get red component of current color.
    	@return	Red.
    */
    int
    getRed() const;

    /**	Get green component of current color.
    	@return	Green.
    */
    int
    getGreen() const;

    /**	Get blue component of current color.
    	@return	Blue.
    */
    int
    getBlue() const;

    /**	Set new current color.
    	@param	red	Red.
	@param	green	Green.
	@param	blue	Blue.
    */
    void
    setRGB(int red, int green, int blue);

    /**	Handler for erase event.
    	@param	event	Event to process.
    */
    void
    OnErase(wxEraseEvent & event);

    /**	Handler for paint event.
    	@param	event	Event to process.
    */
    void
    OnPaint(wxPaintEvent & event);

    /**	Handler for mouse click event.
    	@param	event	Event to process.
    */
    void
    OnLeftMouseButtonDown(wxMouseEvent & event);

};


#endif
