/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: DkWxColorView.cpt
*/

/*
Copyright (C) 2011-2013, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file DkWxColorView.cpp The DkWxColorView module.
*/


#line 187 "DkWxColorView.cpt"

#include "DkWxColorView.h"

#include <wx/dcbuffer.h>
#include <wx/colordlg.h>





#line 196 "DkWxColorView.cpt"



BEGIN_EVENT_TABLE(DkWxColorView, wxControl)
  EVT_ERASE_BACKGROUND(DkWxColorView::OnErase)
  EVT_PAINT(DkWxColorView::OnPaint)
  EVT_LEFT_DOWN(DkWxColorView::OnLeftMouseButtonDown)
END_EVENT_TABLE()

IMPLEMENT_DYNAMIC_CLASS(DkWxColorView, wxControl)




wxChar const DkWxColorView::DkWxColorViewName[] = { wxT("DkWxColorView") } ;



DkWxColorView::DkWxColorView()
{
  pParentWindow = NULL;
  pHelper = NULL;
  w = -1;
  h = -1;
  r = 255;
  g = 255;
  b = 255;
  ccdx = -1;
  ccdy = -1;
}



DkWxColorView::DkWxColorView(
      wxWindow		*pParent,
      wxWindowID	 wxid,
      DkWxAppHelper	*appHelper,
      int		 red,
      int		 green,
      int		 blue,
      wxPoint const &	 pos,
      wxSize  const &	 size,
      long		 style,
      wxChar const	*name
)
: wxControl(
    pParent, wxid, pos, size, style, wxDefaultValidator,
    wxString(name)
)
{
  pParentWindow = pParent;
  pHelper = appHelper;
  w = size.x;
  h = size.y;
  r = red;
  g = green;
  b = blue;
  ccdx = -1;
  ccdy = -1;
}



bool
DkWxColorView::Create(
      wxWindow		*pParent,
      wxWindowID	 wxid,
      DkWxAppHelper	*appHelper,
      int		 red,
      int		 green,
      int		 blue,
      wxPoint const &	 pos,
      wxSize  const &	 size,
      long		 style,
      wxChar const	*name
)
{
  bool back;
  back = wxControl::Create(
    pParent, wxid, pos, size, style, wxDefaultValidator,
    wxString(name)
  );
  pParentWindow = pParent;
  pHelper = appHelper;
  w = size.x;
  h = size.y;
  r = red;
  g = green;
  b = blue;
  return back;
}



wxSize
DkWxColorView::DoGetBestSize() const
{
  wxSize back(((-1 < w) ? w : 20), ((-1 < h) ? h : 20));
  return back;
}



void
DkWxColorView::OnErase(wxEraseEvent & event)
{
}



void
DkWxColorView::OnPaint(wxPaintEvent & event)
{
  wxBufferedPaintDC	useDC(this);
  wxSize		sz = GetClientSize();
  wxColour		mycolor(r, g, b);
  wxBrush		myBrush(mycolor, wxSOLID);
  const wxBrush		oldBrush = useDC.GetBrush();
  useDC.SetBrush(myBrush);
  useDC.DrawRectangle(0, 0, sz.GetWidth(), sz.GetHeight());
  useDC.SetBrush(wxNullBrush);
}



void
DkWxColorView::OnLeftMouseButtonDown(wxMouseEvent & event)
{
  

#line 325 "DkWxColorView.cpt"
  wxColourDialog	dlg(this);
  if(pParentWindow) {
    if(pHelper) { 

#line 328 "DkWxColorView.cpt"
      pHelper->setRelatedPosition(pParentWindow, &dlg, &ccdx, &ccdy);
    }
  }
  if(dlg.ShowModal() == wxID_OK) {
    wxColour col = dlg.GetColourData().GetColour();
    r = col.Red();
    g = col.Green();
    b = col.Blue();
    dlg.GetPosition(&ccdx, &ccdy);
    Refresh();
    Update();
  } else {
    dlg.GetPosition(&ccdx, &ccdy);
  }
  

#line 343 "DkWxColorView.cpt"
}



int
DkWxColorView::getRed() const
{
  return r;
}




int
DkWxColorView::getGreen() const
{
  return g;
}



int
DkWxColorView::getBlue() const
{
  return b;
}



void
DkWxColorView::setRGB(int red, int green, int blue)
{
  r = red;
  g = green;
  b = blue;
  if(r < 0) r = 0;
  if(g < 0) g = 0;
  if(b < 0) b = 0;
  if(r > 255) r = 255;
  if(g > 255) g = 255;
  if(b > 255) b = 255;
}

