/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: DkWxBufferedControl.cpt
*/

/*
Copyright (C) 2013, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file DkWxBufferedControl.h Header file for the DkWxBufferedControl module.
*/

#ifndef DKWXBUFFEREDCONTROL_H_INCLUDED
/** Avoid multiple inclusions. */
#define DKWXBUFFEREDCONTROL_H_INCLUDED 1


#line 8 "DkWxBufferedControl.cpt"

#include <dk3all.h>

#include <wx/wxprec.h>
#ifdef __BORLANDC__
#pragma hdrstop
#endif
#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif

/**	This is a base class for triple-buffered views.
	Like double-buffering we write the windows contents
	to an image and finally transfer the entire image
	to the device context.
	Additionally we keep the image between the paint events
	and rebuild the image only if necessary (data to show
	has changed).

	When the frame containing your view becomes invisible
	(frame iconized or hidden) you should use the releaseBuffer()
	method to decrease the memory footprint of the program.

	In your derived class, call the DkWxBufferedControl constructors from
	the constructors.
	From Create() call DkWxBufferedControl::Create().

	You should also use DECLARE_DYNAMIC_CLASS() and
	IMPLEMENT_DYNAMIC_CLASS().
*/
class DkWxBufferedControl : public wxControl
{
  private:

    /**	Avoid simultaneous access from multiple threads.
    */
    wxMutex	 mxProtectData;

    /**	Bitmap for buffered drawing operations.
    */
    wxBitmap	*pBitmap;

    /**	Flag: Must redraw.
    */
    bool	 bMustDraw;

    /**	Bitmap width, window width.
    */
    int		 iWidth;

    /**	Bitmap height, window height.
    */
    int		 iHeight;

    /**	For RTTI.
    */
    DECLARE_DYNAMIC_CLASS(DkWxBufferedControl)

    /**	Event table.
    */
    DECLARE_EVENT_TABLE()

  protected:

    static wxChar const DkWxBufferedControlName[];

    /**	Internal method to paint.
    	This method saves some DC attributes and restores them
	before returning.
    	@param	pdc		Device context to draw to.
	@param	event		Paint event to process.
	@param	buffered	Flag: Operating on a memory DC.
	@param	clWidth		Client area width.
	@param	clHeight	Client area height.
    */
    void InternalPaint(
      wxDC &		pdc,
      wxPaintEvent &	event,
      bool		buffered,
      int		clWidth,
      int		clHeight
    );

  public:

    /**	Default constructor.
    */
    DkWxBufferedControl();

    /**	Constructor.
    	@param	pParent		Parent window.
	@param	wid		Window ID
	@param	pos		Window position.
	@param	size		Window size.
	@param	style		Window style.
	@param	validator	Validator for control.
	@param	name		Window type name.
    */
    DkWxBufferedControl(
      wxWindow 			*pParent,
      wxWindowID		 wid = wxID_ANY,
      const wxPoint &		 pos = wxDefaultPosition,
      const wxSize  &		 size = wxDefaultSize,
      long			 style = 0L,
      const wxValidator &	 validator = wxDefaultValidator,
      wxChar const		*name = DkWxBufferedControlName
    );

    /**	Create after using the default constructor.
    	@param	pParent		Parent window.
	@param	wid		Window ID
	@param	pos		Window position.
	@param	size		Window size.
	@param	style		Window style.
	@param	validator	Validator for control.
	@param	name		Window type name.
    */
    bool
    Create(
      wxWindow 			*pParent,
      wxWindowID		 wid = wxID_ANY,
      const wxPoint &		 pos = wxDefaultPosition,
      const wxSize  &		 size = wxDefaultSize,
      long			 style = 0L,
      const wxValidator	&	 validator = wxDefaultValidator,
      const wxChar		*name = DkWxBufferedControlName
    );

    /**	Destructor.
    */
    ~DkWxBufferedControl();

    /**	Indicate that data has changed so on next
    	paint we must rebuild the bitmap.
	@param	flag:	Flag to turn bMustDraw on or off.
    */
    void
    SetMustUpdate(bool flag = true);

    /**	Release bitmap buffer. This function should be called
    	when the frame or dialog containing this view is iconized
	or hidden.
    */
    void
    releaseBuffer(void);

    /**	Handler for erase background event.
    	@param	event	Event to process.
    */
    void
    OnErase(wxEraseEvent & event);

    /**	Handler for paint event.
    	@param	event	Event to process.
    */
    void
    OnPaint(wxPaintEvent & event);

    /**	Overwrite this method to do the real drawing.
    	@param	pdc		Device context to draw to.
				Normally a memory dc, but may be a direct
				dc in special situations (failed to allocate
				bitmap).
	@param	event		Paint event to process.
	@param	buffered	Flag: Operating on a memory DC.
	@param	clWidth		Client area width.
	@param	clHeight	Client area height.
    */
    virtual
    void PaintOperation(
      wxDC &		pdc,
      wxPaintEvent &	event,
      bool		buffered,
      int		clWidth,
      int		clHeight
    );

};


#endif
