/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: DkWxBufferedControl.cpt
*/

/*
Copyright (C) 2013, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file DkWxBufferedControl.cpp The DkWxBufferedControl module.
*/


#line 188 "DkWxBufferedControl.cpt"



#include "DkWxBufferedControl.h"




#line 195 "DkWxBufferedControl.cpt"



wxChar const DkWxBufferedControl::DkWxBufferedControlName[] = {
  wxT("DkWxBufferedControl")
};


IMPLEMENT_DYNAMIC_CLASS(DkWxBufferedControl, wxControl)

BEGIN_EVENT_TABLE(DkWxBufferedControl,wxControl)
	EVT_ERASE_BACKGROUND(DkWxBufferedControl::OnErase)
	EVT_PAINT(DkWxBufferedControl::OnPaint)
END_EVENT_TABLE()



DkWxBufferedControl::DkWxBufferedControl()
{
  

#line 215 "DkWxBufferedControl.cpt"
  pBitmap = NULL;
  iWidth = -1;
  iHeight = -1;
  bMustDraw = true;
  SetBackgroundStyle(wxBG_STYLE_CUSTOM);
  

#line 221 "DkWxBufferedControl.cpt"
}



bool
DkWxBufferedControl::Create(
  wxWindow 		*pParent,
  wxWindowID	 	 wid,
  const wxPoint &	 pos,
  const wxSize  &	 size,
  long		 	 style,
  const wxValidator &	 validator,
  wxChar const		*name
)
{
  bool back;
  back = wxControl::Create(
    pParent, wid, pos, size, style, validator, wxString(name)
  );
  pBitmap = NULL;
  iWidth = -1;
  iHeight = -1;
  bMustDraw = true;
  SetBackgroundStyle(wxBG_STYLE_CUSTOM);
  return back;
}



DkWxBufferedControl::DkWxBufferedControl(
  wxWindow 		*pParent,
  wxWindowID	 	 wid,
  const wxPoint &	 pos,
  const wxSize  &	 size,
  long		 	 style,
  const wxValidator &	 validator,
  wxChar const		*name
)
: wxControl(
  pParent,
  wid,
  pos,
  size,
  style,
  validator,
  wxString(name)
)
{
  

#line 270 "DkWxBufferedControl.cpt"
  pBitmap = NULL;
  iWidth = -1;
  iHeight = -1;
  bMustDraw = true;
  SetBackgroundStyle(wxBG_STYLE_CUSTOM);
  

#line 276 "DkWxBufferedControl.cpt"
}



DkWxBufferedControl::~DkWxBufferedControl()
{
  

#line 283 "DkWxBufferedControl.cpt"
  {
    wxMutexLocker	lock(mxProtectData);
    if(NULL != pBitmap) {		

#line 286 "DkWxBufferedControl.cpt"
      delete(pBitmap);
      pBitmap = NULL;
    }
    iWidth = -1;
    iHeight = -1;
    bMustDraw = false;
  }
  

#line 294 "DkWxBufferedControl.cpt"
}



void
DkWxBufferedControl::OnErase(wxEraseEvent & event)
{
  

#line 302 "DkWxBufferedControl.cpt"
  /* Do nothing here. */
  

#line 304 "DkWxBufferedControl.cpt"
}



void
DkWxBufferedControl::OnPaint(wxPaintEvent & event)
{
  bool		mustdraw = false;
  bool		done = false;
  int		w = 0;
  int		h = 0;
  

#line 316 "DkWxBufferedControl.cpt"
  wxPaintDC	paintDC(this);
  {
    wxMutexLocker lock(mxProtectData);
    w = iWidth;
    h = iHeight;
    wxSize sz = GetClientSize();
    if(NULL != pBitmap) {
      if((iWidth != sz.x) || (iHeight != sz.y)) {
        delete(pBitmap);	

#line 325 "DkWxBufferedControl.cpt"
	pBitmap = NULL;
	mustdraw = true;	

#line 327 "DkWxBufferedControl.cpt"
      }
    }
    w = iWidth = sz.x; h = iHeight = sz.y;
    if(NULL == pBitmap) {		

#line 331 "DkWxBufferedControl.cpt"
      pBitmap = new wxBitmap(iWidth, iHeight);
      mustdraw = true;		

#line 333 "DkWxBufferedControl.cpt"
    }
    if(NULL != pBitmap) {	

#line 335 "DkWxBufferedControl.cpt"
      if(false == mustdraw) {
        if(bMustDraw) {		

#line 337 "DkWxBufferedControl.cpt"
	  mustdraw = true;
	}
      }
      if(mustdraw) {		

#line 341 "DkWxBufferedControl.cpt"
	wxMemoryDC	memDC;
	memDC.SelectObject(*pBitmap);
	InternalPaint(memDC, event, true, w, h);
	memDC.SelectObject(wxNullBitmap);
        bMustDraw = false;	

#line 346 "DkWxBufferedControl.cpt"
      } else {			

#line 347 "DkWxBufferedControl.cpt"
      }
      paintDC.DrawBitmap(*pBitmap, 0, 0, false);
      done = true;
    }
  }
  if(!(done)) {			

#line 353 "DkWxBufferedControl.cpt"
    InternalPaint(paintDC, event, false, w, h);
  } 

#line 355 "DkWxBufferedControl.cpt"
}



void
DkWxBufferedControl::PaintOperation(
  wxDC &		pdc,
  wxPaintEvent &	event,
  bool			buffered,
  int			clWidth,
  int			clHeight
)
{
  /* The default implementation intentionally does nothing. */
}



void
DkWxBufferedControl::InternalPaint(
  wxDC &		pdc,
  wxPaintEvent &	event,
  bool			buffered,
  int			clWidth,
  int			clHeight
)
{
  wxBrush	const	br	=	pdc.GetBrush();
  wxBrush	const	bg	=	pdc.GetBackground();
  wxFont	const	fn	=	pdc.GetFont();
  wxPen		const	pn	=	pdc.GetPen();
  wxColour	const	tbg	=	pdc.GetTextBackground();
  wxColour	const	tfg	=	pdc.GetTextForeground();
  int			bgm	=	pdc.GetBackgroundMode();
  

#line 390 "DkWxBufferedControl.cpt"
  PaintOperation(pdc, event, buffered, clWidth, clHeight);

  pdc.SetBackgroundMode(bgm);
  pdc.SetTextForeground(tfg);
  pdc.SetTextBackground(tbg);
  pdc.SetPen(pn);
  pdc.SetFont(fn);
  pdc.SetBackground(bg);
  pdc.SetBrush(br);
  

#line 400 "DkWxBufferedControl.cpt"
}



void
DkWxBufferedControl::SetMustUpdate(bool flag)
{
  

#line 408 "DkWxBufferedControl.cpt"
  {
    wxMutexLocker	lock(mxProtectData);
    bMustDraw = flag;
  }
  

#line 413 "DkWxBufferedControl.cpt"
}



void
DkWxBufferedControl::releaseBuffer(void)
{
  

#line 421 "DkWxBufferedControl.cpt"
  {
    wxMutexLocker	lock(mxProtectData);
    if(pBitmap) {		

#line 424 "DkWxBufferedControl.cpt"
      delete(pBitmap);
      pBitmap = NULL;
    }
  } 

#line 428 "DkWxBufferedControl.cpt"
}

