/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: DkWxBmepsThread.cpt
*/

/*
Copyright (C) 2011, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file DkWxBmepsThread.h Header file for the DkWxBmepsThread module.
*/

#ifndef DKWXBMEPSTHREAD_H_INCLUDED
/** Avoid multiple inclusions. */
#define DKWXBMEPSTHREAD_H_INCLUDED 1


#line 9 "DkWxBmepsThread.cpt"


/**	Worker thread for wxbmeps.
*/
class DkWxBmepsThread : public wxThread
{
  protected:

    /**	Conversion options.
    */
    dk3_bm_eps_options_t	bmeo;

    /**	Communication object to communicate with main thread.
    */
    DkWxCommunicator		*pComm;

    /**	Localized messages, wxChar strings.
    */
    wxChar const * const	*sTexts;

    /**	Localized messages, dkChar strings.
    */
    dkChar const * const	*msg;

    /**	Directory or file name.
    */
    wxChar const		*sDirectory;

    /**	Application helper.
    */
    DkWxAppHelper		*pHelper;

    /**	Encoding for wxChar strings.
    */
    int			 	 wxenc;

    /**	Encoding for dkChar strings.
    */
    int				 dkenc;

  public:

    /**	Constructor.
    	@param	pc	Communication object.
	@param	st	Localized messages, wxChar strings.
	@param	m	Localized messages, dkChar strings.
	@param	sd	Directory or file name.
	@param	ph	Application helper.
	@param	wxe	Encoding for wxChar strings.
	@param	dke	Encoding for dkChar strings.
	@param	bmeoptr	Conversion options.
    */
    DkWxBmepsThread(
      DkWxCommunicator		*pc,
      wxChar const * const	*st,
      dkChar const * const	*m,
      wxChar const		*sd,
      DkWxAppHelper		*ph,
      int			 wxe,
      int			 dke,
      dk3_bm_eps_options_t	*bmeoptr
    );

    /**	Destructor.
    */
    ~DkWxBmepsThread();

    /**	Check setup (memory allocations succeeded).
    	@return	Test result, true on success, false on error.
    */
    bool
    checkSetup();

    /**	Thread function.
    	@return	A pointer which is ignored.
    */
    virtual
    void *
    Entry();

    /**	Function executed at end of thread, does nothing.
    */
    virtual
    void
    OnExit();

    /**	Run for one file.
    	@param	fn	File name.
	@param	ming	Minimum value for progress bar.
	@param	maxg	Maximum value for progress bar.
    */
    void
    runForFile(wxChar const *fn, int ming, int maxg);

    /**	Run for one directory.
    	@param	dn	Directory name.
    */
    void
    runForDirectory(wxChar const *dn);

    /**	Check whether we must run for a file.
    	@param	sfn	Source file name.
	@return	true for must run, false for not necessary.
    */
    bool
    checkMustRun(wxChar const *sfn);

    /**	Get short file name.
    	@param	longName	Full file name.
	@return	Pointer to short file name on success, NULL on error.
    */
    wxChar const *
    shortFileName(wxChar const *longName);
};




#endif
