/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: DkWxBmepsThread.cpt
*/

/*
Copyright (C) 2011, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file DkWxBmepsThread.cpp The DkWxBmepsThread module.
*/


#line 127 "DkWxBmepsThread.cpt"

#include "wxbmeps.h"



#line 131 "DkWxBmepsThread.cpt"



/**	File name separator.
*/
static wxChar const	dkwxbmeps_fnsep[] = {
DK3_WX_CHAR_SEP , wxT('\0')
};



static wxChar const * const	dkwxbmeps_output_suffixes[] = {
wxT(".ps"),
wxT(".eps"),
wxT(".pdf"),
wxT(".bb")
};




/**	Non-localized  keywords used by this module.
*/
static wxChar const * const	dkwxbmeps_thread_kw[] = {
/* 0 */
wxT("*.*"),

NULL


#line 161 "DkWxBmepsThread.cpt"
};



/**	File suffixes we can handle.
*/
static wxChar const * const	dkwxbmeps_thread_suffixes[] = {
#if DK3_HAVE_PNG_H
wxT(".png"),
#endif
#if DK3_HAVE_JPEGLIB_H
wxT(".jpg"),
wxT(".jpeg"),
#endif
#if DK3_HAVE_TIFF_H
wxT(".tif"),
wxT(".tiff"),
#endif
NULL
};



DkWxBmepsThread::DkWxBmepsThread(
      DkWxCommunicator		*pc,
      wxChar const * const	*st,
      dkChar const * const	*m,
      wxChar const		*sd,
      DkWxAppHelper		*ph,
      int			 wxe,
      int			 dke,
      dk3_bm_eps_options_t	*bmeoptr
)
{
  

#line 196 "DkWxBmepsThread.cpt"
  pComm = pc;
  sTexts = st;
  msg = m;
  sDirectory = dk3wxs_dup_app(sd, ph->getApp());
  pHelper = ph;
  wxenc = wxe;
  dkenc = dke;
  dk3mem_cpy((void *)(&bmeo), (void *)bmeoptr, sizeof(dk3_bm_eps_options_t));
  bmeo.to_stdout = 0;
  

#line 206 "DkWxBmepsThread.cpt"
}



bool
DkWxBmepsThread::checkSetup()
{
  bool		back = false;
  

#line 215 "DkWxBmepsThread.cpt"
  if(sDirectory) {
    back = true;
  } 

#line 218 "DkWxBmepsThread.cpt"
  return back;
}



DkWxBmepsThread::~DkWxBmepsThread()
{
  

#line 226 "DkWxBmepsThread.cpt"
  dk3_release(sDirectory);
  

#line 228 "DkWxBmepsThread.cpt"
}



void *
DkWxBmepsThread::Entry()
{
#if 0
  /*
	Simple test thread without practical use.
  */
  int	i = 0;
  int	cc = 1;
  int	numbreak = -1;
  do {
    this->Sleep(100);
    i++;
    if(i >= 10) {
      cc = 0;
    }
    pComm->setUpdates(wxT("test-file"), (100*i));
    if(pComm->getCanContinue() == 0) {
      if(numbreak == -1) {
        numbreak = i;
      } else {
        if(i >= numbreak + 15) {
	  cc = 0;
	}
      }
    }
    pComm->addWxText(wxT("Test mit einer ganz ganz ganz ganz langen Zeile\n"));
  } while(cc);
  pComm->setRunning(0);
#else
  

#line 263 "DkWxBmepsThread.cpt"
  if(wxFileName::DirExists(sDirectory)) {	

#line 264 "DkWxBmepsThread.cpt"
    runForDirectory(sDirectory);
  } else {					

#line 266 "DkWxBmepsThread.cpt"
    if(wxFileName::FileExists(sDirectory)) {	

#line 267 "DkWxBmepsThread.cpt"
      runForFile(sDirectory, 0, 1000);
    } else {					

#line 269 "DkWxBmepsThread.cpt"
      /* ##### ERROR: No such file or directory! */
    }
  }
  pComm->setRunning(0); 

#line 273 "DkWxBmepsThread.cpt"
#endif
  return NULL;
}



void
DkWxBmepsThread::OnExit()
{
  /* Doing nothing. */
  

#line 284 "DkWxBmepsThread.cpt"
}



/**	Compare two wxChar file names.
	@param	l	Left file name.
	@param	r	Right file name.
	@param	cr	Comparison criteria (ignored).
	@return	Comparison result.
*/
static
int
dkwxbmeps_compare_filenames(void const *l, void const *r, int cr)
{
  int		back	= 0;
  if(l) {
    if(r) {
#if DK3_HAVE_FNCASEINS
      back = dk3wxs_casecmp((wxChar const *)l, (wxChar const *)r);
#else
      back = dk3wxs_cmp((wxChar const *)l, (wxChar const *)r);
#endif
      if(back < -1) back = -1;
      if(back >  1) back =  1;
    } else {
      back = 1;
    }
  } else {
    if(r) {
      back = -1;
    }
  }
  return back;
}



void
DkWxBmepsThread::runForFile(wxChar const *fn, int ming, int maxg)
{
  dkChar	 sfn[DK3_MAX_PATH];
  wxChar const	*shortname;
  

#line 327 "DkWxBmepsThread.cpt"
  shortname = shortFileName(fn);
  if(dk3wxs_to_dkstr(
      sfn,
      DK3_SIZEOF(sfn,dkChar),
      pHelper->getDkEncoding(),
      fn,
      pHelper->getWxEncoding()
    )
  )
  {
    /* PROGRESS MESSAGE Start */
    pComm->addWxText(sTexts[114]);
    pComm->addWxText(shortname);
    pComm->addWxText(sTexts[115]);
    pComm->addWxText(sTexts[110]);
    (void)dk3bm_process_file_name(
      &bmeo,
      sfn,
      DK3_BIF_IMAGE_TYPE_UNKNOWN,
      ming,
      maxg,
      (void *)pComm
    );
    /* PROGRESS MESSAGE Finished */
#if 0
    pComm->addWxText(sTexts[116]);
    pComm->addWxText(shortname);
    pComm->addWxText(sTexts[117]);
    pComm->addWxText(sTexts[110]);
#endif
    pComm->addWxText(sTexts[110]);
  } else { 

#line 359 "DkWxBmepsThread.cpt"
    /* ERROR: Failed to convert file name! */
    pComm->addWxText(sTexts[118]);
    pComm->addWxText(shortname);
    pComm->addWxText(sTexts[119]);
    pComm->addWxText(sTexts[110]);
    pComm->setLogLevel(DK3_LL_ERROR);
  }
  pComm->setUpdates(NULL, maxg);
  

#line 368 "DkWxBmepsThread.cpt"
}






void
DkWxBmepsThread::runForDirectory(wxChar const *dn)
{
  wxChar		namein[DK3_MAX_PATH];
  wxChar const		*currentfn;
  wxChar const		*cfilename;
  wxChar		*suffix;
  dk3_sto_t		*sFiles;
  dk3_sto_it_t		*iFiles;
  size_t		fnlgt;
  int			namesFound;
  int			i;
  int			promille;
  int			cc;

  

#line 391 "DkWxBmepsThread.cpt"
  pComm->addWxText(sTexts[106]);
  pComm->addWxText(dn);
  pComm->addWxText(sTexts[107]);
  pComm->addWxText(sTexts[110]);
  pComm->addWxText(sTexts[110]);
  sFiles = dk3sto_open_app(pHelper->getApp());
  if(sFiles) {
    dk3sto_set_comp(sFiles, dkwxbmeps_compare_filenames, 0);
    iFiles = dk3sto_it_open(sFiles);
    if(iFiles) {
      /*
      	Find all input filename candidates.
      */
      namesFound = 0;
      {
        wxLogNull	lognull;
	bool		canContinue;
        wxDir directory(sDirectory);
	if(directory.IsOpened()) {
	  wxString	filename;
	  canContinue = directory.GetFirst(
	    &filename, dkwxbmeps_thread_kw[0], wxDIR_FILES
	  );
	  while(canContinue) {
	    cfilename = filename.c_str();
	    if(cfilename) {
	      if(dk3wxs_len(cfilename) < DK3_SIZEOF(namein,wxChar)) {
	        dk3wxs_cpy(namein, cfilename);
		suffix = dk3wxs_get_suffix(namein);
		if(suffix) {
		  if(dk3wxs_array_index(dkwxbmeps_thread_suffixes,suffix,0)
		     > -1
		  )
		  {
		    suffix = dk3wxs_dup_app(namein, pHelper->getApp());
		    if(suffix) {
		      if(dk3sto_add(sFiles, suffix)) {
		        namesFound++; 

#line 429 "DkWxBmepsThread.cpt"
		      } else {
		        /* ERROR: Memory */
			dk3_release(suffix);
			pComm->addWxText(sTexts[105]);
			pComm->addWxText(sTexts[110]);
			pComm->setLogLevel(DK3_LL_ERROR);
		      }
		    } else {
		      /* ERROR: Memory */
		      pComm->addWxText(sTexts[105]);
		      pComm->addWxText(sTexts[110]);
		      pComm->setLogLevel(DK3_LL_ERROR);
		    }
		  }
		}
	      } else {
	        /* ERROR: Name too long! */
		pComm->addWxText(sTexts[111]);
		pComm->addWxText(cfilename);
		pComm->addWxText(sTexts[112]);
		pComm->addWxText(sTexts[110]);
		pComm->setLogLevel(DK3_LL_ERROR);
	      }
	    }
	    canContinue = directory.GetNext(&filename);
	  }
	}
      }
      pComm->setUpdates(NULL, 50);
      /*
      	Process all input file name candidates.
      */
      if(namesFound > 0) {
        dk3sto_it_reset(iFiles);
	i = 0; cc = 1;
	do {
	  cc = 0;
	  cfilename = (wxChar const *)dk3sto_it_next(iFiles);
	  if(cfilename) {
	    cc = 1;
	    promille = 50 + (950 * i )/namesFound;
	    if(promille >= 1000) { promille = 999; }
	    pComm->setUpdates(cfilename, promille);
	    

#line 473 "DkWxBmepsThread.cpt"
	    fnlgt = dk3wxs_len(sDirectory);
	    fnlgt += dk3wxs_len(cfilename);
	    fnlgt += 1;
	    if(fnlgt < DK3_SIZEOF(namein,wxChar)) {
	      dk3wxs_cpy(namein, sDirectory);
	      dk3wxs_cat(namein, dkwxbmeps_fnsep);
	      dk3wxs_cat(namein, cfilename);
	      if(checkMustRun(namein)) {
	        runForFile(
	          namein,
		  50 + (950 * i )/namesFound,
		  50 + (950 * (i + 1))/namesFound
	        );
	      }
	    } else {
	      /* ERROR: File name too long for buffer */
	      pComm->addWxText(sTexts[111]);
	      pComm->addWxText(sDirectory);
	      pComm->addWxText(dkwxbmeps_fnsep);
	      pComm->addWxText(cfilename);
	      pComm->addWxText(sTexts[112]);
	      pComm->addWxText(sTexts[110]);
	      pComm->setLogLevel(DK3_LL_ERROR);
	    }
	    i++;
	    promille = 50 + (950 * i )/namesFound;
	    if(promille >= 1000) { promille = 999; }
	    pComm->setUpdates(cfilename, promille);
	    if(!(pComm->getCanContinue())) {
	      cc = 0;
	    }
	  }
	} while(cc);
	pComm->setUpdates(cfilename, 1000);
      } else {
        /* ERROR: No names found! */
	pComm->addWxText(sTexts[113]);
	pComm->addWxText(sTexts[110]);
	pComm->setLogLevel(DK3_LL_ERROR);
      }
      /*
      	Release the file names.
      */
      dk3sto_it_reset(iFiles);
      while((currentfn = (wxChar const *)dk3sto_it_next(iFiles)) != NULL) {
        dk3_release(currentfn);
      }
      dk3sto_it_close(iFiles);
    } else {
      pComm->addWxText(sTexts[105]);
      pComm->addWxText(sTexts[110]);
      pComm->setLogLevel(DK3_LL_ERROR);
    }
    dk3sto_close(sFiles);
  } else {
    pComm->addWxText(sTexts[105]);
    pComm->addWxText(sTexts[110]);
    pComm->setLogLevel(DK3_LL_ERROR);
  }
  pComm->addWxText(sTexts[108]);
  pComm->addWxText(dn);
  pComm->addWxText(sTexts[109]);
  pComm->addWxText(sTexts[110]);
  

#line 537 "DkWxBmepsThread.cpt"
}



bool
DkWxBmepsThread::checkMustRun(wxChar const *sfn)
{
  wxChar	nameout[DK3_MAX_PATH];
  wxChar	*suffix;
  wxChar const	*nsuffix;
  bool		back	= true;
  if(bmeo.make) {
    dk3wxs_cpy(nameout, sfn);
    suffix = dk3wxs_get_suffix(nameout);
    if(suffix) {
      *suffix = wxT('\0');
      nsuffix = NULL;
      switch(bmeo.dr) {
        case DK3_BMEPS_DRIVER_PS: {
	  nsuffix = dkwxbmeps_output_suffixes[0];
	} break;
	case DK3_BMEPS_DRIVER_EPS: {
	  nsuffix = dkwxbmeps_output_suffixes[1];
	} break;
	case DK3_BMEPS_DRIVER_PDF: {
	  nsuffix = dkwxbmeps_output_suffixes[2];
	} break;
	case DK3_BMEPS_DRIVER_BB: {
	  nsuffix = dkwxbmeps_output_suffixes[3];
	} break;
      }
      if(nsuffix) {
        if((dk3wxs_len(nameout) + dk3wxs_len(nsuffix))
	   < DK3_SIZEOF(nameout,wxChar)
	)
	{
	  dk3wxs_cat(nameout, nsuffix);
	  if(wxFileName::FileExists(sfn)) {
	    if(wxFileName::FileExists(nameout)) {
	      wxFileName	fni(sfn);
	      wxFileName	fno(nameout);
	      if(fno.GetModificationTime() > fni.GetModificationTime()) {
	        back = false;
	      }
	    }
	  } else {
	    /* ##### BUG: Source file does not exist, should not happen. */
	  }
	} else {
	  /* ##### ERROR: Name too long! */
	}
      } else {		

#line 589 "DkWxBmepsThread.cpt"
        /* BUG: Illegal output driver, should not happen. */
      }
    }
  }
  return back;
}



wxChar const *
DkWxBmepsThread::shortFileName(wxChar const *longName)
{
  wxChar const	*back	= NULL;
  wxChar const	*ptr;

  if(longName) {
    ptr = longName;
    while(*ptr) {
      if(*ptr == DK3_WX_CHAR_SEP) {
        back = ptr;
      }
      ptr++;
    }
    if(back) { back++; }
    else { back = longName; }
  }
  return back;
}


