/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: DkWxBmepsOptionsDialog.wxc
*/

/*
Copyright (C) 2011, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file DkWxBmepsOptionsDialog.h Header file for the DkWxBmepsOptionsDialog module.
*/

#ifndef DKWXBMEPSOPTIONSDIALOG_H_INCLUDED
/** Avoid multiple inclusions. */
#define DKWXBMEPSOPTIONSDIALOG_H_INCLUDED 1


#line 219 "DkWxBmepsOptionsDialog.wxc"


#line 221 "DkWxBmepsOptionsDialog.wxc"



/**	Options dialog for the wxbmpp program.
*/
class DkWxBmepsOptionsDialog : public wxDialog
{

  private:

    /**	Flag: Already in correction, do not enter correction again.
    */
    bool			 bIsCorrecting;

    /**	Event table.
    */
    DECLARE_EVENT_TABLE()
  
  protected:

    /**	Application helper object.
    */
    DkWxAppHelper		*pHelper;

    /**	Localized texts.
    */
    wxChar const * const	*sTexts;

    /**	Paper size names.
    */
    wxArrayString		*arrayStringPaperSizeNames;

    /**	Conversion options.
    */
    dk3_bm_eps_options_t	*bmepsOptions;

    /**	Paper sizes in PS points.
    */
    dk3_paper_size_t		*paperSizes;

    /**	Pointer to variable for selected paper size.
    */
    size_t			*selectedPaperSize;

    /** Encoding of dkChar.
    */
    int				 dke;

    /**	Encoding of wxChar.
    */
    int				 wxe;

    /**	Handler for OK button.
    	@param	event	Event to process.
    */
    void
    OnOK(wxCommandEvent& WXUNUSED(event));

    /**	Handler for Cancel button.
    	@param	event	Event to process.
    */
    void
    OnCancel(wxCommandEvent& WXUNUSED(event));

    /**	Handler for output format change.
    	@param	event	Event to process.
    */
    void
    OnOutputFormat(wxCommandEvent & event);

    /**	Handler for output type change.
    	@param	event	Event to process.
    */
    void
    OnOutputType(wxCommandEvent & event);

    /**	Handler for resolution change.
    	@param	event	Event to process.
    */
    void
    OnResolution(wxCommandEvent & event);

    /**	Handler changed draft setting.
    	@param	event	Event to process.
    */
    void
    OnDraft(wxCommandEvent & event);

    /**	Handler for changed PS level.
    	@param	event	Event to process.
    */
    void
    OnPsLevel(wxCommandEvent & event);

    /**	Handler changed interpolation setting.
    	@param	event	Event to process.
    */
    void
    OnInterpolation(wxCommandEvent & event);

    /**	Correct GUI (enable/disable elements based on last decision).
    */
    void
    correctGUI();


    /**	Flag: GUI ok.
    */
    bool dkctGUILayoutOK;

    /**	GUI element sDialog.
    */
#line 12 "DkWxBmepsOptionsDialog.wxc"
    wxBoxSizer *sDialog;

    /**	GUI element verticalSizer.
    */
#line 18 "DkWxBmepsOptionsDialog.wxc"
    wxBoxSizer *verticalSizer;

    /**	GUI element sSetup.
    */
#line 27 "DkWxBmepsOptionsDialog.wxc"
    wxGridBagSizer *sSetup;

    /**	GUI element sButtons.
    */
#line 201 "DkWxBmepsOptionsDialog.wxc"
    wxStdDialogButtonSizer *sButtons;

    /**	GUI element sttGeneral.
    */
#line 70 "DkWxBmepsOptionsDialog.wxc"
    wxStaticText *sttGeneral;

    /**	GUI element cbMakeMode.
    */
#line 73 "DkWxBmepsOptionsDialog.wxc"
    wxCheckBox *cbMakeMode;

    /**	GUI element sttOutput.
    */
#line 78 "DkWxBmepsOptionsDialog.wxc"
    wxStaticText *sttOutput;

    /**	GUI element sttOutputDetails.
    */
#line 151 "DkWxBmepsOptionsDialog.wxc"
    wxStaticText *sttOutputDetails;

    /**	GUI element sttOutputFormat.
    */
#line 81 "DkWxBmepsOptionsDialog.wxc"
    wxStaticText *sttOutputFormat;

    /**	GUI element cobOutputFormat.
    */
#line 85 "DkWxBmepsOptionsDialog.wxc"
    wxChoice *cobOutputFormat;

    /**	GUI element cbDraft.
    */
#line 91 "DkWxBmepsOptionsDialog.wxc"
    wxCheckBox *cbDraft;

    /**	GUI element sttPsLevel.
    */
#line 154 "DkWxBmepsOptionsDialog.wxc"
    wxStaticText *sttPsLevel;

    /**	GUI element cobPsLevel.
    */
#line 157 "DkWxBmepsOptionsDialog.wxc"
    wxChoice *cobPsLevel;

    /**	GUI element cbDsc.
    */
#line 162 "DkWxBmepsOptionsDialog.wxc"
    wxCheckBox *cbDsc;

    /**	GUI element sttOutputType.
    */
#line 96 "DkWxBmepsOptionsDialog.wxc"
    wxStaticText *sttOutputType;

    /**	GUI element cobOutputType.
    */
#line 99 "DkWxBmepsOptionsDialog.wxc"
    wxChoice *cobOutputType;

    /**	GUI element sttPredictor.
    */
#line 166 "DkWxBmepsOptionsDialog.wxc"
    wxStaticText *sttPredictor;

    /**	GUI element cobPredictor.
    */
#line 170 "DkWxBmepsOptionsDialog.wxc"
    wxChoice *cobPredictor;

    /**	GUI element sttFinishing.
    */
#line 109 "DkWxBmepsOptionsDialog.wxc"
    wxStaticText *sttFinishing;

    /**	GUI element cobFinishing.
    */
#line 112 "DkWxBmepsOptionsDialog.wxc"
    wxChoice *cobFinishing;

    /**	GUI element cbDCT.
    */
#line 117 "DkWxBmepsOptionsDialog.wxc"
    wxCheckBox *cbDCT;

    /**	GUI element cbBpc.
    */
#line 121 "DkWxBmepsOptionsDialog.wxc"
    wxCheckBox *cbBpc;

    /**	GUI element sttOutputSize.
    */
#line 125 "DkWxBmepsOptionsDialog.wxc"
    wxStaticText *sttOutputSize;

    /**	GUI element sttInterpolation.
    */
#line 174 "DkWxBmepsOptionsDialog.wxc"
    wxStaticText *sttInterpolation;

    /**	GUI element sttResolution.
    */
#line 128 "DkWxBmepsOptionsDialog.wxc"
    wxStaticText *sttResolution;

    /**	GUI element cobResolution.
    */
#line 132 "DkWxBmepsOptionsDialog.wxc"
    wxChoice *cobResolution;

    /**	GUI element txtResolution.
    */
#line 137 "DkWxBmepsOptionsDialog.wxc"
    wxTextCtrl *txtResolution;

    /**	GUI element cbInterNormal.
    */
#line 177 "DkWxBmepsOptionsDialog.wxc"
    wxCheckBox *cbInterNormal;

    /**	GUI element sttPaperSize.
    */
#line 142 "DkWxBmepsOptionsDialog.wxc"
    wxStaticText *sttPaperSize;

    /**	GUI element cobPaperSize.
    */
#line 146 "DkWxBmepsOptionsDialog.wxc"
    wxChoice *cobPaperSize;

    /**	GUI element cbInterJpeg.
    */
#line 182 "DkWxBmepsOptionsDialog.wxc"
    wxCheckBox *cbInterJpeg;

    /**	GUI element sttTransparency.
    */
#line 186 "DkWxBmepsOptionsDialog.wxc"
    wxStaticText *sttTransparency;

    /**	GUI element sttBackground.
    */
#line 189 "DkWxBmepsOptionsDialog.wxc"
    wxStaticText *sttBackground;

    /**	GUI element cvBackground.
    */
#line 193 "DkWxBmepsOptionsDialog.wxc"
    DkWxColorView *cvBackground;

    /**	GUI element cbForceBackground.
    */
#line 197 "DkWxBmepsOptionsDialog.wxc"
    wxCheckBox *cbForceBackground;

    /**	GUI element bOK.
    */
#line 206 "DkWxBmepsOptionsDialog.wxc"
    wxButton *bOK;

    /**	GUI element bCancel.
    */
#line 211 "DkWxBmepsOptionsDialog.wxc"
    wxButton *bCancel;


#line 328 "DkWxBmepsOptionsDialog.wxc"
  public:

    /**	Constructor.
    	@param	parent		Parent window.
	@param	title		Dialog box title.
	@param	messageTexts	Localized message texts.
	@param	asPaperSizes	Known paper size names.
	@param	opt	Conversion options.
	@param	pps	Known paper sizes array.
	@param	sps	Size of @arg pps (number of elements in array).
	@param	applicationHelper	Application helper object.
	@param	de	Character encoding used for dkChar strings.
	@param	we	Character encoding used for wxChar strings.
    */
    DkWxBmepsOptionsDialog(
      DkWxBmepsFrame		*parent,
      wxChar const		*title,
      wxChar const * const	*messageTexts,
      wxArrayString		*asPaperSizes,
      dk3_bm_eps_options_t	*opt,
      dk3_paper_size_t		*pps,
      size_t			*sps,
      DkWxAppHelper		*applicationHelper,
      int			 de,
      int			 we
    );

    /**	Transfer data from GUI controls to configuration structure.
    */
    void dataOut();

    /**	Transfer data from configuration structure to GUI controls.
    */
    void dataIn();

    /**	Restrict a number to a range.
    	@param	min	Range minimum.
	@param	max	Range maximum.
	@param	val	Value to use.
	@return	The value fitted into the range.
    */
    int
    intToRange(int min, int max, int val);

    /**	Set a wxChoice selection.
    	@param	ch	Choice to modify.
	@param	val	New selection index.
    */
    void
    setChoice(wxChoice *ch, int val);
};


#line 381 "DkWxBmepsOptionsDialog.wxc"



#endif
