/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: DkWxBmepsOptionsDialog.wxc
*/

/*
Copyright (C) 2011, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file DkWxBmepsOptionsDialog.cpp The DkWxBmepsOptionsDialog module.
*/


#line 384 "DkWxBmepsOptionsDialog.wxc"

#include	"wxbmeps.h"





#line 390 "DkWxBmepsOptionsDialog.wxc"

BEGIN_EVENT_TABLE(DkWxBmepsOptionsDialog, wxDialog)
  EVT_BUTTON(wxID_OK,			DkWxBmepsOptionsDialog::OnOK)
  EVT_BUTTON(wxID_CANCEL,		DkWxBmepsOptionsDialog::OnCancel)
  EVT_CHOICE(DkWxBmeps_OuputFormat,	DkWxBmepsOptionsDialog::OnOutputFormat)
  EVT_CHOICE(DkWxBmeps_OutputType,	DkWxBmepsOptionsDialog::OnOutputType)
  EVT_CHOICE(DkWxBmeps_ResolutionType,	DkWxBmepsOptionsDialog::OnResolution)
  EVT_CHECKBOX(DkWxBmeps_Draft,		DkWxBmepsOptionsDialog::OnDraft)
  EVT_CHOICE(DkWxBmeps_PsLevel,		DkWxBmepsOptionsDialog::OnPsLevel)
  EVT_CHECKBOX(DkWxBmeps_Interpolation,	DkWxBmepsOptionsDialog::OnInterpolation)
END_EVENT_TABLE()




#line 405 "DkWxBmepsOptionsDialog.wxc"
DkWxBmepsOptionsDialog::DkWxBmepsOptionsDialog(
  DkWxBmepsFrame	*parent,
  wxChar const		*title,
  wxChar const * const	*messageTexts,
  wxArrayString		*asPaperSizes,
  dk3_bm_eps_options_t	*opt,
  dk3_paper_size_t	*pps,
  size_t		*sps,
  DkWxAppHelper		*applicationHelper,
  int			 de,
  int			 we
) : wxDialog(
  parent,
  wxID_ANY,
  title,
  wxDefaultPosition,
  wxDefaultSize,
  wxDEFAULT_DIALOG_STYLE
)
{
  pHelper = applicationHelper;
  dke = de; wxe = we;
  arrayStringPaperSizeNames = asPaperSizes;
  bmepsOptions = opt;
  paperSizes = pps;
  selectedPaperSize = sps;
  bIsCorrecting = false;
  wxColour cRed(0x7F, 0x00, 0x00);
  wxString saOutputFormat[] = {
    wxString(messageTexts[42]),
    wxString(messageTexts[43]),
    wxString(messageTexts[44]),
    wxString(messageTexts[45])
  };
  wxString saOutputType[] = {
    wxString(messageTexts[47]),
    wxString(messageTexts[48]),
    wxString(messageTexts[49])
  };
  wxString saFinishing[] = {
    wxString(messageTexts[51]),
    wxString(messageTexts[52]),
    wxString(messageTexts[53])
  };
  wxString saResolution[] = {
    wxString(messageTexts[60]),
    wxString(messageTexts[61]),
    wxString(messageTexts[62])
  };
  wxString saPsLevel[] = {
    wxString(wxT("2")),
    wxString(wxT("3"))
  };
  wxString saPredictor[] = {
    wxString(messageTexts[76]),
    wxString(messageTexts[77]),
    wxString(messageTexts[78]),
    wxString(messageTexts[79]),
    wxString(messageTexts[80]),
    wxString(messageTexts[81])
  };
  sTexts = messageTexts;
  dkctGUILayoutOK = false;
  sDialog = NULL;
  verticalSizer = NULL;
  sSetup = NULL;
  sButtons = NULL;
  sttGeneral = NULL;
  cbMakeMode = NULL;
  sttOutput = NULL;
  sttOutputDetails = NULL;
  sttOutputFormat = NULL;
  cobOutputFormat = NULL;
  cbDraft = NULL;
  sttPsLevel = NULL;
  cobPsLevel = NULL;
  cbDsc = NULL;
  sttOutputType = NULL;
  cobOutputType = NULL;
  sttPredictor = NULL;
  cobPredictor = NULL;
  sttFinishing = NULL;
  cobFinishing = NULL;
  cbDCT = NULL;
  cbBpc = NULL;
  sttOutputSize = NULL;
  sttInterpolation = NULL;
  sttResolution = NULL;
  cobResolution = NULL;
  txtResolution = NULL;
  cbInterNormal = NULL;
  sttPaperSize = NULL;
  cobPaperSize = NULL;
  cbInterJpeg = NULL;
  sttTransparency = NULL;
  sttBackground = NULL;
  cvBackground = NULL;
  cbForceBackground = NULL;
  bOK = NULL;
  bCancel = NULL;
  sDialog = new wxBoxSizer(
    wxHORIZONTAL
  );
  if(!(sDialog)) {
    goto dkctGUILayoutFinished;
  }
  sDialog->Add(10, 10, 1);
  verticalSizer = new wxBoxSizer(
    wxVERTICAL
  );
  if(!(verticalSizer)) {
    goto dkctGUILayoutFinished;
  }
  verticalSizer->Add(10, 10, 1);
  sSetup = new wxGridBagSizer(
    5, 5
  );
  if(!(sSetup)) {
    goto dkctGUILayoutFinished;
  }
  sttGeneral = new wxStaticText(
    this,
    wxID_ANY,
    sTexts[37]
  );
  if(!(sttGeneral)) {
    goto dkctGUILayoutFinished;
  }
  sSetup->Add(
    sttGeneral,
    wxGBPosition(0, 0),
    wxGBSpan(1, 5),
    wxALIGN_LEFT
  );
  cbMakeMode = new wxCheckBox(
    this,
    wxID_ANY,
    sTexts[38]
  );
  if(!(cbMakeMode)) {
    goto dkctGUILayoutFinished;
  }
  cbMakeMode->SetToolTip(sTexts[39]);
  sSetup->Add(
    cbMakeMode,
    wxGBPosition(1, 0),
    wxGBSpan(1, 3),
    wxALIGN_LEFT
  );
  sSetup->Add(10, 1, wxGBPosition(1, 3), wxGBSpan(1, 1));
  sSetup->Add(1, 10, wxGBPosition(2, 0), wxGBSpan(1, 5));
  sttOutput = new wxStaticText(
    this,
    wxID_ANY,
    sTexts[40]
  );
  if(!(sttOutput)) {
    goto dkctGUILayoutFinished;
  }
  sSetup->Add(
    sttOutput,
    wxGBPosition(3, 0),
    wxGBSpan(1, 5),
    wxALIGN_LEFT
  );
  sSetup->Add(30, 1, wxGBPosition(3, 5), wxGBSpan(1, 1));
  sttOutputDetails = new wxStaticText(
    this,
    wxID_ANY,
    sTexts[73]
  );
  if(!(sttOutputDetails)) {
    goto dkctGUILayoutFinished;
  }
  sSetup->Add(
    sttOutputDetails,
    wxGBPosition(3, 6),
    wxGBSpan(1, 5),
    wxALIGN_LEFT
  );
  sttOutputFormat = new wxStaticText(
    this,
    wxID_ANY,
    sTexts[41],
    wxDefaultPosition,
    wxDefaultSize,
    wxALIGN_RIGHT
  );
  if(!(sttOutputFormat)) {
    goto dkctGUILayoutFinished;
  }
  sSetup->Add(
    sttOutputFormat,
    wxGBPosition(4, 0),
    wxGBSpan(1, 1),
    wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL
  );
  cobOutputFormat = new wxChoice(
    this,
    DkWxBmeps_OuputFormat,
    wxDefaultPosition,
    wxDefaultSize,
    4,
    saOutputFormat
  );
  if(!(cobOutputFormat)) {
    goto dkctGUILayoutFinished;
  }
  cobOutputFormat->SetToolTip(sTexts[91]);
  sSetup->Add(
    cobOutputFormat,
    wxGBPosition(4, 1),
    wxGBSpan(1, 2),
    wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL|wxGROW
  );
  cbDraft = new wxCheckBox(
    this,
    DkWxBmeps_Draft,
    sTexts[54]
  );
  if(!(cbDraft)) {
    goto dkctGUILayoutFinished;
  }
  cbDraft->SetToolTip(sTexts[55]);
  sSetup->Add(
    cbDraft,
    wxGBPosition(4, 4),
    wxGBSpan(1, 1),
    wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL
  );
  sttPsLevel = new wxStaticText(
    this,
    wxID_ANY,
    sTexts[74]
  );
  if(!(sttPsLevel)) {
    goto dkctGUILayoutFinished;
  }
  sSetup->Add(
    sttPsLevel,
    wxGBPosition(4, 6),
    wxGBSpan(1, 1),
    wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL
  );
  cobPsLevel = new wxChoice(
    this,
    DkWxBmeps_PsLevel,
    wxDefaultPosition,
    wxDefaultSize,
    2,
    saPsLevel
  );
  if(!(cobPsLevel)) {
    goto dkctGUILayoutFinished;
  }
  cobPsLevel->SetToolTip(sTexts[96]);
  sSetup->Add(
    cobPsLevel,
    wxGBPosition(4, 7),
    wxGBSpan(1, 1),
    wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL
  );
  sSetup->Add(10, 1, wxGBPosition(4, 8), wxGBSpan(1, 1));
  cbDsc = new wxCheckBox(
    this,
    wxID_ANY,
    sTexts[82]
  );
  if(!(cbDsc)) {
    goto dkctGUILayoutFinished;
  }
  cbDsc->SetToolTip(sTexts[83]);
  sSetup->Add(
    cbDsc,
    wxGBPosition(4, 9),
    wxGBSpan(1, 1),
    wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL
  );
  sSetup->Add(10, 10, wxGBPosition(4, 10), wxGBSpan(1, 1));
  sttOutputType = new wxStaticText(
    this,
    wxID_ANY,
    sTexts[46]
  );
  if(!(sttOutputType)) {
    goto dkctGUILayoutFinished;
  }
  sSetup->Add(
    sttOutputType,
    wxGBPosition(5, 0),
    wxGBSpan(1, 1),
    wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL
  );
  cobOutputType = new wxChoice(
    this,
    DkWxBmeps_OutputType,
    wxDefaultPosition,
    wxDefaultSize,
    3,
    saOutputType
  );
  if(!(cobOutputType)) {
    goto dkctGUILayoutFinished;
  }
  cobOutputType->SetToolTip(sTexts[92]);
  sSetup->Add(
    cobOutputType,
    wxGBPosition(5, 1),
    wxGBSpan(1, 2),
    wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL|wxGROW
  );
  sttPredictor = new wxStaticText(
    this,
    wxID_ANY,
    sTexts[75],
    wxDefaultPosition,
    wxDefaultSize,
    wxALIGN_RIGHT
  );
  if(!(sttPredictor)) {
    goto dkctGUILayoutFinished;
  }
  sSetup->Add(
    sttPredictor,
    wxGBPosition(5, 6),
    wxGBSpan(1, 1),
    wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL
  );
  cobPredictor = new wxChoice(
    this,
    wxID_ANY,
    wxDefaultPosition,
    wxDefaultSize,
    6,
    saPredictor
  );
  if(!(cobPredictor)) {
    goto dkctGUILayoutFinished;
  }
  cobPredictor->SetToolTip(sTexts[97]);
  sSetup->Add(
    cobPredictor,
    wxGBPosition(5, 7),
    wxGBSpan(1, 3),
    wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL
  );
  sttFinishing = new wxStaticText(
    this,
    wxID_ANY,
    sTexts[50]
  );
  if(!(sttFinishing)) {
    goto dkctGUILayoutFinished;
  }
  sSetup->Add(
    sttFinishing,
    wxGBPosition(6, 0),
    wxGBSpan(1, 1),
    wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL
  );
  cobFinishing = new wxChoice(
    this,
    wxID_ANY,
    wxDefaultPosition,
    wxDefaultSize,
    3,
    saFinishing
  );
  if(!(cobFinishing)) {
    goto dkctGUILayoutFinished;
  }
  cobFinishing->SetToolTip(sTexts[93]);
  sSetup->Add(
    cobFinishing,
    wxGBPosition(6, 1),
    wxGBSpan(1, 2),
    wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL|wxGROW
  );
  cbDCT = new wxCheckBox(
    this,
    wxID_ANY,
    sTexts[89]
  );
  if(!(cbDCT)) {
    goto dkctGUILayoutFinished;
  }
  cbDCT->SetToolTip(sTexts[90]);
  sSetup->Add(
    cbDCT,
    wxGBPosition(6, 6),
    wxGBSpan(1, 4),
    wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL
  );
  cbBpc = new wxCheckBox(
    this,
    wxID_ANY,
    sTexts[120]
  );
  if(!(cbBpc)) {
    goto dkctGUILayoutFinished;
  }
  cbBpc->SetToolTip(sTexts[121]);
  sSetup->Add(
    cbBpc,
    wxGBPosition(7, 6),
    wxGBSpan(1, 4),
    wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL
  );
  sSetup->Add(1, 10, wxGBPosition(8, 0), wxGBSpan(1, 5));
  sttOutputSize = new wxStaticText(
    this,
    wxID_ANY,
    sTexts[58]
  );
  if(!(sttOutputSize)) {
    goto dkctGUILayoutFinished;
  }
  sSetup->Add(
    sttOutputSize,
    wxGBPosition(9, 0),
    wxGBSpan(1, 5),
    wxALIGN_LEFT
  );
  sttInterpolation = new wxStaticText(
    this,
    wxID_ANY,
    sTexts[64]
  );
  if(!(sttInterpolation)) {
    goto dkctGUILayoutFinished;
  }
  sSetup->Add(
    sttInterpolation,
    wxGBPosition(9, 6),
    wxGBSpan(1, 5),
    wxALIGN_LEFT
  );
  sttResolution = new wxStaticText(
    this,
    wxID_ANY,
    sTexts[59],
    wxDefaultPosition,
    wxDefaultSize,
    wxALIGN_RIGHT
  );
  if(!(sttResolution)) {
    goto dkctGUILayoutFinished;
  }
  sSetup->Add(
    sttResolution,
    wxGBPosition(10, 0),
    wxGBSpan(1, 1),
    wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL
  );
  cobResolution = new wxChoice(
    this,
    DkWxBmeps_ResolutionType,
    wxDefaultPosition,
    wxDefaultSize,
    3,
    saResolution
  );
  if(!(cobResolution)) {
    goto dkctGUILayoutFinished;
  }
  cobResolution->SetToolTip(sTexts[94]);
  sSetup->Add(
    cobResolution,
    wxGBPosition(10, 1),
    wxGBSpan(1, 1),
    wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL
  );
  txtResolution = new wxTextCtrl(
    this,
    wxID_ANY,
    wxT("   ")
  );
  if(!(txtResolution)) {
    goto dkctGUILayoutFinished;
  }
  txtResolution->SetToolTip(sTexts[98]);
  sSetup->Add(
    txtResolution,
    wxGBPosition(10, 2),
    wxGBSpan(1, 2),
    wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL
  );
  cbInterNormal = new wxCheckBox(
    this,
    DkWxBmeps_Interpolation,
    sTexts[65]
  );
  if(!(cbInterNormal)) {
    goto dkctGUILayoutFinished;
  }
  cbInterNormal->SetToolTip(sTexts[66]);
  sSetup->Add(
    cbInterNormal,
    wxGBPosition(10, 6),
    wxGBSpan(1, 5),
    wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL
  );
  sttPaperSize = new wxStaticText(
    this,
    wxID_ANY,
    sTexts[63],
    wxDefaultPosition,
    wxDefaultSize,
    wxALIGN_RIGHT
  );
  if(!(sttPaperSize)) {
    goto dkctGUILayoutFinished;
  }
  sSetup->Add(
    sttPaperSize,
    wxGBPosition(11, 0),
    wxGBSpan(1, 1),
    wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL
  );
  cobPaperSize = new wxChoice(
    this,
    wxID_ANY,
    wxDefaultPosition,
    wxDefaultSize,
    *asPaperSizes
  );
  if(!(cobPaperSize)) {
    goto dkctGUILayoutFinished;
  }
  cobPaperSize->SetToolTip(sTexts[95]);
  sSetup->Add(
    cobPaperSize,
    wxGBPosition(11, 1),
    wxGBSpan(1, 2),
    wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL|wxGROW
  );
  cbInterJpeg = new wxCheckBox(
    this,
    wxID_ANY,
    sTexts[67]
  );
  if(!(cbInterJpeg)) {
    goto dkctGUILayoutFinished;
  }
  cbInterJpeg->SetToolTip(sTexts[68]);
  sSetup->Add(
    cbInterJpeg,
    wxGBPosition(11, 6),
    wxGBSpan(1, 5),
    wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL
  );
  sSetup->Add(1, 10, wxGBPosition(12, 0), wxGBSpan(1, 1));
  sttTransparency = new wxStaticText(
    this,
    wxID_ANY,
    sTexts[69]
  );
  if(!(sttTransparency)) {
    goto dkctGUILayoutFinished;
  }
  sSetup->Add(
    sttTransparency,
    wxGBPosition(13, 6),
    wxGBSpan(1, 5),
    wxALIGN_LEFT
  );
  sttBackground = new wxStaticText(
    this,
    wxID_ANY,
    sTexts[70],
    wxDefaultPosition,
    wxDefaultSize,
    wxALIGN_RIGHT
  );
  if(!(sttBackground)) {
    goto dkctGUILayoutFinished;
  }
  sSetup->Add(
    sttBackground,
    wxGBPosition(14, 6),
    wxGBSpan(1, 2),
    wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL
  );
  cvBackground = new DkWxColorView(
    this,wxID_ANY,pHelper,255,255,255
  );
  if(!(cvBackground)) {
    goto dkctGUILayoutFinished;
  }
  sSetup->Add(
    cvBackground,
    wxGBPosition(14, 8),
    wxGBSpan(1, 1),
    wxALIGN_CENTER_VERTICAL
  );
  cbForceBackground = new wxCheckBox(
    this,
    wxID_ANY,
    sTexts[71]
  );
  if(!(cbForceBackground)) {
    goto dkctGUILayoutFinished;
  }
  cbForceBackground->SetToolTip(sTexts[72]);
  sSetup->Add(
    cbForceBackground,
    wxGBPosition(15, 6),
    wxGBSpan(1, 5),
    wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL
  );
  verticalSizer->Add(
    sSetup
  );
  verticalSizer->Add(10, 10, 1);
  sButtons = new wxStdDialogButtonSizer(
  );
  if(!(sButtons)) {
    goto dkctGUILayoutFinished;
  }
  bOK = new wxButton(
    this,
    wxID_OK,
    sTexts[84]
  );
  if(!(bOK)) {
    goto dkctGUILayoutFinished;
  }
  bOK->SetToolTip(sTexts[85]);
  sButtons->AddButton(
    bOK
  );
  bCancel = new wxButton(
    this,
    wxID_CANCEL,
    sTexts[86]
  );
  if(!(bCancel)) {
    goto dkctGUILayoutFinished;
  }
  bCancel->SetToolTip(sTexts[87]);
  sButtons->AddButton(
    bCancel
  );
  sButtons->Realize();
  verticalSizer->Add(
    sButtons,
    0,
    wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL
  );
  verticalSizer->Add(10, 10, 1);
  sDialog->Add(
    verticalSizer,
    0,
    wxGROW
  );
  sDialog->Add(10, 10, 1);
  SetSizer(sDialog);
  dkctGUILayoutOK = true;
  dkctGUILayoutFinished:
  if(dkctGUILayoutOK) {
    sDialog->Fit(this);
    sDialog->SetSizeHints(this);
  }

#line 468 "DkWxBmepsOptionsDialog.wxc"
  cvBackground->SetToolTip(messageTexts[88]);
  sttGeneral->SetForegroundColour(cRed);
  sttOutput->SetForegroundColour(cRed);
  sttOutputDetails->SetForegroundColour(cRed);
  sttOutputSize->SetForegroundColour(cRed);
  sttInterpolation->SetForegroundColour(cRed);
  sttTransparency->SetForegroundColour(cRed);
  txtResolution->ChangeValue(sTexts[3]);
}


#line 479 "DkWxBmepsOptionsDialog.wxc"



void
DkWxBmepsOptionsDialog::OnOK(
  wxCommandEvent &	event
)
{
  

#line 488 "DkWxBmepsOptionsDialog.wxc"
  dataOut();
  if(IsModal()) {
    EndModal(wxID_OK);
  } else {
    SetReturnCode(wxID_OK);
    Show(false);
  }
  

#line 496 "DkWxBmepsOptionsDialog.wxc"
}



void
DkWxBmepsOptionsDialog::OnCancel(
  wxCommandEvent &	event
)
{
  if(IsModal()) {
    EndModal(wxID_CANCEL);
  } else {
    SetReturnCode(wxID_CANCEL);
    Show(false);
  }
}



void
DkWxBmepsOptionsDialog::dataOut()
{
  int	i;
  

#line 520 "DkWxBmepsOptionsDialog.wxc"
  /* Make mode			cbMakeMode */
  bmepsOptions->make = ((cbMakeMode->GetValue()) ? 1 : 0);
  /* Output format		cobOutputFormat */
  i = cobOutputFormat->GetSelection();
  if((i >= 0) && (i <= DK3_BMEPS_DRIVER_BB)) {
    bmepsOptions->dr = i;
  } else {
    bmepsOptions->dr = 0;
  }
  /* Output type		cobOutputType */
  i = cobOutputType->GetSelection();
  if((i >= 0) && (i <= DK3_BMEPS_MODE_DOCUMENT)) {
    bmepsOptions->mode = i;		

#line 533 "DkWxBmepsOptionsDialog.wxc"
  } else {
    bmepsOptions->mode = 0;
  }
  /* Finishing			cobFinishing */
  i = cobFinishing->GetSelection();	

#line 538 "DkWxBmepsOptionsDialog.wxc"
  switch(i) {
    case 1: {
      bmepsOptions->duplex = 1; bmepsOptions->tumble = 0;
    } break;
    case 2: {
      bmepsOptions->duplex = 1; bmepsOptions->tumble = 1;
    } break;
    default: {
      bmepsOptions->duplex = 0; bmepsOptions->tumble = 0;
    } break;
  }
  /* Draft			cbDraft */
  bmepsOptions->draft = ((cbDraft->GetValue()) ? 1 : 0);
  /* Color			cbColor */
  /* bmepsOptions->color = ((cbColor->GetValue()) ? 1 : 0); */
  /* Resolution choice		cobResolution */
#if VERSION_BEFORE_20140902
  bmepsOptions->szmode = cobResolution->GetSelection();
#else
  switch (bmepsOptions->mode) {
    case DK3_BMEPS_MODE_DOCUMENT: {
      bmepsOptions->szmode = DK3_BMEPS_SIZE_PAPER;
      

#line 561 "DkWxBmepsOptionsDialog.wxc"
    } break;
    default: {
      bmepsOptions->szmode = cobResolution->GetSelection();
      

#line 565 "DkWxBmepsOptionsDialog.wxc"
    } break;
  }
#endif
  /* Resolution value		txtResolution */
  if(bmepsOptions->szmode == DK3_BMEPS_SIZE_SPECIFIED) {
    dkChar	bu[64];
    dkChar	*ptr;
    double	v = 0.0;
    wxString resText = txtResolution->GetValue();
    wxChar const *txt = resText.c_str();
    

#line 576 "DkWxBmepsOptionsDialog.wxc"
    if(txt) {					

#line 577 "DkWxBmepsOptionsDialog.wxc"
      if(dk3wxs_to_dkstr(bu,DK3_SIZEOF(bu,dkChar),dke,txt,wxe)) {
        ptr = bu;		

#line 579 "DkWxBmepsOptionsDialog.wxc"
	while(*ptr) {
	  if(*ptr == dkT(',')) { *ptr = dkT('.'); }
	  ptr++;
	}			

#line 583 "DkWxBmepsOptionsDialog.wxc"
        if(dk3sf_scan_double_app(bu,&v,NULL)) {	

#line 584 "DkWxBmepsOptionsDialog.wxc"
	  bmepsOptions->resolution = v;		

#line 585 "DkWxBmepsOptionsDialog.wxc"
	} else {
	  bmepsOptions->resolution = 0.0;
	}
      } else {
        bmepsOptions->resolution = 0.0;
      }
    } else {
      bmepsOptions->resolution = 0.0;
    }
  } else {		

#line 595 "DkWxBmepsOptionsDialog.wxc"
    bmepsOptions->resolution = 0.0;
  }
  /* Paper size			cobPaperSize */
  if(selectedPaperSize) {
    *selectedPaperSize = (size_t)(cobPaperSize->GetSelection());
    

#line 601 "DkWxBmepsOptionsDialog.wxc"
  }
  /* PS level			cobPsLevel */
  i = cobPsLevel->GetSelection();
  bmepsOptions->psl = ((i == 1) ? 3 : 2);
  /* DSC			cbDsc */
  bmepsOptions->dsc = ((cbDsc->GetValue()) ? 1 : 0);
  /* Predictor			cobPredictor */
  bmepsOptions->pred = cobPredictor->GetSelection();
  /* DCT 			cbDCT */
  bmepsOptions->dct = ((cbDCT->GetValue()) ? 1 : 0);
  /* Bits per component		cbBpc */
  bmepsOptions->rbpc = ((cbBpc->GetValue()) ? 1 : 0);
  /* Image interpolation	cbInterNormal */
  bmepsOptions->ip = ((cbInterNormal->GetValue()) ? 1 : 0);
  /* Interpolation for JPEG	cbInterJpeg */
  bmepsOptions->jip = ((cbInterJpeg->GetValue()) ? 1 : 0);
  /* Background color		cvBackground */
  bmepsOptions->bgr = cvBackground->getRed();
  bmepsOptions->bgg = cvBackground->getGreen();
  bmepsOptions->bgb = cvBackground->getBlue();
  /* Force background color	cbForceBackground*/
  bmepsOptions->fbg = ((cbForceBackground->GetValue()) ? 1 : 0);
  (void)dk3bmeo_check(bmepsOptions, 0, bmepsOptions->app, NULL);
  

#line 625 "DkWxBmepsOptionsDialog.wxc"
}



void
DkWxBmepsOptionsDialog::dataIn()
{
  /* Make mode			cbMakeMode */
  cbMakeMode->SetValue((bmepsOptions->make) ? true : false);
  /* Output format		cobOutputFormat */
  setChoice(cobOutputFormat, bmepsOptions->dr);
  /* Output type		cobOutputType */
  setChoice(cobOutputType, bmepsOptions->mode);
  /* Finishing			cobFinishing */
  if(bmepsOptions->duplex) {
    if(bmepsOptions->tumble) {
      cobFinishing->SetSelection(2);
    } else {
      cobFinishing->SetSelection(1);
    }
  } else {
    cobFinishing->SetSelection(0);
  }
  /* Draft			cbDraft */
  cbDraft->SetValue((bmepsOptions->draft) ? true : false);
  /* Color			cbColor */
  /* cbColor->SetValue((bmepsOptions->color) ? true : false); */
  /* Resolution choice		cobResolution */
  

#line 654 "DkWxBmepsOptionsDialog.wxc"
  setChoice(cobResolution, bmepsOptions->szmode);
  /* Resolution value		txtResolution */
  if(bmepsOptions->szmode == 2) {	

#line 657 "DkWxBmepsOptionsDialog.wxc"
    txtResolution->ChangeValue(
      wxString::Format(wxT("%lg"), bmepsOptions->resolution)
    );
  } else {
    txtResolution->ChangeValue(sTexts[3]);
  }
  /* Paper size			cobPaperSize */
  if(selectedPaperSize) {
    setChoice(cobPaperSize, (int)(*selectedPaperSize));
  } else {
    cobPaperSize->SetSelection(0);
  }
  /* PS level			cobPsLevel */
  if(bmepsOptions->psl == 3) {
    cobPsLevel->SetSelection(1);
  } else {
    cobPsLevel->SetSelection(0);
  }
  /* DSC			cbDsc */
  cbDsc->SetValue((bmepsOptions->dsc) ? true : false);
  /* Predictor			cobPredictor */
  setChoice(cobPredictor, bmepsOptions->pred);
  /* DCT 			cbDCT */
  cbDCT->SetValue((bmepsOptions->dct) ? true : false);
  /* Reduce bits per component	cbBpc */
  cbBpc->SetValue((bmepsOptions->rbpc) ? true : false);
  /* Image interpolation	cbInterNormal */
  cbInterNormal->SetValue((bmepsOptions->ip) ? true : false);
  /* Interpolation for JPEG	cbInterJpeg */
  cbInterJpeg->SetValue((bmepsOptions->jip) ? true : false);
  /* Background color		cvBackground */
  cvBackground->setRGB(
    intToRange(0,255,bmepsOptions->bgr),
    intToRange(0,255,bmepsOptions->bgg),
    intToRange(0,255,bmepsOptions->bgb)
  );
  /* Force background color	cbForceBackground*/
  cbForceBackground->SetValue((bmepsOptions->fbg) ? true : false);
  correctGUI();
}



int
DkWxBmepsOptionsDialog::intToRange(int min, int max, int val)
{
  int back = val;
  if(back < min) back = min;
  if(back > max) back = max;
  return back;
}



void
DkWxBmepsOptionsDialog::setChoice(wxChoice *ch, int val)
{
  if(ch) {
    unsigned max = ch->GetCount();
    if(val == wxNOT_FOUND) {
      ch->SetSelection(val);
    } else {
      ch->SetSelection(intToRange(0, ((int)max - 1), val));
    }
  }
}



void
DkWxBmepsOptionsDialog::OnOutputFormat(wxCommandEvent & event)
{
  correctGUI();
}



void
DkWxBmepsOptionsDialog::OnOutputType(wxCommandEvent & event)
{
  correctGUI();
}



void
DkWxBmepsOptionsDialog::OnResolution(wxCommandEvent & event)
{
  correctGUI();
}



void
DkWxBmepsOptionsDialog::OnDraft(wxCommandEvent & event)
{
  correctGUI();
}



void
DkWxBmepsOptionsDialog::OnPsLevel(wxCommandEvent & event)
{
  correctGUI();
}



void
DkWxBmepsOptionsDialog::OnInterpolation(wxCommandEvent & event)
{
  correctGUI();
}



void
DkWxBmepsOptionsDialog::correctGUI()
{
  bool	doEnable;
  

#line 779 "DkWxBmepsOptionsDialog.wxc"
  if(!bIsCorrecting) {
    bIsCorrecting = true;
    /* Output type */
    if(cobOutputFormat->GetSelection() == 3) {
      cobOutputType->SetSelection(1);
      cobOutputType->Enable(false);
    } else {
      cobOutputType->Enable(true);
    }
    /* Finishing */
    if(cobOutputType->GetSelection() == 2) {
      cobFinishing->Enable(true);
    } else {
      cobFinishing->Enable(false);
    }
    /* Resolution type */
    switch(cobOutputType->GetSelection()) {
      case 0: {
        cobResolution->Enable(true);
      } break;
      case 1: {
        cobResolution->SetSelection(0);
	cobResolution->Enable(false);
      } break;
      case 2: {
        cobResolution->Enable(false);
      } break;
    }
    /* Resolution text */
    if(cobResolution->GetSelection() == 2) {
      txtResolution->Enable(true);
    } else {
      txtResolution->Enable(false);
    }
    /* Paper size */
    if(cobOutputType->GetSelection() == 2) {
      cobPaperSize->Enable(true);
    } else {
      cobPaperSize->Enable(false);
    }
    /* Draft mode */
    if(cobOutputFormat->GetSelection() == 3) {
      cbDraft->Enable(false);
    } else {
      if(cobOutputType->GetSelection() == 2) {
        cbDraft->Enable(false);
      } else {
        cbDraft->Enable(true);
      }
    }
    /* Color */
    if(cobOutputFormat->GetSelection() == 3) {
      /* cbColor->Enable(false); */
    } else {
      if(cbDraft->GetValue()) {
        /* cbColor->Enable(false); */
      } else {
        /* cbColor->Enable(true); */
      }
    }
    /* PS level and DSC */
    switch(cobOutputFormat->GetSelection()) {
      case 0: case 1: {
        cobPsLevel->Enable(true);
	cbDsc->Enable(true);
      } break;
      default: {
        cobPsLevel->Enable(false);
	cbDsc->Enable(false);
      } break;
    }
    /* Predictor */
    doEnable = false;
    switch(cobOutputFormat->GetSelection()) {
      case 0: case 1: {
        if(cobPsLevel->GetSelection() == 1) {
	  doEnable = true;
	}
      } break;
      case 2: {
        doEnable = true;
      } break;
    }
    if(cbDraft->GetValue()) { doEnable = false; }
    cobPredictor->Enable(doEnable);
    /* Re-use JPEG DCT data */
    if(cobOutputFormat->GetSelection() == 3) {
      cbDCT->Enable(false);
    } else {
      if(cbDraft->GetValue()) {
        cbDCT->Enable(false);
      } else {
        cbDCT->Enable(true);
      }
    }
    /* Normal interpolation */
    if(cobOutputFormat->GetSelection() == 3) {
      cbInterNormal->Enable(false);
    } else {
      if(cbDraft->GetValue()) {
        cbInterNormal->Enable(false);
      } else {
        cbInterNormal->Enable(true);
      }
    }
    /* Interpolation for JPEG */
    if(cobOutputFormat->GetSelection() == 3) {
      cbInterJpeg->Enable(false);
    } else {
      if(cbInterNormal->GetValue()) {
        if(cbDraft->GetValue()) {
          cbInterJpeg->Enable(false);
        } else {
          cbInterJpeg->Enable(true);
        }
      } else {
        cbInterJpeg->Enable(false);
      }
    }
    /* Force background */
    if(cobOutputFormat->GetSelection() == 3) {
      cbForceBackground->Enable(false);
    } else {
      if(cbDraft->GetValue()) {
        cbForceBackground->Enable(false);
      } else {
        cbForceBackground->Enable(true);
      }
    }
    bIsCorrecting = false;
    Refresh();
    Update();
  } 

#line 912 "DkWxBmepsOptionsDialog.wxc"
}

