/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: DkWxBmepsFrame.wxc
*/

/*
Copyright (C) 2011-2013, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file DkWxBmepsFrame.cpp The DkWxBmepsFrame module.
*/


#line 364 "DkWxBmepsFrame.wxc"



#include "wxbmeps.h"

/*
	Icons and bitmaps
*/
#include "dkicon.xpm"
#include "choose-dir.xpm"
#include "exit-program.xpm"
#include "run-conversion.xpm"
#include "set-options.xpm"




#line 380 "DkWxBmepsFrame.wxc"



/**	Start of version information.
*/
static wxChar const wxbmpp_version[] = {
  wxT("wxbmpp (part of dkt-")
};



/**	Version number for version information.
*/
static wxChar const wxbmpp_versnumber[] = {
  DKT_WXCHAR_VERSION
};



/**	End of version information.
*/
static wxChar const wxbmpp_versend[] = {
  wxT(")")
};



/**	Setting names for string settings.
*/
wxChar const * const dkwxbmeps_string_setting_names[] = {
/* 0 */
wxT("wxbmeps.directory"),

/* 1 */
wxT("wxbmeps.paper-size"),

NULL


#line 420 "DkWxBmepsFrame.wxc"
};



/**	Setting names for double settings.
*/
wxChar const * const dkwxbmeps_double_setting_names[] = {
/* 0 */
wxT("wxbmeps.area.w"),

/* 1 */
wxT("wxbmeps.area.h"),

/* 2 */
wxT("wxbmeps.area.border.left"),

/* 3 */
wxT("wxbmeps.area.border.right"),

/* 4 */
wxT("wxbmeps.area.border.top"),

/* 5 */
wxT("wxbmeps.area.border.bottom"),

/* 6 */
wxT("wxbmeps.resolution"),

NULL


#line 436 "DkWxBmepsFrame.wxc"
};



/**	Setting names for int settings.
*/
wxChar const * const dkwxbmeps_int_setting_names[] = {
/* 0 */
wxT("wxbmeps.driver"),

/* 1 */
wxT("wxbmeps.mode"),

/* 2 */
wxT("wxbmeps.size-mode"),

/* 3 */
wxT("wxbmeps.color"),

/* 4 */
wxT("wxbmeps.predictor"),

/* 5 */
wxT("wxbmeps.image-origin-point"),

/* 6 */
wxT("wxbmeps.draft"),

/* 7 */
wxT("wxbmeps.duplex"),

/* 8 */
wxT("wxbmeps.tumble"),

/* 9 */
wxT("wxbmeps.ps-level"),

/* 10 */
wxT("wxbmeps.dsc"),

/* 11 */
wxT("wxbmeps.dct"),

/* 12 */
wxT("wxbmeps.keep-aspect-ratio"),

/* 13 */
wxT("wxbmeps.bg.red"),

/* 14 */
wxT("wxbmeps.bg.green"),

/* 15 */
wxT("wxbmeps.bg.blue"),

/* 16 */
wxT("wxbmeps.bg.force"),

/* 17 */
wxT("wxbmeps.interpolation"),

/* 18 */
wxT("wxbmeps.interpolation-for-jpeg"),

/* 19 */
wxT("wxbmeps.make"),

/* 20 */
wxT("wxbmeps.reduce-bits-per-component"),

NULL


#line 466 "DkWxBmepsFrame.wxc"
};



static const wxCmdLineEntryDesc wxbmepsframe_cmd_line_desc[] = {
  {
    wxCMD_LINE_OPTION,
    wxT_2("l"),
    wxT_2("language"),
    wxT_2("Choose output language"),
    wxCMD_LINE_VAL_STRING
  },
  {
    wxCMD_LINE_SWITCH,
    wxT_2("m"),
    wxT_2("make"),
    wxT_2("Run in make mode")
  },
  {
    wxCMD_LINE_SWITCH,
    wxT_2("r"),
    wxT_2("run"),
    wxT_2("Run immediately")
  },
  {
    wxCMD_LINE_PARAM,
    NULL,
    NULL,
    wxT_2("input file"),
    wxCMD_LINE_VAL_STRING,
    wxCMD_LINE_PARAM_OPTIONAL
  },
  { wxCMD_LINE_NONE }
};


/**	Event table for the DkWxBmepsFrame class.
*/
BEGIN_EVENT_TABLE(DkWxBmepsFrame, wxFrame)
    EVT_MENU(DkWxBmeps_Quit,  DkWxBmepsFrame::OnQuit)
    EVT_MENU(DkWxBmeps_Help_Contents, DkWxBmepsFrame::OnHelpContents)
    EVT_MENU(DkWxBmeps_About, DkWxBmepsFrame::OnAbout)
    EVT_MENU(DkWxBmeps_ChooseDirectory, DkWxBmepsFrame::OnChooseDirectory)
    EVT_MENU(DkWxBmeps_SetOptions, DkWxBmepsFrame::OnSetOptions)
    EVT_MENU(DkWxBmeps_ResetOptions, DkWxBmepsFrame::OnResetOptions)
    EVT_MENU(DkWxBmeps_Run, DkWxBmepsFrame::OnRunConversion)
    EVT_IDLE(DkWxBmepsFrame::OnIdle)
END_EVENT_TABLE()




#line 518 "DkWxBmepsFrame.wxc"
DkWxBmepsFrame::DkWxBmepsFrame(
  wxChar const		*applicationName,
  wxChar const * const	*messageTexts,
  dkChar const * const	*m,
  DkWxAppHelper		*applicationHelper,
  int			 wxid,
  DkWxHelpController	*hc,
  int			 argc,
  wxChar 		**argv
) : DkWxFrame(applicationName, applicationHelper, hc, wxid)
{
#if defined(__WXMSW__)
  wxIcon	dkicon_bitmap(wxT("aaaaa"));	/* from resource file */
#else
  wxIcon	dkicon_bitmap(xpm_dkicon);	/* from included xpm */
#endif
  

#line 535 "DkWxBmepsFrame.wxc"
  ddx = -1;
  ddy = -1;
  odx = -1;
  ody = -1;
  pComm = NULL;
  timeClose = (dk3_time_t)0UL;
  bSetupChecked = false;
  sTexts = messageTexts;
  msg = m;
  bSaveSettings = true;
  bGuiActive = true;
  bCloseScheduled = false;
  bAutostartWanted = false;
  bAutostartDone = false;
  sDirectory = NULL;
  cBlack = NULL;
  cGreen = NULL;
  cRed   = NULL;
  dk3bmeo_init(&bmeo);
  bmeo.app = applicationHelper->getApp();
  dk3bmeo_apply_preferences(&bmeo);
  asPaperSizes = new wxArrayString();
  paperSizes = NULL;
  nPaperSizes = 0;
  currentPaperSize = 0;
  findPaperSizes();
  retrieveData();
  dkctGUILayoutOK = false;
  dkctGUIContentsPanel = NULL;
  mbMain = NULL;
  mainSizer = NULL;
  tbMain = NULL;
  bDir = NULL;
  bOptions = NULL;
  bRun = NULL;
  bExit = NULL;
  menuFile = NULL;
  menuHelp = NULL;
  miFileDir = NULL;
  miFileOptions = NULL;
  miFileRun = NULL;
  miFileExit = NULL;
  miHelpContents = NULL;
  miHelpAbout = NULL;
  miFileOptionsSetup = NULL;
  miFileOptionsReset = NULL;
  verticalSizer = NULL;
  contentsSizer = NULL;
  tLogmessages = NULL;
  tStatus = NULL;
  lDirectory = NULL;
  tDirectory = NULL;
  dkctGUIContentsPanel = new wxPanel(this);
  if(!(dkctGUIContentsPanel)) {
    goto dkctGUILayoutFinished;
  }
#if wxUSE_MENUS
  mbMain = new wxMenuBar(
  );
  if(!(mbMain)) {
    goto dkctGUILayoutFinished;
  }
  menuFile = new wxMenu(
  );
  if(!(menuFile)) {
    goto dkctGUILayoutFinished;
  }
  miFileDir = menuFile->Append(
    DkWxBmeps_ChooseDirectory,
    sTexts[14],
    sTexts[15]
  );
  if(!(miFileDir)) {
    goto dkctGUILayoutFinished;
  }
  miFileOptions = new wxMenu(
  );
  if(!(miFileOptions)) {
    goto dkctGUILayoutFinished;
  }
  miFileOptionsSetup = miFileOptions->Append(
    DkWxBmeps_SetOptions,
    sTexts[99],
    sTexts[100]
  );
  if(!(miFileOptionsSetup)) {
    goto dkctGUILayoutFinished;
  }
  miFileOptionsReset = miFileOptions->Append(
    DkWxBmeps_ResetOptions,
    sTexts[101],
    sTexts[102]
  );
  if(!(miFileOptionsReset)) {
    goto dkctGUILayoutFinished;
  }
  menuFile->Append(wxID_ANY, sTexts[16], miFileOptions, sTexts[17]);
  miFileRun = menuFile->Append(
    DkWxBmeps_Run,
    sTexts[18],
    sTexts[19]
  );
  if(!(miFileRun)) {
    goto dkctGUILayoutFinished;
  }
  miFileExit = menuFile->Append(
    DkWxBmeps_Quit,
    sTexts[20],
    sTexts[21]
  );
  if(!(miFileExit)) {
    goto dkctGUILayoutFinished;
  }
  mbMain->Append(menuFile, sTexts[12]);
  menuHelp = new wxMenu(
  );
  if(!(menuHelp)) {
    goto dkctGUILayoutFinished;
  }
  miHelpContents = menuHelp->Append(
    DkWxBmeps_Help_Contents,
    sTexts[22],
    sTexts[23]
  );
  if(!(miHelpContents)) {
    goto dkctGUILayoutFinished;
  }
  miHelpAbout = menuHelp->Append(
    DkWxBmeps_About,
    sTexts[24],
    sTexts[25]
  );
  if(!(miHelpAbout)) {
    goto dkctGUILayoutFinished;
  }
  mbMain->Append(menuHelp, sTexts[13]);
  SetMenuBar(mbMain);
#endif
#if wxUSE_TOOLBAR
  tbMain = new wxToolBar(
    this,
    wxID_ANY
  );
  if(!(tbMain)) {
    goto dkctGUILayoutFinished;
  }
  bDir = tbMain->AddTool(
    DkWxBmeps_ChooseDirectory,
    sTexts[4],
    xpm_choose_dir,
    wxNullBitmap,
    wxITEM_NORMAL,
    sTexts[5]
  );
  if(!(bDir)) {
    goto dkctGUILayoutFinished;
  }
  bOptions = tbMain->AddTool(
    DkWxBmeps_SetOptions,
    sTexts[6],
    xpm_set_options,
    wxNullBitmap,
    wxITEM_NORMAL,
    sTexts[7]
  );
  if(!(bOptions)) {
    goto dkctGUILayoutFinished;
  }
  bRun = tbMain->AddTool(
    DkWxBmeps_Run,
    sTexts[8],
    xpm_run_conversion,
    wxNullBitmap,
    wxITEM_NORMAL,
    sTexts[9]
  );
  if(!(bRun)) {
    goto dkctGUILayoutFinished;
  }
  bExit = tbMain->AddTool(
    DkWxBmeps_Quit,
    sTexts[10],
    xpm_exit_program,
    wxNullBitmap,
    wxITEM_NORMAL,
    sTexts[11]
  );
  if(!(bExit)) {
    goto dkctGUILayoutFinished;
  }
  tbMain->Realize();
  SetToolBar(tbMain);
#endif
  mainSizer = new wxBoxSizer(
    wxHORIZONTAL
  );
  if(!(mainSizer)) {
    goto dkctGUILayoutFinished;
  }
  mainSizer->Add(10, 10, 0);
  verticalSizer = new wxBoxSizer(
    wxVERTICAL
  );
  if(!(verticalSizer)) {
    goto dkctGUILayoutFinished;
  }
  verticalSizer->Add(10, 10, 0);
  contentsSizer = new wxGridBagSizer(
    5, 5
  );
  if(!(contentsSizer)) {
    goto dkctGUILayoutFinished;
  }
  lDirectory = new wxStaticText(
    dkctGUIContentsPanel,
    wxID_ANY,
    sTexts[26]
  );
  if(!(lDirectory)) {
    goto dkctGUILayoutFinished;
  }
  contentsSizer->Add(
    lDirectory,
    wxGBPosition(0, 0),
    wxGBSpan(1, 1),
    wxALIGN_RIGHT
  );
  tDirectory = new wxStaticText(
    dkctGUIContentsPanel,
    wxID_ANY,
    ((sDirectory) ? sDirectory : sTexts[27])
  );
  if(!(tDirectory)) {
    goto dkctGUILayoutFinished;
  }
  contentsSizer->Add(
    tDirectory,
    wxGBPosition(0, 1),
    wxGBSpan(1, 1)
  );
  verticalSizer->Add(
    contentsSizer,
    0,
    wxALIGN_LEFT
  );
  verticalSizer->Add(10, 10, 0);
  tLogmessages = new wxTextCtrl(
    dkctGUIContentsPanel,
    wxID_ANY,
    sTexts[28],
    wxDefaultPosition,
    wxSize(400, 60),
    wxTE_MULTILINE|wxTE_READONLY|wxTE_NOHIDESEL|wxTE_LEFT|wxTE_DONTWRAP
  );
  if(!(tLogmessages)) {
    goto dkctGUILayoutFinished;
  }
  verticalSizer->Add(
    tLogmessages,
    1,
    wxALIGN_LEFT|wxALIGN_TOP|wxGROW
  );
  verticalSizer->Add(10, 10, 0);
  tStatus = new wxStaticText(
    dkctGUIContentsPanel,
    wxID_ANY,
    sTexts[28]
  );
  if(!(tStatus)) {
    goto dkctGUILayoutFinished;
  }
  verticalSizer->Add(
    tStatus,
    0,
    wxALIGN_LEFT
  );
  verticalSizer->Add(10, 10, 0);
  mainSizer->Add(
    verticalSizer,
    1,
    wxGROW
  );
  mainSizer->Add(10, 10, 0);
  dkctGUIContentsPanel->SetSizer(mainSizer);
  SetIcon(dkicon_bitmap);
  dkctGUILayoutOK = true;
  dkctGUILayoutFinished:
#if wxUSE_STATUSBAR
  if(dkctGUILayoutOK) {
    CreateStatusBar(1);
    SetStatusText(sTexts[3]);
  }
#endif
  if(dkctGUILayoutOK) {
    mainSizer->Fit(this);
    mainSizer->SetSizeHints(this);
  }

#line 563 "DkWxBmepsFrame.wxc"
  pComm = new DkWxCommunicator(
    applicationHelper->getWxEncoding(),
    applicationHelper->getDkEncoding()
  );
  cBlack = new wxColour(0x00, 0x00, 0x00);
  cGreen = new wxColour(0x00, 0x7F, 0x00);
  cRed   = new wxColour(0x7F, 0x00, 0x00);
  if(argc > 1) {	/* Any option or argument, no persistent settings. */
    bSaveSettings = false;
    dk3bmeo_init(&bmeo);
#if VERSION_BEFORE_20131020
    bAutostartWanted = true;
    if(pComm) {		

#line 576 "DkWxBmepsFrame.wxc"
      pComm->autostartEnable(true);
    }
#endif
    /* ##### Process command line arguments. */
    {
      int res = -1;
      wxCmdLineParser parser(wxbmepsframe_cmd_line_desc, argc, argv);
      {
        wxLogNull log;
	res = parser.Parse(false);
      }
      if(res == 0) {
        wxString	sLanguage(wxT(""));
	dkChar		bu[1024];
	wxChar const	*ptr;
	if(parser.Found(wxT("r"))) {
	  bAutostartWanted = true;
	  if(pComm) {	

#line 594 "DkWxBmepsFrame.wxc"
	    pComm->autostartEnable(true);
	  }
	}
	if(parser.Found(wxT("m"))) {
	  bmeo.make = 1;
	}
	if(parser.Found(wxT("l"), &sLanguage)) {
	  ptr = sLanguage.c_str();
	  if(ptr) {
	    if(applicationHelper->wxToDk(bu, DK3_SIZEOF(bu,dkChar), ptr)) {
	      (void)dk3bmeo_set_language(
	        &bmeo, bu, applicationHelper->getApp()
	      );
	    }
	  }
	}
	if(parser.GetParamCount() > 0) {	

#line 611 "DkWxBmepsFrame.wxc"
	  wxString	cmdfn;
	  wxChar const	*newfn;
	  cmdfn = parser.GetParam(0);
	  wxFileName fn(cmdfn);
	  fn.Normalize(
	    wxPATH_NORM_LONG | wxPATH_NORM_DOTS
	    | wxPATH_NORM_TILDE | wxPATH_NORM_ABSOLUTE
	  );
	  if(fn.FileExists()) {
	    bAutostartWanted = true;
	    if(pComm) {	

#line 622 "DkWxBmepsFrame.wxc"
	      pComm->autostartEnable(true);
	    }
	  }
	  cmdfn = fn.GetFullPath();
	  newfn = cmdfn.c_str();
	  if(newfn) {				

#line 628 "DkWxBmepsFrame.wxc"
	    newfn = dk3wxs_dup_app(newfn, applicationHelper->getApp());
	    if(newfn) {				

#line 630 "DkWxBmepsFrame.wxc"
	      dk3_release(sDirectory);
	      sDirectory = newfn;
	    } else {				

#line 633 "DkWxBmepsFrame.wxc"
	    }
	  } else {				

#line 635 "DkWxBmepsFrame.wxc"
	  }
	} else {				

#line 637 "DkWxBmepsFrame.wxc"
	}
      }
    }
    /* (void)dk3bmeo_check(&bmeo, 0, applicationHelper->getApp(), NULL); */
  }
  

#line 643 "DkWxBmepsFrame.wxc"
  

#line 644 "DkWxBmepsFrame.wxc"
  

#line 645 "DkWxBmepsFrame.wxc"
  

#line 646 "DkWxBmepsFrame.wxc"
  

#line 647 "DkWxBmepsFrame.wxc"
  

#line 648 "DkWxBmepsFrame.wxc"
  

#line 649 "DkWxBmepsFrame.wxc"
  

#line 650 "DkWxBmepsFrame.wxc"
  

#line 651 "DkWxBmepsFrame.wxc"
  

#line 652 "DkWxBmepsFrame.wxc"
  

#line 653 "DkWxBmepsFrame.wxc"
  

#line 654 "DkWxBmepsFrame.wxc"
  

#line 655 "DkWxBmepsFrame.wxc"
  

#line 656 "DkWxBmepsFrame.wxc"
  

#line 657 "DkWxBmepsFrame.wxc"
  

#line 658 "DkWxBmepsFrame.wxc"
  

#line 659 "DkWxBmepsFrame.wxc"
  

#line 660 "DkWxBmepsFrame.wxc"
  restorePosition();
  

#line 662 "DkWxBmepsFrame.wxc"
}


#line 665 "DkWxBmepsFrame.wxc"


DkWxBmepsFrame::~DkWxBmepsFrame()
{
  

#line 670 "DkWxBmepsFrame.wxc"
  dk3_release(paperSizes);
  dk3_release(sDirectory);
  dk3_cpp_release(pComm);
  dk3_cpp_release(cBlack);
  dk3_cpp_release(cGreen);
  dk3_cpp_release(cRed);
  dk3_cpp_release(asPaperSizes);
  

#line 678 "DkWxBmepsFrame.wxc"
}



void
DkWxBmepsFrame::saveData()
{
  double d[7];
  int i[21];
  

#line 688 "DkWxBmepsFrame.wxc"
  d[0] = bmeo.ima.ps.w;
  d[1] = bmeo.ima.ps.h;
  d[2] = bmeo.ima.ps.i;
  d[3] = bmeo.ima.ps.o;
  d[4] = bmeo.ima.ps.t;
  d[5] = bmeo.ima.ps.b;
  d[6] = bmeo.resolution;
  i[0] = bmeo.dr;
  i[1] = bmeo.mode;
  i[2] = bmeo.szmode;
  /* i[3] = bmeo.color; */
  i[3] = 0;
  i[4] = bmeo.pred;
  i[5] = bmeo.io;
  i[6] = bmeo.draft;
  i[7] = bmeo.duplex;
  i[8] = bmeo.tumble;
  i[9] = bmeo.psl;
  i[10] = bmeo.dsc;
  i[11] = bmeo.dct;
  i[12] = bmeo.kar;
  i[13] = bmeo.bgr;
  i[14] = bmeo.bgg;
  i[15] = bmeo.bgb;
  i[16] = bmeo.fbg;
  i[17] = bmeo.ip;
  i[18] = bmeo.jip;
  i[19] = bmeo.make;
  i[20] = bmeo.rbpc;
  pHelper->saveMultipleDoubles(dkwxbmeps_double_setting_names, d);
  pHelper->saveMultipleInts(dkwxbmeps_int_setting_names, i);
  if(sDirectory) {
    pHelper->saveString(dkwxbmeps_string_setting_names[0], sDirectory);
  }
  pHelper->saveString(
    dkwxbmeps_string_setting_names[1],
    asPaperSizes->Item(currentPaperSize)
  );
  /* ##### */
  

#line 728 "DkWxBmepsFrame.wxc"
}



void
DkWxBmepsFrame::retrieveData()
{
  double d[7];
  int i[21];
  

#line 738 "DkWxBmepsFrame.wxc"
  d[0] = bmeo.ima.ps.w;
  d[1] = bmeo.ima.ps.h;
  d[2] = bmeo.ima.ps.i;
  d[3] = bmeo.ima.ps.o;
  d[4] = bmeo.ima.ps.t;
  d[5] = bmeo.ima.ps.b;
  d[6] = bmeo.resolution;
  i[0] = bmeo.dr;
  i[1] = bmeo.mode;
  i[2] = bmeo.szmode;
  /* i[3] = bmeo.color; */
  i[3] = 0;
  i[4] = bmeo.pred;
  i[5] = bmeo.io;
  i[6] = bmeo.draft;
  i[7] = bmeo.duplex;
  i[8] = bmeo.tumble;
  i[9] = bmeo.psl;
  i[10] = bmeo.dsc;
  i[11] = bmeo.dct;
  i[12] = bmeo.kar;
  i[13] = bmeo.bgr;
  i[14] = bmeo.bgg;
  i[15] = bmeo.bgb;
  i[16] = bmeo.fbg;
  i[17] = bmeo.ip;
  i[18] = bmeo.jip;
  i[19] = bmeo.make;
  i[20] = bmeo.rbpc;
  pHelper->retrieveMultipleDoubles(dkwxbmeps_double_setting_names, d);
  bmeo.ima.ps.w = d[0];
  bmeo.ima.ps.h = d[1];
  bmeo.ima.ps.i = d[2];
  bmeo.ima.ps.o = d[3];
  bmeo.ima.ps.t = d[4];
  bmeo.ima.ps.b = d[5];
  bmeo.resolution = d[6];
  pHelper->retrieveMultipleInts(dkwxbmeps_int_setting_names, i);
  bmeo.dr = i[0];
  bmeo.mode = i[1];
  bmeo.szmode = i[2];	

#line 779 "DkWxBmepsFrame.wxc"
  /* bmeo.color = i[3]; */
  bmeo.pred = i[4];
  bmeo.io = i[5];
  bmeo.draft = i[6];
  bmeo.duplex = i[7];
  bmeo.tumble = i[8];
  bmeo.psl = i[9];
  bmeo.dsc = i[10];
  bmeo.dct = i[11];
  bmeo.kar = i[12];
  bmeo.bgr = i[13];
  bmeo.bgg = i[14];
  bmeo.bgb = i[15];
  bmeo.fbg = i[16];
  bmeo.ip = i[17];
  bmeo.jip = i[18];
  bmeo.make = i[19];
  bmeo.rbpc = i[20];
  currentPaperSize = 0;
  sDirectory = pHelper->retrieveString(dkwxbmeps_string_setting_names[0]);
  {
    wxChar const *psn;
    int		  j;
    psn = pHelper->retrieveString(dkwxbmeps_string_setting_names[1]);
    if(psn) {
      j = asPaperSizes->Index(psn);
      if(j != wxNOT_FOUND) {
        currentPaperSize = (size_t)j;
      }
      dk3_release(psn);
    }
  }
  

#line 812 "DkWxBmepsFrame.wxc"
  /* ##### */
}



void
DkWxBmepsFrame::runConversion(void)
{
  DkWxProgressDialog	*pd = NULL;
  DkWxBmepsThread	*pt = NULL;
  

#line 823 "DkWxBmepsFrame.wxc"
  if(tStatus) {
    tStatus->SetLabel(sTexts[28]);
    if(cBlack) {
      tStatus->SetForegroundColour(*cBlack);
    }
  }
  if(pComm) {
    pComm->prepareRun();
    pd = new DkWxProgressDialog(
      (DkWxFrame *)this,
      pComm,
      tLogmessages,
      sTexts[32],	/* title */
      sTexts[28],	/* file name */
      sTexts[33],	/* button text */
      sTexts[34],	/* button tool tip */
      sTexts[35]	/* wait text */
    );
    if(pd) {
      pt = new DkWxBmepsThread(
	pComm,
	sTexts,
	msg,
	sDirectory,
	pHelper,
	pHelper->getWxEncoding(),
	pHelper->getDkEncoding(),
	&bmeo
      );
      if(pt) {
	if(pt->checkSetup()) {
	  if(pt->Create() == wxTHREAD_NO_ERROR) {
	    pt->SetPriority(WXTHREAD_DEFAULT_PRIORITY);
	    pt->Run();
	    pd->chooseModalPosition();
	    pd->ShowModal();
	    if(pComm->getLogLevel() <= DK3_LL_WARNING) {
	      bGuiActive = true;
	    }
	  } else {			

#line 863 "DkWxBmepsFrame.wxc"
	    delete(pt);
	    /* ##### ERROR: Failed to create new thread! */
	  }
	} else {
	  /* ##### ERROR: Memory! */
	  delete(pt);
	}
      } else {				

#line 871 "DkWxBmepsFrame.wxc"
        /* ##### ERROR: Failed to construct new thread! */
      }
      pd->Destroy();
    } else {				

#line 875 "DkWxBmepsFrame.wxc"
      /* ##### ERROR: Failed to create progress dialog! */
    }
  } else {				

#line 878 "DkWxBmepsFrame.wxc"
    /* ##### ERROR: Setup incomplete! */
  }
  

#line 881 "DkWxBmepsFrame.wxc"
}



void
DkWxBmepsFrame::OnIdle(wxIdleEvent & event)
{
  dk3_time_t	ct;	/* Current time. */
  

#line 890 "DkWxBmepsFrame.wxc"
  if(!bCloseScheduled) {
    if(!bSetupChecked) {
      bSetupChecked = true;
      if(!checkSetup()) {
        bCloseScheduled = true;
	/* ##### Show message: Failed to initialize! */
	Show(false);
	Close();
      }
    }
    if(!bCloseScheduled) {			

#line 901 "DkWxBmepsFrame.wxc"
      if(pComm->autostartCanRun()) {		

#line 902 "DkWxBmepsFrame.wxc"
        runConversion();
      } else {					

#line 904 "DkWxBmepsFrame.wxc"
        if(pComm->autostartIsFinished()) {	

#line 905 "DkWxBmepsFrame.wxc"
	  if(!(timeClose)) {
	    if(pComm->getLogLevel() > DK3_LL_WARNING) {
	      dk3sf_time(&timeClose);
	      event.RequestMore();
	      tStatus->SetLabel(sTexts[30]);
	      if((cGreen) && (cBlack)) {
	        tStatus->SetForegroundColour(*cGreen);
	      }
	      Refresh();
	      Update();
	    }
	  }
	}
      }
      if(timeClose) {
        dk3sf_time(&ct);
        if(ct > (timeClose + (dk3_time_t)1UL)) {
          timeClose = (dk3_time_t)0UL;
	  bCloseScheduled = true;
	  Show(false);
	  Close();
        } else {
          event.RequestMore();
        }
      }
    }
  }
  

#line 933 "DkWxBmepsFrame.wxc"
}



void
DkWxBmepsFrame::OnChooseDirectory(wxCommandEvent& WXUNUSED(event))
{
  wxChar const	*ptr;
  wxChar const	*np;
  

#line 943 "DkWxBmepsFrame.wxc"
  if(isGuiActive()) {
    wxDirDialog dd(
      this, sTexts[29],
      ((sDirectory) ? sDirectory : wxEmptyString),
      (wxDD_DIR_MUST_EXIST | wxDD_CHANGE_DIR)
    );
    pHelper->setRelatedPosition(this, &dd, &ddx, &ddy);
    if(dd.ShowModal() == wxID_OK) {
      wxString path = dd.GetPath();
      ptr = path.c_str();
      if(ptr) {
        np = dk3wxs_dup_app(ptr, pHelper->getApp());
	if(np) {
	  dk3_release(sDirectory);
	  sDirectory = np;
	  if(tDirectory) {
	    tDirectory->SetLabel(sDirectory);
	    Refresh();
	    Update();
	  }
	}
      }
    }
    dd.GetPosition(&ddx, &ddy);
  } 

#line 968 "DkWxBmepsFrame.wxc"
}



void
DkWxBmepsFrame::OnRunConversion(wxCommandEvent& WXUNUSED(event))
{
  

#line 976 "DkWxBmepsFrame.wxc"
  if(isGuiActive()) {
    runConversion();
  }
  

#line 980 "DkWxBmepsFrame.wxc"
}



bool
DkWxBmepsFrame::isGuiActive()
{
  bool back;
  back = bGuiActive;
  

#line 990 "DkWxBmepsFrame.wxc"
  if(bCloseScheduled) { back = false; }
  

#line 992 "DkWxBmepsFrame.wxc"
  return back;
}



bool
DkWxBmepsFrame::canClose(bool isLast)
{
  

#line 1001 "DkWxBmepsFrame.wxc"
  if(isLast) {
    if(bSaveSettings) {
      saveData();
    }
  } 

#line 1006 "DkWxBmepsFrame.wxc"
  return true;
}



void
DkWxBmepsFrame::OnQuit(wxCommandEvent& WXUNUSED(event))
{
  

#line 1015 "DkWxBmepsFrame.wxc"
  if(isGuiActive()) {
    bCloseScheduled = true;
    Show(false);
    Close();
  }
  

#line 1021 "DkWxBmepsFrame.wxc"
}



bool
DkWxBmepsFrame::checkSetup()
{
  bool back = false;
  if(pComm) {
    if((cBlack) && (cGreen) && (cRed)) {
      if((asPaperSizes) && (paperSizes)) {
        back = true;
      }
    }
  }
  return back;
}



void
DkWxBmepsFrame::OnSetOptions(wxCommandEvent& WXUNUSED(event))
{
  int		dke;
  int		wxe;
  

#line 1047 "DkWxBmepsFrame.wxc"
  dke = pHelper->getDkEncoding();
  wxe = pHelper->getWxEncoding();
  if(isGuiActive()) {
    DkWxBmepsOptionsDialog dlg(
      (DkWxBmepsFrame *)this, sTexts[36], sTexts, asPaperSizes,
      &bmeo, paperSizes, &currentPaperSize, pHelper, dke, wxe
    );
    pHelper->setRelatedPosition(this, &dlg, &odx, &ody);
    dlg.dataIn();
    if(dlg.ShowModal() == wxID_OK) {
      dk3mem_cpy(
        (void *)(&(bmeo.ima.ps)),
	(void *)(&(paperSizes[currentPaperSize])),
	sizeof(dk3_paper_size_t)
      );
      

#line 1063 "DkWxBmepsFrame.wxc"
    }
    dlg.GetPosition(&odx, &ody);
  }
  

#line 1067 "DkWxBmepsFrame.wxc"
}



void
DkWxBmepsFrame::OnResetOptions(wxCommandEvent& WXUNUSED(event))
{
  int	res;
  res = wxMessageBox(
    sTexts[103],
    sTexts[104],
    wxNO_DEFAULT|wxYES_NO
  );
  if(res == wxYES) {
    dk3bmeo_init(&bmeo);
  }
}



void
DkWxBmepsFrame::findPaperSizes()
{
  wxChar			 bu[64];
  dk3_paper_size_collection_t	*psc;
  dk3_named_paper_size_t const	*nsz;
  dk3_paper_size_t		*pps;
  dk3_app_t			*app;
  

#line 1096 "DkWxBmepsFrame.wxc"
  if(asPaperSizes) {				

#line 1097 "DkWxBmepsFrame.wxc"
    app = pHelper->getApp();
    psc = dk3paper_open_app(app);
    if(psc) {					

#line 1100 "DkWxBmepsFrame.wxc"
      dk3paper_reset(psc);
      while((nsz = dk3paper_next(psc)) != NULL) {
        if(nsz->name) {
	  if(pHelper->dkToWx(bu, DK3_SIZEOF(bu,wxChar), nsz->name)) {
	    

#line 1105 "DkWxBmepsFrame.wxc"
	    asPaperSizes->Add(bu);
	    nPaperSizes++;
	  }
	}
      }
      if(nPaperSizes) {		

#line 1111 "DkWxBmepsFrame.wxc"
        paperSizes = dk3_new_app(dk3_paper_size_t,nPaperSizes,app);
	if(paperSizes) {			

#line 1113 "DkWxBmepsFrame.wxc"
	  pps = paperSizes;
	  dk3paper_reset(psc);
	  while((nsz = dk3paper_next(psc)) != NULL) {
	    if(nsz->name) {
	      if(pHelper->dkToWx(bu, DK3_SIZEOF(bu,wxChar), nsz->name))
	      {				

#line 1119 "DkWxBmepsFrame.wxc"
	        dk3mem_cpy(
		  (void *)pps,
		  (void *)(&(nsz->size)),
		  sizeof(dk3_paper_size_t)
		);
		pps++;
	      }
	    }
	  }
	}
      }
      dk3paper_close(psc);
    }
  }
  

#line 1134 "DkWxBmepsFrame.wxc"
}



void
DkWxBmepsFrame::OnHelpContents(wxCommandEvent& WXUNUSED(event))
{
  openHelp();
}



void
DkWxBmepsFrame::OnAbout(wxCommandEvent& WXUNUSED(event)) 
{
  if(isGuiActive()) {
    wxString sVersion(wxbmpp_version);
    sVersion.Append(wxbmpp_versnumber);
    sVersion.Append(wxbmpp_versend);
    sVersion.Append(wxT("\nCopyright (c) 2013 - Dirk Krause\n\n"));
    sVersion.Append(sTexts[123]);
    sVersion.Append(wxT("DK tools, wxWidgets, libpng, libjpeg, libtiff, zlib."));
    sVersion.Append(wxT("\n\n"));
    sVersion.Append(sTexts[124]);
    sVersion.Append(wxT("http://dktools.sourceforge.net\n"));
    sVersion.Append(wxT("http://www.wxwidgets.org\n"));
    sVersion.Append(wxT("http://www.libpng.org/pub/png/libpng.html\n"));
    sVersion.Append(wxT("http://www.ijg.org\n"));
    sVersion.Append(wxT("http://www.remotesensing.org/libtiff\n"));
    sVersion.Append(wxT("http://www.zlib.org"));
    wxMessageBox(sVersion, sTexts[122]);
  }
}

