/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: DkWxAppHelper.cpt
*/

/*
Copyright (C) 2011, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file DkWxAppHelper.h Header file for the DkWxAppHelper module.
*/

#ifndef DKWXAPPHELPER_H_INCLUDED
/** Avoid multiple inclusions. */
#define DKWXAPPHELPER_H_INCLUDED 1


#line 10 "DkWxAppHelper.cpt"

#if 0
#include <dk3all.h>
#else
#include <dk3conf.h>
#include <dk3types.h>
#include <dk3const.h>
#endif



#include <wx/wxprec.h>
#ifdef __BORLANDC__
#pragma hdrstop
#endif
#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif
#include <wx/config.h>
#include <wx/filename.h>

/**	Application helper class, provides file search, internationalization
	and some functions for GUI development using the wxWidgets libraries.
*/
class DkWxAppHelper
{
  protected:

    /**	Application structure.
    */
    dk3_app_t		*app;

    /**	Storage for string tables.
    */
    dk3_sto_t		*sStringTables;

    /**	Iterator through string tables storage.
    */
    dk3_sto_it_t	*iStringTables;

    /**	Basic strings used by wxWidgets applications.
    */
    wxChar const * const	*basicStrings;

    /**	First command line argument.
    */
    wxChar const	*cmdName;

    /**	Application name.
    */
    wxChar const	*appName;

    /**	Software vendor name.
    */
    wxChar const	*vendorName;

    /**	Encoding for dkChar.
    */
    int			dkEncoding;

    /**	Encoding for wxChar.
    */
    int			wxEncoding;

    /**	Number of entries in the basicStrings array.
    */
    size_t		nBasicStrings;
  
  public:

    /**	Constructor.
    	@param	arg0		First command line argument.
	@param	vName		Software vendor name.
	@param	groupName	Application group name.
    */
    DkWxAppHelper(
      wxChar const	*arg0,
      wxChar const	*vName,
      dkChar const	*groupName
    );

    /**	Destructor.
    */
    ~DkWxAppHelper();

    /**	Check whether application helper object is set up correctly
    	and is ready to use.
    	@return	1 on success, 0 on error.
    */
    int
    checkSetup() const;

    /**	Retrieve array of localized texts.
    	@param	dt	Default texts, used if problems occur.
	@param	tn	Table name.
	@return	Pointer to localized messages array or dt.
    */
    wxChar const * const *
    getStringTable(
      wxChar const * const	*dt,
      dkChar const		*tn
    );

    /**	Find data file name. Provide a short file name like "x.y",
    	on success the program writes a full path like
	"/usr/share/myapp/en/x.y" to the result buffer.
    	@param	fn	Short file name.
	@param	fnb	Buffer for full path name.
	@param	szfnb	Size of @arg fnb (number of wxChar).
	@return	1 on success, 0 on error.
    */
    int
    findDataFile(wxChar const *fn, wxChar *fnb, size_t szfnb);

    /**	Retrieve multiple int settings at once.
    	@param	names	Pointer to names array, must be terminated
			by a NULL pointer.
	@param	values	Pointer to destination value array.
	@return	Number of items read successfully.
    */
    size_t
    retrieveMultipleInts(
      wxChar const * const	*names,
      int			*values
    ) const;

    /**	Retrieve multiple long settings at once.
    	@param	names	Pointer to names array, must be terminated
			by a NULL pointer.
	@param	values	Pointer to destination value array.
	@return	Number of items read successfully.
    */
    size_t
    retrieveMultipleLongs(
      wxChar const * const	*names,
      long			*values
    ) const;

    /**	Save multiple int settings at once.
    	@param	names	Pointer to names array, must be terminated by
			a NULL pointer.
	@param	values	Pointer to values array.
	@return	Number of items successfully written.
    */
    size_t
    saveMultipleInts(
      wxChar const * const	*names,
      int			*values
    ) const;

    /**	Save multiple long settings at once.
    	@param	names	Pointer to names array, must be terminated by
			a NULL pointer.
	@param	values	Pointer to values array.
	@return	Number of items successfully written.
    */
    size_t
    saveMultipleLongs(
      wxChar const * const	*names,
      long			*values
    ) const;

    /**	Retrieve multiple double settings at once.
    	@param	names	Pointer to names array, must be terminated by
			a NULL pointer.
	@param	values	Pointer to values array.
	@return	Number of items successfully read.
    */
    size_t
    retrieveMultipleDoubles(
      wxChar const * const	*names,
      double			*values
    ) const;

    /**	Save multiple doubles at once.
    	@param	names	Pointer to names array, must be terminated by
			a NULL pointer.
	@param	values	Pointer to values array.
	@return	Number of items successfully written.
    */
    size_t
    saveMultipleDoubles(
      wxChar const * const	*names,
      double			*values
    ) const;

    /**	Retrieve a string preference.
    	@param	name	Preference name.
	@return	Pointer to new string on success, NULL on error.
    */
    wxChar const *
    retrieveString(
      wxChar const		*name
    ) const;

    /**	Save a string entry.
    	@param	name	Entry name.
	@param	value	Entry value.
	@return	1 on success, 0 on error.
    */
    int
    saveString(
      wxChar const		*name,
      wxChar const		*value
    ) const;

    /**	Retrieve encoding for wxChar.
    	@return	Encoding used for wxChar.
    */
    int
    getWxEncoding() const;

    /**	Retrieve encoding for dkChar.
    	@return	Encoding used for dkChar.
    */
    int
    getDkEncoding() const;

    /**	Retrieve encoding to use for 8 bit characters.
    	@return	Encoding to use for 8 bit character strings.
    */
    int
    getC8Encoding() const;

    /**	Retrieve application structure.
    	@return	Application structure on success, NULL on error.
    */
    dk3_app_t *
    getApp() const;

    /**	Get one of the basic application strings.
    	@param	i	Index of string in array.
	@return	String pointer on success or NULL on error.
    */
    wxChar const *
    getBasicString(size_t i) const;

    /**	Get basic strings array.
    	@return	Array pointer to basic strings.
    */
    wxChar const * const *
    getBasicStrings() const;

    /**	Find number of basic strings stored in the \a basicStrings array.
    	@return	Number of strings in the array.
    */
    size_t
    getBasicStringNumbers() const;

    /**	Convert wxChar string to dkChar string.
    	@param	bu	Destination buffer.
	@param	sz	Destination buffer size (number of dkChar).
	@param	src	Source buffer.
	@return	true on success, false on error.
    */
    bool
    wxToDk(dkChar *bu, size_t sz, wxChar const *src) const;

    /**	Convert wxChar string to 8-bit char string.
    	@param	bu	Destination buffer.
	@param	sz	Destination buffer size.
	@param	src	Source buffer.
	@return	true on success, false on error.
    */
    bool
    wxToC8(char *bu, size_t sz, wxChar const *src) const;

    /**	Convert wxChar string to 8-bit char string.
    	@param	bu	Destination buffer.
	@param	sz	Destination buffer size.
	@param	str	Source string.
	@return	true on success, false on error.
    */
    bool
    wxToC8(char *bu, size_t sz, wxString & str) const;

    /**	Convert dkChar string to wxChar string.
    	@param	bu	Destination buffer.
	@param	sz	Destination buffer size (number of wxChar).
	@param	src	Source buffer.
	@return	true on success, false on error.
    */
    bool
    dkToWx(wxChar *bu, size_t sz, dkChar const *src) const;

    /**	Set related position (child over parent), the child
    	is either placed on a known previous position or placed
	centered on top of the parent.
    	@param	parent	Parent top level window (frame).
	@param	child	Child top level window (dialog).
	@param	pcx	Pointer to previous child x position.
	@param	pcy	Pointer to previous child y position.
    */
    void
    setRelatedPosition(
      wxWindow	*parent,
      wxWindow	*child,
      int	*pcx = NULL,
      int	*pcy = NULL
    ) const;

};




#endif
