/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: DkWxAppHelper.cpt
*/

/*
Copyright (C) 2011, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file DkWxAppHelper.cpp The DkWxAppHelper module.
*/


#line 316 "DkWxAppHelper.cpt"


#include <dk3all.h>
#include "DkWxAppHelper.h"


#include "dk3wxs.h"





#line 327 "DkWxAppHelper.cpt"



/**	Basic texts issued by wxWidgets applications.
*/
static wxChar const * const dkwxapphelper_defwxappstr[] = {
/* 0 */
wxT("Error worse than Panic"),

/* 1 */
wxT("Panic"),

/* 2 */
wxT("Fatal error"),

/* 3 */
wxT("Error"),

/* 4 */
wxT("Warning"),

/* 5 */
wxT("Information"),

/* 6 */
wxT("Progress"),

/* 7 */
wxT("Debug"),

/* 8 */
wxT("Ignore"),

/* 9 */
wxT("Not enough memory!"),

/* 10 */
wxT("Help file not found!"),

NULL


#line 379 "DkWxAppHelper.cpt"
};



/**	String table file containing localized versions of the
	texts in \a dkwxapphelper_defwxappstr.
*/
static dkChar const dkwxapphelper_sttname[] = { dkT("dkwx.str") };



/**	Storage entry for wxChar string table.
*/
typedef struct {
  wxChar const	**array;	/**< String table contents. */
  dkChar const	 *name;		/**< String table name. */
  size_t	  nelem;	/**< Number of elements. */
} DkAppHelperWxStringTable;



/**	Pointer to constant wxChar string.
*/
typedef wxChar const	*wxConstPtr;


/**	Compare two string table entries.
	@param	l	Left entry.
	@param	r	Right entry.
	@param	cr	Comparison criteria (0=entry/entry, 1=entr/name).
	@return	Comparison result.
*/
static
int
dkwxah_string_table_compare(void const *l, void const *r, int cr)
{
  int back = 0;
  DkAppHelperWxStringTable const	*pl;
  DkAppHelperWxStringTable const	*pr;
  if(l) {
    if(r) {
      pl = (DkAppHelperWxStringTable const *)l;
      pr = (DkAppHelperWxStringTable const *)r;
      switch(cr) {
        case 1: {
	  if(pl->name) {
	    back = dk3str_cmp(pl->name, (dkChar const *)r);
	  } else { back = -1; }
	} break;
	default: {
	  if(pl->name) {
	    if(pr->name) {
	      back = dk3str_cmp(pl->name, pr->name);
	    } else { back = 1;}
	  } else {
	    if(pr->name) { back = -1; }
	  }
	} break;
      }
    } else { back = 1; }
  } else {
    if(r) { back = -1; }
  }
  if(back < -1) { back = -1; }
  if(back >  1) { back =  1; }
  return back;
}



/**	Close string table.
	@param	p	String table to close.
*/
static
void
dkwxah_string_table_close(DkAppHelperWxStringTable *p)
{
  wxChar const	**ptr;
  size_t	 i;
  

#line 459 "DkWxAppHelper.cpt"
  if(p) {
    if(p->array) {
      if(p->nelem) {	

#line 462 "DkWxAppHelper.cpt"
        ptr = p->array;
	for(i = 0; i < p->nelem; i++) {
	  if(*ptr) {	

#line 465 "DkWxAppHelper.cpt"
	  }
	  dk3_release(*ptr);
	  ptr++;
	}
      }
      dk3_delete(p->array);
    }
    dk3_release(p->name);
    dk3_delete(p);
  } 

#line 475 "DkWxAppHelper.cpt"
}




#if DK3_ON_WINDOWS || DK3_HAVE_BACKSLASH
/**	Separator character for file names.
*/
#define	SEP	wxT('\\')
#else
/**	Separator character for file names.
*/
#define	SEP	wxT('/')
#endif



/**	Non-localized keywords, 8-bit characters.
*/
static char const * const dkwxapphelper_c8_kw[] = {
/*  0 */	"UTF-8",
/*  1 */	"utf8",
NULL
};



DkWxAppHelper::DkWxAppHelper(
  wxChar const	*arg0,
  wxChar const	*vName,
  dkChar const	*groupName
)
{
  dkChar	dkcb[DK3_MAX_PATH];
  dkChar	*newargv[2];
  wxChar	*ptr;
  wxChar const	*cptr;
  wxChar const * const *ptrGetNumBasicStrings;
  

#line 514 "DkWxAppHelper.cpt"
  app = NULL;
  sStringTables = NULL;
  iStringTables = NULL;
  basicStrings	= NULL;
  nBasicStrings	= 0;
  cmdName	= NULL;
  appName	= NULL;
  vendorName	= NULL;
  dkEncoding = DK3_ENCODING_PLAIN;
  wxEncoding = DK3_ENCODING_PLAIN;
  if(DK3_CHAR_SIZE > 1) {
    if(DK3_CHAR_SIZE > 2) {
      dkEncoding = DK3_ENCODING_UNICODE;
    } else {
      dkEncoding = DK3_ENCODING_UTF16;
    }
  } else {
    /* dkChar is 1 byte. */
#if DK3_ON_WINDOWS
#else
    char *ptr;
    ptr = getenv("LANG");
    if(ptr) {
      ptr = dk3str_c8_chr(ptr, '.');
      if(ptr) {
        ptr++;
	if(dk3str_c8_casecmp(dkwxapphelper_c8_kw[0], ptr) == 0) {
	  dkEncoding = DK3_ENCODING_UTF8;
	} else {
	  if(dk3str_c8_casecmp(dkwxapphelper_c8_kw[1], ptr) == 0) {
	    dkEncoding = DK3_ENCODING_UTF8;
	  }
	}
      }
    }
#endif
  }
  if(sizeof(wxChar) > 1) {
    if(sizeof(wxChar) > 2) {
      wxEncoding = DK3_ENCODING_UNICODE;
    } else {
      wxEncoding = DK3_ENCODING_UTF16;
    }
  } else {
#if DK3_ON_WINDOWS
#else
    char *ptr;
    ptr = getenv("LANG");
    if(ptr) {
      ptr = dk3str_c8_chr(ptr, '.');
      if(ptr) {
        ptr++;
	if(dk3str_c8_casecmp(dkwxapphelper_c8_kw[0], ptr) == 0) {
	  wxEncoding = DK3_ENCODING_UTF8;
	} else {
	  if(dk3str_c8_casecmp(dkwxapphelper_c8_kw[1], ptr) == 0) {
	    wxEncoding = DK3_ENCODING_UTF8;
	  }
	}
      }
    }
#endif
  }
  if(dk3wxs_to_dkstr(dkcb,DK3_SIZEOF(dkcb,dkChar),dkEncoding,arg0,wxEncoding))
  {
    newargv[0] = dkcb,
    newargv[1] = 0;
    app = dk3app_open_gui(1, newargv, groupName);
    if(app) {
      sStringTables = dk3sto_open_app(app);
      if(sStringTables) {
        dk3sto_set_comp(sStringTables, dkwxah_string_table_compare, 0);
        iStringTables = dk3sto_it_open(sStringTables);
	if(iStringTables) {
	}
      }
    }
  }
  cmdName = dk3wxs_dup_app(arg0, app);
  if(cmdName) {
    cptr = dk3wxs_rchr(cmdName, SEP);
    if(cptr) {
      cptr++;
    } else {
      cptr = cmdName;
    }
    appName = dk3wxs_dup_app(cptr, app);
    if(appName) {
      ptr = dk3wxs_rchr(appName, '.');
      if(ptr) { *ptr = wxT('\0'); }
    }
  }
  vendorName = dk3wxs_dup_app(vName, app);
  /*
  	Finally retrieve the basic application strings.
  */
  ptrGetNumBasicStrings = dkwxapphelper_defwxappstr;
  while(*(ptrGetNumBasicStrings++)) { nBasicStrings++; }
  basicStrings = getStringTable(
    dkwxapphelper_defwxappstr,
    dkwxapphelper_sttname
  );
  

#line 617 "DkWxAppHelper.cpt"
}



DkWxAppHelper::~DkWxAppHelper()
{
  

#line 624 "DkWxAppHelper.cpt"
  DkAppHelperWxStringTable	*e;
  basicStrings = NULL;
  if(sStringTables) {
    if(iStringTables) {
      dk3sto_it_reset(iStringTables);
      do {
        e = (DkAppHelperWxStringTable *)dk3sto_it_next(iStringTables);
	if(e) {
	  dkwxah_string_table_close(e);
	}
      } while(e != NULL);
      dk3sto_it_close(iStringTables);
    }
    dk3sto_close(sStringTables);
  } sStringTables = NULL; iStringTables = NULL;
  if(app) {
    dk3app_close(app); app = NULL;
  }
  dk3_release(cmdName);
  dk3_release(appName);
  dk3_release(vendorName);
  

#line 646 "DkWxAppHelper.cpt"
}



int
DkWxAppHelper::checkSetup() const
{
  int back = 0;
  

#line 655 "DkWxAppHelper.cpt"
  if(app) {			

#line 656 "DkWxAppHelper.cpt"
    if(sStringTables) {		

#line 657 "DkWxAppHelper.cpt"
      if(iStringTables) {	

#line 658 "DkWxAppHelper.cpt"
        if(cmdName) {		

#line 659 "DkWxAppHelper.cpt"
	  if(appName) {		

#line 660 "DkWxAppHelper.cpt"
	    if(vendorName) {	

#line 661 "DkWxAppHelper.cpt"
              back = 1;
	    } else {		

#line 663 "DkWxAppHelper.cpt"
	    }
	  } else {		

#line 665 "DkWxAppHelper.cpt"
	  }
	} else {		

#line 667 "DkWxAppHelper.cpt"
	}
      } else {			

#line 669 "DkWxAppHelper.cpt"
      }
    } else {			

#line 671 "DkWxAppHelper.cpt"
    }
  } else {			

#line 673 "DkWxAppHelper.cpt"
  } 

#line 674 "DkWxAppHelper.cpt"
  return back;
}



wxChar const * const *
DkWxAppHelper::getStringTable(
      wxChar const * const	*dt,
      dkChar const		*tn
)
{
#if 0
  wxChar const * const		*back	= NULL;
  wxChar const * 		*wxptr;
  DkAppHelperWxStringTable	*tp	= NULL;
  FILE				*fipo	= NULL;
  dkChar const			*oldsource	= NULL;
#if 0
  dkChar			dkb[4096];
#endif
  dkChar			fnb[DK3_MAX_PATH];
  wxChar			wxb[4096];
  char				il[4096];
  unsigned long			lineno	= 0UL;
  unsigned long			oldline	= 0UL;
  size_t			nelem	= 0;
  size_t			i	= 0;
  int				cc	= 1;
  int				ok	= 0;

  

#line 705 "DkWxAppHelper.cpt"
  if((dt) && (tn)) {				

#line 706 "DkWxAppHelper.cpt"
    if(checkSetup()) {				

#line 707 "DkWxAppHelper.cpt"
      tp = (DkAppHelperWxStringTable *)dk3sto_it_find_like(
        iStringTables, (void *)tn, 1
      );
      if(!(tp)) {				

#line 711 "DkWxAppHelper.cpt"
        if(dk3app_find_data_file(app, tn, fnb, DK3_SIZEOF(fnb,dkChar))) { 

#line 712 "DkWxAppHelper.cpt"
	  fipo = dk3sf_fopen_app(fnb, dk3app_not_localized(22), app);
	  if(fipo) {				

#line 714 "DkWxAppHelper.cpt"
	    wxptr = (wxChar const **)dt; nelem = 0;
	    while(*(wxptr++)) { nelem++; }
	    if(nelem) {		

#line 717 "DkWxAppHelper.cpt"
	      tp = dk3_new_app(DkAppHelperWxStringTable,1,app);
	      if(tp) {		

#line 719 "DkWxAppHelper.cpt"
	        ok = 0;
		tp->array = NULL;
		tp->nelem = nelem;
		tp->name = dk3str_dup_app(tn, app);
		if(tp->name) {	

#line 724 "DkWxAppHelper.cpt"
		  tp->array = dk3_new_app(wxConstPtr,nelem,app);
		  if(tp->array) {	

#line 726 "DkWxAppHelper.cpt"
		    wxptr = tp->array;
		    tp->nelem = nelem;
		    for(i = 0; i < nelem; i++) { *(wxptr++) = NULL; }
		    if(dk3sto_add(sStringTables, (void *)tp)) {	

#line 730 "DkWxAppHelper.cpt"
		      ok = 1;
		      oldsource = dk3app_get_source_file(app);
		      oldline   = dk3app_get_source_line(app);
		      dk3app_set_source_file(app, fnb);
		      dk3app_set_source_line(app, 0UL);
		      lineno = 0UL;
		      wxptr = tp->array; nelem = 0;
		      do {			

#line 738 "DkWxAppHelper.cpt"
		        cc = 0;
			if(fgets(il, sizeof(il), fipo)) {	

#line 740 "DkWxAppHelper.cpt"
			  dk3app_set_source_line(app, ++lineno);
			  cc = 1;
			  if(il[0] != '#') {		

#line 743 "DkWxAppHelper.cpt"
			    dk3app_squeeze_line(il);
			    if(dk3wxs_from_utf8(wxb,DK3_SIZEOF(wxb,wxChar),il))
			    {
			      *wxptr = dk3wxs_dup_app(wxb, app);
			      if(!(*wxptr)) {	

#line 748 "DkWxAppHelper.cpt"
			        ok = 0;
			      }
			      wxptr++;
			    }
			    else
			    {
			      ok = 0;		

#line 755 "DkWxAppHelper.cpt"
			    }
			  } else {		

#line 757 "DkWxAppHelper.cpt"
			  }
			  if(nelem >= tp->nelem) { cc = 0; }
			} else {		

#line 760 "DkWxAppHelper.cpt"
			}
		      } while((cc) && (ok));
		      if(nelem < tp->nelem) {
		        ok = 0;
		      }
		      dk3app_set_source_file(app, oldsource);
		      dk3app_set_source_line(app, oldline);
		    } else {		

#line 768 "DkWxAppHelper.cpt"
		    }
		  } else {		

#line 770 "DkWxAppHelper.cpt"
		  }
		} else {		

#line 772 "DkWxAppHelper.cpt"
		}
		if(ok) {
		  back = (wxChar const * const *)(tp->array);
		} else {
		  dkwxah_string_table_close(tp);
		}
	      } else {			

#line 779 "DkWxAppHelper.cpt"
	      }
	    } else {			

#line 781 "DkWxAppHelper.cpt"
	    }
	    fclose(fipo);
	  } else {			

#line 784 "DkWxAppHelper.cpt"
	  }
	} else {			

#line 786 "DkWxAppHelper.cpt"
	}
      } else {				

#line 788 "DkWxAppHelper.cpt"
      }
      if(tp) {				

#line 790 "DkWxAppHelper.cpt"
        back = (wxChar const * const *)(tp->array);
      }
    } else {				

#line 793 "DkWxAppHelper.cpt"
    }
  } else {				

#line 795 "DkWxAppHelper.cpt"
  }
  if(!(back)) {
    back = dt;
  } 

#line 799 "DkWxAppHelper.cpt"
#else
  dkChar			 fnb[DK3_MAX_PATH];	/* Full file name. */ 
  char				 il[4096];	/* Input line */
  wxChar			 wxb[sizeof(il)];
  wxChar const * const		*back = NULL;
  DkAppHelperWxStringTable	*tp;	/* String table if exists. */
  wxChar const * 		*wxptr;	/* Traverse dt array. */
  FILE				*fipo;	/* Read input file. */
  unsigned long			 lineno;	/* Current line. */
  size_t			 nelem;	/* Number of elements in dt. */
  size_t			 i;	/* Current string to process. */
  int				 res;	/* Search result. */
  int				 cc;	/* Flag: Can continue. */
  int				 ok;	/* Flag: All strings read succes. */
  

#line 814 "DkWxAppHelper.cpt"
  if((dt) && (tn)) {			

#line 815 "DkWxAppHelper.cpt"
    if(checkSetup()) {			

#line 816 "DkWxAppHelper.cpt"
      tp = (DkAppHelperWxStringTable *)dk3sto_it_find_like(
        iStringTables, (void *)tn, 1
      );
      if(!(tp)) {			

#line 820 "DkWxAppHelper.cpt"
        res = dk3app_find_data_file(app,tn,fnb,DK3_SIZEOF(fnb,dkChar));
	

#line 822 "DkWxAppHelper.cpt"
	if(res) {			

#line 823 "DkWxAppHelper.cpt"
	  fipo = dk3sf_fopen_app(fnb, dk3app_not_localized(22), app);
	  if(fipo) {			

#line 825 "DkWxAppHelper.cpt"
	    wxptr = (wxChar const **)dt; nelem = 0;
	    while(*(wxptr++)) { nelem++; }
	    if(nelem) {
	      tp = dk3_new_app(DkAppHelperWxStringTable,1,app);
	      if(tp) {
	        tp->array = NULL;
		tp->nelem = nelem;
		tp->name = NULL;
		tp->name = dk3str_dup_app(tn, app);
		if(tp->name) {
		  tp->array = dk3_new_app(wxConstPtr,nelem,app);
		  if(tp->array) {
		    wxptr = tp->array;
		    tp->nelem = nelem;
		    for(i = 0; i < nelem; i++) { *(wxptr++) = NULL; }
		    wxptr = tp->array; nelem = 0; lineno = 0UL; cc = 1; ok = 1;
		    do {
		      cc = 0;
		      if(fgets(il, sizeof(il), fipo)) {
		        cc = 1;				

#line 845 "DkWxAppHelper.cpt"
			if(il[0] != '#') {		

#line 846 "DkWxAppHelper.cpt"
			  dk3app_squeeze_line(il);
			  if(dk3wxs_from_utf8(wxb,DK3_SIZEOF(wxb,wxChar),il)) {
			    *wxptr = dk3wxs_dup_app(wxb, app);
			    if(*wxptr) {
			      nelem++;
			      if(nelem >= tp->nelem) {
			        cc = 0;
			      }
			    } else {
			      ok = 0; cc = 0;
			    }
			    wxptr++;
			  } else {		

#line 859 "DkWxAppHelper.cpt"
			    ok = 0; cc = 0;
			  }
			} else {		

#line 862 "DkWxAppHelper.cpt"
			}
		      }
		    } while(cc);
		    if(nelem < tp->nelem) {
		      ok = 0;			

#line 867 "DkWxAppHelper.cpt"
		    }
		    if(ok) {				

#line 869 "DkWxAppHelper.cpt"
		      if(!dk3sto_add(sStringTables, (void *)tp)) {
		        dkwxah_string_table_close(tp);	

#line 871 "DkWxAppHelper.cpt"
			tp = NULL;
		      }
		    } else {				

#line 874 "DkWxAppHelper.cpt"
		      dkwxah_string_table_close(tp);
		      tp = NULL;
		    }
		  } else {
		    dkwxah_string_table_close(tp);
		    tp = NULL;
		  }
		} else {
		  dkwxah_string_table_close(tp);
		  tp = NULL;
		}
	      } else {			

#line 886 "DkWxAppHelper.cpt"
	      }
	    }
	    fclose(fipo);
	  } else {			

#line 890 "DkWxAppHelper.cpt"
	  }
	} else {			

#line 892 "DkWxAppHelper.cpt"
	}
      }
      if(tp) {				

#line 895 "DkWxAppHelper.cpt"
        back = (wxChar const * const *)(tp->array);
      }
    } else {				

#line 898 "DkWxAppHelper.cpt"
    }
  } else {				

#line 900 "DkWxAppHelper.cpt"
  }
  if(!(back)) {				

#line 902 "DkWxAppHelper.cpt"
    back = dt;
  } 

#line 904 "DkWxAppHelper.cpt"
#endif
  return back;
}


size_t
DkWxAppHelper::retrieveMultipleInts(
      wxChar const * const	*names,
      int			*values
) const
{
  size_t		back = 0;
  wxChar const * const	*nptr;
  int			*vptr;
  long			 l;
  

#line 920 "DkWxAppHelper.cpt"
  if((appName) && (vendorName) && (names) && (values)) {
    wxConfig *conf = new wxConfig(appName, vendorName);
    if(conf) {
      nptr = names; vptr = values;
      while(*nptr) {
        l = 0L;
	if(conf->Read(*nptr, &l)) {
	  *vptr = (int)l;
	  back++;
	}
	nptr++; vptr++;
      }
      delete(conf);
    }
  } 

#line 935 "DkWxAppHelper.cpt"
  return back;
}



size_t
DkWxAppHelper::retrieveMultipleLongs(
	wxChar const * const	*names,
	long			*values
) const
{
  size_t		 back = 0;
  wxChar const * const	*nptr;
  long			*vptr;
  long			 l;
  

#line 951 "DkWxAppHelper.cpt"
  if((appName) && (vendorName) && (names) && (values)) {
    wxConfig *conf = new wxConfig(appName, vendorName);
    if(conf) {
      nptr = names; vptr = values;
      while(*nptr) {
        l = 0L;
	if(conf->Read(*nptr, &l)) {
	  *vptr = l;
	  back++;
	}
        nptr++; vptr++;
      }
      delete(conf);
    }
  }
  

#line 967 "DkWxAppHelper.cpt"
  return back;
}


size_t
DkWxAppHelper::retrieveMultipleDoubles(
      wxChar const * const	*names,
      double			*values
) const
{
  size_t		 back	= 0;
  double		 d;
  wxChar const * const	*nptr;
  double		*vptr;
  

#line 982 "DkWxAppHelper.cpt"
  if((appName) && (vendorName) && (names) && (values)) {
    wxConfig *conf = new wxConfig(appName,  vendorName);
    if(conf) {
      nptr = names; vptr = values;
      while(*nptr) {
        d = 0.0;
	if(conf->Read(*nptr, &d)) {
	  *vptr = d;
	  back++;
	}
	nptr++; vptr++;
      }
      delete(conf);
    }
  } 

#line 997 "DkWxAppHelper.cpt"
  return back;
}


size_t
DkWxAppHelper::saveMultipleInts(
      wxChar const * const	*names,
      int			*values
) const
{
  size_t		back = 0;
  wxChar const * const	*nptr;
  int			*vptr;
  long			l;
  

#line 1012 "DkWxAppHelper.cpt"
  if((appName) && (vendorName) && (names) && (values)) {
    wxConfig *conf = new wxConfig(appName, vendorName);
    if(conf) {				

#line 1015 "DkWxAppHelper.cpt"
      nptr = names; vptr = values;
      while(*nptr) {			

#line 1017 "DkWxAppHelper.cpt"
        l = (long)(*vptr);
	if(conf->Write(*nptr, l)) {
	  back++;
	}
	nptr++; vptr++;
      }
      delete(conf);
    }
  } 

#line 1026 "DkWxAppHelper.cpt"
  return back;
}



size_t
DkWxAppHelper::saveMultipleLongs(
	wxChar const * const	*names,
	long			*values
) const
{
  size_t		 back = 0;
  wxChar const * const	*nptr;
  long			*vptr;
  long			 l;
  

#line 1042 "DkWxAppHelper.cpt"
  if((appName) && (vendorName) && (names) && (values)) {
    wxConfig *conf = new wxConfig(appName, vendorName);
    if(conf) {
      nptr = names; vptr = values;
      while(*nptr) {
        l = *vptr;
	if(conf->Write(*nptr, l)) {
	  back++;
	}
	nptr++; vptr++;
      }
      delete(conf);
    }
  }
  

#line 1057 "DkWxAppHelper.cpt"
  return back;
}



size_t
DkWxAppHelper::saveMultipleDoubles(
	wxChar const * const	*names,
	double			*values
) const
{
  size_t		 back	= 0;
  double		 d;
  wxChar const * const	*nptr;
  double		*vptr;
  

#line 1073 "DkWxAppHelper.cpt"
  if((appName) && (vendorName) && (names) && (values)) {
    wxConfig *conf = new wxConfig(appName, vendorName);
    if(conf) {
      nptr = names; vptr = values;
      while(*nptr) {
        d = *vptr;
	if(conf->Write(*nptr, d)) {
	  back++;
	}
        nptr++; vptr++;
      }
      delete(conf);
    }
  } 

#line 1087 "DkWxAppHelper.cpt"
  return back;
}



wxChar const *
DkWxAppHelper::retrieveString(
  wxChar const		*name
) const
{
  wxChar const		*back = NULL;
  wxChar const		*ptr;
  

#line 1100 "DkWxAppHelper.cpt"
  if((name) && (appName) && (vendorName)) {
    wxConfig *conf = new wxConfig(appName, vendorName);
    if(conf) {
      wxString str;
      if(conf->Read(name, &str)) {
        ptr = str.c_str();
	if(ptr) {
	  back = dk3wxs_dup_app(ptr, app);
	}
      }
      delete(conf);
    }
  } 

#line 1113 "DkWxAppHelper.cpt"
  return back;
}



int
DkWxAppHelper::saveString(
  wxChar const		*name,
  wxChar const		*value
) const
{
  int			back = 0;
  

#line 1126 "DkWxAppHelper.cpt"
  if((name) && (value) && (appName) && (vendorName)) {
    wxConfig *conf = new wxConfig(appName, vendorName);
    if(conf) {
      conf->Write(name, value);
      delete(conf);
    }
  } 

#line 1133 "DkWxAppHelper.cpt"
  return back;
}



int
DkWxAppHelper::getWxEncoding() const
{
  

#line 1142 "DkWxAppHelper.cpt"
  return wxEncoding;
}



int
DkWxAppHelper::getDkEncoding() const
{
  

#line 1151 "DkWxAppHelper.cpt"
  return dkEncoding;
}



int
DkWxAppHelper::getC8Encoding() const
{
  int		back;
  

#line 1161 "DkWxAppHelper.cpt"
  back = dkEncoding;
  if(DK3_ENCODING_UTF8 != back) {
    back = DK3_ENCODING_PLAIN;
  } 

#line 1165 "DkWxAppHelper.cpt"
  return back;
}



dk3_app_t *
DkWxAppHelper::getApp() const
{
  

#line 1174 "DkWxAppHelper.cpt"
  return app;
}



int
DkWxAppHelper::findDataFile(wxChar const *fn, wxChar *fnb, size_t szfnb)
{
  dkChar	shnDk[DK3_MAX_PATH];
  dkChar	ffnDk[DK3_MAX_PATH];
  int		back = 0;
  

#line 1186 "DkWxAppHelper.cpt"
  if((fn) && (fnb) && (szfnb)) {	

#line 1187 "DkWxAppHelper.cpt"
    if(checkSetup()) {			

#line 1188 "DkWxAppHelper.cpt"
      if(dk3wxs_to_dkstr(
           shnDk, DK3_SIZEOF(shnDk,dkChar), dkEncoding, fn, wxEncoding
         )
        )
      {
        if(app) {			

#line 1194 "DkWxAppHelper.cpt"
	  if(dk3app_find_data_file(app,shnDk,ffnDk,DK3_SIZEOF(ffnDk,dkChar))) {
	    if(dk3wxs_from_dkstr(fnb, szfnb, wxEncoding, ffnDk, dkEncoding)) {
	      back = 1;			

#line 1197 "DkWxAppHelper.cpt"
	    } else {			

#line 1198 "DkWxAppHelper.cpt"
	    }
	  } else {			

#line 1200 "DkWxAppHelper.cpt"
	  }
	} else {			

#line 1202 "DkWxAppHelper.cpt"
	}
      } else {				

#line 1204 "DkWxAppHelper.cpt"
      }
    }
  } 

#line 1207 "DkWxAppHelper.cpt"
  return back;
}



wxChar const *
DkWxAppHelper::getBasicString(size_t i) const
{
  wxChar const		*back	= NULL;
  

#line 1217 "DkWxAppHelper.cpt"
  if(basicStrings) {
    if(i < nBasicStrings) {
      back = basicStrings[i];
    }
  } 

#line 1222 "DkWxAppHelper.cpt"
  return back;
}



wxChar const * const *
DkWxAppHelper::getBasicStrings() const
{
  

#line 1231 "DkWxAppHelper.cpt"
  return basicStrings;
}

    
    
size_t
DkWxAppHelper::getBasicStringNumbers() const
{
  

#line 1240 "DkWxAppHelper.cpt"
  return nBasicStrings;
}



bool
DkWxAppHelper::wxToDk(dkChar *bu, size_t sz, wxChar const *src) const
{
  bool		back	= false;
  

#line 1250 "DkWxAppHelper.cpt"
  if((bu) && (sz) && (src)) {
    if(dk3wxs_to_dkstr(bu, sz, dkEncoding, src, wxEncoding)) {
      back = true;
    }
  } 

#line 1255 "DkWxAppHelper.cpt"
  return back;
}



bool
DkWxAppHelper::wxToC8(char *bu, size_t sz, wxChar const *src) const
{
  bool		back	= false;
  

#line 1265 "DkWxAppHelper.cpt"
  if((bu) && (sz) && (src)) {
    if(dk3wxs_to_c8(bu, sz, getC8Encoding(), src, wxEncoding)) {
      back = true;
    }
  } 

#line 1270 "DkWxAppHelper.cpt"
  return back;
}



bool
DkWxAppHelper::wxToC8(char *bu, size_t sz, wxString & str) const
{
  bool		 back = false;
  wxChar const	*ptr;
  

#line 1281 "DkWxAppHelper.cpt"
  if((bu) && (sz)) {
    ptr = str.c_str();
    if(ptr) {
      back = wxToC8(bu, sz, ptr);
    }
  } 

#line 1287 "DkWxAppHelper.cpt"
  return back;
}



bool
DkWxAppHelper::dkToWx(wxChar *bu, size_t sz, dkChar const *src) const
{
  bool		back	= false;
  

#line 1297 "DkWxAppHelper.cpt"
  if((bu) && (sz) && (src)) {
    if(dk3wxs_from_dkstr(bu, sz, wxEncoding, src, dkEncoding)) {
      back = true;
    }
  } 

#line 1302 "DkWxAppHelper.cpt"
  return back;
}


void
DkWxAppHelper::setRelatedPosition(
  wxWindow	*parent,
  wxWindow	*child,
  int		*pcx,
  int		*pcy
) const
{
  int		px	=	0;	/* Parent x position. */
  int		py	=	0;	/* Parent y position. */
  int		pw	=	0;	/* Parent width. */
  int		ph	=	0;	/* Parent height. */
  int		cx	=	0;	/* Child x position. */
  int		cy	=	0;	/* Child y position. */
  int		cw	=	0;	/* Child width. */
  int		ch	=	0;	/* Child height. */
  wxSize	scsz;			/* Screen size. */

  scsz = wxGetDisplaySize();
  parent->GetPosition(&px, &py);
  parent->GetSize(&pw, &ph);
  child->GetSize(&cw, &ch);
  cx = px + (pw - cw) / 2;
  cy = py + (ph - ch) / 2;
  if((cx + cw) > scsz.x) {
    cx = scsz.x - cw;
  }
  if((cy + ch) > scsz.y) {
    cy = scsz.y - ch;
  }
  if(cx < 0) {
    cx = 0;
  }
  if(cy < 0) {
    cy = 0;
  }
  if((pcx) && (pcy)) {
    if(((*pcx) >= 0) && ((*pcy) >= 0)) {
      cx = *pcx;
      cy = *pcy;
    }
  }
  child->SetSize(cx, cy, cw, ch);
}


