/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: DkClockView.cpt
*/

/*
Copyright (C) 2013, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file DkClockView.h Header file for the DkClockView module.
*/

#ifndef DKCLOCKVIEW_H_INCLUDED
/** Avoid multiple inclusions. */
#define DKCLOCKVIEW_H_INCLUDED 1


#line 10 "DkClockView.cpt"

class DkClockView : public DkWxBufferedControl
{
  private:

    DECLARE_DYNAMIC_CLASS(DkClockView)

    /**	Event table.
    */
    DECLARE_EVENT_TABLE()

  protected:

    /**	Black colour for normal mode.
    */
    wxColour		 cBlack;

    /**	Red colour for alert mode.
    */
    wxColour		 cRed;

    /**	Clock data to show.
    */
    DkClockData		*cld;

    /**	Widget type name.
    */
    static wxChar const	 windowtypename[];

    /**	Flag: Use red colour instead of black.
    */
    bool		 bUseRed;

  public:

    /**	Default constructor.
    */
    DkClockView();

    /**	Constructor.
    	@param		wParent		Parent window.
	@param		wid		Window ID.
	@param		clockData	Clock data to show.
	@param		pos		Window position.
	@param		size		Window size.
	@param		style		Window style.
    */
    DkClockView(
      wxWindow		*wParent,
      wxWindowID	 wid,
      DkClockData	*clockData,
      const wxPoint &	 pos = wxDefaultPosition,
      const wxSize  &	 size = wxDefaultSize,
      long		 style = 0L
    );

    /**	Create window after using the default constructor.
    	@param		wParent		Parent window.
	@param		wid		Window ID.
	@param		clockData	Clock data to show.
	@param		pos		Window position.
	@param		size		Window size.
	@param		style		Window style.
	@return		true on success, false on error.
    */
    bool
    Create(
      wxWindow		*wParent,
      wxWindowID	 wid,
      DkClockData	*clockData,
      const wxPoint &	 pos = wxDefaultPosition,
      const wxSize  &	 size = wxDefaultSize,
      long		 style = 0L
    );

    /**	Draw operation.
    	@param	pdc		Device context to draw to.
	@param	event		Event to process.
	@param	buffered	Flag: Drawing into bitmap buffer.
	@param	clWidth		Client area width.
	@param	clHeight	Client area height.
    */
    void
    PaintOperation(
      wxDC &		pdc,
      wxPaintEvent &	event,
      bool		buffered,
      int		clWidth,
      int		clHeight
    );

    /**	Handler for mouse click.
    	@param	event	Event to process.
    */
    void
    OnLeftDown(wxMouseEvent & event);

    /**	Get red component of normal clock colour.
    	@return	Red value.
    */
    int
    getNormalRed(void) const;

    /**	Get green component of normal clock colour.
    	@return	Green value.
    */
    int
    getNormalGreen(void) const;

    /**	Get blue component of normal clock colour.
    	@return	Blue value.
    */
    int
    getNormalBlue(void) const;

    /**	Get red component of alert clock colour.
    	@return	Red value.
    */
    int
    getAlertRed(void) const;

    /**	Get green component of alert clock colour.
    	@return	Green value.
    */
    int
    getAlertGreen(void) const;

    /**	Get blue component of alert clock colour.
    	@return	Blue value.
    */
    int
    getAlertBlue(void) const;

    /**	Set normal colour.
    	@param	r	Red value.
	@param	g	Green value.
	@param	b	Blue value.
    */
    void
    setNormal(int r, int g, int b);

    /**	Set alert colour.
    	@param	r	Red value.
	@param	g	Green value.
	@param	b	Blue value.
    */
    void
    setAlert(int r, int g, int b);
};


#endif
